      SUBROUTINE READ_STA ( FILSTA, MP, BUF, M_STA, LC_STA, CC_STA, &
     &                      COO_STA, MJD_REF, TAI_REF, IUER )
! ************************************************************************
! *                                                                      *
! *   Soubroutine READ_STA reads the station coordinates from the file   *
! *   generated by getpar program. Units: meters.                        *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 20-MAY-2002    READ_STA   v3.0 (d)  L. Petrov  10-MAR-2023 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INTEGER*4  MP, M_STA, LC_STA, MJD_REF, IUER
      CHARACTER  FILSTA*(*), BUF(MP)*(*), CC_STA(M_STA)*(*)
      REAL*8     COO_STA(3,M_STA), TAI_REF
      INTEGER*4  MIND
      PARAMETER  ( MIND = 128 )
      INTEGER*4  NBUF, IFMT, J1, J2, LIND, IND(2,MIND), IER
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      MJD_REF = -2147483647
      TAI_REF = -1.D30
!
      CALL ERR_PASS ( IUER, IER )
      CALL RD_TEXT  ( FILSTA, MP, BUF, NBUF, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 3221, IUER, 'READ_STA', 'Error in reading '// &
     &         'STA-file '//FILSTA )
           RETURN
      END IF
      IF ( BUF(1) == '# GETPAR_STA format version 1.0  of 2001.05.25' ) THEN
           IFMT = 1
         ELSE IF ( BUF(1) == '# GETPAR_STA format version 1.1  of 2023.03.11' ) THEN
           IFMT = 2
         ELSE IF ( BUF(1) == '$$  SIT-MODFILE Format 2001.09.26' ) THEN
           IFMT = 3
         ELSE
           CALL ERR_LOG ( 3222, IUER, 'READ_STA', 'Unsupported format '// &
     &         'of STA-file '//FILSTA )
           RETURN
      END IF
!
      LC_STA = 0
      IF ( IFMT == 1 .OR. IFMT == 2 ) THEN
           DO 410 J1=1,NBUF
              IF ( BUF(J1)(1:26) == '# Position reference date:' ) THEN
                   CALL ERR_PASS ( IUER, IER )
                   CALL DATE_TO_TIME ( BUF(J1)(28:46), MJD_REF, TAI_REF, IER )
                   IF ( IER .NE. 0 ) THEN
                        CALL ERR_LOG ( 3223, IUER, 'READ_STA', 'Failure in '// &
     &                      'decoding station position epoch from line '// &
     &                       TRIM(BUF(J1))//' of the station position '// &
     &                      'file '//FILSTA )
                        RETURN 
                   END IF
              END IF
              IF ( BUF(J1)(1:1) .EQ. 'W'   ) GOTO 410
              IF ( ILEN(BUF(J1)) .LE.  0   ) GOTO 410
              IF ( BUF(J1)(28:28) .NE. 'X' ) GOTO 410
!
              LC_STA = LC_STA + 1
              CC_STA(LC_STA) = BUF(J1)(11:25)
              READ ( UNIT=BUF(J1)(31:45),  FMT='(F15.5)' ) COO_STA(1,LC_STA)
              READ ( UNIT=BUF(J1)(65:79),  FMT='(F15.5)' ) COO_STA(2,LC_STA)
              READ ( UNIT=BUF(J1)(99:113), FMT='(F15.5)' ) COO_STA(3,LC_STA)
              COO_STA(1,LC_STA) = COO_STA(1,LC_STA)*0.001D0
              COO_STA(2,LC_STA) = COO_STA(2,LC_STA)*0.001D0
              COO_STA(3,LC_STA) = COO_STA(3,LC_STA)*0.001D0
 410       CONTINUE
        ELSE IF ( IFMT == 3 ) THEN
           DO 420 J2=1,NBUF
              CALL EXWORD ( BUF(J2), MIND, LIND, IND, CHAR(32)//CHAR(9), IER )
              IF ( BUF(J2)(1:1)  .EQ. '$' .AND. LIND .GE. 3 ) THEN
                   IF ( BUF(J2)(IND(1,2):IND(2,2)) == 'EPOCH' ) THEN
                        CALL ERR_PASS ( IUER, IER )
                        CALL DATE_TO_TIME ( BUF(J2)(IND(1,3):IND(2,3)), &
     &                                      MJD_REF, TAI_REF, IER )
                        IF ( IER .NE. 0 ) THEN
                             CALL ERR_LOG ( 3224, IUER, 'READ_STA', 'Failure in '// &
     &                           'decoding station position epoch from line '// &
     &                            TRIM(BUF(J2))//' of the station position '// &
     &                           'file '//FILSTA )
                             RETURN 
                        END IF
                   END IF
              END IF
!              
              IF ( BUF(J2)(1:1)  .EQ. '$' ) GOTO 420
              IF ( ILEN(BUF(J2)) .LE.  0  ) GOTO 420
!
              LC_STA = LC_STA + 1
              CC_STA(LC_STA) = BUF(J2)(5:12)
              READ ( UNIT=BUF(J2)(15:27),  FMT='(F13.4)' ) COO_STA(1,LC_STA)
              READ ( UNIT=BUF(J2)(31:43),  FMT='(F13.4)' ) COO_STA(2,LC_STA)
              READ ( UNIT=BUF(J2)(47:59),  FMT='(F13.4)' ) COO_STA(3,LC_STA)
 420       CONTINUE
      END IF
!
      IF ( MJD_REF == -2147483647 ) THEN
           CALL ERR_LOG ( 3225, IUER, 'READ_STA', 'Did not find reference '// &
     &                   'date in the station position file '//FILSTA )
           RETURN
      END IF
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  READ_STA  !#!#
