      SUBROUTINE READ_VEL ( FILVEL, MP, BUF, M_STA, LV_STA, CV_STA, VEL_STA, &
     &                      IUER )
! ************************************************************************
! *                                                                      *
! *   Subroutine READ_VEL reads station velocities from the file         *
! *   generated by getpar program. Units: meter/year                     *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 20-MAY-2002    READ_VEL   v2.0 (d)  L. Petrov  20-OCT-2021 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INTEGER*4  MP, M_STA, LV_STA, IUER
      CHARACTER  FILVEL*(*), BUF(MP)*(*), CV_STA(M_STA)*(*)
      REAL*8     VEL_STA(3,M_STA)
      INTEGER*4  NBUF, IFMT, J1, J2, IER
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      CALL ERR_PASS ( IUER, IER )
      CALL RD_TEXT  ( FILVEL, MP, BUF, NBUF, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 3231, IUER, 'READ_VEL', 'Error in reading '// &
     &         'STA-file '//FILVEL(1:I_LEN(FILVEL)) )
           RETURN
      END IF
      IF ( BUF(1) == '# GETPAR_VEL format version 1.1  of 2023.03.11' ) THEN
           IFMT = 1
         ELSE IF ( BUF(1) == '$$  VEL-MODFILE Format 2001.09.26' ) THEN
           IFMT = 2
         ELSE IF ( BUF(2) == '$$  VEL-MODFILE Format 2001.09.26' ) THEN
           IFMT = 2
         ELSE
           CALL ERR_LOG ( 3232, IUER, 'READ_STA', 'Unsupported format '// &
     &         'of VEL-file '//FILVEL )
           RETURN
      END IF
!
      LV_STA = 0
      IF ( IFMT == 1 ) THEN
           DO 410 J1=1,NBUF
              IF ( BUF(J1)(1:1)  .EQ.  '#' ) GOTO 410
              IF ( ILEN(BUF(J1)) .LE.   0  ) GOTO 410
              IF ( BUF(J1)(21:21) .NE. 'X' ) GOTO 410
!
              LV_STA = LV_STA + 1
              CV_STA(LV_STA) = BUF(J1)(11:25)
              READ ( UNIT=BUF(J1)(24:32), FMT='(F9.4)' ) VEL_STA(1,LV_STA)
              READ ( UNIT=BUF(J1)(50:58), FMT='(F9.4)' ) VEL_STA(2,LV_STA)
              READ ( UNIT=BUF(J1)(76:84), FMT='(F9.4)' ) VEL_STA(3,LV_STA)
              VEL_STA(1,LV_STA) = VEL_STA(1,LV_STA)*0.001D0
              VEL_STA(2,LV_STA) = VEL_STA(2,LV_STA)*0.001D0
              VEL_STA(3,LV_STA) = VEL_STA(3,LV_STA)*0.001D0
 410       CONTINUE
        ELSE IF ( IFMT == 2 ) THEN
           DO 420 J2=2,NBUF
              IF ( BUF(J2)(1:1)  .EQ.  '$' ) GOTO 420
              IF ( ILEN(BUF(J2)) .LE.   0  ) GOTO 420
!
              LV_STA = LV_STA + 1
              CV_STA(LV_STA) = BUF(J2)(5:12)
              READ ( UNIT=BUF(J2)(20:28), FMT='(F9.2)' ) VEL_STA(1,LV_STA)
              READ ( UNIT=BUF(J2)(36:44), FMT='(F9.2)' ) VEL_STA(2,LV_STA)
              READ ( UNIT=BUF(J2)(52:60), FMT='(F9.3)' ) VEL_STA(3,LV_STA)
              VEL_STA(1,LV_STA) = VEL_STA(1,LV_STA)*0.001D0
              VEL_STA(2,LV_STA) = VEL_STA(2,LV_STA)*0.001D0
              VEL_STA(3,LV_STA) = VEL_STA(3,LV_STA)*0.001D0
 420       CONTINUE
      END IF
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  !#!  READ_VEL  #!#
