#include <mk5_preprocessor_directives.inc>
      SUBROUTINE MUL_MM_SS_I_13 ( A, B, C )
! ************************************************************************
! *                                                                      *
! *   Compute a product of two square symmetric matrices in upper        *
! *   triangular representation.                                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.12.12 ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), B(*), C( 13, 13)
!
      C( 1 , 1 ) = A( 1 ) * B( 1 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 2 ) * B( 2 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 4 ) * B( 4 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 7 ) * B( 7 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 11 ) * B( 11 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 16 ) * B( 16 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 22 ) * B( 22 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 29 ) * B( 29 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 37 ) * B( 37 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 46 ) * B( 46 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 56 ) * B( 56 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 67 ) * B( 67 )
      C( 1 , 1 ) = C( 1 , 1 ) + A( 79 ) * B( 79 )
!
      C( 1 , 2 ) = A( 1 ) * B( 2 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 2 ) * B( 3 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 4 ) * B( 5 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 7 ) * B( 8 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 11 ) * B( 12 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 16 ) * B( 17 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 22 ) * B( 23 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 29 ) * B( 30 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 37 ) * B( 38 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 46 ) * B( 47 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 56 ) * B( 57 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 67 ) * B( 68 )
      C( 1 , 2 ) = C( 1 , 2 ) + A( 79 ) * B( 80 )
!
      C( 1 , 3 ) = A( 1 ) * B( 4 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 2 ) * B( 5 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 4 ) * B( 6 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 7 ) * B( 9 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 11 ) * B( 13 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 16 ) * B( 18 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 22 ) * B( 24 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 29 ) * B( 31 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 37 ) * B( 39 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 46 ) * B( 48 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 56 ) * B( 58 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 67 ) * B( 69 )
      C( 1 , 3 ) = C( 1 , 3 ) + A( 79 ) * B( 81 )
!
      C( 1 , 4 ) = A( 1 ) * B( 7 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 2 ) * B( 8 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 4 ) * B( 9 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 7 ) * B( 10 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 11 ) * B( 14 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 16 ) * B( 19 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 22 ) * B( 25 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 29 ) * B( 32 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 37 ) * B( 40 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 46 ) * B( 49 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 56 ) * B( 59 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 67 ) * B( 70 )
      C( 1 , 4 ) = C( 1 , 4 ) + A( 79 ) * B( 82 )
!
      C( 1 , 5 ) = A( 1 ) * B( 11 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 2 ) * B( 12 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 4 ) * B( 13 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 7 ) * B( 14 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 11 ) * B( 15 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 16 ) * B( 20 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 22 ) * B( 26 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 29 ) * B( 33 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 37 ) * B( 41 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 46 ) * B( 50 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 56 ) * B( 60 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 67 ) * B( 71 )
      C( 1 , 5 ) = C( 1 , 5 ) + A( 79 ) * B( 83 )
!
      C( 1 , 6 ) = A( 1 ) * B( 16 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 2 ) * B( 17 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 4 ) * B( 18 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 7 ) * B( 19 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 11 ) * B( 20 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 16 ) * B( 21 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 22 ) * B( 27 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 29 ) * B( 34 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 37 ) * B( 42 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 46 ) * B( 51 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 56 ) * B( 61 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 67 ) * B( 72 )
      C( 1 , 6 ) = C( 1 , 6 ) + A( 79 ) * B( 84 )
!
      C( 1 , 7 ) = A( 1 ) * B( 22 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 2 ) * B( 23 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 4 ) * B( 24 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 7 ) * B( 25 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 11 ) * B( 26 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 16 ) * B( 27 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 22 ) * B( 28 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 29 ) * B( 35 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 37 ) * B( 43 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 46 ) * B( 52 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 56 ) * B( 62 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 67 ) * B( 73 )
      C( 1 , 7 ) = C( 1 , 7 ) + A( 79 ) * B( 85 )
!
      C( 1 , 8 ) = A( 1 ) * B( 29 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 2 ) * B( 30 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 4 ) * B( 31 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 7 ) * B( 32 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 11 ) * B( 33 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 16 ) * B( 34 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 22 ) * B( 35 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 29 ) * B( 36 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 37 ) * B( 44 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 46 ) * B( 53 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 56 ) * B( 63 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 67 ) * B( 74 )
      C( 1 , 8 ) = C( 1 , 8 ) + A( 79 ) * B( 86 )
!
      C( 1 , 9 ) = A( 1 ) * B( 37 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 2 ) * B( 38 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 4 ) * B( 39 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 7 ) * B( 40 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 11 ) * B( 41 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 16 ) * B( 42 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 22 ) * B( 43 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 29 ) * B( 44 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 37 ) * B( 45 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 46 ) * B( 54 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 56 ) * B( 64 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 67 ) * B( 75 )
      C( 1 , 9 ) = C( 1 , 9 ) + A( 79 ) * B( 87 )
!
      C( 1 , 10 ) = A( 1 ) * B( 46 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 2 ) * B( 47 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 4 ) * B( 48 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 7 ) * B( 49 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 11 ) * B( 50 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 16 ) * B( 51 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 22 ) * B( 52 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 29 ) * B( 53 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 37 ) * B( 54 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 46 ) * B( 55 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 56 ) * B( 65 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 67 ) * B( 76 )
      C( 1 , 10 ) = C( 1 , 10 ) + A( 79 ) * B( 88 )
!
      C( 1 , 11 ) = A( 1 ) * B( 56 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 2 ) * B( 57 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 4 ) * B( 58 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 7 ) * B( 59 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 11 ) * B( 60 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 16 ) * B( 61 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 22 ) * B( 62 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 29 ) * B( 63 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 37 ) * B( 64 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 46 ) * B( 65 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 56 ) * B( 66 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 67 ) * B( 77 )
      C( 1 , 11 ) = C( 1 , 11 ) + A( 79 ) * B( 89 )
!
      C( 1 , 12 ) = A( 1 ) * B( 67 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 2 ) * B( 68 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 4 ) * B( 69 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 7 ) * B( 70 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 11 ) * B( 71 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 16 ) * B( 72 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 22 ) * B( 73 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 29 ) * B( 74 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 37 ) * B( 75 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 46 ) * B( 76 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 56 ) * B( 77 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 67 ) * B( 78 )
      C( 1 , 12 ) = C( 1 , 12 ) + A( 79 ) * B( 90 )
!
      C( 1 , 13 ) = A( 1 ) * B( 79 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 2 ) * B( 80 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 4 ) * B( 81 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 7 ) * B( 82 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 11 ) * B( 83 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 16 ) * B( 84 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 22 ) * B( 85 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 29 ) * B( 86 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 37 ) * B( 87 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 46 ) * B( 88 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 56 ) * B( 89 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 67 ) * B( 90 )
      C( 1 , 13 ) = C( 1 , 13 ) + A( 79 ) * B( 91 )
!
      C( 2 , 1 ) = A( 2 ) * B( 1 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 3 ) * B( 2 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 5 ) * B( 4 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 8 ) * B( 7 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 12 ) * B( 11 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 17 ) * B( 16 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 23 ) * B( 22 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 30 ) * B( 29 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 38 ) * B( 37 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 47 ) * B( 46 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 57 ) * B( 56 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 68 ) * B( 67 )
      C( 2 , 1 ) = C( 2 , 1 ) + A( 80 ) * B( 79 )
!
      C( 2 , 2 ) = A( 2 ) * B( 2 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 3 ) * B( 3 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 5 ) * B( 5 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 8 ) * B( 8 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 12 ) * B( 12 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 17 ) * B( 17 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 23 ) * B( 23 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 30 ) * B( 30 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 38 ) * B( 38 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 47 ) * B( 47 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 57 ) * B( 57 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 68 ) * B( 68 )
      C( 2 , 2 ) = C( 2 , 2 ) + A( 80 ) * B( 80 )
!
      C( 2 , 3 ) = A( 2 ) * B( 4 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 3 ) * B( 5 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 5 ) * B( 6 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 8 ) * B( 9 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 12 ) * B( 13 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 17 ) * B( 18 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 23 ) * B( 24 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 30 ) * B( 31 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 38 ) * B( 39 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 47 ) * B( 48 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 57 ) * B( 58 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 68 ) * B( 69 )
      C( 2 , 3 ) = C( 2 , 3 ) + A( 80 ) * B( 81 )
!
      C( 2 , 4 ) = A( 2 ) * B( 7 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 3 ) * B( 8 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 5 ) * B( 9 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 8 ) * B( 10 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 12 ) * B( 14 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 17 ) * B( 19 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 23 ) * B( 25 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 30 ) * B( 32 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 38 ) * B( 40 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 47 ) * B( 49 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 57 ) * B( 59 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 68 ) * B( 70 )
      C( 2 , 4 ) = C( 2 , 4 ) + A( 80 ) * B( 82 )
!
      C( 2 , 5 ) = A( 2 ) * B( 11 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 3 ) * B( 12 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 5 ) * B( 13 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 8 ) * B( 14 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 12 ) * B( 15 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 17 ) * B( 20 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 23 ) * B( 26 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 30 ) * B( 33 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 38 ) * B( 41 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 47 ) * B( 50 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 57 ) * B( 60 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 68 ) * B( 71 )
      C( 2 , 5 ) = C( 2 , 5 ) + A( 80 ) * B( 83 )
!
      C( 2 , 6 ) = A( 2 ) * B( 16 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 3 ) * B( 17 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 5 ) * B( 18 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 8 ) * B( 19 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 12 ) * B( 20 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 17 ) * B( 21 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 23 ) * B( 27 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 30 ) * B( 34 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 38 ) * B( 42 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 47 ) * B( 51 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 57 ) * B( 61 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 68 ) * B( 72 )
      C( 2 , 6 ) = C( 2 , 6 ) + A( 80 ) * B( 84 )
!
      C( 2 , 7 ) = A( 2 ) * B( 22 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 3 ) * B( 23 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 5 ) * B( 24 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 8 ) * B( 25 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 12 ) * B( 26 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 17 ) * B( 27 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 23 ) * B( 28 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 30 ) * B( 35 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 38 ) * B( 43 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 47 ) * B( 52 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 57 ) * B( 62 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 68 ) * B( 73 )
      C( 2 , 7 ) = C( 2 , 7 ) + A( 80 ) * B( 85 )
!
      C( 2 , 8 ) = A( 2 ) * B( 29 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 3 ) * B( 30 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 5 ) * B( 31 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 8 ) * B( 32 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 12 ) * B( 33 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 17 ) * B( 34 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 23 ) * B( 35 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 30 ) * B( 36 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 38 ) * B( 44 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 47 ) * B( 53 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 57 ) * B( 63 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 68 ) * B( 74 )
      C( 2 , 8 ) = C( 2 , 8 ) + A( 80 ) * B( 86 )
!
      C( 2 , 9 ) = A( 2 ) * B( 37 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 3 ) * B( 38 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 5 ) * B( 39 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 8 ) * B( 40 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 12 ) * B( 41 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 17 ) * B( 42 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 23 ) * B( 43 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 30 ) * B( 44 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 38 ) * B( 45 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 47 ) * B( 54 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 57 ) * B( 64 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 68 ) * B( 75 )
      C( 2 , 9 ) = C( 2 , 9 ) + A( 80 ) * B( 87 )
!
      C( 2 , 10 ) = A( 2 ) * B( 46 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 3 ) * B( 47 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 5 ) * B( 48 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 8 ) * B( 49 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 12 ) * B( 50 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 17 ) * B( 51 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 23 ) * B( 52 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 30 ) * B( 53 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 38 ) * B( 54 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 47 ) * B( 55 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 57 ) * B( 65 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 68 ) * B( 76 )
      C( 2 , 10 ) = C( 2 , 10 ) + A( 80 ) * B( 88 )
!
      C( 2 , 11 ) = A( 2 ) * B( 56 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 3 ) * B( 57 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 5 ) * B( 58 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 8 ) * B( 59 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 12 ) * B( 60 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 17 ) * B( 61 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 23 ) * B( 62 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 30 ) * B( 63 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 38 ) * B( 64 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 47 ) * B( 65 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 57 ) * B( 66 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 68 ) * B( 77 )
      C( 2 , 11 ) = C( 2 , 11 ) + A( 80 ) * B( 89 )
!
      C( 2 , 12 ) = A( 2 ) * B( 67 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 3 ) * B( 68 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 5 ) * B( 69 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 8 ) * B( 70 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 12 ) * B( 71 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 17 ) * B( 72 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 23 ) * B( 73 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 30 ) * B( 74 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 38 ) * B( 75 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 47 ) * B( 76 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 57 ) * B( 77 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 68 ) * B( 78 )
      C( 2 , 12 ) = C( 2 , 12 ) + A( 80 ) * B( 90 )
!
      C( 2 , 13 ) = A( 2 ) * B( 79 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 3 ) * B( 80 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 5 ) * B( 81 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 8 ) * B( 82 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 12 ) * B( 83 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 17 ) * B( 84 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 23 ) * B( 85 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 30 ) * B( 86 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 38 ) * B( 87 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 47 ) * B( 88 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 57 ) * B( 89 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 68 ) * B( 90 )
      C( 2 , 13 ) = C( 2 , 13 ) + A( 80 ) * B( 91 )
!
      C( 3 , 1 ) = A( 4 ) * B( 1 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 5 ) * B( 2 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 6 ) * B( 4 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 9 ) * B( 7 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 13 ) * B( 11 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 18 ) * B( 16 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 24 ) * B( 22 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 31 ) * B( 29 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 39 ) * B( 37 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 48 ) * B( 46 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 58 ) * B( 56 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 69 ) * B( 67 )
      C( 3 , 1 ) = C( 3 , 1 ) + A( 81 ) * B( 79 )
!
      C( 3 , 2 ) = A( 4 ) * B( 2 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 5 ) * B( 3 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 6 ) * B( 5 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 9 ) * B( 8 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 13 ) * B( 12 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 18 ) * B( 17 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 24 ) * B( 23 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 31 ) * B( 30 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 39 ) * B( 38 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 48 ) * B( 47 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 58 ) * B( 57 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 69 ) * B( 68 )
      C( 3 , 2 ) = C( 3 , 2 ) + A( 81 ) * B( 80 )
!
      C( 3 , 3 ) = A( 4 ) * B( 4 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 5 ) * B( 5 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 6 ) * B( 6 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 9 ) * B( 9 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 13 ) * B( 13 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 18 ) * B( 18 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 24 ) * B( 24 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 31 ) * B( 31 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 39 ) * B( 39 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 48 ) * B( 48 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 58 ) * B( 58 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 69 ) * B( 69 )
      C( 3 , 3 ) = C( 3 , 3 ) + A( 81 ) * B( 81 )
!
      C( 3 , 4 ) = A( 4 ) * B( 7 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 5 ) * B( 8 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 6 ) * B( 9 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 9 ) * B( 10 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 13 ) * B( 14 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 18 ) * B( 19 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 24 ) * B( 25 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 31 ) * B( 32 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 39 ) * B( 40 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 48 ) * B( 49 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 58 ) * B( 59 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 69 ) * B( 70 )
      C( 3 , 4 ) = C( 3 , 4 ) + A( 81 ) * B( 82 )
!
      C( 3 , 5 ) = A( 4 ) * B( 11 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 5 ) * B( 12 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 6 ) * B( 13 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 9 ) * B( 14 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 13 ) * B( 15 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 18 ) * B( 20 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 24 ) * B( 26 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 31 ) * B( 33 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 39 ) * B( 41 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 48 ) * B( 50 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 58 ) * B( 60 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 69 ) * B( 71 )
      C( 3 , 5 ) = C( 3 , 5 ) + A( 81 ) * B( 83 )
!
      C( 3 , 6 ) = A( 4 ) * B( 16 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 5 ) * B( 17 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 6 ) * B( 18 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 9 ) * B( 19 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 13 ) * B( 20 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 18 ) * B( 21 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 24 ) * B( 27 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 31 ) * B( 34 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 39 ) * B( 42 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 48 ) * B( 51 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 58 ) * B( 61 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 69 ) * B( 72 )
      C( 3 , 6 ) = C( 3 , 6 ) + A( 81 ) * B( 84 )
!
      C( 3 , 7 ) = A( 4 ) * B( 22 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 5 ) * B( 23 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 6 ) * B( 24 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 9 ) * B( 25 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 13 ) * B( 26 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 18 ) * B( 27 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 24 ) * B( 28 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 31 ) * B( 35 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 39 ) * B( 43 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 48 ) * B( 52 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 58 ) * B( 62 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 69 ) * B( 73 )
      C( 3 , 7 ) = C( 3 , 7 ) + A( 81 ) * B( 85 )
!
      C( 3 , 8 ) = A( 4 ) * B( 29 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 5 ) * B( 30 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 6 ) * B( 31 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 9 ) * B( 32 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 13 ) * B( 33 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 18 ) * B( 34 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 24 ) * B( 35 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 31 ) * B( 36 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 39 ) * B( 44 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 48 ) * B( 53 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 58 ) * B( 63 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 69 ) * B( 74 )
      C( 3 , 8 ) = C( 3 , 8 ) + A( 81 ) * B( 86 )
!
      C( 3 , 9 ) = A( 4 ) * B( 37 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 5 ) * B( 38 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 6 ) * B( 39 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 9 ) * B( 40 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 13 ) * B( 41 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 18 ) * B( 42 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 24 ) * B( 43 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 31 ) * B( 44 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 39 ) * B( 45 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 48 ) * B( 54 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 58 ) * B( 64 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 69 ) * B( 75 )
      C( 3 , 9 ) = C( 3 , 9 ) + A( 81 ) * B( 87 )
!
      C( 3 , 10 ) = A( 4 ) * B( 46 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 5 ) * B( 47 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 6 ) * B( 48 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 9 ) * B( 49 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 13 ) * B( 50 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 18 ) * B( 51 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 24 ) * B( 52 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 31 ) * B( 53 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 39 ) * B( 54 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 48 ) * B( 55 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 58 ) * B( 65 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 69 ) * B( 76 )
      C( 3 , 10 ) = C( 3 , 10 ) + A( 81 ) * B( 88 )
!
      C( 3 , 11 ) = A( 4 ) * B( 56 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 5 ) * B( 57 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 6 ) * B( 58 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 9 ) * B( 59 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 13 ) * B( 60 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 18 ) * B( 61 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 24 ) * B( 62 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 31 ) * B( 63 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 39 ) * B( 64 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 48 ) * B( 65 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 58 ) * B( 66 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 69 ) * B( 77 )
      C( 3 , 11 ) = C( 3 , 11 ) + A( 81 ) * B( 89 )
!
      C( 3 , 12 ) = A( 4 ) * B( 67 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 5 ) * B( 68 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 6 ) * B( 69 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 9 ) * B( 70 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 13 ) * B( 71 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 18 ) * B( 72 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 24 ) * B( 73 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 31 ) * B( 74 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 39 ) * B( 75 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 48 ) * B( 76 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 58 ) * B( 77 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 69 ) * B( 78 )
      C( 3 , 12 ) = C( 3 , 12 ) + A( 81 ) * B( 90 )
!
      C( 3 , 13 ) = A( 4 ) * B( 79 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 5 ) * B( 80 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 6 ) * B( 81 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 9 ) * B( 82 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 13 ) * B( 83 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 18 ) * B( 84 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 24 ) * B( 85 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 31 ) * B( 86 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 39 ) * B( 87 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 48 ) * B( 88 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 58 ) * B( 89 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 69 ) * B( 90 )
      C( 3 , 13 ) = C( 3 , 13 ) + A( 81 ) * B( 91 )
!
      C( 4 , 1 ) = A( 7 ) * B( 1 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 8 ) * B( 2 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 9 ) * B( 4 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 10 ) * B( 7 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 14 ) * B( 11 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 19 ) * B( 16 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 25 ) * B( 22 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 32 ) * B( 29 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 40 ) * B( 37 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 49 ) * B( 46 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 59 ) * B( 56 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 70 ) * B( 67 )
      C( 4 , 1 ) = C( 4 , 1 ) + A( 82 ) * B( 79 )
!
      C( 4 , 2 ) = A( 7 ) * B( 2 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 8 ) * B( 3 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 9 ) * B( 5 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 10 ) * B( 8 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 14 ) * B( 12 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 19 ) * B( 17 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 25 ) * B( 23 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 32 ) * B( 30 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 40 ) * B( 38 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 49 ) * B( 47 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 59 ) * B( 57 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 70 ) * B( 68 )
      C( 4 , 2 ) = C( 4 , 2 ) + A( 82 ) * B( 80 )
!
      C( 4 , 3 ) = A( 7 ) * B( 4 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 8 ) * B( 5 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 9 ) * B( 6 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 10 ) * B( 9 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 14 ) * B( 13 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 19 ) * B( 18 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 25 ) * B( 24 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 32 ) * B( 31 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 40 ) * B( 39 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 49 ) * B( 48 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 59 ) * B( 58 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 70 ) * B( 69 )
      C( 4 , 3 ) = C( 4 , 3 ) + A( 82 ) * B( 81 )
!
      C( 4 , 4 ) = A( 7 ) * B( 7 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 8 ) * B( 8 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 9 ) * B( 9 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 10 ) * B( 10 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 14 ) * B( 14 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 19 ) * B( 19 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 25 ) * B( 25 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 32 ) * B( 32 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 40 ) * B( 40 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 49 ) * B( 49 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 59 ) * B( 59 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 70 ) * B( 70 )
      C( 4 , 4 ) = C( 4 , 4 ) + A( 82 ) * B( 82 )
!
      C( 4 , 5 ) = A( 7 ) * B( 11 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 8 ) * B( 12 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 9 ) * B( 13 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 10 ) * B( 14 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 14 ) * B( 15 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 19 ) * B( 20 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 25 ) * B( 26 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 32 ) * B( 33 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 40 ) * B( 41 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 49 ) * B( 50 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 59 ) * B( 60 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 70 ) * B( 71 )
      C( 4 , 5 ) = C( 4 , 5 ) + A( 82 ) * B( 83 )
!
      C( 4 , 6 ) = A( 7 ) * B( 16 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 8 ) * B( 17 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 9 ) * B( 18 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 10 ) * B( 19 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 14 ) * B( 20 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 19 ) * B( 21 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 25 ) * B( 27 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 32 ) * B( 34 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 40 ) * B( 42 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 49 ) * B( 51 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 59 ) * B( 61 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 70 ) * B( 72 )
      C( 4 , 6 ) = C( 4 , 6 ) + A( 82 ) * B( 84 )
!
      C( 4 , 7 ) = A( 7 ) * B( 22 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 8 ) * B( 23 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 9 ) * B( 24 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 10 ) * B( 25 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 14 ) * B( 26 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 19 ) * B( 27 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 25 ) * B( 28 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 32 ) * B( 35 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 40 ) * B( 43 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 49 ) * B( 52 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 59 ) * B( 62 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 70 ) * B( 73 )
      C( 4 , 7 ) = C( 4 , 7 ) + A( 82 ) * B( 85 )
!
      C( 4 , 8 ) = A( 7 ) * B( 29 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 8 ) * B( 30 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 9 ) * B( 31 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 10 ) * B( 32 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 14 ) * B( 33 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 19 ) * B( 34 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 25 ) * B( 35 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 32 ) * B( 36 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 40 ) * B( 44 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 49 ) * B( 53 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 59 ) * B( 63 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 70 ) * B( 74 )
      C( 4 , 8 ) = C( 4 , 8 ) + A( 82 ) * B( 86 )
!
      C( 4 , 9 ) = A( 7 ) * B( 37 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 8 ) * B( 38 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 9 ) * B( 39 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 10 ) * B( 40 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 14 ) * B( 41 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 19 ) * B( 42 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 25 ) * B( 43 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 32 ) * B( 44 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 40 ) * B( 45 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 49 ) * B( 54 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 59 ) * B( 64 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 70 ) * B( 75 )
      C( 4 , 9 ) = C( 4 , 9 ) + A( 82 ) * B( 87 )
!
      C( 4 , 10 ) = A( 7 ) * B( 46 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 8 ) * B( 47 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 9 ) * B( 48 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 10 ) * B( 49 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 14 ) * B( 50 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 19 ) * B( 51 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 25 ) * B( 52 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 32 ) * B( 53 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 40 ) * B( 54 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 49 ) * B( 55 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 59 ) * B( 65 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 70 ) * B( 76 )
      C( 4 , 10 ) = C( 4 , 10 ) + A( 82 ) * B( 88 )
!
      C( 4 , 11 ) = A( 7 ) * B( 56 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 8 ) * B( 57 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 9 ) * B( 58 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 10 ) * B( 59 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 14 ) * B( 60 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 19 ) * B( 61 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 25 ) * B( 62 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 32 ) * B( 63 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 40 ) * B( 64 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 49 ) * B( 65 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 59 ) * B( 66 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 70 ) * B( 77 )
      C( 4 , 11 ) = C( 4 , 11 ) + A( 82 ) * B( 89 )
!
      C( 4 , 12 ) = A( 7 ) * B( 67 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 8 ) * B( 68 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 9 ) * B( 69 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 10 ) * B( 70 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 14 ) * B( 71 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 19 ) * B( 72 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 25 ) * B( 73 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 32 ) * B( 74 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 40 ) * B( 75 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 49 ) * B( 76 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 59 ) * B( 77 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 70 ) * B( 78 )
      C( 4 , 12 ) = C( 4 , 12 ) + A( 82 ) * B( 90 )
!
      C( 4 , 13 ) = A( 7 ) * B( 79 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 8 ) * B( 80 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 9 ) * B( 81 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 10 ) * B( 82 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 14 ) * B( 83 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 19 ) * B( 84 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 25 ) * B( 85 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 32 ) * B( 86 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 40 ) * B( 87 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 49 ) * B( 88 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 59 ) * B( 89 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 70 ) * B( 90 )
      C( 4 , 13 ) = C( 4 , 13 ) + A( 82 ) * B( 91 )
!
      C( 5 , 1 ) = A( 11 ) * B( 1 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 12 ) * B( 2 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 13 ) * B( 4 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 14 ) * B( 7 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 15 ) * B( 11 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 20 ) * B( 16 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 26 ) * B( 22 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 33 ) * B( 29 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 41 ) * B( 37 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 50 ) * B( 46 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 60 ) * B( 56 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 71 ) * B( 67 )
      C( 5 , 1 ) = C( 5 , 1 ) + A( 83 ) * B( 79 )
!
      C( 5 , 2 ) = A( 11 ) * B( 2 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 12 ) * B( 3 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 13 ) * B( 5 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 14 ) * B( 8 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 15 ) * B( 12 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 20 ) * B( 17 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 26 ) * B( 23 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 33 ) * B( 30 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 41 ) * B( 38 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 50 ) * B( 47 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 60 ) * B( 57 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 71 ) * B( 68 )
      C( 5 , 2 ) = C( 5 , 2 ) + A( 83 ) * B( 80 )
!
      C( 5 , 3 ) = A( 11 ) * B( 4 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 12 ) * B( 5 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 13 ) * B( 6 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 14 ) * B( 9 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 15 ) * B( 13 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 20 ) * B( 18 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 26 ) * B( 24 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 33 ) * B( 31 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 41 ) * B( 39 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 50 ) * B( 48 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 60 ) * B( 58 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 71 ) * B( 69 )
      C( 5 , 3 ) = C( 5 , 3 ) + A( 83 ) * B( 81 )
!
      C( 5 , 4 ) = A( 11 ) * B( 7 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 12 ) * B( 8 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 13 ) * B( 9 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 14 ) * B( 10 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 15 ) * B( 14 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 20 ) * B( 19 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 26 ) * B( 25 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 33 ) * B( 32 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 41 ) * B( 40 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 50 ) * B( 49 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 60 ) * B( 59 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 71 ) * B( 70 )
      C( 5 , 4 ) = C( 5 , 4 ) + A( 83 ) * B( 82 )
!
      C( 5 , 5 ) = A( 11 ) * B( 11 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 12 ) * B( 12 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 13 ) * B( 13 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 14 ) * B( 14 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 15 ) * B( 15 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 20 ) * B( 20 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 26 ) * B( 26 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 33 ) * B( 33 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 41 ) * B( 41 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 50 ) * B( 50 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 60 ) * B( 60 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 71 ) * B( 71 )
      C( 5 , 5 ) = C( 5 , 5 ) + A( 83 ) * B( 83 )
!
      C( 5 , 6 ) = A( 11 ) * B( 16 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 12 ) * B( 17 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 13 ) * B( 18 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 14 ) * B( 19 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 15 ) * B( 20 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 20 ) * B( 21 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 26 ) * B( 27 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 33 ) * B( 34 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 41 ) * B( 42 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 50 ) * B( 51 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 60 ) * B( 61 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 71 ) * B( 72 )
      C( 5 , 6 ) = C( 5 , 6 ) + A( 83 ) * B( 84 )
!
      C( 5 , 7 ) = A( 11 ) * B( 22 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 12 ) * B( 23 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 13 ) * B( 24 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 14 ) * B( 25 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 15 ) * B( 26 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 20 ) * B( 27 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 26 ) * B( 28 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 33 ) * B( 35 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 41 ) * B( 43 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 50 ) * B( 52 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 60 ) * B( 62 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 71 ) * B( 73 )
      C( 5 , 7 ) = C( 5 , 7 ) + A( 83 ) * B( 85 )
!
      C( 5 , 8 ) = A( 11 ) * B( 29 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 12 ) * B( 30 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 13 ) * B( 31 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 14 ) * B( 32 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 15 ) * B( 33 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 20 ) * B( 34 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 26 ) * B( 35 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 33 ) * B( 36 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 41 ) * B( 44 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 50 ) * B( 53 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 60 ) * B( 63 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 71 ) * B( 74 )
      C( 5 , 8 ) = C( 5 , 8 ) + A( 83 ) * B( 86 )
!
      C( 5 , 9 ) = A( 11 ) * B( 37 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 12 ) * B( 38 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 13 ) * B( 39 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 14 ) * B( 40 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 15 ) * B( 41 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 20 ) * B( 42 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 26 ) * B( 43 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 33 ) * B( 44 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 41 ) * B( 45 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 50 ) * B( 54 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 60 ) * B( 64 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 71 ) * B( 75 )
      C( 5 , 9 ) = C( 5 , 9 ) + A( 83 ) * B( 87 )
!
      C( 5 , 10 ) = A( 11 ) * B( 46 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 12 ) * B( 47 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 13 ) * B( 48 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 14 ) * B( 49 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 15 ) * B( 50 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 20 ) * B( 51 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 26 ) * B( 52 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 33 ) * B( 53 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 41 ) * B( 54 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 50 ) * B( 55 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 60 ) * B( 65 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 71 ) * B( 76 )
      C( 5 , 10 ) = C( 5 , 10 ) + A( 83 ) * B( 88 )
!
      C( 5 , 11 ) = A( 11 ) * B( 56 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 12 ) * B( 57 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 13 ) * B( 58 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 14 ) * B( 59 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 15 ) * B( 60 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 20 ) * B( 61 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 26 ) * B( 62 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 33 ) * B( 63 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 41 ) * B( 64 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 50 ) * B( 65 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 60 ) * B( 66 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 71 ) * B( 77 )
      C( 5 , 11 ) = C( 5 , 11 ) + A( 83 ) * B( 89 )
!
      C( 5 , 12 ) = A( 11 ) * B( 67 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 12 ) * B( 68 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 13 ) * B( 69 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 14 ) * B( 70 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 15 ) * B( 71 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 20 ) * B( 72 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 26 ) * B( 73 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 33 ) * B( 74 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 41 ) * B( 75 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 50 ) * B( 76 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 60 ) * B( 77 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 71 ) * B( 78 )
      C( 5 , 12 ) = C( 5 , 12 ) + A( 83 ) * B( 90 )
!
      C( 5 , 13 ) = A( 11 ) * B( 79 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 12 ) * B( 80 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 13 ) * B( 81 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 14 ) * B( 82 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 15 ) * B( 83 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 20 ) * B( 84 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 26 ) * B( 85 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 33 ) * B( 86 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 41 ) * B( 87 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 50 ) * B( 88 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 60 ) * B( 89 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 71 ) * B( 90 )
      C( 5 , 13 ) = C( 5 , 13 ) + A( 83 ) * B( 91 )
!
      C( 6 , 1 ) = A( 16 ) * B( 1 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 17 ) * B( 2 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 18 ) * B( 4 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 19 ) * B( 7 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 20 ) * B( 11 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 21 ) * B( 16 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 27 ) * B( 22 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 34 ) * B( 29 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 42 ) * B( 37 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 51 ) * B( 46 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 61 ) * B( 56 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 72 ) * B( 67 )
      C( 6 , 1 ) = C( 6 , 1 ) + A( 84 ) * B( 79 )
!
      C( 6 , 2 ) = A( 16 ) * B( 2 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 17 ) * B( 3 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 18 ) * B( 5 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 19 ) * B( 8 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 20 ) * B( 12 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 21 ) * B( 17 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 27 ) * B( 23 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 34 ) * B( 30 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 42 ) * B( 38 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 51 ) * B( 47 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 61 ) * B( 57 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 72 ) * B( 68 )
      C( 6 , 2 ) = C( 6 , 2 ) + A( 84 ) * B( 80 )
!
      C( 6 , 3 ) = A( 16 ) * B( 4 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 17 ) * B( 5 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 18 ) * B( 6 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 19 ) * B( 9 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 20 ) * B( 13 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 21 ) * B( 18 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 27 ) * B( 24 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 34 ) * B( 31 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 42 ) * B( 39 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 51 ) * B( 48 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 61 ) * B( 58 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 72 ) * B( 69 )
      C( 6 , 3 ) = C( 6 , 3 ) + A( 84 ) * B( 81 )
!
      C( 6 , 4 ) = A( 16 ) * B( 7 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 17 ) * B( 8 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 18 ) * B( 9 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 19 ) * B( 10 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 20 ) * B( 14 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 21 ) * B( 19 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 27 ) * B( 25 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 34 ) * B( 32 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 42 ) * B( 40 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 51 ) * B( 49 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 61 ) * B( 59 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 72 ) * B( 70 )
      C( 6 , 4 ) = C( 6 , 4 ) + A( 84 ) * B( 82 )
!
      C( 6 , 5 ) = A( 16 ) * B( 11 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 17 ) * B( 12 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 18 ) * B( 13 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 19 ) * B( 14 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 20 ) * B( 15 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 21 ) * B( 20 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 27 ) * B( 26 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 34 ) * B( 33 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 42 ) * B( 41 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 51 ) * B( 50 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 61 ) * B( 60 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 72 ) * B( 71 )
      C( 6 , 5 ) = C( 6 , 5 ) + A( 84 ) * B( 83 )
!
      C( 6 , 6 ) = A( 16 ) * B( 16 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 17 ) * B( 17 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 18 ) * B( 18 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 19 ) * B( 19 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 20 ) * B( 20 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 21 ) * B( 21 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 27 ) * B( 27 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 34 ) * B( 34 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 42 ) * B( 42 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 51 ) * B( 51 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 61 ) * B( 61 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 72 ) * B( 72 )
      C( 6 , 6 ) = C( 6 , 6 ) + A( 84 ) * B( 84 )
!
      C( 6 , 7 ) = A( 16 ) * B( 22 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 17 ) * B( 23 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 18 ) * B( 24 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 19 ) * B( 25 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 20 ) * B( 26 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 21 ) * B( 27 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 27 ) * B( 28 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 34 ) * B( 35 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 42 ) * B( 43 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 51 ) * B( 52 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 61 ) * B( 62 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 72 ) * B( 73 )
      C( 6 , 7 ) = C( 6 , 7 ) + A( 84 ) * B( 85 )
!
      C( 6 , 8 ) = A( 16 ) * B( 29 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 17 ) * B( 30 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 18 ) * B( 31 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 19 ) * B( 32 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 20 ) * B( 33 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 21 ) * B( 34 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 27 ) * B( 35 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 34 ) * B( 36 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 42 ) * B( 44 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 51 ) * B( 53 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 61 ) * B( 63 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 72 ) * B( 74 )
      C( 6 , 8 ) = C( 6 , 8 ) + A( 84 ) * B( 86 )
!
      C( 6 , 9 ) = A( 16 ) * B( 37 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 17 ) * B( 38 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 18 ) * B( 39 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 19 ) * B( 40 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 20 ) * B( 41 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 21 ) * B( 42 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 27 ) * B( 43 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 34 ) * B( 44 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 42 ) * B( 45 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 51 ) * B( 54 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 61 ) * B( 64 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 72 ) * B( 75 )
      C( 6 , 9 ) = C( 6 , 9 ) + A( 84 ) * B( 87 )
!
      C( 6 , 10 ) = A( 16 ) * B( 46 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 17 ) * B( 47 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 18 ) * B( 48 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 19 ) * B( 49 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 20 ) * B( 50 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 21 ) * B( 51 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 27 ) * B( 52 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 34 ) * B( 53 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 42 ) * B( 54 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 51 ) * B( 55 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 61 ) * B( 65 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 72 ) * B( 76 )
      C( 6 , 10 ) = C( 6 , 10 ) + A( 84 ) * B( 88 )
!
      C( 6 , 11 ) = A( 16 ) * B( 56 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 17 ) * B( 57 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 18 ) * B( 58 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 19 ) * B( 59 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 20 ) * B( 60 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 21 ) * B( 61 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 27 ) * B( 62 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 34 ) * B( 63 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 42 ) * B( 64 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 51 ) * B( 65 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 61 ) * B( 66 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 72 ) * B( 77 )
      C( 6 , 11 ) = C( 6 , 11 ) + A( 84 ) * B( 89 )
!
      C( 6 , 12 ) = A( 16 ) * B( 67 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 17 ) * B( 68 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 18 ) * B( 69 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 19 ) * B( 70 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 20 ) * B( 71 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 21 ) * B( 72 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 27 ) * B( 73 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 34 ) * B( 74 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 42 ) * B( 75 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 51 ) * B( 76 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 61 ) * B( 77 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 72 ) * B( 78 )
      C( 6 , 12 ) = C( 6 , 12 ) + A( 84 ) * B( 90 )
!
      C( 6 , 13 ) = A( 16 ) * B( 79 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 17 ) * B( 80 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 18 ) * B( 81 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 19 ) * B( 82 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 20 ) * B( 83 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 21 ) * B( 84 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 27 ) * B( 85 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 34 ) * B( 86 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 42 ) * B( 87 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 51 ) * B( 88 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 61 ) * B( 89 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 72 ) * B( 90 )
      C( 6 , 13 ) = C( 6 , 13 ) + A( 84 ) * B( 91 )
!
      C( 7 , 1 ) = A( 22 ) * B( 1 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 23 ) * B( 2 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 24 ) * B( 4 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 25 ) * B( 7 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 26 ) * B( 11 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 27 ) * B( 16 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 28 ) * B( 22 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 35 ) * B( 29 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 43 ) * B( 37 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 52 ) * B( 46 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 62 ) * B( 56 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 73 ) * B( 67 )
      C( 7 , 1 ) = C( 7 , 1 ) + A( 85 ) * B( 79 )
!
      C( 7 , 2 ) = A( 22 ) * B( 2 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 23 ) * B( 3 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 24 ) * B( 5 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 25 ) * B( 8 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 26 ) * B( 12 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 27 ) * B( 17 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 28 ) * B( 23 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 35 ) * B( 30 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 43 ) * B( 38 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 52 ) * B( 47 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 62 ) * B( 57 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 73 ) * B( 68 )
      C( 7 , 2 ) = C( 7 , 2 ) + A( 85 ) * B( 80 )
!
      C( 7 , 3 ) = A( 22 ) * B( 4 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 23 ) * B( 5 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 24 ) * B( 6 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 25 ) * B( 9 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 26 ) * B( 13 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 27 ) * B( 18 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 28 ) * B( 24 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 35 ) * B( 31 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 43 ) * B( 39 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 52 ) * B( 48 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 62 ) * B( 58 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 73 ) * B( 69 )
      C( 7 , 3 ) = C( 7 , 3 ) + A( 85 ) * B( 81 )
!
      C( 7 , 4 ) = A( 22 ) * B( 7 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 23 ) * B( 8 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 24 ) * B( 9 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 25 ) * B( 10 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 26 ) * B( 14 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 27 ) * B( 19 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 28 ) * B( 25 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 35 ) * B( 32 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 43 ) * B( 40 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 52 ) * B( 49 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 62 ) * B( 59 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 73 ) * B( 70 )
      C( 7 , 4 ) = C( 7 , 4 ) + A( 85 ) * B( 82 )
!
      C( 7 , 5 ) = A( 22 ) * B( 11 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 23 ) * B( 12 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 24 ) * B( 13 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 25 ) * B( 14 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 26 ) * B( 15 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 27 ) * B( 20 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 28 ) * B( 26 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 35 ) * B( 33 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 43 ) * B( 41 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 52 ) * B( 50 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 62 ) * B( 60 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 73 ) * B( 71 )
      C( 7 , 5 ) = C( 7 , 5 ) + A( 85 ) * B( 83 )
!
      C( 7 , 6 ) = A( 22 ) * B( 16 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 23 ) * B( 17 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 24 ) * B( 18 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 25 ) * B( 19 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 26 ) * B( 20 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 27 ) * B( 21 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 28 ) * B( 27 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 35 ) * B( 34 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 43 ) * B( 42 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 52 ) * B( 51 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 62 ) * B( 61 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 73 ) * B( 72 )
      C( 7 , 6 ) = C( 7 , 6 ) + A( 85 ) * B( 84 )
!
      C( 7 , 7 ) = A( 22 ) * B( 22 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 23 ) * B( 23 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 24 ) * B( 24 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 25 ) * B( 25 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 26 ) * B( 26 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 27 ) * B( 27 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 28 ) * B( 28 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 35 ) * B( 35 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 43 ) * B( 43 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 52 ) * B( 52 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 62 ) * B( 62 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 73 ) * B( 73 )
      C( 7 , 7 ) = C( 7 , 7 ) + A( 85 ) * B( 85 )
!
      C( 7 , 8 ) = A( 22 ) * B( 29 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 23 ) * B( 30 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 24 ) * B( 31 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 25 ) * B( 32 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 26 ) * B( 33 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 27 ) * B( 34 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 28 ) * B( 35 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 35 ) * B( 36 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 43 ) * B( 44 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 52 ) * B( 53 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 62 ) * B( 63 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 73 ) * B( 74 )
      C( 7 , 8 ) = C( 7 , 8 ) + A( 85 ) * B( 86 )
!
      C( 7 , 9 ) = A( 22 ) * B( 37 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 23 ) * B( 38 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 24 ) * B( 39 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 25 ) * B( 40 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 26 ) * B( 41 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 27 ) * B( 42 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 28 ) * B( 43 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 35 ) * B( 44 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 43 ) * B( 45 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 52 ) * B( 54 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 62 ) * B( 64 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 73 ) * B( 75 )
      C( 7 , 9 ) = C( 7 , 9 ) + A( 85 ) * B( 87 )
!
      C( 7 , 10 ) = A( 22 ) * B( 46 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 23 ) * B( 47 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 24 ) * B( 48 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 25 ) * B( 49 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 26 ) * B( 50 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 27 ) * B( 51 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 28 ) * B( 52 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 35 ) * B( 53 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 43 ) * B( 54 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 52 ) * B( 55 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 62 ) * B( 65 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 73 ) * B( 76 )
      C( 7 , 10 ) = C( 7 , 10 ) + A( 85 ) * B( 88 )
!
      C( 7 , 11 ) = A( 22 ) * B( 56 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 23 ) * B( 57 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 24 ) * B( 58 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 25 ) * B( 59 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 26 ) * B( 60 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 27 ) * B( 61 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 28 ) * B( 62 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 35 ) * B( 63 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 43 ) * B( 64 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 52 ) * B( 65 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 62 ) * B( 66 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 73 ) * B( 77 )
      C( 7 , 11 ) = C( 7 , 11 ) + A( 85 ) * B( 89 )
!
      C( 7 , 12 ) = A( 22 ) * B( 67 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 23 ) * B( 68 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 24 ) * B( 69 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 25 ) * B( 70 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 26 ) * B( 71 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 27 ) * B( 72 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 28 ) * B( 73 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 35 ) * B( 74 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 43 ) * B( 75 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 52 ) * B( 76 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 62 ) * B( 77 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 73 ) * B( 78 )
      C( 7 , 12 ) = C( 7 , 12 ) + A( 85 ) * B( 90 )
!
      C( 7 , 13 ) = A( 22 ) * B( 79 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 23 ) * B( 80 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 24 ) * B( 81 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 25 ) * B( 82 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 26 ) * B( 83 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 27 ) * B( 84 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 28 ) * B( 85 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 35 ) * B( 86 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 43 ) * B( 87 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 52 ) * B( 88 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 62 ) * B( 89 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 73 ) * B( 90 )
      C( 7 , 13 ) = C( 7 , 13 ) + A( 85 ) * B( 91 )
!
      C( 8 , 1 ) = A( 29 ) * B( 1 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 30 ) * B( 2 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 31 ) * B( 4 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 32 ) * B( 7 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 33 ) * B( 11 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 34 ) * B( 16 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 35 ) * B( 22 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 36 ) * B( 29 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 44 ) * B( 37 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 53 ) * B( 46 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 63 ) * B( 56 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 74 ) * B( 67 )
      C( 8 , 1 ) = C( 8 , 1 ) + A( 86 ) * B( 79 )
!
      C( 8 , 2 ) = A( 29 ) * B( 2 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 30 ) * B( 3 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 31 ) * B( 5 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 32 ) * B( 8 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 33 ) * B( 12 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 34 ) * B( 17 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 35 ) * B( 23 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 36 ) * B( 30 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 44 ) * B( 38 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 53 ) * B( 47 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 63 ) * B( 57 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 74 ) * B( 68 )
      C( 8 , 2 ) = C( 8 , 2 ) + A( 86 ) * B( 80 )
!
      C( 8 , 3 ) = A( 29 ) * B( 4 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 30 ) * B( 5 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 31 ) * B( 6 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 32 ) * B( 9 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 33 ) * B( 13 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 34 ) * B( 18 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 35 ) * B( 24 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 36 ) * B( 31 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 44 ) * B( 39 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 53 ) * B( 48 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 63 ) * B( 58 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 74 ) * B( 69 )
      C( 8 , 3 ) = C( 8 , 3 ) + A( 86 ) * B( 81 )
!
      C( 8 , 4 ) = A( 29 ) * B( 7 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 30 ) * B( 8 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 31 ) * B( 9 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 32 ) * B( 10 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 33 ) * B( 14 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 34 ) * B( 19 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 35 ) * B( 25 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 36 ) * B( 32 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 44 ) * B( 40 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 53 ) * B( 49 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 63 ) * B( 59 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 74 ) * B( 70 )
      C( 8 , 4 ) = C( 8 , 4 ) + A( 86 ) * B( 82 )
!
      C( 8 , 5 ) = A( 29 ) * B( 11 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 30 ) * B( 12 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 31 ) * B( 13 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 32 ) * B( 14 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 33 ) * B( 15 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 34 ) * B( 20 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 35 ) * B( 26 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 36 ) * B( 33 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 44 ) * B( 41 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 53 ) * B( 50 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 63 ) * B( 60 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 74 ) * B( 71 )
      C( 8 , 5 ) = C( 8 , 5 ) + A( 86 ) * B( 83 )
!
      C( 8 , 6 ) = A( 29 ) * B( 16 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 30 ) * B( 17 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 31 ) * B( 18 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 32 ) * B( 19 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 33 ) * B( 20 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 34 ) * B( 21 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 35 ) * B( 27 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 36 ) * B( 34 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 44 ) * B( 42 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 53 ) * B( 51 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 63 ) * B( 61 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 74 ) * B( 72 )
      C( 8 , 6 ) = C( 8 , 6 ) + A( 86 ) * B( 84 )
!
      C( 8 , 7 ) = A( 29 ) * B( 22 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 30 ) * B( 23 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 31 ) * B( 24 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 32 ) * B( 25 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 33 ) * B( 26 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 34 ) * B( 27 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 35 ) * B( 28 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 36 ) * B( 35 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 44 ) * B( 43 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 53 ) * B( 52 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 63 ) * B( 62 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 74 ) * B( 73 )
      C( 8 , 7 ) = C( 8 , 7 ) + A( 86 ) * B( 85 )
!
      C( 8 , 8 ) = A( 29 ) * B( 29 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 30 ) * B( 30 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 31 ) * B( 31 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 32 ) * B( 32 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 33 ) * B( 33 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 34 ) * B( 34 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 35 ) * B( 35 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 36 ) * B( 36 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 44 ) * B( 44 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 53 ) * B( 53 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 63 ) * B( 63 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 74 ) * B( 74 )
      C( 8 , 8 ) = C( 8 , 8 ) + A( 86 ) * B( 86 )
!
      C( 8 , 9 ) = A( 29 ) * B( 37 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 30 ) * B( 38 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 31 ) * B( 39 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 32 ) * B( 40 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 33 ) * B( 41 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 34 ) * B( 42 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 35 ) * B( 43 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 36 ) * B( 44 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 44 ) * B( 45 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 53 ) * B( 54 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 63 ) * B( 64 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 74 ) * B( 75 )
      C( 8 , 9 ) = C( 8 , 9 ) + A( 86 ) * B( 87 )
!
      C( 8 , 10 ) = A( 29 ) * B( 46 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 30 ) * B( 47 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 31 ) * B( 48 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 32 ) * B( 49 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 33 ) * B( 50 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 34 ) * B( 51 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 35 ) * B( 52 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 36 ) * B( 53 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 44 ) * B( 54 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 53 ) * B( 55 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 63 ) * B( 65 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 74 ) * B( 76 )
      C( 8 , 10 ) = C( 8 , 10 ) + A( 86 ) * B( 88 )
!
      C( 8 , 11 ) = A( 29 ) * B( 56 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 30 ) * B( 57 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 31 ) * B( 58 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 32 ) * B( 59 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 33 ) * B( 60 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 34 ) * B( 61 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 35 ) * B( 62 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 36 ) * B( 63 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 44 ) * B( 64 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 53 ) * B( 65 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 63 ) * B( 66 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 74 ) * B( 77 )
      C( 8 , 11 ) = C( 8 , 11 ) + A( 86 ) * B( 89 )
!
      C( 8 , 12 ) = A( 29 ) * B( 67 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 30 ) * B( 68 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 31 ) * B( 69 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 32 ) * B( 70 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 33 ) * B( 71 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 34 ) * B( 72 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 35 ) * B( 73 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 36 ) * B( 74 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 44 ) * B( 75 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 53 ) * B( 76 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 63 ) * B( 77 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 74 ) * B( 78 )
      C( 8 , 12 ) = C( 8 , 12 ) + A( 86 ) * B( 90 )
!
      C( 8 , 13 ) = A( 29 ) * B( 79 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 30 ) * B( 80 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 31 ) * B( 81 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 32 ) * B( 82 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 33 ) * B( 83 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 34 ) * B( 84 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 35 ) * B( 85 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 36 ) * B( 86 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 44 ) * B( 87 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 53 ) * B( 88 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 63 ) * B( 89 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 74 ) * B( 90 )
      C( 8 , 13 ) = C( 8 , 13 ) + A( 86 ) * B( 91 )
!
      C( 9 , 1 ) = A( 37 ) * B( 1 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 38 ) * B( 2 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 39 ) * B( 4 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 40 ) * B( 7 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 41 ) * B( 11 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 42 ) * B( 16 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 43 ) * B( 22 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 44 ) * B( 29 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 45 ) * B( 37 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 54 ) * B( 46 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 64 ) * B( 56 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 75 ) * B( 67 )
      C( 9 , 1 ) = C( 9 , 1 ) + A( 87 ) * B( 79 )
!
      C( 9 , 2 ) = A( 37 ) * B( 2 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 38 ) * B( 3 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 39 ) * B( 5 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 40 ) * B( 8 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 41 ) * B( 12 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 42 ) * B( 17 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 43 ) * B( 23 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 44 ) * B( 30 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 45 ) * B( 38 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 54 ) * B( 47 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 64 ) * B( 57 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 75 ) * B( 68 )
      C( 9 , 2 ) = C( 9 , 2 ) + A( 87 ) * B( 80 )
!
      C( 9 , 3 ) = A( 37 ) * B( 4 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 38 ) * B( 5 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 39 ) * B( 6 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 40 ) * B( 9 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 41 ) * B( 13 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 42 ) * B( 18 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 43 ) * B( 24 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 44 ) * B( 31 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 45 ) * B( 39 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 54 ) * B( 48 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 64 ) * B( 58 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 75 ) * B( 69 )
      C( 9 , 3 ) = C( 9 , 3 ) + A( 87 ) * B( 81 )
!
      C( 9 , 4 ) = A( 37 ) * B( 7 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 38 ) * B( 8 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 39 ) * B( 9 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 40 ) * B( 10 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 41 ) * B( 14 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 42 ) * B( 19 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 43 ) * B( 25 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 44 ) * B( 32 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 45 ) * B( 40 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 54 ) * B( 49 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 64 ) * B( 59 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 75 ) * B( 70 )
      C( 9 , 4 ) = C( 9 , 4 ) + A( 87 ) * B( 82 )
!
      C( 9 , 5 ) = A( 37 ) * B( 11 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 38 ) * B( 12 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 39 ) * B( 13 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 40 ) * B( 14 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 41 ) * B( 15 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 42 ) * B( 20 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 43 ) * B( 26 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 44 ) * B( 33 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 45 ) * B( 41 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 54 ) * B( 50 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 64 ) * B( 60 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 75 ) * B( 71 )
      C( 9 , 5 ) = C( 9 , 5 ) + A( 87 ) * B( 83 )
!
      C( 9 , 6 ) = A( 37 ) * B( 16 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 38 ) * B( 17 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 39 ) * B( 18 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 40 ) * B( 19 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 41 ) * B( 20 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 42 ) * B( 21 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 43 ) * B( 27 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 44 ) * B( 34 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 45 ) * B( 42 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 54 ) * B( 51 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 64 ) * B( 61 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 75 ) * B( 72 )
      C( 9 , 6 ) = C( 9 , 6 ) + A( 87 ) * B( 84 )
!
      C( 9 , 7 ) = A( 37 ) * B( 22 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 38 ) * B( 23 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 39 ) * B( 24 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 40 ) * B( 25 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 41 ) * B( 26 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 42 ) * B( 27 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 43 ) * B( 28 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 44 ) * B( 35 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 45 ) * B( 43 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 54 ) * B( 52 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 64 ) * B( 62 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 75 ) * B( 73 )
      C( 9 , 7 ) = C( 9 , 7 ) + A( 87 ) * B( 85 )
!
      C( 9 , 8 ) = A( 37 ) * B( 29 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 38 ) * B( 30 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 39 ) * B( 31 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 40 ) * B( 32 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 41 ) * B( 33 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 42 ) * B( 34 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 43 ) * B( 35 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 44 ) * B( 36 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 45 ) * B( 44 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 54 ) * B( 53 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 64 ) * B( 63 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 75 ) * B( 74 )
      C( 9 , 8 ) = C( 9 , 8 ) + A( 87 ) * B( 86 )
!
      C( 9 , 9 ) = A( 37 ) * B( 37 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 38 ) * B( 38 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 39 ) * B( 39 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 40 ) * B( 40 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 41 ) * B( 41 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 42 ) * B( 42 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 43 ) * B( 43 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 44 ) * B( 44 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 45 ) * B( 45 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 54 ) * B( 54 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 64 ) * B( 64 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 75 ) * B( 75 )
      C( 9 , 9 ) = C( 9 , 9 ) + A( 87 ) * B( 87 )
!
      C( 9 , 10 ) = A( 37 ) * B( 46 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 38 ) * B( 47 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 39 ) * B( 48 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 40 ) * B( 49 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 41 ) * B( 50 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 42 ) * B( 51 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 43 ) * B( 52 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 44 ) * B( 53 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 45 ) * B( 54 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 54 ) * B( 55 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 64 ) * B( 65 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 75 ) * B( 76 )
      C( 9 , 10 ) = C( 9 , 10 ) + A( 87 ) * B( 88 )
!
      C( 9 , 11 ) = A( 37 ) * B( 56 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 38 ) * B( 57 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 39 ) * B( 58 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 40 ) * B( 59 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 41 ) * B( 60 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 42 ) * B( 61 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 43 ) * B( 62 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 44 ) * B( 63 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 45 ) * B( 64 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 54 ) * B( 65 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 64 ) * B( 66 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 75 ) * B( 77 )
      C( 9 , 11 ) = C( 9 , 11 ) + A( 87 ) * B( 89 )
!
      C( 9 , 12 ) = A( 37 ) * B( 67 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 38 ) * B( 68 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 39 ) * B( 69 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 40 ) * B( 70 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 41 ) * B( 71 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 42 ) * B( 72 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 43 ) * B( 73 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 44 ) * B( 74 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 45 ) * B( 75 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 54 ) * B( 76 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 64 ) * B( 77 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 75 ) * B( 78 )
      C( 9 , 12 ) = C( 9 , 12 ) + A( 87 ) * B( 90 )
!
      C( 9 , 13 ) = A( 37 ) * B( 79 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 38 ) * B( 80 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 39 ) * B( 81 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 40 ) * B( 82 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 41 ) * B( 83 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 42 ) * B( 84 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 43 ) * B( 85 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 44 ) * B( 86 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 45 ) * B( 87 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 54 ) * B( 88 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 64 ) * B( 89 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 75 ) * B( 90 )
      C( 9 , 13 ) = C( 9 , 13 ) + A( 87 ) * B( 91 )
!
      C( 10 , 1 ) = A( 46 ) * B( 1 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 47 ) * B( 2 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 48 ) * B( 4 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 49 ) * B( 7 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 50 ) * B( 11 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 51 ) * B( 16 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 52 ) * B( 22 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 53 ) * B( 29 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 54 ) * B( 37 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 55 ) * B( 46 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 65 ) * B( 56 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 76 ) * B( 67 )
      C( 10 , 1 ) = C( 10 , 1 ) + A( 88 ) * B( 79 )
!
      C( 10 , 2 ) = A( 46 ) * B( 2 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 47 ) * B( 3 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 48 ) * B( 5 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 49 ) * B( 8 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 50 ) * B( 12 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 51 ) * B( 17 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 52 ) * B( 23 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 53 ) * B( 30 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 54 ) * B( 38 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 55 ) * B( 47 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 65 ) * B( 57 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 76 ) * B( 68 )
      C( 10 , 2 ) = C( 10 , 2 ) + A( 88 ) * B( 80 )
!
      C( 10 , 3 ) = A( 46 ) * B( 4 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 47 ) * B( 5 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 48 ) * B( 6 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 49 ) * B( 9 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 50 ) * B( 13 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 51 ) * B( 18 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 52 ) * B( 24 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 53 ) * B( 31 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 54 ) * B( 39 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 55 ) * B( 48 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 65 ) * B( 58 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 76 ) * B( 69 )
      C( 10 , 3 ) = C( 10 , 3 ) + A( 88 ) * B( 81 )
!
      C( 10 , 4 ) = A( 46 ) * B( 7 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 47 ) * B( 8 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 48 ) * B( 9 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 49 ) * B( 10 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 50 ) * B( 14 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 51 ) * B( 19 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 52 ) * B( 25 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 53 ) * B( 32 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 54 ) * B( 40 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 55 ) * B( 49 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 65 ) * B( 59 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 76 ) * B( 70 )
      C( 10 , 4 ) = C( 10 , 4 ) + A( 88 ) * B( 82 )
!
      C( 10 , 5 ) = A( 46 ) * B( 11 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 47 ) * B( 12 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 48 ) * B( 13 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 49 ) * B( 14 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 50 ) * B( 15 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 51 ) * B( 20 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 52 ) * B( 26 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 53 ) * B( 33 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 54 ) * B( 41 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 55 ) * B( 50 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 65 ) * B( 60 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 76 ) * B( 71 )
      C( 10 , 5 ) = C( 10 , 5 ) + A( 88 ) * B( 83 )
!
      C( 10 , 6 ) = A( 46 ) * B( 16 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 47 ) * B( 17 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 48 ) * B( 18 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 49 ) * B( 19 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 50 ) * B( 20 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 51 ) * B( 21 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 52 ) * B( 27 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 53 ) * B( 34 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 54 ) * B( 42 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 55 ) * B( 51 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 65 ) * B( 61 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 76 ) * B( 72 )
      C( 10 , 6 ) = C( 10 , 6 ) + A( 88 ) * B( 84 )
!
      C( 10 , 7 ) = A( 46 ) * B( 22 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 47 ) * B( 23 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 48 ) * B( 24 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 49 ) * B( 25 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 50 ) * B( 26 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 51 ) * B( 27 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 52 ) * B( 28 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 53 ) * B( 35 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 54 ) * B( 43 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 55 ) * B( 52 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 65 ) * B( 62 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 76 ) * B( 73 )
      C( 10 , 7 ) = C( 10 , 7 ) + A( 88 ) * B( 85 )
!
      C( 10 , 8 ) = A( 46 ) * B( 29 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 47 ) * B( 30 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 48 ) * B( 31 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 49 ) * B( 32 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 50 ) * B( 33 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 51 ) * B( 34 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 52 ) * B( 35 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 53 ) * B( 36 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 54 ) * B( 44 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 55 ) * B( 53 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 65 ) * B( 63 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 76 ) * B( 74 )
      C( 10 , 8 ) = C( 10 , 8 ) + A( 88 ) * B( 86 )
!
      C( 10 , 9 ) = A( 46 ) * B( 37 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 47 ) * B( 38 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 48 ) * B( 39 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 49 ) * B( 40 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 50 ) * B( 41 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 51 ) * B( 42 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 52 ) * B( 43 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 53 ) * B( 44 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 54 ) * B( 45 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 55 ) * B( 54 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 65 ) * B( 64 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 76 ) * B( 75 )
      C( 10 , 9 ) = C( 10 , 9 ) + A( 88 ) * B( 87 )
!
      C( 10 , 10 ) = A( 46 ) * B( 46 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 47 ) * B( 47 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 48 ) * B( 48 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 49 ) * B( 49 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 50 ) * B( 50 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 51 ) * B( 51 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 52 ) * B( 52 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 53 ) * B( 53 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 54 ) * B( 54 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 55 ) * B( 55 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 65 ) * B( 65 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 76 ) * B( 76 )
      C( 10 , 10 ) = C( 10 , 10 ) + A( 88 ) * B( 88 )
!
      C( 10 , 11 ) = A( 46 ) * B( 56 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 47 ) * B( 57 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 48 ) * B( 58 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 49 ) * B( 59 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 50 ) * B( 60 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 51 ) * B( 61 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 52 ) * B( 62 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 53 ) * B( 63 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 54 ) * B( 64 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 55 ) * B( 65 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 65 ) * B( 66 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 76 ) * B( 77 )
      C( 10 , 11 ) = C( 10 , 11 ) + A( 88 ) * B( 89 )
!
      C( 10 , 12 ) = A( 46 ) * B( 67 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 47 ) * B( 68 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 48 ) * B( 69 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 49 ) * B( 70 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 50 ) * B( 71 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 51 ) * B( 72 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 52 ) * B( 73 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 53 ) * B( 74 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 54 ) * B( 75 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 55 ) * B( 76 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 65 ) * B( 77 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 76 ) * B( 78 )
      C( 10 , 12 ) = C( 10 , 12 ) + A( 88 ) * B( 90 )
!
      C( 10 , 13 ) = A( 46 ) * B( 79 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 47 ) * B( 80 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 48 ) * B( 81 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 49 ) * B( 82 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 50 ) * B( 83 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 51 ) * B( 84 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 52 ) * B( 85 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 53 ) * B( 86 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 54 ) * B( 87 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 55 ) * B( 88 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 65 ) * B( 89 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 76 ) * B( 90 )
      C( 10 , 13 ) = C( 10 , 13 ) + A( 88 ) * B( 91 )
!
      C( 11 , 1 ) = A( 56 ) * B( 1 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 57 ) * B( 2 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 58 ) * B( 4 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 59 ) * B( 7 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 60 ) * B( 11 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 61 ) * B( 16 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 62 ) * B( 22 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 63 ) * B( 29 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 64 ) * B( 37 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 65 ) * B( 46 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 66 ) * B( 56 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 77 ) * B( 67 )
      C( 11 , 1 ) = C( 11 , 1 ) + A( 89 ) * B( 79 )
!
      C( 11 , 2 ) = A( 56 ) * B( 2 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 57 ) * B( 3 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 58 ) * B( 5 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 59 ) * B( 8 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 60 ) * B( 12 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 61 ) * B( 17 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 62 ) * B( 23 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 63 ) * B( 30 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 64 ) * B( 38 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 65 ) * B( 47 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 66 ) * B( 57 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 77 ) * B( 68 )
      C( 11 , 2 ) = C( 11 , 2 ) + A( 89 ) * B( 80 )
!
      C( 11 , 3 ) = A( 56 ) * B( 4 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 57 ) * B( 5 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 58 ) * B( 6 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 59 ) * B( 9 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 60 ) * B( 13 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 61 ) * B( 18 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 62 ) * B( 24 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 63 ) * B( 31 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 64 ) * B( 39 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 65 ) * B( 48 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 66 ) * B( 58 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 77 ) * B( 69 )
      C( 11 , 3 ) = C( 11 , 3 ) + A( 89 ) * B( 81 )
!
      C( 11 , 4 ) = A( 56 ) * B( 7 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 57 ) * B( 8 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 58 ) * B( 9 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 59 ) * B( 10 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 60 ) * B( 14 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 61 ) * B( 19 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 62 ) * B( 25 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 63 ) * B( 32 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 64 ) * B( 40 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 65 ) * B( 49 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 66 ) * B( 59 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 77 ) * B( 70 )
      C( 11 , 4 ) = C( 11 , 4 ) + A( 89 ) * B( 82 )
!
      C( 11 , 5 ) = A( 56 ) * B( 11 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 57 ) * B( 12 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 58 ) * B( 13 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 59 ) * B( 14 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 60 ) * B( 15 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 61 ) * B( 20 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 62 ) * B( 26 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 63 ) * B( 33 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 64 ) * B( 41 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 65 ) * B( 50 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 66 ) * B( 60 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 77 ) * B( 71 )
      C( 11 , 5 ) = C( 11 , 5 ) + A( 89 ) * B( 83 )
!
      C( 11 , 6 ) = A( 56 ) * B( 16 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 57 ) * B( 17 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 58 ) * B( 18 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 59 ) * B( 19 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 60 ) * B( 20 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 61 ) * B( 21 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 62 ) * B( 27 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 63 ) * B( 34 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 64 ) * B( 42 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 65 ) * B( 51 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 66 ) * B( 61 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 77 ) * B( 72 )
      C( 11 , 6 ) = C( 11 , 6 ) + A( 89 ) * B( 84 )
!
      C( 11 , 7 ) = A( 56 ) * B( 22 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 57 ) * B( 23 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 58 ) * B( 24 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 59 ) * B( 25 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 60 ) * B( 26 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 61 ) * B( 27 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 62 ) * B( 28 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 63 ) * B( 35 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 64 ) * B( 43 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 65 ) * B( 52 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 66 ) * B( 62 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 77 ) * B( 73 )
      C( 11 , 7 ) = C( 11 , 7 ) + A( 89 ) * B( 85 )
!
      C( 11 , 8 ) = A( 56 ) * B( 29 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 57 ) * B( 30 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 58 ) * B( 31 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 59 ) * B( 32 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 60 ) * B( 33 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 61 ) * B( 34 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 62 ) * B( 35 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 63 ) * B( 36 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 64 ) * B( 44 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 65 ) * B( 53 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 66 ) * B( 63 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 77 ) * B( 74 )
      C( 11 , 8 ) = C( 11 , 8 ) + A( 89 ) * B( 86 )
!
      C( 11 , 9 ) = A( 56 ) * B( 37 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 57 ) * B( 38 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 58 ) * B( 39 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 59 ) * B( 40 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 60 ) * B( 41 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 61 ) * B( 42 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 62 ) * B( 43 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 63 ) * B( 44 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 64 ) * B( 45 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 65 ) * B( 54 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 66 ) * B( 64 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 77 ) * B( 75 )
      C( 11 , 9 ) = C( 11 , 9 ) + A( 89 ) * B( 87 )
!
      C( 11 , 10 ) = A( 56 ) * B( 46 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 57 ) * B( 47 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 58 ) * B( 48 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 59 ) * B( 49 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 60 ) * B( 50 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 61 ) * B( 51 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 62 ) * B( 52 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 63 ) * B( 53 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 64 ) * B( 54 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 65 ) * B( 55 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 66 ) * B( 65 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 77 ) * B( 76 )
      C( 11 , 10 ) = C( 11 , 10 ) + A( 89 ) * B( 88 )
!
      C( 11 , 11 ) = A( 56 ) * B( 56 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 57 ) * B( 57 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 58 ) * B( 58 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 59 ) * B( 59 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 60 ) * B( 60 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 61 ) * B( 61 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 62 ) * B( 62 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 63 ) * B( 63 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 64 ) * B( 64 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 65 ) * B( 65 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 66 ) * B( 66 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 77 ) * B( 77 )
      C( 11 , 11 ) = C( 11 , 11 ) + A( 89 ) * B( 89 )
!
      C( 11 , 12 ) = A( 56 ) * B( 67 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 57 ) * B( 68 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 58 ) * B( 69 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 59 ) * B( 70 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 60 ) * B( 71 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 61 ) * B( 72 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 62 ) * B( 73 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 63 ) * B( 74 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 64 ) * B( 75 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 65 ) * B( 76 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 66 ) * B( 77 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 77 ) * B( 78 )
      C( 11 , 12 ) = C( 11 , 12 ) + A( 89 ) * B( 90 )
!
      C( 11 , 13 ) = A( 56 ) * B( 79 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 57 ) * B( 80 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 58 ) * B( 81 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 59 ) * B( 82 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 60 ) * B( 83 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 61 ) * B( 84 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 62 ) * B( 85 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 63 ) * B( 86 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 64 ) * B( 87 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 65 ) * B( 88 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 66 ) * B( 89 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 77 ) * B( 90 )
      C( 11 , 13 ) = C( 11 , 13 ) + A( 89 ) * B( 91 )
!
      C( 12 , 1 ) = A( 67 ) * B( 1 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 68 ) * B( 2 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 69 ) * B( 4 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 70 ) * B( 7 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 71 ) * B( 11 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 72 ) * B( 16 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 73 ) * B( 22 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 74 ) * B( 29 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 75 ) * B( 37 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 76 ) * B( 46 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 77 ) * B( 56 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 78 ) * B( 67 )
      C( 12 , 1 ) = C( 12 , 1 ) + A( 90 ) * B( 79 )
!
      C( 12 , 2 ) = A( 67 ) * B( 2 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 68 ) * B( 3 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 69 ) * B( 5 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 70 ) * B( 8 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 71 ) * B( 12 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 72 ) * B( 17 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 73 ) * B( 23 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 74 ) * B( 30 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 75 ) * B( 38 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 76 ) * B( 47 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 77 ) * B( 57 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 78 ) * B( 68 )
      C( 12 , 2 ) = C( 12 , 2 ) + A( 90 ) * B( 80 )
!
      C( 12 , 3 ) = A( 67 ) * B( 4 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 68 ) * B( 5 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 69 ) * B( 6 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 70 ) * B( 9 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 71 ) * B( 13 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 72 ) * B( 18 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 73 ) * B( 24 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 74 ) * B( 31 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 75 ) * B( 39 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 76 ) * B( 48 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 77 ) * B( 58 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 78 ) * B( 69 )
      C( 12 , 3 ) = C( 12 , 3 ) + A( 90 ) * B( 81 )
!
      C( 12 , 4 ) = A( 67 ) * B( 7 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 68 ) * B( 8 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 69 ) * B( 9 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 70 ) * B( 10 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 71 ) * B( 14 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 72 ) * B( 19 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 73 ) * B( 25 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 74 ) * B( 32 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 75 ) * B( 40 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 76 ) * B( 49 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 77 ) * B( 59 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 78 ) * B( 70 )
      C( 12 , 4 ) = C( 12 , 4 ) + A( 90 ) * B( 82 )
!
      C( 12 , 5 ) = A( 67 ) * B( 11 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 68 ) * B( 12 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 69 ) * B( 13 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 70 ) * B( 14 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 71 ) * B( 15 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 72 ) * B( 20 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 73 ) * B( 26 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 74 ) * B( 33 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 75 ) * B( 41 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 76 ) * B( 50 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 77 ) * B( 60 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 78 ) * B( 71 )
      C( 12 , 5 ) = C( 12 , 5 ) + A( 90 ) * B( 83 )
!
      C( 12 , 6 ) = A( 67 ) * B( 16 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 68 ) * B( 17 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 69 ) * B( 18 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 70 ) * B( 19 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 71 ) * B( 20 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 72 ) * B( 21 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 73 ) * B( 27 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 74 ) * B( 34 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 75 ) * B( 42 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 76 ) * B( 51 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 77 ) * B( 61 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 78 ) * B( 72 )
      C( 12 , 6 ) = C( 12 , 6 ) + A( 90 ) * B( 84 )
!
      C( 12 , 7 ) = A( 67 ) * B( 22 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 68 ) * B( 23 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 69 ) * B( 24 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 70 ) * B( 25 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 71 ) * B( 26 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 72 ) * B( 27 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 73 ) * B( 28 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 74 ) * B( 35 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 75 ) * B( 43 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 76 ) * B( 52 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 77 ) * B( 62 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 78 ) * B( 73 )
      C( 12 , 7 ) = C( 12 , 7 ) + A( 90 ) * B( 85 )
!
      C( 12 , 8 ) = A( 67 ) * B( 29 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 68 ) * B( 30 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 69 ) * B( 31 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 70 ) * B( 32 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 71 ) * B( 33 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 72 ) * B( 34 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 73 ) * B( 35 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 74 ) * B( 36 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 75 ) * B( 44 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 76 ) * B( 53 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 77 ) * B( 63 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 78 ) * B( 74 )
      C( 12 , 8 ) = C( 12 , 8 ) + A( 90 ) * B( 86 )
!
      C( 12 , 9 ) = A( 67 ) * B( 37 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 68 ) * B( 38 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 69 ) * B( 39 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 70 ) * B( 40 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 71 ) * B( 41 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 72 ) * B( 42 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 73 ) * B( 43 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 74 ) * B( 44 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 75 ) * B( 45 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 76 ) * B( 54 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 77 ) * B( 64 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 78 ) * B( 75 )
      C( 12 , 9 ) = C( 12 , 9 ) + A( 90 ) * B( 87 )
!
      C( 12 , 10 ) = A( 67 ) * B( 46 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 68 ) * B( 47 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 69 ) * B( 48 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 70 ) * B( 49 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 71 ) * B( 50 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 72 ) * B( 51 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 73 ) * B( 52 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 74 ) * B( 53 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 75 ) * B( 54 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 76 ) * B( 55 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 77 ) * B( 65 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 78 ) * B( 76 )
      C( 12 , 10 ) = C( 12 , 10 ) + A( 90 ) * B( 88 )
!
      C( 12 , 11 ) = A( 67 ) * B( 56 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 68 ) * B( 57 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 69 ) * B( 58 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 70 ) * B( 59 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 71 ) * B( 60 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 72 ) * B( 61 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 73 ) * B( 62 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 74 ) * B( 63 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 75 ) * B( 64 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 76 ) * B( 65 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 77 ) * B( 66 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 78 ) * B( 77 )
      C( 12 , 11 ) = C( 12 , 11 ) + A( 90 ) * B( 89 )
!
      C( 12 , 12 ) = A( 67 ) * B( 67 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 68 ) * B( 68 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 69 ) * B( 69 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 70 ) * B( 70 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 71 ) * B( 71 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 72 ) * B( 72 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 73 ) * B( 73 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 74 ) * B( 74 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 75 ) * B( 75 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 76 ) * B( 76 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 77 ) * B( 77 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 78 ) * B( 78 )
      C( 12 , 12 ) = C( 12 , 12 ) + A( 90 ) * B( 90 )
!
      C( 12 , 13 ) = A( 67 ) * B( 79 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 68 ) * B( 80 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 69 ) * B( 81 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 70 ) * B( 82 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 71 ) * B( 83 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 72 ) * B( 84 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 73 ) * B( 85 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 74 ) * B( 86 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 75 ) * B( 87 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 76 ) * B( 88 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 77 ) * B( 89 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 78 ) * B( 90 )
      C( 12 , 13 ) = C( 12 , 13 ) + A( 90 ) * B( 91 )
!
      C( 13 , 1 ) = A( 79 ) * B( 1 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 80 ) * B( 2 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 81 ) * B( 4 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 82 ) * B( 7 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 83 ) * B( 11 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 84 ) * B( 16 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 85 ) * B( 22 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 86 ) * B( 29 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 87 ) * B( 37 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 88 ) * B( 46 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 89 ) * B( 56 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 90 ) * B( 67 )
      C( 13 , 1 ) = C( 13 , 1 ) + A( 91 ) * B( 79 )
!
      C( 13 , 2 ) = A( 79 ) * B( 2 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 80 ) * B( 3 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 81 ) * B( 5 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 82 ) * B( 8 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 83 ) * B( 12 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 84 ) * B( 17 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 85 ) * B( 23 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 86 ) * B( 30 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 87 ) * B( 38 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 88 ) * B( 47 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 89 ) * B( 57 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 90 ) * B( 68 )
      C( 13 , 2 ) = C( 13 , 2 ) + A( 91 ) * B( 80 )
!
      C( 13 , 3 ) = A( 79 ) * B( 4 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 80 ) * B( 5 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 81 ) * B( 6 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 82 ) * B( 9 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 83 ) * B( 13 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 84 ) * B( 18 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 85 ) * B( 24 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 86 ) * B( 31 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 87 ) * B( 39 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 88 ) * B( 48 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 89 ) * B( 58 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 90 ) * B( 69 )
      C( 13 , 3 ) = C( 13 , 3 ) + A( 91 ) * B( 81 )
!
      C( 13 , 4 ) = A( 79 ) * B( 7 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 80 ) * B( 8 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 81 ) * B( 9 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 82 ) * B( 10 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 83 ) * B( 14 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 84 ) * B( 19 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 85 ) * B( 25 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 86 ) * B( 32 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 87 ) * B( 40 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 88 ) * B( 49 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 89 ) * B( 59 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 90 ) * B( 70 )
      C( 13 , 4 ) = C( 13 , 4 ) + A( 91 ) * B( 82 )
!
      C( 13 , 5 ) = A( 79 ) * B( 11 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 80 ) * B( 12 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 81 ) * B( 13 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 82 ) * B( 14 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 83 ) * B( 15 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 84 ) * B( 20 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 85 ) * B( 26 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 86 ) * B( 33 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 87 ) * B( 41 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 88 ) * B( 50 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 89 ) * B( 60 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 90 ) * B( 71 )
      C( 13 , 5 ) = C( 13 , 5 ) + A( 91 ) * B( 83 )
!
      C( 13 , 6 ) = A( 79 ) * B( 16 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 80 ) * B( 17 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 81 ) * B( 18 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 82 ) * B( 19 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 83 ) * B( 20 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 84 ) * B( 21 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 85 ) * B( 27 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 86 ) * B( 34 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 87 ) * B( 42 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 88 ) * B( 51 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 89 ) * B( 61 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 90 ) * B( 72 )
      C( 13 , 6 ) = C( 13 , 6 ) + A( 91 ) * B( 84 )
!
      C( 13 , 7 ) = A( 79 ) * B( 22 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 80 ) * B( 23 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 81 ) * B( 24 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 82 ) * B( 25 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 83 ) * B( 26 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 84 ) * B( 27 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 85 ) * B( 28 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 86 ) * B( 35 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 87 ) * B( 43 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 88 ) * B( 52 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 89 ) * B( 62 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 90 ) * B( 73 )
      C( 13 , 7 ) = C( 13 , 7 ) + A( 91 ) * B( 85 )
!
      C( 13 , 8 ) = A( 79 ) * B( 29 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 80 ) * B( 30 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 81 ) * B( 31 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 82 ) * B( 32 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 83 ) * B( 33 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 84 ) * B( 34 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 85 ) * B( 35 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 86 ) * B( 36 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 87 ) * B( 44 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 88 ) * B( 53 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 89 ) * B( 63 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 90 ) * B( 74 )
      C( 13 , 8 ) = C( 13 , 8 ) + A( 91 ) * B( 86 )
!
      C( 13 , 9 ) = A( 79 ) * B( 37 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 80 ) * B( 38 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 81 ) * B( 39 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 82 ) * B( 40 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 83 ) * B( 41 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 84 ) * B( 42 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 85 ) * B( 43 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 86 ) * B( 44 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 87 ) * B( 45 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 88 ) * B( 54 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 89 ) * B( 64 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 90 ) * B( 75 )
      C( 13 , 9 ) = C( 13 , 9 ) + A( 91 ) * B( 87 )
!
      C( 13 , 10 ) = A( 79 ) * B( 46 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 80 ) * B( 47 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 81 ) * B( 48 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 82 ) * B( 49 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 83 ) * B( 50 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 84 ) * B( 51 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 85 ) * B( 52 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 86 ) * B( 53 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 87 ) * B( 54 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 88 ) * B( 55 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 89 ) * B( 65 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 90 ) * B( 76 )
      C( 13 , 10 ) = C( 13 , 10 ) + A( 91 ) * B( 88 )
!
      C( 13 , 11 ) = A( 79 ) * B( 56 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 80 ) * B( 57 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 81 ) * B( 58 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 82 ) * B( 59 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 83 ) * B( 60 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 84 ) * B( 61 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 85 ) * B( 62 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 86 ) * B( 63 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 87 ) * B( 64 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 88 ) * B( 65 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 89 ) * B( 66 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 90 ) * B( 77 )
      C( 13 , 11 ) = C( 13 , 11 ) + A( 91 ) * B( 89 )
!
      C( 13 , 12 ) = A( 79 ) * B( 67 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 80 ) * B( 68 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 81 ) * B( 69 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 82 ) * B( 70 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 83 ) * B( 71 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 84 ) * B( 72 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 85 ) * B( 73 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 86 ) * B( 74 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 87 ) * B( 75 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 88 ) * B( 76 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 89 ) * B( 77 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 90 ) * B( 78 )
      C( 13 , 12 ) = C( 13 , 12 ) + A( 91 ) * B( 90 )
!
      C( 13 , 13 ) = A( 79 ) * B( 79 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 80 ) * B( 80 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 81 ) * B( 81 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 82 ) * B( 82 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 83 ) * B( 83 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 84 ) * B( 84 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 85 ) * B( 85 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 86 ) * B( 86 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 87 ) * B( 87 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 88 ) * B( 88 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 89 ) * B( 89 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 90 ) * B( 90 )
      C( 13 , 13 ) = C( 13 , 13 ) + A( 91 ) * B( 91 )
!
      RETURN
      END !#! SUBROUTINE MUL_MM_SS_I_13
