#include <mk5_preprocessor_directives.inc>
      SUBROUTINE MUL_MM_SS_S_16 ( A, B, C )
! ************************************************************************
! *                                                                      *
! *   Compute a product of two square symmetric matrices in upper        *
! *   triangular representation.                                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.12.14 ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), B(*), C(*)
!
      C( 1 ) = A( 1 ) * B( 1 )
      C( 1 ) = C( 1 ) + A( 2 ) * B( 2 )
      C( 1 ) = C( 1 ) + A( 4 ) * B( 4 )
      C( 1 ) = C( 1 ) + A( 7 ) * B( 7 )
      C( 1 ) = C( 1 ) + A( 11 ) * B( 11 )
      C( 1 ) = C( 1 ) + A( 16 ) * B( 16 )
      C( 1 ) = C( 1 ) + A( 22 ) * B( 22 )
      C( 1 ) = C( 1 ) + A( 29 ) * B( 29 )
      C( 1 ) = C( 1 ) + A( 37 ) * B( 37 )
      C( 1 ) = C( 1 ) + A( 46 ) * B( 46 )
      C( 1 ) = C( 1 ) + A( 56 ) * B( 56 )
      C( 1 ) = C( 1 ) + A( 67 ) * B( 67 )
      C( 1 ) = C( 1 ) + A( 79 ) * B( 79 )
      C( 1 ) = C( 1 ) + A( 92 ) * B( 92 )
      C( 1 ) = C( 1 ) + A( 106 ) * B( 106 )
      C( 1 ) = C( 1 ) + A( 121 ) * B( 121 )
!
      C( 2 ) = A( 2 ) * B( 1 )
      C( 2 ) = C( 2 ) + A( 3 ) * B( 2 )
      C( 2 ) = C( 2 ) + A( 5 ) * B( 4 )
      C( 2 ) = C( 2 ) + A( 8 ) * B( 7 )
      C( 2 ) = C( 2 ) + A( 12 ) * B( 11 )
      C( 2 ) = C( 2 ) + A( 17 ) * B( 16 )
      C( 2 ) = C( 2 ) + A( 23 ) * B( 22 )
      C( 2 ) = C( 2 ) + A( 30 ) * B( 29 )
      C( 2 ) = C( 2 ) + A( 38 ) * B( 37 )
      C( 2 ) = C( 2 ) + A( 47 ) * B( 46 )
      C( 2 ) = C( 2 ) + A( 57 ) * B( 56 )
      C( 2 ) = C( 2 ) + A( 68 ) * B( 67 )
      C( 2 ) = C( 2 ) + A( 80 ) * B( 79 )
      C( 2 ) = C( 2 ) + A( 93 ) * B( 92 )
      C( 2 ) = C( 2 ) + A( 107 ) * B( 106 )
      C( 2 ) = C( 2 ) + A( 122 ) * B( 121 )
!
      C( 3 ) = A( 2 ) * B( 2 )
      C( 3 ) = C( 3 ) + A( 3 ) * B( 3 )
      C( 3 ) = C( 3 ) + A( 5 ) * B( 5 )
      C( 3 ) = C( 3 ) + A( 8 ) * B( 8 )
      C( 3 ) = C( 3 ) + A( 12 ) * B( 12 )
      C( 3 ) = C( 3 ) + A( 17 ) * B( 17 )
      C( 3 ) = C( 3 ) + A( 23 ) * B( 23 )
      C( 3 ) = C( 3 ) + A( 30 ) * B( 30 )
      C( 3 ) = C( 3 ) + A( 38 ) * B( 38 )
      C( 3 ) = C( 3 ) + A( 47 ) * B( 47 )
      C( 3 ) = C( 3 ) + A( 57 ) * B( 57 )
      C( 3 ) = C( 3 ) + A( 68 ) * B( 68 )
      C( 3 ) = C( 3 ) + A( 80 ) * B( 80 )
      C( 3 ) = C( 3 ) + A( 93 ) * B( 93 )
      C( 3 ) = C( 3 ) + A( 107 ) * B( 107 )
      C( 3 ) = C( 3 ) + A( 122 ) * B( 122 )
!
      C( 4 ) = A( 4 ) * B( 1 )
      C( 4 ) = C( 4 ) + A( 5 ) * B( 2 )
      C( 4 ) = C( 4 ) + A( 6 ) * B( 4 )
      C( 4 ) = C( 4 ) + A( 9 ) * B( 7 )
      C( 4 ) = C( 4 ) + A( 13 ) * B( 11 )
      C( 4 ) = C( 4 ) + A( 18 ) * B( 16 )
      C( 4 ) = C( 4 ) + A( 24 ) * B( 22 )
      C( 4 ) = C( 4 ) + A( 31 ) * B( 29 )
      C( 4 ) = C( 4 ) + A( 39 ) * B( 37 )
      C( 4 ) = C( 4 ) + A( 48 ) * B( 46 )
      C( 4 ) = C( 4 ) + A( 58 ) * B( 56 )
      C( 4 ) = C( 4 ) + A( 69 ) * B( 67 )
      C( 4 ) = C( 4 ) + A( 81 ) * B( 79 )
      C( 4 ) = C( 4 ) + A( 94 ) * B( 92 )
      C( 4 ) = C( 4 ) + A( 108 ) * B( 106 )
      C( 4 ) = C( 4 ) + A( 123 ) * B( 121 )
!
      C( 5 ) = A( 4 ) * B( 2 )
      C( 5 ) = C( 5 ) + A( 5 ) * B( 3 )
      C( 5 ) = C( 5 ) + A( 6 ) * B( 5 )
      C( 5 ) = C( 5 ) + A( 9 ) * B( 8 )
      C( 5 ) = C( 5 ) + A( 13 ) * B( 12 )
      C( 5 ) = C( 5 ) + A( 18 ) * B( 17 )
      C( 5 ) = C( 5 ) + A( 24 ) * B( 23 )
      C( 5 ) = C( 5 ) + A( 31 ) * B( 30 )
      C( 5 ) = C( 5 ) + A( 39 ) * B( 38 )
      C( 5 ) = C( 5 ) + A( 48 ) * B( 47 )
      C( 5 ) = C( 5 ) + A( 58 ) * B( 57 )
      C( 5 ) = C( 5 ) + A( 69 ) * B( 68 )
      C( 5 ) = C( 5 ) + A( 81 ) * B( 80 )
      C( 5 ) = C( 5 ) + A( 94 ) * B( 93 )
      C( 5 ) = C( 5 ) + A( 108 ) * B( 107 )
      C( 5 ) = C( 5 ) + A( 123 ) * B( 122 )
!
      C( 6 ) = A( 4 ) * B( 4 )
      C( 6 ) = C( 6 ) + A( 5 ) * B( 5 )
      C( 6 ) = C( 6 ) + A( 6 ) * B( 6 )
      C( 6 ) = C( 6 ) + A( 9 ) * B( 9 )
      C( 6 ) = C( 6 ) + A( 13 ) * B( 13 )
      C( 6 ) = C( 6 ) + A( 18 ) * B( 18 )
      C( 6 ) = C( 6 ) + A( 24 ) * B( 24 )
      C( 6 ) = C( 6 ) + A( 31 ) * B( 31 )
      C( 6 ) = C( 6 ) + A( 39 ) * B( 39 )
      C( 6 ) = C( 6 ) + A( 48 ) * B( 48 )
      C( 6 ) = C( 6 ) + A( 58 ) * B( 58 )
      C( 6 ) = C( 6 ) + A( 69 ) * B( 69 )
      C( 6 ) = C( 6 ) + A( 81 ) * B( 81 )
      C( 6 ) = C( 6 ) + A( 94 ) * B( 94 )
      C( 6 ) = C( 6 ) + A( 108 ) * B( 108 )
      C( 6 ) = C( 6 ) + A( 123 ) * B( 123 )
!
      C( 7 ) = A( 7 ) * B( 1 )
      C( 7 ) = C( 7 ) + A( 8 ) * B( 2 )
      C( 7 ) = C( 7 ) + A( 9 ) * B( 4 )
      C( 7 ) = C( 7 ) + A( 10 ) * B( 7 )
      C( 7 ) = C( 7 ) + A( 14 ) * B( 11 )
      C( 7 ) = C( 7 ) + A( 19 ) * B( 16 )
      C( 7 ) = C( 7 ) + A( 25 ) * B( 22 )
      C( 7 ) = C( 7 ) + A( 32 ) * B( 29 )
      C( 7 ) = C( 7 ) + A( 40 ) * B( 37 )
      C( 7 ) = C( 7 ) + A( 49 ) * B( 46 )
      C( 7 ) = C( 7 ) + A( 59 ) * B( 56 )
      C( 7 ) = C( 7 ) + A( 70 ) * B( 67 )
      C( 7 ) = C( 7 ) + A( 82 ) * B( 79 )
      C( 7 ) = C( 7 ) + A( 95 ) * B( 92 )
      C( 7 ) = C( 7 ) + A( 109 ) * B( 106 )
      C( 7 ) = C( 7 ) + A( 124 ) * B( 121 )
!
      C( 8 ) = A( 7 ) * B( 2 )
      C( 8 ) = C( 8 ) + A( 8 ) * B( 3 )
      C( 8 ) = C( 8 ) + A( 9 ) * B( 5 )
      C( 8 ) = C( 8 ) + A( 10 ) * B( 8 )
      C( 8 ) = C( 8 ) + A( 14 ) * B( 12 )
      C( 8 ) = C( 8 ) + A( 19 ) * B( 17 )
      C( 8 ) = C( 8 ) + A( 25 ) * B( 23 )
      C( 8 ) = C( 8 ) + A( 32 ) * B( 30 )
      C( 8 ) = C( 8 ) + A( 40 ) * B( 38 )
      C( 8 ) = C( 8 ) + A( 49 ) * B( 47 )
      C( 8 ) = C( 8 ) + A( 59 ) * B( 57 )
      C( 8 ) = C( 8 ) + A( 70 ) * B( 68 )
      C( 8 ) = C( 8 ) + A( 82 ) * B( 80 )
      C( 8 ) = C( 8 ) + A( 95 ) * B( 93 )
      C( 8 ) = C( 8 ) + A( 109 ) * B( 107 )
      C( 8 ) = C( 8 ) + A( 124 ) * B( 122 )
!
      C( 9 ) = A( 7 ) * B( 4 )
      C( 9 ) = C( 9 ) + A( 8 ) * B( 5 )
      C( 9 ) = C( 9 ) + A( 9 ) * B( 6 )
      C( 9 ) = C( 9 ) + A( 10 ) * B( 9 )
      C( 9 ) = C( 9 ) + A( 14 ) * B( 13 )
      C( 9 ) = C( 9 ) + A( 19 ) * B( 18 )
      C( 9 ) = C( 9 ) + A( 25 ) * B( 24 )
      C( 9 ) = C( 9 ) + A( 32 ) * B( 31 )
      C( 9 ) = C( 9 ) + A( 40 ) * B( 39 )
      C( 9 ) = C( 9 ) + A( 49 ) * B( 48 )
      C( 9 ) = C( 9 ) + A( 59 ) * B( 58 )
      C( 9 ) = C( 9 ) + A( 70 ) * B( 69 )
      C( 9 ) = C( 9 ) + A( 82 ) * B( 81 )
      C( 9 ) = C( 9 ) + A( 95 ) * B( 94 )
      C( 9 ) = C( 9 ) + A( 109 ) * B( 108 )
      C( 9 ) = C( 9 ) + A( 124 ) * B( 123 )
!
      C( 10 ) = A( 7 ) * B( 7 )
      C( 10 ) = C( 10 ) + A( 8 ) * B( 8 )
      C( 10 ) = C( 10 ) + A( 9 ) * B( 9 )
      C( 10 ) = C( 10 ) + A( 10 ) * B( 10 )
      C( 10 ) = C( 10 ) + A( 14 ) * B( 14 )
      C( 10 ) = C( 10 ) + A( 19 ) * B( 19 )
      C( 10 ) = C( 10 ) + A( 25 ) * B( 25 )
      C( 10 ) = C( 10 ) + A( 32 ) * B( 32 )
      C( 10 ) = C( 10 ) + A( 40 ) * B( 40 )
      C( 10 ) = C( 10 ) + A( 49 ) * B( 49 )
      C( 10 ) = C( 10 ) + A( 59 ) * B( 59 )
      C( 10 ) = C( 10 ) + A( 70 ) * B( 70 )
      C( 10 ) = C( 10 ) + A( 82 ) * B( 82 )
      C( 10 ) = C( 10 ) + A( 95 ) * B( 95 )
      C( 10 ) = C( 10 ) + A( 109 ) * B( 109 )
      C( 10 ) = C( 10 ) + A( 124 ) * B( 124 )
!
      C( 11 ) = A( 11 ) * B( 1 )
      C( 11 ) = C( 11 ) + A( 12 ) * B( 2 )
      C( 11 ) = C( 11 ) + A( 13 ) * B( 4 )
      C( 11 ) = C( 11 ) + A( 14 ) * B( 7 )
      C( 11 ) = C( 11 ) + A( 15 ) * B( 11 )
      C( 11 ) = C( 11 ) + A( 20 ) * B( 16 )
      C( 11 ) = C( 11 ) + A( 26 ) * B( 22 )
      C( 11 ) = C( 11 ) + A( 33 ) * B( 29 )
      C( 11 ) = C( 11 ) + A( 41 ) * B( 37 )
      C( 11 ) = C( 11 ) + A( 50 ) * B( 46 )
      C( 11 ) = C( 11 ) + A( 60 ) * B( 56 )
      C( 11 ) = C( 11 ) + A( 71 ) * B( 67 )
      C( 11 ) = C( 11 ) + A( 83 ) * B( 79 )
      C( 11 ) = C( 11 ) + A( 96 ) * B( 92 )
      C( 11 ) = C( 11 ) + A( 110 ) * B( 106 )
      C( 11 ) = C( 11 ) + A( 125 ) * B( 121 )
!
      C( 12 ) = A( 11 ) * B( 2 )
      C( 12 ) = C( 12 ) + A( 12 ) * B( 3 )
      C( 12 ) = C( 12 ) + A( 13 ) * B( 5 )
      C( 12 ) = C( 12 ) + A( 14 ) * B( 8 )
      C( 12 ) = C( 12 ) + A( 15 ) * B( 12 )
      C( 12 ) = C( 12 ) + A( 20 ) * B( 17 )
      C( 12 ) = C( 12 ) + A( 26 ) * B( 23 )
      C( 12 ) = C( 12 ) + A( 33 ) * B( 30 )
      C( 12 ) = C( 12 ) + A( 41 ) * B( 38 )
      C( 12 ) = C( 12 ) + A( 50 ) * B( 47 )
      C( 12 ) = C( 12 ) + A( 60 ) * B( 57 )
      C( 12 ) = C( 12 ) + A( 71 ) * B( 68 )
      C( 12 ) = C( 12 ) + A( 83 ) * B( 80 )
      C( 12 ) = C( 12 ) + A( 96 ) * B( 93 )
      C( 12 ) = C( 12 ) + A( 110 ) * B( 107 )
      C( 12 ) = C( 12 ) + A( 125 ) * B( 122 )
!
      C( 13 ) = A( 11 ) * B( 4 )
      C( 13 ) = C( 13 ) + A( 12 ) * B( 5 )
      C( 13 ) = C( 13 ) + A( 13 ) * B( 6 )
      C( 13 ) = C( 13 ) + A( 14 ) * B( 9 )
      C( 13 ) = C( 13 ) + A( 15 ) * B( 13 )
      C( 13 ) = C( 13 ) + A( 20 ) * B( 18 )
      C( 13 ) = C( 13 ) + A( 26 ) * B( 24 )
      C( 13 ) = C( 13 ) + A( 33 ) * B( 31 )
      C( 13 ) = C( 13 ) + A( 41 ) * B( 39 )
      C( 13 ) = C( 13 ) + A( 50 ) * B( 48 )
      C( 13 ) = C( 13 ) + A( 60 ) * B( 58 )
      C( 13 ) = C( 13 ) + A( 71 ) * B( 69 )
      C( 13 ) = C( 13 ) + A( 83 ) * B( 81 )
      C( 13 ) = C( 13 ) + A( 96 ) * B( 94 )
      C( 13 ) = C( 13 ) + A( 110 ) * B( 108 )
      C( 13 ) = C( 13 ) + A( 125 ) * B( 123 )
!
      C( 14 ) = A( 11 ) * B( 7 )
      C( 14 ) = C( 14 ) + A( 12 ) * B( 8 )
      C( 14 ) = C( 14 ) + A( 13 ) * B( 9 )
      C( 14 ) = C( 14 ) + A( 14 ) * B( 10 )
      C( 14 ) = C( 14 ) + A( 15 ) * B( 14 )
      C( 14 ) = C( 14 ) + A( 20 ) * B( 19 )
      C( 14 ) = C( 14 ) + A( 26 ) * B( 25 )
      C( 14 ) = C( 14 ) + A( 33 ) * B( 32 )
      C( 14 ) = C( 14 ) + A( 41 ) * B( 40 )
      C( 14 ) = C( 14 ) + A( 50 ) * B( 49 )
      C( 14 ) = C( 14 ) + A( 60 ) * B( 59 )
      C( 14 ) = C( 14 ) + A( 71 ) * B( 70 )
      C( 14 ) = C( 14 ) + A( 83 ) * B( 82 )
      C( 14 ) = C( 14 ) + A( 96 ) * B( 95 )
      C( 14 ) = C( 14 ) + A( 110 ) * B( 109 )
      C( 14 ) = C( 14 ) + A( 125 ) * B( 124 )
!
      C( 15 ) = A( 11 ) * B( 11 )
      C( 15 ) = C( 15 ) + A( 12 ) * B( 12 )
      C( 15 ) = C( 15 ) + A( 13 ) * B( 13 )
      C( 15 ) = C( 15 ) + A( 14 ) * B( 14 )
      C( 15 ) = C( 15 ) + A( 15 ) * B( 15 )
      C( 15 ) = C( 15 ) + A( 20 ) * B( 20 )
      C( 15 ) = C( 15 ) + A( 26 ) * B( 26 )
      C( 15 ) = C( 15 ) + A( 33 ) * B( 33 )
      C( 15 ) = C( 15 ) + A( 41 ) * B( 41 )
      C( 15 ) = C( 15 ) + A( 50 ) * B( 50 )
      C( 15 ) = C( 15 ) + A( 60 ) * B( 60 )
      C( 15 ) = C( 15 ) + A( 71 ) * B( 71 )
      C( 15 ) = C( 15 ) + A( 83 ) * B( 83 )
      C( 15 ) = C( 15 ) + A( 96 ) * B( 96 )
      C( 15 ) = C( 15 ) + A( 110 ) * B( 110 )
      C( 15 ) = C( 15 ) + A( 125 ) * B( 125 )
!
      C( 16 ) = A( 16 ) * B( 1 )
      C( 16 ) = C( 16 ) + A( 17 ) * B( 2 )
      C( 16 ) = C( 16 ) + A( 18 ) * B( 4 )
      C( 16 ) = C( 16 ) + A( 19 ) * B( 7 )
      C( 16 ) = C( 16 ) + A( 20 ) * B( 11 )
      C( 16 ) = C( 16 ) + A( 21 ) * B( 16 )
      C( 16 ) = C( 16 ) + A( 27 ) * B( 22 )
      C( 16 ) = C( 16 ) + A( 34 ) * B( 29 )
      C( 16 ) = C( 16 ) + A( 42 ) * B( 37 )
      C( 16 ) = C( 16 ) + A( 51 ) * B( 46 )
      C( 16 ) = C( 16 ) + A( 61 ) * B( 56 )
      C( 16 ) = C( 16 ) + A( 72 ) * B( 67 )
      C( 16 ) = C( 16 ) + A( 84 ) * B( 79 )
      C( 16 ) = C( 16 ) + A( 97 ) * B( 92 )
      C( 16 ) = C( 16 ) + A( 111 ) * B( 106 )
      C( 16 ) = C( 16 ) + A( 126 ) * B( 121 )
!
      C( 17 ) = A( 16 ) * B( 2 )
      C( 17 ) = C( 17 ) + A( 17 ) * B( 3 )
      C( 17 ) = C( 17 ) + A( 18 ) * B( 5 )
      C( 17 ) = C( 17 ) + A( 19 ) * B( 8 )
      C( 17 ) = C( 17 ) + A( 20 ) * B( 12 )
      C( 17 ) = C( 17 ) + A( 21 ) * B( 17 )
      C( 17 ) = C( 17 ) + A( 27 ) * B( 23 )
      C( 17 ) = C( 17 ) + A( 34 ) * B( 30 )
      C( 17 ) = C( 17 ) + A( 42 ) * B( 38 )
      C( 17 ) = C( 17 ) + A( 51 ) * B( 47 )
      C( 17 ) = C( 17 ) + A( 61 ) * B( 57 )
      C( 17 ) = C( 17 ) + A( 72 ) * B( 68 )
      C( 17 ) = C( 17 ) + A( 84 ) * B( 80 )
      C( 17 ) = C( 17 ) + A( 97 ) * B( 93 )
      C( 17 ) = C( 17 ) + A( 111 ) * B( 107 )
      C( 17 ) = C( 17 ) + A( 126 ) * B( 122 )
!
      C( 18 ) = A( 16 ) * B( 4 )
      C( 18 ) = C( 18 ) + A( 17 ) * B( 5 )
      C( 18 ) = C( 18 ) + A( 18 ) * B( 6 )
      C( 18 ) = C( 18 ) + A( 19 ) * B( 9 )
      C( 18 ) = C( 18 ) + A( 20 ) * B( 13 )
      C( 18 ) = C( 18 ) + A( 21 ) * B( 18 )
      C( 18 ) = C( 18 ) + A( 27 ) * B( 24 )
      C( 18 ) = C( 18 ) + A( 34 ) * B( 31 )
      C( 18 ) = C( 18 ) + A( 42 ) * B( 39 )
      C( 18 ) = C( 18 ) + A( 51 ) * B( 48 )
      C( 18 ) = C( 18 ) + A( 61 ) * B( 58 )
      C( 18 ) = C( 18 ) + A( 72 ) * B( 69 )
      C( 18 ) = C( 18 ) + A( 84 ) * B( 81 )
      C( 18 ) = C( 18 ) + A( 97 ) * B( 94 )
      C( 18 ) = C( 18 ) + A( 111 ) * B( 108 )
      C( 18 ) = C( 18 ) + A( 126 ) * B( 123 )
!
      C( 19 ) = A( 16 ) * B( 7 )
      C( 19 ) = C( 19 ) + A( 17 ) * B( 8 )
      C( 19 ) = C( 19 ) + A( 18 ) * B( 9 )
      C( 19 ) = C( 19 ) + A( 19 ) * B( 10 )
      C( 19 ) = C( 19 ) + A( 20 ) * B( 14 )
      C( 19 ) = C( 19 ) + A( 21 ) * B( 19 )
      C( 19 ) = C( 19 ) + A( 27 ) * B( 25 )
      C( 19 ) = C( 19 ) + A( 34 ) * B( 32 )
      C( 19 ) = C( 19 ) + A( 42 ) * B( 40 )
      C( 19 ) = C( 19 ) + A( 51 ) * B( 49 )
      C( 19 ) = C( 19 ) + A( 61 ) * B( 59 )
      C( 19 ) = C( 19 ) + A( 72 ) * B( 70 )
      C( 19 ) = C( 19 ) + A( 84 ) * B( 82 )
      C( 19 ) = C( 19 ) + A( 97 ) * B( 95 )
      C( 19 ) = C( 19 ) + A( 111 ) * B( 109 )
      C( 19 ) = C( 19 ) + A( 126 ) * B( 124 )
!
      C( 20 ) = A( 16 ) * B( 11 )
      C( 20 ) = C( 20 ) + A( 17 ) * B( 12 )
      C( 20 ) = C( 20 ) + A( 18 ) * B( 13 )
      C( 20 ) = C( 20 ) + A( 19 ) * B( 14 )
      C( 20 ) = C( 20 ) + A( 20 ) * B( 15 )
      C( 20 ) = C( 20 ) + A( 21 ) * B( 20 )
      C( 20 ) = C( 20 ) + A( 27 ) * B( 26 )
      C( 20 ) = C( 20 ) + A( 34 ) * B( 33 )
      C( 20 ) = C( 20 ) + A( 42 ) * B( 41 )
      C( 20 ) = C( 20 ) + A( 51 ) * B( 50 )
      C( 20 ) = C( 20 ) + A( 61 ) * B( 60 )
      C( 20 ) = C( 20 ) + A( 72 ) * B( 71 )
      C( 20 ) = C( 20 ) + A( 84 ) * B( 83 )
      C( 20 ) = C( 20 ) + A( 97 ) * B( 96 )
      C( 20 ) = C( 20 ) + A( 111 ) * B( 110 )
      C( 20 ) = C( 20 ) + A( 126 ) * B( 125 )
!
      C( 21 ) = A( 16 ) * B( 16 )
      C( 21 ) = C( 21 ) + A( 17 ) * B( 17 )
      C( 21 ) = C( 21 ) + A( 18 ) * B( 18 )
      C( 21 ) = C( 21 ) + A( 19 ) * B( 19 )
      C( 21 ) = C( 21 ) + A( 20 ) * B( 20 )
      C( 21 ) = C( 21 ) + A( 21 ) * B( 21 )
      C( 21 ) = C( 21 ) + A( 27 ) * B( 27 )
      C( 21 ) = C( 21 ) + A( 34 ) * B( 34 )
      C( 21 ) = C( 21 ) + A( 42 ) * B( 42 )
      C( 21 ) = C( 21 ) + A( 51 ) * B( 51 )
      C( 21 ) = C( 21 ) + A( 61 ) * B( 61 )
      C( 21 ) = C( 21 ) + A( 72 ) * B( 72 )
      C( 21 ) = C( 21 ) + A( 84 ) * B( 84 )
      C( 21 ) = C( 21 ) + A( 97 ) * B( 97 )
      C( 21 ) = C( 21 ) + A( 111 ) * B( 111 )
      C( 21 ) = C( 21 ) + A( 126 ) * B( 126 )
!
      C( 22 ) = A( 22 ) * B( 1 )
      C( 22 ) = C( 22 ) + A( 23 ) * B( 2 )
      C( 22 ) = C( 22 ) + A( 24 ) * B( 4 )
      C( 22 ) = C( 22 ) + A( 25 ) * B( 7 )
      C( 22 ) = C( 22 ) + A( 26 ) * B( 11 )
      C( 22 ) = C( 22 ) + A( 27 ) * B( 16 )
      C( 22 ) = C( 22 ) + A( 28 ) * B( 22 )
      C( 22 ) = C( 22 ) + A( 35 ) * B( 29 )
      C( 22 ) = C( 22 ) + A( 43 ) * B( 37 )
      C( 22 ) = C( 22 ) + A( 52 ) * B( 46 )
      C( 22 ) = C( 22 ) + A( 62 ) * B( 56 )
      C( 22 ) = C( 22 ) + A( 73 ) * B( 67 )
      C( 22 ) = C( 22 ) + A( 85 ) * B( 79 )
      C( 22 ) = C( 22 ) + A( 98 ) * B( 92 )
      C( 22 ) = C( 22 ) + A( 112 ) * B( 106 )
      C( 22 ) = C( 22 ) + A( 127 ) * B( 121 )
!
      C( 23 ) = A( 22 ) * B( 2 )
      C( 23 ) = C( 23 ) + A( 23 ) * B( 3 )
      C( 23 ) = C( 23 ) + A( 24 ) * B( 5 )
      C( 23 ) = C( 23 ) + A( 25 ) * B( 8 )
      C( 23 ) = C( 23 ) + A( 26 ) * B( 12 )
      C( 23 ) = C( 23 ) + A( 27 ) * B( 17 )
      C( 23 ) = C( 23 ) + A( 28 ) * B( 23 )
      C( 23 ) = C( 23 ) + A( 35 ) * B( 30 )
      C( 23 ) = C( 23 ) + A( 43 ) * B( 38 )
      C( 23 ) = C( 23 ) + A( 52 ) * B( 47 )
      C( 23 ) = C( 23 ) + A( 62 ) * B( 57 )
      C( 23 ) = C( 23 ) + A( 73 ) * B( 68 )
      C( 23 ) = C( 23 ) + A( 85 ) * B( 80 )
      C( 23 ) = C( 23 ) + A( 98 ) * B( 93 )
      C( 23 ) = C( 23 ) + A( 112 ) * B( 107 )
      C( 23 ) = C( 23 ) + A( 127 ) * B( 122 )
!
      C( 24 ) = A( 22 ) * B( 4 )
      C( 24 ) = C( 24 ) + A( 23 ) * B( 5 )
      C( 24 ) = C( 24 ) + A( 24 ) * B( 6 )
      C( 24 ) = C( 24 ) + A( 25 ) * B( 9 )
      C( 24 ) = C( 24 ) + A( 26 ) * B( 13 )
      C( 24 ) = C( 24 ) + A( 27 ) * B( 18 )
      C( 24 ) = C( 24 ) + A( 28 ) * B( 24 )
      C( 24 ) = C( 24 ) + A( 35 ) * B( 31 )
      C( 24 ) = C( 24 ) + A( 43 ) * B( 39 )
      C( 24 ) = C( 24 ) + A( 52 ) * B( 48 )
      C( 24 ) = C( 24 ) + A( 62 ) * B( 58 )
      C( 24 ) = C( 24 ) + A( 73 ) * B( 69 )
      C( 24 ) = C( 24 ) + A( 85 ) * B( 81 )
      C( 24 ) = C( 24 ) + A( 98 ) * B( 94 )
      C( 24 ) = C( 24 ) + A( 112 ) * B( 108 )
      C( 24 ) = C( 24 ) + A( 127 ) * B( 123 )
!
      C( 25 ) = A( 22 ) * B( 7 )
      C( 25 ) = C( 25 ) + A( 23 ) * B( 8 )
      C( 25 ) = C( 25 ) + A( 24 ) * B( 9 )
      C( 25 ) = C( 25 ) + A( 25 ) * B( 10 )
      C( 25 ) = C( 25 ) + A( 26 ) * B( 14 )
      C( 25 ) = C( 25 ) + A( 27 ) * B( 19 )
      C( 25 ) = C( 25 ) + A( 28 ) * B( 25 )
      C( 25 ) = C( 25 ) + A( 35 ) * B( 32 )
      C( 25 ) = C( 25 ) + A( 43 ) * B( 40 )
      C( 25 ) = C( 25 ) + A( 52 ) * B( 49 )
      C( 25 ) = C( 25 ) + A( 62 ) * B( 59 )
      C( 25 ) = C( 25 ) + A( 73 ) * B( 70 )
      C( 25 ) = C( 25 ) + A( 85 ) * B( 82 )
      C( 25 ) = C( 25 ) + A( 98 ) * B( 95 )
      C( 25 ) = C( 25 ) + A( 112 ) * B( 109 )
      C( 25 ) = C( 25 ) + A( 127 ) * B( 124 )
!
      C( 26 ) = A( 22 ) * B( 11 )
      C( 26 ) = C( 26 ) + A( 23 ) * B( 12 )
      C( 26 ) = C( 26 ) + A( 24 ) * B( 13 )
      C( 26 ) = C( 26 ) + A( 25 ) * B( 14 )
      C( 26 ) = C( 26 ) + A( 26 ) * B( 15 )
      C( 26 ) = C( 26 ) + A( 27 ) * B( 20 )
      C( 26 ) = C( 26 ) + A( 28 ) * B( 26 )
      C( 26 ) = C( 26 ) + A( 35 ) * B( 33 )
      C( 26 ) = C( 26 ) + A( 43 ) * B( 41 )
      C( 26 ) = C( 26 ) + A( 52 ) * B( 50 )
      C( 26 ) = C( 26 ) + A( 62 ) * B( 60 )
      C( 26 ) = C( 26 ) + A( 73 ) * B( 71 )
      C( 26 ) = C( 26 ) + A( 85 ) * B( 83 )
      C( 26 ) = C( 26 ) + A( 98 ) * B( 96 )
      C( 26 ) = C( 26 ) + A( 112 ) * B( 110 )
      C( 26 ) = C( 26 ) + A( 127 ) * B( 125 )
!
      C( 27 ) = A( 22 ) * B( 16 )
      C( 27 ) = C( 27 ) + A( 23 ) * B( 17 )
      C( 27 ) = C( 27 ) + A( 24 ) * B( 18 )
      C( 27 ) = C( 27 ) + A( 25 ) * B( 19 )
      C( 27 ) = C( 27 ) + A( 26 ) * B( 20 )
      C( 27 ) = C( 27 ) + A( 27 ) * B( 21 )
      C( 27 ) = C( 27 ) + A( 28 ) * B( 27 )
      C( 27 ) = C( 27 ) + A( 35 ) * B( 34 )
      C( 27 ) = C( 27 ) + A( 43 ) * B( 42 )
      C( 27 ) = C( 27 ) + A( 52 ) * B( 51 )
      C( 27 ) = C( 27 ) + A( 62 ) * B( 61 )
      C( 27 ) = C( 27 ) + A( 73 ) * B( 72 )
      C( 27 ) = C( 27 ) + A( 85 ) * B( 84 )
      C( 27 ) = C( 27 ) + A( 98 ) * B( 97 )
      C( 27 ) = C( 27 ) + A( 112 ) * B( 111 )
      C( 27 ) = C( 27 ) + A( 127 ) * B( 126 )
!
      C( 28 ) = A( 22 ) * B( 22 )
      C( 28 ) = C( 28 ) + A( 23 ) * B( 23 )
      C( 28 ) = C( 28 ) + A( 24 ) * B( 24 )
      C( 28 ) = C( 28 ) + A( 25 ) * B( 25 )
      C( 28 ) = C( 28 ) + A( 26 ) * B( 26 )
      C( 28 ) = C( 28 ) + A( 27 ) * B( 27 )
      C( 28 ) = C( 28 ) + A( 28 ) * B( 28 )
      C( 28 ) = C( 28 ) + A( 35 ) * B( 35 )
      C( 28 ) = C( 28 ) + A( 43 ) * B( 43 )
      C( 28 ) = C( 28 ) + A( 52 ) * B( 52 )
      C( 28 ) = C( 28 ) + A( 62 ) * B( 62 )
      C( 28 ) = C( 28 ) + A( 73 ) * B( 73 )
      C( 28 ) = C( 28 ) + A( 85 ) * B( 85 )
      C( 28 ) = C( 28 ) + A( 98 ) * B( 98 )
      C( 28 ) = C( 28 ) + A( 112 ) * B( 112 )
      C( 28 ) = C( 28 ) + A( 127 ) * B( 127 )
!
      C( 29 ) = A( 29 ) * B( 1 )
      C( 29 ) = C( 29 ) + A( 30 ) * B( 2 )
      C( 29 ) = C( 29 ) + A( 31 ) * B( 4 )
      C( 29 ) = C( 29 ) + A( 32 ) * B( 7 )
      C( 29 ) = C( 29 ) + A( 33 ) * B( 11 )
      C( 29 ) = C( 29 ) + A( 34 ) * B( 16 )
      C( 29 ) = C( 29 ) + A( 35 ) * B( 22 )
      C( 29 ) = C( 29 ) + A( 36 ) * B( 29 )
      C( 29 ) = C( 29 ) + A( 44 ) * B( 37 )
      C( 29 ) = C( 29 ) + A( 53 ) * B( 46 )
      C( 29 ) = C( 29 ) + A( 63 ) * B( 56 )
      C( 29 ) = C( 29 ) + A( 74 ) * B( 67 )
      C( 29 ) = C( 29 ) + A( 86 ) * B( 79 )
      C( 29 ) = C( 29 ) + A( 99 ) * B( 92 )
      C( 29 ) = C( 29 ) + A( 113 ) * B( 106 )
      C( 29 ) = C( 29 ) + A( 128 ) * B( 121 )
!
      C( 30 ) = A( 29 ) * B( 2 )
      C( 30 ) = C( 30 ) + A( 30 ) * B( 3 )
      C( 30 ) = C( 30 ) + A( 31 ) * B( 5 )
      C( 30 ) = C( 30 ) + A( 32 ) * B( 8 )
      C( 30 ) = C( 30 ) + A( 33 ) * B( 12 )
      C( 30 ) = C( 30 ) + A( 34 ) * B( 17 )
      C( 30 ) = C( 30 ) + A( 35 ) * B( 23 )
      C( 30 ) = C( 30 ) + A( 36 ) * B( 30 )
      C( 30 ) = C( 30 ) + A( 44 ) * B( 38 )
      C( 30 ) = C( 30 ) + A( 53 ) * B( 47 )
      C( 30 ) = C( 30 ) + A( 63 ) * B( 57 )
      C( 30 ) = C( 30 ) + A( 74 ) * B( 68 )
      C( 30 ) = C( 30 ) + A( 86 ) * B( 80 )
      C( 30 ) = C( 30 ) + A( 99 ) * B( 93 )
      C( 30 ) = C( 30 ) + A( 113 ) * B( 107 )
      C( 30 ) = C( 30 ) + A( 128 ) * B( 122 )
!
      C( 31 ) = A( 29 ) * B( 4 )
      C( 31 ) = C( 31 ) + A( 30 ) * B( 5 )
      C( 31 ) = C( 31 ) + A( 31 ) * B( 6 )
      C( 31 ) = C( 31 ) + A( 32 ) * B( 9 )
      C( 31 ) = C( 31 ) + A( 33 ) * B( 13 )
      C( 31 ) = C( 31 ) + A( 34 ) * B( 18 )
      C( 31 ) = C( 31 ) + A( 35 ) * B( 24 )
      C( 31 ) = C( 31 ) + A( 36 ) * B( 31 )
      C( 31 ) = C( 31 ) + A( 44 ) * B( 39 )
      C( 31 ) = C( 31 ) + A( 53 ) * B( 48 )
      C( 31 ) = C( 31 ) + A( 63 ) * B( 58 )
      C( 31 ) = C( 31 ) + A( 74 ) * B( 69 )
      C( 31 ) = C( 31 ) + A( 86 ) * B( 81 )
      C( 31 ) = C( 31 ) + A( 99 ) * B( 94 )
      C( 31 ) = C( 31 ) + A( 113 ) * B( 108 )
      C( 31 ) = C( 31 ) + A( 128 ) * B( 123 )
!
      C( 32 ) = A( 29 ) * B( 7 )
      C( 32 ) = C( 32 ) + A( 30 ) * B( 8 )
      C( 32 ) = C( 32 ) + A( 31 ) * B( 9 )
      C( 32 ) = C( 32 ) + A( 32 ) * B( 10 )
      C( 32 ) = C( 32 ) + A( 33 ) * B( 14 )
      C( 32 ) = C( 32 ) + A( 34 ) * B( 19 )
      C( 32 ) = C( 32 ) + A( 35 ) * B( 25 )
      C( 32 ) = C( 32 ) + A( 36 ) * B( 32 )
      C( 32 ) = C( 32 ) + A( 44 ) * B( 40 )
      C( 32 ) = C( 32 ) + A( 53 ) * B( 49 )
      C( 32 ) = C( 32 ) + A( 63 ) * B( 59 )
      C( 32 ) = C( 32 ) + A( 74 ) * B( 70 )
      C( 32 ) = C( 32 ) + A( 86 ) * B( 82 )
      C( 32 ) = C( 32 ) + A( 99 ) * B( 95 )
      C( 32 ) = C( 32 ) + A( 113 ) * B( 109 )
      C( 32 ) = C( 32 ) + A( 128 ) * B( 124 )
!
      C( 33 ) = A( 29 ) * B( 11 )
      C( 33 ) = C( 33 ) + A( 30 ) * B( 12 )
      C( 33 ) = C( 33 ) + A( 31 ) * B( 13 )
      C( 33 ) = C( 33 ) + A( 32 ) * B( 14 )
      C( 33 ) = C( 33 ) + A( 33 ) * B( 15 )
      C( 33 ) = C( 33 ) + A( 34 ) * B( 20 )
      C( 33 ) = C( 33 ) + A( 35 ) * B( 26 )
      C( 33 ) = C( 33 ) + A( 36 ) * B( 33 )
      C( 33 ) = C( 33 ) + A( 44 ) * B( 41 )
      C( 33 ) = C( 33 ) + A( 53 ) * B( 50 )
      C( 33 ) = C( 33 ) + A( 63 ) * B( 60 )
      C( 33 ) = C( 33 ) + A( 74 ) * B( 71 )
      C( 33 ) = C( 33 ) + A( 86 ) * B( 83 )
      C( 33 ) = C( 33 ) + A( 99 ) * B( 96 )
      C( 33 ) = C( 33 ) + A( 113 ) * B( 110 )
      C( 33 ) = C( 33 ) + A( 128 ) * B( 125 )
!
      C( 34 ) = A( 29 ) * B( 16 )
      C( 34 ) = C( 34 ) + A( 30 ) * B( 17 )
      C( 34 ) = C( 34 ) + A( 31 ) * B( 18 )
      C( 34 ) = C( 34 ) + A( 32 ) * B( 19 )
      C( 34 ) = C( 34 ) + A( 33 ) * B( 20 )
      C( 34 ) = C( 34 ) + A( 34 ) * B( 21 )
      C( 34 ) = C( 34 ) + A( 35 ) * B( 27 )
      C( 34 ) = C( 34 ) + A( 36 ) * B( 34 )
      C( 34 ) = C( 34 ) + A( 44 ) * B( 42 )
      C( 34 ) = C( 34 ) + A( 53 ) * B( 51 )
      C( 34 ) = C( 34 ) + A( 63 ) * B( 61 )
      C( 34 ) = C( 34 ) + A( 74 ) * B( 72 )
      C( 34 ) = C( 34 ) + A( 86 ) * B( 84 )
      C( 34 ) = C( 34 ) + A( 99 ) * B( 97 )
      C( 34 ) = C( 34 ) + A( 113 ) * B( 111 )
      C( 34 ) = C( 34 ) + A( 128 ) * B( 126 )
!
      C( 35 ) = A( 29 ) * B( 22 )
      C( 35 ) = C( 35 ) + A( 30 ) * B( 23 )
      C( 35 ) = C( 35 ) + A( 31 ) * B( 24 )
      C( 35 ) = C( 35 ) + A( 32 ) * B( 25 )
      C( 35 ) = C( 35 ) + A( 33 ) * B( 26 )
      C( 35 ) = C( 35 ) + A( 34 ) * B( 27 )
      C( 35 ) = C( 35 ) + A( 35 ) * B( 28 )
      C( 35 ) = C( 35 ) + A( 36 ) * B( 35 )
      C( 35 ) = C( 35 ) + A( 44 ) * B( 43 )
      C( 35 ) = C( 35 ) + A( 53 ) * B( 52 )
      C( 35 ) = C( 35 ) + A( 63 ) * B( 62 )
      C( 35 ) = C( 35 ) + A( 74 ) * B( 73 )
      C( 35 ) = C( 35 ) + A( 86 ) * B( 85 )
      C( 35 ) = C( 35 ) + A( 99 ) * B( 98 )
      C( 35 ) = C( 35 ) + A( 113 ) * B( 112 )
      C( 35 ) = C( 35 ) + A( 128 ) * B( 127 )
!
      C( 36 ) = A( 29 ) * B( 29 )
      C( 36 ) = C( 36 ) + A( 30 ) * B( 30 )
      C( 36 ) = C( 36 ) + A( 31 ) * B( 31 )
      C( 36 ) = C( 36 ) + A( 32 ) * B( 32 )
      C( 36 ) = C( 36 ) + A( 33 ) * B( 33 )
      C( 36 ) = C( 36 ) + A( 34 ) * B( 34 )
      C( 36 ) = C( 36 ) + A( 35 ) * B( 35 )
      C( 36 ) = C( 36 ) + A( 36 ) * B( 36 )
      C( 36 ) = C( 36 ) + A( 44 ) * B( 44 )
      C( 36 ) = C( 36 ) + A( 53 ) * B( 53 )
      C( 36 ) = C( 36 ) + A( 63 ) * B( 63 )
      C( 36 ) = C( 36 ) + A( 74 ) * B( 74 )
      C( 36 ) = C( 36 ) + A( 86 ) * B( 86 )
      C( 36 ) = C( 36 ) + A( 99 ) * B( 99 )
      C( 36 ) = C( 36 ) + A( 113 ) * B( 113 )
      C( 36 ) = C( 36 ) + A( 128 ) * B( 128 )
!
      C( 37 ) = A( 37 ) * B( 1 )
      C( 37 ) = C( 37 ) + A( 38 ) * B( 2 )
      C( 37 ) = C( 37 ) + A( 39 ) * B( 4 )
      C( 37 ) = C( 37 ) + A( 40 ) * B( 7 )
      C( 37 ) = C( 37 ) + A( 41 ) * B( 11 )
      C( 37 ) = C( 37 ) + A( 42 ) * B( 16 )
      C( 37 ) = C( 37 ) + A( 43 ) * B( 22 )
      C( 37 ) = C( 37 ) + A( 44 ) * B( 29 )
      C( 37 ) = C( 37 ) + A( 45 ) * B( 37 )
      C( 37 ) = C( 37 ) + A( 54 ) * B( 46 )
      C( 37 ) = C( 37 ) + A( 64 ) * B( 56 )
      C( 37 ) = C( 37 ) + A( 75 ) * B( 67 )
      C( 37 ) = C( 37 ) + A( 87 ) * B( 79 )
      C( 37 ) = C( 37 ) + A( 100 ) * B( 92 )
      C( 37 ) = C( 37 ) + A( 114 ) * B( 106 )
      C( 37 ) = C( 37 ) + A( 129 ) * B( 121 )
!
      C( 38 ) = A( 37 ) * B( 2 )
      C( 38 ) = C( 38 ) + A( 38 ) * B( 3 )
      C( 38 ) = C( 38 ) + A( 39 ) * B( 5 )
      C( 38 ) = C( 38 ) + A( 40 ) * B( 8 )
      C( 38 ) = C( 38 ) + A( 41 ) * B( 12 )
      C( 38 ) = C( 38 ) + A( 42 ) * B( 17 )
      C( 38 ) = C( 38 ) + A( 43 ) * B( 23 )
      C( 38 ) = C( 38 ) + A( 44 ) * B( 30 )
      C( 38 ) = C( 38 ) + A( 45 ) * B( 38 )
      C( 38 ) = C( 38 ) + A( 54 ) * B( 47 )
      C( 38 ) = C( 38 ) + A( 64 ) * B( 57 )
      C( 38 ) = C( 38 ) + A( 75 ) * B( 68 )
      C( 38 ) = C( 38 ) + A( 87 ) * B( 80 )
      C( 38 ) = C( 38 ) + A( 100 ) * B( 93 )
      C( 38 ) = C( 38 ) + A( 114 ) * B( 107 )
      C( 38 ) = C( 38 ) + A( 129 ) * B( 122 )
!
      C( 39 ) = A( 37 ) * B( 4 )
      C( 39 ) = C( 39 ) + A( 38 ) * B( 5 )
      C( 39 ) = C( 39 ) + A( 39 ) * B( 6 )
      C( 39 ) = C( 39 ) + A( 40 ) * B( 9 )
      C( 39 ) = C( 39 ) + A( 41 ) * B( 13 )
      C( 39 ) = C( 39 ) + A( 42 ) * B( 18 )
      C( 39 ) = C( 39 ) + A( 43 ) * B( 24 )
      C( 39 ) = C( 39 ) + A( 44 ) * B( 31 )
      C( 39 ) = C( 39 ) + A( 45 ) * B( 39 )
      C( 39 ) = C( 39 ) + A( 54 ) * B( 48 )
      C( 39 ) = C( 39 ) + A( 64 ) * B( 58 )
      C( 39 ) = C( 39 ) + A( 75 ) * B( 69 )
      C( 39 ) = C( 39 ) + A( 87 ) * B( 81 )
      C( 39 ) = C( 39 ) + A( 100 ) * B( 94 )
      C( 39 ) = C( 39 ) + A( 114 ) * B( 108 )
      C( 39 ) = C( 39 ) + A( 129 ) * B( 123 )
!
      C( 40 ) = A( 37 ) * B( 7 )
      C( 40 ) = C( 40 ) + A( 38 ) * B( 8 )
      C( 40 ) = C( 40 ) + A( 39 ) * B( 9 )
      C( 40 ) = C( 40 ) + A( 40 ) * B( 10 )
      C( 40 ) = C( 40 ) + A( 41 ) * B( 14 )
      C( 40 ) = C( 40 ) + A( 42 ) * B( 19 )
      C( 40 ) = C( 40 ) + A( 43 ) * B( 25 )
      C( 40 ) = C( 40 ) + A( 44 ) * B( 32 )
      C( 40 ) = C( 40 ) + A( 45 ) * B( 40 )
      C( 40 ) = C( 40 ) + A( 54 ) * B( 49 )
      C( 40 ) = C( 40 ) + A( 64 ) * B( 59 )
      C( 40 ) = C( 40 ) + A( 75 ) * B( 70 )
      C( 40 ) = C( 40 ) + A( 87 ) * B( 82 )
      C( 40 ) = C( 40 ) + A( 100 ) * B( 95 )
      C( 40 ) = C( 40 ) + A( 114 ) * B( 109 )
      C( 40 ) = C( 40 ) + A( 129 ) * B( 124 )
!
      C( 41 ) = A( 37 ) * B( 11 )
      C( 41 ) = C( 41 ) + A( 38 ) * B( 12 )
      C( 41 ) = C( 41 ) + A( 39 ) * B( 13 )
      C( 41 ) = C( 41 ) + A( 40 ) * B( 14 )
      C( 41 ) = C( 41 ) + A( 41 ) * B( 15 )
      C( 41 ) = C( 41 ) + A( 42 ) * B( 20 )
      C( 41 ) = C( 41 ) + A( 43 ) * B( 26 )
      C( 41 ) = C( 41 ) + A( 44 ) * B( 33 )
      C( 41 ) = C( 41 ) + A( 45 ) * B( 41 )
      C( 41 ) = C( 41 ) + A( 54 ) * B( 50 )
      C( 41 ) = C( 41 ) + A( 64 ) * B( 60 )
      C( 41 ) = C( 41 ) + A( 75 ) * B( 71 )
      C( 41 ) = C( 41 ) + A( 87 ) * B( 83 )
      C( 41 ) = C( 41 ) + A( 100 ) * B( 96 )
      C( 41 ) = C( 41 ) + A( 114 ) * B( 110 )
      C( 41 ) = C( 41 ) + A( 129 ) * B( 125 )
!
      C( 42 ) = A( 37 ) * B( 16 )
      C( 42 ) = C( 42 ) + A( 38 ) * B( 17 )
      C( 42 ) = C( 42 ) + A( 39 ) * B( 18 )
      C( 42 ) = C( 42 ) + A( 40 ) * B( 19 )
      C( 42 ) = C( 42 ) + A( 41 ) * B( 20 )
      C( 42 ) = C( 42 ) + A( 42 ) * B( 21 )
      C( 42 ) = C( 42 ) + A( 43 ) * B( 27 )
      C( 42 ) = C( 42 ) + A( 44 ) * B( 34 )
      C( 42 ) = C( 42 ) + A( 45 ) * B( 42 )
      C( 42 ) = C( 42 ) + A( 54 ) * B( 51 )
      C( 42 ) = C( 42 ) + A( 64 ) * B( 61 )
      C( 42 ) = C( 42 ) + A( 75 ) * B( 72 )
      C( 42 ) = C( 42 ) + A( 87 ) * B( 84 )
      C( 42 ) = C( 42 ) + A( 100 ) * B( 97 )
      C( 42 ) = C( 42 ) + A( 114 ) * B( 111 )
      C( 42 ) = C( 42 ) + A( 129 ) * B( 126 )
!
      C( 43 ) = A( 37 ) * B( 22 )
      C( 43 ) = C( 43 ) + A( 38 ) * B( 23 )
      C( 43 ) = C( 43 ) + A( 39 ) * B( 24 )
      C( 43 ) = C( 43 ) + A( 40 ) * B( 25 )
      C( 43 ) = C( 43 ) + A( 41 ) * B( 26 )
      C( 43 ) = C( 43 ) + A( 42 ) * B( 27 )
      C( 43 ) = C( 43 ) + A( 43 ) * B( 28 )
      C( 43 ) = C( 43 ) + A( 44 ) * B( 35 )
      C( 43 ) = C( 43 ) + A( 45 ) * B( 43 )
      C( 43 ) = C( 43 ) + A( 54 ) * B( 52 )
      C( 43 ) = C( 43 ) + A( 64 ) * B( 62 )
      C( 43 ) = C( 43 ) + A( 75 ) * B( 73 )
      C( 43 ) = C( 43 ) + A( 87 ) * B( 85 )
      C( 43 ) = C( 43 ) + A( 100 ) * B( 98 )
      C( 43 ) = C( 43 ) + A( 114 ) * B( 112 )
      C( 43 ) = C( 43 ) + A( 129 ) * B( 127 )
!
      C( 44 ) = A( 37 ) * B( 29 )
      C( 44 ) = C( 44 ) + A( 38 ) * B( 30 )
      C( 44 ) = C( 44 ) + A( 39 ) * B( 31 )
      C( 44 ) = C( 44 ) + A( 40 ) * B( 32 )
      C( 44 ) = C( 44 ) + A( 41 ) * B( 33 )
      C( 44 ) = C( 44 ) + A( 42 ) * B( 34 )
      C( 44 ) = C( 44 ) + A( 43 ) * B( 35 )
      C( 44 ) = C( 44 ) + A( 44 ) * B( 36 )
      C( 44 ) = C( 44 ) + A( 45 ) * B( 44 )
      C( 44 ) = C( 44 ) + A( 54 ) * B( 53 )
      C( 44 ) = C( 44 ) + A( 64 ) * B( 63 )
      C( 44 ) = C( 44 ) + A( 75 ) * B( 74 )
      C( 44 ) = C( 44 ) + A( 87 ) * B( 86 )
      C( 44 ) = C( 44 ) + A( 100 ) * B( 99 )
      C( 44 ) = C( 44 ) + A( 114 ) * B( 113 )
      C( 44 ) = C( 44 ) + A( 129 ) * B( 128 )
!
      C( 45 ) = A( 37 ) * B( 37 )
      C( 45 ) = C( 45 ) + A( 38 ) * B( 38 )
      C( 45 ) = C( 45 ) + A( 39 ) * B( 39 )
      C( 45 ) = C( 45 ) + A( 40 ) * B( 40 )
      C( 45 ) = C( 45 ) + A( 41 ) * B( 41 )
      C( 45 ) = C( 45 ) + A( 42 ) * B( 42 )
      C( 45 ) = C( 45 ) + A( 43 ) * B( 43 )
      C( 45 ) = C( 45 ) + A( 44 ) * B( 44 )
      C( 45 ) = C( 45 ) + A( 45 ) * B( 45 )
      C( 45 ) = C( 45 ) + A( 54 ) * B( 54 )
      C( 45 ) = C( 45 ) + A( 64 ) * B( 64 )
      C( 45 ) = C( 45 ) + A( 75 ) * B( 75 )
      C( 45 ) = C( 45 ) + A( 87 ) * B( 87 )
      C( 45 ) = C( 45 ) + A( 100 ) * B( 100 )
      C( 45 ) = C( 45 ) + A( 114 ) * B( 114 )
      C( 45 ) = C( 45 ) + A( 129 ) * B( 129 )
!
      C( 46 ) = A( 46 ) * B( 1 )
      C( 46 ) = C( 46 ) + A( 47 ) * B( 2 )
      C( 46 ) = C( 46 ) + A( 48 ) * B( 4 )
      C( 46 ) = C( 46 ) + A( 49 ) * B( 7 )
      C( 46 ) = C( 46 ) + A( 50 ) * B( 11 )
      C( 46 ) = C( 46 ) + A( 51 ) * B( 16 )
      C( 46 ) = C( 46 ) + A( 52 ) * B( 22 )
      C( 46 ) = C( 46 ) + A( 53 ) * B( 29 )
      C( 46 ) = C( 46 ) + A( 54 ) * B( 37 )
      C( 46 ) = C( 46 ) + A( 55 ) * B( 46 )
      C( 46 ) = C( 46 ) + A( 65 ) * B( 56 )
      C( 46 ) = C( 46 ) + A( 76 ) * B( 67 )
      C( 46 ) = C( 46 ) + A( 88 ) * B( 79 )
      C( 46 ) = C( 46 ) + A( 101 ) * B( 92 )
      C( 46 ) = C( 46 ) + A( 115 ) * B( 106 )
      C( 46 ) = C( 46 ) + A( 130 ) * B( 121 )
!
      C( 47 ) = A( 46 ) * B( 2 )
      C( 47 ) = C( 47 ) + A( 47 ) * B( 3 )
      C( 47 ) = C( 47 ) + A( 48 ) * B( 5 )
      C( 47 ) = C( 47 ) + A( 49 ) * B( 8 )
      C( 47 ) = C( 47 ) + A( 50 ) * B( 12 )
      C( 47 ) = C( 47 ) + A( 51 ) * B( 17 )
      C( 47 ) = C( 47 ) + A( 52 ) * B( 23 )
      C( 47 ) = C( 47 ) + A( 53 ) * B( 30 )
      C( 47 ) = C( 47 ) + A( 54 ) * B( 38 )
      C( 47 ) = C( 47 ) + A( 55 ) * B( 47 )
      C( 47 ) = C( 47 ) + A( 65 ) * B( 57 )
      C( 47 ) = C( 47 ) + A( 76 ) * B( 68 )
      C( 47 ) = C( 47 ) + A( 88 ) * B( 80 )
      C( 47 ) = C( 47 ) + A( 101 ) * B( 93 )
      C( 47 ) = C( 47 ) + A( 115 ) * B( 107 )
      C( 47 ) = C( 47 ) + A( 130 ) * B( 122 )
!
      C( 48 ) = A( 46 ) * B( 4 )
      C( 48 ) = C( 48 ) + A( 47 ) * B( 5 )
      C( 48 ) = C( 48 ) + A( 48 ) * B( 6 )
      C( 48 ) = C( 48 ) + A( 49 ) * B( 9 )
      C( 48 ) = C( 48 ) + A( 50 ) * B( 13 )
      C( 48 ) = C( 48 ) + A( 51 ) * B( 18 )
      C( 48 ) = C( 48 ) + A( 52 ) * B( 24 )
      C( 48 ) = C( 48 ) + A( 53 ) * B( 31 )
      C( 48 ) = C( 48 ) + A( 54 ) * B( 39 )
      C( 48 ) = C( 48 ) + A( 55 ) * B( 48 )
      C( 48 ) = C( 48 ) + A( 65 ) * B( 58 )
      C( 48 ) = C( 48 ) + A( 76 ) * B( 69 )
      C( 48 ) = C( 48 ) + A( 88 ) * B( 81 )
      C( 48 ) = C( 48 ) + A( 101 ) * B( 94 )
      C( 48 ) = C( 48 ) + A( 115 ) * B( 108 )
      C( 48 ) = C( 48 ) + A( 130 ) * B( 123 )
!
      C( 49 ) = A( 46 ) * B( 7 )
      C( 49 ) = C( 49 ) + A( 47 ) * B( 8 )
      C( 49 ) = C( 49 ) + A( 48 ) * B( 9 )
      C( 49 ) = C( 49 ) + A( 49 ) * B( 10 )
      C( 49 ) = C( 49 ) + A( 50 ) * B( 14 )
      C( 49 ) = C( 49 ) + A( 51 ) * B( 19 )
      C( 49 ) = C( 49 ) + A( 52 ) * B( 25 )
      C( 49 ) = C( 49 ) + A( 53 ) * B( 32 )
      C( 49 ) = C( 49 ) + A( 54 ) * B( 40 )
      C( 49 ) = C( 49 ) + A( 55 ) * B( 49 )
      C( 49 ) = C( 49 ) + A( 65 ) * B( 59 )
      C( 49 ) = C( 49 ) + A( 76 ) * B( 70 )
      C( 49 ) = C( 49 ) + A( 88 ) * B( 82 )
      C( 49 ) = C( 49 ) + A( 101 ) * B( 95 )
      C( 49 ) = C( 49 ) + A( 115 ) * B( 109 )
      C( 49 ) = C( 49 ) + A( 130 ) * B( 124 )
!
      C( 50 ) = A( 46 ) * B( 11 )
      C( 50 ) = C( 50 ) + A( 47 ) * B( 12 )
      C( 50 ) = C( 50 ) + A( 48 ) * B( 13 )
      C( 50 ) = C( 50 ) + A( 49 ) * B( 14 )
      C( 50 ) = C( 50 ) + A( 50 ) * B( 15 )
      C( 50 ) = C( 50 ) + A( 51 ) * B( 20 )
      C( 50 ) = C( 50 ) + A( 52 ) * B( 26 )
      C( 50 ) = C( 50 ) + A( 53 ) * B( 33 )
      C( 50 ) = C( 50 ) + A( 54 ) * B( 41 )
      C( 50 ) = C( 50 ) + A( 55 ) * B( 50 )
      C( 50 ) = C( 50 ) + A( 65 ) * B( 60 )
      C( 50 ) = C( 50 ) + A( 76 ) * B( 71 )
      C( 50 ) = C( 50 ) + A( 88 ) * B( 83 )
      C( 50 ) = C( 50 ) + A( 101 ) * B( 96 )
      C( 50 ) = C( 50 ) + A( 115 ) * B( 110 )
      C( 50 ) = C( 50 ) + A( 130 ) * B( 125 )
!
      C( 51 ) = A( 46 ) * B( 16 )
      C( 51 ) = C( 51 ) + A( 47 ) * B( 17 )
      C( 51 ) = C( 51 ) + A( 48 ) * B( 18 )
      C( 51 ) = C( 51 ) + A( 49 ) * B( 19 )
      C( 51 ) = C( 51 ) + A( 50 ) * B( 20 )
      C( 51 ) = C( 51 ) + A( 51 ) * B( 21 )
      C( 51 ) = C( 51 ) + A( 52 ) * B( 27 )
      C( 51 ) = C( 51 ) + A( 53 ) * B( 34 )
      C( 51 ) = C( 51 ) + A( 54 ) * B( 42 )
      C( 51 ) = C( 51 ) + A( 55 ) * B( 51 )
      C( 51 ) = C( 51 ) + A( 65 ) * B( 61 )
      C( 51 ) = C( 51 ) + A( 76 ) * B( 72 )
      C( 51 ) = C( 51 ) + A( 88 ) * B( 84 )
      C( 51 ) = C( 51 ) + A( 101 ) * B( 97 )
      C( 51 ) = C( 51 ) + A( 115 ) * B( 111 )
      C( 51 ) = C( 51 ) + A( 130 ) * B( 126 )
!
      C( 52 ) = A( 46 ) * B( 22 )
      C( 52 ) = C( 52 ) + A( 47 ) * B( 23 )
      C( 52 ) = C( 52 ) + A( 48 ) * B( 24 )
      C( 52 ) = C( 52 ) + A( 49 ) * B( 25 )
      C( 52 ) = C( 52 ) + A( 50 ) * B( 26 )
      C( 52 ) = C( 52 ) + A( 51 ) * B( 27 )
      C( 52 ) = C( 52 ) + A( 52 ) * B( 28 )
      C( 52 ) = C( 52 ) + A( 53 ) * B( 35 )
      C( 52 ) = C( 52 ) + A( 54 ) * B( 43 )
      C( 52 ) = C( 52 ) + A( 55 ) * B( 52 )
      C( 52 ) = C( 52 ) + A( 65 ) * B( 62 )
      C( 52 ) = C( 52 ) + A( 76 ) * B( 73 )
      C( 52 ) = C( 52 ) + A( 88 ) * B( 85 )
      C( 52 ) = C( 52 ) + A( 101 ) * B( 98 )
      C( 52 ) = C( 52 ) + A( 115 ) * B( 112 )
      C( 52 ) = C( 52 ) + A( 130 ) * B( 127 )
!
      C( 53 ) = A( 46 ) * B( 29 )
      C( 53 ) = C( 53 ) + A( 47 ) * B( 30 )
      C( 53 ) = C( 53 ) + A( 48 ) * B( 31 )
      C( 53 ) = C( 53 ) + A( 49 ) * B( 32 )
      C( 53 ) = C( 53 ) + A( 50 ) * B( 33 )
      C( 53 ) = C( 53 ) + A( 51 ) * B( 34 )
      C( 53 ) = C( 53 ) + A( 52 ) * B( 35 )
      C( 53 ) = C( 53 ) + A( 53 ) * B( 36 )
      C( 53 ) = C( 53 ) + A( 54 ) * B( 44 )
      C( 53 ) = C( 53 ) + A( 55 ) * B( 53 )
      C( 53 ) = C( 53 ) + A( 65 ) * B( 63 )
      C( 53 ) = C( 53 ) + A( 76 ) * B( 74 )
      C( 53 ) = C( 53 ) + A( 88 ) * B( 86 )
      C( 53 ) = C( 53 ) + A( 101 ) * B( 99 )
      C( 53 ) = C( 53 ) + A( 115 ) * B( 113 )
      C( 53 ) = C( 53 ) + A( 130 ) * B( 128 )
!
      C( 54 ) = A( 46 ) * B( 37 )
      C( 54 ) = C( 54 ) + A( 47 ) * B( 38 )
      C( 54 ) = C( 54 ) + A( 48 ) * B( 39 )
      C( 54 ) = C( 54 ) + A( 49 ) * B( 40 )
      C( 54 ) = C( 54 ) + A( 50 ) * B( 41 )
      C( 54 ) = C( 54 ) + A( 51 ) * B( 42 )
      C( 54 ) = C( 54 ) + A( 52 ) * B( 43 )
      C( 54 ) = C( 54 ) + A( 53 ) * B( 44 )
      C( 54 ) = C( 54 ) + A( 54 ) * B( 45 )
      C( 54 ) = C( 54 ) + A( 55 ) * B( 54 )
      C( 54 ) = C( 54 ) + A( 65 ) * B( 64 )
      C( 54 ) = C( 54 ) + A( 76 ) * B( 75 )
      C( 54 ) = C( 54 ) + A( 88 ) * B( 87 )
      C( 54 ) = C( 54 ) + A( 101 ) * B( 100 )
      C( 54 ) = C( 54 ) + A( 115 ) * B( 114 )
      C( 54 ) = C( 54 ) + A( 130 ) * B( 129 )
!
      C( 55 ) = A( 46 ) * B( 46 )
      C( 55 ) = C( 55 ) + A( 47 ) * B( 47 )
      C( 55 ) = C( 55 ) + A( 48 ) * B( 48 )
      C( 55 ) = C( 55 ) + A( 49 ) * B( 49 )
      C( 55 ) = C( 55 ) + A( 50 ) * B( 50 )
      C( 55 ) = C( 55 ) + A( 51 ) * B( 51 )
      C( 55 ) = C( 55 ) + A( 52 ) * B( 52 )
      C( 55 ) = C( 55 ) + A( 53 ) * B( 53 )
      C( 55 ) = C( 55 ) + A( 54 ) * B( 54 )
      C( 55 ) = C( 55 ) + A( 55 ) * B( 55 )
      C( 55 ) = C( 55 ) + A( 65 ) * B( 65 )
      C( 55 ) = C( 55 ) + A( 76 ) * B( 76 )
      C( 55 ) = C( 55 ) + A( 88 ) * B( 88 )
      C( 55 ) = C( 55 ) + A( 101 ) * B( 101 )
      C( 55 ) = C( 55 ) + A( 115 ) * B( 115 )
      C( 55 ) = C( 55 ) + A( 130 ) * B( 130 )
!
      C( 56 ) = A( 56 ) * B( 1 )
      C( 56 ) = C( 56 ) + A( 57 ) * B( 2 )
      C( 56 ) = C( 56 ) + A( 58 ) * B( 4 )
      C( 56 ) = C( 56 ) + A( 59 ) * B( 7 )
      C( 56 ) = C( 56 ) + A( 60 ) * B( 11 )
      C( 56 ) = C( 56 ) + A( 61 ) * B( 16 )
      C( 56 ) = C( 56 ) + A( 62 ) * B( 22 )
      C( 56 ) = C( 56 ) + A( 63 ) * B( 29 )
      C( 56 ) = C( 56 ) + A( 64 ) * B( 37 )
      C( 56 ) = C( 56 ) + A( 65 ) * B( 46 )
      C( 56 ) = C( 56 ) + A( 66 ) * B( 56 )
      C( 56 ) = C( 56 ) + A( 77 ) * B( 67 )
      C( 56 ) = C( 56 ) + A( 89 ) * B( 79 )
      C( 56 ) = C( 56 ) + A( 102 ) * B( 92 )
      C( 56 ) = C( 56 ) + A( 116 ) * B( 106 )
      C( 56 ) = C( 56 ) + A( 131 ) * B( 121 )
!
      C( 57 ) = A( 56 ) * B( 2 )
      C( 57 ) = C( 57 ) + A( 57 ) * B( 3 )
      C( 57 ) = C( 57 ) + A( 58 ) * B( 5 )
      C( 57 ) = C( 57 ) + A( 59 ) * B( 8 )
      C( 57 ) = C( 57 ) + A( 60 ) * B( 12 )
      C( 57 ) = C( 57 ) + A( 61 ) * B( 17 )
      C( 57 ) = C( 57 ) + A( 62 ) * B( 23 )
      C( 57 ) = C( 57 ) + A( 63 ) * B( 30 )
      C( 57 ) = C( 57 ) + A( 64 ) * B( 38 )
      C( 57 ) = C( 57 ) + A( 65 ) * B( 47 )
      C( 57 ) = C( 57 ) + A( 66 ) * B( 57 )
      C( 57 ) = C( 57 ) + A( 77 ) * B( 68 )
      C( 57 ) = C( 57 ) + A( 89 ) * B( 80 )
      C( 57 ) = C( 57 ) + A( 102 ) * B( 93 )
      C( 57 ) = C( 57 ) + A( 116 ) * B( 107 )
      C( 57 ) = C( 57 ) + A( 131 ) * B( 122 )
!
      C( 58 ) = A( 56 ) * B( 4 )
      C( 58 ) = C( 58 ) + A( 57 ) * B( 5 )
      C( 58 ) = C( 58 ) + A( 58 ) * B( 6 )
      C( 58 ) = C( 58 ) + A( 59 ) * B( 9 )
      C( 58 ) = C( 58 ) + A( 60 ) * B( 13 )
      C( 58 ) = C( 58 ) + A( 61 ) * B( 18 )
      C( 58 ) = C( 58 ) + A( 62 ) * B( 24 )
      C( 58 ) = C( 58 ) + A( 63 ) * B( 31 )
      C( 58 ) = C( 58 ) + A( 64 ) * B( 39 )
      C( 58 ) = C( 58 ) + A( 65 ) * B( 48 )
      C( 58 ) = C( 58 ) + A( 66 ) * B( 58 )
      C( 58 ) = C( 58 ) + A( 77 ) * B( 69 )
      C( 58 ) = C( 58 ) + A( 89 ) * B( 81 )
      C( 58 ) = C( 58 ) + A( 102 ) * B( 94 )
      C( 58 ) = C( 58 ) + A( 116 ) * B( 108 )
      C( 58 ) = C( 58 ) + A( 131 ) * B( 123 )
!
      C( 59 ) = A( 56 ) * B( 7 )
      C( 59 ) = C( 59 ) + A( 57 ) * B( 8 )
      C( 59 ) = C( 59 ) + A( 58 ) * B( 9 )
      C( 59 ) = C( 59 ) + A( 59 ) * B( 10 )
      C( 59 ) = C( 59 ) + A( 60 ) * B( 14 )
      C( 59 ) = C( 59 ) + A( 61 ) * B( 19 )
      C( 59 ) = C( 59 ) + A( 62 ) * B( 25 )
      C( 59 ) = C( 59 ) + A( 63 ) * B( 32 )
      C( 59 ) = C( 59 ) + A( 64 ) * B( 40 )
      C( 59 ) = C( 59 ) + A( 65 ) * B( 49 )
      C( 59 ) = C( 59 ) + A( 66 ) * B( 59 )
      C( 59 ) = C( 59 ) + A( 77 ) * B( 70 )
      C( 59 ) = C( 59 ) + A( 89 ) * B( 82 )
      C( 59 ) = C( 59 ) + A( 102 ) * B( 95 )
      C( 59 ) = C( 59 ) + A( 116 ) * B( 109 )
      C( 59 ) = C( 59 ) + A( 131 ) * B( 124 )
!
      C( 60 ) = A( 56 ) * B( 11 )
      C( 60 ) = C( 60 ) + A( 57 ) * B( 12 )
      C( 60 ) = C( 60 ) + A( 58 ) * B( 13 )
      C( 60 ) = C( 60 ) + A( 59 ) * B( 14 )
      C( 60 ) = C( 60 ) + A( 60 ) * B( 15 )
      C( 60 ) = C( 60 ) + A( 61 ) * B( 20 )
      C( 60 ) = C( 60 ) + A( 62 ) * B( 26 )
      C( 60 ) = C( 60 ) + A( 63 ) * B( 33 )
      C( 60 ) = C( 60 ) + A( 64 ) * B( 41 )
      C( 60 ) = C( 60 ) + A( 65 ) * B( 50 )
      C( 60 ) = C( 60 ) + A( 66 ) * B( 60 )
      C( 60 ) = C( 60 ) + A( 77 ) * B( 71 )
      C( 60 ) = C( 60 ) + A( 89 ) * B( 83 )
      C( 60 ) = C( 60 ) + A( 102 ) * B( 96 )
      C( 60 ) = C( 60 ) + A( 116 ) * B( 110 )
      C( 60 ) = C( 60 ) + A( 131 ) * B( 125 )
!
      C( 61 ) = A( 56 ) * B( 16 )
      C( 61 ) = C( 61 ) + A( 57 ) * B( 17 )
      C( 61 ) = C( 61 ) + A( 58 ) * B( 18 )
      C( 61 ) = C( 61 ) + A( 59 ) * B( 19 )
      C( 61 ) = C( 61 ) + A( 60 ) * B( 20 )
      C( 61 ) = C( 61 ) + A( 61 ) * B( 21 )
      C( 61 ) = C( 61 ) + A( 62 ) * B( 27 )
      C( 61 ) = C( 61 ) + A( 63 ) * B( 34 )
      C( 61 ) = C( 61 ) + A( 64 ) * B( 42 )
      C( 61 ) = C( 61 ) + A( 65 ) * B( 51 )
      C( 61 ) = C( 61 ) + A( 66 ) * B( 61 )
      C( 61 ) = C( 61 ) + A( 77 ) * B( 72 )
      C( 61 ) = C( 61 ) + A( 89 ) * B( 84 )
      C( 61 ) = C( 61 ) + A( 102 ) * B( 97 )
      C( 61 ) = C( 61 ) + A( 116 ) * B( 111 )
      C( 61 ) = C( 61 ) + A( 131 ) * B( 126 )
!
      C( 62 ) = A( 56 ) * B( 22 )
      C( 62 ) = C( 62 ) + A( 57 ) * B( 23 )
      C( 62 ) = C( 62 ) + A( 58 ) * B( 24 )
      C( 62 ) = C( 62 ) + A( 59 ) * B( 25 )
      C( 62 ) = C( 62 ) + A( 60 ) * B( 26 )
      C( 62 ) = C( 62 ) + A( 61 ) * B( 27 )
      C( 62 ) = C( 62 ) + A( 62 ) * B( 28 )
      C( 62 ) = C( 62 ) + A( 63 ) * B( 35 )
      C( 62 ) = C( 62 ) + A( 64 ) * B( 43 )
      C( 62 ) = C( 62 ) + A( 65 ) * B( 52 )
      C( 62 ) = C( 62 ) + A( 66 ) * B( 62 )
      C( 62 ) = C( 62 ) + A( 77 ) * B( 73 )
      C( 62 ) = C( 62 ) + A( 89 ) * B( 85 )
      C( 62 ) = C( 62 ) + A( 102 ) * B( 98 )
      C( 62 ) = C( 62 ) + A( 116 ) * B( 112 )
      C( 62 ) = C( 62 ) + A( 131 ) * B( 127 )
!
      C( 63 ) = A( 56 ) * B( 29 )
      C( 63 ) = C( 63 ) + A( 57 ) * B( 30 )
      C( 63 ) = C( 63 ) + A( 58 ) * B( 31 )
      C( 63 ) = C( 63 ) + A( 59 ) * B( 32 )
      C( 63 ) = C( 63 ) + A( 60 ) * B( 33 )
      C( 63 ) = C( 63 ) + A( 61 ) * B( 34 )
      C( 63 ) = C( 63 ) + A( 62 ) * B( 35 )
      C( 63 ) = C( 63 ) + A( 63 ) * B( 36 )
      C( 63 ) = C( 63 ) + A( 64 ) * B( 44 )
      C( 63 ) = C( 63 ) + A( 65 ) * B( 53 )
      C( 63 ) = C( 63 ) + A( 66 ) * B( 63 )
      C( 63 ) = C( 63 ) + A( 77 ) * B( 74 )
      C( 63 ) = C( 63 ) + A( 89 ) * B( 86 )
      C( 63 ) = C( 63 ) + A( 102 ) * B( 99 )
      C( 63 ) = C( 63 ) + A( 116 ) * B( 113 )
      C( 63 ) = C( 63 ) + A( 131 ) * B( 128 )
!
      C( 64 ) = A( 56 ) * B( 37 )
      C( 64 ) = C( 64 ) + A( 57 ) * B( 38 )
      C( 64 ) = C( 64 ) + A( 58 ) * B( 39 )
      C( 64 ) = C( 64 ) + A( 59 ) * B( 40 )
      C( 64 ) = C( 64 ) + A( 60 ) * B( 41 )
      C( 64 ) = C( 64 ) + A( 61 ) * B( 42 )
      C( 64 ) = C( 64 ) + A( 62 ) * B( 43 )
      C( 64 ) = C( 64 ) + A( 63 ) * B( 44 )
      C( 64 ) = C( 64 ) + A( 64 ) * B( 45 )
      C( 64 ) = C( 64 ) + A( 65 ) * B( 54 )
      C( 64 ) = C( 64 ) + A( 66 ) * B( 64 )
      C( 64 ) = C( 64 ) + A( 77 ) * B( 75 )
      C( 64 ) = C( 64 ) + A( 89 ) * B( 87 )
      C( 64 ) = C( 64 ) + A( 102 ) * B( 100 )
      C( 64 ) = C( 64 ) + A( 116 ) * B( 114 )
      C( 64 ) = C( 64 ) + A( 131 ) * B( 129 )
!
      C( 65 ) = A( 56 ) * B( 46 )
      C( 65 ) = C( 65 ) + A( 57 ) * B( 47 )
      C( 65 ) = C( 65 ) + A( 58 ) * B( 48 )
      C( 65 ) = C( 65 ) + A( 59 ) * B( 49 )
      C( 65 ) = C( 65 ) + A( 60 ) * B( 50 )
      C( 65 ) = C( 65 ) + A( 61 ) * B( 51 )
      C( 65 ) = C( 65 ) + A( 62 ) * B( 52 )
      C( 65 ) = C( 65 ) + A( 63 ) * B( 53 )
      C( 65 ) = C( 65 ) + A( 64 ) * B( 54 )
      C( 65 ) = C( 65 ) + A( 65 ) * B( 55 )
      C( 65 ) = C( 65 ) + A( 66 ) * B( 65 )
      C( 65 ) = C( 65 ) + A( 77 ) * B( 76 )
      C( 65 ) = C( 65 ) + A( 89 ) * B( 88 )
      C( 65 ) = C( 65 ) + A( 102 ) * B( 101 )
      C( 65 ) = C( 65 ) + A( 116 ) * B( 115 )
      C( 65 ) = C( 65 ) + A( 131 ) * B( 130 )
!
      C( 66 ) = A( 56 ) * B( 56 )
      C( 66 ) = C( 66 ) + A( 57 ) * B( 57 )
      C( 66 ) = C( 66 ) + A( 58 ) * B( 58 )
      C( 66 ) = C( 66 ) + A( 59 ) * B( 59 )
      C( 66 ) = C( 66 ) + A( 60 ) * B( 60 )
      C( 66 ) = C( 66 ) + A( 61 ) * B( 61 )
      C( 66 ) = C( 66 ) + A( 62 ) * B( 62 )
      C( 66 ) = C( 66 ) + A( 63 ) * B( 63 )
      C( 66 ) = C( 66 ) + A( 64 ) * B( 64 )
      C( 66 ) = C( 66 ) + A( 65 ) * B( 65 )
      C( 66 ) = C( 66 ) + A( 66 ) * B( 66 )
      C( 66 ) = C( 66 ) + A( 77 ) * B( 77 )
      C( 66 ) = C( 66 ) + A( 89 ) * B( 89 )
      C( 66 ) = C( 66 ) + A( 102 ) * B( 102 )
      C( 66 ) = C( 66 ) + A( 116 ) * B( 116 )
      C( 66 ) = C( 66 ) + A( 131 ) * B( 131 )
!
      C( 67 ) = A( 67 ) * B( 1 )
      C( 67 ) = C( 67 ) + A( 68 ) * B( 2 )
      C( 67 ) = C( 67 ) + A( 69 ) * B( 4 )
      C( 67 ) = C( 67 ) + A( 70 ) * B( 7 )
      C( 67 ) = C( 67 ) + A( 71 ) * B( 11 )
      C( 67 ) = C( 67 ) + A( 72 ) * B( 16 )
      C( 67 ) = C( 67 ) + A( 73 ) * B( 22 )
      C( 67 ) = C( 67 ) + A( 74 ) * B( 29 )
      C( 67 ) = C( 67 ) + A( 75 ) * B( 37 )
      C( 67 ) = C( 67 ) + A( 76 ) * B( 46 )
      C( 67 ) = C( 67 ) + A( 77 ) * B( 56 )
      C( 67 ) = C( 67 ) + A( 78 ) * B( 67 )
      C( 67 ) = C( 67 ) + A( 90 ) * B( 79 )
      C( 67 ) = C( 67 ) + A( 103 ) * B( 92 )
      C( 67 ) = C( 67 ) + A( 117 ) * B( 106 )
      C( 67 ) = C( 67 ) + A( 132 ) * B( 121 )
!
      C( 68 ) = A( 67 ) * B( 2 )
      C( 68 ) = C( 68 ) + A( 68 ) * B( 3 )
      C( 68 ) = C( 68 ) + A( 69 ) * B( 5 )
      C( 68 ) = C( 68 ) + A( 70 ) * B( 8 )
      C( 68 ) = C( 68 ) + A( 71 ) * B( 12 )
      C( 68 ) = C( 68 ) + A( 72 ) * B( 17 )
      C( 68 ) = C( 68 ) + A( 73 ) * B( 23 )
      C( 68 ) = C( 68 ) + A( 74 ) * B( 30 )
      C( 68 ) = C( 68 ) + A( 75 ) * B( 38 )
      C( 68 ) = C( 68 ) + A( 76 ) * B( 47 )
      C( 68 ) = C( 68 ) + A( 77 ) * B( 57 )
      C( 68 ) = C( 68 ) + A( 78 ) * B( 68 )
      C( 68 ) = C( 68 ) + A( 90 ) * B( 80 )
      C( 68 ) = C( 68 ) + A( 103 ) * B( 93 )
      C( 68 ) = C( 68 ) + A( 117 ) * B( 107 )
      C( 68 ) = C( 68 ) + A( 132 ) * B( 122 )
!
      C( 69 ) = A( 67 ) * B( 4 )
      C( 69 ) = C( 69 ) + A( 68 ) * B( 5 )
      C( 69 ) = C( 69 ) + A( 69 ) * B( 6 )
      C( 69 ) = C( 69 ) + A( 70 ) * B( 9 )
      C( 69 ) = C( 69 ) + A( 71 ) * B( 13 )
      C( 69 ) = C( 69 ) + A( 72 ) * B( 18 )
      C( 69 ) = C( 69 ) + A( 73 ) * B( 24 )
      C( 69 ) = C( 69 ) + A( 74 ) * B( 31 )
      C( 69 ) = C( 69 ) + A( 75 ) * B( 39 )
      C( 69 ) = C( 69 ) + A( 76 ) * B( 48 )
      C( 69 ) = C( 69 ) + A( 77 ) * B( 58 )
      C( 69 ) = C( 69 ) + A( 78 ) * B( 69 )
      C( 69 ) = C( 69 ) + A( 90 ) * B( 81 )
      C( 69 ) = C( 69 ) + A( 103 ) * B( 94 )
      C( 69 ) = C( 69 ) + A( 117 ) * B( 108 )
      C( 69 ) = C( 69 ) + A( 132 ) * B( 123 )
!
      C( 70 ) = A( 67 ) * B( 7 )
      C( 70 ) = C( 70 ) + A( 68 ) * B( 8 )
      C( 70 ) = C( 70 ) + A( 69 ) * B( 9 )
      C( 70 ) = C( 70 ) + A( 70 ) * B( 10 )
      C( 70 ) = C( 70 ) + A( 71 ) * B( 14 )
      C( 70 ) = C( 70 ) + A( 72 ) * B( 19 )
      C( 70 ) = C( 70 ) + A( 73 ) * B( 25 )
      C( 70 ) = C( 70 ) + A( 74 ) * B( 32 )
      C( 70 ) = C( 70 ) + A( 75 ) * B( 40 )
      C( 70 ) = C( 70 ) + A( 76 ) * B( 49 )
      C( 70 ) = C( 70 ) + A( 77 ) * B( 59 )
      C( 70 ) = C( 70 ) + A( 78 ) * B( 70 )
      C( 70 ) = C( 70 ) + A( 90 ) * B( 82 )
      C( 70 ) = C( 70 ) + A( 103 ) * B( 95 )
      C( 70 ) = C( 70 ) + A( 117 ) * B( 109 )
      C( 70 ) = C( 70 ) + A( 132 ) * B( 124 )
!
      C( 71 ) = A( 67 ) * B( 11 )
      C( 71 ) = C( 71 ) + A( 68 ) * B( 12 )
      C( 71 ) = C( 71 ) + A( 69 ) * B( 13 )
      C( 71 ) = C( 71 ) + A( 70 ) * B( 14 )
      C( 71 ) = C( 71 ) + A( 71 ) * B( 15 )
      C( 71 ) = C( 71 ) + A( 72 ) * B( 20 )
      C( 71 ) = C( 71 ) + A( 73 ) * B( 26 )
      C( 71 ) = C( 71 ) + A( 74 ) * B( 33 )
      C( 71 ) = C( 71 ) + A( 75 ) * B( 41 )
      C( 71 ) = C( 71 ) + A( 76 ) * B( 50 )
      C( 71 ) = C( 71 ) + A( 77 ) * B( 60 )
      C( 71 ) = C( 71 ) + A( 78 ) * B( 71 )
      C( 71 ) = C( 71 ) + A( 90 ) * B( 83 )
      C( 71 ) = C( 71 ) + A( 103 ) * B( 96 )
      C( 71 ) = C( 71 ) + A( 117 ) * B( 110 )
      C( 71 ) = C( 71 ) + A( 132 ) * B( 125 )
!
      C( 72 ) = A( 67 ) * B( 16 )
      C( 72 ) = C( 72 ) + A( 68 ) * B( 17 )
      C( 72 ) = C( 72 ) + A( 69 ) * B( 18 )
      C( 72 ) = C( 72 ) + A( 70 ) * B( 19 )
      C( 72 ) = C( 72 ) + A( 71 ) * B( 20 )
      C( 72 ) = C( 72 ) + A( 72 ) * B( 21 )
      C( 72 ) = C( 72 ) + A( 73 ) * B( 27 )
      C( 72 ) = C( 72 ) + A( 74 ) * B( 34 )
      C( 72 ) = C( 72 ) + A( 75 ) * B( 42 )
      C( 72 ) = C( 72 ) + A( 76 ) * B( 51 )
      C( 72 ) = C( 72 ) + A( 77 ) * B( 61 )
      C( 72 ) = C( 72 ) + A( 78 ) * B( 72 )
      C( 72 ) = C( 72 ) + A( 90 ) * B( 84 )
      C( 72 ) = C( 72 ) + A( 103 ) * B( 97 )
      C( 72 ) = C( 72 ) + A( 117 ) * B( 111 )
      C( 72 ) = C( 72 ) + A( 132 ) * B( 126 )
!
      C( 73 ) = A( 67 ) * B( 22 )
      C( 73 ) = C( 73 ) + A( 68 ) * B( 23 )
      C( 73 ) = C( 73 ) + A( 69 ) * B( 24 )
      C( 73 ) = C( 73 ) + A( 70 ) * B( 25 )
      C( 73 ) = C( 73 ) + A( 71 ) * B( 26 )
      C( 73 ) = C( 73 ) + A( 72 ) * B( 27 )
      C( 73 ) = C( 73 ) + A( 73 ) * B( 28 )
      C( 73 ) = C( 73 ) + A( 74 ) * B( 35 )
      C( 73 ) = C( 73 ) + A( 75 ) * B( 43 )
      C( 73 ) = C( 73 ) + A( 76 ) * B( 52 )
      C( 73 ) = C( 73 ) + A( 77 ) * B( 62 )
      C( 73 ) = C( 73 ) + A( 78 ) * B( 73 )
      C( 73 ) = C( 73 ) + A( 90 ) * B( 85 )
      C( 73 ) = C( 73 ) + A( 103 ) * B( 98 )
      C( 73 ) = C( 73 ) + A( 117 ) * B( 112 )
      C( 73 ) = C( 73 ) + A( 132 ) * B( 127 )
!
      C( 74 ) = A( 67 ) * B( 29 )
      C( 74 ) = C( 74 ) + A( 68 ) * B( 30 )
      C( 74 ) = C( 74 ) + A( 69 ) * B( 31 )
      C( 74 ) = C( 74 ) + A( 70 ) * B( 32 )
      C( 74 ) = C( 74 ) + A( 71 ) * B( 33 )
      C( 74 ) = C( 74 ) + A( 72 ) * B( 34 )
      C( 74 ) = C( 74 ) + A( 73 ) * B( 35 )
      C( 74 ) = C( 74 ) + A( 74 ) * B( 36 )
      C( 74 ) = C( 74 ) + A( 75 ) * B( 44 )
      C( 74 ) = C( 74 ) + A( 76 ) * B( 53 )
      C( 74 ) = C( 74 ) + A( 77 ) * B( 63 )
      C( 74 ) = C( 74 ) + A( 78 ) * B( 74 )
      C( 74 ) = C( 74 ) + A( 90 ) * B( 86 )
      C( 74 ) = C( 74 ) + A( 103 ) * B( 99 )
      C( 74 ) = C( 74 ) + A( 117 ) * B( 113 )
      C( 74 ) = C( 74 ) + A( 132 ) * B( 128 )
!
      C( 75 ) = A( 67 ) * B( 37 )
      C( 75 ) = C( 75 ) + A( 68 ) * B( 38 )
      C( 75 ) = C( 75 ) + A( 69 ) * B( 39 )
      C( 75 ) = C( 75 ) + A( 70 ) * B( 40 )
      C( 75 ) = C( 75 ) + A( 71 ) * B( 41 )
      C( 75 ) = C( 75 ) + A( 72 ) * B( 42 )
      C( 75 ) = C( 75 ) + A( 73 ) * B( 43 )
      C( 75 ) = C( 75 ) + A( 74 ) * B( 44 )
      C( 75 ) = C( 75 ) + A( 75 ) * B( 45 )
      C( 75 ) = C( 75 ) + A( 76 ) * B( 54 )
      C( 75 ) = C( 75 ) + A( 77 ) * B( 64 )
      C( 75 ) = C( 75 ) + A( 78 ) * B( 75 )
      C( 75 ) = C( 75 ) + A( 90 ) * B( 87 )
      C( 75 ) = C( 75 ) + A( 103 ) * B( 100 )
      C( 75 ) = C( 75 ) + A( 117 ) * B( 114 )
      C( 75 ) = C( 75 ) + A( 132 ) * B( 129 )
!
      C( 76 ) = A( 67 ) * B( 46 )
      C( 76 ) = C( 76 ) + A( 68 ) * B( 47 )
      C( 76 ) = C( 76 ) + A( 69 ) * B( 48 )
      C( 76 ) = C( 76 ) + A( 70 ) * B( 49 )
      C( 76 ) = C( 76 ) + A( 71 ) * B( 50 )
      C( 76 ) = C( 76 ) + A( 72 ) * B( 51 )
      C( 76 ) = C( 76 ) + A( 73 ) * B( 52 )
      C( 76 ) = C( 76 ) + A( 74 ) * B( 53 )
      C( 76 ) = C( 76 ) + A( 75 ) * B( 54 )
      C( 76 ) = C( 76 ) + A( 76 ) * B( 55 )
      C( 76 ) = C( 76 ) + A( 77 ) * B( 65 )
      C( 76 ) = C( 76 ) + A( 78 ) * B( 76 )
      C( 76 ) = C( 76 ) + A( 90 ) * B( 88 )
      C( 76 ) = C( 76 ) + A( 103 ) * B( 101 )
      C( 76 ) = C( 76 ) + A( 117 ) * B( 115 )
      C( 76 ) = C( 76 ) + A( 132 ) * B( 130 )
!
      C( 77 ) = A( 67 ) * B( 56 )
      C( 77 ) = C( 77 ) + A( 68 ) * B( 57 )
      C( 77 ) = C( 77 ) + A( 69 ) * B( 58 )
      C( 77 ) = C( 77 ) + A( 70 ) * B( 59 )
      C( 77 ) = C( 77 ) + A( 71 ) * B( 60 )
      C( 77 ) = C( 77 ) + A( 72 ) * B( 61 )
      C( 77 ) = C( 77 ) + A( 73 ) * B( 62 )
      C( 77 ) = C( 77 ) + A( 74 ) * B( 63 )
      C( 77 ) = C( 77 ) + A( 75 ) * B( 64 )
      C( 77 ) = C( 77 ) + A( 76 ) * B( 65 )
      C( 77 ) = C( 77 ) + A( 77 ) * B( 66 )
      C( 77 ) = C( 77 ) + A( 78 ) * B( 77 )
      C( 77 ) = C( 77 ) + A( 90 ) * B( 89 )
      C( 77 ) = C( 77 ) + A( 103 ) * B( 102 )
      C( 77 ) = C( 77 ) + A( 117 ) * B( 116 )
      C( 77 ) = C( 77 ) + A( 132 ) * B( 131 )
!
      C( 78 ) = A( 67 ) * B( 67 )
      C( 78 ) = C( 78 ) + A( 68 ) * B( 68 )
      C( 78 ) = C( 78 ) + A( 69 ) * B( 69 )
      C( 78 ) = C( 78 ) + A( 70 ) * B( 70 )
      C( 78 ) = C( 78 ) + A( 71 ) * B( 71 )
      C( 78 ) = C( 78 ) + A( 72 ) * B( 72 )
      C( 78 ) = C( 78 ) + A( 73 ) * B( 73 )
      C( 78 ) = C( 78 ) + A( 74 ) * B( 74 )
      C( 78 ) = C( 78 ) + A( 75 ) * B( 75 )
      C( 78 ) = C( 78 ) + A( 76 ) * B( 76 )
      C( 78 ) = C( 78 ) + A( 77 ) * B( 77 )
      C( 78 ) = C( 78 ) + A( 78 ) * B( 78 )
      C( 78 ) = C( 78 ) + A( 90 ) * B( 90 )
      C( 78 ) = C( 78 ) + A( 103 ) * B( 103 )
      C( 78 ) = C( 78 ) + A( 117 ) * B( 117 )
      C( 78 ) = C( 78 ) + A( 132 ) * B( 132 )
!
      C( 79 ) = A( 79 ) * B( 1 )
      C( 79 ) = C( 79 ) + A( 80 ) * B( 2 )
      C( 79 ) = C( 79 ) + A( 81 ) * B( 4 )
      C( 79 ) = C( 79 ) + A( 82 ) * B( 7 )
      C( 79 ) = C( 79 ) + A( 83 ) * B( 11 )
      C( 79 ) = C( 79 ) + A( 84 ) * B( 16 )
      C( 79 ) = C( 79 ) + A( 85 ) * B( 22 )
      C( 79 ) = C( 79 ) + A( 86 ) * B( 29 )
      C( 79 ) = C( 79 ) + A( 87 ) * B( 37 )
      C( 79 ) = C( 79 ) + A( 88 ) * B( 46 )
      C( 79 ) = C( 79 ) + A( 89 ) * B( 56 )
      C( 79 ) = C( 79 ) + A( 90 ) * B( 67 )
      C( 79 ) = C( 79 ) + A( 91 ) * B( 79 )
      C( 79 ) = C( 79 ) + A( 104 ) * B( 92 )
      C( 79 ) = C( 79 ) + A( 118 ) * B( 106 )
      C( 79 ) = C( 79 ) + A( 133 ) * B( 121 )
!
      C( 80 ) = A( 79 ) * B( 2 )
      C( 80 ) = C( 80 ) + A( 80 ) * B( 3 )
      C( 80 ) = C( 80 ) + A( 81 ) * B( 5 )
      C( 80 ) = C( 80 ) + A( 82 ) * B( 8 )
      C( 80 ) = C( 80 ) + A( 83 ) * B( 12 )
      C( 80 ) = C( 80 ) + A( 84 ) * B( 17 )
      C( 80 ) = C( 80 ) + A( 85 ) * B( 23 )
      C( 80 ) = C( 80 ) + A( 86 ) * B( 30 )
      C( 80 ) = C( 80 ) + A( 87 ) * B( 38 )
      C( 80 ) = C( 80 ) + A( 88 ) * B( 47 )
      C( 80 ) = C( 80 ) + A( 89 ) * B( 57 )
      C( 80 ) = C( 80 ) + A( 90 ) * B( 68 )
      C( 80 ) = C( 80 ) + A( 91 ) * B( 80 )
      C( 80 ) = C( 80 ) + A( 104 ) * B( 93 )
      C( 80 ) = C( 80 ) + A( 118 ) * B( 107 )
      C( 80 ) = C( 80 ) + A( 133 ) * B( 122 )
!
      C( 81 ) = A( 79 ) * B( 4 )
      C( 81 ) = C( 81 ) + A( 80 ) * B( 5 )
      C( 81 ) = C( 81 ) + A( 81 ) * B( 6 )
      C( 81 ) = C( 81 ) + A( 82 ) * B( 9 )
      C( 81 ) = C( 81 ) + A( 83 ) * B( 13 )
      C( 81 ) = C( 81 ) + A( 84 ) * B( 18 )
      C( 81 ) = C( 81 ) + A( 85 ) * B( 24 )
      C( 81 ) = C( 81 ) + A( 86 ) * B( 31 )
      C( 81 ) = C( 81 ) + A( 87 ) * B( 39 )
      C( 81 ) = C( 81 ) + A( 88 ) * B( 48 )
      C( 81 ) = C( 81 ) + A( 89 ) * B( 58 )
      C( 81 ) = C( 81 ) + A( 90 ) * B( 69 )
      C( 81 ) = C( 81 ) + A( 91 ) * B( 81 )
      C( 81 ) = C( 81 ) + A( 104 ) * B( 94 )
      C( 81 ) = C( 81 ) + A( 118 ) * B( 108 )
      C( 81 ) = C( 81 ) + A( 133 ) * B( 123 )
!
      C( 82 ) = A( 79 ) * B( 7 )
      C( 82 ) = C( 82 ) + A( 80 ) * B( 8 )
      C( 82 ) = C( 82 ) + A( 81 ) * B( 9 )
      C( 82 ) = C( 82 ) + A( 82 ) * B( 10 )
      C( 82 ) = C( 82 ) + A( 83 ) * B( 14 )
      C( 82 ) = C( 82 ) + A( 84 ) * B( 19 )
      C( 82 ) = C( 82 ) + A( 85 ) * B( 25 )
      C( 82 ) = C( 82 ) + A( 86 ) * B( 32 )
      C( 82 ) = C( 82 ) + A( 87 ) * B( 40 )
      C( 82 ) = C( 82 ) + A( 88 ) * B( 49 )
      C( 82 ) = C( 82 ) + A( 89 ) * B( 59 )
      C( 82 ) = C( 82 ) + A( 90 ) * B( 70 )
      C( 82 ) = C( 82 ) + A( 91 ) * B( 82 )
      C( 82 ) = C( 82 ) + A( 104 ) * B( 95 )
      C( 82 ) = C( 82 ) + A( 118 ) * B( 109 )
      C( 82 ) = C( 82 ) + A( 133 ) * B( 124 )
!
      C( 83 ) = A( 79 ) * B( 11 )
      C( 83 ) = C( 83 ) + A( 80 ) * B( 12 )
      C( 83 ) = C( 83 ) + A( 81 ) * B( 13 )
      C( 83 ) = C( 83 ) + A( 82 ) * B( 14 )
      C( 83 ) = C( 83 ) + A( 83 ) * B( 15 )
      C( 83 ) = C( 83 ) + A( 84 ) * B( 20 )
      C( 83 ) = C( 83 ) + A( 85 ) * B( 26 )
      C( 83 ) = C( 83 ) + A( 86 ) * B( 33 )
      C( 83 ) = C( 83 ) + A( 87 ) * B( 41 )
      C( 83 ) = C( 83 ) + A( 88 ) * B( 50 )
      C( 83 ) = C( 83 ) + A( 89 ) * B( 60 )
      C( 83 ) = C( 83 ) + A( 90 ) * B( 71 )
      C( 83 ) = C( 83 ) + A( 91 ) * B( 83 )
      C( 83 ) = C( 83 ) + A( 104 ) * B( 96 )
      C( 83 ) = C( 83 ) + A( 118 ) * B( 110 )
      C( 83 ) = C( 83 ) + A( 133 ) * B( 125 )
!
      C( 84 ) = A( 79 ) * B( 16 )
      C( 84 ) = C( 84 ) + A( 80 ) * B( 17 )
      C( 84 ) = C( 84 ) + A( 81 ) * B( 18 )
      C( 84 ) = C( 84 ) + A( 82 ) * B( 19 )
      C( 84 ) = C( 84 ) + A( 83 ) * B( 20 )
      C( 84 ) = C( 84 ) + A( 84 ) * B( 21 )
      C( 84 ) = C( 84 ) + A( 85 ) * B( 27 )
      C( 84 ) = C( 84 ) + A( 86 ) * B( 34 )
      C( 84 ) = C( 84 ) + A( 87 ) * B( 42 )
      C( 84 ) = C( 84 ) + A( 88 ) * B( 51 )
      C( 84 ) = C( 84 ) + A( 89 ) * B( 61 )
      C( 84 ) = C( 84 ) + A( 90 ) * B( 72 )
      C( 84 ) = C( 84 ) + A( 91 ) * B( 84 )
      C( 84 ) = C( 84 ) + A( 104 ) * B( 97 )
      C( 84 ) = C( 84 ) + A( 118 ) * B( 111 )
      C( 84 ) = C( 84 ) + A( 133 ) * B( 126 )
!
      C( 85 ) = A( 79 ) * B( 22 )
      C( 85 ) = C( 85 ) + A( 80 ) * B( 23 )
      C( 85 ) = C( 85 ) + A( 81 ) * B( 24 )
      C( 85 ) = C( 85 ) + A( 82 ) * B( 25 )
      C( 85 ) = C( 85 ) + A( 83 ) * B( 26 )
      C( 85 ) = C( 85 ) + A( 84 ) * B( 27 )
      C( 85 ) = C( 85 ) + A( 85 ) * B( 28 )
      C( 85 ) = C( 85 ) + A( 86 ) * B( 35 )
      C( 85 ) = C( 85 ) + A( 87 ) * B( 43 )
      C( 85 ) = C( 85 ) + A( 88 ) * B( 52 )
      C( 85 ) = C( 85 ) + A( 89 ) * B( 62 )
      C( 85 ) = C( 85 ) + A( 90 ) * B( 73 )
      C( 85 ) = C( 85 ) + A( 91 ) * B( 85 )
      C( 85 ) = C( 85 ) + A( 104 ) * B( 98 )
      C( 85 ) = C( 85 ) + A( 118 ) * B( 112 )
      C( 85 ) = C( 85 ) + A( 133 ) * B( 127 )
!
      C( 86 ) = A( 79 ) * B( 29 )
      C( 86 ) = C( 86 ) + A( 80 ) * B( 30 )
      C( 86 ) = C( 86 ) + A( 81 ) * B( 31 )
      C( 86 ) = C( 86 ) + A( 82 ) * B( 32 )
      C( 86 ) = C( 86 ) + A( 83 ) * B( 33 )
      C( 86 ) = C( 86 ) + A( 84 ) * B( 34 )
      C( 86 ) = C( 86 ) + A( 85 ) * B( 35 )
      C( 86 ) = C( 86 ) + A( 86 ) * B( 36 )
      C( 86 ) = C( 86 ) + A( 87 ) * B( 44 )
      C( 86 ) = C( 86 ) + A( 88 ) * B( 53 )
      C( 86 ) = C( 86 ) + A( 89 ) * B( 63 )
      C( 86 ) = C( 86 ) + A( 90 ) * B( 74 )
      C( 86 ) = C( 86 ) + A( 91 ) * B( 86 )
      C( 86 ) = C( 86 ) + A( 104 ) * B( 99 )
      C( 86 ) = C( 86 ) + A( 118 ) * B( 113 )
      C( 86 ) = C( 86 ) + A( 133 ) * B( 128 )
!
      C( 87 ) = A( 79 ) * B( 37 )
      C( 87 ) = C( 87 ) + A( 80 ) * B( 38 )
      C( 87 ) = C( 87 ) + A( 81 ) * B( 39 )
      C( 87 ) = C( 87 ) + A( 82 ) * B( 40 )
      C( 87 ) = C( 87 ) + A( 83 ) * B( 41 )
      C( 87 ) = C( 87 ) + A( 84 ) * B( 42 )
      C( 87 ) = C( 87 ) + A( 85 ) * B( 43 )
      C( 87 ) = C( 87 ) + A( 86 ) * B( 44 )
      C( 87 ) = C( 87 ) + A( 87 ) * B( 45 )
      C( 87 ) = C( 87 ) + A( 88 ) * B( 54 )
      C( 87 ) = C( 87 ) + A( 89 ) * B( 64 )
      C( 87 ) = C( 87 ) + A( 90 ) * B( 75 )
      C( 87 ) = C( 87 ) + A( 91 ) * B( 87 )
      C( 87 ) = C( 87 ) + A( 104 ) * B( 100 )
      C( 87 ) = C( 87 ) + A( 118 ) * B( 114 )
      C( 87 ) = C( 87 ) + A( 133 ) * B( 129 )
!
      C( 88 ) = A( 79 ) * B( 46 )
      C( 88 ) = C( 88 ) + A( 80 ) * B( 47 )
      C( 88 ) = C( 88 ) + A( 81 ) * B( 48 )
      C( 88 ) = C( 88 ) + A( 82 ) * B( 49 )
      C( 88 ) = C( 88 ) + A( 83 ) * B( 50 )
      C( 88 ) = C( 88 ) + A( 84 ) * B( 51 )
      C( 88 ) = C( 88 ) + A( 85 ) * B( 52 )
      C( 88 ) = C( 88 ) + A( 86 ) * B( 53 )
      C( 88 ) = C( 88 ) + A( 87 ) * B( 54 )
      C( 88 ) = C( 88 ) + A( 88 ) * B( 55 )
      C( 88 ) = C( 88 ) + A( 89 ) * B( 65 )
      C( 88 ) = C( 88 ) + A( 90 ) * B( 76 )
      C( 88 ) = C( 88 ) + A( 91 ) * B( 88 )
      C( 88 ) = C( 88 ) + A( 104 ) * B( 101 )
      C( 88 ) = C( 88 ) + A( 118 ) * B( 115 )
      C( 88 ) = C( 88 ) + A( 133 ) * B( 130 )
!
      C( 89 ) = A( 79 ) * B( 56 )
      C( 89 ) = C( 89 ) + A( 80 ) * B( 57 )
      C( 89 ) = C( 89 ) + A( 81 ) * B( 58 )
      C( 89 ) = C( 89 ) + A( 82 ) * B( 59 )
      C( 89 ) = C( 89 ) + A( 83 ) * B( 60 )
      C( 89 ) = C( 89 ) + A( 84 ) * B( 61 )
      C( 89 ) = C( 89 ) + A( 85 ) * B( 62 )
      C( 89 ) = C( 89 ) + A( 86 ) * B( 63 )
      C( 89 ) = C( 89 ) + A( 87 ) * B( 64 )
      C( 89 ) = C( 89 ) + A( 88 ) * B( 65 )
      C( 89 ) = C( 89 ) + A( 89 ) * B( 66 )
      C( 89 ) = C( 89 ) + A( 90 ) * B( 77 )
      C( 89 ) = C( 89 ) + A( 91 ) * B( 89 )
      C( 89 ) = C( 89 ) + A( 104 ) * B( 102 )
      C( 89 ) = C( 89 ) + A( 118 ) * B( 116 )
      C( 89 ) = C( 89 ) + A( 133 ) * B( 131 )
!
      C( 90 ) = A( 79 ) * B( 67 )
      C( 90 ) = C( 90 ) + A( 80 ) * B( 68 )
      C( 90 ) = C( 90 ) + A( 81 ) * B( 69 )
      C( 90 ) = C( 90 ) + A( 82 ) * B( 70 )
      C( 90 ) = C( 90 ) + A( 83 ) * B( 71 )
      C( 90 ) = C( 90 ) + A( 84 ) * B( 72 )
      C( 90 ) = C( 90 ) + A( 85 ) * B( 73 )
      C( 90 ) = C( 90 ) + A( 86 ) * B( 74 )
      C( 90 ) = C( 90 ) + A( 87 ) * B( 75 )
      C( 90 ) = C( 90 ) + A( 88 ) * B( 76 )
      C( 90 ) = C( 90 ) + A( 89 ) * B( 77 )
      C( 90 ) = C( 90 ) + A( 90 ) * B( 78 )
      C( 90 ) = C( 90 ) + A( 91 ) * B( 90 )
      C( 90 ) = C( 90 ) + A( 104 ) * B( 103 )
      C( 90 ) = C( 90 ) + A( 118 ) * B( 117 )
      C( 90 ) = C( 90 ) + A( 133 ) * B( 132 )
!
      C( 91 ) = A( 79 ) * B( 79 )
      C( 91 ) = C( 91 ) + A( 80 ) * B( 80 )
      C( 91 ) = C( 91 ) + A( 81 ) * B( 81 )
      C( 91 ) = C( 91 ) + A( 82 ) * B( 82 )
      C( 91 ) = C( 91 ) + A( 83 ) * B( 83 )
      C( 91 ) = C( 91 ) + A( 84 ) * B( 84 )
      C( 91 ) = C( 91 ) + A( 85 ) * B( 85 )
      C( 91 ) = C( 91 ) + A( 86 ) * B( 86 )
      C( 91 ) = C( 91 ) + A( 87 ) * B( 87 )
      C( 91 ) = C( 91 ) + A( 88 ) * B( 88 )
      C( 91 ) = C( 91 ) + A( 89 ) * B( 89 )
      C( 91 ) = C( 91 ) + A( 90 ) * B( 90 )
      C( 91 ) = C( 91 ) + A( 91 ) * B( 91 )
      C( 91 ) = C( 91 ) + A( 104 ) * B( 104 )
      C( 91 ) = C( 91 ) + A( 118 ) * B( 118 )
      C( 91 ) = C( 91 ) + A( 133 ) * B( 133 )
!
      C( 92 ) = A( 92 ) * B( 1 )
      C( 92 ) = C( 92 ) + A( 93 ) * B( 2 )
      C( 92 ) = C( 92 ) + A( 94 ) * B( 4 )
      C( 92 ) = C( 92 ) + A( 95 ) * B( 7 )
      C( 92 ) = C( 92 ) + A( 96 ) * B( 11 )
      C( 92 ) = C( 92 ) + A( 97 ) * B( 16 )
      C( 92 ) = C( 92 ) + A( 98 ) * B( 22 )
      C( 92 ) = C( 92 ) + A( 99 ) * B( 29 )
      C( 92 ) = C( 92 ) + A( 100 ) * B( 37 )
      C( 92 ) = C( 92 ) + A( 101 ) * B( 46 )
      C( 92 ) = C( 92 ) + A( 102 ) * B( 56 )
      C( 92 ) = C( 92 ) + A( 103 ) * B( 67 )
      C( 92 ) = C( 92 ) + A( 104 ) * B( 79 )
      C( 92 ) = C( 92 ) + A( 105 ) * B( 92 )
      C( 92 ) = C( 92 ) + A( 119 ) * B( 106 )
      C( 92 ) = C( 92 ) + A( 134 ) * B( 121 )
!
      C( 93 ) = A( 92 ) * B( 2 )
      C( 93 ) = C( 93 ) + A( 93 ) * B( 3 )
      C( 93 ) = C( 93 ) + A( 94 ) * B( 5 )
      C( 93 ) = C( 93 ) + A( 95 ) * B( 8 )
      C( 93 ) = C( 93 ) + A( 96 ) * B( 12 )
      C( 93 ) = C( 93 ) + A( 97 ) * B( 17 )
      C( 93 ) = C( 93 ) + A( 98 ) * B( 23 )
      C( 93 ) = C( 93 ) + A( 99 ) * B( 30 )
      C( 93 ) = C( 93 ) + A( 100 ) * B( 38 )
      C( 93 ) = C( 93 ) + A( 101 ) * B( 47 )
      C( 93 ) = C( 93 ) + A( 102 ) * B( 57 )
      C( 93 ) = C( 93 ) + A( 103 ) * B( 68 )
      C( 93 ) = C( 93 ) + A( 104 ) * B( 80 )
      C( 93 ) = C( 93 ) + A( 105 ) * B( 93 )
      C( 93 ) = C( 93 ) + A( 119 ) * B( 107 )
      C( 93 ) = C( 93 ) + A( 134 ) * B( 122 )
!
      C( 94 ) = A( 92 ) * B( 4 )
      C( 94 ) = C( 94 ) + A( 93 ) * B( 5 )
      C( 94 ) = C( 94 ) + A( 94 ) * B( 6 )
      C( 94 ) = C( 94 ) + A( 95 ) * B( 9 )
      C( 94 ) = C( 94 ) + A( 96 ) * B( 13 )
      C( 94 ) = C( 94 ) + A( 97 ) * B( 18 )
      C( 94 ) = C( 94 ) + A( 98 ) * B( 24 )
      C( 94 ) = C( 94 ) + A( 99 ) * B( 31 )
      C( 94 ) = C( 94 ) + A( 100 ) * B( 39 )
      C( 94 ) = C( 94 ) + A( 101 ) * B( 48 )
      C( 94 ) = C( 94 ) + A( 102 ) * B( 58 )
      C( 94 ) = C( 94 ) + A( 103 ) * B( 69 )
      C( 94 ) = C( 94 ) + A( 104 ) * B( 81 )
      C( 94 ) = C( 94 ) + A( 105 ) * B( 94 )
      C( 94 ) = C( 94 ) + A( 119 ) * B( 108 )
      C( 94 ) = C( 94 ) + A( 134 ) * B( 123 )
!
      C( 95 ) = A( 92 ) * B( 7 )
      C( 95 ) = C( 95 ) + A( 93 ) * B( 8 )
      C( 95 ) = C( 95 ) + A( 94 ) * B( 9 )
      C( 95 ) = C( 95 ) + A( 95 ) * B( 10 )
      C( 95 ) = C( 95 ) + A( 96 ) * B( 14 )
      C( 95 ) = C( 95 ) + A( 97 ) * B( 19 )
      C( 95 ) = C( 95 ) + A( 98 ) * B( 25 )
      C( 95 ) = C( 95 ) + A( 99 ) * B( 32 )
      C( 95 ) = C( 95 ) + A( 100 ) * B( 40 )
      C( 95 ) = C( 95 ) + A( 101 ) * B( 49 )
      C( 95 ) = C( 95 ) + A( 102 ) * B( 59 )
      C( 95 ) = C( 95 ) + A( 103 ) * B( 70 )
      C( 95 ) = C( 95 ) + A( 104 ) * B( 82 )
      C( 95 ) = C( 95 ) + A( 105 ) * B( 95 )
      C( 95 ) = C( 95 ) + A( 119 ) * B( 109 )
      C( 95 ) = C( 95 ) + A( 134 ) * B( 124 )
!
      C( 96 ) = A( 92 ) * B( 11 )
      C( 96 ) = C( 96 ) + A( 93 ) * B( 12 )
      C( 96 ) = C( 96 ) + A( 94 ) * B( 13 )
      C( 96 ) = C( 96 ) + A( 95 ) * B( 14 )
      C( 96 ) = C( 96 ) + A( 96 ) * B( 15 )
      C( 96 ) = C( 96 ) + A( 97 ) * B( 20 )
      C( 96 ) = C( 96 ) + A( 98 ) * B( 26 )
      C( 96 ) = C( 96 ) + A( 99 ) * B( 33 )
      C( 96 ) = C( 96 ) + A( 100 ) * B( 41 )
      C( 96 ) = C( 96 ) + A( 101 ) * B( 50 )
      C( 96 ) = C( 96 ) + A( 102 ) * B( 60 )
      C( 96 ) = C( 96 ) + A( 103 ) * B( 71 )
      C( 96 ) = C( 96 ) + A( 104 ) * B( 83 )
      C( 96 ) = C( 96 ) + A( 105 ) * B( 96 )
      C( 96 ) = C( 96 ) + A( 119 ) * B( 110 )
      C( 96 ) = C( 96 ) + A( 134 ) * B( 125 )
!
      C( 97 ) = A( 92 ) * B( 16 )
      C( 97 ) = C( 97 ) + A( 93 ) * B( 17 )
      C( 97 ) = C( 97 ) + A( 94 ) * B( 18 )
      C( 97 ) = C( 97 ) + A( 95 ) * B( 19 )
      C( 97 ) = C( 97 ) + A( 96 ) * B( 20 )
      C( 97 ) = C( 97 ) + A( 97 ) * B( 21 )
      C( 97 ) = C( 97 ) + A( 98 ) * B( 27 )
      C( 97 ) = C( 97 ) + A( 99 ) * B( 34 )
      C( 97 ) = C( 97 ) + A( 100 ) * B( 42 )
      C( 97 ) = C( 97 ) + A( 101 ) * B( 51 )
      C( 97 ) = C( 97 ) + A( 102 ) * B( 61 )
      C( 97 ) = C( 97 ) + A( 103 ) * B( 72 )
      C( 97 ) = C( 97 ) + A( 104 ) * B( 84 )
      C( 97 ) = C( 97 ) + A( 105 ) * B( 97 )
      C( 97 ) = C( 97 ) + A( 119 ) * B( 111 )
      C( 97 ) = C( 97 ) + A( 134 ) * B( 126 )
!
      C( 98 ) = A( 92 ) * B( 22 )
      C( 98 ) = C( 98 ) + A( 93 ) * B( 23 )
      C( 98 ) = C( 98 ) + A( 94 ) * B( 24 )
      C( 98 ) = C( 98 ) + A( 95 ) * B( 25 )
      C( 98 ) = C( 98 ) + A( 96 ) * B( 26 )
      C( 98 ) = C( 98 ) + A( 97 ) * B( 27 )
      C( 98 ) = C( 98 ) + A( 98 ) * B( 28 )
      C( 98 ) = C( 98 ) + A( 99 ) * B( 35 )
      C( 98 ) = C( 98 ) + A( 100 ) * B( 43 )
      C( 98 ) = C( 98 ) + A( 101 ) * B( 52 )
      C( 98 ) = C( 98 ) + A( 102 ) * B( 62 )
      C( 98 ) = C( 98 ) + A( 103 ) * B( 73 )
      C( 98 ) = C( 98 ) + A( 104 ) * B( 85 )
      C( 98 ) = C( 98 ) + A( 105 ) * B( 98 )
      C( 98 ) = C( 98 ) + A( 119 ) * B( 112 )
      C( 98 ) = C( 98 ) + A( 134 ) * B( 127 )
!
      C( 99 ) = A( 92 ) * B( 29 )
      C( 99 ) = C( 99 ) + A( 93 ) * B( 30 )
      C( 99 ) = C( 99 ) + A( 94 ) * B( 31 )
      C( 99 ) = C( 99 ) + A( 95 ) * B( 32 )
      C( 99 ) = C( 99 ) + A( 96 ) * B( 33 )
      C( 99 ) = C( 99 ) + A( 97 ) * B( 34 )
      C( 99 ) = C( 99 ) + A( 98 ) * B( 35 )
      C( 99 ) = C( 99 ) + A( 99 ) * B( 36 )
      C( 99 ) = C( 99 ) + A( 100 ) * B( 44 )
      C( 99 ) = C( 99 ) + A( 101 ) * B( 53 )
      C( 99 ) = C( 99 ) + A( 102 ) * B( 63 )
      C( 99 ) = C( 99 ) + A( 103 ) * B( 74 )
      C( 99 ) = C( 99 ) + A( 104 ) * B( 86 )
      C( 99 ) = C( 99 ) + A( 105 ) * B( 99 )
      C( 99 ) = C( 99 ) + A( 119 ) * B( 113 )
      C( 99 ) = C( 99 ) + A( 134 ) * B( 128 )
!
      C( 100 ) = A( 92 ) * B( 37 )
      C( 100 ) = C( 100 ) + A( 93 ) * B( 38 )
      C( 100 ) = C( 100 ) + A( 94 ) * B( 39 )
      C( 100 ) = C( 100 ) + A( 95 ) * B( 40 )
      C( 100 ) = C( 100 ) + A( 96 ) * B( 41 )
      C( 100 ) = C( 100 ) + A( 97 ) * B( 42 )
      C( 100 ) = C( 100 ) + A( 98 ) * B( 43 )
      C( 100 ) = C( 100 ) + A( 99 ) * B( 44 )
      C( 100 ) = C( 100 ) + A( 100 ) * B( 45 )
      C( 100 ) = C( 100 ) + A( 101 ) * B( 54 )
      C( 100 ) = C( 100 ) + A( 102 ) * B( 64 )
      C( 100 ) = C( 100 ) + A( 103 ) * B( 75 )
      C( 100 ) = C( 100 ) + A( 104 ) * B( 87 )
      C( 100 ) = C( 100 ) + A( 105 ) * B( 100 )
      C( 100 ) = C( 100 ) + A( 119 ) * B( 114 )
      C( 100 ) = C( 100 ) + A( 134 ) * B( 129 )
!
      C( 101 ) = A( 92 ) * B( 46 )
      C( 101 ) = C( 101 ) + A( 93 ) * B( 47 )
      C( 101 ) = C( 101 ) + A( 94 ) * B( 48 )
      C( 101 ) = C( 101 ) + A( 95 ) * B( 49 )
      C( 101 ) = C( 101 ) + A( 96 ) * B( 50 )
      C( 101 ) = C( 101 ) + A( 97 ) * B( 51 )
      C( 101 ) = C( 101 ) + A( 98 ) * B( 52 )
      C( 101 ) = C( 101 ) + A( 99 ) * B( 53 )
      C( 101 ) = C( 101 ) + A( 100 ) * B( 54 )
      C( 101 ) = C( 101 ) + A( 101 ) * B( 55 )
      C( 101 ) = C( 101 ) + A( 102 ) * B( 65 )
      C( 101 ) = C( 101 ) + A( 103 ) * B( 76 )
      C( 101 ) = C( 101 ) + A( 104 ) * B( 88 )
      C( 101 ) = C( 101 ) + A( 105 ) * B( 101 )
      C( 101 ) = C( 101 ) + A( 119 ) * B( 115 )
      C( 101 ) = C( 101 ) + A( 134 ) * B( 130 )
!
      C( 102 ) = A( 92 ) * B( 56 )
      C( 102 ) = C( 102 ) + A( 93 ) * B( 57 )
      C( 102 ) = C( 102 ) + A( 94 ) * B( 58 )
      C( 102 ) = C( 102 ) + A( 95 ) * B( 59 )
      C( 102 ) = C( 102 ) + A( 96 ) * B( 60 )
      C( 102 ) = C( 102 ) + A( 97 ) * B( 61 )
      C( 102 ) = C( 102 ) + A( 98 ) * B( 62 )
      C( 102 ) = C( 102 ) + A( 99 ) * B( 63 )
      C( 102 ) = C( 102 ) + A( 100 ) * B( 64 )
      C( 102 ) = C( 102 ) + A( 101 ) * B( 65 )
      C( 102 ) = C( 102 ) + A( 102 ) * B( 66 )
      C( 102 ) = C( 102 ) + A( 103 ) * B( 77 )
      C( 102 ) = C( 102 ) + A( 104 ) * B( 89 )
      C( 102 ) = C( 102 ) + A( 105 ) * B( 102 )
      C( 102 ) = C( 102 ) + A( 119 ) * B( 116 )
      C( 102 ) = C( 102 ) + A( 134 ) * B( 131 )
!
      C( 103 ) = A( 92 ) * B( 67 )
      C( 103 ) = C( 103 ) + A( 93 ) * B( 68 )
      C( 103 ) = C( 103 ) + A( 94 ) * B( 69 )
      C( 103 ) = C( 103 ) + A( 95 ) * B( 70 )
      C( 103 ) = C( 103 ) + A( 96 ) * B( 71 )
      C( 103 ) = C( 103 ) + A( 97 ) * B( 72 )
      C( 103 ) = C( 103 ) + A( 98 ) * B( 73 )
      C( 103 ) = C( 103 ) + A( 99 ) * B( 74 )
      C( 103 ) = C( 103 ) + A( 100 ) * B( 75 )
      C( 103 ) = C( 103 ) + A( 101 ) * B( 76 )
      C( 103 ) = C( 103 ) + A( 102 ) * B( 77 )
      C( 103 ) = C( 103 ) + A( 103 ) * B( 78 )
      C( 103 ) = C( 103 ) + A( 104 ) * B( 90 )
      C( 103 ) = C( 103 ) + A( 105 ) * B( 103 )
      C( 103 ) = C( 103 ) + A( 119 ) * B( 117 )
      C( 103 ) = C( 103 ) + A( 134 ) * B( 132 )
!
      C( 104 ) = A( 92 ) * B( 79 )
      C( 104 ) = C( 104 ) + A( 93 ) * B( 80 )
      C( 104 ) = C( 104 ) + A( 94 ) * B( 81 )
      C( 104 ) = C( 104 ) + A( 95 ) * B( 82 )
      C( 104 ) = C( 104 ) + A( 96 ) * B( 83 )
      C( 104 ) = C( 104 ) + A( 97 ) * B( 84 )
      C( 104 ) = C( 104 ) + A( 98 ) * B( 85 )
      C( 104 ) = C( 104 ) + A( 99 ) * B( 86 )
      C( 104 ) = C( 104 ) + A( 100 ) * B( 87 )
      C( 104 ) = C( 104 ) + A( 101 ) * B( 88 )
      C( 104 ) = C( 104 ) + A( 102 ) * B( 89 )
      C( 104 ) = C( 104 ) + A( 103 ) * B( 90 )
      C( 104 ) = C( 104 ) + A( 104 ) * B( 91 )
      C( 104 ) = C( 104 ) + A( 105 ) * B( 104 )
      C( 104 ) = C( 104 ) + A( 119 ) * B( 118 )
      C( 104 ) = C( 104 ) + A( 134 ) * B( 133 )
!
      C( 105 ) = A( 92 ) * B( 92 )
      C( 105 ) = C( 105 ) + A( 93 ) * B( 93 )
      C( 105 ) = C( 105 ) + A( 94 ) * B( 94 )
      C( 105 ) = C( 105 ) + A( 95 ) * B( 95 )
      C( 105 ) = C( 105 ) + A( 96 ) * B( 96 )
      C( 105 ) = C( 105 ) + A( 97 ) * B( 97 )
      C( 105 ) = C( 105 ) + A( 98 ) * B( 98 )
      C( 105 ) = C( 105 ) + A( 99 ) * B( 99 )
      C( 105 ) = C( 105 ) + A( 100 ) * B( 100 )
      C( 105 ) = C( 105 ) + A( 101 ) * B( 101 )
      C( 105 ) = C( 105 ) + A( 102 ) * B( 102 )
      C( 105 ) = C( 105 ) + A( 103 ) * B( 103 )
      C( 105 ) = C( 105 ) + A( 104 ) * B( 104 )
      C( 105 ) = C( 105 ) + A( 105 ) * B( 105 )
      C( 105 ) = C( 105 ) + A( 119 ) * B( 119 )
      C( 105 ) = C( 105 ) + A( 134 ) * B( 134 )
!
      C( 106 ) = A( 106 ) * B( 1 )
      C( 106 ) = C( 106 ) + A( 107 ) * B( 2 )
      C( 106 ) = C( 106 ) + A( 108 ) * B( 4 )
      C( 106 ) = C( 106 ) + A( 109 ) * B( 7 )
      C( 106 ) = C( 106 ) + A( 110 ) * B( 11 )
      C( 106 ) = C( 106 ) + A( 111 ) * B( 16 )
      C( 106 ) = C( 106 ) + A( 112 ) * B( 22 )
      C( 106 ) = C( 106 ) + A( 113 ) * B( 29 )
      C( 106 ) = C( 106 ) + A( 114 ) * B( 37 )
      C( 106 ) = C( 106 ) + A( 115 ) * B( 46 )
      C( 106 ) = C( 106 ) + A( 116 ) * B( 56 )
      C( 106 ) = C( 106 ) + A( 117 ) * B( 67 )
      C( 106 ) = C( 106 ) + A( 118 ) * B( 79 )
      C( 106 ) = C( 106 ) + A( 119 ) * B( 92 )
      C( 106 ) = C( 106 ) + A( 120 ) * B( 106 )
      C( 106 ) = C( 106 ) + A( 135 ) * B( 121 )
!
      C( 107 ) = A( 106 ) * B( 2 )
      C( 107 ) = C( 107 ) + A( 107 ) * B( 3 )
      C( 107 ) = C( 107 ) + A( 108 ) * B( 5 )
      C( 107 ) = C( 107 ) + A( 109 ) * B( 8 )
      C( 107 ) = C( 107 ) + A( 110 ) * B( 12 )
      C( 107 ) = C( 107 ) + A( 111 ) * B( 17 )
      C( 107 ) = C( 107 ) + A( 112 ) * B( 23 )
      C( 107 ) = C( 107 ) + A( 113 ) * B( 30 )
      C( 107 ) = C( 107 ) + A( 114 ) * B( 38 )
      C( 107 ) = C( 107 ) + A( 115 ) * B( 47 )
      C( 107 ) = C( 107 ) + A( 116 ) * B( 57 )
      C( 107 ) = C( 107 ) + A( 117 ) * B( 68 )
      C( 107 ) = C( 107 ) + A( 118 ) * B( 80 )
      C( 107 ) = C( 107 ) + A( 119 ) * B( 93 )
      C( 107 ) = C( 107 ) + A( 120 ) * B( 107 )
      C( 107 ) = C( 107 ) + A( 135 ) * B( 122 )
!
      C( 108 ) = A( 106 ) * B( 4 )
      C( 108 ) = C( 108 ) + A( 107 ) * B( 5 )
      C( 108 ) = C( 108 ) + A( 108 ) * B( 6 )
      C( 108 ) = C( 108 ) + A( 109 ) * B( 9 )
      C( 108 ) = C( 108 ) + A( 110 ) * B( 13 )
      C( 108 ) = C( 108 ) + A( 111 ) * B( 18 )
      C( 108 ) = C( 108 ) + A( 112 ) * B( 24 )
      C( 108 ) = C( 108 ) + A( 113 ) * B( 31 )
      C( 108 ) = C( 108 ) + A( 114 ) * B( 39 )
      C( 108 ) = C( 108 ) + A( 115 ) * B( 48 )
      C( 108 ) = C( 108 ) + A( 116 ) * B( 58 )
      C( 108 ) = C( 108 ) + A( 117 ) * B( 69 )
      C( 108 ) = C( 108 ) + A( 118 ) * B( 81 )
      C( 108 ) = C( 108 ) + A( 119 ) * B( 94 )
      C( 108 ) = C( 108 ) + A( 120 ) * B( 108 )
      C( 108 ) = C( 108 ) + A( 135 ) * B( 123 )
!
      C( 109 ) = A( 106 ) * B( 7 )
      C( 109 ) = C( 109 ) + A( 107 ) * B( 8 )
      C( 109 ) = C( 109 ) + A( 108 ) * B( 9 )
      C( 109 ) = C( 109 ) + A( 109 ) * B( 10 )
      C( 109 ) = C( 109 ) + A( 110 ) * B( 14 )
      C( 109 ) = C( 109 ) + A( 111 ) * B( 19 )
      C( 109 ) = C( 109 ) + A( 112 ) * B( 25 )
      C( 109 ) = C( 109 ) + A( 113 ) * B( 32 )
      C( 109 ) = C( 109 ) + A( 114 ) * B( 40 )
      C( 109 ) = C( 109 ) + A( 115 ) * B( 49 )
      C( 109 ) = C( 109 ) + A( 116 ) * B( 59 )
      C( 109 ) = C( 109 ) + A( 117 ) * B( 70 )
      C( 109 ) = C( 109 ) + A( 118 ) * B( 82 )
      C( 109 ) = C( 109 ) + A( 119 ) * B( 95 )
      C( 109 ) = C( 109 ) + A( 120 ) * B( 109 )
      C( 109 ) = C( 109 ) + A( 135 ) * B( 124 )
!
      C( 110 ) = A( 106 ) * B( 11 )
      C( 110 ) = C( 110 ) + A( 107 ) * B( 12 )
      C( 110 ) = C( 110 ) + A( 108 ) * B( 13 )
      C( 110 ) = C( 110 ) + A( 109 ) * B( 14 )
      C( 110 ) = C( 110 ) + A( 110 ) * B( 15 )
      C( 110 ) = C( 110 ) + A( 111 ) * B( 20 )
      C( 110 ) = C( 110 ) + A( 112 ) * B( 26 )
      C( 110 ) = C( 110 ) + A( 113 ) * B( 33 )
      C( 110 ) = C( 110 ) + A( 114 ) * B( 41 )
      C( 110 ) = C( 110 ) + A( 115 ) * B( 50 )
      C( 110 ) = C( 110 ) + A( 116 ) * B( 60 )
      C( 110 ) = C( 110 ) + A( 117 ) * B( 71 )
      C( 110 ) = C( 110 ) + A( 118 ) * B( 83 )
      C( 110 ) = C( 110 ) + A( 119 ) * B( 96 )
      C( 110 ) = C( 110 ) + A( 120 ) * B( 110 )
      C( 110 ) = C( 110 ) + A( 135 ) * B( 125 )
!
      C( 111 ) = A( 106 ) * B( 16 )
      C( 111 ) = C( 111 ) + A( 107 ) * B( 17 )
      C( 111 ) = C( 111 ) + A( 108 ) * B( 18 )
      C( 111 ) = C( 111 ) + A( 109 ) * B( 19 )
      C( 111 ) = C( 111 ) + A( 110 ) * B( 20 )
      C( 111 ) = C( 111 ) + A( 111 ) * B( 21 )
      C( 111 ) = C( 111 ) + A( 112 ) * B( 27 )
      C( 111 ) = C( 111 ) + A( 113 ) * B( 34 )
      C( 111 ) = C( 111 ) + A( 114 ) * B( 42 )
      C( 111 ) = C( 111 ) + A( 115 ) * B( 51 )
      C( 111 ) = C( 111 ) + A( 116 ) * B( 61 )
      C( 111 ) = C( 111 ) + A( 117 ) * B( 72 )
      C( 111 ) = C( 111 ) + A( 118 ) * B( 84 )
      C( 111 ) = C( 111 ) + A( 119 ) * B( 97 )
      C( 111 ) = C( 111 ) + A( 120 ) * B( 111 )
      C( 111 ) = C( 111 ) + A( 135 ) * B( 126 )
!
      C( 112 ) = A( 106 ) * B( 22 )
      C( 112 ) = C( 112 ) + A( 107 ) * B( 23 )
      C( 112 ) = C( 112 ) + A( 108 ) * B( 24 )
      C( 112 ) = C( 112 ) + A( 109 ) * B( 25 )
      C( 112 ) = C( 112 ) + A( 110 ) * B( 26 )
      C( 112 ) = C( 112 ) + A( 111 ) * B( 27 )
      C( 112 ) = C( 112 ) + A( 112 ) * B( 28 )
      C( 112 ) = C( 112 ) + A( 113 ) * B( 35 )
      C( 112 ) = C( 112 ) + A( 114 ) * B( 43 )
      C( 112 ) = C( 112 ) + A( 115 ) * B( 52 )
      C( 112 ) = C( 112 ) + A( 116 ) * B( 62 )
      C( 112 ) = C( 112 ) + A( 117 ) * B( 73 )
      C( 112 ) = C( 112 ) + A( 118 ) * B( 85 )
      C( 112 ) = C( 112 ) + A( 119 ) * B( 98 )
      C( 112 ) = C( 112 ) + A( 120 ) * B( 112 )
      C( 112 ) = C( 112 ) + A( 135 ) * B( 127 )
!
      C( 113 ) = A( 106 ) * B( 29 )
      C( 113 ) = C( 113 ) + A( 107 ) * B( 30 )
      C( 113 ) = C( 113 ) + A( 108 ) * B( 31 )
      C( 113 ) = C( 113 ) + A( 109 ) * B( 32 )
      C( 113 ) = C( 113 ) + A( 110 ) * B( 33 )
      C( 113 ) = C( 113 ) + A( 111 ) * B( 34 )
      C( 113 ) = C( 113 ) + A( 112 ) * B( 35 )
      C( 113 ) = C( 113 ) + A( 113 ) * B( 36 )
      C( 113 ) = C( 113 ) + A( 114 ) * B( 44 )
      C( 113 ) = C( 113 ) + A( 115 ) * B( 53 )
      C( 113 ) = C( 113 ) + A( 116 ) * B( 63 )
      C( 113 ) = C( 113 ) + A( 117 ) * B( 74 )
      C( 113 ) = C( 113 ) + A( 118 ) * B( 86 )
      C( 113 ) = C( 113 ) + A( 119 ) * B( 99 )
      C( 113 ) = C( 113 ) + A( 120 ) * B( 113 )
      C( 113 ) = C( 113 ) + A( 135 ) * B( 128 )
!
      C( 114 ) = A( 106 ) * B( 37 )
      C( 114 ) = C( 114 ) + A( 107 ) * B( 38 )
      C( 114 ) = C( 114 ) + A( 108 ) * B( 39 )
      C( 114 ) = C( 114 ) + A( 109 ) * B( 40 )
      C( 114 ) = C( 114 ) + A( 110 ) * B( 41 )
      C( 114 ) = C( 114 ) + A( 111 ) * B( 42 )
      C( 114 ) = C( 114 ) + A( 112 ) * B( 43 )
      C( 114 ) = C( 114 ) + A( 113 ) * B( 44 )
      C( 114 ) = C( 114 ) + A( 114 ) * B( 45 )
      C( 114 ) = C( 114 ) + A( 115 ) * B( 54 )
      C( 114 ) = C( 114 ) + A( 116 ) * B( 64 )
      C( 114 ) = C( 114 ) + A( 117 ) * B( 75 )
      C( 114 ) = C( 114 ) + A( 118 ) * B( 87 )
      C( 114 ) = C( 114 ) + A( 119 ) * B( 100 )
      C( 114 ) = C( 114 ) + A( 120 ) * B( 114 )
      C( 114 ) = C( 114 ) + A( 135 ) * B( 129 )
!
      C( 115 ) = A( 106 ) * B( 46 )
      C( 115 ) = C( 115 ) + A( 107 ) * B( 47 )
      C( 115 ) = C( 115 ) + A( 108 ) * B( 48 )
      C( 115 ) = C( 115 ) + A( 109 ) * B( 49 )
      C( 115 ) = C( 115 ) + A( 110 ) * B( 50 )
      C( 115 ) = C( 115 ) + A( 111 ) * B( 51 )
      C( 115 ) = C( 115 ) + A( 112 ) * B( 52 )
      C( 115 ) = C( 115 ) + A( 113 ) * B( 53 )
      C( 115 ) = C( 115 ) + A( 114 ) * B( 54 )
      C( 115 ) = C( 115 ) + A( 115 ) * B( 55 )
      C( 115 ) = C( 115 ) + A( 116 ) * B( 65 )
      C( 115 ) = C( 115 ) + A( 117 ) * B( 76 )
      C( 115 ) = C( 115 ) + A( 118 ) * B( 88 )
      C( 115 ) = C( 115 ) + A( 119 ) * B( 101 )
      C( 115 ) = C( 115 ) + A( 120 ) * B( 115 )
      C( 115 ) = C( 115 ) + A( 135 ) * B( 130 )
!
      C( 116 ) = A( 106 ) * B( 56 )
      C( 116 ) = C( 116 ) + A( 107 ) * B( 57 )
      C( 116 ) = C( 116 ) + A( 108 ) * B( 58 )
      C( 116 ) = C( 116 ) + A( 109 ) * B( 59 )
      C( 116 ) = C( 116 ) + A( 110 ) * B( 60 )
      C( 116 ) = C( 116 ) + A( 111 ) * B( 61 )
      C( 116 ) = C( 116 ) + A( 112 ) * B( 62 )
      C( 116 ) = C( 116 ) + A( 113 ) * B( 63 )
      C( 116 ) = C( 116 ) + A( 114 ) * B( 64 )
      C( 116 ) = C( 116 ) + A( 115 ) * B( 65 )
      C( 116 ) = C( 116 ) + A( 116 ) * B( 66 )
      C( 116 ) = C( 116 ) + A( 117 ) * B( 77 )
      C( 116 ) = C( 116 ) + A( 118 ) * B( 89 )
      C( 116 ) = C( 116 ) + A( 119 ) * B( 102 )
      C( 116 ) = C( 116 ) + A( 120 ) * B( 116 )
      C( 116 ) = C( 116 ) + A( 135 ) * B( 131 )
!
      C( 117 ) = A( 106 ) * B( 67 )
      C( 117 ) = C( 117 ) + A( 107 ) * B( 68 )
      C( 117 ) = C( 117 ) + A( 108 ) * B( 69 )
      C( 117 ) = C( 117 ) + A( 109 ) * B( 70 )
      C( 117 ) = C( 117 ) + A( 110 ) * B( 71 )
      C( 117 ) = C( 117 ) + A( 111 ) * B( 72 )
      C( 117 ) = C( 117 ) + A( 112 ) * B( 73 )
      C( 117 ) = C( 117 ) + A( 113 ) * B( 74 )
      C( 117 ) = C( 117 ) + A( 114 ) * B( 75 )
      C( 117 ) = C( 117 ) + A( 115 ) * B( 76 )
      C( 117 ) = C( 117 ) + A( 116 ) * B( 77 )
      C( 117 ) = C( 117 ) + A( 117 ) * B( 78 )
      C( 117 ) = C( 117 ) + A( 118 ) * B( 90 )
      C( 117 ) = C( 117 ) + A( 119 ) * B( 103 )
      C( 117 ) = C( 117 ) + A( 120 ) * B( 117 )
      C( 117 ) = C( 117 ) + A( 135 ) * B( 132 )
!
      C( 118 ) = A( 106 ) * B( 79 )
      C( 118 ) = C( 118 ) + A( 107 ) * B( 80 )
      C( 118 ) = C( 118 ) + A( 108 ) * B( 81 )
      C( 118 ) = C( 118 ) + A( 109 ) * B( 82 )
      C( 118 ) = C( 118 ) + A( 110 ) * B( 83 )
      C( 118 ) = C( 118 ) + A( 111 ) * B( 84 )
      C( 118 ) = C( 118 ) + A( 112 ) * B( 85 )
      C( 118 ) = C( 118 ) + A( 113 ) * B( 86 )
      C( 118 ) = C( 118 ) + A( 114 ) * B( 87 )
      C( 118 ) = C( 118 ) + A( 115 ) * B( 88 )
      C( 118 ) = C( 118 ) + A( 116 ) * B( 89 )
      C( 118 ) = C( 118 ) + A( 117 ) * B( 90 )
      C( 118 ) = C( 118 ) + A( 118 ) * B( 91 )
      C( 118 ) = C( 118 ) + A( 119 ) * B( 104 )
      C( 118 ) = C( 118 ) + A( 120 ) * B( 118 )
      C( 118 ) = C( 118 ) + A( 135 ) * B( 133 )
!
      C( 119 ) = A( 106 ) * B( 92 )
      C( 119 ) = C( 119 ) + A( 107 ) * B( 93 )
      C( 119 ) = C( 119 ) + A( 108 ) * B( 94 )
      C( 119 ) = C( 119 ) + A( 109 ) * B( 95 )
      C( 119 ) = C( 119 ) + A( 110 ) * B( 96 )
      C( 119 ) = C( 119 ) + A( 111 ) * B( 97 )
      C( 119 ) = C( 119 ) + A( 112 ) * B( 98 )
      C( 119 ) = C( 119 ) + A( 113 ) * B( 99 )
      C( 119 ) = C( 119 ) + A( 114 ) * B( 100 )
      C( 119 ) = C( 119 ) + A( 115 ) * B( 101 )
      C( 119 ) = C( 119 ) + A( 116 ) * B( 102 )
      C( 119 ) = C( 119 ) + A( 117 ) * B( 103 )
      C( 119 ) = C( 119 ) + A( 118 ) * B( 104 )
      C( 119 ) = C( 119 ) + A( 119 ) * B( 105 )
      C( 119 ) = C( 119 ) + A( 120 ) * B( 119 )
      C( 119 ) = C( 119 ) + A( 135 ) * B( 134 )
!
      C( 120 ) = A( 106 ) * B( 106 )
      C( 120 ) = C( 120 ) + A( 107 ) * B( 107 )
      C( 120 ) = C( 120 ) + A( 108 ) * B( 108 )
      C( 120 ) = C( 120 ) + A( 109 ) * B( 109 )
      C( 120 ) = C( 120 ) + A( 110 ) * B( 110 )
      C( 120 ) = C( 120 ) + A( 111 ) * B( 111 )
      C( 120 ) = C( 120 ) + A( 112 ) * B( 112 )
      C( 120 ) = C( 120 ) + A( 113 ) * B( 113 )
      C( 120 ) = C( 120 ) + A( 114 ) * B( 114 )
      C( 120 ) = C( 120 ) + A( 115 ) * B( 115 )
      C( 120 ) = C( 120 ) + A( 116 ) * B( 116 )
      C( 120 ) = C( 120 ) + A( 117 ) * B( 117 )
      C( 120 ) = C( 120 ) + A( 118 ) * B( 118 )
      C( 120 ) = C( 120 ) + A( 119 ) * B( 119 )
      C( 120 ) = C( 120 ) + A( 120 ) * B( 120 )
      C( 120 ) = C( 120 ) + A( 135 ) * B( 135 )
!
      C( 121 ) = A( 121 ) * B( 1 )
      C( 121 ) = C( 121 ) + A( 122 ) * B( 2 )
      C( 121 ) = C( 121 ) + A( 123 ) * B( 4 )
      C( 121 ) = C( 121 ) + A( 124 ) * B( 7 )
      C( 121 ) = C( 121 ) + A( 125 ) * B( 11 )
      C( 121 ) = C( 121 ) + A( 126 ) * B( 16 )
      C( 121 ) = C( 121 ) + A( 127 ) * B( 22 )
      C( 121 ) = C( 121 ) + A( 128 ) * B( 29 )
      C( 121 ) = C( 121 ) + A( 129 ) * B( 37 )
      C( 121 ) = C( 121 ) + A( 130 ) * B( 46 )
      C( 121 ) = C( 121 ) + A( 131 ) * B( 56 )
      C( 121 ) = C( 121 ) + A( 132 ) * B( 67 )
      C( 121 ) = C( 121 ) + A( 133 ) * B( 79 )
      C( 121 ) = C( 121 ) + A( 134 ) * B( 92 )
      C( 121 ) = C( 121 ) + A( 135 ) * B( 106 )
      C( 121 ) = C( 121 ) + A( 136 ) * B( 121 )
!
      C( 122 ) = A( 121 ) * B( 2 )
      C( 122 ) = C( 122 ) + A( 122 ) * B( 3 )
      C( 122 ) = C( 122 ) + A( 123 ) * B( 5 )
      C( 122 ) = C( 122 ) + A( 124 ) * B( 8 )
      C( 122 ) = C( 122 ) + A( 125 ) * B( 12 )
      C( 122 ) = C( 122 ) + A( 126 ) * B( 17 )
      C( 122 ) = C( 122 ) + A( 127 ) * B( 23 )
      C( 122 ) = C( 122 ) + A( 128 ) * B( 30 )
      C( 122 ) = C( 122 ) + A( 129 ) * B( 38 )
      C( 122 ) = C( 122 ) + A( 130 ) * B( 47 )
      C( 122 ) = C( 122 ) + A( 131 ) * B( 57 )
      C( 122 ) = C( 122 ) + A( 132 ) * B( 68 )
      C( 122 ) = C( 122 ) + A( 133 ) * B( 80 )
      C( 122 ) = C( 122 ) + A( 134 ) * B( 93 )
      C( 122 ) = C( 122 ) + A( 135 ) * B( 107 )
      C( 122 ) = C( 122 ) + A( 136 ) * B( 122 )
!
      C( 123 ) = A( 121 ) * B( 4 )
      C( 123 ) = C( 123 ) + A( 122 ) * B( 5 )
      C( 123 ) = C( 123 ) + A( 123 ) * B( 6 )
      C( 123 ) = C( 123 ) + A( 124 ) * B( 9 )
      C( 123 ) = C( 123 ) + A( 125 ) * B( 13 )
      C( 123 ) = C( 123 ) + A( 126 ) * B( 18 )
      C( 123 ) = C( 123 ) + A( 127 ) * B( 24 )
      C( 123 ) = C( 123 ) + A( 128 ) * B( 31 )
      C( 123 ) = C( 123 ) + A( 129 ) * B( 39 )
      C( 123 ) = C( 123 ) + A( 130 ) * B( 48 )
      C( 123 ) = C( 123 ) + A( 131 ) * B( 58 )
      C( 123 ) = C( 123 ) + A( 132 ) * B( 69 )
      C( 123 ) = C( 123 ) + A( 133 ) * B( 81 )
      C( 123 ) = C( 123 ) + A( 134 ) * B( 94 )
      C( 123 ) = C( 123 ) + A( 135 ) * B( 108 )
      C( 123 ) = C( 123 ) + A( 136 ) * B( 123 )
!
      C( 124 ) = A( 121 ) * B( 7 )
      C( 124 ) = C( 124 ) + A( 122 ) * B( 8 )
      C( 124 ) = C( 124 ) + A( 123 ) * B( 9 )
      C( 124 ) = C( 124 ) + A( 124 ) * B( 10 )
      C( 124 ) = C( 124 ) + A( 125 ) * B( 14 )
      C( 124 ) = C( 124 ) + A( 126 ) * B( 19 )
      C( 124 ) = C( 124 ) + A( 127 ) * B( 25 )
      C( 124 ) = C( 124 ) + A( 128 ) * B( 32 )
      C( 124 ) = C( 124 ) + A( 129 ) * B( 40 )
      C( 124 ) = C( 124 ) + A( 130 ) * B( 49 )
      C( 124 ) = C( 124 ) + A( 131 ) * B( 59 )
      C( 124 ) = C( 124 ) + A( 132 ) * B( 70 )
      C( 124 ) = C( 124 ) + A( 133 ) * B( 82 )
      C( 124 ) = C( 124 ) + A( 134 ) * B( 95 )
      C( 124 ) = C( 124 ) + A( 135 ) * B( 109 )
      C( 124 ) = C( 124 ) + A( 136 ) * B( 124 )
!
      C( 125 ) = A( 121 ) * B( 11 )
      C( 125 ) = C( 125 ) + A( 122 ) * B( 12 )
      C( 125 ) = C( 125 ) + A( 123 ) * B( 13 )
      C( 125 ) = C( 125 ) + A( 124 ) * B( 14 )
      C( 125 ) = C( 125 ) + A( 125 ) * B( 15 )
      C( 125 ) = C( 125 ) + A( 126 ) * B( 20 )
      C( 125 ) = C( 125 ) + A( 127 ) * B( 26 )
      C( 125 ) = C( 125 ) + A( 128 ) * B( 33 )
      C( 125 ) = C( 125 ) + A( 129 ) * B( 41 )
      C( 125 ) = C( 125 ) + A( 130 ) * B( 50 )
      C( 125 ) = C( 125 ) + A( 131 ) * B( 60 )
      C( 125 ) = C( 125 ) + A( 132 ) * B( 71 )
      C( 125 ) = C( 125 ) + A( 133 ) * B( 83 )
      C( 125 ) = C( 125 ) + A( 134 ) * B( 96 )
      C( 125 ) = C( 125 ) + A( 135 ) * B( 110 )
      C( 125 ) = C( 125 ) + A( 136 ) * B( 125 )
!
      C( 126 ) = A( 121 ) * B( 16 )
      C( 126 ) = C( 126 ) + A( 122 ) * B( 17 )
      C( 126 ) = C( 126 ) + A( 123 ) * B( 18 )
      C( 126 ) = C( 126 ) + A( 124 ) * B( 19 )
      C( 126 ) = C( 126 ) + A( 125 ) * B( 20 )
      C( 126 ) = C( 126 ) + A( 126 ) * B( 21 )
      C( 126 ) = C( 126 ) + A( 127 ) * B( 27 )
      C( 126 ) = C( 126 ) + A( 128 ) * B( 34 )
      C( 126 ) = C( 126 ) + A( 129 ) * B( 42 )
      C( 126 ) = C( 126 ) + A( 130 ) * B( 51 )
      C( 126 ) = C( 126 ) + A( 131 ) * B( 61 )
      C( 126 ) = C( 126 ) + A( 132 ) * B( 72 )
      C( 126 ) = C( 126 ) + A( 133 ) * B( 84 )
      C( 126 ) = C( 126 ) + A( 134 ) * B( 97 )
      C( 126 ) = C( 126 ) + A( 135 ) * B( 111 )
      C( 126 ) = C( 126 ) + A( 136 ) * B( 126 )
!
      C( 127 ) = A( 121 ) * B( 22 )
      C( 127 ) = C( 127 ) + A( 122 ) * B( 23 )
      C( 127 ) = C( 127 ) + A( 123 ) * B( 24 )
      C( 127 ) = C( 127 ) + A( 124 ) * B( 25 )
      C( 127 ) = C( 127 ) + A( 125 ) * B( 26 )
      C( 127 ) = C( 127 ) + A( 126 ) * B( 27 )
      C( 127 ) = C( 127 ) + A( 127 ) * B( 28 )
      C( 127 ) = C( 127 ) + A( 128 ) * B( 35 )
      C( 127 ) = C( 127 ) + A( 129 ) * B( 43 )
      C( 127 ) = C( 127 ) + A( 130 ) * B( 52 )
      C( 127 ) = C( 127 ) + A( 131 ) * B( 62 )
      C( 127 ) = C( 127 ) + A( 132 ) * B( 73 )
      C( 127 ) = C( 127 ) + A( 133 ) * B( 85 )
      C( 127 ) = C( 127 ) + A( 134 ) * B( 98 )
      C( 127 ) = C( 127 ) + A( 135 ) * B( 112 )
      C( 127 ) = C( 127 ) + A( 136 ) * B( 127 )
!
      C( 128 ) = A( 121 ) * B( 29 )
      C( 128 ) = C( 128 ) + A( 122 ) * B( 30 )
      C( 128 ) = C( 128 ) + A( 123 ) * B( 31 )
      C( 128 ) = C( 128 ) + A( 124 ) * B( 32 )
      C( 128 ) = C( 128 ) + A( 125 ) * B( 33 )
      C( 128 ) = C( 128 ) + A( 126 ) * B( 34 )
      C( 128 ) = C( 128 ) + A( 127 ) * B( 35 )
      C( 128 ) = C( 128 ) + A( 128 ) * B( 36 )
      C( 128 ) = C( 128 ) + A( 129 ) * B( 44 )
      C( 128 ) = C( 128 ) + A( 130 ) * B( 53 )
      C( 128 ) = C( 128 ) + A( 131 ) * B( 63 )
      C( 128 ) = C( 128 ) + A( 132 ) * B( 74 )
      C( 128 ) = C( 128 ) + A( 133 ) * B( 86 )
      C( 128 ) = C( 128 ) + A( 134 ) * B( 99 )
      C( 128 ) = C( 128 ) + A( 135 ) * B( 113 )
      C( 128 ) = C( 128 ) + A( 136 ) * B( 128 )
!
      C( 129 ) = A( 121 ) * B( 37 )
      C( 129 ) = C( 129 ) + A( 122 ) * B( 38 )
      C( 129 ) = C( 129 ) + A( 123 ) * B( 39 )
      C( 129 ) = C( 129 ) + A( 124 ) * B( 40 )
      C( 129 ) = C( 129 ) + A( 125 ) * B( 41 )
      C( 129 ) = C( 129 ) + A( 126 ) * B( 42 )
      C( 129 ) = C( 129 ) + A( 127 ) * B( 43 )
      C( 129 ) = C( 129 ) + A( 128 ) * B( 44 )
      C( 129 ) = C( 129 ) + A( 129 ) * B( 45 )
      C( 129 ) = C( 129 ) + A( 130 ) * B( 54 )
      C( 129 ) = C( 129 ) + A( 131 ) * B( 64 )
      C( 129 ) = C( 129 ) + A( 132 ) * B( 75 )
      C( 129 ) = C( 129 ) + A( 133 ) * B( 87 )
      C( 129 ) = C( 129 ) + A( 134 ) * B( 100 )
      C( 129 ) = C( 129 ) + A( 135 ) * B( 114 )
      C( 129 ) = C( 129 ) + A( 136 ) * B( 129 )
!
      C( 130 ) = A( 121 ) * B( 46 )
      C( 130 ) = C( 130 ) + A( 122 ) * B( 47 )
      C( 130 ) = C( 130 ) + A( 123 ) * B( 48 )
      C( 130 ) = C( 130 ) + A( 124 ) * B( 49 )
      C( 130 ) = C( 130 ) + A( 125 ) * B( 50 )
      C( 130 ) = C( 130 ) + A( 126 ) * B( 51 )
      C( 130 ) = C( 130 ) + A( 127 ) * B( 52 )
      C( 130 ) = C( 130 ) + A( 128 ) * B( 53 )
      C( 130 ) = C( 130 ) + A( 129 ) * B( 54 )
      C( 130 ) = C( 130 ) + A( 130 ) * B( 55 )
      C( 130 ) = C( 130 ) + A( 131 ) * B( 65 )
      C( 130 ) = C( 130 ) + A( 132 ) * B( 76 )
      C( 130 ) = C( 130 ) + A( 133 ) * B( 88 )
      C( 130 ) = C( 130 ) + A( 134 ) * B( 101 )
      C( 130 ) = C( 130 ) + A( 135 ) * B( 115 )
      C( 130 ) = C( 130 ) + A( 136 ) * B( 130 )
!
      C( 131 ) = A( 121 ) * B( 56 )
      C( 131 ) = C( 131 ) + A( 122 ) * B( 57 )
      C( 131 ) = C( 131 ) + A( 123 ) * B( 58 )
      C( 131 ) = C( 131 ) + A( 124 ) * B( 59 )
      C( 131 ) = C( 131 ) + A( 125 ) * B( 60 )
      C( 131 ) = C( 131 ) + A( 126 ) * B( 61 )
      C( 131 ) = C( 131 ) + A( 127 ) * B( 62 )
      C( 131 ) = C( 131 ) + A( 128 ) * B( 63 )
      C( 131 ) = C( 131 ) + A( 129 ) * B( 64 )
      C( 131 ) = C( 131 ) + A( 130 ) * B( 65 )
      C( 131 ) = C( 131 ) + A( 131 ) * B( 66 )
      C( 131 ) = C( 131 ) + A( 132 ) * B( 77 )
      C( 131 ) = C( 131 ) + A( 133 ) * B( 89 )
      C( 131 ) = C( 131 ) + A( 134 ) * B( 102 )
      C( 131 ) = C( 131 ) + A( 135 ) * B( 116 )
      C( 131 ) = C( 131 ) + A( 136 ) * B( 131 )
!
      C( 132 ) = A( 121 ) * B( 67 )
      C( 132 ) = C( 132 ) + A( 122 ) * B( 68 )
      C( 132 ) = C( 132 ) + A( 123 ) * B( 69 )
      C( 132 ) = C( 132 ) + A( 124 ) * B( 70 )
      C( 132 ) = C( 132 ) + A( 125 ) * B( 71 )
      C( 132 ) = C( 132 ) + A( 126 ) * B( 72 )
      C( 132 ) = C( 132 ) + A( 127 ) * B( 73 )
      C( 132 ) = C( 132 ) + A( 128 ) * B( 74 )
      C( 132 ) = C( 132 ) + A( 129 ) * B( 75 )
      C( 132 ) = C( 132 ) + A( 130 ) * B( 76 )
      C( 132 ) = C( 132 ) + A( 131 ) * B( 77 )
      C( 132 ) = C( 132 ) + A( 132 ) * B( 78 )
      C( 132 ) = C( 132 ) + A( 133 ) * B( 90 )
      C( 132 ) = C( 132 ) + A( 134 ) * B( 103 )
      C( 132 ) = C( 132 ) + A( 135 ) * B( 117 )
      C( 132 ) = C( 132 ) + A( 136 ) * B( 132 )
!
      C( 133 ) = A( 121 ) * B( 79 )
      C( 133 ) = C( 133 ) + A( 122 ) * B( 80 )
      C( 133 ) = C( 133 ) + A( 123 ) * B( 81 )
      C( 133 ) = C( 133 ) + A( 124 ) * B( 82 )
      C( 133 ) = C( 133 ) + A( 125 ) * B( 83 )
      C( 133 ) = C( 133 ) + A( 126 ) * B( 84 )
      C( 133 ) = C( 133 ) + A( 127 ) * B( 85 )
      C( 133 ) = C( 133 ) + A( 128 ) * B( 86 )
      C( 133 ) = C( 133 ) + A( 129 ) * B( 87 )
      C( 133 ) = C( 133 ) + A( 130 ) * B( 88 )
      C( 133 ) = C( 133 ) + A( 131 ) * B( 89 )
      C( 133 ) = C( 133 ) + A( 132 ) * B( 90 )
      C( 133 ) = C( 133 ) + A( 133 ) * B( 91 )
      C( 133 ) = C( 133 ) + A( 134 ) * B( 104 )
      C( 133 ) = C( 133 ) + A( 135 ) * B( 118 )
      C( 133 ) = C( 133 ) + A( 136 ) * B( 133 )
!
      C( 134 ) = A( 121 ) * B( 92 )
      C( 134 ) = C( 134 ) + A( 122 ) * B( 93 )
      C( 134 ) = C( 134 ) + A( 123 ) * B( 94 )
      C( 134 ) = C( 134 ) + A( 124 ) * B( 95 )
      C( 134 ) = C( 134 ) + A( 125 ) * B( 96 )
      C( 134 ) = C( 134 ) + A( 126 ) * B( 97 )
      C( 134 ) = C( 134 ) + A( 127 ) * B( 98 )
      C( 134 ) = C( 134 ) + A( 128 ) * B( 99 )
      C( 134 ) = C( 134 ) + A( 129 ) * B( 100 )
      C( 134 ) = C( 134 ) + A( 130 ) * B( 101 )
      C( 134 ) = C( 134 ) + A( 131 ) * B( 102 )
      C( 134 ) = C( 134 ) + A( 132 ) * B( 103 )
      C( 134 ) = C( 134 ) + A( 133 ) * B( 104 )
      C( 134 ) = C( 134 ) + A( 134 ) * B( 105 )
      C( 134 ) = C( 134 ) + A( 135 ) * B( 119 )
      C( 134 ) = C( 134 ) + A( 136 ) * B( 134 )
!
      C( 135 ) = A( 121 ) * B( 106 )
      C( 135 ) = C( 135 ) + A( 122 ) * B( 107 )
      C( 135 ) = C( 135 ) + A( 123 ) * B( 108 )
      C( 135 ) = C( 135 ) + A( 124 ) * B( 109 )
      C( 135 ) = C( 135 ) + A( 125 ) * B( 110 )
      C( 135 ) = C( 135 ) + A( 126 ) * B( 111 )
      C( 135 ) = C( 135 ) + A( 127 ) * B( 112 )
      C( 135 ) = C( 135 ) + A( 128 ) * B( 113 )
      C( 135 ) = C( 135 ) + A( 129 ) * B( 114 )
      C( 135 ) = C( 135 ) + A( 130 ) * B( 115 )
      C( 135 ) = C( 135 ) + A( 131 ) * B( 116 )
      C( 135 ) = C( 135 ) + A( 132 ) * B( 117 )
      C( 135 ) = C( 135 ) + A( 133 ) * B( 118 )
      C( 135 ) = C( 135 ) + A( 134 ) * B( 119 )
      C( 135 ) = C( 135 ) + A( 135 ) * B( 120 )
      C( 135 ) = C( 135 ) + A( 136 ) * B( 135 )
!
      C( 136 ) = A( 121 ) * B( 121 )
      C( 136 ) = C( 136 ) + A( 122 ) * B( 122 )
      C( 136 ) = C( 136 ) + A( 123 ) * B( 123 )
      C( 136 ) = C( 136 ) + A( 124 ) * B( 124 )
      C( 136 ) = C( 136 ) + A( 125 ) * B( 125 )
      C( 136 ) = C( 136 ) + A( 126 ) * B( 126 )
      C( 136 ) = C( 136 ) + A( 127 ) * B( 127 )
      C( 136 ) = C( 136 ) + A( 128 ) * B( 128 )
      C( 136 ) = C( 136 ) + A( 129 ) * B( 129 )
      C( 136 ) = C( 136 ) + A( 130 ) * B( 130 )
      C( 136 ) = C( 136 ) + A( 131 ) * B( 131 )
      C( 136 ) = C( 136 ) + A( 132 ) * B( 132 )
      C( 136 ) = C( 136 ) + A( 133 ) * B( 133 )
      C( 136 ) = C( 136 ) + A( 134 ) * B( 134 )
      C( 136 ) = C( 136 ) + A( 135 ) * B( 135 )
      C( 136 ) = C( 136 ) + A( 136 ) * B( 136 )
!
!
      RETURN
      END !#! SUBROUTINE MUL_MM_SS_S_16
