C-----------------------------------------------------------------------
      SUBROUTINE FPARSER(CARG,MARG,RARG)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:  FPARSER       PARSE REAL NUMBERS FROM A CHARACTER STRING
C   PRGMMR: IREDELL          ORG: NP23        DATE:1998-09-03
C
C ABSTRACT: THIS SUBPROGRAM EXTRACTS REAL NUMBERS FROM A FREE-FORMAT
C   CHARACTER STRING.  IT IS USEFUL FOR PARSING COMMAND ARGUMENTS.
C
C PROGRAM HISTORY LOG:
C 1998-09-03  IREDELL  
C
C USAGE:  CALL FPARSER(CARG,MARG,RARG)
C
C   INPUT ARGUMENT LIST:
C     CARG     - CHARACTER*(*) STRING OF ASCII DIGITS TO PARSE.
C                REAL NUMBERS MAY BE SEPARATED BY A COMMA OR BY BLANKS.
C     MARG     - INTEGER MAXIMUM NUMBER OF REAL NUMBERS TO PARSE.
C
C   OUTPUT ARGUMENT LIST:
C     RARG     - REAL (MARG) NUMBERS PARSED.
C                (FROM 0 TO MARG VALUES MAY BE RETURNED.)
C
C REMARKS:
C   TO DETERMINE THE ACTUAL NUMBER OF REAL NUMBERS FOUND IN THE STRING,
C   RARG SHOULD BE SET TO FILL VALUES BEFORE THE CALL TO FPARSER AND
C   THE NUMBER OF NON-FILL VALUES SHOULD BE COUNTED AFTER THE CALL.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C
C$$$
      CHARACTER*(*) CARG
      REAL RARG(MARG)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      READ(CARG,*,IOSTAT=IOS) RARG
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      END
