!
! --- This file was generated automatically by nut_out v5.0  2006.11.17
! --- written by Leonid Petrov ( Leonid.Petrov@lpetrov.net )
! --- File was created at 2006.11.17-16:49:51
! --- It contains nutation expansion of the model IERS96 luni-solar + planet terms
! --- Phases, frequencies, accelerations of the arguments as well as amplitudes  
! --- of cos and sin components of nutation in longituide and in obliquity
! --- are transformed to the form suitable for computations.
! --- Nutation is considered as a a harmonic variations in polar motion 
! --- Convention: angles of a small rotation are computed as :
! ---             E1 = sum_i {  PMC_i*cos(ARG_i) + PMS_i*sin(ARG_i) }
! ---             E2 = sum_i { -PMC_i*sin(ARG_i) + PMS_i*cos(ARG_i) }
! ---             E3 = 0 
! --- Truncation limit for amplitudes:   0.0010 prad
! --- Units are picoradians for amplitudes  and  1.0D-24 rad/sec for their rates
! --- in total  750 consitiuents are presented
! --- Epsilon_o =  0.4090928041 rad
! --- OM_preces = -7.08618327D-12 rad/sec
!
      INTEGER*4   N_NUT, I_NUT
      PARAMETER ( N_NUT = 750 )
      INTEGER*4  IND_NUT(N_NUT)
      CHARACTER  TYP_NUT(N_NUT)*1, MODEL_NUT*40
      REAL*8     PHAS_NUT(N_NUT), FREQ_NUT(N_NUT), ACCL_NUT(N_NUT)
      REAL*8     PMC_NUT(N_NUT),      PMS_NUT(N_NUT) 
      REAL*8     PMC_RATE_NUT(N_NUT), PMS_RATE_NUT(N_NUT)
      REAL*8     EPSILON_0_NUT
      PARAMETER  ( EPSILON_0_NUT = 0.4090928041D0 ) ! rad
      PARAMETER  ( MODEL_NUT = 'IERS96 luni-solar + planet terms        ' )
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1,10 ) &
     &             /            &
     & 0.0484511887D0, -9.108738374180D-05, -7.3864D-23,  198, 'R', & !    1
     &        -13.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6458148159D0, -9.073417926490D-05,  6.0248D-25,  168, 'R', & !    2
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8066434615D0, -8.880138516554D-05, -1.1680D-22,  145, 'R', & !    3
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5864462887D0, -8.845887765071D-05, -3.5064D-23,  154, 'R', & !    4
     &          5.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4040070887D0, -8.844818068865D-05, -4.2334D-23,   80, 'R', & !    5
     &          9.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 2.3608819115D0, -8.824908381341D-05, -4.2856D-23,  205, 'R', & !    6
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1838099159D0, -8.810567317382D-05,  3.9402D-23,  174, 'R', & !    7
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0013707159D0, -8.809497621176D-05,  3.2132D-23,   98, 'R', & !    8
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9582455387D0, -8.789587933652D-05,  3.1610D-23,  201, 'R', & !    9
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0614532544D0, -8.617287907446D-05, -7.8001D-23,  104, 'R', & !   10
     &         12.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  11,  20 ) &
     &             /                 &
     & 4.1621993615D0, -8.616218211240D-05, -8.5271D-23,   53, 'R', & !   11
     &         21.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.8026881659D0, -8.600807451074D-05, -1.0282D-23,  178, 'R', & !   12
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1190741844D0, -8.596308523716D-05, -8.5793D-23,  250, 'R', & !   13
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8412560815D0, -8.583037155963D-05,  3.7354D-24,  217, 'R', & !   14
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6588168815D0, -8.581967459757D-05, -3.5346D-24,   73, 'R', & !   15
     &         31.7D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.7595629887D0, -8.580897763550D-05, -1.0804D-23,   35, 'R', & !   16
     &         47.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.3859547415D0, -8.576396934210D-05, -8.3183D-23,  249, 'R', & !   17
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6156917044D0, -8.562057772233D-05, -4.0567D-24,  219, 'R', & !   18
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7164378115D0, -8.560988076026D-05, -1.1327D-23,  101, 'R', & !   19
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2561805087D0, -8.546647012067D-05,  7.0932D-23,  140, 'R', & !   20
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  21,  30 ) &
     &             /                 &
     & 5.3569266159D0, -8.545577315861D-05,  6.3662D-23,   70, 'R', & !   21
     &         14.4D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.9833183687D0, -8.541076486520D-05, -8.7159D-24,  216, 'R', & !   22
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3138014387D0, -8.525667628337D-05,  6.3140D-23,  164, 'R', & !   23
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9203916344D0, -8.387618353614D-05, -1.2821D-22,  207, 'R', & !   24
     &         11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4601343315D0, -8.373277289655D-05, -4.5949D-23,  246, 'R', & !   25
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2776951315D0, -8.372207593449D-05, -5.3219D-23,  124, 'R', & !   26
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6898712944D0, -8.358938127678D-05,  3.3177D-23,  161, 'R', & !   27
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5994483544D0, -8.354437298337D-05, -3.9201D-23,  147, 'R', & !   28
     &         37.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4170091544D0, -8.353367602131D-05, -4.6471D-23,   44, 'R', & !   29
     &        138.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.2345699544D0, -8.352297905925D-05, -5.3741D-23,   22, 'R', & !   30
     &        213.5D0,        -2.0D0,     -768.1D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  31,  40 ) &
     &             /                 &
     & 3.1441470144D0, -8.347797076584D-05, -1.2612D-22,  206, 'R', & !   31
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0574979587D0, -8.337956841966D-05,  2.8517D-23,  213, 'R', & !   32
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8750587587D0, -8.336887145759D-05,  2.1247D-23,  106, 'R', & !   33
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8572836215D0, -8.335707378286D-05, -9.2380D-24,  240, 'R', & !   34
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6748444215D0, -8.334637682080D-05, -1.6508D-23,  134, 'R', & !   35
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3738839772D0, -8.333457914607D-05, -4.6994D-23,  247, 'R', & !   36
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1914447772D0, -8.332388218401D-05, -5.4263D-23,  114, 'R', & !   37
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1968119815D0, -8.319116850648D-05,  3.5265D-23,  141, 'R', & !   38
     &         42.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0143727815D0, -8.318047154442D-05,  2.7995D-23,   38, 'R', & !   39
     &        171.8D0,        -0.5D0,    -1073.7D0,      0.0D0,     & !
     & 0.8319335815D0, -8.316977458236D-05,  2.0725D-23,   20, 'R', & !   40
     &        266.6D0,        -2.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  41,  50 ) &
     &             /                 &
     & 5.9239498415D0, -8.313546325101D-05, -4.4383D-23,  254, 'P', & !   41
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7415106415D0, -8.312476628895D-05, -5.1653D-23,  128, 'R', & !   42
     &         59.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5590714415D0, -8.311406932689D-05, -5.8923D-23,  190, 'R', & !   43
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2722080487D0, -8.299317234391D-05,  5.7959D-23,  226, 'R', & !   44
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9712476044D0, -8.298137466918D-05,  2.7473D-23,  109, 'R', & !   45
     &         15.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7888084044D0, -8.297067770712D-05,  2.0203D-23,   59, 'R', & !   46
     &         21.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.6117364087D0, -8.282726706753D-05,  1.0246D-22,  155, 'R', & !   47
     &          5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4292972087D0, -8.281657010546D-05,  9.5192D-23,   77, 'R', & !   48
     &          9.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7456832272D0, -8.277158083188D-05,  1.9681D-23,  183, 'R', & !   49
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3388742687D0, -8.277156181206D-05,  2.2814D-23,  135, 'R', & !   50
     &         48.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  51,  60 ) &
     &             /                 &
     & 2.1564350687D0, -8.276086484999D-05,  1.5544D-23,  166, 'R', & !   51
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3861720315D0, -8.261747323022D-05,  9.4670D-23,  212, 'R', & !   52
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2957490915D0, -8.257246493682D-05,  2.2292D-23,  237, 'R', & !   53
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4480635672D0, -8.130338270053D-05, -9.7602D-24,  153, 'R', & !   54
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1752014272D0, -8.124767744506D-05, -8.9408D-23,  179, 'R', & !   55
     &         -5.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9927622272D0, -8.123698048299D-05, -9.6678D-23,   83, 'R', & !   56
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8156902315D0, -8.109356984340D-05, -1.4419D-23,  123, 'R', & !   57
     &         -8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6332510315D0, -8.108287288134D-05, -2.1689D-23,   61, 'R', & !   58
     &        -19.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.4330366944D0, -8.106037824455D-05, -5.9445D-23,  245, 'R', & !   59
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2278663944D0, -8.096087518570D-05,  7.1976D-23,  159, 'R', & !   60
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  61,  70 ) &
     &             /                 &
     & 4.0454271944D0, -8.095017822363D-05,  6.4706D-23,   78, 'R', & !   61
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8542581472D0, -8.091586689229D-05, -4.0165D-25,  193, 'P', & !   62
     &         21.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0735254987D0, -8.090627064289D-05,  1.5544D-23,  146, 'R', & !   63
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6718189472D0, -8.090516993023D-05, -7.6716D-24,   65, 'R', & !   64
     &        295.4D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 4.7725650544D0, -8.089447296816D-05, -1.4942D-23,   17, 'R', & !   65
     &       1409.1D0,        -7.8D0,    -1222.2D0,      0.0D0,     & !
     & 2.5901258544D0, -8.088377600610D-05, -2.2211D-23,    9, 'R', & !   66
     &       2202.5D0,       -11.6D0,    -5831.0D0,      0.0D0,     & !
     & 1.3989568072D0, -8.084946467476D-05, -8.7320D-23,  172, 'P', & !   67
     &         30.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4997029144D0, -8.083876771269D-05, -9.4590D-23,   82, 'R', & !   68
     &        139.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 3.3172637144D0, -8.082807075063D-05, -1.0186D-22,  224, 'R', & !   69
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4130538587D0, -8.074036536651D-05,  6.0047D-23,  228, 'R', & !   70
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  71,  80 ) &
     &             /                 &
     & 3.2306146587D0, -8.072966840445D-05,  5.2777D-23,  105, 'R', & !   71
     &         -4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9296542144D0, -8.071787072972D-05,  2.2292D-23,  136, 'R', & !   72
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0304003215D0, -8.070717376765D-05,  1.5022D-23,   69, 'R', & !   73
     &        -15.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7294398772D0, -8.069537609293D-05, -1.5464D-23,  115, 'R', & !   74
     &         12.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5470006772D0, -8.068467913086D-05, -2.2734D-23,   55, 'R', & !   75
     &         21.4D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 6.1401917187D0, -8.068466011104D-05, -1.9601D-23,  203, 'R', & !   76
     &         -9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2691825744D0, -8.055196545333D-05,  6.6795D-23,  122, 'R', & !   77
     &         64.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3699286815D0, -8.054126849127D-05,  5.9525D-23,   33, 'R', & !   78
     &        279.9D0,        -2.9D0,     -305.5D0,      0.0D0,     & !
     & 3.1874894815D0, -8.053057152921D-05,  5.2255D-23,   16, 'R', & !   79
     &        439.4D0,        -2.5D0,    -1073.7D0,      0.0D0,     & !
     & 1.9963204344D0, -8.049626019786D-05, -1.2853D-23,  107, 'P', & !   80
     &        113.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  81,  90 ) &
     &             /                 &
     & 6.0970665415D0, -8.048556323580D-05, -2.0123D-23,   49, 'R', & !   81
     &        585.0D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.9146273415D0, -8.047486627374D-05, -2.7393D-23,   81, 'R', & !   82
     &         27.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3268035044D0, -8.034217161603D-05,  5.9003D-23,  112, 'R', & !   83
     &         13.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1443643044D0, -8.033147465397D-05,  5.1733D-23,   56, 'R', & !   84
     &         23.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 6.0539413644D0, -8.028646636056D-05, -2.0645D-23,  139, 'R', & !   85
     &         46.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5936840615D0, -8.014305572097D-05,  6.1614D-23,  184, 'P', & !   86
     &         26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1012391272D0, -8.013237777873D-05,  5.1211D-23,  210, 'R', & !   87
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4112448615D0, -8.013235875891D-05,  5.4344D-23,   88, 'R', & !   88
     &        118.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5119909687D0, -8.012166179685D-05,  4.7074D-23,  158, 'R', & !   89
     &          4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3681196844D0, -7.993326188367D-05,  5.3822D-23,  196, 'R', & !   90
     &         14.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT=  91, 100 ) &
     &             /                 &
     & 4.3914433044D0, -7.879687430508D-05, -6.4626D-23,  148, 'R', & !   91
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7028733600D0, -7.867487660944D-05,  2.9040D-23,  175, 'R', & !   92
     &         -5.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8036194672D0, -7.866417964738D-05,  2.1770D-23,   84, 'R', & !   93
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0319321087D0, -7.864276670343D-05,  1.0363D-23,  214, 'R', & !   94
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4300112200D0, -7.861917135397D-05, -5.0608D-23,  233, 'P', & !   95
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2475720200D0, -7.860847439191D-05, -5.7878D-23,   79, 'R', & !   96
     &        -33.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3483181272D0, -7.859777742985D-05, -6.5148D-23,   42, 'R', & !   97
     &        -51.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8880608244D0, -7.845436679025D-05,  1.7110D-23,   86, 'R', & !   98
     &        -23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9888069315D0, -7.844366982819D-05,  9.8405D-24,   37, 'R', & !   99
     &        -60.3D0,         1.5D0,    -2147.4D0,      0.0D0,     & !
     & 1.5054072872D0, -7.842117519140D-05, -2.7915D-23,  138, 'R', & !  100
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 101, 110 ) &
     &             /                 &
     & 4.3051929500D0, -7.839868055461D-05, -6.5670D-23,  248, 'R', & !  101
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6151986844D0, -7.839866153479D-05, -6.2538D-23,  162, 'R', & !  102
     &        -27.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1177977872D0, -7.831097517049D-05,  9.6236D-23,  232, 'R', & !  103
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2098140472D0, -7.827666383914D-05,  3.1128D-23,   95, 'P', & !  104
     &        152.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0273748472D0, -7.826596687708D-05,  2.3858D-23,   26, 'R', & !  105
     &       2356.8D0,        -9.2D0,        0.0D0,      0.0D0,     & !
     & 0.8449356472D0, -7.825526991502D-05,  1.6588D-23,    8, 'R', & !  106
     &      11299.4D0,       -46.7D0,    -9769.0D0,      0.0D0,     & !
     & 3.3188633611D0, -7.824530215831D-05,  4.0848D-23,  374, 'R', & !  107
     &         -0.4D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.9456817544D0, -7.824457295295D-05,  9.3184D-24,    3, 'R', & !  108
     &      17654.4D0,       -73.8D0,   -43898.4D0,      0.0D0,     & !
     & 0.2893148405D0, -7.824384374760D-05, -2.2211D-23,  375, 'R', & !  109
     &          0.4D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 2.7632425544D0, -7.823387599089D-05,  2.0484D-24,  173, 'R', & !  110
     &         19.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 111, 120 ) &
     &             /                 &
     & 5.0554731515D0, -7.822205929634D-05, -2.5304D-23,  243, 'R', & !  111
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9369519072D0, -7.822095858367D-05, -4.8520D-23,  252, 'P', & !  112
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7545127072D0, -7.821026162161D-05, -5.5790D-23,   60, 'P', & !  113
     &        525.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.5720735072D0, -7.819956465955D-05, -6.3060D-23,   25, 'R', & !  114
     &       2668.2D0,       -10.1D0,        0.0D0,      0.0D0,     & !
     & 5.6728196144D0, -7.818886769748D-05, -7.0330D-23,   62, 'R', & !  115
     &        -66.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4903804144D0, -7.817817073542D-05, -7.7600D-23,  222, 'R', & !  116
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1027709144D0, -7.806797071451D-05,  4.6552D-23,  225, 'R', & !  117
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8018104700D0, -7.805617303978D-05,  1.6066D-23,   93, 'R', & !  118
     &         21.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3950015115D0, -7.805615401996D-05,  1.9199D-23,  238, 'P', & !  119
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9025565772D0, -7.804547607772D-05,  8.7962D-24,   39, 'R', & !  120
     &         55.7D0,         1.0D0,     2147.4D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 121, 130 ) &
     &             /                 &
     & 2.2125623115D0, -7.804545705789D-05,  1.1929D-23,  117, 'R', & !  121
     &        -64.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0301231115D0, -7.803476009583D-05,  4.6592D-24,  156, 'R', & !  122
     &         -4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0123479744D0, -7.802296242110D-05, -2.5826D-23,  157, 'R', & !  123
     &        -31.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5289483300D0, -7.800046778431D-05, -6.3582D-23,  149, 'R', & !  124
     &         36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6247384744D0, -7.791276240019D-05,  9.8325D-23,  255, 'R', & !  125
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4422992744D0, -7.790206543812D-05,  9.1055D-23,  151, 'R', & !  126
     &         -5.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5430453815D0, -7.789136847606D-05,  8.3785D-23,   74, 'R', & !  127
     &        -11.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2511302272D0, -7.786775410678D-05,  2.5947D-23,  182, 'P', & !  128
     &        -24.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3518763344D0, -7.785705714472D-05,  1.8677D-23,   46, 'P', & !  129
     &       1134.7D0,        -4.4D0,      305.5D0,      0.0D0,     & !
     & 4.8594314000D0, -7.784637920248D-05,  8.2741D-24,  215, 'R', & !  130
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 131, 140 ) &
     &             /                 &
     & 2.1694371344D0, -7.784636018265D-05,  1.1407D-23,   19, 'R', & !  131
     &       5806.4D0,       -22.7D0,      305.5D0,      0.0D0,     & !
     & 6.2701832415D0, -7.783566322059D-05,  4.1370D-24,   40, 'R', & !  132
     &        184.2D0,         0.0D0,     -305.5D0,      0.0D0,     & !
     & 4.0877440415D0, -7.782496625853D-05, -3.1329D-24,  116, 'R', & !  133
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8965749944D0, -7.779065492719D-05, -6.8241D-23,  231, 'P', & !  134
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4999202044D0, -7.769227160082D-05,  8.3263D-23,  257, 'R', & !  135
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6097116015D0, -7.766975794421D-05,  4.8640D-23,  208, 'R', & !  136
     &         -9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3087511572D0, -7.765796026948D-05,  1.8155D-23,  131, 'P', & !  137
     &         75.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1263119572D0, -7.764726330742D-05,  1.0885D-23,   54, 'R', & !  138
     &        397.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 6.2270580644D0, -7.763656634535D-05,  3.6149D-24,  167, 'R', & !  139
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9492399615D0, -7.750385266782D-05,  9.3144D-23,  191, 'P', & !  140
     &         22.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 141, 150 ) &
     &             /                 &
     & 2.7668007615D0, -7.749315570576D-05,  8.5874D-23,   90, 'R', & !  141
     &        125.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5843615615D0, -7.748245874370D-05,  7.8604D-23,  186, 'R', & !  142
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0831867800D0, -7.744816643218D-05,  1.0363D-23,  176, 'R', & !  143
     &         20.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4939386215D0, -7.743745045029D-05,  6.2256D-24,  163, 'P', & !  144
     &         37.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7236755844D0, -7.729405883052D-05,  8.5351D-23,  211, 'R', & !  145
     &         11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6462530972D0, -7.616836821400D-05, -2.5826D-23,  144, 'R', & !  146
     &         -6.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4638138972D0, -7.615767125194D-05, -3.3096D-23,   76, 'R', & !  147
     &         -9.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8759900600D0, -7.602497659423D-05,  5.3299D-23,  209, 'R', & !  148
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7855671200D0, -7.597996830083D-05, -1.9079D-23,  111, 'P', & !  149
     &        -74.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6031279200D0, -7.596927133876D-05, -2.6349D-23,   41, 'R', & !  150
     &       -184.9D0,         0.0D0,      305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 151, 160 ) &
     &             /                 &
     & 0.4206887200D0, -7.595857437670D-05, -3.3618D-23,   23, 'R', & !  151
     &       -230.7D0,         0.0D0,      768.1D0,      0.0D0,     & !
     & 3.2436167244D0, -7.581516373711D-05,  4.8640D-23,  194, 'R', & !  152
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0611775244D0, -7.580446677504D-05,  4.1370D-23,  118, 'R', & !  153
     &         -3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0434023872D0, -7.579266910032D-05,  1.0885D-23,  187, 'R', & !  154
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8609631872D0, -7.578197213825D-05,  3.6149D-24,   97, 'R', & !  155
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1531937844D0, -7.577015544370D-05, -2.3738D-23,  150, 'P', & !  156
     &        -49.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3775635428D0, -7.575947750146D-05, -3.4141D-23,  220, 'R', & !  157
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9707545844D0, -7.575945848164D-05, -3.1008D-23,   64, 'R', & !  158
     &       -316.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7883153844D0, -7.574876151957D-05, -3.8278D-23,  127, 'R', & !  159
     &         13.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2821846400D0, -7.563746078600D-05,  6.2658D-23,  142, 'P', & !  160
     &        -60.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 161, 170 ) &
     &             /                 &
     & 5.3829307472D0, -7.562676382393D-05,  5.5388D-23,   58, 'R', & !  161
     &       -379.9D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.2004915472D0, -7.561606686187D-05,  4.8118D-23,   24, 'R', & !  162
     &       -637.4D0,         1.0D0,      611.1D0,      0.0D0,     & !
     & 1.0180523472D0, -7.560536989981D-05,  4.0848D-23,   12, 'R', & !  163
     &      -1016.3D0,         3.4D0,     2610.0D0,      0.0D0,     & !
     & 4.6112433887D0, -7.560535087998D-05,  4.3981D-23,  229, 'R', & !  164
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6552800772D0, -7.559356271517D-05,  1.1929D-23,  258, 'R', & !  165
     &          0.0D0,         7.7D0,        0.0D0,      0.0D0,     & !
     & 3.8178380100D0, -7.558287526302D-05,  3.0927D-24,  202, 'R', & !  166
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4728408772D0, -7.558286575310D-05,  4.6592D-24,  259, 'R', & !  167
     &          0.0D0,        18.5D0,        0.0D0,      0.0D0,     & !
     & 1.1278437444D0, -7.558285624319D-05,  6.2256D-24,  125, 'R', & !  168
     &         55.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0093225000D0, -7.558175553053D-05, -1.6990D-23,   75, 'P', & !  169
     &       -279.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2285898515D0, -7.557215928113D-05, -1.0443D-24,  236, 'R', & !  170
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 171, 180 ) &
     &             /                 &
     & 6.1100686072D0, -7.557105856846D-05, -2.4260D-23,   15, 'P', & !  171
     &      13203.7D0,       -37.7D0,     1833.3D0,      0.0D0,     & !
     & 3.9276294072D0, -7.556036160640D-05, -3.1530D-23,    7, 'R', & !  172
     &      66909.4D0,      -189.0D0,     2138.8D0,      0.0D0,     & !
     & 1.7451902072D0, -7.554966464434D-05, -3.8800D-23,   14, 'R', & !  173
     &      -1967.0D0,         5.3D0,     1833.3D0,      0.0D0,     & !
     & 5.8459363144D0, -7.553896768227D-05, -4.6070D-23,   67, 'R', & !  174
     &         16.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6547672672D0, -7.550465635093D-05, -1.1118D-22,  235, 'P', & !  175
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1573663700D0, -7.541696998663D-05,  4.7596D-23,  251, 'R', & !  176
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4673721044D0, -7.541695096681D-05,  5.0729D-23,  244, 'P', & !  177
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9749271700D0, -7.540627302457D-05,  4.0326D-23,  180, 'R', & !  178
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5681182115D0, -7.540625400474D-05,  4.3459D-23,  100, 'R', & !  179
     &        -90.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3856790115D0, -7.539555704268D-05,  3.6189D-23,  185, 'R', & !  180
     &          4.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 181, 190 ) &
     &             /                 &
     & 3.2671577672D0, -7.539445633002D-05,  1.2973D-23,  130, 'P', & !  181
     &        -75.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0847185672D0, -7.538375936795D-05,  5.7035D-24,   57, 'R', & !  182
     &       -399.6D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.1854646744D0, -7.537306240589D-05, -1.5665D-24,  121, 'R', & !  183
     &         12.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0669434300D0, -7.537196169323D-05, -2.4782D-23,  133, 'P', & !  184
     &         71.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8845042300D0, -7.536126473116D-05, -3.2052D-23,   51, 'R', & !  185
     &        444.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.7020650300D0, -7.535056776910D-05, -3.9322D-23,  102, 'R', & !  186
     &        -16.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6066861272D0, -7.522855105363D-05,  5.7477D-23,  137, 'P', & !  187
     &        -64.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4242469272D0, -7.521785409157D-05,  5.0207D-23,   31, 'P', & !  188
     &       2922.3D0,        -8.7D0,      305.5D0,      0.0D0,     & !
     & 4.5249930344D0, -7.520715712951D-05,  4.2937D-23,   13, 'R', & !  189
     &      14830.7D0,       -40.1D0,      305.5D0,      0.0D0,     & !
     & 2.3425538344D0, -7.519646016744D-05,  3.5667D-23,   28, 'R', & !  190
     &       -478.9D0,         1.0D0,      305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 191, 200 ) &
     &             /                 &
     & 0.1601146344D0, -7.518576320538D-05,  2.8397D-23,  129, 'R', & !  191
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8413790528D0, -7.516216785592D-05, -3.2574D-23,  221, 'R', & !  192
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1513847872D0, -7.516214883610D-05, -2.9441D-23,  132, 'P', & !  193
     &        -73.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2521308944D0, -7.515145187404D-05, -3.6711D-23,   66, 'P', & !  194
     &        451.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 3.0696916944D0, -7.514075491197D-05, -4.3981D-23,  126, 'R', & !  195
     &        -55.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6820821944D0, -7.503055489106D-05,  8.0170D-23,  253, 'R', & !  196
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3811217500D0, -7.501875721633D-05,  4.9685D-23,   99, 'P', & !  197
     &        136.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4818678572D0, -7.500806025427D-05,  4.2415D-23,   47, 'R', & !  198
     &        696.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.2994286572D0, -7.499736329221D-05,  3.5145D-23,   91, 'R', & !  199
     &        -22.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5916592544D0, -7.498554659765D-05,  7.7921D-24,  160, 'P', & !  200
     &         38.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 201, 210 ) &
     &             /                 &
     & 5.2090057172D0, -7.495235499880D-05, -3.7233D-23,  195, 'P', & !  201
     &         22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1223566615D0, -7.485395265261D-05,  1.1740D-22,  197, 'R', & !  202
     &         15.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4387426800D0, -7.480896337903D-05,  4.1893D-23,  165, 'R', & !  203
     &         26.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7487484144D0, -7.480894435921D-05,  4.5025D-23,  218, 'P', & !  204
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8494945215D0, -7.479824739714D-05,  3.7755D-23,  110, 'P', & !  205
     &        103.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6670553215D0, -7.478755043508D-05,  3.0486D-23,  227, 'R', & !  206
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9056201515D0, -7.391666194927D-05, -5.2215D-25,  119, 'R', & !  207
     &          3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0449341744D0, -7.372826203609D-05,  6.2256D-24,  189, 'R', & !  208
     &         -4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8624949744D0, -7.371756507403D-05, -1.0443D-24,   29, 'R', & !  209
     &        138.9D0,         0.5D0,     -933.7D0,      0.0D0,     & !
     & 0.4683970452D0, -7.368399885485D-05, -2.1637D-24,  373, 'R', & !  210
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 211, 220 ) &
     &             /                 &
     & 4.3613201928D0, -7.368327276251D-05, -6.9285D-23,  192, 'R', & !  211
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356845298398D-05, -2.1637D-24,  372, 'R', & !  212
     &         -3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4529886994D0, -7.354386270325D-05,  0.0000D+00,  371, 'R', & !  213
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9010628900D0, -7.353986212292D-05,  1.2973D-23,  120, 'P', & !  214
     &        -63.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0018089972D0, -7.352916516085D-05,  5.7035D-24,   50, 'R', & !  215
     &       -122.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.6919001784D0, -7.351927242253D-05,  2.1637D-24,  370, 'R', & !  216
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8193697972D0, -7.351846819879D-05, -1.5665D-24,    6, 'R', & !  217
     &       4557.5D0,        -8.4D0,   -14651.1D0,      0.0D0,     & !
     & 5.3930805700D0, -7.350585340232D-05, -2.1637D-24,  369, 'R', & !  218
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6223208622D0, -7.350168508941D-05, -2.1637D-24,  368, 'R', & !  219
     &         -3.2D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 5.6191554600D0, -7.349597356200D-05, -3.9322D-23,  241, 'R', & !  220
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 221, 230 ) &
     &             /                 &
     & 0.2616858442D0, -7.349389515472D-05, -2.1637D-24,  367, 'R', & !  221
     &          0.0D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 2.2218673592D0, -7.348490019560D-05, -2.1637D-24,  366, 'R', & !  222
     &         -0.5D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.6282007500D0, -7.348415686745D-05, -6.6675D-23,  181, 'P', & !  223
     &         29.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7289468572D0, -7.347345990538D-05, -7.3944D-23,   92, 'P', & !  224
     &        113.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5465076572D0, -7.346276294332D-05, -8.1214D-23,  223, 'R', & !  225
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344391215398D-05, -2.1637D-24,  365, 'R', & !  226
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341932187325D-05,  0.0000D+00,  364, 'R', & !  227
     &         10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1145765614D0, -7.339473159253D-05,  2.1637D-24,  363, 'R', & !  228
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6843622272D0, -7.336935432472D-05, -2.1637D-24,  362, 'R', & !  229
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 3.0403769128D0, -7.335146220974D-05,  1.9721D-23,   85, 'P', & !  230
     &       -190.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 231, 240 ) &
     &             /                 &
     & 3.5373332002D0, -7.334394615248D-05, -2.1637D-24,  361, 'P', & !  231
     &         -6.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 0.8579377128D0, -7.334076524768D-05,  1.2451D-23,   30, 'P', & !  232
     &      -2136.5D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 2.1766981822D0, -7.333615621779D-05, -2.1637D-24,  360, 'R', & !  233
     &         -0.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 4.6891237815D0, -7.333198790489D-05, -2.1637D-24,  359, 'R', & !  234
     &         -7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 4.9586838200D0, -7.333006828562D-05,  5.1813D-24,   11, 'R', & !  235
     &      -4357.3D0,         7.7D0,     3509.5D0,      0.0D0,     & !
     & 2.2686895544D0, -7.333004926579D-05,  8.3142D-24,  239, 'P', & !  236
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1621851852D0, -7.332020466772D-05, -2.1637D-24,  358, 'R', & !  237
     &         25.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.9432152724D0, -7.331948296618D-05, -2.1637D-24,  357, 'P', & !  238
     &          0.5D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 2.7762446792D0, -7.331937132398D-05, -2.1637D-24,  356, 'R', & !  239
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7762446200D0, -7.331937132355D-05, -2.0886D-24,    2, 'R', & !  240
     &     119216.9D0,      -225.7D0,  -282716.8D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 241, 250 ) &
     &             /                 &
     & 0.0862503544D0, -7.331935230373D-05,  1.0443D-24,   34, 'R', & !  241
     &       1645.2D0,        -3.4D0,    -2444.4D0,      0.0D0,     & !
     & 5.8924593931D0, -7.331925968178D-05, -2.1637D-24,  355, 'R', & !  242
     &         -0.5D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 5.3903041732D0, -7.331853798024D-05, -2.1637D-24,  354, 'P', & !  243
     &         -1.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5938054200D0, -7.330867436149D-05, -9.3585D-24,   87, 'R', & !  244
     &         70.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1869964615D0, -7.330865534167D-05, -6.2256D-24,  188, 'R', & !  245
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8633655768D0, -7.330675474306D-05, -2.1637D-24,  353, 'R', & !  246
     &          7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 3.3757911762D0, -7.330258643016D-05, -2.1637D-24,  352, 'R', & !  247
     &          2.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.7675147728D0, -7.329575695427D-05, -5.9927D-23,  169, 'P', & !  248
     &        -36.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329479649547D-05, -2.1637D-24,  351, 'R', & !  249
     &          4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329478104325D-05,  0.0000D+00,  350, 'R', & !  250
     &          9.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 251, 260 ) &
     &             /                 &
     & 3.9753376732D0, -7.328578608412D-05,  0.0000D+00,  349, 'R', & !  251
     &         37.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5850755728D0, -7.328505999221D-05, -6.7197D-23,   43, 'P', & !  252
     &       1295.2D0,        -1.0D0,      305.5D0,      0.0D0,     & !
     & 5.6858216800D0, -7.327436303015D-05, -7.4467D-23,   21, 'P', & !  253
     &       4719.6D0,        -9.2D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327019076253D-05,  2.1637D-24,  348, 'R', & !  254
     &        -23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8681271312D0, -7.326938832323D-05, -2.1637D-24,  347, 'P', & !  255
     &          0.0D0,         2.0D0,        0.0D0,      0.0D0,     & !
     & 4.5748841702D0, -7.326900119031D-05,  0.0000D+00,  346, 'R', & !  256
     &          7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 3.5033824800D0, -7.326366606808D-05, -8.1737D-23,   48, 'R', & !  257
     &       -142.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.3209432800D0, -7.325296910602D-05, -8.9007D-23,  204, 'R', & !  258
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319483049398D-05, -2.1637D-24,  344, 'P', & !  259
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319482276787D-05, -1.0819D-24,  345, 'P', & !  260
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 261, 270 ) &
     &             /                 &
     & 5.5991726244D0, -7.317596068396D-05,  8.0170D-23,  234, 'R', & !  261
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317024021325D-05,  0.0000D+00,  343, 'R', & !  262
     &        -57.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317023248714D-05,  1.0819D-24,  342, 'R', & !  263
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 4.2982121800D0, -7.316416300923D-05,  4.9685D-23,  242, 'P', & !  264
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3306219992D0, -7.315384245236D-05, -2.1637D-24,  341, 'R', & !  265
     &         -2.9D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 2.1157729800D0, -7.315346604717D-05,  4.2415D-23,  143, 'R', & !  266
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314564993253D-05,  2.1637D-24,  340, 'R', & !  267
     &        -42.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314484749323D-05, -2.1637D-24,  339, 'P', & !  268
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 0.8148125356D0, -7.314166837244D-05,  1.1929D-23,  103, 'P', & !  269
     &         94.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4080035772D0, -7.314164935262D-05,  1.5062D-23,  113, 'P', & !  270
     &       -117.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 271, 280 ) &
     &             /                 &
     & 3.9301684962D0, -7.313705755854D-05, -2.1637D-24,  338, 'R', & !  271
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1594087884D0, -7.313288924564D-05, -2.1637D-24,  337, 'R', & !  272
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9155586428D0, -7.313097141038D-05,  4.6592D-24,   45, 'R', & !  273
     &        197.0D0,         0.0D0,    -1073.7D0,      0.0D0,     & !
     & 2.2255643772D0, -7.313095239055D-05,  7.7921D-24,   32, 'P', & !  274
     &       2779.9D0,        10.6D0,      462.6D0,      0.0D0,     & !
     & 2.7331194428D0, -7.312027444831D-05, -2.6108D-24,   10, 'R', & !  275
     &      -2438.1D0,       -23.3D0,     8072.3D0,      0.0D0,     & !
     & 0.0431251772D0, -7.312025542849D-05,  5.2215D-25,    5, 'R', & !  276
     &     160182.5D0,      1560.9D0,  -125814.5D0,      0.0D0,     & !
     & 5.4037317502D0, -7.311349817204D-05,  0.0000D+00,  336, 'R', & !  277
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1438712844D0, -7.310955846643D-05, -6.7478D-24,   27, 'R', & !  278
     &        721.7D0,        17.4D0,     -916.6D0,      0.0D0,     & !
     & 5.0253500400D0, -7.310845775376D-05, -2.9963D-23,   94, 'P', & !  279
     &       -216.2D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 2.6168358908D0, -7.310764063159D-05,  0.0000D+00,  335, 'R', & !  280
     &        -36.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 281, 290 ) &
     &             /                 &
     & 5.1292614902D0, -7.310347231869D-05,  0.0000D+00,  334, 'R', & !  281
     &       -118.6D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 1.9614320844D0, -7.309886150436D-05, -1.4018D-23,   96, 'R', & !  282
     &        -13.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.8429108400D0, -7.309776079170D-05, -3.7233D-23,   68, 'P', & !  283
     &       -523.8D0,       -67.7D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309568238400D-05,  0.0000D+00,  333, 'R', & !  284
     &          0.0D0,        28.0D0,        0.0D0,      0.0D0,     & !
     & 0.7039567885D0, -7.309502405068D-05,  0.0000D+00,  332, 'R', & !  285
     &         -7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 0.6604716400D0, -7.308706382964D-05, -4.4503D-23,  177, 'R', & !  286
     &          4.3D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 5.7288079872D0, -7.308668742487D-05,  0.0000D+00,  331, 'R', & !  287
     &        -17.4D0,        26.0D0,        0.0D0,      0.0D0,     & !
     & 5.6426965028D0, -7.307526615491D-05, -7.4989D-23,  199, 'P', & !  288
     &         -6.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028966398D-05, -2.1637D-24,  330, 'P', & !  289
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028193787D-05, -1.0819D-24,  329, 'P', & !  290
     &          0.0D0,        -7.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 291, 300 ) &
     &             /                 &
     & 0.0451691770D0, -7.306988707883D-05,  2.1637D-24,  328, 'R', & !  291
     &        -22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7702630372D0, -7.306455017302D-05, -7.9126D-23,  171, 'P', & !  292
     &        -20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8710091444D0, -7.305385321096D-05, -8.6396D-23,  256, 'P', & !  293
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304570710936D-05, -1.0819D-24,  327, 'R', & !  294
     &         -2.4D0,         6.3D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304569938325D-05,  0.0000D+00,  326, 'R', & !  295
     &        147.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302111682864D-05,  1.0819D-24,  325, 'R', & !  296
     &          2.4D0,        20.8D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302110910253D-05,  2.1637D-24,  324, 'R', & !  297
     &       -105.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4302945900D0, -7.302030666323D-05, -2.1637D-24,  323, 'P', & !  298
     &          0.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 4.4500105990D0, -7.301439959242D-05,  0.0000D+00,  322, 'R', & !  299
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5371314966D0, -7.300178301151D-05,  0.0000D+00,  321, 'R', & !  300
     &         -7.7D0,         4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 301, 310 ) &
     &             /                 &
     & 3.6377405400D0, -7.299825773285D-05,  9.4188D-23,   89, 'P', & !  301
     &       -160.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299571638250D-05,  0.0000D+00,  320, 'P', & !  302
     &          0.0D0,        -8.7D0,        0.0D0,      0.0D0,     & !
     & 1.4553013400D0, -7.298756077079D-05,  8.6918D-23,   36, 'R', & !  303
     &      -1038.4D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.5560474472D0, -7.297686380872D-05,  7.9648D-23,   18, 'R', & !  304
     &      -1450.1D0,        -1.5D0,      759.6D0,      0.0D0,     & !
     & 4.4845458162D0, -7.297152868692D-05, -2.1637D-24,  319, 'R', & !  305
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297114155400D-05,  0.0000D+00,  318, 'R', & !  306
     &          0.0D0,        60.7D0,        0.0D0,      0.0D0,     & !
     & 3.3736082472D0, -7.296616684666D-05,  7.2378D-23,   52, 'R', & !  307
     &         17.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6836139815D0, -7.296614782684D-05,  7.5511D-23,  170, 'R', & !  308
     &        -21.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9833461468D0, -7.296544075474D-05,  5.1813D-24,  317, 'R', & !  309
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9435276618D0, -7.295644579562D-05,  5.1813D-24,  316, 'R', & !  310
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 311, 320 ) &
     &             /                 &
     & 5.0840923132D0, -7.295474379311D-05, -2.1637D-24,  315, 'R', & !  311
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295473606700D-05, -1.0819D-24,  313, 'R', & !  312
     &         -1.0D0,        -3.1D0,        0.0D0,      0.0D0,     & !
     & 1.9424996300D0, -7.295473606678D-05, -1.0443D-24,  314, 'R', & !  313
     &         -0.5D0,         5.9D0,        0.0D0,      0.0D0,     & !
     & 2.0726478028D0, -7.295436917193D-05,  4.1893D-23,  230, 'R', & !  314
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7276506700D0, -7.295435966202D-05,  4.3459D-23,  260, 'R', & !  315
     &          0.0D0,        31.8D0,        0.0D0,      0.0D0,     & !
     & 0.2641322928D0, -7.295324943944D-05,  2.1810D-23,  152, 'P', & !  316
     &         45.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2886217102D0, -7.294655899960D-05,  1.0443D-24,  312, 'P', & !  317
     &        -30.5D0,         5.3D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655127328D-05,  2.1637D-24,  311, 'R', & !  318
     &          0.0D0,       -56.6D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294640716730D-05, -2.1637D-24,  310, 'P', & !  319
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294639171508D-05,  0.0000D+00,  309, 'P', & !  320
     &          7.7D0,        13.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 321, 330 ) &
     &             /                 &
     & 0.7610885210D0, -7.294574883398D-05, -2.1637D-24,  308, 'P', & !  321
     &         29.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294574110787D-05, -1.0819D-24,  307, 'P', & !  322
     &         -1.5D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294573338176D-05,  0.0000D+00,  306, 'P', & !  323
     &         21.2D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 4.8283967772D0, -7.294366269996D-05,  3.6189D-23,  261, 'R', & !  324
     &          0.0D0,       114.5D0,        0.0D0,      0.0D0,     & !
     & 3.4833996444D0, -7.294365319004D-05,  3.7755D-23,   63, 'R', & !  325
     &        312.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4719551932D0, -7.294327856929D-05,  8.1737D-23,  305, 'P', & !  326
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7716873585D0, -7.294257149720D-05,  1.1407D-23,  200, 'P', & !  327
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3648784000D0, -7.294255247738D-05,  1.4540D-23,    4, 'P', & !  328
     &    -417560.6D0,      -138.8D0,    29686.1D0,      0.0D0,     & !
     & 2.6125197854D0, -7.294157656636D-05,  7.4467D-23,  304, 'R', & !  329
     &        -13.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293795117318D-05, -1.0819D-24,  302, 'R', & !  330
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 331, 340 ) &
     &             /                 &
     & 2.5420461270D0, -7.293795117297D-05, -1.0443D-24,  303, 'R', & !  331
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293794344707D-05,  0.0000D+00,  301, 'R', & !  332
     &         -7.7D0,        24.1D0,        0.0D0,      0.0D0,     & !
     & 2.5420461862D0, -7.293793572117D-05,  1.0443D-24,  299, 'P', & !  333
     &         12.1D0,        42.6D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293793572096D-05,  1.0819D-24,  300, 'R', & !  334
     &          1.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 3.2933767098D0, -7.293721735515D-05, -6.7197D-23,  298, 'P', & !  335
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2477751934D0, -7.293585431164D-05, -5.1813D-24,  297, 'P', & !  336
     &          1.9D0,       -98.2D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293469208641D-05, -2.1637D-24,  296, 'R', & !  337
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293468436029D-05, -1.0819D-24,  294, 'R', & !  338
     &         -2.5D0,        -4.9D0,        0.0D0,      0.0D0,     & !
     & 1.3935591100D0, -7.293468436008D-05, -1.0443D-24,  295, 'R', & !  339
     &          2.5D0,         3.9D0,        0.0D0,      0.0D0,     & !
     & 5.0544717264D0, -7.293378286006D-05, -1.0443D-24,  293, 'R', & !  340
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 341, 350 ) &
     &             /                 &
     & 1.9128791024D0, -7.293377513417D-05,  0.0000D+00,  292, 'P', & !  341
     &         44.4D0,        42.4D0,        0.0D0,      0.0D0,     & !
     & 5.0544717855D0, -7.293376740827D-05,  1.0443D-24,  291, 'P', & !  342
     &        -62.4D0,        17.4D0,        0.0D0,      0.0D0,     & !
     & 2.6459575772D0, -7.293296573789D-05,  2.8919D-23,  262, 'R', & !  343
     &          0.0D0,        -8.9D0,        0.0D0,      0.0D0,     & !
     & 1.3009604444D0, -7.293295622798D-05,  3.0486D-23,   72, 'R', & !  344
     &        -37.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8515650132D0, -7.293268885906D-05,  7.2699D-24,  290, 'P', & !  345
     &          3.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 0.5556208067D0, -7.293258472067D-05,  3.8800D-23,  289, 'P', & !  346
     &         -5.8D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 4.5727013004D0, -7.293258160723D-05,  7.4467D-23,  288, 'R', & !  347
     &        -42.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2946337162D0, -7.293208093001D-05,  7.2699D-24,  287, 'P', & !  348
     &          6.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 5.3494097933D0, -7.293196715752D-05,  7.2699D-24,  286, 'P', & !  349
     &         17.4D0,        66.7D0,        0.0D0,      0.0D0,     & !
     & 4.8724334656D0, -7.293187453514D-05,  4.1370D-24,   71, 'R', & !  350
     &         41.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 351, 360 ) &
     &             /                 &
     & 2.1824392000D0, -7.293185551532D-05,  7.2699D-24,    1, 'P', & !  351
     &   38905342.7D0,      7219.3D0,  6002929.4D0,      0.0D0,     & !
     & 5.2986539139D0, -7.293174387312D-05,  7.2699D-24,  285, 'P', & !  352
     &        -17.4D0,        67.7D0,        0.0D0,      0.0D0,     & !
     & 5.3534299910D0, -7.293163010062D-05,  7.2699D-24,  284, 'P', & !  353
     &         -7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 3.8092575933D0, -7.293112630996D-05, -2.4260D-23,  283, 'P', & !  354
     &          6.7D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 4.7964986940D0, -7.293102217158D-05,  7.2699D-24,  282, 'P', & !  355
     &         -4.8D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292792531983D-05, -1.0819D-24,  280, 'R', & !  356
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2675758670D0, -7.292792531962D-05, -1.0443D-24,  281, 'R', & !  357
     &         -6.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292791759372D-05,  0.0000D+00,  279, 'R', & !  358
     &          1.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 2.2675759262D0, -7.292790986782D-05,  1.0443D-24,  278, 'P', & !  359
     &        -38.2D0,        17.4D0,        0.0D0,      0.0D0,     & !
     & 3.5011996102D0, -7.292724648501D-05, -7.2699D-24,  277, 'R', & !  360
     &          1.9D0,        -6.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 361, 370 ) &
     &             /                 &
     & 0.3596069862D0, -7.292723875911D-05, -6.2256D-24,  276, 'R', & !  361
     &         -1.9D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 2.2863506502D0, -7.292687008024D-05,  3.7233D-23,  275, 'R', & !  362
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1109375098D0, -7.292652039309D-05, -7.4467D-23,  274, 'P', & !  363
     &         33.7D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 1.0715016902D0, -7.292649367548D-05,  8.1737D-23,  273, 'P', & !  364
     &        -20.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 3.6262274968D0, -7.292608352604D-05,  0.0000D+00,  272, 'R', & !  365
     &          4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 4.4317540428D0, -7.292531536865D-05, -7.4467D-23,  271, 'P', & !  366
     &         -7.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 0.0653359934D0, -7.292515734957D-05, -1.2451D-23,  270, 'R', & !  367
     &          0.0D0,        22.2D0,        0.0D0,      0.0D0,     & !
     & 5.3574696750D0, -7.292323696095D-05, -3.7233D-23,  269, 'P', & !  368
     &          0.0D0,        12.5D0,        0.0D0,      0.0D0,     & !
     & 6.0136252095D0, -7.292307817210D-05, -7.2699D-24,  268, 'R', & !  369
     &         16.2D0,        14.3D0,        0.0D0,      0.0D0,     & !
     & 2.8720325855D0, -7.292307044620D-05, -6.2256D-24,  267, 'R', & !  370
     &         26.0D0,        -7.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 371, 380 ) &
     &             /                 &
     & 0.4635183772D0, -7.292226877583D-05,  2.1649D-23,  263, 'R', & !  371
     &          0.0D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 5.4017065515D0, -7.292225926592D-05,  2.3216D-23,  108, 'R', & !  372
     &          5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5275331892D0, -7.292198417109D-05,  1.0443D-24,  266, 'P', & !  373
     &       -270.8D0,       135.4D0,        0.0D0,      0.0D0,     & !
     & 4.6563669139D0, -7.292188775860D-05,  3.1530D-23,  265, 'R', & !  374
     &         22.2D0,         9.6D0,        0.0D0,      0.0D0,     & !
     & 2.3902621004D0, -7.292188464517D-05,  6.7197D-23,  264, 'R', & !  375
     &         -9.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8929232068D0, -7.292043246134D-05, -6.7197D-23,  264, 'P', & !  376
     &        -63.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6268183933D0, -7.292042934790D-05, -3.1530D-23,  265, 'P', & !  377
     &        -22.2D0,         9.6D0,        0.0D0,      0.0D0,     & !
     & 5.7556521180D0, -7.292033293541D-05, -1.0443D-24,  266, 'R', & !  378
     &        -39.4D0,       -19.7D0,        0.0D0,      0.0D0,     & !
     & 0.8814787556D0, -7.292005784059D-05, -2.3216D-23,  108, 'P', & !  379
     &        105.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8196669300D0, -7.292004833068D-05, -2.1649D-23,  263, 'P', & !  380
     &          0.0D0,        -5.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 381, 390 ) &
     &             /                 &
     & 3.4111527216D0, -7.291924666030D-05,  6.2256D-24,  267, 'P', & !  381
     &        -26.0D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 0.2695600976D0, -7.291923893440D-05,  7.2699D-24,  268, 'P', & !  382
     &        105.0D0,       -97.2D0,        0.0D0,      0.0D0,     & !
     & 0.9257156322D0, -7.291908014555D-05,  3.7233D-23,  269, 'R', & !  383
     &          0.0D0,        12.5D0,        0.0D0,      0.0D0,     & !
     & 6.2178493138D0, -7.291715975693D-05,  1.2451D-23,  270, 'P', & !  384
     &          0.0D0,        22.2D0,        0.0D0,      0.0D0,     & !
     & 1.8514312644D0, -7.291700173786D-05,  7.4467D-23,  271, 'R', & !  385
     &          7.7D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291623358047D-05,  0.0000D+00,  272, 'P', & !  386
     &         -4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 5.2116836170D0, -7.291582343103D-05, -8.1737D-23,  273, 'R', & !  387
     &         -3.4D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 5.1722477974D0, -7.291579671341D-05,  7.4467D-23,  274, 'R', & !  388
     &        -33.7D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 3.9968346570D0, -7.291544702626D-05, -3.7233D-23,  275, 'P', & !  389
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9235783210D0, -7.291507834740D-05,  6.2256D-24,  276, 'P', & !  390
     &          1.9D0,        -7.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 391, 400 ) &
     &             /                 &
     & 2.7819856970D0, -7.291507062150D-05,  7.2699D-24,  277, 'P', & !  391
     &         -1.9D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 4.0156093810D0, -7.291440723869D-05, -1.0443D-24,  278, 'R', & !  392
     &         -5.4D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439951279D-05,  0.0000D+00,  279, 'P', & !  393
     &         -1.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 4.0156094402D0, -7.291439178689D-05,  1.0443D-24,  281, 'P', & !  394
     &          6.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439178668D-05,  1.0819D-24,  280, 'P', & !  395
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4866866132D0, -7.291129493493D-05, -7.2699D-24,  282, 'R', & !  396
     &          4.8D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 2.4739277139D0, -7.291119079654D-05,  2.4260D-23,  283, 'R', & !  397
     &         -6.7D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.9297553162D0, -7.291068700589D-05, -7.2699D-24,  284, 'R', & !  398
     &          7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 0.9845313933D0, -7.291057323339D-05, -7.2699D-24,  285, 'R', & !  399
     &         -2.0D0,        -9.9D0,        0.0D0,      0.0D0,     & !
     & 4.1007461072D0, -7.291046159119D-05, -7.2699D-24,    1, 'R', & !  400
     &    5723443.8D0,      -261.4D0, -4641783.6D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 401, 410 ) &
     &             /                 &
     & 1.4107518415D0, -7.291044257137D-05, -4.1370D-24,   71, 'P', & !  401
     &        292.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9337755139D0, -7.291034994899D-05, -7.2699D-24,  286, 'R', & !  402
     &          2.0D0,       -10.8D0,        0.0D0,      0.0D0,     & !
     & 0.9885515910D0, -7.291023617649D-05, -7.2699D-24,  287, 'R', & !  403
     &         -6.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 1.7104840068D0, -7.290973549928D-05, -7.4467D-23,  288, 'P', & !  404
     &         42.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7275645005D0, -7.290973238584D-05, -3.8800D-23,  289, 'R', & !  405
     &          5.8D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.4316202940D0, -7.290962824745D-05, -7.2699D-24,  290, 'R', & !  406
     &         -3.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 4.9822248628D0, -7.290936087852D-05, -3.0486D-23,   72, 'P', & !  407
     &       -292.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6372277300D0, -7.290935136861D-05, -2.8919D-23,  262, 'P', & !  408
     &          0.0D0,        78.3D0,        0.0D0,      0.0D0,     & !
     & 1.2287135216D0, -7.290854969824D-05, -1.0443D-24,  291, 'R', & !  409
     &        -10.3D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290854197234D-05,  0.0000D+00,  292, 'R', & !  410
     &        -44.4D0,        42.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 411, 420 ) &
     &             /                 &
     & 1.2287135808D0, -7.290853424644D-05,  1.0443D-24,  293, 'P', & !  411
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 4.8896261972D0, -7.290763274642D-05,  1.0443D-24,  295, 'P', & !  412
     &         12.1D0,       -25.2D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290763274621D-05,  1.0819D-24,  294, 'P', & !  413
     &        -12.1D0,        24.2D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290762502010D-05,  2.1637D-24,  296, 'P', & !  414
     &         23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0354101138D0, -7.290646279487D-05,  5.1813D-24,  297, 'R', & !  415
     &         -1.9D0,        13.3D0,        0.0D0,      0.0D0,     & !
     & 2.9898085974D0, -7.290509975135D-05,  6.7197D-23,  298, 'R', & !  416
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290438138555D-05, -1.0819D-24,  300, 'P', & !  417
     &         -1.9D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 3.7411391210D0, -7.290438138533D-05, -1.0443D-24,  299, 'R', & !  418
     &          2.5D0,        -5.9D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290437365944D-05,  0.0000D+00,  301, 'P', & !  419
     &          7.7D0,        24.1D0,        0.0D0,      0.0D0,     & !
     & 3.7411391802D0, -7.290436593354D-05,  1.0443D-24,  303, 'P', & !  420
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 421, 430 ) &
     &             /                 &
     & 0.5995464970D0, -7.290436593333D-05,  1.0819D-24,  302, 'P', & !  421
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 3.6706655218D0, -7.290074054015D-05, -7.4467D-23,  304, 'P', & !  422
     &         13.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9183069072D0, -7.289976462913D-05, -1.4540D-23,    4, 'R', & !  423
     &     -17540.3D0,         1.8D0,    42519.2D0,      0.0D0,     & !
     & 5.5114979487D0, -7.289974560930D-05, -1.1407D-23,  200, 'R', & !  424
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8112301140D0, -7.289903853721D-05, -8.1737D-23,  305, 'R', & !  425
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7997856628D0, -7.289866391646D-05, -3.7755D-23,   63, 'P', & !  426
     &       -317.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4547885300D0, -7.289865440655D-05, -3.6189D-23,  261, 'P', & !  427
     &          0.0D0,      -317.0D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289658372475D-05,  0.0000D+00,  306, 'R', & !  428
     &        -21.2D0,         6.7D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289657599864D-05,  1.0819D-24,  307, 'R', & !  429
     &         -3.4D0,       -14.0D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289656827253D-05,  2.1637D-24,  308, 'R', & !  430
     &        436.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 431, 440 ) &
     &             /                 &
     & 2.4574271025D0, -7.289592539143D-05,  0.0000D+00,  309, 'R', & !  431
     &         -7.7D0,        13.5D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289590993921D-05,  2.1637D-24,  310, 'R', & !  432
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289576583323D-05, -2.1637D-24,  311, 'P', & !  433
     &          0.0D0,         6.4D0,        0.0D0,      0.0D0,     & !
     & 4.9945635970D0, -7.289575810691D-05, -1.0443D-24,  312, 'R', & !  434
     &         -3.5D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 6.0190530144D0, -7.288906766706D-05, -2.1810D-23,  152, 'R', & !  435
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5555346372D0, -7.288795744449D-05, -4.3459D-23,  260, 'P', & !  436
     &          0.0D0,        31.8D0,        0.0D0,      0.0D0,     & !
     & 4.2105375044D0, -7.288794793457D-05, -4.1893D-23,  230, 'P', & !  437
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3406856772D0, -7.288758103972D-05,  1.0443D-24,  314, 'P', & !  438
     &          5.3D0,       -32.9D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288758103951D-05,  1.0819D-24,  313, 'P', & !  439
     &         -8.7D0,        55.1D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288757331340D-05,  2.1637D-24,  315, 'P', & !  440
     &        235.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 441, 450 ) &
     &             /                 &
     & 3.3396576454D0, -7.288587131089D-05, -5.1813D-24,  316, 'P', & !  441
     &        -26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2998391604D0, -7.287687635176D-05, -5.1813D-24,  317, 'P', & !  442
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5995713256D0, -7.287616927967D-05, -7.5511D-23,  170, 'P', & !  443
     &         21.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9095770600D0, -7.287615025985D-05, -7.2378D-23,   52, 'P', & !  444
     &        617.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287117555251D-05,  0.0000D+00,  318, 'P', & !  445
     &          0.0D0,        60.7D0,        0.0D0,      0.0D0,     & !
     & 1.7986394910D0, -7.287078841958D-05,  2.1637D-24,  319, 'P', & !  446
     &         23.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7271378600D0, -7.286545329778D-05, -7.9648D-23,   18, 'P', & !  447
     &     -10301.8D0,         3.4D0,    -2295.9D0,      0.0D0,     & !
     & 4.8278839672D0, -7.285475633572D-05, -8.6918D-23,   36, 'P', & !  448
     &       1086.8D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284660072400D-05,  0.0000D+00,  320, 'R', & !  449
     &          0.0D0,        -8.7D0,        0.0D0,      0.0D0,     & !
     & 2.6454447672D0, -7.284405937366D-05, -9.4188D-23,   89, 'R', & !  450
     &        -23.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 451, 460 ) &
     &             /                 &
     & 3.7460538105D0, -7.284053409500D-05,  0.0000D+00,  321, 'P', & !  451
     &          7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 1.8331747082D0, -7.282791751408D-05,  0.0000D+00,  322, 'P', & !  452
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8528907172D0, -7.282201044328D-05,  2.1637D-24,  323, 'R', & !  453
     &          0.0D0,         5.8D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120800398D-05, -2.1637D-24,  324, 'P', & !  454
     &         -5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120027787D-05, -1.0819D-24,  325, 'P', & !  455
     &          2.4D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279661772325D-05,  0.0000D+00,  326, 'P', & !  456
     &       -147.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279660999714D-05,  1.0819D-24,  327, 'P', & !  457
     &         -2.4D0,       -17.9D0,        0.0D0,      0.0D0,     & !
     & 1.4121761628D0, -7.278846389555D-05,  8.6396D-23,  256, 'R', & !  458
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5129222700D0, -7.277776693348D-05,  7.9126D-23,  171, 'R', & !  459
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277243002767D-05, -2.1637D-24,  328, 'P', & !  460
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 461, 470 ) &
     &             /                 &
     & 0.6615878620D0, -7.277203516864D-05,  1.0819D-24,  329, 'R', & !  461
     &          0.0D0,        -7.7D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277202744253D-05,  2.1637D-24,  330, 'R', & !  462
     &         93.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6404888044D0, -7.276705095160D-05,  7.4989D-23,  199, 'R', & !  463
     &         11.1D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.5543773200D0, -7.275562968163D-05,  0.0000D+00,  331, 'P', & !  464
     &         17.4D0,        26.0D0,        0.0D0,      0.0D0,     & !
     & 5.6227136672D0, -7.275525327687D-05,  4.4503D-23,  177, 'P', & !  465
     &        -28.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.5792285187D0, -7.274729305583D-05,  0.0000D+00,  332, 'P', & !  466
     &          7.7D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274663472251D-05,  0.0000D+00,  333, 'P', & !  467
     &          0.0D0,        28.0D0,        0.0D0,      0.0D0,     & !
     & 3.4402744672D0, -7.274455631481D-05,  3.7233D-23,   68, 'R', & !  468
     &        257.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.3217532228D0, -7.274345560214D-05,  1.4018D-23,   96, 'P', & !  469
     &       -146.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273884478782D-05,  0.0000D+00,  334, 'P', & !  470
     &        118.6D0,        -2.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 471, 480 ) &
     &             /                 &
     & 3.6663494164D0, -7.273467647491D-05,  0.0000D+00,  335, 'P', & !  471
     &         36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2578352672D0, -7.273385935274D-05,  2.9963D-23,   94, 'R', & !  472
     &        -21.4D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.1393140228D0, -7.273275864008D-05,  6.7478D-24,   27, 'P', & !  473
     &       3433.1D0,        -2.0D0,      916.6D0,      0.0D0,     & !
     & 0.8794535570D0, -7.272881893447D-05,  0.0000D+00,  336, 'P', & !  474
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2400601300D0, -7.272206167802D-05, -5.2215D-25,    5, 'P', & !  475
     &    -124354.8D0,       600.9D0,    96625.1D0,      0.0D0,     & !
     & 3.5500658644D0, -7.272204265819D-05,  2.6108D-24,   10, 'P', & !  476
     &     -44060.4D0,        34.9D0,    38016.1D0,      0.0D0,     & !
     & 4.0576209300D0, -7.271136471595D-05, -7.7921D-24,   32, 'R', & !  477
     &        332.6D0,         0.9D0,     1073.7D0,      0.0D0,     & !
     & 1.3676266644D0, -7.271134569613D-05, -4.6592D-24,   45, 'P', & !  478
     &       1116.9D0,         0.0D0,     -462.6D0,      0.0D0,     & !
     & 6.1237765188D0, -7.270942786087D-05,  2.1637D-24,  337, 'P', & !  479
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270525954796D-05,  2.1637D-24,  338, 'P', & !  480
     &         50.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 481, 490 ) &
     &             /                 &
     & 1.8751817300D0, -7.270066775389D-05, -1.5062D-23,  113, 'R', & !  481
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4683727715D0, -7.270064873407D-05, -1.1929D-23,  103, 'R', & !  482
     &        -79.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269746961328D-05,  2.1637D-24,  339, 'R', & !  483
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269666717398D-05, -2.1637D-24,  340, 'P', & !  484
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1674123272D0, -7.268885105934D-05, -4.2415D-23,  143, 'P', & !  485
     &         56.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9525633080D0, -7.268847465415D-05,  2.1637D-24,  341, 'P', & !  486
     &          2.9D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 1.9849731272D0, -7.267815409727D-05, -4.9685D-23,  242, 'R', & !  487
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267208461936D-05, -1.0819D-24,  342, 'P', & !  488
     &          0.0D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267207689325D-05,  0.0000D+00,  343, 'P', & !  489
     &         57.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6840126828D0, -7.266635642255D-05, -8.0170D-23,  234, 'P', & !  490
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 491, 500 ) &
     &             /                 &
     & 2.0842642450D0, -7.264749433864D-05,  1.0819D-24,  345, 'R', & !  491
     &          0.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264748661253D-05,  2.1637D-24,  344, 'R', & !  492
     &        -22.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9622420272D0, -7.258934800049D-05,  8.9007D-23,  204, 'P', & !  493
     &         10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7798028272D0, -7.257865103842D-05,  8.1737D-23,   48, 'P', & !  494
     &       -923.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.7083011370D0, -7.257331591620D-05,  0.0000D+00,  346, 'P', & !  495
     &         -7.7D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 2.4150581760D0, -7.257292878328D-05,  2.1637D-24,  347, 'R', & !  496
     &          0.0D0,       -27.1D0,        0.0D0,      0.0D0,     & !
     & 5.0291176700D0, -7.257212634398D-05, -2.1637D-24,  348, 'P', & !  497
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5973636272D0, -7.256795407636D-05,  7.4467D-23,   21, 'R', & !  498
     &      -4486.9D0,         5.3D0,        0.0D0,      0.0D0,     & !
     & 4.6981097344D0, -7.255725711430D-05,  6.7197D-23,   43, 'R', & !  499
     &        178.6D0,        -1.0D0,     -305.5D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255653102238D-05,  0.0000D+00,  349, 'P', & !  500
     &        -37.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 501, 510 ) &
     &             /                 &
     & 4.2680291490D0, -7.254753606325D-05,  0.0000D+00,  350, 'P', & !  501
     &         -9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254752061103D-05,  2.1637D-24,  351, 'P', & !  502
     &         -4.8D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 2.5156705344D0, -7.254656015223D-05,  5.9927D-23,  169, 'R', & !  503
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9073941310D0, -7.253973067635D-05,  2.1637D-24,  352, 'P', & !  504
     &         31.4D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 5.4198197304D0, -7.253556236344D-05,  2.1637D-24,  353, 'P', & !  505
     &         -7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 2.0961888456D0, -7.253366176484D-05,  6.2256D-24,  188, 'P', & !  506
     &         20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6893798872D0, -7.253364274502D-05,  9.3585D-24,   87, 'P', & !  507
     &       -167.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8928811340D0, -7.252377912627D-05,  2.1637D-24,  354, 'R', & !  508
     &        -13.1D0,       -19.3D0,        0.0D0,      0.0D0,     & !
     & 0.3907259141D0, -7.252305742473D-05,  2.1637D-24,  355, 'P', & !  509
     &        -23.7D0,       -84.1D0,        0.0D0,      0.0D0,     & !
     & 6.1969349528D0, -7.252296480278D-05, -1.0443D-24,   34, 'P', & !  510
     &      -1577.3D0,         1.5D0,     2444.4D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 511, 520 ) &
     &             /                 &
     & 3.5069406872D0, -7.252294578295D-05,  2.0886D-24,    2, 'P', & !  511
     &    2659051.5D0,     -2470.3D0,  -187385.5D0,      0.0D0,     & !
     & 3.5069406280D0, -7.252294578253D-05,  2.1637D-24,  356, 'P', & !  512
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3399700347D0, -7.252283414033D-05,  2.1637D-24,  357, 'R', & !  513
     &         23.7D0,       -84.1D0,        0.0D0,      0.0D0,     & !
     & 6.1210001220D0, -7.252211243879D-05,  2.1637D-24,  358, 'P', & !  514
     &         37.3D0,       -19.3D0,        0.0D0,      0.0D0,     & !
     & 4.0144957528D0, -7.251226784071D-05, -8.3142D-24,  239, 'R', & !  515
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3245014872D0, -7.251224882089D-05, -5.1813D-24,   11, 'P', & !  516
     &     -29080.3D0,        27.1D0,    -5045.8D0,      0.0D0,     & !
     & 1.5940615256D0, -7.251032920162D-05,  2.1637D-24,  359, 'P', & !  517
     &          7.7D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 4.1064871250D0, -7.250616088871D-05,  2.1637D-24,  360, 'P', & !  518
     &        -33.4D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.4252475944D0, -7.250155185883D-05, -1.2451D-23,   30, 'R', & !  519
     &       2063.8D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 2.7458521070D0, -7.249837095402D-05,  2.1637D-24,  361, 'R', & !  520
     &          6.7D0,        -1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 521, 530 ) &
     &             /                 &
     & 3.2428083944D0, -7.249085489676D-05, -1.9721D-23,   85, 'R', & !  521
     &        -22.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5988230800D0, -7.247296278178D-05,  2.1637D-24,  362, 'P', & !  522
     &          0.0D0,       -35.8D0,        0.0D0,      0.0D0,     & !
     & 0.1686087458D0, -7.244758551398D-05, -2.1637D-24,  363, 'P', & !  523
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242299523325D-05,  0.0000D+00,  364, 'P', & !  524
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239840495253D-05,  2.1637D-24,  365, 'P', & !  525
     &         60.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7366776500D0, -7.237955416319D-05,  8.1214D-23,  223, 'P', & !  526
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5542384500D0, -7.236885720112D-05,  7.3944D-23,   92, 'R', & !  527
     &       -108.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6549845572D0, -7.235816023906D-05,  6.6675D-23,  181, 'R', & !  528
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0613179480D0, -7.235741691091D-05,  2.1637D-24,  366, 'P', & !  529
     &        -14.0D0,       -18.4D0,        0.0D0,      0.0D0,     & !
     & 6.0214994630D0, -7.234842195178D-05,  2.1637D-24,  367, 'P', & !  530
     &          0.0D0,       -22.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 531, 540 ) &
     &             /                 &
     & 0.6640298472D0, -7.234634354451D-05,  3.9322D-23,  241, 'P', & !  531
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6608644450D0, -7.234063201709D-05,  2.1637D-24,  368, 'P', & !  532
     &       -103.5D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 0.8901047372D0, -7.233646370419D-05,  2.1637D-24,  369, 'P', & !  533
     &        -28.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4638155100D0, -7.232384890772D-05,  1.5665D-24,    6, 'P', & !  534
     &     104234.7D0,       -95.7D0,   -89816.1D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232304468398D-05, -2.1637D-24,  370, 'P', & !  535
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2813763100D0, -7.231315194565D-05, -5.7035D-24,   50, 'P', & !  536
     &       -818.4D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.3821224172D0, -7.230245498359D-05, -1.2973D-23,  120, 'R', & !  537
     &         63.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229845440325D-05,  0.0000D+00,  371, 'P', & !  538
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227386412253D-05,  2.1637D-24,  372, 'P', & !  539
     &        -78.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9218651144D0, -7.215904434400D-05,  6.9285D-23,  192, 'P', & !  540
     &        -21.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 541, 550 ) &
     &             /                 &
     & 5.8147882620D0, -7.215831825166D-05,  2.1637D-24,  373, 'P', & !  541
     &         36.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4206903328D0, -7.212475203248D-05,  1.0443D-24,   29, 'P', & !  542
     &       3182.1D0,        -4.4D0,    -5211.4D0,      0.0D0,     & !
     & 1.2382511328D0, -7.211405507042D-05, -6.2256D-24,  189, 'P', & !  543
     &        -19.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3775651556D0, -7.192565515724D-05,  5.2215D-25,  119, 'P', & !  544
     &         88.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6161299856D0, -7.105476667142D-05, -3.0486D-23,  227, 'P', & !  545
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4336907856D0, -7.104406970936D-05, -3.7755D-23,  110, 'R', & !  546
     &         12.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5344368928D0, -7.103337274730D-05, -4.5025D-23,  218, 'R', & !  547
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8444426272D0, -7.103335372747D-05, -4.1893D-23,  165, 'P', & !  548
     &        -26.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1608286456D0, -7.098836445389D-05, -1.1740D-22,  197, 'P', & !  549
     &        -15.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0741795900D0, -7.088996210771D-05,  3.7233D-23,  195, 'R', & !  550
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 551, 560 ) &
     &             /                 &
     & 1.6915260528D0, -7.085677050885D-05, -7.7921D-24,  160, 'R', & !  551
     &          0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9837566500D0, -7.084495381430D-05, -3.5145D-23,   91, 'P', & !  552
     &       -166.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8013174500D0, -7.083425685224D-05, -4.2415D-23,   47, 'P', & !  553
     &       -720.8D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.9020635572D0, -7.082355989017D-05, -4.9685D-23,   99, 'R', & !  554
     &         18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6011031128D0, -7.081176221545D-05, -8.0170D-23,  253, 'P', & !  555
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2134936128D0, -7.070156219453D-05,  4.3981D-23,  126, 'P', & !  556
     &         55.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0310544128D0, -7.069086523247D-05,  3.6711D-23,   66, 'R', & !  557
     &         67.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.1318005200D0, -7.068016827041D-05,  2.9441D-23,  132, 'R', & !  558
     &         -4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4418062544D0, -7.068014925058D-05,  3.2574D-23,  221, 'P', & !  559
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1230706728D0, -7.065655390112D-05, -2.8397D-23,  129, 'P', & !  560
     &         77.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 561, 570 ) &
     &             /                 &
     & 3.9406314728D0, -7.064585693906D-05, -3.5667D-23,   28, 'P', & !  561
     &      -3404.4D0,         1.0D0,     -305.5D0,      0.0D0,     & !
     & 1.7581922728D0, -7.063515997700D-05, -4.2937D-23,   13, 'P', & !  562
     &     -15446.4D0,         3.5D0,     -305.5D0,      0.0D0,     & !
     & 5.8589383800D0, -7.062446301494D-05, -5.0207D-23,   31, 'R', & !  563
     &        442.3D0,         1.0D0,     -305.5D0,      0.0D0,     & !
     & 3.6764991800D0, -7.061376605287D-05, -5.7477D-23,  137, 'R', & !  564
     &         -3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5811202772D0, -7.049174933741D-05,  3.9322D-23,  102, 'P', & !  565
     &       -114.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3986810772D0, -7.048105237534D-05,  3.2052D-23,   51, 'P', & !  566
     &       -463.9D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.2162418772D0, -7.047035541328D-05,  2.4782D-23,  133, 'R', & !  567
     &         11.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0977206328D0, -7.046925470062D-05,  1.5665D-24,  121, 'P', & !  568
     &         84.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1984667400D0, -7.045855773855D-05, -5.7035D-24,   57, 'P', & !  569
     &        414.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.0160275400D0, -7.044786077649D-05, -1.2973D-23,  130, 'R', & !  570
     &        -11.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 571, 580 ) &
     &             /                 &
     & 3.8975062956D0, -7.044676006382D-05, -3.6189D-23,  185, 'P', & !  571
     &         24.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7150670956D0, -7.043606310176D-05, -4.3459D-23,  100, 'P', & !  572
     &         90.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3082581372D0, -7.043604408194D-05, -4.0326D-23,  180, 'P', & !  573
     &         30.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8158132028D0, -7.042536613970D-05, -5.0729D-23,  244, 'R', & !  574
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1258189372D0, -7.042534711987D-05, -4.7596D-23,  251, 'P', & !  575
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6284180400D0, -7.033766075558D-05,  1.1118D-22,  235, 'R', & !  576
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4372489928D0, -7.030334942423D-05,  4.6070D-23,   67, 'P', & !  577
     &        396.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5379951000D0, -7.029265246217D-05,  3.8800D-23,   14, 'P', & !  578
     &     -14143.4D0,         0.5D0,    -1833.3D0,      0.0D0,     & !
     & 2.3555559000D0, -7.028195550011D-05,  3.1530D-23,    7, 'P', & !  579
     &     -70240.1D0,         0.0D0,    -2138.8D0,      0.0D0,     & !
     & 0.1731167000D0, -7.027125853804D-05,  2.4260D-23,   15, 'R', & !  580
     &       2024.3D0,         1.1D0,    -1833.3D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 581, 590 ) &
     &             /                 &
     & 1.0545954556D0, -7.027015782538D-05,  1.0443D-24,  236, 'P', & !  581
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2738628072D0, -7.026056157598D-05,  1.6990D-23,   75, 'R', & !  582
     &        -11.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1553415628D0, -7.025946086331D-05, -6.2256D-24,  125, 'P', & !  583
     &        -55.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8103444300D0, -7.025945135340D-05, -4.6592D-24,  259, 'P', & !  584
     &          0.0D0,       -49.4D0,        0.0D0,      0.0D0,     & !
     & 2.4653472972D0, -7.025944184349D-05, -3.0927D-24,  202, 'P', & !  585
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6279052300D0, -7.024875439134D-05, -1.1929D-23,  258, 'P', & !  586
     &          0.0D0,         7.7D0,        0.0D0,      0.0D0,     & !
     & 1.6719419185D0, -7.023696622652D-05, -4.3981D-23,  229, 'P', & !  587
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2651329600D0, -7.023694720670D-05, -4.0848D-23,   12, 'P', & !  588
     &     -24838.8D0,        -1.5D0,     1998.9D0,      0.0D0,     & !
     & 3.0826937600D0, -7.022625024464D-05, -4.8118D-23,   24, 'P', & !  589
     &      -4579.2D0,         1.0D0,     -611.1D0,      0.0D0,     & !
     & 0.9002545600D0, -7.021555328257D-05, -5.5388D-23,   58, 'P', & !  590
     &        399.2D0,         1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 591, 600 ) &
     &             /                 &
     & 5.0010006672D0, -7.020485632051D-05, -6.2658D-23,  142, 'R', & !  591
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4948699228D0, -7.009355558693D-05,  3.8278D-23,  127, 'P', & !  592
     &         78.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3124307228D0, -7.008285862487D-05,  3.1008D-23,   64, 'P', & !  593
     &        335.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9056217644D0, -7.008283960504D-05,  3.4141D-23,  220, 'P', & !  594
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1299915228D0, -7.007216166281D-05,  2.3738D-23,  150, 'R', & !  595
     &         -8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4222221200D0, -7.006034496825D-05, -3.6149D-24,   97, 'P', & !  596
     &        146.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2397829200D0, -7.004964800619D-05, -1.0885D-23,  187, 'P', & !  597
     &         21.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2220077828D0, -7.003785033146D-05, -4.1370D-23,  118, 'P', & !  598
     &        -93.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0395685828D0, -7.002715336940D-05, -4.8640D-23,  194, 'P', & !  599
     &        -20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8624965872D0, -6.988374272981D-05,  3.3618D-23,   23, 'P', & !  600
     &      -5751.9D0,         0.0D0,      768.1D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 601, 610 ) &
     &             /                 &
     & 3.6800573872D0, -6.987304576774D-05,  2.6349D-23,   41, 'P', & !  601
     &      -1303.4D0,         0.0D0,     -305.5D0,      0.0D0,     & !
     & 1.4976181872D0, -6.986234880568D-05,  1.9079D-23,  111, 'R', & !  602
     &         74.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4071952472D0, -6.981734051227D-05, -5.3299D-23,  209, 'P', & !  603
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8193714100D0, -6.968464585457D-05,  3.3096D-23,   76, 'P', & !  604
     &       -256.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6369322100D0, -6.967394889251D-05,  2.5826D-23,  144, 'P', & !  605
     &        -51.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5595097228D0, -6.854825827598D-05, -8.5351D-23,  211, 'P', & !  606
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7892466856D0, -6.840486665621D-05, -6.2256D-24,  163, 'R', & !  607
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1999985272D0, -6.839415067433D-05, -1.0363D-23,  176, 'P', & !  608
     &        -20.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6988237456D0, -6.835985836281D-05, -7.8604D-23,  186, 'P', & !  609
     &        -25.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5163845456D0, -6.834916140074D-05, -8.5874D-23,   90, 'P', & !  610
     &       -121.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 611, 620 ) &
     &             /                 &
     & 1.3339453456D0, -6.833846443868D-05, -9.3144D-23,  191, 'R', & !  611
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0561272428D0, -6.820575076115D-05, -3.6149D-24,  167, 'P', & !  612
     &         30.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1568733500D0, -6.819505379909D-05, -1.0885D-23,   54, 'P', & !  613
     &       -441.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.9744341500D0, -6.818435683703D-05, -1.8155D-23,  131, 'R', & !  614
     &         11.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6734737056D0, -6.817255916230D-05, -4.8640D-23,  208, 'P', & !  615
     &          9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7832651028D0, -6.815004550568D-05, -8.3263D-23,  257, 'P', & !  616
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3866103128D0, -6.805166217932D-05,  6.8241D-23,  231, 'R', & !  617
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1954412656D0, -6.801735084798D-05,  3.1329D-24,  116, 'P', & !  618
     &         92.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0130020656D0, -6.800665388591D-05, -4.1370D-24,   40, 'P', & !  619
     &       1401.1D0,         0.0D0,      305.5D0,      0.0D0,     & !
     & 4.1137481728D0, -6.799595692385D-05, -1.1407D-23,   19, 'P', & !  620
     &      -6412.4D0,        -8.2D0,     -305.5D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 621, 630 ) &
     &             /                 &
     & 1.4237539072D0, -6.799593790403D-05, -8.2741D-24,  215, 'P', & !  621
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9313089728D0, -6.798525996179D-05, -1.8677D-23,   46, 'R', & !  622
     &        184.0D0,         0.5D0,     -305.5D0,      0.0D0,     & !
     & 6.0320550800D0, -6.797456299973D-05, -2.5947D-23,  182, 'R', & !  623
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7401399256D0, -6.795094863045D-05, -8.3785D-23,   74, 'P', & !  624
     &       -279.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8408860328D0, -6.794025166838D-05, -9.1055D-23,  151, 'P', & !  625
     &        -47.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6584468328D0, -6.792955470632D-05, -9.8325D-23,  255, 'P', & !  626
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7542369772D0, -6.784184932220D-05,  6.3582D-23,  149, 'P', & !  627
     &        -36.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2708373328D0, -6.781935468541D-05,  2.5826D-23,  157, 'P', & !  628
     &         31.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2530621956D0, -6.780755701068D-05, -4.6592D-24,  156, 'P', & !  629
     &        -39.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0706229956D0, -6.779686004861D-05, -1.1929D-23,  117, 'P', & !  630
     &         64.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 631, 640 ) &
     &             /                 &
     & 1.3806287300D0, -6.779684102879D-05, -8.7962D-24,   39, 'P', & !  631
     &       1432.7D0,         1.0D0,      925.2D0,      0.0D0,     & !
     & 1.8881837956D0, -6.778616308655D-05, -1.9199D-23,  238, 'R', & !  632
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4813748372D0, -6.778614406673D-05, -1.6066D-23,   93, 'P', & !  633
     &        148.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1804143928D0, -6.777434639200D-05, -4.6552D-23,  225, 'P', & !  634
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7928048928D0, -6.766414637108D-05,  7.7600D-23,  222, 'P', & !  635
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6103656928D0, -6.765344940902D-05,  7.0330D-23,   62, 'P', & !  636
     &       -486.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7111118000D0, -6.764275244696D-05,  6.3060D-23,   25, 'P', & !  637
     &      -2968.8D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 2.5286726000D0, -6.763205548490D-05,  5.5790D-23,   60, 'R', & !  638
     &         85.6D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.3462334000D0, -6.762135852283D-05,  4.8520D-23,  252, 'R', & !  639
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2277121556D0, -6.762025781017D-05,  2.5304D-23,  243, 'P', & !  640
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 641, 650 ) &
     &             /                 &
     & 3.5199427528D0, -6.760844111562D-05, -2.0484D-24,  173, 'P', & !  641
     &        -19.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9938704667D0, -6.759847335890D-05,  2.2211D-23,  375, 'P', & !  642
     &        -24.7D0,       -13.1D0,        0.0D0,      0.0D0,     & !
     & 1.3375035528D0, -6.759774415355D-05, -9.3184D-24,    3, 'P', & !  643
     &     456803.6D0,       629.2D0,   -29843.1D0,      0.0D0,     & !
     & 2.9643219461D0, -6.759701494820D-05, -4.0848D-23,  374, 'P', & !  644
     &         24.7D0,       -13.1D0,        0.0D0,      0.0D0,     & !
     & 5.4382496600D0, -6.758704719149D-05, -1.6588D-23,    8, 'P', & !  645
     &      86031.8D0,       118.1D0,    12841.6D0,      0.0D0,     & !
     & 3.2558104600D0, -6.757635022943D-05, -2.3858D-23,   26, 'P', & !  646
     &      -2628.3D0,        -4.3D0,        0.0D0,      0.0D0,     & !
     & 1.0733712600D0, -6.756565326736D-05, -3.1128D-23,   95, 'R', & !  647
     &         21.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1653875200D0, -6.753134193602D-05, -9.6236D-23,  232, 'P', & !  648
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6679866228D0, -6.744365557172D-05,  6.2538D-23,  162, 'P', & !  649
     &         27.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9779923572D0, -6.744363655190D-05,  6.5670D-23,  248, 'P', & !  650
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 651, 660 ) &
     &             /                 &
     & 4.7777780200D0, -6.742114191511D-05,  2.7915D-23,  138, 'P', & !  651
     &         63.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2943783756D0, -6.739864727831D-05, -9.8405D-24,   37, 'P', & !  652
     &      -1520.2D0,        -3.4D0,     -925.2D0,      0.0D0,     & !
     & 5.3951244828D0, -6.738795031625D-05, -1.7110D-23,   86, 'P', & !  653
     &       -179.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9348671800D0, -6.724453967666D-05,  6.5148D-23,   42, 'P', & !  654
     &      -1291.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 6.0356132872D0, -6.723384271460D-05,  5.7878D-23,   79, 'P', & !  655
     &       -228.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8531740872D0, -6.722314575253D-05,  5.0608D-23,  233, 'R', & !  656
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2512531985D0, -6.719955040308D-05, -1.0363D-23,  214, 'P', & !  657
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4795658400D0, -6.717813745913D-05, -2.1770D-23,   84, 'P', & !  658
     &       -182.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5803119472D0, -6.716744049706D-05, -2.9040D-23,  175, 'P', & !  659
     &        -28.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8917420028D0, -6.704544280142D-05,  6.4626D-23,  148, 'P', & !  660
     &        -48.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 661, 670 ) &
     &             /                 &
     & 5.9150656228D0, -6.590905522284D-05, -5.3822D-23,  196, 'P', & !  661
     &        -14.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7711943385D0, -6.572065530966D-05, -4.7074D-23,  158, 'P', & !  662
     &         39.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8719404456D0, -6.570995834760D-05, -5.4344D-23,   88, 'P', & !  663
     &       -137.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1819461800D0, -6.570993932777D-05, -5.1211D-23,  210, 'P', & !  664
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6895012456D0, -6.569926138553D-05, -6.1614D-23,  184, 'R', & !  665
     &          3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2292439428D0, -6.555585074594D-05,  2.0645D-23,  139, 'P', & !  666
     &        -46.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1388210028D0, -6.551084245254D-05, -5.1733D-23,   56, 'P', & !  667
     &        567.7D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 0.9563818028D0, -6.550014549047D-05, -5.9003D-23,  112, 'P', & !  668
     &        102.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3685579656D0, -6.536745083277D-05,  2.7393D-23,   81, 'P', & !  669
     &        210.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1861187656D0, -6.535675387070D-05,  2.0123D-23,   49, 'P', & !  670
     &       -682.0D0,        -1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 671, 680 ) &
     &             /                 &
     & 4.2868648728D0, -6.534605690864D-05,  1.2853D-23,  107, 'R', & !  671
     &         17.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0956958256D0, -6.531174557730D-05, -5.2255D-23,   16, 'P', & !  672
     &      11942.8D0,        31.4D0,     -462.6D0,      0.0D0,     & !
     & 0.9132566256D0, -6.530104861523D-05, -5.9525D-23,   33, 'P', & !  673
     &       2250.8D0,         6.8D0,      305.5D0,      0.0D0,     & !
     & 5.0140027328D0, -6.529035165317D-05, -6.6795D-23,  122, 'P', & !  674
     &        -59.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1429935885D0, -6.515765699547D-05,  1.9601D-23,  203, 'P', & !  675
     &          9.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7361846300D0, -6.515763797564D-05,  2.2734D-23,   55, 'P', & !  676
     &        574.9D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.5537454300D0, -6.514694101358D-05,  1.5464D-23,  115, 'P', & !  677
     &         93.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2527849856D0, -6.513514333885D-05, -1.5022D-23,   69, 'P', & !  678
     &       -333.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3535310928D0, -6.512444637679D-05, -2.2292D-23,  136, 'P', & !  679
     &        -60.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0525706485D0, -6.511264870206D-05, -5.2777D-23,  105, 'P', & !  680
     &       -112.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 681, 690 ) &
     &             /                 &
     & 0.8701314485D0, -6.510195174000D-05, -6.0047D-23,  228, 'P', & !  681
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9659215928D0, -6.501424635587D-05,  1.0186D-22,  224, 'P', & !  682
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7834823928D0, -6.500354939381D-05,  9.4590D-23,   82, 'P', & !  683
     &       -163.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 4.8842285000D0, -6.499285243175D-05,  8.7320D-23,  172, 'R', & !  684
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6930594528D0, -6.495854110040D-05,  2.2211D-23,    9, 'P', & !  685
     &      60319.1D0,       167.8D0,    -3386.6D0,      0.0D0,     & !
     & 1.5106202528D0, -6.494784413834D-05,  1.4942D-23,   17, 'P', & !  686
     &      11365.8D0,        31.0D0,     1222.2D0,      0.0D0,     & !
     & 5.6113663600D0, -6.493714717628D-05,  7.6716D-24,   65, 'P', & !  687
     &       -348.7D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.2096598085D0, -6.493604646361D-05, -1.5544D-23,  146, 'P', & !  688
     &         47.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4289271600D0, -6.492645021422D-05,  4.0165D-25,  193, 'R', & !  689
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2377581128D0, -6.489213888287D-05, -6.4706D-23,   78, 'P', & !  690
     &       -229.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 691, 700 ) &
     &             /                 &
     & 0.0553189128D0, -6.488144192081D-05, -7.1976D-23,  159, 'P', & !  691
     &        -40.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8501486128D0, -6.478193886196D-05,  5.9445D-23,  245, 'P', & !  692
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6499342756D0, -6.475944422517D-05,  2.1689D-23,   61, 'P', & !  693
     &       -494.2D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 1.4674950756D0, -6.474874726310D-05,  1.4419D-23,  123, 'P', & !  694
     &        -78.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2904230800D0, -6.460533662351D-05,  9.6678D-23,   83, 'P', & !  695
     &       -187.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1079838800D0, -6.459463966145D-05,  8.9408D-23,  179, 'P', & !  696
     &        -28.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8351217400D0, -6.453893440598D-05,  9.7602D-24,  153, 'P', & !  697
     &        -44.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9874362156D0, -6.326985216969D-05, -2.2292D-23,  237, 'P', & !  698
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8970132756D0, -6.322484387628D-05, -9.4670D-23,  212, 'P', & !  699
     &         11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1267502385D0, -6.308145225651D-05, -1.5544D-23,  166, 'P', & !  700
     &         32.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 701, 710 ) &
     &             /                 &
     & 1.9443110385D0, -6.307075529445D-05, -2.2814D-23,  135, 'P', & !  701
     &        -43.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5375020800D0, -6.307073627463D-05, -1.9681D-23,  183, 'P', & !  702
     &         24.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8538880985D0, -6.302574700104D-05, -9.5192D-23,   77, 'P', & !  703
     &        242.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6714488985D0, -6.301505003898D-05, -1.0246D-22,  155, 'P', & !  704
     &         43.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4943769028D0, -6.287163939939D-05, -2.0203D-23,   59, 'P', & !  705
     &        530.9D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.3119377028D0, -6.286094243733D-05, -2.7473D-23,  109, 'P', & !  706
     &        100.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0109772585D0, -6.284914476260D-05, -5.7959D-23,  226, 'P', & !  707
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7241138656D0, -6.272824777962D-05,  5.8923D-23,  190, 'P', & !  708
     &         20.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5416746656D0, -6.271755081756D-05,  5.1653D-23,  128, 'P', & !  709
     &        -54.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3592354656D0, -6.270685385549D-05,  4.4383D-23,  254, 'R', & !  710
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 711, 720 ) &
     &             /                 &
     & 5.4512517256D0, -6.267254252415D-05, -2.0725D-23,   20, 'P', & !  711
     &       7698.9D0,        31.4D0,        0.0D0,      0.0D0,     & !
     & 3.2688125256D0, -6.266184556209D-05, -2.7995D-23,   38, 'P', & !  712
     &       1452.3D0,         4.4D0,     -462.6D0,      0.0D0,     & !
     & 1.0863733256D0, -6.265114860002D-05, -3.5265D-23,  141, 'P', & !  713
     &        -37.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0917405300D0, -6.251843492250D-05,  5.4263D-23,  114, 'P', & !  714
     &         97.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9093013300D0, -6.250773796043D-05,  4.6994D-23,  247, 'P', & !  715
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6083408856D0, -6.249594028570D-05,  1.6508D-23,  134, 'P', & !  716
     &        -65.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4259016856D0, -6.248524332364D-05,  9.2380D-24,  240, 'P', & !  717
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4081265485D0, -6.247344564891D-05, -2.1247D-23,  106, 'P', & !  718
     &       -105.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2256873485D0, -6.246274868685D-05, -2.8517D-23,  213, 'P', & !  719
     &         -6.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1390382928D0, -6.236434634066D-05,  1.2612D-22,  206, 'P', & !  720
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 721, 730 ) &
     &             /                 &
     & 6.0486153528D0, -6.231933804726D-05,  5.3741D-23,   22, 'P', & !  721
     &       6195.7D0,        27.1D0,     -768.1D0,      0.0D0,     & !
     & 3.8661761528D0, -6.230864108519D-05,  4.6471D-23,   44, 'P', & !  722
     &       1166.0D0,         4.4D0,        0.0D0,      0.0D0,     & !
     & 1.6837369528D0, -6.229794412313D-05,  3.9201D-23,  147, 'P', & !  723
     &        -32.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5933140128D0, -6.225293582973D-05, -3.3177D-23,  161, 'P', & !  724
     &        -37.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0054901756D0, -6.212024117202D-05,  5.3219D-23,  124, 'P', & !  725
     &        -79.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8230509756D0, -6.210954420996D-05,  4.5949D-23,  246, 'P', & !  726
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3627936728D0, -6.196613357036D-05,  1.2821D-22,  207, 'P', & !  727
     &        -11.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9693838685D0, -6.058564082313D-05, -6.3140D-23,  164, 'P', & !  728
     &         33.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2998669385D0, -6.043155224130D-05,  8.7159D-24,  216, 'P', & !  729
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9262586913D0, -6.038654394790D-05, -6.3662D-23,   70, 'P', & !  730
     &        305.6D0,         1.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 731, 740 ) &
     &             /                 &
     & 5.0270047985D0, -6.037584698583D-05, -7.0932D-23,  140, 'P', & !  731
     &         56.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5667474956D0, -6.023243634624D-05,  1.1327D-23,  101, 'P', & !  732
     &        117.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6674936028D0, -6.022173938418D-05,  4.0567D-24,  219, 'P', & !  733
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8972305656D0, -6.007834776441D-05,  8.3183D-23,  249, 'P', & !  734
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5236223185D0, -6.003333947100D-05,  1.0804D-23,   35, 'P', & !  735
     &       1528.4D0,         8.7D0,        0.0D0,      0.0D0,     & !
     & 5.6243684256D0, -6.002264250894D-05,  3.5346D-24,   73, 'P', & !  736
     &        288.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.4419292256D0, -6.001194554688D-05, -3.7354D-24,  217, 'P', & !  737
     &         -7.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1641111228D0, -5.987923186935D-05,  8.5793D-23,  250, 'P', & !  738
     &          4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4804971413D0, -5.983424259577D-05,  1.0282D-23,  178, 'P', & !  739
     &        -29.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1209859456D0, -5.968013499411D-05,  8.5271D-23,   53, 'P', & !  740
     &        579.2D0,         4.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),        &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                           &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                           &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT), &
     &             I_NUT= 741, 750 ) &
     &             /                 &
     & 6.2217320528D0, -5.966943803205D-05,  7.8001D-23,  104, 'P', & !  741
     &        108.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3249397685D0, -5.794643776999D-05, -3.1610D-23,  201, 'P', & !  742
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2818145913D0, -5.774734089475D-05, -3.2132D-23,   98, 'P', & !  743
     &        136.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0993753913D0, -5.773664393269D-05, -3.9402D-23,  174, 'P', & !  744
     &         26.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9223033956D0, -5.759323329309D-05,  4.2856D-23,  205, 'P', & !  745
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8791782185D0, -5.739413641786D-05,  4.2334D-23,   80, 'P', & !  746
     &        218.1D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 1.6967390185D0, -5.738343945579D-05,  3.5064D-23,  154, 'P', & !  747
     &         42.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4765418456D0, -5.704093194096D-05,  1.1680D-22,  145, 'P', & !  748
     &         51.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6373704913D0, -5.510813784160D-05, -6.0248D-25,  168, 'P', & !  749
     &         32.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2347341185D0, -5.475493336471D-05,  7.3864D-23,  198, 'P', & !  750
     &         13.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
! --- Contribution to E3 due to a secular part of the nutation-nutation
! --- cross terms
!
      REAL*8      CROSS_NUT_RATE_E3
      DATA        CROSS_NUT_RATE_E3 / -5.9230183722D-18 / ! rad/s  or -3.85542430 mas/Jul_cent
