      SUBROUTINE READ_SPD_CLI_DAT ( SPD_CLI_DAT, M_DEL, SPD_2P, N_DEL, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine  READ_SPD_CLI_DAT  reads the input file with with          *
! *   data for the SPD_CLIENT example.                                   *
! *                                                                      *
! * ### 28-APR-2015  READ_SPD_CLI_DAT v1.0 (c) L. Petrov 28-APR-2015 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'spd.i'
      INCLUDE   'spd_local.i'
      INTEGER*4  M_DEL, N_DEL, IUER
      TYPE     ( SPD_2P__TYPE  ) :: SPD_2P(M_DEL)
      CHARACTER  SPD_CLI_DAT*(*)
      INTEGER*4  MBUF
      PARAMETER  ( MBUF = 1024 )
      CHARACTER  BUF(MBUF)*256
      INTEGER*4  NBUF, J1, IER
!
      CALL ERR_PASS ( IUER, IER )
      CALL RD_TEXT ( SPD_CLI_DAT, MBUF, BUF, NBUF, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 5611, IUER, 'READ_SPD_CLI_DAT', 'Error in '// &
     &         'reading input file with example '//SPD_CLI_DAT )
           RETURN 
      END IF
!
      N_DEL = 0
      DO 410 J1=1,NBUF
         IF ( BUF(J1)(1:1) == '#' ) GOTO 410
!
         N_DEL = N_DEL + 1
         READ ( UNIT=BUF(J1)(11:15),   FMT='(I5)'    ) SPD_2P(N_DEL)%MJD
         READ ( UNIT=BUF(J1)(17:23),   FMT='(F7.1)'  ) SPD_2P(N_DEL)%TAI
         READ ( UNIT=BUF(J1)(26:38),   FMT='(F13.4)' ) SPD_2P(N_DEL)%COO_EMI(1)
         READ ( UNIT=BUF(J1)(40:52),   FMT='(F13.4)' ) SPD_2P(N_DEL)%COO_EMI(2)
         READ ( UNIT=BUF(J1)(54:66),   FMT='(F13.4)' ) SPD_2P(N_DEL)%COO_EMI(3)
         READ ( UNIT=BUF(J1)(69:81),   FMT='(F13.4)' ) SPD_2P(N_DEL)%COO_REC(1)
         READ ( UNIT=BUF(J1)(83:95),   FMT='(F13.4)' ) SPD_2P(N_DEL)%COO_REC(2)
         READ ( UNIT=BUF(J1)(97:109),  FMT='(F13.4)' ) SPD_2P(N_DEL)%COO_REC(3)
         READ ( UNIT=BUF(J1)(112:117), FMT='(F6.4)'  ) SPD_2P(N_DEL)%DEL(1)
         READ ( UNIT=BUF(J1)(120:125), FMT='(F6.4)'  ) SPD_2P(N_DEL)%DEL(2)
         READ ( UNIT=BUF(J1)(128:138), FMT='(F11.4)' ) SPD_2P(N_DEL)%DEL_RDER(1)
         READ ( UNIT=BUF(J1)(140:150), FMT='(F11.4)' ) SPD_2P(N_DEL)%DEL_RDER(2)
         READ ( UNIT=BUF(J1)(152:162), FMT='(F11.4)' ) SPD_2P(N_DEL)%DEL_EDER(1)
         READ ( UNIT=BUF(J1)(164:174), FMT='(F11.4)' ) SPD_2P(N_DEL)%DEL_EDER(2)
 410  CONTINUE 
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE READ_SPD_CLI_DAT  !#!  
