!
!  >>>> Include block sur_sked.i
!  >>>> 2005.10.10   L. Petrov  2025.03.21_11:46:42
!
        CHARACTER    SUR__LABEL*30, A2S__LABEL*40, SUR__CNT_FORMAT*48, SUR__AST_FORMAT*58, &
     &               SUR__AST_FMT_101*58, SUR__AST_FMT_100*58, SUR__SLEW_FMT*36, SUR__STP_FMT*43, &
     &               FRQ_SEQ__LABEL*32, SUR__SAT__LABEL*58
        PARAMETER  ( SUR__LABEL = 'Sur_sked  Version of  20250418' )
        PARAMETER  ( A2S__LABEL = 'Ast_to_snap  Version  1.7  of 2021.10.15' )
        PARAMETER  ( SUR__CNT_FORMAT  = '# sur_sked  control file.  Version of 2024.05.29' )
        PARAMETER  ( SUR__AST_FORMAT  = '# VLBI schedule in ast format version  1.2   of 2018.01.20' )
        PARAMETER  ( SUR__SLEW_FMT    = '# Station slew format of  2018.02.02' )
        PARAMETER  ( SUR__STP_FMT     = '# VLBI station parameters Format 2022.04.03' )
        PARAMETER  ( SUR__AST_FMT_101 = '# VLBI schedule in ast format version  1.1   of 2018.01.18' )
        PARAMETER  ( SUR__AST_FMT_100 = '# VLBI schedule in ast format version  1.0   of 2017.12.30' )
        PARAMETER  ( FRQ_SEQ__LABEL   = '# FRQ_SEQ  1.4   Format version 2023.06.03' )
        PARAMETER  ( SUR__SAT__LABEL  = '# GNSS satellite name table.  Format Version of 2025.01.23' )
!
	INTEGER*4    SUR__M_STA, SUR__M_SOU, SUR__M_SCN, SUR__M_EPC, &
     &               SUR__M_VIS, SUR__M_SPL, SUR__M_DEG, SUR__M_HOR, &
     &               SUR__M_HDS, SUR__M_GAP, SUR__M_SAT
	PARAMETER  ( SUR__M_STA =    256 )
	PARAMETER  ( SUR__M_SOU = 512*1024 )
	PARAMETER  ( SUR__M_SCN = 4096 )
	PARAMETER  ( SUR__M_EPC = 4096 )
	PARAMETER  ( SUR__M_VIS =   16 ) ! Number of source rises
	PARAMETER  ( SUR__M_SPL =   32 ) ! Number of spline knots
	PARAMETER  ( SUR__M_DEG =    3 ) ! Spline degree
	PARAMETER  ( SUR__M_HOR =  360 ) ! Maximum number of elements of the horizont mask
        PARAMETER  ( SUR__M_HDS =    4 ) ! Maximum number of hardware setups
        PARAMETER  ( SUR__M_GAP =    8 ) ! Maximum number of gaps in the schedule 
        PARAMETER  ( SUR__M_SAT =  256 ) ! Maximum number of satellites
!
        INTEGER*4    SUR__TYP_TAG, SUR__TYP_SEC, SUR__TYP_CAL, SUR__TYP_POC, &
      &              SUR__TYP_PLA, SUR__TYP_PAI
	INTEGER*4  SUR__NTYP
	PARAMETER  ( SUR__NTYP = 5 )
	CHARACTER    SUR__TYP_STR(6)*3
	PARAMETER  ( SUR__TYP_TAG = 1 )
	PARAMETER  ( SUR__TYP_SEC = 2 )
	PARAMETER  ( SUR__TYP_CAL = 3 )
	PARAMETER  ( SUR__TYP_POC = 4 )
	PARAMETER  ( SUR__TYP_PLA = 5 )
	PARAMETER  ( SUR__TYP_PAI = 6 )
	DATA         SUR__TYP_STR  / 'TAG', 'SEC', 'CAL', 'POC', 'PLA', 'PAI' /
!
	INTEGER*4  SUR__RIS, SUR__SET
	PARAMETER  ( SUR__RIS = 1 )
	PARAMETER  ( SUR__SET = 2 )
!
	INTEGER*4    SUR__FIRST, SUR__SHORT, SUR__LONG, SUR__TAPE, SUR__LAST, &
       &             SUR__POIN,  SUR__FLUX
	PARAMETER  ( SUR__FIRST = 21 )
	PARAMETER  ( SUR__SHORT = 22 )
	PARAMETER  ( SUR__LONG  = 23 )
	PARAMETER  ( SUR__TAPE  = 24 )
	PARAMETER  ( SUR__LAST  = 25 )
	PARAMETER  ( SUR__POIN  = 26 )
	PARAMETER  ( SUR__FLUX  = 27 )
!
	INTEGER*4    M__SUR_PAR, M__SUR_STP, M__SUR_SLE, M__SUR_LS
	PARAMETER  ( M__SUR_PAR = 66 )
	PARAMETER  ( M__SUR_STP = 24 )
	PARAMETER  ( M__SUR_SLE = 16 )
	PARAMETER  ( M__SUR_LS  = 64 )
	REAL*8     SUR__INTV_CHECK, SUR__DIST_LIM
	PARAMETER  ( SUR__INTV_CHECK = 300.0D0 )
	PARAMETER  ( SUR__DIST_LIM   = 30.0D0*ARCSEC__TO__RAD )
	REAL*8       SUR__SLEW_EXTRA_TIM,   SUR__TAPE_LEN, &
     &               SUR__TAPE_MOTION, SUR__AV_SLEW, SUR__AV_TROPO_SLEW, &
     &               SUR__FIRST_EXTRA_TIM
	PARAMETER  ( SUR__SLEW_EXTRA_TIM   =  4.0D0  )
	PARAMETER  ( SUR__TAPE_MOTION      = 10.0D0 )
	PARAMETER  ( SUR__TAPE_LEN         = 80.0D0*60.0D0 - 2.0D0*SUR__TAPE_MOTION )
        PARAMETER  ( SUR__AV_SLEW          = 20.0D0 )
        PARAMETER  ( SUR__AV_TROPO_SLEW    = 40.0D0 )
	PARAMETER  ( SUR__FIRST_EXTRA_TIM  = 30.0D0  )
	INTEGER*4    SUR__TROPO_RANGE_MAX
	PARAMETER  ( SUR__TROPO_RANGE_MAX  = 21 ) 
!
	TYPE     SUR_STA__TYPE
	    CHARACTER  NAME*8
	    CHARACTER  SHORT_NAME*2
	    CHARACTER  LAST_UPDATE*10  
	    LOGICAL*1  TAGALONE
            LOGICAL*1  STICKY
            LOGICAL*1  REF
            LOGICAL*1  SATELLITE
	    REAL*8     SLEW_RATE_EL
	    REAL*8     SLEW_RATE_AZ
	    REAL*8     SLEW_ACCL_EL
	    REAL*8     SLEW_ACCL_AZ
	    REAL*8     TIME_SETTLE_EL
	    REAL*8     TIME_SETTLE_AZ
	    REAL*8     EL_MIN
	    REAL*8     EL_MAX
	    REAL*8     AZ_ACC_MIN
	    REAL*8     AZ_ACC_MAX
	    REAL*8     AZ_RANGE(4)
	    REAL*8     STOW_AZIM
	    REAL*8     STOW_ELEV
!
	    REAL*8     COO_TRS(3)
	    REAL*8     REN_TO_TRS(3,3)
	    REAL*8     UEN_TO_TRS(3,3)
	    REAL*8     LAT_GCN
            REAL*8     LAT_GDT
	    REAL*8     LONG
	    REAL*8     HEI_ELL
	    REAL*8     RAD
	    REAL*8     GAC_ELL
!
	    REAL*8     EL_CUR
	    REAL*8     AZ_CUR
	    REAL*8     AZ_ACC_CUR
	    REAL*8     AZ_ACC_PREV
	    REAL*8     SETMODE
	    REAL*8     PREOB
	    REAL*8     POSTOB
!
            REAL*8     ALP_CUR
	    REAL*8     DEL_CUR
	    REAL*8     HA_CUR
	    REAL*8     HA_ACC_CUR
	    REAL*8     HA_ACC_PREV
            INTEGER*4  N_HM
            REAL*8     AZ_HM(SUR__M_HOR)
            REAL*8     EL_HM(SUR__M_HOR)
            REAL*8     REC_RATE
            REAL*8     CLOCK_OFFSET
!
            CHARACTER  CLOCK_DATE_BEG*20
            CHARACTER  CLOCK_DATE_END*20
            CHARACTER  HDS_NAME*16
	    CHARACTER  MOUNT_TYPE*8 
            CHARACTER  TLE_FILE*128
            CHARACTER  RECORDER*16
            CHARACTER  BACKEND*16
!
! --------- Block for a case when a stations is on th orbit
!
            INTEGER*4  N_EPC
            REAL*8     TIM_EPC(SUR__M_EPC)
            REAL*8     STA_POS(SUR__M_EPC,3)
            REAL*8     STA_SPL(SUR__M_EPC,3)
        END TYPE SUR_STA__TYPE
!
	TYPE     SUR_SOU__TYPE
	    CHARACTER  ALPHA_STR*15
	    CHARACTER  DELTA_STR*15
	    CHARACTER  J2000_NAME*10
	    CHARACTER  B1950_NAME*8
	    REAL*8     ALPHA
	    REAL*8     DELTA
 	    REAL*8     S_VEC(3)
	    REAL*8     FLUX
	    REAL*8     DUR
	    REAL*8     PRI
	    INTEGER*4  MJD_UP_CULM
	    INTEGER*4  NOBS
            INTEGER*4  NSCA_MIN
            INTEGER*4  NSCA_MAX
	    REAL*8     TAI_UP_CULM
	    REAL*8     EL_MIN
            REAL*8     GAP_MIN
            REAL*8     GAP_NOR
	    INTEGER*4  MIN_STA
	    INTEGER*4  FL_END
 	    LOGICAL*4  FL_USE
            INTEGER*4  MJD_EPOCH
            REAL*8     TAI_EPOCH
            REAL*8     RANGE
            REAL*8     DST
            INTEGER*4  IND_SAT
        END TYPE SUR_SOU__TYPE
!
	TYPE     SUR__TYPE
	   CHARACTER  DE_FILE*128
	   CHARACTER  DATE_START_UTC*21
	   CHARACTER  DATE_STOP_UTC*21
	   CHARACTER  DATE_GAP_UTC(2,SUR__M_GAP)*21
!
	   CHARACTER  ALGORITHM*16
!
	   CHARACTER  EXP_CODE*32
	   CHARACTER  EXP_DESCR*80
           CHARACTER  SCHEDULE_REVISION*16
	   CHARACTER  PI_NAME*32
	   CHARACTER  SCHEDULER_NAME*32
	   CHARACTER  SCHEDULER_EMAIL*64
	   CHARACTER  SCHEDULER_PHONE*64
	   CHARACTER  OBSERVER_PHONE*64
           REAL*8     CORR_SPECTRAL_RESOLUTION
           REAL*8     CORR_TIME_RESOLUTION
!
           CHARACTER  STATION_SLEW_DIR*128
	   CHARACTER  HEADER_VEX_TEMPLATE_FILE*128
	   CHARACTER  HEADER_KEY_TEMPLATE_FILE*128
	   CHARACTER  HARDWARE_SETUP_NAME*16
           INTEGER*4  L_HDS
	   CHARACTER  HARDWARE_SETUP_NAMS(SUR__M_HDS)*16
	   CHARACTER  OBSERVING_MODE_NAME*256
	   CHARACTER  OBSERVING_MODE_DESCR*2048
           CHARACTER  TLE_FILE*128
	   INTEGER*4  REF_STA
!
	   INTEGER*4  MJD_START
	   REAL*8     TAI_START
	   INTEGER*4  MJD_UTC_START
	   REAL*8     UTC_START
	   INTEGER*4  N_GAP
	   INTEGER*4  MJD_GAP(2,SUR__M_GAP)
	   REAL*8     TAI_GAP(2,SUR__M_GAP)
!
	   REAL*8     UTC_M_TAI
	   REAL*8     SUN_DIST_MIN
!
	   INTEGER*4  MJD_STOP
	   REAL*8     TAI_STOP
	   INTEGER*4  MJD_UTC_STOP
	   REAL*8     UTC_STOP
	   REAL*8     AZIM_180_MARGIN
!
	   REAL*8     PRESES_INTERVAL
	   REAL*8     POSTSES_INTERVAL
	   REAL*8     PREOBS_SHORT
	   REAL*8     PREOBS_LONG
	   REAL*8     EL_CHANGE_TSYS
	   REAL*8     TAPE_LENGTH
	   REAL*8     TAPE_CHANGE_TIME
	   REAL*8     START_ROUNDING
	   INTEGER*4  SKIP_PREOBS_LONG
!
     	   REAL*8     RECORDING_PAUSE
	   REAL*8     RECORDING_RATE
!
	   REAL*8     AVR_SLEW_TIME
	   REAL*8     AVR_SLEW_TROPO_TIME
           REAL*8     TROPO_BURST_INTERVAL
           INTEGER*4  TROPO_RANGE
	   INTEGER*4  TROPO_MIN_STA
	   INTEGER*4  SCAN_PER_SOURCE_MIN
	   INTEGER*4  SCAN_PER_SOURCE_MAX
	   INTEGER*4  SCAN_PER_SOURCE_NORM
           REAL*8     SCAN_GAP_SOURCE_NORM
           REAL*8     SCAN_GAP_SOURCE_MIN
	   INTEGER*4  NOBS_MIN
	   INTEGER*4  NOBS_MAX
	   INTEGER*4  KEY_TYP
           CHARACTER  POCAL_STYLE*16
!
	   INTEGER*4  L_STA
	   INTEGER*4  L_CAL
	   INTEGER*4  L_SOU
	   INTEGER*4  L_SO2
	   INTEGER*4  L_SOP
	   INTEGER*4  L_PLA
	   INTEGER*4  L_PAI
	   TYPE     ( SUR_STA__TYPE ) :: STA(SUR__M_STA)
	   TYPE     ( SUR_SOU__TYPE ) :: CAL(SUR__M_SOU)
	   TYPE     ( SUR_SOU__TYPE ) :: SOU(SUR__M_SOU)
	   TYPE     ( SUR_SOU__TYPE ) :: SO2(SUR__M_SOU)
	   TYPE     ( SUR_SOU__TYPE ) :: SOP(SUR__M_SOU)
	   TYPE     ( SUR_SOU__TYPE ) :: PLA(SUR__M_SOU)
	   TYPE     ( SUR_SOU__TYPE ) :: PAI(SUR__M_SOU)
!
	   INTEGER*4  L_SCN
	   INTEGER*4  L_OBS_TAG
	   INTEGER*4  L_OBS_SEC
	   INTEGER*4  L_OBS_CAL
	   INTEGER*4  L_OBS_POC
	   INTEGER*4  L_OBS_PLA
	   INTEGER*4  SRC_TYP(SUR__M_SOU)
	   INTEGER*4  IND_SRC(SUR__M_SOU)
	   INTEGER*4  NOBS_SRC(SUR__M_SOU)
	   INTEGER*4  NOBS_SO2(SUR__M_SOU)
	   INTEGER*4  NOBS_SRC_ORIG(SUR__M_SOU)
	   INTEGER*4  NOBS_SO2_ORIG(SUR__M_SOU)
	   REAL*8     GAPS_SRC(SUR__M_SOU)
	   INTEGER*4  IND_SCN_SRC(SUR__M_SCN,SUR__M_SOU)
	   INTEGER*4  IND_SCN_SO2(SUR__M_SCN,SUR__M_SOU)
	   INTEGER*4  MJD_OBS_BEG(SUR__M_SOU)
	   INTEGER*4  MJD_OBS_END(SUR__M_SOU)
	   REAL*8     TAI_OBS_BEG(SUR__M_SOU)
	   REAL*8     TAI_OBS_END(SUR__M_SOU)
	   INTEGER*4  IND_PAI(SUR__M_SOU)
!
           INTEGER*4  SCA_PREV(SUR__M_STA,SUR__M_SCN)
	   REAL*8     EL_OBS(SUR__M_STA,SUR__M_SCN)
	   REAL*8     AZ_OBS(SUR__M_STA,SUR__M_SCN)
	   REAL*8     HA_OBS(SUR__M_STA,SUR__M_SCN)
	   REAL*8     AZ_ACC_OBS(SUR__M_STA,SUR__M_SCN)
	   REAL*8     HA_ACC_OBS(SUR__M_STA,SUR__M_SCN)
	   REAL*8     SLEW_DUR(SUR__M_STA,SUR__M_SCN)
	   REAL*8     SLEW_SCA(SUR__M_SCN)
!
	   INTEGER*4  L_TAP
	   INTEGER*4  IND_TAP(SUR__M_SOU)
	   INTEGER*4  MJD_TAPE_START_CUR
	   INTEGER*4  SCAN_TYPE(SUR__M_SCN)
	   INTEGER*4  SOU_POCAL(SUR__M_SCN)
	   INTEGER*4  LAST_POCAL_SCAN
	   INTEGER*4  MJD_POCAL(SUR__M_SCN)
	   REAL*8     TAI_POCAL(SUR__M_SCN)
!
	   INTEGER*4  MJD_TROPO_CUR
	   REAL*8     TAI_TAPE_START_CUR
	   REAL*8     TAI_TROPO_CUR
!
	   INTEGER*4  N_VIS(SUR__M_SOU,SUR__NTYP)
	   INTEGER*4  MJD_VIS(SUR__M_VIS,2,SUR__M_SOU,SUR__NTYP)
	   REAL*8     TAI_VIS(SUR__M_VIS,2,SUR__M_SOU,SUR__NTYP)
	   REAL*8     ELEV_MAX(SUR__M_SOU,SUR__NTYP)
!
	   INTEGER*4  STATUS_SPL(SUR__NTYP)
	   REAL*8     TIM_SPL(SUR__M_SPL)
	   REAL*8,    POINTER :: VAL_SOU(:,:,:,:)
	   REAL*8,    POINTER :: VAL_SO2(:,:,:,:)
	   REAL*8,    POINTER :: VAL_CAL(:,:,:,:)
           REAL*8,    POINTER :: VAL_SOP(:,:,:,:)
           REAL*8,    POINTER :: VAL_PLA(:,:,:,:)
	   REAL*8,    POINTER :: SPL_SOU(:,:,:,:)
	   REAL*8,    POINTER :: SPL_SO2(:,:,:,:)
	   REAL*8,    POINTER :: SPL_CAL(:,:,:,:)
           REAL*8,    POINTER :: SPL_SOP(:,:,:,:)
           REAL*8,    POINTER :: SPL_PLA(:,:,:,:)
!
	   INTEGER*4  MJD_CALIB_START_CUR
	   REAL*8     TAI_CALIB_START_CUR
!
	   INTEGER*4  MJD_CUR
	   REAL*8     TAI_CUR
	   REAL*8     SCAN_LEN
	   REAL*8     TROPO_SCAN_LEN
	   REAL*8     CALIB_LEN
!
	   CHARACTER  OUT_PLAN*128
	   CHARACTER  OUT_VEX*128
	   CHARACTER  OUT_STAT*128
	   CHARACTER  OUT_KEY*128
	   CHARACTER  OUT_AST*128
	   CHARACTER  OUT_SOU_LIST*128
           CHARACTER  CDATE_START*20
           CHARACTER  CDATE_STOP*20
!
	   INTEGER*1  OBS_STA(SUR__M_STA,SUR__M_SCN)
!
	   INTEGER*4  L_SCN_SO1
	   INTEGER*4  L_SCN_SO2
	   INTEGER*4  L_SCN_CAL
	   INTEGER*4  L_SCN_POC
	   INTEGER*4  L_SCN_PLA
!
           INTEGER*4  L_SAT
           CHARACTER  C_SAT_ABBR(SUR__M_SAT)*3
           CHARACTER  C_SAT_NAME(SUR__M_SAT)*20
           CHARACTER  C_SAT_NORAD(SUR__M_SAT)*5
           CHARACTER  C_TLE_FILE(SUR__M_SAT)*128
	END TYPE SUR__TYPE
!
	TYPE      SUR__OBS_TYPE
           INTEGER*4  MJD_CUR
           INTEGER*4  L_OBS_TAG
           INTEGER*4  L_STA
           INTEGER*4  L_SCN
           INTEGER*4  L_SCN_CAL
	   INTEGER*4  L_TAP
	   INTEGER*4  IND_TAP(SUR__M_SOU)
	   INTEGER*4  MJD_TAPE_START_CUR
	   REAL*8     TAI_TAPE_START_CUR
           REAL*8     TAI_CUR
           REAL*8     AZ_CUR(SUR__M_STA)
           REAL*8     EL_CUR(SUR__M_STA)
           REAL*8     HA_CUR(SUR__M_STA)
	   REAL*8     AZ_ACC_CUR(SUR__M_STA)
	   REAL*8     HA_ACC_CUR(SUR__M_STA)
	   REAL*8     AZ_ACC_PREV(SUR__M_STA)
	   REAL*8     HA_ACC_PREV(SUR__M_STA)
	   INTEGER*4  USAGE(SUR__M_STA)
	END TYPE  SUR__OBS_TYPE
!
	CHARACTER  MT__ALTAZ*8, MT__EQUAT*8, MT__XY_N*8, MT__XY_E*8
	PARAMETER  ( MT__ALTAZ = 'ALTAZ   ' )
	PARAMETER  ( MT__EQUAT = 'EQUAT   ' )
	PARAMETER  ( MT__XY_N  = 'XY_N    ' )
	PARAMETER  ( MT__XY_E  = 'XY_E    ' )
        CHARACTER    POCAL_STYLE__GBT_4HR*16
        CHARACTER    POCAL_STYLE__KVN*16
        CHARACTER    POCAL_STYLE__ATCA*16
        PARAMETER  ( POCAL_STYLE__GBT_4HR = 'POCAL_GBT_4HR' )
        PARAMETER  ( POCAL_STYLE__KVN     = 'POCAL_KVN' )
        PARAMETER  ( POCAL_STYLE__ATCA    = 'POCAL_ATCA' )
	REAL*8       POCAL_DUR__GBT_4HR 
	PARAMETER  ( POCAL_DUR__GBT_4HR = 480.0D0 )
!
	INTEGER*4  SUR__ALC, SUR__SPL, SUR__UND
	PARAMETER  ( SUR__ALC = 1283023172 )
	PARAMETER  ( SUR__SPL = 1983923874 )
	PARAMETER  ( SUR__UND = 0          )
	INTEGER*4  SUR__AZ, SUR__EL, SUR__HA
	PARAMETER  ( SUR__AZ = 1 )
	PARAMETER  ( SUR__EL = 2 )
	PARAMETER  ( SUR__HA = 3 )
	INTEGER*4  SUR__ALL, SUR__TAG, SUR__STI
	PARAMETER  ( SUR__ALL = 2039102398 )
	PARAMETER  ( SUR__TAG = 1372840123 )
	PARAMETER  ( SUR__STI = 1828947124 )
	INTEGER*4  SUR__COARSE, SUR__FINE, SUR__2STA, SUR__3STA
	PARAMETER  ( SUR__COARSE = 1629838712 )
	PARAMETER  ( SUR__FINE   =  187542038 )
	PARAMETER  ( SUR__2STA   =  937830394 )
	PARAMETER  ( SUR__3STA   =  349290542 )
	INTEGER*4  SUR__USED
	PARAMETER  ( SUR__USED = 1 )
	REAL*8       EL__SOU_MIN
	PARAMETER  ( EL__SOU_MIN = -0.01 ) ! rad, i.e. -35'
	INTEGER*4  KEY__TIME_ABS, KEY__TIME_DUR, KEY__LST_PT, &
     &             KEY__LST_PA, KEY__LST_JB, KEY__LST_MC, KEY__LST_EF, &
     &             KEY__START_STOP, KEY__START_STOP_2STA, KEY__START_STOP_3STA
	PARAMETER  ( KEY__TIME_ABS        = 2019281923 )
	PARAMETER  ( KEY__TIME_DUR        =  886234283 )
	PARAMETER  ( KEY__LST_PT          =  921384210 )
	PARAMETER  ( KEY__LST_PA          =  729183174 )
	PARAMETER  ( KEY__LST_JB          =  301481904 )
	PARAMETER  ( KEY__LST_MC          =  452192384 )
	PARAMETER  ( KEY__LST_EF          =  627132343 )
	PARAMETER  ( KEY__START_STOP      = 1029439128 )
	PARAMETER  ( KEY__START_STOP_2STA = 1923782335 )
	PARAMETER  ( KEY__START_STOP_3STA = 1823703482 )
	REAL*8       KEY__STOP_GAP
	PARAMETER  ( KEY__STOP_GAP = 10.0D0 )
	REAL*8       MAX__CONT_SCAN
	PARAMETER  ( MAX__CONT_SCAN = 1200.0D0 )
        REAL*8       SUR__POCAL_LEN, SUR__PLA_LEN
        PARAMETER  ( SUR__POCAL_LEN = 300.0D0 )
        PARAMETER  ( SUR__PLA_LEN   = 180.0D0 )
        REAL*8       SUR__POCAL_RAT, SUR__POCAL_INT 
        PARAMETER  ( SUR__POCAL_RAT = 1.80D0  )
        PARAMETER  ( SUR__POCAL_INT = 8.0D0*3600.0D0 )
!
        CHARACTER    SUR__POCAL_FIL*128
        PARAMETER  ( SUR__POCAL_FIL = '/vlbi/cats/1jy.sou' )
!
!  >>>> End of Include block sur_sked.i
