#!/usr/bin/env python3
# ************************************************************************
# *                                                                      *
# *   Program spd_movie generates a movie from a directory of files      *
# *   in PostScript format. It is assumed that the contents of these     *
# *   files  was generated by programs opa_tatm_spectrum,                *
# *   opa_tatm_tipping, or spd_res program from package spd_client.      *
# *                                                                      *
# * ### 09-JAN-2024   spd_movie.py   v1.0 (c) L. Petrov 09-JAN-2024 ###  *
# *                                                                      *
# ************************************************************************
import sys, os, shutil, subprocess
sys.path.append('/auto/')
from   pet_misc  import *
import datetime
import optparse 
ivrb = 1
mum_proc = 64

ps_dir     = "/spd/plots"
plot_dir   = "/spd/plots"
output_mp4 = "/spd/movie/movie.mp4"
tmp_file   = "/dev/shm/spd_movie_convert.csh"
fs_rate    = "25"
num_cores  = 64

#
# -- Check whether the output file with movie already exists
#
if ( os.path.isfile ( output_mp4 ) ):
     print ( "Output file %s already exists" % output_mp4 )
     exit  ( 1 )

#
# --- Get the sorted list of files in the ps directory
#
file_list = sorted ( os.listdir( ps_dir ) )

print ( "file_list_len: ", len(file_list) )

#
# --- Generate a list of commands
#
com_list = []
last_jpg_file = ""
for file in file_list:
#
# --- consider only files with extendions .ps
#
    if ( file.find(".ps") < 1 ): continue
#
# --- Add a command for transformation of file from postscript to jpeg
#
    com_list.append ( "convert -antialias -density 283 " + ps_dir+ "/" + file + " " + plot_dir + "/" + file.replace(".ps",".jpg") )
    last_jpg_file =  plot_dir + "/" + file.replace(".ps",".jpg")
         
#
# --- Write the list of file transformation commands into the temporary file
#
(ret,err) = write_file ( com_list, tmp_file )
check_err_exe ( ret, err, "write_file" )

#
# --- Execute this temporary files in parallel
#
com = "cat %s | parallel -j %d :::" % ( tmp_file, num_cores )
if ( ivrb > 0 ):
     print ( "com= ", com )
(ret, out) = exe_pipe ( com )
os.unlink ( tmp_file )

#
# -- Learn image dimensions in the last jpg file
#
com = "identify " + last_jpg_file
if ( ivrb > 0 ):
    print ( "com= ", com )
(ret, out) = exe ( com )
if ( ivrb > 0 ):
     print ( "out= ", out )

width  = out[0].split()[2].split("x")[0]
height = out[0].split()[2].split("x")[1] 
    
#
# --- Generate a command for mmencoder that will make movie
#
mencode_opt = "vbitrate=2160000:mbd=2:keyint=132:v4mv:vqmin=3:lumi_mask=0.07:dark_mask=0.2:mpeg_quant:scplx_mask=0.1:tcplx_mask=0.1:vhq:threads=%d" % num_cores
com = "mencoder \"mf://" + plot_dir + "/*.jpg\" -mf type=jpg:w=" + width + ":h=" + height + \
      ":fps=" + fs_rate + " -ovc lavc vcodec=mpeg4:" + mencode_opt + \
      " -ffourcc DX50 -nosound -ofps " + \
      fs_rate + " -o " + output_mp4

if ( ivrb > 0 ):
     print ( "com: " + com )
(ret, out) = exe ( com )

if ( ret !=0 ):
     print ( "(E) ", ret, " Failure in executing ", com )
     print ( ret )
     print ( out )
     exit ( 1 )

