      PROGRAM    EVAL_GAIN
! ************************************************************************
! *                                                                      *
! *   Program EVAL_GAIN is for processing the log file generated by      *
! *   the procveadure aquire of the VLBI antenna controlled software     *
! *   Fields System. It computes Tsys, SEFD, and gain averaged over      *
! *   a number of elevation bins and fitted to a low degree polynomical  *
! *   as a function of elevation angle.                                  *
! *                                                                      *
! *  ### 12-JUL-2021   EVAL_GAIN   v1.0 (c)  L. Petrov  06-NOV-2021 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INTEGER*4  MP, MIND, MPOL, MA, MSOU
      PARAMETER  ( MP = 2*1024*1024 )
      PARAMETER  ( MIND =        64 )
      PARAMETER  ( MPOL =         8 )
      PARAMETER  ( MA   =        10 )
      PARAMETER  ( MSOU =        32 )
      REAL*8     TIM(MP), EL(MP), POL_COEF(MPOL), RC, &
     &           SEFD_AVR, TSYS_AVR, GAIN_AVR, &
     &           SEFD_RMS, TSYS_RMS, GAIN_RMS, &
     &           SEFD(MP), TSYS(MP), GAIN(MP), &
     &           SEFD_MOD(MP), TSYS_MOD(MP), GAIN_MOD(MP), &
     &           SEFD_FLT(MP), TSYS_FLT(MP), GAIN_FLT(MP), EL_FLT(MP), &
     &           EL_ARR(MA), GAIN_ARR(MA), TSYS_ARR(MA), SEFD_ARR(MA)
      DATA       EL_ARR /      &
     &                    3.0, &
     &                    8.0, &
     &                   15.0, &
     &                   20.0, &
     &                   25.0, &
     &                   30.0, &
     &                   45.0, &
     &                   70.0, &
     &                   80.0, &
     &                   90.0  &
     &                  /
      REAL*8     SEFD_MIN, SEFD_MAX, SEFD_MIN_VAL, SEFD_MAX_VAL
      REAL*8     TSYS_MIN, TSYS_MAX, TSYS_MIN_VAL, TSYS_MAX_VAL
      REAL*8     GAIN_MIN, GAIN_MAX, GAIN_MIN_VAL, GAIN_MAX_VAL
      CHARACTER  FIL*128, BUF(MP)*128, SENS_ID*4, C_PLOT*3, C_MODE*4, &
     &           FREQ_STR*8, STR*128, STR_DATE*19, POL_NAM*1, &
     &           POL_TYP*2, STA_NAM*8, C_SOU(MSOU)*8, SOU_LIST*1024
      CHARACTER    EVAL_GAIN__STR*18
      PARAMETER  ( EVAL_GAIN__STR = 'eval_gain 20250703' )
      REAL*8     SEC, TIM0, FREQ, BDW
      INTEGER*4  J1, J2, J3, LIND, IND(2,MIND), MODE, MJD, NP, KP, KF, &
     &           LPOL_GAIN, LPOL_SEFD, LPOL_TSYS, L_SOU, IUER
      LOGICAL*1, EXTERNAL :: IS_R8_NAN
      INTEGER*4, EXTERNAL :: ILEN, LTM_DIF
      CHARACTER, EXTERNAL :: VEX_TO_DATE*19
!
      TSYS_AVR = 0.0D0
      SEFD_AVR = 0.0D0
      GAIN_AVR = 0.0D0
      CALL CLRCH ( SOU_LIST )
!
      IF ( IARGC() < 16 ) THEN
           WRITE ( 6, * ) 'Usage: eval_gain fil sta_nam pol_typ sens_id mode plot '// &
     &                    'lpol_tsys tsys_min tsys_max '// &
     &                    'lpol_sefd sefd_min sefd_max '// &
     &                    'lpol_gain gain_min gain_max '// &
     &                    'bdw [sou_list]'
           CALL EXIT ( 1 ) 
         ELSE
           CALL GETARG (  1, FIL     )
           CALL GETARG (  2, STA_NAM )
           CALL GETARG (  3, POL_TYP )
           CALL GETARG (  4, SENS_ID )
           CALL GETARG (  5, C_MODE  )
           CALL GETARG (  6, C_PLOT  )
           CALL TRAN   ( 11, C_PLOT, C_PLOT )
           CALL GETARG (  7, STR ) ; READ ( UNIT=STR, FMT='(I2)'    ) LPOL_TSYS
           CALL GETARG (  8, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) TSYS_MIN
           CALL GETARG (  9, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) TSYS_MAX
           CALL GETARG ( 10, STR ) ; READ ( UNIT=STR, FMT='(I2)'    ) LPOL_SEFD
           CALL GETARG ( 11, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) SEFD_MIN
           CALL GETARG ( 12, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) SEFD_MAX
           CALL GETARG ( 13, STR ) ; READ ( UNIT=STR, FMT='(I2)'    ) LPOL_GAIN
           CALL GETARG ( 14, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) GAIN_MIN
           CALL GETARG ( 15, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) GAIN_MAX
           CALL GETARG ( 16, STR ) ; READ ( UNIT=STR, FMT='(F10.5)' ) BDW
           IF ( IARGC() .GE. 17 ) THEN
                CALL GETARG ( 17, SOU_LIST )
           END IF
      END IF
!
! --- Check the argument source list
!
      IF ( ILEN(SOU_LIST) > 0 ) THEN
!
! -------- It is expected to be a comma-separated list of sources
!
           CALL EXWORD ( SOU_LIST, MSOU, L_SOU, IND, ',:;', IUER )
           DO 410 J1=1,L_SOU
!
! ----------- Extracted it adn convert to the lower case
!
              C_SOU(J1) = SOU_LIST(IND(1,J1):IND(2,J1))
              CALL TRAN ( 12, C_SOU(J1), C_SOU(J1) )
 410       CONTINUE 
         ELSE
!
! -------- Default: all the sources
!
           L_SOU = 1
           C_SOU(L_SOU) = 'all' 
      END IF 
!
! --- Read the file with log or onof lines only
!
      IUER = -1
      CALL RD_TEXT ( FIL, MP, BUF, NP, IUER )
      IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
!
      TIM0 = 1.001D30
      KP   = 0
!
! --- Cycle over lines of the file
!
      DO 420 J2=1,NP
         CALL EXWORD ( BUF(J2), MIND, LIND, IND, CHAR(32)//CHAR(9), IUER )
         IF ( LIND < 2 ) GOTO 420
         IF ( INDEX ( BUF(J2), '#onoff#VAL' ) > 0                                .AND. &
     &        ( LTM_DIF ( 0, L_SOU, C_SOU, BUF(J2)(IND(1,2):IND(2,2)) ) > 0 .OR. &
     &          C_SOU(1) == 'all'                                                ) .AND. &
     &        BUF(J2)(IND(1,5):IND(2,5)) == SENS_ID ) THEN
!
              KP = KP + 1
              IUER = -1
              BUF(J2)(5:5)   = 'y'
              BUF(J2)(9:9)   = 'd'
              BUF(J2)(12:12) = 'h'
              BUF(J2)(15:15) = 'm'
              BUF(J2)(18:18) = 's'
              STR_DATE = VEX_TO_DATE ( BUF(J2)(1:20), IUER )
              CALL DATE_TO_TIME ( STR_DATE, MJD, SEC, IUER )
              READ ( UNIT=BUF(J2)(IND(1,4):IND(2,4)),   FMT='(F8.1)' ) EL(KP)
              IF ( BUF(J2)(IND(1,11):IND(1,11)) == '$' ) THEN
                   SEFD(KP) = 99999.9
                 ELSE 
                   READ ( UNIT=BUF(J2)(IND(1,11):IND(2,11)), FMT='(F8.1)' ) SEFD(KP)
              END IF
              IF ( SEFD(KP) < 1.0 ) THEN
                   SEFD(KP) = 99999.9
              END IF
              IF ( BUF(J2)(IND(1,10):IND(1,10)) == '$' ) THEN
                   TSYS(KP) = 99999.9
                 ELSE
                   READ ( UNIT=BUF(J2)(IND(1,10):IND(2,10)), FMT='(F8.1)' ) TSYS(KP)
              END IF
              GAIN(KP) = TSYS(KP)/SEFD(KP)
              IF ( TIM0 > 1.D30 ) THEN
                   TIM0 = MJD*86400.0D0 + SEC
              END IF
              TIM(KP) = (MJD*86400.0D0 + SEC - TIM0)/3600.0
              READ ( UNIT=BUF(J2)(IND(1,8):IND(2,8)), FMT='(F8.2)' ) FREQ
              FREQ_STR = BUF(J2)(IND(1,8):IND(2,8))
              IF ( BUF(J2)(IND(1,7):IND(2,7)) == 'l' ) THEN
                   IF ( POL_TYP == 'RL' ) THEN
                        POL_NAM = 'L'
                      ELSE
                        POL_NAM = 'H'
                   END IF
                 ELSE IF ( BUF(J2)(IND(1,7):IND(2,7)) == 'r' ) THEN
                   IF ( POL_TYP == 'RL' ) THEN
                        POL_NAM = 'R'
                      ELSE
                        POL_NAM = 'V'
                   END IF
              END IF
         END IF
 420  CONTINUE 
      IF ( C_PLOT(1:1) == 'V' ) THEN
           CALL GETENVAR ( 'EVAL_GAIN_PLOT', STR )
           IF ( STR(1:1) == 'Y' .OR. STR(1:1) == 'y' ) THEN
                C_PLOT = 'Y'
              ELSE 
                C_PLOT = 'N'
           END IF
      END IF
!
      IF ( C_MODE == 'time' .AND. C_PLOT(1:1) == 'Y' ) THEN
           CALL DIAGI_SETDEF ( IUER, 'DIAGI_CTIT', 'Time SEFD dependence for '// &
     &                         FREQ_STR//' Pol: '//POL_NAM//' in Jy' )
           CALL DIAGI_SETDEF ( IUER, 'DIAGI_UNIT', 'Time in hours' )
           CALL DIAGI_SETDEF ( IUER, 'DIAGI_ILST', 1 )
           CALL DIAGI_1 ( KP, TIM, SEFD, IUER )
           CALL DIAGI_SETDEF ( IUER, 'DIAGI_CTIT', 'Time Tsys dependence for '// &
     &                         FREQ_STR//' Pol: '//POL_NAM//' in K' )
           CALL DIAGI_SETDEF ( IUER, 'DIAGI_UNIT', 'Time in hours' )
           CALL DIAGI_1 ( KP, TIM, TSYS, IUER )
        ELSE IF ( C_MODE == 'elev' ) THEN
           CALL SORT8   ( KP, EL, SEFD )
!
           CALL FILTER_RANGE ( KP, EL, TSYS, TSYS_MIN, TSYS_MAX, KF, EL_FLT, TSYS_FLT )
           IUER = -1
           WRITE ( 6, 100 ) EVAL_GAIN__STR, STR_DATE
 100       FORMAT ( 'Gain computed with ', A/ &
     &              'Experiment date: ', A    )
           CALL POL_FIT ( LPOL_TSYS, KF, EL_FLT, 45.0D0, TSYS_FLT, TSYS_MOD, POL_COEF, &
     &                    TSYS_AVR, TSYS_RMS, RC, MA, EL_ARR, TSYS_ARR, IUER )
           WRITE ( 6, 110 ) STA_NAM, 1.D-3*FREQ, POL_NAM, TSYS_AVR, TSYS_ARR(8), TSYS_RMS
 110       FORMAT ( 'Sta: ', A, '  Freq: ', F7.3, ' GHz Pol: ', A1, &
     &              ' tsys_avr: ', F6.1, ' tsys_70deg: ', F6.1, ' tsys_rms: ', F6.1, ' K' )
!
           WRITE ( 6, 210 ) STA_NAM, 1.D-3*(FREQ-BDW/2.0D0), 1.D-3*(FREQ+BDW/2.0D0), &
     &                      STA_NAM, EL_ARR, STA_NAM, POL_NAM, TSYS_ARR
 210       FORMAT ( 'TSYS_FREQS:    ', A,'  GHz', 8X, F7.3, 2X, F7.3 / &
     &              'TSYS_ELEVS:    ', A,'  deg        ', 10(3X,F4.1)/ &
     &              'TSYS_POLVALS:  ', A,'  K     ',A, 4X,10(1X,F6.1) )  
           IF ( C_PLOT(1:1) == 'Y' .AND. .NOT. IS_R8_NAN(TSYS_ARR(1)) ) THEN
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_ILST', 1 )
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_UNIT', 'Elevation in deg' )
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_CTIT', 'Elevation dependence for Tsys '// &
     &                              FREQ_STR//' Pol: '//POL_NAM//' in K' )
                CALL DIAGI_2 ( KP, EL, TSYS, KF, EL_FLT, TSYS_MOD, IUER )
              ELSE IF ( C_PLOT(1:1) == 'Y' .AND. IS_R8_NAN(TSYS_ARR(1)) ) THEN
                CALL DIAGI_1 ( KP, EL, TSYS, IUER )
           END IF
!
           CALL FILTER_RANGE ( KP, EL, SEFD, SEFD_MIN, SEFD_MAX, KF, EL_FLT, SEFD_FLT )
           IUER = -1
           CALL POL_FIT ( LPOL_SEFD, KF, EL_FLT, 45.0D0, SEFD_FLT, SEFD_MOD, POL_COEF, &
     &                    SEFD_AVR, SEFD_RMS, RC, MA, EL_ARR, SEFD_ARR, IUER )
           IF ( IUER .NE. 0 ) CALL EXIT ( 1 ) 
           WRITE ( 6, 120 ) STA_NAM, 1.D-3*FREQ, POL_NAM, SEFD_AVR, SEFD_ARR(8), SEFD_RMS
 120       FORMAT ( 'Sta: ', A, '  Freq: ', F7.3, ' GHz Pol: ', A1, &
     &              ' SEFD_avr: ', F6.1, ' SEFD_70deg: ', F6.1, ' SEFD_rms: ', F6.1, ' Jy' )
           IF ( C_PLOT(1:1) == 'Y' .AND. .NOT. IS_R8_NAN(SEFD_MOD(1)) ) THEN
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_ILST', 1 )
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_CTIT', 'Elevation SEFD dependence for '// &
     &                              FREQ_STR//' Pol: '//POL_NAM//' in Jy' )
                CALL DIAGI_2 ( KP, EL, SEFD, KF, EL_FLT, SEFD_MOD, IUER )
              ELSE IF ( C_PLOT(1:1) == 'Y' .AND. IS_R8_NAN(SEFD_MOD(1)) ) THEN
                CALL DIAGI_1 ( KP, EL, SEFD, IUER )
           END IF
!
           CALL FILTER_RANGE ( KP, EL, GAIN, GAIN_MIN, GAIN_MAX, KF, EL_FLT, GAIN_FLT )
           CALL POL_FIT ( LPOL_GAIN, KF, EL_FLT, 45.0D0, GAIN_FLT, GAIN_MOD, POL_COEF, &
     &                    GAIN_AVR, GAIN_RMS, RC, MA, EL_ARR, GAIN_ARR, IUER )
           WRITE ( 6, 130 ) STA_NAM, 1.D-3*FREQ, POL_NAM, GAIN_AVR, GAIN_ARR(8), GAIN_RMS
 130       FORMAT ( 'Sta: ', A, '  Freq: ', F7.3, ' GHz Pol: ', A1, &
     &              ' gain_avr: ', F6.3, ' gain_70deg: ', F6.3, ' gain_rms: ', F6.3, ' K/Jy' )
           IF ( C_PLOT(1:1) == 'Y' .AND. .NOT. IS_R8_NAN(GAIN_MOD(1)) ) THEN
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_ILST', 1 )
                CALL DIAGI_SETDEF ( IUER, 'DIAGI_CTIT', 'Elevation gain dependence for '// &
     &                              FREQ_STR//' Pol: '//POL_NAM//' in K/Jy' )
                CALL DIAGI_2 ( KP, EL, GAIN, KF, EL_FLT, GAIN_MOD, IUER )
             ELSE IF ( C_PLOT(1:1) == 'Y' .AND. IS_R8_NAN(GAIN_MOD(1)) ) THEN
                CALL DIAGI_1 ( KP, EL, GAIN, IUER )
           END IF
!
           WRITE ( 6, 220 ) STA_NAM, 1.D-3*(FREQ-BDW/2.0D0), 1.D-3*(FREQ+BDW/2.0D0), &
     &                      STA_NAM, EL_ARR, STA_NAM, POL_NAM, GAIN_ARR
 220       FORMAT ( 'GAIN_FREQS:    ', A,'  GHz', 8X, F7.3, 2X, F7.3 / &
     &              'GAIN_ELEVS:    ', A,'  deg        ', 10(3X,F4.1)/ &
     &              'GAIN_POLVALS:  ', A,'  K/Jy  ',A, 4X,10(1X,F6.3) )  
      END IF
!
      END  PROGRAM  EVAL_GAIN  !#!#
!
! ------------------------------------------------------------------------
!
      SUBROUTINE POL_FIT ( MP, MA, ARG, ARG0, FUN, MOD, POL_COEF, &
     &                     AVR, RMS, RC, MO, ARR_OUT, VAL_OUT, IUER )
! ************************************************************************
! *                                                                      *
! *   Axuilliry routine POL_FIT
! *                                                                      *
! *  ### 27-OCT-2021     POL_FIT   2.0 (c)  L. Petrov  06-NOV-2021  ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INTEGER*4  MP, MA, MO, IUER
      REAL*8     ARG(MA), FUN(MA), MOD(MA), POL_COEF(0:MP), ARR_OUT(MO), &
     &           VAL_OUT(MO), ARG0, AVR, RMS, RC
      REAL*8,    ALLOCATABLE :: NOR_MAT(:), NOR_VEC(:), EQU_VEC(:)
      INTEGER*4  J1, J2, J3, J4, J5, J6, LP, IER
      REAL*8,    EXTERNAL :: DP_VV_V
!
      LP = MP+1
      ALLOCATE ( NOR_MAT(LP*(LP+1)/2), NOR_VEC(LP), EQU_VEC(0:LP) )
      NOR_MAT = 0.0D0
      NOR_VEC = 0.0D0
      DO 410 J1=1,MA
         DO 420 J2=0,MP
            EQU_VEC(J2) = (ARG(J1) - ARG0)**J2
 420     CONTINUE 
         CALL DIAD_CVT_S ( 1.0D0, LP, EQU_VEC, EQU_VEC, NOR_MAT )
         CALL NORVEC_UPD ( LP, 1.00D0, FUN(J1), EQU_VEC, NOR_VEC )
 410  CONTINUE 
!
      CALL ERR_PASS ( IUER, IER )
      CALL INVS ( LP, NOR_MAT, RC, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 5971, IUER, 'POL_FIT', 'Failure in matrix inversion '// &
     &         'when tried to solved for the polynomial model' ) 
           RETURN 
      END IF
!
      CALL MUL_MV_SV_V ( LP, NOR_MAT, LP, NOR_VEC, LP, POL_COEF, IER )
!
      AVR = 0.0D0
      RMS = 0.0D0
      DO 430 J3=1,MA
         DO 440 J4=0,MP
            EQU_VEC(J4) = (ARG(J3) - ARG0)**J4
 440     CONTINUE 
         MOD(J3) = DP_VV_V ( LP, EQU_VEC, POL_COEF )
         AVR = AVR + MOD(J3)
         RMS = RMS + (MOD(J3) - FUN(J3))**2
 430  CONTINUE 
      AVR = AVR/MA
      RMS = DSQRT ( RMS/MA )
!
      DO 450 J5=1,MO
         DO 460 J6=0,MP
            EQU_VEC(J6) = (ARR_OUT(J5) - ARG0)**J6
 460     CONTINUE 
         VAL_OUT(J5) = DP_VV_V ( LP, EQU_VEC, POL_COEF )
 450  CONTINUE 
!
      DEALLOCATE ( NOR_MAT, NOR_VEC, EQU_VEC )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  POL_FIT  !#!  
!
! ------------------------------------------------------------------------
!
      SUBROUTINE FILTER_RANGE ( MP, ARG, VAL, VAL_MIN, VAL_MAX, KF, ARG_FLT, VAL_FLT )
      IMPLICIT   NONE 
      INTEGER*4  MP, KF
      REAL*8     ARG(MP), VAL(MP), VAL_MIN, VAL_MAX, ARG_FLT(MP), VAL_FLT(MP)
      INTEGER*4  J1
!
      KF = 0
      DO 410 J1=1,MP
         IF ( VAL(J1) .GE. VAL_MIN .AND. VAL(J1) .LE. VAL_MAX ) THEN
              KF = KF + 1
              ARG_FLT(KF) = ARG(J1)
              VAL_FLT(KF) = VAL(J1)
         END IF
 410  CONTINUE 
      RETURN
      END  SUBROUTINE  FILTER_RANGE  !#!#
