      SUBROUTINE COMMON_33_TO_46()
! ************************************************************************
! *                                                                      *
! *   Routine  COMMON_33_TO_46  transfroms common block from 33-block    *
! *   format (pre JUN-2000) to 46-block format (post JUL-2000 ).         *
! *                                                                      *
! *   It is assumed that the image of 33-block of SOCOM resids there     *
! *   where the image of 46-block should be located.                     *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 21-JUL-2000  COMMON_33_TO_46  v1.0 (d) L. Petrov 24-JUL-2000 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'solve.i'
      INCLUDE   'socom.i'
      INCLUDE   'socom_33.i'
      INTEGER*4  NB, NB_33
      INTEGER*2  INT2_ARG
      INTEGER*4  INT4
      INT4(INT2_ARG) = INT(INT2_ARG,KIND=4)
!
      NB_33 = JSOCOM_BLOCKS_33*INT4(BLOCK_BYTES)
      NB    = JSOCOM_BLOCKS*INT4(BLOCK_BYTES)
!
! --- Copying content of socom to its 33-block sister
!
      CALL LIB$MOVC3 ( NB_33, ISOCOM, ISOCOM_33 )
!
! --- Initialization of main socom
!
      CALL NOUT      ( NB,    ISOCOM )
      CALL CLRCH ( USER_PRO )
      CALL CLRCH ( USER_BUF )
      CALL CLRCH ( SCR_FIL_ORIGIN )
      CALL CLRCH ( EXP_DESC )
      CALL CLRCH ( EXP_CODE )
      CALL CLRCH ( PI_NAME )
      CALL CLRCH ( CORRELATOR_NAME )
      CALL CLRCH ( CORRTYPE )
      CALL CLRCH ( REC_MODE )
      CALL CLRCH ( UT1_RS )
      CALL CLRCH ( UT1_RS_FLYBY )
!
! --- Copying stuff from 33-block socom to its older sister: 46-block socom
!
!
! --- REAL*8
!
      PI_VAR = PI_33
      CALL LIB$MOVC3 ( 8*INT4(MAX_CLK), FJDCL_33, FJDCL )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ATM), TATM_33, TATM )
      ELMIN = ELMIN_33
      VLIGHT = VLIGHT_33
      CALL LIB$MOVC3 ( 8*INT4(MAX_ROT), TROT_33, TROT )
      CALL LIB$MOVC3 ( 8*3, WRMS_33, WRMS )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ROT)*4, ROTAP_33, ROTAP )
      CALL LIB$MOVC3 ( 8*3, UT1INB_33, UT1INB )
      CALL LIB$MOVC3 ( 8*3, WOBINB_33, WOBINB  )
      CALCV = CALCV_33
      ATMOS_INTERVAL = ATMOS_INTERVAL_33
      CLOCK_INTERVAL = CLOCK_INTERVAL_33
      CALL LIB$MOVC3 ( 8*2, ROT_INTERVAL_33, ROT_INTERVAL )
      TROT_A1 = TROT_A1_33
      CALL LIB$MOVC3 ( 8*INT4(MAX_EROT_VALUES), UT1PTB_33, UT1PTB )
      CALL LIB$MOVC3 ( 8*INT4(MAX_EROT_VALUES), WOBXXB_33, WOBXXB )
      CALL LIB$MOVC3 ( 8*INT4(MAX_EROT_VALUES), WOBYYB_33, WOBYYB )
      FCNPER = FCNPER_33
      CALL LIB$MOVC3 ( 8*INT4(MAX_ARC_STA), SACNST_33, SACNST )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ARC_STA), SCCNST_33, SCCNST  )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ARC_STA), ELVCUT_33, ELVCUT )
      CALL LIB$MOVC3 ( 8*3, EOPCONS_33, EOPCONS  )
      CALL LIB$MOVC3 ( 8*3, EOPRCONS_33, EOPRCONS  )
      CALL LIB$MOVC3 ( 8*2, SEOCNST_33, SEOCNST  )
      PWCCNST = PWCCNST_33
      CALL LIB$MOVC3 ( 8*2, NUTCONS_33, NUTCONS  )
      CALL LIB$MOVC3 ( 8*INT4(MAX_GRAD_33), TGRAD_33, TGRAD  )
      GRAD_INTERVAL = GRAD_INTERVAL_33
      CALL LIB$MOVC3 ( 8*2, GRADCONS_33, GRADCONS )
      NUTPSI_DIF = NUTPSI_DIF_33
      NUTEPS_DIF = NUTEPS_DIF_33
!
! --- LOGICAL*2
!
      LOGBCL = LOGBCL_33
      BMODE_CL = BMODE_CL_33
      BMODE_AT = BMODE_AT_33
      CLK_BRK_STAT = CLK_BRK_STAT_33
      FLYBY_WARNING = FLYBY_WARNING_33
      SITE_DEP_CONST = SITE_DEP_CONST_33
      SIMULATION_TEST = SIMULATION_TEST_33
      SITE_DEP_EL_CUT = SITE_DEP_EL_CUT_33
      SHORT_UT1_IN = SHORT_UT1_IN_33
      SOL_AVAIL = SOL_AVAIL_33
      OLD_CLOCKS = OLD_CLOCKS_33
      OLD_ATMS = OLD_ATMS_33
      SKIP_EOP_OFF = SKIP_EOP_OFF_33
      CGM_TYPE = CGM_TYPE_33
!
! --- Character
!
      USER_PRO = USER_PRO_33
      USER_BUF = USER_BUF_33
      SCR_FIL_ORIGIN = SCR_FIL_ORIGIN_33
      UT1_RS = UT1_RS_33
      UT1_RS_FLYBY = UT1_RS_FLYBY_33
!
! --- INTEGER*2
!
      NUMSTR = NUMSTR_33
      NUMSTA = NUMSTA_33
      NPOLD = NPOLD_33
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_ARC_STA), ICLOCK_33, ICLOCK )
      IDNWT = IDNWT_33
      IPRES = IPRES_33
      CALL LIB$MOVC3 ( 2*2, IRNCD_33, IRNCD  )
      ITDGLB = ITDGLB_33
      NPARAM = NPARAM_33
      IDATYP = IDATYP_33
      NROT = NROT_33
      NSOURC = NSOURC_33
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NSPARM_33, NSPARM  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NUMATM_33, NUMATM  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NUMGRAD_33, NUMGRAD )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), IATSTR_33, IATSTR  )
      ICLMAX = ICLMAX_33
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NUMCLK_33, NUMCLK  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), ICLSTR_33, ICLSTR  )
      IPSTP = IPSTP_33
      CALL LIB$MOVC3 ( 2*3, LNUT_33, LNUT  )
      LPREC = LPREC_33
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS)*3, LTIDE_33, LTIDE )
      LREL = LREL_33
      CALL LIB$MOVC3 ( 2*INT4(ROT_BIT_WORDS)*3, LROT_33, LROT  )
      CALL LIB$MOVC3 ( 2*INT4(ATM_BIT_WORDS)*3, LATM_33, LATM  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_CLK), LCLK_33, LCLK  )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_33), LSTAR_33(1,1), LSTAR(1,1) )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_33), LSTAR_33(1,2), LSTAR(1,2) )
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS), LAXOF_33, LAXOF  )
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS)*3, LSITEC_33, LSITEC )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_33), ISRSEL_33, ISRSEL  )
      IUEN = IUEN_33
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_CLK), ICLSTA_33, ICLSTA  )
      NFLEPS = NFLEPS_33
      CALL LIB$MOVC3 ( 2*14, FLEPS_33, FLEPS  )
      NFLPSI = NFLPSI_33
      CALL LIB$MOVC3 ( 2*14, FLPSI_33, FLPSI  )
      CALL LIB$MOVC3 ( 2*7, IDPNUT_33, IDPNUT  )
      NDPNUT = NDPNUT_33
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS)*3, LSITEV_33, LSITEV )
      IARCSOC = IARCSOC_33
      NSLAST = NSLAST_33
      IDBSEL = IDBSEL_33
      NDB = NDB_33
      IDCSEL = IDCSEL_33
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_ARC_STA), IBLSEL_G_33, &
     &     IBLSEL_G )
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_ARC_STA), IBLSEL_P_33, &
     &     IBLSEL_P )
      CONSTRAINT_BITS = CONSTRAINT_BITS_33
      INDL = INDL_33
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), WVMASK_33, WVMASK  )
      BM_REF_CL = BM_REF_CL_33
      CALL LIB$MOVC3 ( 2*2, NROT_A1_33, NROT_A1 )
      CALL LIB$MOVC3 ( 2*2, EOP_STYLE_33, EOP_STYLE  )
      CALL LIB$MOVC3 ( 2*2, EOPA1_CHOICE_33, EOPA1_CHOICE )
      IEOPL = IEOPL_33
      NUMSTAX = NUMSTAX_33
      INTERPOLATION_UT1 = INTERPOLATION_UT1_33
      INTERPOLATION_PM = INTERPOLATION_PM_33
      BGROUND = BGROUND_33
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_33), LPROP_33(1,1), LPROP(1,1) )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_33), LPROP_33(1,2), LPROP(1,2) )
      TOTSTA = TOTSTA_33
      CALL LIB$MOVC3 ( 2*2, LGRAD_33, LGRAD  )
      INIT_INTERACTIVE = INIT_INTERACTIVE_33
      CALL LIB$MOVC3 ( 2*2, CLOCK_REF_BITS_33, CLOCK_REF_BITS  )
      IDBEST = IDBEST_33
      OPP_STATUS = OPP_STATUS_33
      PAMB_STATUS = PAMB_STATUS_33
      SUPMET = SUPMET_33
      CALL LIB$MOVC3 ( 2*INT4(SOCOM_IFREE_LEN), IFREE_SOCOM_33, IFREE_SOCOM  )
      SOCOM_LAST_I2 = SOCOM_LAST_I2_33
!
! --- INTEGER*4
!
      NUMOBS = NUMOBS_33
      CALL LIB$MOVC3 ( 4*INT4(MAX_DBS), IDBEND_33, IDBEND  )
      NUMSCA = NUMSCA_33
      STABIT_G(1) = STABIT_G_33(1)
      STABIT_G(2) = STABIT_G_33(2)
      STABIT_P(1) = STABIT_P_33(1)
      STABIT_P(2) = STABIT_P_33(2)
!
      RETURN
      END  !#!  COMMON_33_TO_46  #!#
