#!/bin/csh -f
# ************************************************************************
# *                                                                      *
# *   Program solve_apr_vcat_update.csh creates an intial the VCAT       *
# *   catalogue  configuration file. It also creates VTD configuration   *
# *   file used by pSolve for the  interactive solution and updates      *
# *   a priori files.                                                    *
# *                                                                      *
# *   Copyright (c) 1975-2025 United States Government as represented by *
# *   the Administrator of the National Aeronautics and Space            *
# *   Administration. All Rights Reserved.                               *
# *   License: NASA Open Source Software Agreement (NOSA).               *
# *                                                                      *
# * ### 17-JUN-2020 gen_vcat_conf.csh v1.3 (d) L. Petrov 19-APR-2025 ### *
# *                                                                      *
# ************************************************************************
if ( -f $SOLVE_VTD_DIR/bin/vtd_vars == 0 ) then
     echo "Did not find $SOLVE_VTD_DIR/bin/vtd_vars"
     exit 1
endif
#
source $SOLVE_VTD_DIR/bin/vtd_vars
if ( ${?VTD_DATA} == 0 ) then
     echo "Variable VTD_DATA is not defined in $SOLVE_VTD_DIR/bin/vtd_vars"
     exit 1
endif
#
if ( -d $VTD_DATA == 0 ) then
     echo "Did not find directory VTD_DATA defined in $SOLVE_VTD_DIR/bin/vtd_vars"
     exit 1
endif
#
if ( -f $VTD_DATA/vtd_test_01.cnf == 0 ) then
     echo "Did not find file defined vtd_test_01.cnf $VTD_DATA directory defined in $SOLVE_VTD_DIR/bin/vtd_vars"
     exit 1
endif
if ( -d /apr/ == 0 ) then
     echo 'WARNING! WARNING! WARNING!'
     echo "Did not find /apr directory: a priori data will not be configured"
     echo 'WARNING! WARNING! WARNING!'
  else
     if ( -d /apr/sta == 0 ) then
          mkdir --mode=0755 /apr/sta
     endif
     if ( -d /apr/sou == 0 ) then
          mkdir --mode=0755 /apr/sou
     endif
     if ( -d /apr/eph == 0 ) then
          mkdir --mode=0755 /apr/eph
     endif
     if ( -d /apr/eop == 0 ) then
          mkdir --mode=0755 /apr/eop
     endif
#
# --- Check missing files and copy them from VTD data directory if needed
#
     setenv VTD_BINDIR  `vtd_inq --bindir`
     setenv VTD_DATADIR `vtd_inq --data`
     echo "ok"
     $VTD_BINDIR/vtd_apriori_update.py -c ${VTD_DATADIR}/apr_update.conf --missing
#
     cp -p ${VTD_DATADIR}/*.heo /apr/eop/
endif
#
# --- Generae vcat.conf file and put it in the temporary directry $SOLVE_ROOT/support/
#
set DATE_ISO  = `date "+%Y.%m.%d_%H:%M:%S"`
set VCAT_FILE = $SOLVE_ROOT/support/vcat.conf
#
echo '# VCAT  Configuration file.  Version of 2020.06.08'                           > $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo "# Generated by solve_apr_vcat_update.csh on $DATE_ISO"                       >> $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo '#  GVF_REP_NAMES  list of GVF repositories'                                  >> $VCAT_FILE
echo '#  GVF_ENV_DIR    name of the GVF directory for ascii database envelopes'    >> $VCAT_FILE
echo '#  GVF_DB_DIR     name of the GVF directory for binary database files'       >> $VCAT_FILE
echo '#  VTD_CONF_FILE  name of VTD configuration files used by interactive Solve' >> $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo "GVF_REP_NAMES: OBS INT SIM"                                                  >> $VCAT_FILE
echo "GVF_DB_DIR:    OBS $SOLVE_GVF_DATA/obs/db"                                   >> $VCAT_FILE
echo "GVF_ENV_DIR:   OBS $SOLVE_GVF_DATA/obs/env"                                  >> $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo "GVF_DB_DIR:    INT $SOLVE_GVF_DATA/int/db"                                   >> $VCAT_FILE
echo "GVF_ENV_DIR:   INT $SOLVE_GVF_DATA/int/env"                                  >> $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo "GVF_DB_DIR:    SIM $SOLVE_GVF_DATA/sim/db"                                   >> $VCAT_FILE
echo "GVF_ENV_DIR:   SIM $SOLVE_GVF_DATA/sim/env"                                  >> $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo "VTD_CONF_FILE: $SOLVE_SAVE_DATA/solve_lite.vtd"                              >> $VCAT_FILE
echo '#'                                                                           >> $VCAT_FILE
echo '# VCAT  Configuration file.  Version of 2020.06.08'                          >> $VCAT_FILE
#
# --- If directories with GVF data do not exist, let us create them
#
if ( ! -d $SOLVE_GVF_DATA/obs     ) mkdir $SOLVE_GVF_DATA/obs
if ( ! -d $SOLVE_GVF_DATA/obs/env ) mkdir $SOLVE_GVF_DATA/obs/env
if ( ! -d $SOLVE_GVF_DATA/obs/db  ) mkdir $SOLVE_GVF_DATA/obs/db
if ( ! -d $SOLVE_GVF_DATA/int     ) mkdir $SOLVE_GVF_DATA/int
if ( ! -d $SOLVE_GVF_DATA/int/env ) mkdir $SOLVE_GVF_DATA/int/env
if ( ! -d $SOLVE_GVF_DATA/int/db  ) mkdir $SOLVE_GVF_DATA/int/db
if ( ! -d $SOLVE_GVF_DATA/sim     ) mkdir $SOLVE_GVF_DATA/sim
if ( ! -d $SOLVE_GVF_DATA/sim/env ) mkdir $SOLVE_GVF_DATA/sim/env
if ( ! -d $SOLVE_GVF_DATA/sim/db  ) mkdir $SOLVE_GVF_DATA/sim/db
#
if ( -f ${SOLVE_SAVE_DATA}/vcat.conf ) then
#
# -- Remove corrupted vcat.conf that was installed by psolve prior to 2023.12.23
#
     if ( `grep GVF_DB_DIR: ${SOLVE_SAVE_DATA}/vcat.conf | tail -1 | wc -w` == 2 ) then
          rm ${SOLVE_SAVE_DATA}/vcat.conf
     endif
endif
#
exit 0
