      SUBROUTINE PARSE_SPE_LISTING ( NBUF, BUF, L_BSP, BSP, IND_SEC, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine PARSE_SPE_LISTING parses listing of solution in SPOOL      *
! *   format generated by Solve. It extracts information related to      *
! *   estimation of site displacements with using expansion with the     *
! *   B-spline basis and puts it in arrays of BSP objects: site name,    *
! *   the B-spline degree, the number of knots, time epochs of each      *
! *   knot, the estimates of coefficients of B-spline, the global site   *
! *   displacement, the global velocity and their covariance matrix.     *
! *                                                                      *
! * _________________________ Input parameters: ________________________ *
! *                                                                      *
! *    NBUF ( INTEGER*4 ) -- The number of lines in the buffer which     *
! *                          keeps the spool file or the portion of      *
! *                          spool-file with relevant information about  *
! *                          estimates of B-spline.                      *
! *     BUF ( CHARACTER ) -- Buffer with contents of the Solve listing   *
! *                          in SPOOL format. Dimenstion: NBUF.          *
! * IND_SEC ( INTEGER*4 ) -- The index of the first line of the buffer   *
! *                          with respect to the beginning of the        *
! *                          listing. If tyhe buffer contains entire     *
! *                          listing IND_SEC should be 1. This parameter *
! *                          is used for formatting errors only.         *
! *                                                                      *
! * ________________________ Modified parameters: ______________________ *
! *                                                                      *
! *   L_BSP ( INTEGER*4 ) -- The number of sites for which site          *
! *                          positions were modeled with expansion with  *
! *                          the B-spline basis.                         *
! *     BSP ( RECORD    ) -- Array of objects which keep information     *
! *                          estimates of B-spline coefficients and      *
! *                          global site position and velocity.          *
! *    IUER ( INTEGER*4, OPT ) -- Universal error handler.               *
! *                           Input: switch IUER=0 -- no error messages  *
! *                                  will be generated even in the case  *
! *                                  of error. IUER=-1 -- in the case of *
! *                                  error the message will be put on    *
! *                                  stdout.                             *
! *                           Output: 0 in the case of successful        *
! *                                   completion and non-zero in the     *
! *                                   case of error.                     *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ## 08-MAR-2005  PARSE_SPE_LISTING  v1.0 (d) L. Petrov 08-MAR-2005 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'solve.i'
      INCLUDE   'bsp.i'
      INTEGER*4  NBUF, IND_SEC, L_BSP, IUER
      CHARACTER  BUF(NBUF)*(*)
      TYPE       ( BSPSTA__TYPE ) :: BSP(L_BSP)
      CHARACTER  STR*32, STR1*32, C_CMP(3)*1
      DATA       C_CMP / 'X', 'Y', 'Z' /
      REAL*8     VAL, TAI
      INTEGER*4  J1, J2, J3, J4, KSPE, IBSP, ICMP, ICMP1, ICMP2, IOS, &
     &           INOD, MJD,  IND_PAR(1-M__SPD:M__SPN,3), PAR_IND1, PAR_IND2, &
     &           IND1, IND2, IND_COV, L_COV, IER
      INTEGER*4, EXTERNAL :: ILEN, I_LEN, IFIND_PL, LTM_DIF
      INTEGER*4  LOCS, I, J
      LOCS(I,J)=min(I,J) +(max(I,J)*(max(I,J)-1))/2
!
      IBSP = 0
      DO 410 J1=1,NBUF
         CALL CLRCH ( STR1 )
         CALL INCH  ( IND_SEC + J1 - 1, STR1 )
         IF ( BUF(J1)(1:5) == 'L_BSP' ) THEN
              READ ( UNIT=BUF(J1)(7:10), FMT='(I4)', IOSTAT=IOS ) KSPE
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1611, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              IF ( KSPE .NE. L_BSP ) THEN
                   CALL ERR_LOG ( 1612, IUER, 'PARSE_SPE_LISTING', 'Trap '// &
     &                 ' of internal control: error in line '// &
     &                 STR1(1:I_LEN(STR1))//' -- '//BUF(J1) )
                   RETURN 
              END IF
           ELSE IF ( BUF(J1)(1:8) == '   I_SPE' ) THEN
              READ ( UNIT=BUF(J1)(10:13), FMT='(I4)', IOSTAT=IOS ) IBSP
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1613, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              IF ( IBSP < 1  .OR.  IBSP > L_BSP ) THEN
                   CALL ERR_LOG ( 1614, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                 ' in parsing line '//STR(1:I_LEN(STR))//' -- '// &
     &                 BUF(J1) )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(22:25), FMT='(I4)', IOSTAT=IOS ) BSP(IBSP)%L_NOD
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1615, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              IF ( BSP(IBSP)%L_NOD < 0  .OR.  BSP(IBSP)%L_NOD > M__SPN ) THEN
                   WRITE ( 6, * ) ' BSP(IBSP)%L_NOD = ', BSP(IBSP)%L_NOD 
                   CALL ERR_LOG ( 1616, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                 ' in parsing line '//STR1(1:I_LEN(STR1))//' -- '// &
     &                 BUF(J1) )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(34:37), FMT='(I4)', IOSTAT=IOS ) BSP(IBSP)%DEGREE
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1615, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              IF ( BSP(IBSP)%DEGREE < 0  .OR.  BSP(IBSP)%DEGREE  > M__SPD ) THEN
                   WRITE ( 6, * ) ' BSP(IBSP)%L_NOD = ', BSP(IBSP)%L_NOD 
                   CALL ERR_LOG ( 1616, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                 ' in parsing line '//STR(1:I_LEN(STR))//' -- '// &
     &                 BUF(J1) )
                   RETURN 
              END IF
!
              BSP(IBSP)%EST_COO = .FALSE.
              BSP(IBSP)%EST_VEL = .FALSE.
              CALL NOUT_R8 ( M__SPD+M__SPN, BSP(IBSP)%TIM )
              CALL NOUT_R8 ( 3*M__SPD+M__SPN, BSP(IBSP)%POS )
              L_COV = (3*(BSP(IBSP)%L_NOD+M__SPD+1)* &
     &                 3*(BSP(IBSP)%L_NOD+M__SPD+2))/2
              ALLOCATE ( BSP(IBSP)%COV(L_COV) )
              CALL NOUT    ( SIZEOF(BSP(IBSP)%COV), BSP(IBSP)%COV )
              CALL NOUT    ( SIZEOF(IND_PAR), IND_PAR )
           ELSE IF ( BUF(J1)(1:7) == '   APS: ' ) THEN
              BSP(IBSP)%STATION = BUF(J1)(9:16)
              ICMP = LTM_DIF ( 0, 3, C_CMP, BUF(J1)(18:18) )
              IF ( ICMP < 1  .OR.  ICMP > 3 ) THEN
                   CALL ERR_LOG ( 1617, IUER, 'PARSE_SPE_LISTING', 'Wrong '// &
     &                 'component code in line '//STR1(1:I_LEN(STR1))// &
     &                 ' -- '//STR )
                   RETURN 
              END IF
!
              DO 420 J2=1,ILEN(BSP(IBSP)%STATION)
                 IF ( BSP(IBSP)%STATION(J2:J2) == ' ' ) BSP(IBSP)%STATION(J2:J2) = '_'
 420          CONTINUE 
!
              CALL ERR_PASS ( IUER, IER )
              CALL DATE_TO_TIME ( BUF(J1)(51:73), MJD, TAI, IER )
              IF ( IER .NE. 0 ) THEN
                   CALL ERR_LOG ( 1618, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                 'in parsing referecne date in line '// &
     &                  STR1(1:I_LEN(STR1))//' -- '//STR )
                   RETURN 
              END IF
!
              BSP(IBSP)%TIM_COO = (MJD - J2000__MJD)*86400.0D0 + (TAI - 43200.0D0)
              READ ( UNIT=BUF(J1)(78:92), FMT='(F15.5)', IOSTAT=IOS ) VAL
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1619, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              BSP(IBSP)%APR_COO(ICMP) = VAL
           ELSE IF ( BUF(J1)(1:7) == '   APV: ' ) THEN
              ICMP = LTM_DIF ( 0, 3, C_CMP, BUF(J1)(18:18) )
              IF ( ICMP < 1  .OR.  ICMP > 3 ) THEN
                   CALL ERR_LOG ( 1620, IUER, 'PARSE_SPE_LISTING', 'Wrong '// &
     &                 'component code in line '//STR1(1:I_LEN(STR1))// &
     &                 ' -- '//STR )
                   RETURN 
              END IF
              READ ( UNIT=BUF(J1)(78:92), FMT='(F15.5)', IOSTAT=IOS ) VAL
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1621, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              BSP(IBSP)%APR_VEL(ICMP) = VAL
           ELSE IF ( BUF(J1)(1:7) == '   EST: ' ) THEN
              ICMP = LTM_DIF ( 0, 3, C_CMP, BUF(J1)(18:18) )
              IF ( ICMP < 1  .OR.  ICMP > 3 ) THEN
                   CALL ERR_LOG ( 1622, IUER, 'PARSE_SPE_LISTING', 'Wrong '// &
     &                 'component code in line '//STR1(1:I_LEN(STR1))// &
     &                 ' -- '//STR )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(42:46), FMT='(I5)', IOSTAT=IOS ) INOD
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1623, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(33:37), FMT='(I5)', IOSTAT=IOS ) IND_PAR(INOD,ICMP)
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1624, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
!
              CALL ERR_PASS ( IUER, IER )
              CALL DATE_TO_TIME ( BUF(J1)(51:73), MJD, TAI, IER )
              IF ( IER .NE. 0 ) THEN
                   CALL ERR_LOG ( 1625, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                 'in parsing node date in line '// &
     &                  STR1(1:I_LEN(STR1))//' -- '//STR )
                   RETURN 
              END IF
              BSP(IBSP)%TIM(INOD) = (MJD - J2000__MJD)*86400.0D0 + (TAI - 43200.0D0)
!
              READ ( UNIT=BUF(J1)(78:92), FMT='(F15.5)', IOSTAT=IOS ) BSP(IBSP)%POS(ICMP,INOD) 
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1626, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line: '//STR1 )
                   RETURN 
              END IF
           ELSE IF ( BUF(J1)(1:7) == '   NOD: ' ) THEN
              READ ( UNIT=BUF(J1)(42:46), FMT='(I5)', IOSTAT=IOS ) INOD
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1627, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line: '//STR1 )
                   RETURN 
              END IF
!
              CALL ERR_PASS ( IUER, IER )
              CALL DATE_TO_TIME ( BUF(J1)(51:73), MJD, TAI, IER )
              IF ( IER .NE. 0 ) THEN
                   CALL ERR_LOG ( 1628, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                 'in parsing node date in line '// &
     &                  STR1(1:I_LEN(STR1))//' -- '//STR )
                   RETURN 
              END IF
              BSP(IBSP)%TIM(INOD) = (MJD - J2000__MJD)*86400.0D0 + (TAI - 43200.0D0)
           ELSE IF ( BUF(J1)(1:7) == '   POS: ' ) THEN
              ICMP = LTM_DIF ( 0, 3, C_CMP, BUF(J1)(18:18) )
              IF ( ICMP < 1  .OR.  ICMP > 3 ) THEN
                   CALL ERR_LOG ( 1629, IUER, 'PARSE_SPE_LISTING', 'Wrong '// &
     &                 'component code in line '//STR1(1:I_LEN(STR1))// &
     &                 ' -- '//STR )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(33:37), FMT='(I5)', IOSTAT=IOS ) &
     &               IND_PAR(BSP(IBSP)%L_NOD,ICMP)
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1630, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line: '//STR1 )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(78:92), FMT='(F15.5)', IOSTAT=IOS ) BSP(IBSP)%ADJ_COO(ICMP)
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1631, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line: '//STR1 )
                   RETURN 
              END IF
              BSP(IBSP)%POS(ICMP,BSP(IBSP)%L_NOD) = BSP(IBSP)%ADJ_COO(ICMP)
              BSP(IBSP)%EST_COO = .TRUE.
           ELSE IF ( BUF(J1)(1:7) == '   VEL: ' ) THEN
              ICMP = LTM_DIF ( 0, 3, C_CMP, BUF(J1)(18:18) )
              IF ( ICMP < 1  .OR.  ICMP > 3 ) THEN
                   CALL ERR_LOG ( 1632, IUER, 'PARSE_SPE_LISTING', 'Wrong '// &
     &                 'component code in line '//STR1(1:I_LEN(STR1))// &
     &                 ' -- '//STR )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(33:37), FMT='(I5)', IOSTAT=IOS ) &
     &               IND_PAR(BSP(IBSP)%L_NOD+1,ICMP)
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1633, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line: '//STR1 )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(78:92), FMT='(F15.5)', IOSTAT=IOS ) BSP(IBSP)%ADJ_VEL(ICMP)
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1634, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line: '//STR1 )
                   RETURN 
              END IF
              BSP(IBSP)%POS(ICMP,BSP(IBSP)%L_NOD+1) = BSP(IBSP)%ADJ_VEL(ICMP)
              BSP(IBSP)%EST_VEL = .TRUE.
           ELSE IF ( BUF(J1)(1:7) == '   COV: ' ) THEN
              READ ( UNIT=BUF(J1)(24:28), FMT='(I5)', IOSTAT=IOS ) PAR_IND1
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1635, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              DO 430 J3=1,3
                 IND1 = IFIND_PL ( BSP(IBSP)%L_NOD+BSP(IBSP)%DEGREE+2, &
     &                             IND_PAR(1-BSP(IBSP)%DEGREE,J3), PAR_IND1 ) - &
     &                             BSP(IBSP)%DEGREE
                 IF ( IND1 > -BSP(IBSP)%DEGREE ) THEN
                      ICMP1 = J3
                      GOTO 830
                 END IF
 430          CONTINUE 
 830          CONTINUE 
!
              IF ( IND1 .LE. -BSP(IBSP)%DEGREE ) THEN
                   write ( 6, * ) ' par_ind1=',par_ind1  ! %%%%%%
                   write ( 6, * ) ' ind_par = ', ind_par ! %%%%%%
                   CALL ERR_LOG ( 1636, IUER, 'PARSE_SPE_LISTING', 'Trap '// &
     &                 'of internal control on line '//STR1 )
                   RETURN 
              END IF
!
              READ ( UNIT=BUF(J1)(36:40), FMT='(I5)', IOSTAT=IOS ) PAR_IND2
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1637, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                   RETURN 
              END IF
              DO 440 J4=1,3
                 IND2 = IFIND_PL ( BSP(IBSP)%L_NOD+BSP(IBSP)%DEGREE+2, &
     &                             IND_PAR(1-BSP(IBSP)%DEGREE,J4), PAR_IND2 ) - &
     &                             BSP(IBSP)%DEGREE
                 IF ( IND2 > -BSP(IBSP)%DEGREE  ) THEN
                      ICMP2 = J4
                      GOTO 840
                 END IF
 440          CONTINUE 
 840          CONTINUE 
!
              IF ( IND2 .LE. -BSP(IBSP)%DEGREE  ) THEN
                   write ( 6, * ) ' BSP(IBSP)%L_NOD  = ', BSP(IBSP)%L_NOD, &
     &                            ' BSP(IBSP)%DEGREE = ', BSP(IBSP)%DEGREE 
                   write ( 6, * ) ' par_ind2=',par_ind2  ! %%%%%%
                   write ( 6, * ) ' ind_par = ', ind_par ! %%%%%%
                   CALL ERR_LOG ( 1638, IUER, 'PARSE_SPE_LISTING', 'Trap '// &
     &                 'of internal control on line '//STR1(1:I_LEN(STR1))// &
     &                 ' in parsing line '//BUF(J1) )
                   RETURN 
              END IF
!
              IND_COV = LOCS( (IND1+M__SPD-1)*3+ICMP1, (IND2+M__SPD-1)*3+ICMP2 )
              READ ( UNIT=BUF(J1)(45:63), FMT='(F19.12)', IOSTAT=IOS ) &
     &               BSP(IBSP)%COV(IND_COV)
              IF ( IOS .NE. 0 ) THEN
                   CALL CLRCH ( STR ) 
                   CALL INCH  ( IOS, STR ) 
                   CALL ERR_LOG ( 1639, IUER, 'PARSE_SPE_LISTING', 'Error '// &
     &                  STR(1:I_LEN(STR))//' in parsing line '//STR1 )
                  RETURN 
              END IF
         END IF
 410  CONTINUE 
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  PARSE_SPE_LISTING 
