#include <mk5_preprocessor_directives.inc>
      SUBROUTINE INVS_10 ( A, EPS, IERR )
! ************************************************************************
! *                                                                      *
! *       Inverts square symmetric matrix in packed upper triangular     *
! *     storage format using Cholesky decomposition.                     *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.11.28  ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), S
      REAL*8     EPS
      INTEGER*4  IERR
!
      IF ( A ( 1 ) .LT. EPS ) THEN
           IERR = 1
           RETURN
      END IF
      A(1) = 1.0D0 / DSQRT ( A(1) )
      S = A(1)
      A( 2  ) = A( 2  ) * S
      A( 4  ) = A( 4  ) * S
      A( 7  ) = A( 7  ) * S
      A( 11  ) = A( 11  ) * S
      A( 16  ) = A( 16  ) * S
      A( 22  ) = A( 22  ) * S
      A( 29  ) = A( 29  ) * S
      A( 37  ) = A( 37  ) * S
      A( 46  ) = A( 46  ) * S
      S = 0.0D0
      S = S + A( 2  ) * A( 2  )
      A( 3  ) = ( A( 3  ) - S )
      IF ( A( 3  ) .LT. EPS ) THEN
           IERR = 2
           RETURN
      END IF
      A( 3  ) = 1.0D0 / DSQRT ( A( 3  ) )
      S = 0.0D0
      S = S + A( 2  ) * A( 4  )
      A( 5  ) = ( A( 5  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 7  )
      A( 8  ) = ( A( 8  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 11  )
      A( 12  ) = ( A( 12  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 16  )
      A( 17  ) = ( A( 17  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 22  )
      A( 23  ) = ( A( 23  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 29  )
      A( 30  ) = ( A( 30  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 37  )
      A( 38  ) = ( A( 38  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 46  )
      A( 47  ) = ( A( 47  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 4  ) * A( 4  )
      S = S + A( 5  ) * A( 5  )
      A( 6  ) = ( A( 6  ) - S )
      IF ( A( 6  ) .LT. EPS ) THEN
           IERR = 3
           RETURN
      END IF
      A( 6  ) = 1.0D0 / DSQRT ( A( 6  ) )
      S = 0.0D0
      S = S + A( 4  ) * A( 7  )
      S = S + A( 5  ) * A( 8  )
      A( 9  ) = ( A( 9  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 11  )
      S = S + A( 5  ) * A( 12  )
      A( 13  ) = ( A( 13  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 16  )
      S = S + A( 5  ) * A( 17  )
      A( 18  ) = ( A( 18  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 22  )
      S = S + A( 5  ) * A( 23  )
      A( 24  ) = ( A( 24  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 29  )
      S = S + A( 5  ) * A( 30  )
      A( 31  ) = ( A( 31  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 37  )
      S = S + A( 5  ) * A( 38  )
      A( 39  ) = ( A( 39  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 46  )
      S = S + A( 5  ) * A( 47  )
      A( 48  ) = ( A( 48  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 7  ) * A( 7  )
      S = S + A( 8  ) * A( 8  )
      S = S + A( 9  ) * A( 9  )
      A( 10  ) = ( A( 10  ) - S )
      IF ( A( 10  ) .LT. EPS ) THEN
           IERR = 4
           RETURN
      END IF
      A( 10  ) = 1.0D0 / DSQRT ( A( 10  ) )
      S = 0.0D0
      S = S + A( 7  ) * A( 11  )
      S = S + A( 8  ) * A( 12  )
      S = S + A( 9  ) * A( 13  )
      A( 14  ) = ( A( 14  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 16  )
      S = S + A( 8  ) * A( 17  )
      S = S + A( 9  ) * A( 18  )
      A( 19  ) = ( A( 19  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 22  )
      S = S + A( 8  ) * A( 23  )
      S = S + A( 9  ) * A( 24  )
      A( 25  ) = ( A( 25  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 29  )
      S = S + A( 8  ) * A( 30  )
      S = S + A( 9  ) * A( 31  )
      A( 32  ) = ( A( 32  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 37  )
      S = S + A( 8  ) * A( 38  )
      S = S + A( 9  ) * A( 39  )
      A( 40  ) = ( A( 40  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 46  )
      S = S + A( 8  ) * A( 47  )
      S = S + A( 9  ) * A( 48  )
      A( 49  ) = ( A( 49  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 11  ) * A( 11  )
      S = S + A( 12  ) * A( 12  )
      S = S + A( 13  ) * A( 13  )
      S = S + A( 14  ) * A( 14  )
      A( 15  ) = ( A( 15  ) - S )
      IF ( A( 15  ) .LT. EPS ) THEN
           IERR = 5
           RETURN
      END IF
      A( 15  ) = 1.0D0 / DSQRT ( A( 15  ) )
      S = 0.0D0
      S = S + A( 11  ) * A( 16  )
      S = S + A( 12  ) * A( 17  )
      S = S + A( 13  ) * A( 18  )
      S = S + A( 14  ) * A( 19  )
      A( 20  ) = ( A( 20  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 22  )
      S = S + A( 12  ) * A( 23  )
      S = S + A( 13  ) * A( 24  )
      S = S + A( 14  ) * A( 25  )
      A( 26  ) = ( A( 26  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 29  )
      S = S + A( 12  ) * A( 30  )
      S = S + A( 13  ) * A( 31  )
      S = S + A( 14  ) * A( 32  )
      A( 33  ) = ( A( 33  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 37  )
      S = S + A( 12  ) * A( 38  )
      S = S + A( 13  ) * A( 39  )
      S = S + A( 14  ) * A( 40  )
      A( 41  ) = ( A( 41  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 46  )
      S = S + A( 12  ) * A( 47  )
      S = S + A( 13  ) * A( 48  )
      S = S + A( 14  ) * A( 49  )
      A( 50  ) = ( A( 50  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 16  ) * A( 16  )
      S = S + A( 17  ) * A( 17  )
      S = S + A( 18  ) * A( 18  )
      S = S + A( 19  ) * A( 19  )
      S = S + A( 20  ) * A( 20  )
      A( 21  ) = ( A( 21  ) - S )
      IF ( A( 21  ) .LT. EPS ) THEN
           IERR = 6
           RETURN
      END IF
      A( 21  ) = 1.0D0 / DSQRT ( A( 21  ) )
      S = 0.0D0
      S = S + A( 16  ) * A( 22  )
      S = S + A( 17  ) * A( 23  )
      S = S + A( 18  ) * A( 24  )
      S = S + A( 19  ) * A( 25  )
      S = S + A( 20  ) * A( 26  )
      A( 27  ) = ( A( 27  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 29  )
      S = S + A( 17  ) * A( 30  )
      S = S + A( 18  ) * A( 31  )
      S = S + A( 19  ) * A( 32  )
      S = S + A( 20  ) * A( 33  )
      A( 34  ) = ( A( 34  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 37  )
      S = S + A( 17  ) * A( 38  )
      S = S + A( 18  ) * A( 39  )
      S = S + A( 19  ) * A( 40  )
      S = S + A( 20  ) * A( 41  )
      A( 42  ) = ( A( 42  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 46  )
      S = S + A( 17  ) * A( 47  )
      S = S + A( 18  ) * A( 48  )
      S = S + A( 19  ) * A( 49  )
      S = S + A( 20  ) * A( 50  )
      A( 51  ) = ( A( 51  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 22  ) * A( 22  )
      S = S + A( 23  ) * A( 23  )
      S = S + A( 24  ) * A( 24  )
      S = S + A( 25  ) * A( 25  )
      S = S + A( 26  ) * A( 26  )
      S = S + A( 27  ) * A( 27  )
      A( 28  ) = ( A( 28  ) - S )
      IF ( A( 28  ) .LT. EPS ) THEN
           IERR = 7
           RETURN
      END IF
      A( 28  ) = 1.0D0 / DSQRT ( A( 28  ) )
      S = 0.0D0
      S = S + A( 22  ) * A( 29  )
      S = S + A( 23  ) * A( 30  )
      S = S + A( 24  ) * A( 31  )
      S = S + A( 25  ) * A( 32  )
      S = S + A( 26  ) * A( 33  )
      S = S + A( 27  ) * A( 34  )
      A( 35  ) = ( A( 35  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 37  )
      S = S + A( 23  ) * A( 38  )
      S = S + A( 24  ) * A( 39  )
      S = S + A( 25  ) * A( 40  )
      S = S + A( 26  ) * A( 41  )
      S = S + A( 27  ) * A( 42  )
      A( 43  ) = ( A( 43  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 46  )
      S = S + A( 23  ) * A( 47  )
      S = S + A( 24  ) * A( 48  )
      S = S + A( 25  ) * A( 49  )
      S = S + A( 26  ) * A( 50  )
      S = S + A( 27  ) * A( 51  )
      A( 52  ) = ( A( 52  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 29  ) * A( 29  )
      S = S + A( 30  ) * A( 30  )
      S = S + A( 31  ) * A( 31  )
      S = S + A( 32  ) * A( 32  )
      S = S + A( 33  ) * A( 33  )
      S = S + A( 34  ) * A( 34  )
      S = S + A( 35  ) * A( 35  )
      A( 36  ) = ( A( 36  ) - S )
      IF ( A( 36  ) .LT. EPS ) THEN
           IERR = 8
           RETURN
      END IF
      A( 36  ) = 1.0D0 / DSQRT ( A( 36  ) )
      S = 0.0D0
      S = S + A( 29  ) * A( 37  )
      S = S + A( 30  ) * A( 38  )
      S = S + A( 31  ) * A( 39  )
      S = S + A( 32  ) * A( 40  )
      S = S + A( 33  ) * A( 41  )
      S = S + A( 34  ) * A( 42  )
      S = S + A( 35  ) * A( 43  )
      A( 44  ) = ( A( 44  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 29  ) * A( 46  )
      S = S + A( 30  ) * A( 47  )
      S = S + A( 31  ) * A( 48  )
      S = S + A( 32  ) * A( 49  )
      S = S + A( 33  ) * A( 50  )
      S = S + A( 34  ) * A( 51  )
      S = S + A( 35  ) * A( 52  )
      A( 53  ) = ( A( 53  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 37  ) * A( 37  )
      S = S + A( 38  ) * A( 38  )
      S = S + A( 39  ) * A( 39  )
      S = S + A( 40  ) * A( 40  )
      S = S + A( 41  ) * A( 41  )
      S = S + A( 42  ) * A( 42  )
      S = S + A( 43  ) * A( 43  )
      S = S + A( 44  ) * A( 44  )
      A( 45  ) = ( A( 45  ) - S )
      IF ( A( 45  ) .LT. EPS ) THEN
           IERR = 9
           RETURN
      END IF
      A( 45  ) = 1.0D0 / DSQRT ( A( 45  ) )
      S = 0.0D0
      S = S + A( 37  ) * A( 46  )
      S = S + A( 38  ) * A( 47  )
      S = S + A( 39  ) * A( 48  )
      S = S + A( 40  ) * A( 49  )
      S = S + A( 41  ) * A( 50  )
      S = S + A( 42  ) * A( 51  )
      S = S + A( 43  ) * A( 52  )
      S = S + A( 44  ) * A( 53  )
      A( 54  ) = ( A( 54  ) - S ) * A( 45  )
      S = 0.0D0
      S = S + A( 46  ) * A( 46  )
      S = S + A( 47  ) * A( 47  )
      S = S + A( 48  ) * A( 48  )
      S = S + A( 49  ) * A( 49  )
      S = S + A( 50  ) * A( 50  )
      S = S + A( 51  ) * A( 51  )
      S = S + A( 52  ) * A( 52  )
      S = S + A( 53  ) * A( 53  )
      S = S + A( 54  ) * A( 54  )
      A( 55  ) = ( A( 55  ) - S )
      IF ( A( 55  ) .LT. EPS ) THEN
           IERR = 10
           RETURN
      END IF
      A( 55  ) = 1.0D0 / DSQRT ( A( 55  ) )
      S = 0.0D0
      S = S - A( 1  ) * A( 2  )
      A( 2 ) = S * A( 3  )
      S = 0.0D0
      S = S - A( 1  ) * A( 4  )
      S = S - A( 2  ) * A( 5  )
      A( 4 ) = S * A( 6  )
      S = 0.0D0
      S = S - A( 1  ) * A( 7  )
      S = S - A( 2  ) * A( 8  )
      S = S - A( 4  ) * A( 9  )
      A( 7 ) = S * A( 10  )
      S = 0.0D0
      S = S - A( 1  ) * A( 11  )
      S = S - A( 2  ) * A( 12  )
      S = S - A( 4  ) * A( 13  )
      S = S - A( 7  ) * A( 14  )
      A( 11 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 1  ) * A( 16  )
      S = S - A( 2  ) * A( 17  )
      S = S - A( 4  ) * A( 18  )
      S = S - A( 7  ) * A( 19  )
      S = S - A( 11  ) * A( 20  )
      A( 16 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 1  ) * A( 22  )
      S = S - A( 2  ) * A( 23  )
      S = S - A( 4  ) * A( 24  )
      S = S - A( 7  ) * A( 25  )
      S = S - A( 11  ) * A( 26  )
      S = S - A( 16  ) * A( 27  )
      A( 22 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 1  ) * A( 29  )
      S = S - A( 2  ) * A( 30  )
      S = S - A( 4  ) * A( 31  )
      S = S - A( 7  ) * A( 32  )
      S = S - A( 11  ) * A( 33  )
      S = S - A( 16  ) * A( 34  )
      S = S - A( 22  ) * A( 35  )
      A( 29 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 1  ) * A( 37  )
      S = S - A( 2  ) * A( 38  )
      S = S - A( 4  ) * A( 39  )
      S = S - A( 7  ) * A( 40  )
      S = S - A( 11  ) * A( 41  )
      S = S - A( 16  ) * A( 42  )
      S = S - A( 22  ) * A( 43  )
      S = S - A( 29  ) * A( 44  )
      A( 37 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 1  ) * A( 46  )
      S = S - A( 2  ) * A( 47  )
      S = S - A( 4  ) * A( 48  )
      S = S - A( 7  ) * A( 49  )
      S = S - A( 11  ) * A( 50  )
      S = S - A( 16  ) * A( 51  )
      S = S - A( 22  ) * A( 52  )
      S = S - A( 29  ) * A( 53  )
      S = S - A( 37  ) * A( 54  )
      A( 46 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 3  ) * A( 5  )
      A( 5 ) = S * A( 6  )
      S = 0.0D0
      S = S - A( 3  ) * A( 8  )
      S = S - A( 5  ) * A( 9  )
      A( 8 ) = S * A( 10  )
      S = 0.0D0
      S = S - A( 3  ) * A( 12  )
      S = S - A( 5  ) * A( 13  )
      S = S - A( 8  ) * A( 14  )
      A( 12 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 3  ) * A( 17  )
      S = S - A( 5  ) * A( 18  )
      S = S - A( 8  ) * A( 19  )
      S = S - A( 12  ) * A( 20  )
      A( 17 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 3  ) * A( 23  )
      S = S - A( 5  ) * A( 24  )
      S = S - A( 8  ) * A( 25  )
      S = S - A( 12  ) * A( 26  )
      S = S - A( 17  ) * A( 27  )
      A( 23 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 3  ) * A( 30  )
      S = S - A( 5  ) * A( 31  )
      S = S - A( 8  ) * A( 32  )
      S = S - A( 12  ) * A( 33  )
      S = S - A( 17  ) * A( 34  )
      S = S - A( 23  ) * A( 35  )
      A( 30 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 3  ) * A( 38  )
      S = S - A( 5  ) * A( 39  )
      S = S - A( 8  ) * A( 40  )
      S = S - A( 12  ) * A( 41  )
      S = S - A( 17  ) * A( 42  )
      S = S - A( 23  ) * A( 43  )
      S = S - A( 30  ) * A( 44  )
      A( 38 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 3  ) * A( 47  )
      S = S - A( 5  ) * A( 48  )
      S = S - A( 8  ) * A( 49  )
      S = S - A( 12  ) * A( 50  )
      S = S - A( 17  ) * A( 51  )
      S = S - A( 23  ) * A( 52  )
      S = S - A( 30  ) * A( 53  )
      S = S - A( 38  ) * A( 54  )
      A( 47 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 6  ) * A( 9  )
      A( 9 ) = S * A( 10  )
      S = 0.0D0
      S = S - A( 6  ) * A( 13  )
      S = S - A( 9  ) * A( 14  )
      A( 13 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 6  ) * A( 18  )
      S = S - A( 9  ) * A( 19  )
      S = S - A( 13  ) * A( 20  )
      A( 18 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 6  ) * A( 24  )
      S = S - A( 9  ) * A( 25  )
      S = S - A( 13  ) * A( 26  )
      S = S - A( 18  ) * A( 27  )
      A( 24 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 6  ) * A( 31  )
      S = S - A( 9  ) * A( 32  )
      S = S - A( 13  ) * A( 33  )
      S = S - A( 18  ) * A( 34  )
      S = S - A( 24  ) * A( 35  )
      A( 31 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 6  ) * A( 39  )
      S = S - A( 9  ) * A( 40  )
      S = S - A( 13  ) * A( 41  )
      S = S - A( 18  ) * A( 42  )
      S = S - A( 24  ) * A( 43  )
      S = S - A( 31  ) * A( 44  )
      A( 39 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 6  ) * A( 48  )
      S = S - A( 9  ) * A( 49  )
      S = S - A( 13  ) * A( 50  )
      S = S - A( 18  ) * A( 51  )
      S = S - A( 24  ) * A( 52  )
      S = S - A( 31  ) * A( 53  )
      S = S - A( 39  ) * A( 54  )
      A( 48 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 10  ) * A( 14  )
      A( 14 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 10  ) * A( 19  )
      S = S - A( 14  ) * A( 20  )
      A( 19 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 10  ) * A( 25  )
      S = S - A( 14  ) * A( 26  )
      S = S - A( 19  ) * A( 27  )
      A( 25 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 10  ) * A( 32  )
      S = S - A( 14  ) * A( 33  )
      S = S - A( 19  ) * A( 34  )
      S = S - A( 25  ) * A( 35  )
      A( 32 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 10  ) * A( 40  )
      S = S - A( 14  ) * A( 41  )
      S = S - A( 19  ) * A( 42  )
      S = S - A( 25  ) * A( 43  )
      S = S - A( 32  ) * A( 44  )
      A( 40 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 10  ) * A( 49  )
      S = S - A( 14  ) * A( 50  )
      S = S - A( 19  ) * A( 51  )
      S = S - A( 25  ) * A( 52  )
      S = S - A( 32  ) * A( 53  )
      S = S - A( 40  ) * A( 54  )
      A( 49 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 15  ) * A( 20  )
      A( 20 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 15  ) * A( 26  )
      S = S - A( 20  ) * A( 27  )
      A( 26 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 15  ) * A( 33  )
      S = S - A( 20  ) * A( 34  )
      S = S - A( 26  ) * A( 35  )
      A( 33 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 15  ) * A( 41  )
      S = S - A( 20  ) * A( 42  )
      S = S - A( 26  ) * A( 43  )
      S = S - A( 33  ) * A( 44  )
      A( 41 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 15  ) * A( 50  )
      S = S - A( 20  ) * A( 51  )
      S = S - A( 26  ) * A( 52  )
      S = S - A( 33  ) * A( 53  )
      S = S - A( 41  ) * A( 54  )
      A( 50 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 21  ) * A( 27  )
      A( 27 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 21  ) * A( 34  )
      S = S - A( 27  ) * A( 35  )
      A( 34 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 21  ) * A( 42  )
      S = S - A( 27  ) * A( 43  )
      S = S - A( 34  ) * A( 44  )
      A( 42 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 21  ) * A( 51  )
      S = S - A( 27  ) * A( 52  )
      S = S - A( 34  ) * A( 53  )
      S = S - A( 42  ) * A( 54  )
      A( 51 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 28  ) * A( 35  )
      A( 35 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 28  ) * A( 43  )
      S = S - A( 35  ) * A( 44  )
      A( 43 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 28  ) * A( 52  )
      S = S - A( 35  ) * A( 53  )
      S = S - A( 43  ) * A( 54  )
      A( 52 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 36  ) * A( 44  )
      A( 44 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 36  ) * A( 53  )
      S = S - A( 44  ) * A( 54  )
      A( 53 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 45  ) * A( 54  )
      A( 54 ) = S * A( 55  )
      S = 0.0D0
      S = S + A( 1  ) * A( 1  )
      S = S + A( 2  ) * A( 2  )
      S = S + A( 4  ) * A( 4  )
      S = S + A( 7  ) * A( 7  )
      S = S + A( 11  ) * A( 11  )
      S = S + A( 16  ) * A( 16  )
      S = S + A( 22  ) * A( 22  )
      S = S + A( 29  ) * A( 29  )
      S = S + A( 37  ) * A( 37  )
      S = S + A( 46  ) * A( 46  )
      A( 1  ) = S
      S = 0.0D0
      S = S + A( 2  ) * A( 3  )
      S = S + A( 4  ) * A( 5  )
      S = S + A( 7  ) * A( 8  )
      S = S + A( 11  ) * A( 12  )
      S = S + A( 16  ) * A( 17  )
      S = S + A( 22  ) * A( 23  )
      S = S + A( 29  ) * A( 30  )
      S = S + A( 37  ) * A( 38  )
      S = S + A( 46  ) * A( 47  )
      A( 2  ) = S
      S = 0.0D0
      S = S + A( 4  ) * A( 6  )
      S = S + A( 7  ) * A( 9  )
      S = S + A( 11  ) * A( 13  )
      S = S + A( 16  ) * A( 18  )
      S = S + A( 22  ) * A( 24  )
      S = S + A( 29  ) * A( 31  )
      S = S + A( 37  ) * A( 39  )
      S = S + A( 46  ) * A( 48  )
      A( 4  ) = S
      S = 0.0D0
      S = S + A( 7  ) * A( 10  )
      S = S + A( 11  ) * A( 14  )
      S = S + A( 16  ) * A( 19  )
      S = S + A( 22  ) * A( 25  )
      S = S + A( 29  ) * A( 32  )
      S = S + A( 37  ) * A( 40  )
      S = S + A( 46  ) * A( 49  )
      A( 7  ) = S
      S = 0.0D0
      S = S + A( 11  ) * A( 15  )
      S = S + A( 16  ) * A( 20  )
      S = S + A( 22  ) * A( 26  )
      S = S + A( 29  ) * A( 33  )
      S = S + A( 37  ) * A( 41  )
      S = S + A( 46  ) * A( 50  )
      A( 11  ) = S
      S = 0.0D0
      S = S + A( 16  ) * A( 21  )
      S = S + A( 22  ) * A( 27  )
      S = S + A( 29  ) * A( 34  )
      S = S + A( 37  ) * A( 42  )
      S = S + A( 46  ) * A( 51  )
      A( 16  ) = S
      S = 0.0D0
      S = S + A( 22  ) * A( 28  )
      S = S + A( 29  ) * A( 35  )
      S = S + A( 37  ) * A( 43  )
      S = S + A( 46  ) * A( 52  )
      A( 22  ) = S
      S = 0.0D0
      S = S + A( 29  ) * A( 36  )
      S = S + A( 37  ) * A( 44  )
      S = S + A( 46  ) * A( 53  )
      A( 29  ) = S
      S = 0.0D0
      S = S + A( 37  ) * A( 45  )
      S = S + A( 46  ) * A( 54  )
      A( 37  ) = S
      S = 0.0D0
      S = S + A( 46  ) * A( 55  )
      A( 46  ) = S
      S = 0.0D0
      S = S + A( 3  ) * A( 3  )
      S = S + A( 5  ) * A( 5  )
      S = S + A( 8  ) * A( 8  )
      S = S + A( 12  ) * A( 12  )
      S = S + A( 17  ) * A( 17  )
      S = S + A( 23  ) * A( 23  )
      S = S + A( 30  ) * A( 30  )
      S = S + A( 38  ) * A( 38  )
      S = S + A( 47  ) * A( 47  )
      A( 3  ) = S
      S = 0.0D0
      S = S + A( 5  ) * A( 6  )
      S = S + A( 8  ) * A( 9  )
      S = S + A( 12  ) * A( 13  )
      S = S + A( 17  ) * A( 18  )
      S = S + A( 23  ) * A( 24  )
      S = S + A( 30  ) * A( 31  )
      S = S + A( 38  ) * A( 39  )
      S = S + A( 47  ) * A( 48  )
      A( 5  ) = S
      S = 0.0D0
      S = S + A( 8  ) * A( 10  )
      S = S + A( 12  ) * A( 14  )
      S = S + A( 17  ) * A( 19  )
      S = S + A( 23  ) * A( 25  )
      S = S + A( 30  ) * A( 32  )
      S = S + A( 38  ) * A( 40  )
      S = S + A( 47  ) * A( 49  )
      A( 8  ) = S
      S = 0.0D0
      S = S + A( 12  ) * A( 15  )
      S = S + A( 17  ) * A( 20  )
      S = S + A( 23  ) * A( 26  )
      S = S + A( 30  ) * A( 33  )
      S = S + A( 38  ) * A( 41  )
      S = S + A( 47  ) * A( 50  )
      A( 12  ) = S
      S = 0.0D0
      S = S + A( 17  ) * A( 21  )
      S = S + A( 23  ) * A( 27  )
      S = S + A( 30  ) * A( 34  )
      S = S + A( 38  ) * A( 42  )
      S = S + A( 47  ) * A( 51  )
      A( 17  ) = S
      S = 0.0D0
      S = S + A( 23  ) * A( 28  )
      S = S + A( 30  ) * A( 35  )
      S = S + A( 38  ) * A( 43  )
      S = S + A( 47  ) * A( 52  )
      A( 23  ) = S
      S = 0.0D0
      S = S + A( 30  ) * A( 36  )
      S = S + A( 38  ) * A( 44  )
      S = S + A( 47  ) * A( 53  )
      A( 30  ) = S
      S = 0.0D0
      S = S + A( 38  ) * A( 45  )
      S = S + A( 47  ) * A( 54  )
      A( 38  ) = S
      S = 0.0D0
      S = S + A( 47  ) * A( 55  )
      A( 47  ) = S
      S = 0.0D0
      S = S + A( 6  ) * A( 6  )
      S = S + A( 9  ) * A( 9  )
      S = S + A( 13  ) * A( 13  )
      S = S + A( 18  ) * A( 18  )
      S = S + A( 24  ) * A( 24  )
      S = S + A( 31  ) * A( 31  )
      S = S + A( 39  ) * A( 39  )
      S = S + A( 48  ) * A( 48  )
      A( 6  ) = S
      S = 0.0D0
      S = S + A( 9  ) * A( 10  )
      S = S + A( 13  ) * A( 14  )
      S = S + A( 18  ) * A( 19  )
      S = S + A( 24  ) * A( 25  )
      S = S + A( 31  ) * A( 32  )
      S = S + A( 39  ) * A( 40  )
      S = S + A( 48  ) * A( 49  )
      A( 9  ) = S
      S = 0.0D0
      S = S + A( 13  ) * A( 15  )
      S = S + A( 18  ) * A( 20  )
      S = S + A( 24  ) * A( 26  )
      S = S + A( 31  ) * A( 33  )
      S = S + A( 39  ) * A( 41  )
      S = S + A( 48  ) * A( 50  )
      A( 13  ) = S
      S = 0.0D0
      S = S + A( 18  ) * A( 21  )
      S = S + A( 24  ) * A( 27  )
      S = S + A( 31  ) * A( 34  )
      S = S + A( 39  ) * A( 42  )
      S = S + A( 48  ) * A( 51  )
      A( 18  ) = S
      S = 0.0D0
      S = S + A( 24  ) * A( 28  )
      S = S + A( 31  ) * A( 35  )
      S = S + A( 39  ) * A( 43  )
      S = S + A( 48  ) * A( 52  )
      A( 24  ) = S
      S = 0.0D0
      S = S + A( 31  ) * A( 36  )
      S = S + A( 39  ) * A( 44  )
      S = S + A( 48  ) * A( 53  )
      A( 31  ) = S
      S = 0.0D0
      S = S + A( 39  ) * A( 45  )
      S = S + A( 48  ) * A( 54  )
      A( 39  ) = S
      S = 0.0D0
      S = S + A( 48  ) * A( 55  )
      A( 48  ) = S
      S = 0.0D0
      S = S + A( 10  ) * A( 10  )
      S = S + A( 14  ) * A( 14  )
      S = S + A( 19  ) * A( 19  )
      S = S + A( 25  ) * A( 25  )
      S = S + A( 32  ) * A( 32  )
      S = S + A( 40  ) * A( 40  )
      S = S + A( 49  ) * A( 49  )
      A( 10  ) = S
      S = 0.0D0
      S = S + A( 14  ) * A( 15  )
      S = S + A( 19  ) * A( 20  )
      S = S + A( 25  ) * A( 26  )
      S = S + A( 32  ) * A( 33  )
      S = S + A( 40  ) * A( 41  )
      S = S + A( 49  ) * A( 50  )
      A( 14  ) = S
      S = 0.0D0
      S = S + A( 19  ) * A( 21  )
      S = S + A( 25  ) * A( 27  )
      S = S + A( 32  ) * A( 34  )
      S = S + A( 40  ) * A( 42  )
      S = S + A( 49  ) * A( 51  )
      A( 19  ) = S
      S = 0.0D0
      S = S + A( 25  ) * A( 28  )
      S = S + A( 32  ) * A( 35  )
      S = S + A( 40  ) * A( 43  )
      S = S + A( 49  ) * A( 52  )
      A( 25  ) = S
      S = 0.0D0
      S = S + A( 32  ) * A( 36  )
      S = S + A( 40  ) * A( 44  )
      S = S + A( 49  ) * A( 53  )
      A( 32  ) = S
      S = 0.0D0
      S = S + A( 40  ) * A( 45  )
      S = S + A( 49  ) * A( 54  )
      A( 40  ) = S
      S = 0.0D0
      S = S + A( 49  ) * A( 55  )
      A( 49  ) = S
      S = 0.0D0
      S = S + A( 15  ) * A( 15  )
      S = S + A( 20  ) * A( 20  )
      S = S + A( 26  ) * A( 26  )
      S = S + A( 33  ) * A( 33  )
      S = S + A( 41  ) * A( 41  )
      S = S + A( 50  ) * A( 50  )
      A( 15  ) = S
      S = 0.0D0
      S = S + A( 20  ) * A( 21  )
      S = S + A( 26  ) * A( 27  )
      S = S + A( 33  ) * A( 34  )
      S = S + A( 41  ) * A( 42  )
      S = S + A( 50  ) * A( 51  )
      A( 20  ) = S
      S = 0.0D0
      S = S + A( 26  ) * A( 28  )
      S = S + A( 33  ) * A( 35  )
      S = S + A( 41  ) * A( 43  )
      S = S + A( 50  ) * A( 52  )
      A( 26  ) = S
      S = 0.0D0
      S = S + A( 33  ) * A( 36  )
      S = S + A( 41  ) * A( 44  )
      S = S + A( 50  ) * A( 53  )
      A( 33  ) = S
      S = 0.0D0
      S = S + A( 41  ) * A( 45  )
      S = S + A( 50  ) * A( 54  )
      A( 41  ) = S
      S = 0.0D0
      S = S + A( 50  ) * A( 55  )
      A( 50  ) = S
      S = 0.0D0
      S = S + A( 21  ) * A( 21  )
      S = S + A( 27  ) * A( 27  )
      S = S + A( 34  ) * A( 34  )
      S = S + A( 42  ) * A( 42  )
      S = S + A( 51  ) * A( 51  )
      A( 21  ) = S
      S = 0.0D0
      S = S + A( 27  ) * A( 28  )
      S = S + A( 34  ) * A( 35  )
      S = S + A( 42  ) * A( 43  )
      S = S + A( 51  ) * A( 52  )
      A( 27  ) = S
      S = 0.0D0
      S = S + A( 34  ) * A( 36  )
      S = S + A( 42  ) * A( 44  )
      S = S + A( 51  ) * A( 53  )
      A( 34  ) = S
      S = 0.0D0
      S = S + A( 42  ) * A( 45  )
      S = S + A( 51  ) * A( 54  )
      A( 42  ) = S
      S = 0.0D0
      S = S + A( 51  ) * A( 55  )
      A( 51  ) = S
      S = 0.0D0
      S = S + A( 28  ) * A( 28  )
      S = S + A( 35  ) * A( 35  )
      S = S + A( 43  ) * A( 43  )
      S = S + A( 52  ) * A( 52  )
      A( 28  ) = S
      S = 0.0D0
      S = S + A( 35  ) * A( 36  )
      S = S + A( 43  ) * A( 44  )
      S = S + A( 52  ) * A( 53  )
      A( 35  ) = S
      S = 0.0D0
      S = S + A( 43  ) * A( 45  )
      S = S + A( 52  ) * A( 54  )
      A( 43  ) = S
      S = 0.0D0
      S = S + A( 52  ) * A( 55  )
      A( 52  ) = S
      S = 0.0D0
      S = S + A( 36  ) * A( 36  )
      S = S + A( 44  ) * A( 44  )
      S = S + A( 53  ) * A( 53  )
      A( 36  ) = S
      S = 0.0D0
      S = S + A( 44  ) * A( 45  )
      S = S + A( 53  ) * A( 54  )
      A( 44  ) = S
      S = 0.0D0
      S = S + A( 53  ) * A( 55  )
      A( 53  ) = S
      S = 0.0D0
      S = S + A( 45  ) * A( 45  )
      S = S + A( 54  ) * A( 54  )
      A( 45  ) = S
      S = 0.0D0
      S = S + A( 54  ) * A( 55  )
      A( 54  ) = S
      S = 0.0D0
      S = S + A( 55  ) * A( 55  )
      A( 55  ) = S
!
      IERR = 0
      RETURN
      END  !#!  INVS_10  #!#
