#include <mk5_preprocessor_directives.inc>
      SUBROUTINE MUL_MM_SS_S_5  ( A, B, C )
! ************************************************************************
! *                                                                      *
! *   Compute a product of two square symmetric matrices in upper        *
! *   triangular representation.                                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.12.14 ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), B(*), C(*)
!
      C( 1 ) = A( 1 ) * B( 1 )
      C( 1 ) = C( 1 ) + A( 2 ) * B( 2 )
      C( 1 ) = C( 1 ) + A( 4 ) * B( 4 )
      C( 1 ) = C( 1 ) + A( 7 ) * B( 7 )
      C( 1 ) = C( 1 ) + A( 11 ) * B( 11 )
!
      C( 2 ) = A( 2 ) * B( 1 )
      C( 2 ) = C( 2 ) + A( 3 ) * B( 2 )
      C( 2 ) = C( 2 ) + A( 5 ) * B( 4 )
      C( 2 ) = C( 2 ) + A( 8 ) * B( 7 )
      C( 2 ) = C( 2 ) + A( 12 ) * B( 11 )
!
      C( 3 ) = A( 2 ) * B( 2 )
      C( 3 ) = C( 3 ) + A( 3 ) * B( 3 )
      C( 3 ) = C( 3 ) + A( 5 ) * B( 5 )
      C( 3 ) = C( 3 ) + A( 8 ) * B( 8 )
      C( 3 ) = C( 3 ) + A( 12 ) * B( 12 )
!
      C( 4 ) = A( 4 ) * B( 1 )
      C( 4 ) = C( 4 ) + A( 5 ) * B( 2 )
      C( 4 ) = C( 4 ) + A( 6 ) * B( 4 )
      C( 4 ) = C( 4 ) + A( 9 ) * B( 7 )
      C( 4 ) = C( 4 ) + A( 13 ) * B( 11 )
!
      C( 5 ) = A( 4 ) * B( 2 )
      C( 5 ) = C( 5 ) + A( 5 ) * B( 3 )
      C( 5 ) = C( 5 ) + A( 6 ) * B( 5 )
      C( 5 ) = C( 5 ) + A( 9 ) * B( 8 )
      C( 5 ) = C( 5 ) + A( 13 ) * B( 12 )
!
      C( 6 ) = A( 4 ) * B( 4 )
      C( 6 ) = C( 6 ) + A( 5 ) * B( 5 )
      C( 6 ) = C( 6 ) + A( 6 ) * B( 6 )
      C( 6 ) = C( 6 ) + A( 9 ) * B( 9 )
      C( 6 ) = C( 6 ) + A( 13 ) * B( 13 )
!
      C( 7 ) = A( 7 ) * B( 1 )
      C( 7 ) = C( 7 ) + A( 8 ) * B( 2 )
      C( 7 ) = C( 7 ) + A( 9 ) * B( 4 )
      C( 7 ) = C( 7 ) + A( 10 ) * B( 7 )
      C( 7 ) = C( 7 ) + A( 14 ) * B( 11 )
!
      C( 8 ) = A( 7 ) * B( 2 )
      C( 8 ) = C( 8 ) + A( 8 ) * B( 3 )
      C( 8 ) = C( 8 ) + A( 9 ) * B( 5 )
      C( 8 ) = C( 8 ) + A( 10 ) * B( 8 )
      C( 8 ) = C( 8 ) + A( 14 ) * B( 12 )
!
      C( 9 ) = A( 7 ) * B( 4 )
      C( 9 ) = C( 9 ) + A( 8 ) * B( 5 )
      C( 9 ) = C( 9 ) + A( 9 ) * B( 6 )
      C( 9 ) = C( 9 ) + A( 10 ) * B( 9 )
      C( 9 ) = C( 9 ) + A( 14 ) * B( 13 )
!
      C( 10 ) = A( 7 ) * B( 7 )
      C( 10 ) = C( 10 ) + A( 8 ) * B( 8 )
      C( 10 ) = C( 10 ) + A( 9 ) * B( 9 )
      C( 10 ) = C( 10 ) + A( 10 ) * B( 10 )
      C( 10 ) = C( 10 ) + A( 14 ) * B( 14 )
!
      C( 11 ) = A( 11 ) * B( 1 )
      C( 11 ) = C( 11 ) + A( 12 ) * B( 2 )
      C( 11 ) = C( 11 ) + A( 13 ) * B( 4 )
      C( 11 ) = C( 11 ) + A( 14 ) * B( 7 )
      C( 11 ) = C( 11 ) + A( 15 ) * B( 11 )
!
      C( 12 ) = A( 11 ) * B( 2 )
      C( 12 ) = C( 12 ) + A( 12 ) * B( 3 )
      C( 12 ) = C( 12 ) + A( 13 ) * B( 5 )
      C( 12 ) = C( 12 ) + A( 14 ) * B( 8 )
      C( 12 ) = C( 12 ) + A( 15 ) * B( 12 )
!
      C( 13 ) = A( 11 ) * B( 4 )
      C( 13 ) = C( 13 ) + A( 12 ) * B( 5 )
      C( 13 ) = C( 13 ) + A( 13 ) * B( 6 )
      C( 13 ) = C( 13 ) + A( 14 ) * B( 9 )
      C( 13 ) = C( 13 ) + A( 15 ) * B( 13 )
!
      C( 14 ) = A( 11 ) * B( 7 )
      C( 14 ) = C( 14 ) + A( 12 ) * B( 8 )
      C( 14 ) = C( 14 ) + A( 13 ) * B( 9 )
      C( 14 ) = C( 14 ) + A( 14 ) * B( 10 )
      C( 14 ) = C( 14 ) + A( 15 ) * B( 14 )
!
      C( 15 ) = A( 11 ) * B( 11 )
      C( 15 ) = C( 15 ) + A( 12 ) * B( 12 )
      C( 15 ) = C( 15 ) + A( 13 ) * B( 13 )
      C( 15 ) = C( 15 ) + A( 14 ) * B( 14 )
      C( 15 ) = C( 15 ) + A( 15 ) * B( 15 )
!
!
      RETURN
      END !#! SUBROUTINE MUL_MM_SS_S_5 
