!
! --- This file was generated automatically by nut_out v4.2  2003.12.27
! --- written by Leonid Petrov ( Leonid.Petrov@lpetrov.net )
! --- File was created at 2003.12.27-18:17:06
! --- It contains nutation expansion of the model REN2000 + MHB2000 transfer funcion + add-on terms
! --- Phases, frequencies, accelerations of the arguments as well as amplitudes
! --- of cos and sin components of nutation in longitude and in obliquity
! --- are transformed to the form suitable for computations.
! --- Nutation is considered as a a harmonic variations in polar motion
! --- Convention: angles of a small rotation are computed as :
! ---             E1 = sum_i {  PMC_i*cos(ARG_i) + PMS_i*sin(ARG_i) }
! ---             E2 = sum_i { -PMC_i*sin(ARG_i) + PMS_i*cos(ARG_i) }
! ---             E3 = 0
! --- Units are picoradians for amplitudes  and  1.0D-24 rad/sec for their rates
! --- Truncation limit for amplitudes:   0.2000 prad
! --- in total 2302 constituents are presented
! --- The expansion has frequencies only in the range [ -9.200D-05, -5.100D-05 ] rad/sec
! --- The expansion is based on REN2000 with MHB transfer function applied
! --- using the resonance formula with corrections applied
! --- This expansion does not contains terms with geodesic nutation
! --- Epsilon_o =  0.4090928041 rad
! --- OM_preces = -7.08618327D-12 rad/sec
!
      INTEGER*4   N_NUT, I_NUT
      PARAMETER ( N_NUT = 2302 )
      INTEGER*4  IND_NUT(N_NUT)
      CHARACTER  TYP_NUT(N_NUT)*1, MODEL_NUT*40
      REAL*8     PHAS_NUT(N_NUT), FREQ_NUT(N_NUT), ACCL_NUT(N_NUT)
      REAL*8     PMC_NUT(N_NUT),      PMS_NUT(N_NUT)
      REAL*8     PMC_RATE_NUT(N_NUT), PMS_RATE_NUT(N_NUT)
      REAL*8     EPSILON_0_NUT
      PARAMETER  ( EPSILON_0_NUT = 0.4090928041D0 ) ! rad
      PARAMETER  ( MODEL_NUT = 'REN2000 + MHB2000 transfer funcion + add' )
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1,10 ) &
     & /                        &
     & 2.2308903847D0, -9.109808070378D-05, -6.3156D-23, 1358, 'R', & !    1
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0484511847D0, -9.108738374171D-05, -7.0431D-23, 1357, 'R', & !    2
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8282540059D0, -9.074487622679D-05,  1.1327D-23, 1354, 'R', & !    3
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6458148059D0, -9.073417926473D-05,  4.0515D-24, 1353, 'R', & !    4
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2431784271D0, -9.038097478775D-05,  7.8534D-23, 1349, 'R', & !    5
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9890826615D0, -8.881208212763D-05, -1.0660D-22, 1346, 'R', & !    6
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8066434615D0, -8.880138516556D-05, -1.1388D-22, 1345, 'R', & !    7
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4857001755D0, -8.846957461271D-05, -2.4842D-23, 1339, 'R', & !    8
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5864462827D0, -8.845887765064D-05, -3.2117D-23, 1338, 'R', & !    9
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4040070827D0, -8.844818068858D-05, -3.9393D-23, 1337, 'R', & !   10
     &          6.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  11,  20 ) &
     & /                             &
     & 5.3135841547D0, -8.840317239506D-05, -1.1175D-22, 1336, 'R', & !   11
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3608819055D0, -8.824908381334D-05, -3.9931D-23, 1332, 'R', & !   12
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0830637967D0, -8.811637013572D-05,  4.9641D-23, 1331, 'R', & !   13
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1838099039D0, -8.810567317366D-05,  4.2365D-23, 1330, 'R', & !   14
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0013707039D0, -8.809497621160D-05,  3.5090D-23, 1329, 'R', & !   15
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9109477759D0, -8.804996791808D-05, -3.7267D-23, 1328, 'R', & !   16
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9582455267D0, -8.789587933636D-05,  3.4552D-23, 1324, 'R', & !   17
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5987343251D0, -8.774177173461D-05,  1.0957D-22, 1322, 'R', & !   18
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2251260899D0, -8.769676344109D-05,  3.7216D-23, 1321, 'R', & !   19
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1045784295D0, -8.637197594973D-05, -7.5023D-23, 1316, 'R', & !   20
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  21,  30 ) &
     & /                             &
     & 4.2053245367D0, -8.636127898767D-05, -8.2298D-23, 1315, 'R', & !   21
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2438924524D0, -8.618357603656D-05, -6.8286D-23, 1312, 'R', & !   22
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0614532524D0, -8.617287907449D-05, -7.5561D-23, 1310, 'R', & !   23
     &         12.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.1621993595D0, -8.616218211243D-05, -8.2837D-23, 1309, 'R', & !   24
     &         18.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.7885911244D0, -8.611717381891D-05, -1.5519D-22, 1308, 'R', & !   25
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7019420507D0, -8.601877147275D-05, -5.3998D-25, 1307, 'R', & !   26
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8026881579D0, -8.600807451068D-05, -7.8152D-24, 1306, 'R', & !   27
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1190741824D0, -8.596308523719D-05, -8.3375D-23, 1302, 'R', & !   28
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8412560735D0, -8.583037155957D-05,  6.1966D-24, 1299, 'R', & !   29
     &          6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6588168735D0, -8.581967459751D-05, -1.0786D-24, 1297, 'R', & !   30
     &         32.5D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  31,  40 ) &
     & /                             &
     & 4.7595629807D0, -8.580897763545D-05, -8.3538D-24, 1296, 'R', & !   31
     &         50.6D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.5683939455D0, -8.577466630399D-05, -7.3436D-23, 1295, 'P', & !   32
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3859547455D0, -8.576396934193D-05, -8.0711D-23, 1294, 'R', & !   33
     &          4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4867008527D0, -8.575327237987D-05, -8.7986D-23, 1293, 'R', & !   34
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0990913377D0, -8.564307235902D-05,  3.6163D-23, 1290, 'R', & !   35
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9166521377D0, -8.563237539695D-05,  2.8888D-23, 1289, 'R', & !   36
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7981308964D0, -8.563127468433D-05,  5.6580D-24, 1288, 'R', & !   37
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6156916964D0, -8.562057772227D-05, -1.6172D-24, 1287, 'R', & !   38
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7164378035D0, -8.560988076021D-05, -8.8924D-24, 1286, 'R', & !   39
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3428295684D0, -8.556487246669D-05, -8.1250D-23, 1285, 'R', & !   40
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  41,  50 ) &
     & /                             &
     & 3.4386196947D0, -8.547716708259D-05,  8.0679D-23, 1284, 'R', & !   41
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2561804947D0, -8.546647012053D-05,  7.3404D-23, 1283, 'R', & !   42
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3569266019D0, -8.545577315846D-05,  6.6129D-23, 1282, 'R', & !   43
     &         10.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.1657575667D0, -8.542146182701D-05,  1.0471D-24, 1280, 'P', & !   44
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9833183667D0, -8.541076486495D-05, -6.2282D-24, 1279, 'R', & !   45
     &          6.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0840644739D0, -8.540006790288D-05, -1.3503D-23, 1277, 'R', & !   46
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2130553175D0, -8.526737324529D-05,  7.2866D-23, 1275, 'R', & !   47
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3138014247D0, -8.525667628323D-05,  6.5590D-23, 1274, 'R', & !   48
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9401931895D0, -8.521166798971D-05, -6.7668D-24, 1273, 'R', & !   49
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5806819879D0, -8.505756038796D-05,  6.8255D-23, 1269, 'R', & !   50
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  51,  60 ) &
     & /                             &
     & 0.3982427879D0, -8.504686342590D-05,  6.0979D-23, 1267, 'R', & !   51
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5375568107D0, -8.485846351272D-05,  6.7716D-23, 1265, 'R', & !   52
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2749468572D0, -8.395328271599D-05, -3.2098D-23, 1263, 'R', & !   53
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0925076572D0, -8.394258575392D-05, -3.9373D-23, 1262, 'R', & !   54
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8196455292D0, -8.388688049834D-05, -1.1901D-22, 1261, 'R', & !   55
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9203916364D0, -8.387618353628D-05, -1.2628D-22, 1260, 'R', & !   56
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6425735275D0, -8.374346985866D-05, -3.6709D-23, 1259, 'R', & !   57
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4601343275D0, -8.373277289660D-05, -4.3984D-23, 1258, 'R', & !   58
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2776951275D0, -8.372207593453D-05, -5.1259D-23, 1257, 'R', & !   59
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8723104784D0, -8.360007823900D-05,  4.2385D-23, 1255, 'R', & !   60
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  61,  70 ) &
     & /                             &
     & 1.6898712784D0, -8.358938127694D-05,  3.5110D-23, 1254, 'R', & !   61
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9004087917D0, -8.355617065811D-05, -6.7426D-24, 1252, 'R', & !   62
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4987022432D0, -8.355506994549D-05, -2.9972D-23, 1251, 'P', & !   63
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7179695917D0, -8.354547369604D-05, -1.4018D-23, 1249, 'R', & !   64
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5994483504D0, -8.354437298342D-05, -3.7247D-23, 1248, 'R', & !   65
     &         28.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.4170091504D0, -8.353367602136D-05, -4.4523D-23, 1246, 'R', & !   66
     &        137.4D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.2345699504D0, -8.352297905930D-05, -5.1798D-23, 1244, 'R', & !   67
     &        214.8D0,        -1.2D0,     -839.0D0,      4.9D0,     & !
     & 4.3353160575D0, -8.351228209723D-05, -5.9073D-23, 1242, 'R', & !   68
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3265862224D0, -8.348866772784D-05, -1.1688D-22, 1241, 'P', & !   69
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1441470224D0, -8.347797076578D-05, -1.2416D-22, 1240, 'R', & !   70
     &          8.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  71,  80 ) &
     & /                             &
     & 5.2399371487D0, -8.339026538168D-05,  3.7774D-23, 1239, 'R', & !   71
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0574979487D0, -8.337956841961D-05,  3.0499D-23, 1238, 'R', & !   72
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8750587487D0, -8.336887145755D-05,  2.3224D-23, 1237, 'R', & !   73
     &         -3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7565375074D0, -8.336777074493D-05, -6.0328D-27, 1236, 'R', & !   74
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8572836145D0, -8.335707378287D-05, -7.2812D-24, 1235, 'R', & !   75
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6748444145D0, -8.334637682081D-05, -1.4556D-23, 1233, 'R', & !   76
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5563231732D0, -8.334527610819D-05, -3.7786D-23, 1234, 'R', & !   77
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3738839732D0, -8.333457914612D-05, -4.5061D-23, 1232, 'R', & !   78
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1914447732D0, -8.332388218406D-05, -5.2336D-23, 1230, 'R', & !   79
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7846358207D0, -8.332386316403D-05, -4.9134D-23, 1231, 'R', & !   80
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  81,  90 ) &
     & /                             &
     & 1.0960658644D0, -8.320186546850D-05,  4.4511D-23, 1226, 'P', & !   81
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1968119715D0, -8.319116850644D-05,  3.7235D-23, 1224, 'R', & !   82
     &         35.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.0143727715D0, -8.318047154438D-05,  2.9960D-23, 1223, 'R', & !   83
     &        172.8D0,        -1.0D0,     -333.3D0,      1.9D0,     & !
     & 0.8319335715D0, -8.316977458231D-05,  2.2685D-23, 1220, 'R', & !   84
     &        269.1D0,        -1.5D0,     -837.9D0,      4.8D0,     & !
     & 4.9326796787D0, -8.315907762025D-05,  1.5410D-23, 1219, 'R', & !   85
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9239498435D0, -8.313546325086D-05, -4.2397D-23, 1217, 'P', & !   86
     &          9.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.7415106435D0, -8.312476628880D-05, -4.9672D-23, 1216, 'R', & !   87
     &         50.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.5590714435D0, -8.311406932673D-05, -5.6947D-23, 1214, 'R', & !   88
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1714619285D0, -8.300386930588D-05,  6.7202D-23, 1211, 'R', & !   89
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2722080357D0, -8.299317234382D-05,  5.9926D-23, 1210, 'R', & !   90
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=  91, 100 ) &
     & /                             &
     & 5.1536867944D0, -8.299207163120D-05,  3.6697D-23, 1209, 'R', & !   91
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9712475944D0, -8.298137466914D-05,  2.9422D-23, 1208, 'R', & !   92
     &         11.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.7888083944D0, -8.297067770708D-05,  2.2146D-23, 1206, 'R', & !   93
     &         18.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3819994419D0, -8.297065868705D-05,  2.5349D-23, 1207, 'R', & !   94
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8985998005D0, -8.294816405030D-05, -1.2431D-23, 1204, 'R', & !   95
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8808246664D0, -8.293636637562D-05, -4.2936D-23, 1203, 'P', & !   96
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6983854664D0, -8.292566941356D-05, -5.0211D-23, 1202, 'R', & !   97
     &          4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7941755927D0, -8.283796402946D-05,  1.1172D-22, 1200, 'R', & !   98
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6117363927D0, -8.282726706739D-05,  1.0444D-22, 1199, 'R', & !   99
     &          5.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4292971927D0, -8.281657010533D-05,  9.7168D-23, 1198, 'R', & !  100
     &          8.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 101, 110 ) &
     & /                             &
     & 2.9281224172D0, -8.278227779390D-05,  2.8883D-23, 1196, 'R', & !  101
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2381281575D0, -8.278225877387D-05,  3.2086D-23, 1195, 'P', & !  102
     &          8.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7456832172D0, -8.277158083184D-05,  2.1608D-23, 1193, 'R', & !  103
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3388742647D0, -8.277156181181D-05,  2.4811D-23, 1194, 'R', & !  104
     &         43.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.1564350647D0, -8.276086484975D-05,  1.7535D-23, 1192, 'R', & !  105
     &          4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5686112155D0, -8.262817019215D-05,  1.0390D-22, 1190, 'R', & !  106
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3861720155D0, -8.261747323009D-05,  9.6629D-23, 1189, 'R', & !  107
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1950029804D0, -8.258316189864D-05,  3.1547D-23, 1188, 'P', & !  108
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2957490875D0, -8.257246493657D-05,  2.4272D-23, 1187, 'R', & !  109
     &          5.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1133098875D0, -8.256176797451D-05,  1.6997D-23, 1185, 'R', & !  110
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 111, 120 ) &
     & /                             &
     & 4.9362378859D0, -8.241835733483D-05,  9.9293D-23, 1184, 'R', & !  111
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2526239104D0, -8.237336806134D-05,  2.3733D-23, 1181, 'R', & !  112
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8931127087D0, -8.221926045959D-05,  9.8755D-23, 1180, 'R', & !  113
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6305027552D0, -8.131407966285D-05, -1.0591D-24, 1176, 'R', & !  114
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4480635552D0, -8.130338270079D-05, -8.3343D-24, 1175, 'R', & !  115
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0744553200D0, -8.125837440727D-05, -8.0691D-23, 1172, 'P', & !  116
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1752014272D0, -8.124767744521D-05, -8.7967D-23, 1171, 'R', & !  117
     &         -4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9927622272D0, -8.123698048315D-05, -9.5242D-23, 1170, 'R', & !  118
     &         -6.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7149441184D0, -8.110426680553D-05, -5.6701D-24, 1168, 'R', & !  119
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8156902255D0, -8.109356984346D-05, -1.2945D-23, 1167, 'R', & !  120
     &        -10.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 121, 130 ) &
     & /                             &
     & 2.6332510255D0, -8.108287288140D-05, -2.0220D-23, 1166, 'R', & !  121
     &        -18.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.4330366914D0, -8.106037824466D-05, -5.8001D-23, 1164, 'R', & !  122
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5428280975D0, -8.103786458788D-05, -9.2578D-23, 1162, 'R', & !  123
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1271202692D0, -8.097157214793D-05,  8.0699D-23, 1160, 'R', & !  124
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2278663764D0, -8.096087518587D-05,  7.3424D-23, 1159, 'R', & !  125
     &         -5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0454271764D0, -8.095017822381D-05,  6.6148D-23, 1158, 'R', & !  126
     &         -8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4561790239D0, -8.093946224172D-05,  6.2076D-23, 1157, 'R', & !  127
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3177765124D0, -8.091697711499D-05,  2.2695D-23, 1155, 'R', & !  128
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.9727793825D0, -8.091696760497D-05,  2.4296D-23, 1154, 'R', & !  129
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8542581412D0, -8.091586689235D-05,  1.0665D-24, 1153, 'P', & !  130
     &         19.5D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 131, 140 ) &
     & /                             &
     & 6.0735254897D0, -8.090627064291D-05,  1.7021D-23, 1151, 'R', & !  131
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6718189412D0, -8.090516993029D-05, -6.2087D-24, 1150, 'R', & !  132
     &        296.1D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 3.1457466531D0, -8.089520217331D-05,  1.7555D-23, 1147, 'R', & !  133
     &          0.1D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.8796418355D0, -8.089519906026D-05,  5.3724D-23, 1148, 'R', & !  134
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7725650484D0, -8.089447296823D-05, -1.3484D-23, 1146, 'R', & !  135
     &       1414.1D0,        -6.9D0,    -1321.8D0,      6.5D0,     & !
     & 0.1161981365D0, -8.089374376314D-05, -4.4523D-23, 1145, 'R', & !  136
     &         -0.1D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.5901258484D0, -8.088377600616D-05, -2.0759D-23, 1140, 'R', & !  137
     &       2208.1D0,       -10.8D0,    -5975.4D0,     29.1D0,     & !
     & 4.2169442436D0, -8.088304680108D-05, -5.1798D-23, 1139, 'R', & !  138
     &         -0.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4076866484D0, -8.087307904410D-05, -2.8034D-23, 1137, 'R', & !  139
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6999172545D0, -8.086126234939D-05, -5.5336D-23, 1136, 'R', & !  140
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 141, 150 ) &
     & /                             &
     & 3.5813960132D0, -8.086016163677D-05, -7.8566D-23, 1134, 'P', & !  141
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3989568132D0, -8.084946467471D-05, -8.5841D-23, 1133, 'P', & !  142
     &         27.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.4997029204D0, -8.083876771265D-05, -9.3116D-23, 1132, 'R', & !  143
     &        139.7D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 3.3172637204D0, -8.082807075058D-05, -1.0039D-22, 1131, 'R', & !  144
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3123077395D0, -8.075106232854D-05,  6.8813D-23, 1128, 'R', & !  145
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4130538467D0, -8.074036536648D-05,  6.1538D-23, 1127, 'R', & !  146
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2306146467D0, -8.072966840442D-05,  5.4262D-23, 1126, 'R', & !  147
     &         -4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1120934054D0, -8.072856769180D-05,  3.1033D-23, 1125, 'R', & !  148
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9296542054D0, -8.071787072974D-05,  2.3758D-23, 1124, 'R', & !  149
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0304003125D0, -8.070717376767D-05,  1.6482D-23, 1123, 'R', & !  150
     &        -12.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 151, 160 ) &
     & /                             &
     & 0.6286937640D0, -8.070607305505D-05, -6.7473D-24, 1122, 'R', & !  151
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7294398712D0, -8.069537609299D-05, -1.4023D-23, 1120, 'R', & !  152
     &         11.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.0394456115D0, -8.069535707296D-05, -1.0820D-23, 1121, 'P', & !  153
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5470006712D0, -8.068467913093D-05, -2.1298D-23, 1118, 'R', & !  154
     &         21.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 6.1401917187D0, -8.068466011090D-05, -1.8095D-23, 1119, 'R', & !  155
     &         -9.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9577525187D0, -8.067396314884D-05, -2.5370D-23, 1117, 'R', & !  156
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6567920774D0, -8.066216547415D-05, -5.5875D-23, 1116, 'R', & !  157
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4565777432D0, -8.063967083741D-05, -9.3655D-23, 1115, 'R', & !  158
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4516217624D0, -8.056266241537D-05,  7.5549D-23, 1114, 'P', & !  159
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2691825624D0, -8.055196545331D-05,  6.8274D-23, 1113, 'R', & !  160
     &         57.0D0,        -0.3D0,     -330.0D0,      1.6D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 161, 170 ) &
     & /                             &
     & 5.3699286695D0, -8.054126849124D-05,  6.0999D-23, 1112, 'R', & !  161
     &        282.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 1.5606710743D0, -8.053130073427D-05,  8.4762D-23, 1111, 'R', & !  162
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.1874894695D0, -8.053057152918D-05,  5.3724D-23, 1110, 'R', & !  163
     &        440.7D0,        -2.1D0,    -1159.6D0,      5.5D0,     & !
     & 4.8143078648D0, -8.052984232410D-05,  2.2685D-23, 1109, 'R', & !  164
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.0050502695D0, -8.051987456712D-05,  4.6448D-23, 1108, 'R', & !  165
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2972808757D0, -8.050805787241D-05,  1.9147D-23, 1107, 'R', & !  166
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1787596344D0, -8.050695715979D-05, -4.0830D-24, 1105, 'P', & !  167
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9963204344D0, -8.049626019773D-05, -1.1358D-23, 1103, 'P', & !  168
     &        114.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.5038754940D0, -8.048558225569D-05, -2.1836D-23, 1101, 'R', & !  169
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0970665415D0, -8.048556323566D-05, -1.8633D-23, 1102, 'R', & !  170
     &        586.2D0,        -2.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 171, 180 ) &
     & /                             &
     & 3.9146273415D0, -8.047486627360D-05, -2.5909D-23, 1100, 'R', & !  171
     &         26.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7321881415D0, -8.046416931154D-05, -3.3184D-23, 1099, 'R', & !  172
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5410191064D0, -8.042985798008D-05, -9.8266D-23, 1098, 'P', & !  173
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3445786265D0, -8.035396929069D-05,  9.0965D-23, 1097, 'R', & !  174
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2260573852D0, -8.035286857807D-05,  6.7736D-23, 1096, 'R', & !  175
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3268034924D0, -8.034217161601D-05,  6.0460D-23, 1094, 'R', & !  176
     &         13.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.1443642924D0, -8.033147465394D-05,  5.3185D-23, 1092, 'R', & !  177
     &         20.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4543700327D0, -8.033145563392D-05,  5.6388D-23, 1093, 'R', & !  178
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2541556985D0, -8.030896099717D-05,  1.8608D-23, 1090, 'R', & !  179
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0717164985D0, -8.029826403511D-05,  1.1333D-23, 1089, 'R', & !  180
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 181, 190 ) &
     & /                             &
     & 1.9531952572D0, -8.029716332249D-05, -1.1897D-23, 1088, 'P', & !  181
     &          8.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0539413644D0, -8.028646636042D-05, -1.9172D-23, 1086, 'R', & !  182
     &         43.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.8715021644D0, -8.027576939836D-05, -2.6447D-23, 1085, 'R', & !  183
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7761232555D0, -8.015375268280D-05,  7.0400D-23, 1083, 'P', & !  184
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2836783152D0, -8.014307474077D-05,  5.9922D-23, 1082, 'R', & !  185
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5936840555D0, -8.014305572074D-05,  6.3125D-23, 1081, 'P', & !  186
     &         23.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.1012391152D0, -8.013237777870D-05,  5.2646D-23, 1079, 'R', & !  187
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4112448555D0, -8.013235875868D-05,  5.5849D-23, 1080, 'R', & !  188
     &        119.6D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5119909627D0, -8.012166179662D-05,  4.8574D-23, 1078, 'R', & !  189
     &          5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3295517627D0, -8.011096483455D-05,  4.1299D-23, 1077, 'R', & !  190
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 191, 200 ) &
     & /                             &
     & 6.0108161872D0, -8.008736948519D-05, -1.9711D-23, 1075, 'R', & !  191
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3208219275D0, -8.008735046516D-05, -1.6508D-23, 1076, 'P', & !  192
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1383827275D0, -8.007665350310D-05, -2.3783D-23, 1074, 'P', & !  193
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5505588784D0, -7.994395884550D-05,  6.2586D-23, 1073, 'P', & !  194
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3681196784D0, -7.993326188344D-05,  5.5311D-23, 1072, 'R', & !  195
     &         13.4D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4688657855D0, -7.992256492138D-05,  4.8036D-23, 1070, 'R', & !  196
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0086084767D0, -7.977915428169D-05,  1.3033D-22, 1069, 'R', & !  197
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3249945012D0, -7.973416500820D-05,  5.4772D-23, 1068, 'R', & !  198
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7357463487D0, -7.972344902611D-05,  5.0700D-23, 1067, 'P', & !  199
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7459985232D0, -7.887397348496D-05,  3.0518D-23, 1063, 'R', & !  200
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 201, 210 ) &
     & /                             &
     & 5.8467446304D0, -7.886327652290D-05,  2.3243D-23, 1062, 'R', & !  201
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4731363952D0, -7.881826822938D-05, -4.9114D-23, 1061, 'P', & !  202
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2906971952D0, -7.880757126732D-05, -5.6389D-23, 1060, 'R', & !  203
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3914433024D0, -7.879687430525D-05, -6.3665D-23, 1059, 'R', & !  204
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8853125460D0, -7.868557357178D-05,  3.7255D-23, 1058, 'P', & !  205
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7028733460D0, -7.867487660972D-05,  2.9980D-23, 1057, 'R', & !  206
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8036194532D0, -7.866417964766D-05,  2.2704D-23, 1056, 'R', & !  207
     &         -7.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6211802532D0, -7.865348268560D-05,  1.5429D-23, 1055, 'R', & !  208
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4387410532D0, -7.864278572353D-05,  8.1540D-24, 1053, 'R', & !  209
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0319321007D0, -7.864276670351D-05,  1.1357D-23, 1052, 'R', & !  210
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 211, 220 ) &
     & /                             &
     & 4.6124504180D0, -7.862986831620D-05, -4.2378D-23, 1051, 'P', & !  211
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4300112180D0, -7.861917135414D-05, -4.9653D-23, 1050, 'P', & !  212
     &         -7.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2475720180D0, -7.860847439208D-05, -5.6928D-23, 1049, 'R', & !  213
     &        -29.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3483181252D0, -7.859777743001D-05, -6.4203D-23, 1048, 'R', & !  214
     &        -49.8D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.9747098900D0, -7.855276913650D-05, -1.3656D-22, 1047, 'P', & !  215
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0705000164D0, -7.846506375239D-05,  2.5369D-23, 1043, 'R', & !  216
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8880608164D0, -7.845436679033D-05,  1.8093D-23, 1042, 'R', & !  217
     &        -23.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.9888069235D0, -7.844366982827D-05,  1.0818D-23, 1041, 'R', & !  218
     &        -58.4D0,         0.2D0,     -655.1D0,      2.6D0,     & !
     & 5.8702856822D0, -7.844256911565D-05, -1.2411D-23, 1040, 'P', & !  219
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6878464822D0, -7.843187215359D-05, -1.9687D-23, 1039, 'R', & !  220
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 221, 230 ) &
     & /                             &
     & 1.5054072822D0, -7.842117519152D-05, -2.6962D-23, 1037, 'R', & !  221
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2044468408D0, -7.840937751684D-05, -5.7467D-23, 1036, 'R', & !  222
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7976378884D0, -7.840935849681D-05, -5.4264D-23, 1035, 'P', & !  223
     &         -4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3051929480D0, -7.839868055478D-05, -6.4742D-23, 1034, 'R', & !  224
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6151986884D0, -7.839866153475D-05, -6.1539D-23, 1033, 'R', & !  225
     &        -26.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.7159447955D0, -7.838796457269D-05, -6.8814D-23, 1032, 'R', & !  226
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4149843542D0, -7.837616689801D-05, -9.9319D-23, 1031, 'P', & !  227
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3002369672D0, -7.832167213274D-05,  1.0446D-22, 1029, 'R', & !  228
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1177977672D0, -7.831097517067D-05,  9.7187D-23, 1028, 'R', & !  229
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1090679320D0, -7.828736080128D-05,  3.9380D-23, 1026, 'P', & !  230
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 231, 240 ) &
     & /                             &
     & 5.2098140392D0, -7.827666383922D-05,  3.2105D-23, 1025, 'P', & !  231
     &        153.6D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.0273748392D0, -7.826596687716D-05,  2.4830D-23, 1024, 'R', & !  232
     &       2362.9D0,        -9.1D0,        0.0D0,      0.0D0,     & !
     & 5.5013025511D0, -7.825599912018D-05,  4.8594D-23, 1022, 'R', & !  233
     &          0.7D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 0.8449356392D0, -7.825526991509D-05,  1.7555D-23, 1020, 'R', & !  234
     &      11313.0D0,       -40.8D0,    -9810.8D0,     37.9D0,     & !
     & 3.9865283254D0, -7.825526218912D-05,  1.8618D-23, 1021, 'R', & !  235
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 2.4717540345D0, -7.825454071001D-05, -1.3484D-23, 1019, 'R', & !  236
     &         -0.7D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.3188633511D0, -7.824530215812D-05,  4.1318D-23, 1017, 'R', & !  237
     &          1.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.8294670324D0, -7.824468459415D-05,  1.0280D-23, 1016, 'R', & !  238
     &         -0.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.9584406476D0, -7.824467709141D-05, -2.0759D-23, 1014, 'R', & !  239
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.9456817464D0, -7.824457295303D-05,  1.0280D-23, 1010, 'R', & !  240
     &      17684.5D0,       -73.1D0,   -44398.6D0,    171.3D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 241, 250 ) &
     & /                             &
     & 1.8040891254D0, -7.824456522706D-05,  1.1342D-23, 1013, 'R', & !  241
     &          0.2D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.2556874867D0, -7.824455393300D-05,  1.3483D-23, 1011, 'R', & !  242
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9329228451D0, -7.824446881465D-05,  4.1318D-23, 1012, 'R', & !  243
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.7787111531D0, -7.824446131191D-05,  1.0280D-23, 1015, 'R', & !  244
     &          0.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.2893148345D0, -7.824384374795D-05, -2.0759D-23, 1009, 'R', & !  245
     &         -1.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.7632425464D0, -7.823387599097D-05,  3.0044D-24, 1007, 'R', & !  246
     &         12.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2997241752D0, -7.823276576834D-05, -1.8624D-23, 1006, 'R', & !  247
     &          0.3D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 0.9547270454D0, -7.823275625832D-05, -1.7022D-23, 1005, 'P', & !  248
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1172849752D0, -7.822206880627D-05, -2.5899D-23, 1004, 'R', & !  249
     &          0.0D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 5.0554731525D0, -7.822205929626D-05, -2.4297D-23, 1002, 'R', & !  250
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 251, 260 ) &
     & /                             &
     & 5.9369519112D0, -7.822095858364D-05, -4.7527D-23, 1001, 'P', & !  251
     &        -11.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1447748055D0, -7.821098771361D-05,  1.2405D-23,  999, 'R', & !  252
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7545127112D0, -7.821026162158D-05, -5.4802D-23,  998, 'P', & !  253
     &        528.2D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 1.5720735112D0, -7.819956465951D-05, -6.2078D-23,  996, 'R', & !  254
     &       2672.0D0,       -10.3D0,        0.0D0,      0.0D0,     & !
     & 5.6728196184D0, -7.818886769745D-05, -6.9353D-23,  994, 'R', & !  255
     &        -63.6D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 3.4903804184D0, -7.817817073539D-05, -7.6628D-23,  993, 'R', & !  256
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2992113832D0, -7.814385940393D-05, -1.4171D-22,  992, 'P', & !  257
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1027709034D0, -7.806797071454D-05,  4.7521D-23,  988, 'R', & !  258
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9842496620D0, -7.806687000192D-05,  2.4291D-23,  987, 'R', & !  259
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8018104620D0, -7.805617303986D-05,  1.7016D-23,  984, 'R', & !  260
     &         19.5D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 261, 270 ) &
     & /                             &
     & 4.3950015095D0, -7.805615401983D-05,  2.0219D-23,  985, 'P', & !  261
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9025565692D0, -7.804547607779D-05,  9.7410D-24,  982, 'R', & !  262
     &         55.8D0,        -0.2D0,      654.2D0,     -2.5D0,     & !
     & 2.2125623095D0, -7.804545705777D-05,  1.2944D-23,  983, 'R', & !  263
     &        -61.6D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.0301231095D0, -7.803476009570D-05,  5.6687D-24,  981, 'R', & !  264
     &         -5.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9116018682D0, -7.803365938308D-05, -1.7561D-23,  980, 'P', & !  265
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0123479754D0, -7.802296242102D-05, -2.4836D-23,  978, 'R', & !  266
     &        -29.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.8299087754D0, -7.801226545896D-05, -3.2111D-23,  977, 'R', & !  267
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7113875340D0, -7.801116474634D-05, -5.5341D-23,  976, 'P', & !  268
     &          6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5289483340D0, -7.800046778428D-05, -6.2616D-23,  975, 'R', & !  269
     &         34.4D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.6296944412D0, -7.798977082221D-05, -6.9891D-23,  973, 'R', & !  270
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 271, 280 ) &
     & /                             &
     & 5.8071776604D0, -7.792345936224D-05,  1.0659D-22,  972, 'P', & !  271
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6247384604D0, -7.791276240017D-05,  9.9313D-23,  971, 'R', & !  272
     &         -5.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4422992604D0, -7.790206543811D-05,  9.2038D-23,  970, 'R', & !  273
     &         -6.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5430453675D0, -7.789136847605D-05,  8.4762D-23,  969, 'R', & !  274
     &        -10.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6528367737D0, -7.786885481928D-05,  5.0185D-23,  966, 'R', & !  275
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2511302252D0, -7.786775410666D-05,  2.6956D-23,  965, 'P', & !  276
     &        -24.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3518763324D0, -7.785705714459D-05,  1.9681D-23,  963, 'P', & !  277
     &       1135.7D0,        -4.2D0,      326.9D0,     -1.2D0,     & !
     & 0.5426187371D0, -7.784708938761D-05,  4.3444D-23,  962, 'R', & !  278
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8594313920D0, -7.784637920256D-05,  9.2024D-24,  961, 'R', & !  279
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1694371324D0, -7.784636018253D-05,  1.2405D-23,  960, 'R', & !  280
     &       5816.1D0,       -21.5D0,      326.9D0,     -1.2D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 281, 290 ) &
     & /                             &
     & 3.7962555276D0, -7.784563097744D-05, -1.8633D-23,  959, 'P', & !  281
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2701832395D0, -7.783566322047D-05,  5.1301D-24,  958, 'R', & !  282
     &        185.4D0,        -0.7D0,     -326.9D0,      1.2D0,     & !
     & 4.0877440395D0, -7.782496625840D-05, -2.1451D-24,  957, 'R', & !  283
     &          3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9692227982D0, -7.782386554578D-05, -2.5375D-23,  956, 'R', & !  284
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4858231568D0, -7.780137090904D-05, -6.3155D-23,  955, 'R', & !  285
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0790142044D0, -7.780135188901D-05, -5.9952D-23,  954, 'P', & !  286
     &         -3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8965750044D0, -7.779065492695D-05, -6.7227D-23,  953, 'P', & !  287
     &         17.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.7141358044D0, -7.777995796489D-05, -7.4502D-23,  952, 'R', & !  288
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3991740832D0, -7.770296856287D-05,  9.1499D-23,  951, 'R', & !  289
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4999201904D0, -7.769227160081D-05,  8.4224D-23,  950, 'R', & !  290
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 291, 300 ) &
     & /                             &
     & 2.8099259307D0, -7.769225258078D-05,  8.7427D-23,  949, 'R', & !  291
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5089654894D0, -7.768045490610D-05,  5.6922D-23,  948, 'P', & !  292
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6097115965D0, -7.766975794404D-05,  4.9647D-23,  947, 'R', & !  293
     &         -9.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2080050480D0, -7.766865723142D-05,  2.6417D-23,  946, 'P', & !  294
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3233609494D0, -7.766404641699D-05,  1.2405D-23,  945, 'P', & !  295
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3087511552D0, -7.765796026935D-05,  1.9142D-23,  943, 'P', & !  296
     &         76.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.1263119552D0, -7.764726330729D-05,  1.1867D-23,  942, 'R', & !  297
     &        399.6D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 6.2270580624D0, -7.763656634523D-05,  4.5915D-24,  940, 'R', & !  298
     &          4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5370638027D0, -7.763654732520D-05,  7.7944D-24,  941, 'P', & !  299
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0446188624D0, -7.762586938317D-05, -2.6837D-24,  939, 'R', & !  300
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 301, 310 ) &
     & /                             &
     & 5.0147898984D0, -7.759727852257D-05,  1.2405D-23,  938, 'P', & !  301
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8534498272D0, -7.759155805171D-05, -6.7766D-23,  937, 'P', & !  302
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8484938464D0, -7.751454962967D-05,  1.0144D-22,  936, 'P', & !  303
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9492399535D0, -7.750385266761D-05,  9.4163D-23,  935, 'P', & !  304
     &         23.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7668007535D0, -7.749315570555D-05,  8.6888D-23,  934, 'R', & !  305
     &        118.1D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 0.5843615535D0, -7.748245874348D-05,  7.9613D-23,  933, 'R', & !  306
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5665864194D0, -7.747066106880D-05,  4.9108D-23,  931, 'R', & !  307
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2656259780D0, -7.745886339412D-05,  1.8603D-23,  930, 'P', & !  308
     &          4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0831867780D0, -7.744816643205D-05,  1.1328D-23,  928, 'R', & !  309
     &         19.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.6763778255D0, -7.744814741203D-05,  1.4531D-23,  929, 'P', & !  310
     &         -6.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 311, 320 ) &
     & /                             &
     & 3.4939386255D0, -7.743745044997D-05,  7.2557D-24,  927, 'P', & !  311
     &         35.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.3114994255D0, -7.742675348790D-05, -1.9472D-26,  926, 'R', & !  312
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9061147764D0, -7.730475579237D-05,  9.3625D-23,  925, 'P', & !  313
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7236755764D0, -7.729405883031D-05,  8.6349D-23,  924, 'R', & !  314
     &         10.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5412363764D0, -7.728336186824D-05,  7.9074D-23,  923, 'R', & !  315
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0400616008D0, -7.724906955682D-05,  1.0789D-23,  921, 'R', & !  316
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6332526484D0, -7.724905053679D-05,  1.3992D-23,  922, 'P', & !  317
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4508134484D0, -7.723835357473D-05,  6.7171D-24,  920, 'P', & !  318
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6805503992D0, -7.709496195507D-05,  8.5811D-23,  919, 'R', & !  319
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0913022467D0, -7.708424597298D-05,  8.1739D-23,  918, 'P', & !  320
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 321, 330 ) &
     & /                             &
     & 0.5069390704D0, -7.635676812736D-05, -3.2087D-23,  915, 'R', & !  321
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1065104020D0, -7.631177885387D-05, -1.0765D-22,  914, 'R', & !  322
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8286922932D0, -7.617906517625D-05, -1.8075D-23,  912, 'P', & !  323
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6462530932D0, -7.616836821418D-05, -2.5351D-23,  911, 'R', & !  324
     &         -7.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4638138932D0, -7.615767125212D-05, -3.2626D-23,  910, 'R', & !  325
     &        -10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3733909652D0, -7.611266295860D-05, -1.0498D-22,  908, 'P', & !  326
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0584292440D0, -7.603567355659D-05,  6.1018D-23,  907, 'R', & !  327
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8759900440D0, -7.602497659453D-05,  5.3743D-23,  906, 'R', & !  328
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6848210088D0, -7.599066526307D-05, -1.1339D-23,  904, 'P', & !  329
     &         -8.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7855671160D0, -7.597996830101D-05, -1.8614D-23,  903, 'P', & !  330
     &        -71.8D0,         0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 331, 340 ) &
     & /                             &
     & 2.6031279160D0, -7.596927133894D-05, -2.5889D-23,  902, 'R', & !  331
     &       -178.9D0,         0.5D0,      325.0D0,     -0.9D0,     & !
     & 0.4206887160D0, -7.595857437688D-05, -3.3164D-23,  900, 'R', & !  332
     &       -233.7D0,         0.7D0,      817.0D0,     -2.4D0,     & !
     & 4.0138797635D0, -7.595855535686D-05, -2.9962D-23,  901, 'R', & !  333
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5214348232D0, -7.594787741482D-05, -4.0440D-23,  899, 'R', & !  334
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5127049880D0, -7.592426304543D-05, -9.8246D-23,  897, 'P', & !  335
     &          3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3302657880D0, -7.591356608336D-05, -1.0552D-22,  896, 'P', & !  336
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1478265880D0, -7.590286912130D-05, -1.1280D-22,  895, 'R', & !  337
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4260559144D0, -7.582586069926D-05,  5.6407D-23,  894, 'R', & !  338
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2436167144D0, -7.581516373720D-05,  4.9132D-23,  893, 'R', & !  339
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0611775144D0, -7.580446677514D-05,  4.1857D-23,  892, 'R', & !  340
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 341, 350 ) &
     & /                             &
     & 1.9426562730D0, -7.580336606252D-05,  1.8627D-23,  891, 'P', & !  341
     &          3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0434023802D0, -7.579266910045D-05,  1.1352D-23,  890, 'R', & !  342
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8609631802D0, -7.578197213839D-05,  4.0770D-24,  889, 'R', & !  343
     &          5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7424419388D0, -7.578087142577D-05, -1.9153D-23,  887, 'P', & !  344
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0524476792D0, -7.578085240574D-05, -1.5950D-23,  888, 'P', & !  345
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5600027388D0, -7.577017446371D-05, -2.6428D-23,  885, 'R', & !  346
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1531937864D0, -7.577015544368D-05, -2.3225D-23,  886, 'P', & !  347
     &        -47.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.3775635388D0, -7.575947750164D-05, -3.3703D-23,  884, 'R', & !  348
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9707545864D0, -7.575945848162D-05, -3.0500D-23,  883, 'R', & !  349
     &       -318.2D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 1.7883153864D0, -7.574876151955D-05, -3.7775D-23,  882, 'R', & !  350
     &         11.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 351, 360 ) &
     & /                             &
     & 2.7737055922D0, -7.574267537192D-05, -3.1039D-23,  881, 'R', & !  351
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4873549450D0, -7.573696384487D-05, -6.8280D-23,  879, 'P', & !  352
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2871406108D0, -7.571446920813D-05, -1.0606D-22,  877, 'P', & !  353
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5049530262D0, -7.568490243636D-05, -3.1039D-23,  876, 'R', & !  354
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4646238300D0, -7.564815774815D-05,  7.0419D-23,  875, 'P', & !  355
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2821846300D0, -7.563746078609D-05,  6.3144D-23,  874, 'P', & !  356
     &        -57.8D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.3829307372D0, -7.562676382402D-05,  5.5869D-23,  873, 'R', & !  357
     &       -381.4D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 3.2004915372D0, -7.561606686196D-05,  4.8594D-23,  871, 'R', & !  358
     &       -636.8D0,         1.8D0,      649.4D0,     -1.8D0,     & !
     & 0.5104972775D0, -7.561604784193D-05,  5.1796D-23,  872, 'P', & !  359
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0180523372D0, -7.560536989990D-05,  4.1318D-23,  868, 'R', & !  360
     &      -1018.7D0,         2.8D0,     2773.5D0,     -7.7D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 361, 370 ) &
     & /                             &
     & 4.6112433847D0, -7.560535087987D-05,  4.4521D-23,  869, 'R', & !  361
     &         -7.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1187984444D0, -7.559467293783D-05,  3.4043D-23,  866, 'R', & !  362
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4288041847D0, -7.559465391781D-05,  3.7246D-23,  865, 'R', & !  363
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0002772030D0, -7.559357222522D-05,  1.0814D-23,  862, 'R', & !  364
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6552800732D0, -7.559356271520D-05,  1.2415D-23,  863, 'R', & !  365
     &          0.0D0,         7.7D0,        0.0D0,      0.0D0,     & !
     & 3.3102829434D0, -7.559355320519D-05,  1.4016D-23,  861, 'P', & !  366
     &         10.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8178380030D0, -7.558287526315D-05,  3.5384D-24,  859, 'R', & !  367
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4728408732D0, -7.558286575314D-05,  5.1398D-24,  858, 'R', & !  368
     &          0.1D0,        18.9D0,        0.0D0,      0.0D0,     & !
     & 1.1278437434D0, -7.558285624313D-05,  6.7413D-24,  857, 'R', & !  369
     &         53.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3995845964D0, -7.558248162254D-05,  5.0719D-23,  856, 'P', & !  370
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 371, 380 ) &
     & /                             &
     & 2.0093225020D0, -7.558175553051D-05, -1.6488D-23,  855, 'P', & !  371
     &       -283.5D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.2569638814D0, -7.558077961934D-05,  4.3444D-23,  854, 'R', & !  372
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2904016732D0, -7.557216879108D-05, -2.1354D-24,  853, 'R', & !  373
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.2285898505D0, -7.557215928106D-05, -5.3394D-25,  852, 'R', & !  374
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2171453964D0, -7.557178466047D-05,  4.3444D-23,  851, 'R', & !  375
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1100686092D0, -7.557105856844D-05, -2.3764D-23,  849, 'P', & !  376
     &      13210.7D0,       -33.8D0,     1948.0D0,     -5.3D0,     & !
     & 2.3008110139D0, -7.556109081147D-05,  0.0000D+00,  848, 'R', & !  377
     &          2.1D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8114146953D0, -7.556047324750D-05, -3.1039D-23,  846, 'P', & !  378
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.7860367230D0, -7.556036933235D-05, -3.2102D-23,  845, 'R', & !  379
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.9276294092D0, -7.556036160638D-05, -3.1039D-23,  842, 'R', & !  380
     &      66936.0D0,      -170.9D0,     2272.6D0,     -6.2D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 381, 390 ) &
     & /                             &
     & 0.7860367882D0, -7.556035388041D-05, -2.9976D-23,  843, 'P', & !  381
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.7606588159D0, -7.556024996526D-05, -3.1039D-23,  841, 'R', & !  382
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.5544478045D0, -7.555963240130D-05, -6.2078D-23,  840, 'P', & !  383
     &         -2.1D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.8166918934D0, -7.555499976673D-05,  4.3444D-23,  839, 'R', & !  384
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7451902092D0, -7.554966464432D-05, -3.8314D-23,  837, 'R', & !  385
     &      -1969.0D0,         5.4D0,     1947.9D0,     -5.3D0,     & !
     & 4.8867828954D0, -7.554965691834D-05, -3.7251D-23,  838, 'R', & !  386
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.8459363164D0, -7.553896768225D-05, -4.5589D-23,  836, 'R', & !  387
     &         16.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4442297678D0, -7.553786696963D-05, -6.8819D-23,  835, 'P', & !  388
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5540211740D0, -7.551535331286D-05, -1.0340D-22,  834, 'P', & !  389
     &         -3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6547672812D0, -7.550465635080D-05, -1.1067D-22,  833, 'P', & !  390
     &         17.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 391, 400 ) &
     & /                             &
     & 2.4723280812D0, -7.549395938874D-05, -1.1795D-22,  832, 'P', & !  391
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6796402644D0, -7.545623878936D-05,  4.3444D-23,  831, 'R', & !  392
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3503057922D0, -7.543582077640D-05, -3.1039D-23,  830, 'P', & !  393
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3398055600D0, -7.542766694879D-05,  5.5330D-23,  829, 'R', & !  394
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1573663600D0, -7.541696998672D-05,  4.8055D-23,  827, 'R', & !  395
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4673721004D0, -7.541695096670D-05,  5.1258D-23,  828, 'P', & !  396
     &        -14.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9749271600D0, -7.540627302466D-05,  4.0780D-23,  826, 'R', & !  397
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5681182075D0, -7.540625400463D-05,  4.3983D-23,  825, 'R', & !  398
     &        -89.5D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.4495969662D0, -7.540515329201D-05,  2.0753D-23,  824, 'P', & !  399
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3856790075D0, -7.539555704257D-05,  3.6707D-23,  823, 'R', & !  400
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 401, 410 ) &
     & /                             &
     & 3.2671577662D0, -7.539445632995D-05,  1.3478D-23,  822, 'P', & !  401
     &        -73.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.0847185662D0, -7.538375936789D-05,  6.2026D-24,  820, 'R', & !  402
     &       -399.5D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 1.9661973248D0, -7.538265865527D-05, -1.7027D-23,  819, 'P', & !  403
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0815532262D0, -7.537804784084D-05, -3.1039D-23,  818, 'P', & !  404
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1854646734D0, -7.537306240583D-05, -1.0726D-24,  817, 'R', & !  405
     &         12.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0669434320D0, -7.537196169321D-05, -2.4302D-23,  816, 'P', & !  406
     &         68.3D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.0030254734D0, -7.536236544376D-05, -8.3478D-24,  815, 'R', & !  407
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8845042320D0, -7.536126473114D-05, -3.1577D-23,  814, 'R', & !  408
     &        445.7D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 1.1945099724D0, -7.536124571112D-05, -2.8374D-23,  813, 'P', & !  409
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7020650320D0, -7.535056776908D-05, -3.8853D-23,  811, 'R', & !  410
     &        -16.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 411, 420 ) &
     & /                             &
     & 5.2952560795D0, -7.535054874905D-05, -3.5650D-23,  812, 'P', & !  411
     &        -10.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1128168795D0, -7.533985178699D-05, -4.2925D-23,  809, 'R', & !  412
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9802943584D0, -7.527355934704D-05,  1.3035D-22,  808, 'R', & !  413
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7978551584D0, -7.526286238498D-05,  1.2308D-22,  807, 'R', & !  414
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6154159584D0, -7.525216542291D-05,  1.1580D-22,  806, 'R', & !  415
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6066861232D0, -7.522855105352D-05,  5.7994D-23,  805, 'P', & !  416
     &        -62.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.4242469232D0, -7.521785409146D-05,  5.0719D-23,  804, 'P', & !  417
     &       2926.1D0,        -7.6D0,      324.4D0,     -0.8D0,     & !
     & 5.6359305462D0, -7.521251896904D-05, -3.1039D-23,  803, 'P', & !  418
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8981746351D0, -7.520788633448D-05,  7.4483D-23,  802, 'R', & !  419
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4087783164D0, -7.520726877051D-05,  4.3444D-23,  801, 'P', & !  420
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 421, 430 ) &
     & /                             &
     & 4.5249930304D0, -7.520715712940D-05,  4.3444D-23,  800, 'R', & !  421
     &      14838.2D0,       -36.0D0,      324.4D0,     -0.8D0,     & !
     & 1.3580224371D0, -7.520704548828D-05,  4.3444D-23,  799, 'R', & !  422
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 6.1518114256D0, -7.520642792431D-05,  1.2405D-23,  798, 'P', & !  423
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3425538304D0, -7.519646016733D-05,  3.6169D-23,  797, 'R', & !  424
     &       -477.3D0,         1.2D0,      324.4D0,     -0.8D0,     & !
     & 6.2354770432D0, -7.519573407530D-05, -3.1039D-23,  796, 'P', & !  425
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9124732510D0, -7.518673911644D-05, -3.1039D-23,  795, 'P', & !  426
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1601146304D0, -7.518576320527D-05,  2.8894D-23,  794, 'R', & !  427
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0415933890D0, -7.518466249265D-05,  5.6640D-24,  793, 'R', & !  428
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0238182548D0, -7.517286481797D-05, -2.4841D-23,  792, 'P', & !  429
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8413790548D0, -7.516216785590D-05, -3.2116D-23,  791, 'R', & !  430
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 431, 440 ) &
     & /                             &
     & 1.1513847952D0, -7.516214883588D-05, -2.8913D-23,  790, 'P', & !  431
     &        -71.7D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.6589398548D0, -7.515147089384D-05, -3.9391D-23,  789, 'R', & !  432
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2521309024D0, -7.515145187382D-05, -3.6188D-23,  788, 'P', & !  433
     &        451.8D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 3.0696917024D0, -7.514075491175D-05, -4.3464D-23,  787, 'R', & !  434
     &        -54.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.8872525024D0, -7.513005794969D-05, -5.0739D-23,  786, 'R', & !  435
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9476694134D0, -7.508261629942D-05,  4.3444D-23,  785, 'P', & !  436
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8645213874D0, -7.504125185297D-05,  8.7961D-23,  784, 'P', & !  437
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6820821874D0, -7.503055489090D-05,  8.0685D-23,  783, 'R', & !  438
     &         -5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5635609460D0, -7.502945417828D-05,  5.7456D-23,  782, 'P', & !  439
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6789168474D0, -7.502484336386D-05,  4.3444D-23,  781, 'P', & !  440
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 441, 450 ) &
     & /                             &
     & 5.7828282945D0, -7.501985792884D-05,  7.3410D-23,  780, 'R', & !  441
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3811217460D0, -7.501875721622D-05,  5.0181D-23,  779, 'P', & !  442
     &        133.1D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.4818678532D0, -7.500806025416D-05,  4.2905D-23,  778, 'R', & !  443
     &        696.4D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 2.2994286532D0, -7.499736329210D-05,  3.5630D-23,  777, 'R', & !  444
     &        -23.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.8926197007D0, -7.499734427207D-05,  3.8833D-23,  776, 'P', & !  445
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5916592594D0, -7.498554659739D-05,  8.3283D-24,  774, 'P', & !  446
     &         38.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.4092200594D0, -7.497484963532D-05,  1.0531D-24,  773, 'P', & !  447
     &         -5.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2267808594D0, -7.496415267326D-05, -6.2221D-24,  772, 'R', & !  448
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1082596180D0, -7.496305196064D-05, -2.9452D-23,  771, 'P', & !  449
     &         -4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0871604892D0, -7.495807546943D-05,  4.3444D-23,  770, 'P', & !  450
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 451, 460 ) &
     & /                             &
     & 5.2090057252D0, -7.495235499858D-05, -3.6727D-23,  769, 'P', & !  451
     &         24.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.0265665252D0, -7.494165803652D-05, -4.4002D-23,  768, 'R', & !  452
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0216105444D0, -7.486464961448D-05,  1.2520D-22,  767, 'P', & !  453
     &          3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1223566515D0, -7.485395265241D-05,  1.1793D-22,  766, 'R', & !  454
     &         15.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9399174515D0, -7.484325569035D-05,  1.1065D-22,  765, 'R', & !  455
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5496553572D0, -7.484252959832D-05,  4.3444D-23,  764, 'P', & !  456
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6389570102D0, -7.483145801567D-05,  8.0147D-23,  763, 'R', & !  457
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3379965688D0, -7.481966034098D-05,  4.9642D-23,  762, 'P', & !  458
     &          5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4387426760D0, -7.480896337892D-05,  4.2367D-23,  760, 'R', & !  459
     &         26.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7487484164D0, -7.480894435889D-05,  4.5570D-23,  761, 'P', & !  460
     &        -14.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 461, 470 ) &
     & /                             &
     & 2.2563034760D0, -7.479826641686D-05,  3.5092D-23,  759, 'R', & !  461
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8494945235D0, -7.479824739683D-05,  3.8294D-23,  758, 'P', & !  462
     &        102.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.6670553235D0, -7.478755043477D-05,  3.1019D-23,  757, 'R', & !  463
     &         -7.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1658805480D0, -7.475325812334D-05, -3.7266D-23,  755, 'P', & !  464
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0792314744D0, -7.465485577717D-05,  1.1739D-22,  754, 'R', & !  465
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3956174988D0, -7.460986650368D-05,  4.1828D-23,  752, 'R', & !  466
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7056232392D0, -7.460984748366D-05,  4.5031D-23,  753, 'P', & !  467
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8063693464D0, -7.459915052159D-05,  3.7756D-23,  751, 'P', & !  468
     &         10.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6239301464D0, -7.458845355953D-05,  3.0481D-23,  750, 'R', & !  469
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3547629425D0, -7.454018934300D-05,  0.0000D+00,  749, 'R', & !  470
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 471, 480 ) &
     & /                             &
     & 5.8768597287D0, -7.451559906318D-05,  0.0000D+00,  748, 'P', & !  471
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7774393255D0, -7.441564851302D-05,  0.0000D+00,  747, 'R', & !  472
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7632441692D0, -7.440005364636D-05,  3.7217D-23,  746, 'P', & !  473
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0163508045D0, -7.439105823320D-05,  0.0000D+00,  745, 'P', & !  474
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2001157085D0, -7.429110768304D-05,  0.0000D+00,  743, 'R', & !  475
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2001157085D0, -7.429109995743D-05,  0.0000D+00,  744, 'P', & !  476
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 2.4390271875D0, -7.426651740322D-05,  0.0000D+00,  742, 'P', & !  477
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6227920915D0, -7.416656685306D-05,  0.0000D+00,  740, 'R', & !  478
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6227920915D0, -7.416655912745D-05,  0.0000D+00,  741, 'P', & !  479
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 3.8617035705D0, -7.414197657324D-05,  0.0000D+00,  739, 'P', & !  480
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 481, 490 ) &
     & /                             &
     & 6.0454684745D0, -7.404202602308D-05,  0.0000D+00,  736, 'R', & !  481
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0454684745D0, -7.404201829747D-05,  0.0000D+00,  735, 'P', & !  482
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 5.2843799535D0, -7.401743574325D-05,  0.0000D+00,  734, 'P', & !  483
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6151738845D0, -7.394287791396D-05,  0.0000D+00,  733, 'P', & !  484
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 1.9460480714D0, -7.394206774732D-05,  0.0000D+00,  731, 'R', & !  485
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.1849595504D0, -7.391748519310D-05,  0.0000D+00,  729, 'R', & !  486
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1849595504D0, -7.391747746749D-05,  0.0000D+00,  728, 'P', & !  487
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 5.5956144052D0, -7.391668096949D-05, -3.7127D-24,  727, 'R', & !  488
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9056201455D0, -7.391666194946D-05, -5.0980D-25,  726, 'R', & !  489
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4238710294D0, -7.389289491327D-05,  0.0000D+00,  725, 'P', & !  490
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 491, 500 ) &
     & /                             &
     & 5.5976585354D0, -7.386631261963D-05,  0.0000D+00,  720, 'R', & !  491
     &          0.1D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.5157534814D0, -7.384292736380D-05,  0.0000D+00,  718, 'R', & !  492
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.7546649604D0, -7.381833708398D-05,  0.0000D+00,  717, 'P', & !  493
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.3687244544D0, -7.381752691733D-05,  0.0000D+00,  715, 'R', & !  494
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.6076359334D0, -7.379294436312D-05,  0.0000D+00,  714, 'R', & !  495
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6076359334D0, -7.379293663751D-05,  0.0000D+00,  713, 'P', & !  496
     &         -0.3D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 1.8465474124D0, -7.376836180890D-05,  0.0000D+00,  712, 'P', & !  497
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.8465474124D0, -7.376835408329D-05,  0.0000D+00,  711, 'P', & !  498
     &         -5.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4606069064D0, -7.376755164226D-05,  0.0000D+00,  710, 'R', & !  499
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.8166215208D0, -7.374967498044D-05,  1.7574D-23,  709, 'R', & !  500
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 501, 510 ) &
     & /                             &
     & 3.6341823208D0, -7.373897801838D-05,  1.0299D-23,  707, 'R', & !  501
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9441880612D0, -7.373895899835D-05,  1.3502D-23,  706, 'P', & !  502
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0449341684D0, -7.372826203629D-05,  6.2268D-24,  705, 'R', & !  503
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9384298644D0, -7.371838653382D-05,  0.0000D+00,  704, 'R', & !  504
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.5524892280D0, -7.371758409425D-05, -4.2513D-24,  703, 'R', & !  505
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8624949684D0, -7.371756507422D-05, -1.0484D-24,  702, 'R', & !  506
     &        137.6D0,        -0.3D0,     -994.8D0,      2.0D0,     & !
     & 5.5524893584D0, -7.371755319035D-05,  0.0000D+00,  701, 'R', & !  507
     &          0.3D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 6.1520358554D0, -7.370078374783D-05,  0.0000D+00,  698, 'R', & !  508
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.2605740856D0, -7.369396972486D-05, -6.2058D-23,  697, 'P', & !  509
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1773413434D0, -7.369379625400D-05,  0.0000D+00,  696, 'P', & !  510
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 511, 520 ) &
     & /                             &
     & 4.7914008374D0, -7.369298608735D-05,  0.0000D+00,  694, 'R', & !  511
     &         -0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7914008374D0, -7.369297836174D-05,  0.0000D+00,  693, 'R', & !  512
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4683970452D0, -7.368399885409D-05,  0.0000D+00,  691, 'R', & !  513
     &          1.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3613201928D0, -7.368327276280D-05, -6.9333D-23,  690, 'R', & !  514
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6713259332D0, -7.368325374277D-05, -6.6130D-23,  689, 'P', & !  515
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1788809928D0, -7.367257580073D-05, -7.6608D-23,  688, 'R', & !  516
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7720720404D0, -7.367255678071D-05, -7.3406D-23,  687, 'P', & !  517
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0303123164D0, -7.366840353314D-05,  0.0000D+00,  685, 'R', & !  518
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0303123164D0, -7.366839580753D-05,  0.0000D+00,  684, 'P', & !  519
     &         -0.8D0,         3.1D0,        0.0D0,      0.0D0,     & !
     & 1.0679435422D0, -7.366721396035D-05,  0.0000D+00,  683, 'R', & !  520
     &          0.3D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 521, 530 ) &
     & /                             &
     & 3.2692237954D0, -7.364382097892D-05,  0.0000D+00,  681, 'P', & !  521
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 3.2692237954D0, -7.364381325331D-05,  0.0000D+00,  680, 'P', & !  522
     &         -7.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0884580648D0, -7.362756750721D-05, -1.4897D-22,  678, 'P', & !  523
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3611062474D0, -7.359384570384D-05,  0.0000D+00,  675, 'R', & !  524
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 3.6000177264D0, -7.356925542401D-05,  0.0000D+00,  672, 'P', & !  525
     &          0.0D0,        -1.6D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356845298298D-05,  0.0000D+00,  671, 'R', & !  526
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356844525737D-05,  0.0000D+00,  670, 'R', & !  527
     &         -0.1D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 6.2140772204D0, -7.356843753176D-05,  0.0000D+00,  669, 'R', & !  528
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0835020840D0, -7.355055908518D-05,  2.0239D-23,  668, 'P', & !  529
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4529886994D0, -7.354386270315D-05,  0.0000D+00,  665, 'R', & !  530
     &          6.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 531, 540 ) &
     & /                             &
     & 5.4529886994D0, -7.354385497755D-05,  0.0000D+00,  664, 'P', & !  531
     &         -0.9D0,         4.1D0,        0.0D0,      0.0D0,     & !
     & 0.9010628840D0, -7.353986212311D-05,  1.2963D-23,  662, 'P', & !  532
     &        -64.0D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0018089912D0, -7.352916516105D-05,  5.6882D-24,  659, 'R', & !  533
     &       -115.6D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.6919001784D0, -7.351928014894D-05,  0.0000D+00,  657, 'P', & !  534
     &          0.0D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 4.6919001784D0, -7.351927242333D-05,  0.0000D+00,  656, 'P', & !  535
     &        -10.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1897449584D0, -7.351858162341D-05,  0.0000D+00,  655, 'R', & !  536
     &          0.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.8193697912D0, -7.351846819899D-05, -1.5870D-24,  653, 'R', & !  537
     &       4557.8D0,        -9.2D0,   -14530.5D0,     29.4D0,     & !
     & 0.1293755315D0, -7.351844917896D-05,  1.6158D-24,  651, 'R', & !  538
     &         27.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.1389890791D0, -7.351835834118D-05,  0.0000D+00,  650, 'R', & !  539
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7008485498D0, -7.351736748637D-05, -2.4817D-23,  647, 'P', & !  540
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 541, 550 ) &
     & /                             &
     & 1.8967911222D0, -7.351171094152D-05,  0.0000D+00,  645, 'R', & !  541
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6369305912D0, -7.350777123692D-05, -8.8622D-24,  644, 'R', & !  542
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5184093498D0, -7.350667052430D-05, -3.2092D-23,  643, 'R', & !  543
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3930805700D0, -7.350585340171D-05,  0.0000D+00,  642, 'R', & !  544
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6223208622D0, -7.350168508855D-05,  0.0000D+00,  640, 'R', & !  545
     &         -4.8D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.8106399560D0, -7.349485382959D-05, -5.9394D-23,  638, 'P', & !  546
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2616858442D0, -7.349389515368D-05,  0.0000D+00,  637, 'R', & !  547
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 3.4802014676D0, -7.349323682113D-05,  0.0000D+00,  635, 'R', & !  548
     &         -0.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.2218673592D0, -7.348490019482D-05,  0.0000D+00,  634, 'R', & !  549
     &         -0.6D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 2.2218673592D0, -7.348488474360D-05,  0.0000D+00,  633, 'R', & !  550
     &         -0.4D0,        -1.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 551, 560 ) &
     & /                             &
     & 1.6282007560D0, -7.348415686753D-05, -6.6669D-23,  632, 'P', & !  551
     &         29.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.7289468632D0, -7.347345990547D-05, -7.3944D-23,  630, 'P', & !  552
     &         98.7D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.7837826304D0, -7.346930487386D-05,  0.0000D+00,  629, 'R', & !  553
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.7837826304D0, -7.346929714825D-05,  0.0000D+00,  628, 'P', & !  554
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8214138562D0, -7.346809984986D-05,  0.0000D+00,  625, 'R', & !  555
     &          1.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.5465076632D0, -7.346276294341D-05, -8.1219D-23,  623, 'R', & !  556
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4209603532D0, -7.345131495612D-05,  0.0000D+00,  621, 'R', & !  557
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2455472218D0, -7.345096526872D-05, -1.1172D-22,  620, 'P', & !  558
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0226941094D0, -7.344471459403D-05,  0.0000D+00,  619, 'P', & !  559
     &          0.0D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344391215300D-05,  0.0000D+00,  618, 'R', & !  560
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 561, 570 ) &
     & /                             &
     & 1.3535682962D0, -7.344390442739D-05,  0.0000D+00,  617, 'R', & !  561
     &         -0.3D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 1.3535682962D0, -7.344389670178D-05,  0.0000D+00,  616, 'R', & !  562
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0205068502D0, -7.343451461117D-05,  0.0000D+00,  615, 'P', & !  563
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8559490734D0, -7.342522894295D-05,  0.0000D+00,  614, 'R', & !  564
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341932959878D-05,  0.0000D+00,  612, 'R', & !  565
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341932187317D-05,  0.0000D+00,  611, 'R', & !  566
     &          8.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5924797752D0, -7.341931414756D-05,  0.0000D+00,  610, 'P', & !  567
     &         -1.4D0,         5.9D0,        0.0D0,      0.0D0,     & !
     & 6.1145765614D0, -7.339473931896D-05,  0.0000D+00,  606, 'P', & !  568
     &          0.8D0,         2.8D0,        0.0D0,      0.0D0,     & !
     & 6.1145765614D0, -7.339473159335D-05,  0.0000D+00,  605, 'P', & !  569
     &        -16.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6843622272D0, -7.336935432370D-05,  0.0000D+00,  599, 'R', & !  570
     &          0.0D0,         1.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 571, 580 ) &
     & /                             &
     & 1.6843622272D0, -7.336933887249D-05,  0.0000D+00,  598, 'R', & !  571
     &          0.6D0,         2.0D0,        0.0D0,      0.0D0,     & !
     & 5.2228161068D0, -7.336215917200D-05,  2.6975D-23,  597, 'P', & !  572
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0403769068D0, -7.335146220994D-05,  1.9700D-23,  592, 'P', & !  573
     &       -187.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334476404388D-05,  0.0000D+00,  590, 'R', & !  574
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334475631827D-05,  0.0000D+00,  589, 'P', & !  575
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9232737062D0, -7.334474859266D-05,  0.0000D+00,  588, 'P', & !  576
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 0.3188175767D0, -7.334460448418D-05,  0.0000D+00,  587, 'R', & !  577
     &          0.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.5373332002D0, -7.334394615163D-05,  0.0000D+00,  586, 'R', & !  578
     &          0.8D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.8579377068D0, -7.334076524787D-05,  1.2425D-23,  585, 'P', & !  579
     &      -2140.9D0,         4.4D0,        0.0D0,      0.0D0,     & !
     & 4.4511287544D0, -7.334074622785D-05,  1.5628D-23,  584, 'P', & !  580
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 581, 590 ) &
     & /                             &
     & 2.1766981822D0, -7.333615621676D-05,  0.0000D+00,  582, 'R', & !  581
     &         -1.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6891237815D0, -7.333198790360D-05,  0.0000D+00,  581, 'R', & !  582
     &          0.8D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 4.9586838140D0, -7.333006828581D-05,  5.1496D-24,  579, 'R', & !  583
     &      -4356.7D0,         8.9D0,     3477.5D0,     -7.1D0,     & !
     & 1.8170911930D0, -7.333006055984D-05,  6.2124D-24,  578, 'R', & !  584
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.2686895544D0, -7.333004926579D-05,  8.3524D-24,  577, 'P', & !  585
     &         13.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1621851852D0, -7.332020466648D-05,  0.0000D+00,  572, 'R', & !  586
     &          0.6D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.1621851852D0, -7.332018148966D-05,  0.0000D+00,  571, 'P', & !  587
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1621851852D0, -7.332017376405D-05,  0.0000D+00,  570, 'P', & !  588
     &          0.0D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 5.8409143629D0, -7.332002965557D-05,  0.0000D+00,  569, 'R', & !  589
     &          0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.9432152724D0, -7.331948296413D-05,  0.0000D+00,  566, 'R', & !  590
     &          1.1D0,         3.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 591, 600 ) &
     & /                             &
     & 5.8376833160D0, -7.331937345715D-05,  0.0000D+00,  565, 'R', & !  591
     &          0.2D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.7762446140D0, -7.331937132375D-05, -2.1256D-24,  562, 'R', & !  592
     &     119084.1D0,      -208.7D0,  -282780.6D0,    579.9D0,     & !
     & 2.7762446792D0, -7.331937132302D-05,  0.0000D+00,  563, 'R', & !  593
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9979913495D0, -7.331936918888D-05,  0.0000D+00,  564, 'R', & !  594
     &         -0.2D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.9178373002D0, -7.331936359777D-05, -1.0628D-24,  560, 'R', & !  595
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 2.7762446792D0, -7.331936359741D-05,  0.0000D+00,  559, 'R', & !  596
     &          0.7D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 2.7762446792D0, -7.331936359741D-05,  0.0000D+00,  561, 'R', & !  597
     &         -1.0D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 2.7762446792D0, -7.331935587180D-05,  0.0000D+00,  558, 'R', & !  598
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0862503544D0, -7.331935230372D-05,  1.0772D-24,  557, 'R', & !  599
     &       1642.4D0,        -3.4D0,    -2656.9D0,      5.4D0,     & !
     & 5.8924593931D0, -7.331925968190D-05,  0.0000D+00,  556, 'R', & !  600
     &         -1.1D0,         3.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 601, 610 ) &
     & /                             &
     & 5.9472354702D0, -7.331914590665D-05,  0.0000D+00,  554, 'R', & !  601
     &          0.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.3903041732D0, -7.331853797955D-05,  0.0000D+00,  552, 'R', & !  602
     &         -0.7D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 3.6502614362D0, -7.331261228225D-05,  0.0000D+00,  550, 'R', & !  603
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.5938054140D0, -7.330867436169D-05, -9.4009D-24,  549, 'R', & !  604
     &         79.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.1869964615D0, -7.330865534166D-05, -6.1980D-24,  548, 'R', & !  605
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1302870428D0, -7.330756413905D-05, -3.1029D-23,  546, 'P', & !  606
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.8633655768D0, -7.330675474243D-05,  0.0000D+00,  545, 'R', & !  607
     &         -0.8D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 0.8633655768D0, -7.330673929122D-05,  0.0000D+00,  544, 'R', & !  608
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.5242781932D0, -7.330583779026D-05,  0.0000D+00,  542, 'R', & !  609
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3757911762D0, -7.330258642928D-05,  0.0000D+00,  541, 'R', & !  610
     &          1.5D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 611, 620 ) &
     & /                             &
     & 3.3757911762D0, -7.330257097806D-05,  0.0000D+00,  540, 'R', & !  611
     &          0.0D0,         3.7D0,        0.0D0,      0.0D0,     & !
     & 5.3982949502D0, -7.329907874949D-05,  0.0000D+00,  538, 'R', & !  612
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.6945515212D0, -7.329797739962D-05, -1.6676D-23,  537, 'R', & !  613
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2310331500D0, -7.329686717699D-05, -3.8304D-23,  535, 'R', & !  614
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 2.8860360202D0, -7.329685766698D-05, -3.6703D-23,  534, 'P', & !  615
     &          3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7675147788D0, -7.329575695436D-05, -5.9932D-23,  533, 'P', & !  616
     &        -35.1D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329479649441D-05,  0.0000D+00,  532, 'R', & !  617
     &         -0.7D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329478876880D-05,  0.0000D+00,  531, 'R', & !  618
     &          0.1D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329478104319D-05,  0.0000D+00,  530, 'R', & !  619
     &          9.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0151561582D0, -7.329477331758D-05,  0.0000D+00,  529, 'P', & !  620
     &         -1.9D0,         8.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 621, 630 ) &
     & /                             &
     & 5.2336717816D0, -7.329413816185D-05,  0.0000D+00,  528, 'R', & !  621
     &         -0.2D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.2336717816D0, -7.329412271063D-05,  0.0000D+00,  527, 'R', & !  622
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6292156522D0, -7.329396315094D-05,  0.0000D+00,  526, 'R', & !  623
     &         -0.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.7035968202D0, -7.328616070491D-05, -4.3978D-23,  525, 'R', & !  624
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328580153554D-05,  0.0000D+00,  524, 'R', & !  625
     &          0.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328579380993D-05,  0.0000D+00,  523, 'R', & !  626
     &          0.1D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 3.9753376732D0, -7.328578608432D-05,  0.0000D+00,  522, 'R', & !  627
     &         41.4D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.5850755788D0, -7.328505999229D-05, -6.7208D-23,  521, 'P', & !  628
     &       1293.4D0,        -2.7D0,      334.0D0,     -0.7D0,     & !
     & 3.3207926793D0, -7.328150613005D-05,  0.0000D+00,  519, 'R', & !  629
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6858216860D0, -7.327436303023D-05, -7.4483D-23,  516, 'P', & !  630
     &       4715.6D0,        -9.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 631, 640 ) &
     & /                             &
     & 1.2540676372D0, -7.327020621458D-05,  0.0000D+00,  515, 'R', & !  631
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327019848897D-05,  0.0000D+00,  514, 'P', & !  632
     &          1.1D0,         4.7D0,        0.0D0,      0.0D0,     & !
     & 1.2540676372D0, -7.327019076337D-05,  0.0000D+00,  513, 'P', & !  633
     &        -25.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.8681271312D0, -7.326938832233D-05,  0.0000D+00,  512, 'R', & !  634
     &          0.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.5748841702D0, -7.326900119059D-05,  0.0000D+00,  510, 'R', & !  635
     &          8.8D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 3.5033824860D0, -7.326366606817D-05, -8.1758D-23,  508, 'R', & !  636
     &       -142.7D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.3209432860D0, -7.325296910610D-05, -8.9033D-23,  507, 'R', & !  637
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1744306672D0, -7.325221629685D-05,  0.0000D+00,  506, 'R', & !  638
     &          1.2D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.1744306672D0, -7.325220084563D-05,  0.0000D+00,  505, 'P', & !  639
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2024220446D0, -7.325186839349D-05, -1.1226D-22,  504, 'P', & !  640
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 641, 650 ) &
     & /                             &
     & 0.4929791162D0, -7.324561593476D-05,  0.0000D+00,  502, 'P', & !  641
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1070386102D0, -7.324479804251D-05,  0.0000D+00,  500, 'R', & !  642
     &         -0.4D0,        -3.0D0,        0.0D0,      0.0D0,     & !
     & 0.2391131825D0, -7.323874686425D-05,  0.0000D+00,  499, 'R', & !  643
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7739771642D0, -7.323541595189D-05,  0.0000D+00,  498, 'P', & !  644
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6094193874D0, -7.322613028367D-05,  0.0000D+00,  497, 'R', & !  645
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3459500892D0, -7.322022321390D-05,  0.0000D+00,  496, 'R', & !  646
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.3459500892D0, -7.322021548829D-05,  0.0000D+00,  495, 'P', & !  647
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3459500892D0, -7.322020776268D-05,  0.0000D+00,  494, 'P', & !  648
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.1297742508D0, -7.321865777465D-05, -1.5412D-22,  492, 'P', & !  649
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2305203580D0, -7.320796081259D-05, -1.6139D-22,  491, 'P', & !  650
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 651, 660 ) &
     & /                             &
     & 0.7836611826D0, -7.320088167129D-05,  0.0000D+00,  490, 'R', & !  651
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6808657052D0, -7.319735460819D-05,  9.4721D-23,  489, 'P', & !  652
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5848615682D0, -7.319564065968D-05,  0.0000D+00,  488, 'P', & !  653
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5848615682D0, -7.319563293407D-05,  0.0000D+00,  487, 'P', & !  654
     &          0.0D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319483049304D-05,  0.0000D+00,  486, 'R', & !  655
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319482276743D-05,  0.0000D+00,  484, 'R', & !  656
     &         -0.2D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.1989210622D0, -7.319481504182D-05,  0.0000D+00,  483, 'P', & !  657
     &         -0.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.1539673875D0, -7.318826509070D-05,  0.0000D+00,  482, 'R', & !  658
     &          1.7D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 1.4984265052D0, -7.318665764613D-05,  8.7446D-23,  481, 'R', & !  659
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6202717412D0, -7.318093717527D-05,  7.2752D-24,  480, 'P', & !  660
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 661, 670 ) &
     & /                             &
     & 5.5991726124D0, -7.317596068407D-05,  8.0171D-23,  479, 'R', & !  661
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2410882851D0, -7.317564851012D-05,  0.0000D+00,  478, 'R', & !  662
     &          0.6D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 3.2410882851D0, -7.317563305891D-05,  0.0000D+00,  477, 'P', & !  663
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1974660638D0, -7.317485997145D-05,  5.6941D-23,  476, 'P', & !  664
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317024793882D-05,  0.0000D+00,  474, 'R', & !  665
     &         -0.1D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317024021321D-05,  0.0000D+00,  473, 'R', & !  666
     &        -66.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.4378325412D0, -7.317023248760D-05,  0.0000D+00,  471, 'P', & !  667
     &         -3.0D0,        14.2D0,        0.0D0,      0.0D0,     & !
     & 0.2962399202D0, -7.317023248724D-05,  1.0628D-24,  472, 'P', & !  668
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 4.2982121710D0, -7.316416300938D-05,  4.9666D-23,  469, 'P', & !  669
     &          6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3282091827D0, -7.316303192954D-05,  0.0000D+00,  468, 'R', & !  670
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 671, 680 ) &
     & /                             &
     & 1.3282091827D0, -7.316301647832D-05,  0.0000D+00,  467, 'P', & !  671
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3306219992D0, -7.315384245122D-05,  0.0000D+00,  464, 'R', & !  672
     &          0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.1157729710D0, -7.315346604732D-05,  4.2391D-23,  463, 'R', & !  673
     &          8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9972517296D0, -7.315236533470D-05,  1.9161D-23,  462, 'P', & !  674
     &          7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6985153876D0, -7.315041534896D-05,  0.0000D+00,  460, 'R', & !  675
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1126076310D0, -7.314775452027D-05,  5.1496D-24,  459, 'R', & !  676
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314566538460D-05,  0.0000D+00,  458, 'R', & !  677
     &          1.9D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314565765899D-05,  0.0000D+00,  456, 'P', & !  678
     &          2.4D0,         9.6D0,        0.0D0,      0.0D0,     & !
     & 5.8183367064D0, -7.314565765863D-05,  1.0628D-24,  457, 'P', & !  679
     &          0.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 2.6767440202D0, -7.314564993338D-05,  0.0000D+00,  455, 'P', & !  680
     &        -48.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 681, 690 ) &
     & /                             &
     & 2.0722878907D0, -7.314550582491D-05,  0.0000D+00,  454, 'R', & !  681
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314484749235D-05,  0.0000D+00,  453, 'R', & !  682
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314483976674D-05,  0.0000D+00,  452, 'R', & !  683
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2908035142D0, -7.314483204113D-05,  0.0000D+00,  451, 'P', & !  684
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 6.2165190782D0, -7.314276908526D-05,  3.5116D-23,  450, 'R', & !  685
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5265248185D0, -7.314275006523D-05,  3.8319D-23,  449, 'R', & !  686
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8148125296D0, -7.314166837264D-05,  1.1886D-23,  448, 'P', & !  687
     &         91.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4080035772D0, -7.314164935261D-05,  1.5089D-23,  447, 'P', & !  688
     &       -118.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.9301684962D0, -7.313705755748D-05,  0.0000D+00,  446, 'R', & !  689
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9301684962D0, -7.313704210626D-05,  0.0000D+00,  444, 'R', & !  690
     &          0.9D0,         1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 691, 700 ) &
     & /                             &
     & 0.4943048854D0, -7.313495297059D-05, -5.1496D-24,  443, 'P', & !  691
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1594087884D0, -7.313288924432D-05,  0.0000D+00,  441, 'R', & !  692
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1594087884D0, -7.313287379311D-05,  0.0000D+00,  440, 'R', & !  693
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9155586368D0, -7.313097141057D-05,  4.6109D-24,  439, 'R', & !  694
     &        200.9D0,         0.5D0,     -382.9D0,     -0.9D0,     & !
     & 3.5705615070D0, -7.313096190056D-05,  6.2124D-24,  438, 'R', & !  695
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2255643772D0, -7.313095239055D-05,  7.8138D-24,  437, 'P', & !  696
     &       2775.1D0,        12.4D0,     -382.9D0,     -0.9D0,     & !
     & 1.8727571828D0, -7.312518218779D-05,  0.0000D+00,  435, 'R', & !  697
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6782020102D0, -7.312352402473D-05,  0.0000D+00,  434, 'R', & !  698
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9156554992D0, -7.312109055599D-05,  0.0000D+00,  433, 'R', & !  699
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9156554992D0, -7.312107510478D-05,  0.0000D+00,  432, 'P', & !  700
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 701, 710 ) &
     & /                             &
     & 1.4135002793D0, -7.312036885364D-05,  0.0000D+00,  429, 'P', & !  701
     &          2.4D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 2.7331194368D0, -7.312027444851D-05, -2.6643D-24,  428, 'R', & !  702
     &      -2436.2D0,       -12.7D0,     7850.6D0,     53.2D0,     & !
     & 4.5297149932D0, -7.312025721252D-05,  0.0000D+00,  427, 'R', & !  703
     &          1.0D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 0.0431251772D0, -7.312025542848D-05,  5.3862D-25,  426, 'R', & !  704
     &     160354.2D0,      1605.0D0,  -125116.7D0,   -849.0D0,     & !
     & 4.5297149932D0, -7.312024948692D-05,  0.0000D+00,  425, 'P', & !  705
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3627443999D0, -7.312014557141D-05,  0.0000D+00,  423, 'R', & !  706
     &          2.7D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.4175204770D0, -7.312003179616D-05,  0.0000D+00,  422, 'R', & !  707
     &         -1.6D0,        -3.9D0,        0.0D0,      0.0D0,     & !
     & 0.8605891800D0, -7.311942386906D-05,  0.0000D+00,  420, 'P', & !  708
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9246039358D0, -7.311915471587D-05, -2.2691D-23,  419, 'P', & !  709
     &          6.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.7992750908D0, -7.311833759400D-05,  7.2752D-24,  418, 'P', & !  710
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 711, 720 ) &
     & /                             &
     & 1.0285153830D0, -7.311416928085D-05,  7.2752D-24,  417, 'P', & !  711
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4037317502D0, -7.311349817176D-05,  0.0000D+00,  416, 'R', & !  712
     &        -10.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5506802368D0, -7.310957748645D-05, -9.9395D-24,  415, 'R', & !  713
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1438712844D0, -7.310955846642D-05, -6.7366D-24,  414, 'R', & !  714
     &        717.7D0,        18.4D0,     -901.5D0,    -17.7D0,     & !
     & 5.0253500430D0, -7.310845775380D-05, -2.9966D-23,  413, 'P', & !  715
     &       -218.4D0,        -4.9D0,        0.0D0,      0.0D0,     & !
     & 2.6168358908D0, -7.310764063194D-05,  0.0000D+00,  412, 'R', & !  716
     &        -54.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 6.2777485072D0, -7.310673913099D-05,  0.0000D+00,  411, 'R', & !  717
     &         -1.0D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 5.9510656722D0, -7.310637934598D-05,  7.2752D-24,  410, 'P', & !  718
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 1.9582706992D0, -7.310369773515D-05,  0.0000D+00,  409, 'R', & !  719
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1292614902D0, -7.310347231879D-05,  0.0000D+00,  407, 'R', & !  720
     &       -197.6D0,       -14.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 721, 730 ) &
     & /                             &
     & 5.1292614902D0, -7.310346459318D-05,  0.0000D+00,  406, 'P', & !  721
     &          0.1D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 2.0170669740D0, -7.310324690242D-05,  0.0000D+00,  405, 'R', & !  722
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8685799570D0, -7.309998009022D-05,  0.0000D+00,  404, 'R', & !  723
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9614320844D0, -7.309886150436D-05, -1.4012D-23,  403, 'R', & !  724
     &         -9.9D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.8429108430D0, -7.309776079174D-05, -3.7241D-23,  402, 'P', & !  725
     &       -521.6D0,       -67.2D0,        0.0D0,      0.0D0,     & !
     & 1.6280618800D0, -7.309738438711D-05,  7.2752D-24,  401, 'P', & !  726
     &         -0.1D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309568238391D-05,  0.0000D+00,  398, 'R', & !  727
     &        -16.9D0,        77.3D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309567465831D-05,  0.0000D+00,  397, 'P', & !  728
     &         -4.0D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 3.7686264722D0, -7.309566693270D-05,  0.0000D+00,  396, 'P', & !  729
     &          0.4D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 0.7039567885D0, -7.309502405136D-05,  0.0000D+00,  395, 'R', & !  730
     &        -21.6D0,         7.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 731, 740 ) &
     & /                             &
     & 2.9468222902D0, -7.309277535672D-05, -7.2752D-24,  393, 'R', & !  731
     &         -1.6D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 0.6604716430D0, -7.308706382968D-05, -4.4517D-23,  392, 'R', & !  732
     &          3.7D0,        -5.0D0,        0.0D0,      0.0D0,     & !
     & 5.7288079872D0, -7.308668742505D-05,  0.0000D+00,  391, 'R', & !  733
     &        -20.4D0,       -30.9D0,        0.0D0,      0.0D0,     & !
     & 5.7288079872D0, -7.308667197383D-05,  0.0000D+00,  390, 'P', & !  734
     &         -0.8D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 5.0742629933D0, -7.308240747077D-05,  0.0000D+00,  388, 'R', & !  735
     &         -0.6D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.0742629933D0, -7.308239201956D-05,  0.0000D+00,  387, 'P', & !  736
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.5208512728D0, -7.308098662585D-05,  5.1496D-24,  386, 'R', & !  737
     &         -0.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.5463687872D0, -7.307599046298D-05, -7.2752D-24,  384, 'R', & !  738
     &         -0.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6426965088D0, -7.307526615499D-05, -7.5021D-23,  383, 'P', & !  739
     &         -5.9D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.9527022492D0, -7.307524713497D-05, -7.1819D-23,  382, 'P', & !  740
     &          0.5D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 741, 750 ) &
     & /                             &
     & 3.0075379512D0, -7.307110755531D-05,  0.0000D+00,  381, 'R', & !  741
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.0075379512D0, -7.307109982970D-05,  0.0000D+00,  380, 'P', & !  742
     &         -1.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.0075379512D0, -7.307109210409D-05,  0.0000D+00,  379, 'P', & !  743
     &          0.5D0,        -5.7D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028966305D-05,  0.0000D+00,  378, 'R', & !  744
     &          2.4D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.4800047590D0, -7.307028193781D-05, -1.0628D-24,  377, 'R', & !  745
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307028193745D-05,  0.0000D+00,  376, 'R', & !  746
     &         -0.5D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 5.6215974452D0, -7.307027421184D-05,  0.0000D+00,  375, 'P', & !  747
     &         -0.3D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306990253131D-05,  0.0000D+00,  374, 'R', & !  748
     &         -1.9D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306989480570D-05,  0.0000D+00,  373, 'P', & !  749
     &          0.1D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.0451691770D0, -7.306988708009D-05,  0.0000D+00,  372, 'P', & !  750
     &        -15.5D0,        -1.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 751, 760 ) &
     & /                             &
     & 3.1613838909D0, -7.306979089019D-05,  0.0000D+00,  371, 'R', & !  751
     &          0.0D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 3.1613838909D0, -7.306977543898D-05,  0.0000D+00,  370, 'P', & !  752
     &         -0.6D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.1898433964D0, -7.306611739619D-05,  7.4483D-23,  369, 'R', & !  753
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4602573088D0, -7.306456919293D-05, -8.2297D-23,  367, 'R', & !  754
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7702630492D0, -7.306455017290D-05, -7.9094D-23,  366, 'P', & !  755
     &        -21.9D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.1459153494D0, -7.305919011730D-05, -5.1496D-24,  365, 'P', & !  756
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2485047886D0, -7.305717430961D-05,  0.0000D+00,  364, 'R', & !  757
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.2485047886D0, -7.305715885839D-05,  0.0000D+00,  363, 'P', & !  758
     &         -0.2D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 0.7597628170D0, -7.305639634529D-05,  7.2752D-24,  362, 'P', & !  759
     &          3.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.8710091564D0, -7.305385321084D-05, -8.6369D-23,  360, 'P', & !  760
     &          3.8D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 761, 770 ) &
     & /                             &
     & 0.6447156740D0, -7.305311763757D-05,  0.0000D+00,  359, 'R', & !  761
     &         -0.3D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.6447156740D0, -7.305310218635D-05,  0.0000D+00,  358, 'P', & !  762
     &         -5.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 3.9054625989D0, -7.305226478556D-05,  0.0000D+00,  357, 'R', & !  763
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.7189162380D0, -7.304570710920D-05, -1.0628D-24,  356, 'R', & !  764
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304570710884D-05,  0.0000D+00,  355, 'R', & !  765
     &          0.2D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304569938323D-05,  0.0000D+00,  354, 'R', & !  766
     &        123.7D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304569165762D-05,  0.0000D+00,  352, 'P', & !  767
     &         -5.0D0,        20.7D0,        0.0D0,      0.0D0,     & !
     & 1.7189163032D0, -7.304569165725D-05,  1.0628D-24,  353, 'P', & !  768
     &         -1.1D0,         4.0D0,        0.0D0,      0.0D0,     & !
     & 4.8605089242D0, -7.304568393201D-05,  0.0000D+00,  351, 'P', & !  769
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6188109934D0, -7.304454227781D-05,  0.0000D+00,  350, 'P', & !  770
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 771, 780 ) &
     & /                             &
     & 2.6885699564D0, -7.304315624878D-05, -9.3644D-23,  349, 'R', & !  771
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5700487150D0, -7.304205553616D-05, -1.1687D-22,  348, 'P', & !  772
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9925834965D0, -7.303963275376D-05,  0.0000D+00,  346, 'P', & !  773
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.2442621710D0, -7.303631729262D-05,  0.0000D+00,  345, 'P', & !  774
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6780697242D0, -7.303500242117D-05, -7.2752D-24,  344, 'R', & !  775
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8196624104D0, -7.303499469519D-05, -6.2124D-24,  343, 'R', & !  776
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.2690882736D0, -7.303025786148D-05, -1.4738D-22,  342, 'P', & !  777
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0797043942D0, -7.302701617318D-05,  0.0000D+00,  341, 'R', & !  778
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.2479891448D0, -7.302528137027D-05, -7.4483D-23,  340, 'P', & !  779
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302112455462D-05,  0.0000D+00,  339, 'R', & !  780
     &         -4.1D0,         1.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 781, 790 ) &
     & /                             &
     & 4.0994204032D0, -7.302111682901D-05,  0.0000D+00,  338, 'P', & !  781
     &          3.4D0,        13.8D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302111682901D-05,  0.0000D+00,  336, 'P', & !  782
     &          1.9D0,         8.3D0,        0.0D0,      0.0D0,     & !
     & 0.9578277822D0, -7.302111682865D-05,  1.0628D-24,  337, 'P', & !  783
     &          1.5D0,         5.9D0,        0.0D0,      0.0D0,     & !
     & 4.0994204032D0, -7.302110910340D-05,  0.0000D+00,  335, 'P', & !  784
     &        -91.9D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 0.4302945900D0, -7.302030666237D-05,  0.0000D+00,  334, 'R', & !  785
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 0.4302945900D0, -7.302029893676D-05,  0.0000D+00,  332, 'R', & !  786
     &          0.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.4500105990D0, -7.301439959259D-05,  0.0000D+00,  331, 'R', & !  787
     &         -2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0585738894D0, -7.301041986658D-05, -6.2124D-24,  330, 'R', & !  788
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.9169812684D0, -7.301041214061D-05, -5.1496D-24,  329, 'P', & !  789
     &         -5.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8201797280D0, -7.300895469502D-05,  1.0146D-22,  328, 'P', & !  790
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 791, 800 ) &
     & /                             &
     & 2.5371314966D0, -7.300178301201D-05,  0.0000D+00,  327, 'R', & !  791
     &         -6.3D0,         3.6D0,        0.0D0,      0.0D0,     & !
     & 6.0177273755D0, -7.299971517855D-05, -1.2425D-23,  326, 'R', & !  792
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6377405280D0, -7.299825773295D-05,  9.4183D-23,  325, 'P', & !  793
     &       -163.2D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.3383318822D0, -7.299654200040D-05,  0.0000D+00,  324, 'P', & !  794
     &          0.0D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 3.3383318822D0, -7.299653427479D-05,  0.0000D+00,  323, 'P', & !  795
     &          3.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299571638254D-05,  0.0000D+00,  320, 'P', & !  796
     &         -2.0D0,        -8.1D0,        0.0D0,      0.0D0,     & !
     & 5.9523913762D0, -7.299570865693D-05,  0.0000D+00,  318, 'P', & !  797
     &          2.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.8107987552D0, -7.299570865657D-05,  1.0628D-24,  319, 'P', & !  798
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6242523943D0, -7.298916643143D-05,  0.0000D+00,  317, 'R', & !  799
     &         -1.9D0,         3.2D0,        0.0D0,      0.0D0,     & !
     & 0.6242523943D0, -7.298915870582D-05,  0.0000D+00,  316, 'P', & !  800
     &         -0.2D0,        -0.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 801, 810 ) &
     & /                             &
     & 0.6242523943D0, -7.298915098021D-05,  0.0000D+00,  315, 'P', & !  801
     &         -3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4553013280D0, -7.298756077089D-05,  8.6908D-23,  312, 'R', & !  802
     &      -1037.9D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 0.3837996438D0, -7.298222564847D-05,  5.1496D-24,  309, 'R', & !  803
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0905567480D0, -7.298183851600D-05,  7.2752D-24,  308, 'P', & !  804
     &          0.0D0,         4.1D0,        0.0D0,      0.0D0,     & !
     & 5.5560474352D0, -7.297686380883D-05,  7.9632D-23,  307, 'R', & !  805
     &      -1449.7D0,        -1.8D0,      741.5D0,      0.9D0,     & !
     & 2.8660531755D0, -7.297684478880D-05,  8.2835D-23,  306, 'P', & !  806
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9945585991D0, -7.297654985084D-05,  0.0000D+00,  305, 'R', & !  807
     &          0.0D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 4.9945585991D0, -7.297654212524D-05,  0.0000D+00,  304, 'P', & !  808
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9945585991D0, -7.297653439963D-05,  0.0000D+00,  303, 'P', & !  809
     &         -3.2D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 3.1657853408D0, -7.297613771680D-05,  1.2425D-23,  302, 'P', & !  810
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 811, 820 ) &
     & /                             &
     & 1.3683311023D0, -7.297162487558D-05,  0.0000D+00,  300, 'P', & !  811
     &         -0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.4845458162D0, -7.297152868568D-05,  0.0000D+00,  299, 'R', & !  812
     &          1.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.3429531300D0, -7.297152096044D-05, -1.0628D-24,  297, 'R', & !  813
     &          0.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.4845458162D0, -7.297152096007D-05,  0.0000D+00,  298, 'R', & !  814
     &         -0.9D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 4.4845458162D0, -7.297152096007D-05,  0.0000D+00,  296, 'R', & !  815
     &          0.6D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297114927954D-05,  0.0000D+00,  295, 'R', & !  816
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297114155393D-05,  0.0000D+00,  294, 'R', & !  817
     &          0.7D0,        58.0D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297113382833D-05,  0.0000D+00,  292, 'P', & !  818
     &         -6.6D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 2.0497102342D0, -7.297113382796D-05,  1.0628D-24,  293, 'P', & !  819
     &         -3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1913028552D0, -7.297112610272D-05,  0.0000D+00,  291, 'P', & !  820
     &         -0.9D0,        -2.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 821, 830 ) &
     & /                             &
     & 1.5221770420D0, -7.297032366168D-05,  0.0000D+00,  290, 'R', & !  821
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5221770420D0, -7.297031593607D-05,  0.0000D+00,  289, 'R', & !  822
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.1259668558D0, -7.296714275793D-05,  1.2425D-23,  288, 'P', & !  823
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3736082352D0, -7.296616684676D-05,  7.2357D-23,  287, 'R', & !  824
     &         21.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2320156142D0, -7.296615912079D-05,  7.3420D-23,  286, 'R', & !  825
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.6836139755D0, -7.296614782674D-05,  7.5560D-23,  285, 'R', & !  826
     &        -21.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9833461408D0, -7.296544075474D-05,  5.1496D-24,  284, 'R', & !  827
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1249388270D0, -7.296543302876D-05,  6.2124D-24,  283, 'P', & !  828
     &          0.3D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.2550869938D0, -7.296506613415D-05,  4.9128D-23,  282, 'P', & !  829
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9100898640D0, -7.296505662413D-05,  5.0729D-23,  281, 'P', & !  830
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 831, 840 ) &
     & /                             &
     & 3.0816794967D0, -7.296393327026D-05,  0.0000D+00,  280, 'R', & !  831
     &          0.7D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 3.0816794967D0, -7.296392554465D-05,  0.0000D+00,  279, 'P', & !  832
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0816794967D0, -7.296391781905D-05,  0.0000D+00,  278, 'P', & !  833
     &         -1.5D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 3.0088636552D0, -7.296044459187D-05, -7.2752D-24,  277, 'R', & !  834
     &          0.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 6.1504563414D0, -7.296043686590D-05, -6.2124D-24,  276, 'R', & !  835
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7386373071D0, -7.295902374621D-05,  0.0000D+00,  275, 'R', & !  836
     &          0.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.7386373071D0, -7.295901602060D-05,  0.0000D+00,  274, 'R', & !  837
     &          0.8D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.7386373071D0, -7.295901602060D-05,  0.0000D+00,  272, 'R', & !  838
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7386373071D0, -7.295900829500D-05,  0.0000D+00,  271, 'P', & !  839
     &          0.0D0,         2.9D0,        0.0D0,      0.0D0,     & !
     & 3.4710609132D0, -7.295725596141D-05,  8.3380D-24,  270, 'P', & !  840
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 841, 850 ) &
     & /                             &
     & 6.0081974047D0, -7.295708867648D-05,  7.2752D-24,  268, 'P', & !  841
     &          0.9D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 2.9435276558D0, -7.295644579587D-05,  5.1496D-24,  267, 'R', & !  842
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0851203420D0, -7.295643806989D-05,  6.2124D-24,  266, 'P', & !  843
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 2.9435277210D0, -7.295643034392D-05,  7.2752D-24,  265, 'P', & !  844
     &          1.7D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.7843600827D0, -7.295545086468D-05,  6.8285D-23,  264, 'R', & !  845
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295474379194D-05,  0.0000D+00,  261, 'R', & !  846
     &          9.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9424996270D0, -7.295473606670D-05, -1.0628D-24,  259, 'R', & !  847
     &          0.8D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295473606633D-05,  0.0000D+00,  260, 'R', & !  848
     &         -5.6D0,       -30.1D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295473606633D-05,  0.0000D+00,  258, 'R', & !  849
     &          4.0D0,        21.2D0,        0.0D0,      0.0D0,     & !
     & 5.0840923132D0, -7.295472834072D-05,  0.0000D+00,  257, 'R', & !  850
     &         -2.4D0,         2.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 851, 860 ) &
     & /                             &
     & 2.0726477938D0, -7.295436917208D-05,  4.1852D-23,  255, 'R', & !  851
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7276506640D0, -7.295435966207D-05,  4.3454D-23,  254, 'R', & !  852
     &          0.0D0,        31.4D0,        0.0D0,      0.0D0,     & !
     & 0.2641322928D0, -7.295324943944D-05,  2.1826D-23,  253, 'P', & !  853
     &         31.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8992403619D0, -7.295322085625D-05, -5.1496D-24,  252, 'P', & !  854
     &         -0.2D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 5.1216418144D0, -7.295263331328D-05,  7.4483D-23,  251, 'R', & !  855
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7949589794D0, -7.295227352827D-05,  8.1758D-23,  250, 'P', & !  856
     &         -3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6112724140D0, -7.295143968177D-05,  0.0000D+00,  249, 'R', & !  857
     &          0.5D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.6112724140D0, -7.295142423056D-05,  0.0000D+00,  248, 'P', & !  858
     &          0.9D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 1.1688003944D0, -7.295131668968D-05,  0.0000D+00,  247, 'R', & !  859
     &          0.9D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.1688003944D0, -7.295130123846D-05,  0.0000D+00,  246, 'P', & !  860
     &          0.0D0,         2.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 861, 870 ) &
     & /                             &
     & 4.7244853240D0, -7.294864813502D-05,  6.2124D-24,  244, 'P', & !  861
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.5828927030D0, -7.294864040905D-05,  7.2752D-24,  243, 'P', & !  862
     &         -0.9D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 4.7244853892D0, -7.294863268307D-05,  8.3380D-24,  242, 'P', & !  863
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294656672532D-05,  0.0000D+00,  241, 'R', & !  864
     &         -1.3D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655899972D-05,  0.0000D+00,  240, 'P', & !  865
     &        -16.7D0,         3.2D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655899972D-05,  0.0000D+00,  238, 'P', & !  866
     &         -3.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.2886217132D0, -7.294655899935D-05,  1.0628D-24,  239, 'P', & !  867
     &        -31.4D0,         5.9D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655127411D-05,  0.0000D+00,  237, 'P', & !  868
     &          1.2D0,       -26.5D0,        0.0D0,      0.0D0,     & !
     & 4.4302143342D0, -7.294655127411D-05,  0.0000D+00,  235, 'P', & !  869
     &          1.1D0,       -25.6D0,        0.0D0,      0.0D0,     & !
     & 4.4302143994D0, -7.294655127338D-05,  2.1256D-24,  236, 'P', & !  870
     &          0.0D0,         2.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 871, 880 ) &
     & /                             &
     & 3.8257582047D0, -7.294640716563D-05,  0.0000D+00,  234, 'R', & !  871
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6841655185D0, -7.294639944039D-05, -1.0628D-24,  232, 'R', & !  872
     &         -0.3D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294639944002D-05,  0.0000D+00,  233, 'R', & !  873
     &          0.9D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294639944002D-05,  0.0000D+00,  231, 'R', & !  874
     &         -0.6D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294639171441D-05,  0.0000D+00,  230, 'P', & !  875
     &          8.2D0,        14.6D0,        0.0D0,      0.0D0,     & !
     & 3.8257582047D0, -7.294638398881D-05,  0.0000D+00,  228, 'P', & !  876
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6841655837D0, -7.294638398844D-05,  1.0628D-24,  229, 'P', & !  877
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294574883307D-05,  0.0000D+00,  227, 'R', & !  878
     &         17.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9026811420D0, -7.294574110783D-05, -1.0628D-24,  223, 'R', & !  879
     &          0.2D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294574110746D-05,  0.0000D+00,  224, 'R', & !  880
     &         -0.6D0,         1.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 881, 890 ) &
     & /                             &
     & 0.7610885210D0, -7.294573338186D-05,  0.0000D+00,  222, 'P', & !  881
     &         13.9D0,         4.5D0,        0.0D0,      0.0D0,     & !
     & 0.7610885210D0, -7.294572565625D-05,  0.0000D+00,  221, 'P', & !  882
     &          1.0D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 3.9026812072D0, -7.294572565588D-05,  1.0628D-24,  220, 'P', & !  883
     &          2.1D0,        -3.3D0,        0.0D0,      0.0D0,     & !
     & 3.5759983070D0, -7.294538132282D-05,  6.2124D-24,  218, 'P', & !  884
     &          0.4D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.9537256162D0, -7.294447982187D-05,  6.2124D-24,  216, 'P', & !  885
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.0953183024D0, -7.294447209589D-05,  7.2752D-24,  215, 'P', & !  886
     &          8.3D0,         7.9D0,        0.0D0,      0.0D0,     & !
     & 0.9537256814D0, -7.294446436992D-05,  8.3380D-24,  214, 'P', & !  887
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8283967712D0, -7.294366270001D-05,  3.6179D-23,  211, 'R', & !  888
     &          0.0D0,       114.5D0,        0.0D0,      0.0D0,     & !
     & 3.4833996414D0, -7.294365318999D-05,  3.7780D-23,  210, 'R', & !  889
     &        313.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4719551872D0, -7.294327856940D-05,  8.1758D-23,  209, 'P', & !  890
     &        -12.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 891, 900 ) &
     & /                             &
     & 1.2486636861D0, -7.294266411849D-05,  1.4550D-23,  208, 'P', & !  891
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 0.7716873525D0, -7.294257149740D-05,  1.1348D-23,  207, 'P', & !  892
     &          9.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3648784000D0, -7.294255247737D-05,  1.4550D-23,  206, 'P', & !  893
     &    -417593.5D0,      -137.8D0,    29782.4D0,     10.7D0,     & !
     & 1.1979078067D0, -7.294244083626D-05,  1.4550D-23,  205, 'P', & !  894
     &          0.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 2.6125197794D0, -7.294157656621D-05,  7.4483D-23,  204, 'R', & !  895
     &        -13.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6611350362D0, -7.294145112677D-05,  0.0000D+00,  203, 'R', & !  896
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.5195423500D0, -7.294144340153D-05, -1.0628D-24,  201, 'R', & !  897
     &          0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6611350362D0, -7.294144340116D-05,  0.0000D+00,  202, 'R', & !  898
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5489405200D0, -7.294121025919D-05,  0.0000D+00,  200, 'R', & !  899
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8310354028D0, -7.294091823365D-05,  7.4483D-23,  199, 'R', & !  900
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 901, 910 ) &
     & /                             &
     & 0.4288332792D0, -7.294072726776D-05, -5.1496D-24,  198, 'P', & !  901
     &          0.2D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 5.2695465667D0, -7.294060427567D-05, -5.1496D-24,  197, 'P', & !  902
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 6.1005955005D0, -7.293899861513D-05,  8.1758D-23,  196, 'P', & !  903
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5391065992D0, -7.293870010910D-05,  0.0000D+00,  195, 'R', & !  904
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5391065992D0, -7.293868465788D-05,  0.0000D+00,  194, 'P', & !  905
     &          0.9D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.4500150640D0, -7.293862228205D-05,  6.2124D-24,  193, 'P', & !  906
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3084224430D0, -7.293861455608D-05,  7.2752D-24,  192, 'P', & !  907
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 4.4500151292D0, -7.293860683010D-05,  8.3380D-24,  191, 'P', & !  908
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293795889820D-05,  0.0000D+00,  190, 'R', & !  909
     &         -0.6D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.5420461240D0, -7.293795117296D-05, -1.0628D-24,  188, 'R', & !  910
     &          0.1D0,         1.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 911, 920 ) &
     & /                             &
     & 5.6836388102D0, -7.293795117259D-05,  0.0000D+00,  189, 'R', & !  911
     &         -0.7D0,        -6.5D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293795117259D-05,  0.0000D+00,  187, 'R', & !  912
     &          0.6D0,         4.7D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293794344699D-05,  0.0000D+00,  186, 'R', & !  913
     &         -8.7D0,        23.8D0,        0.0D0,      0.0D0,     & !
     & 5.6836388102D0, -7.293793572138D-05,  0.0000D+00,  185, 'P', & !  914
     &          2.9D0,        11.7D0,        0.0D0,      0.0D0,     & !
     & 2.5420461892D0, -7.293793572101D-05,  1.0628D-24,  184, 'P', & !  915
     &         11.3D0,        43.4D0,        0.0D0,      0.0D0,     & !
     & 2.5714442940D0, -7.293771803062D-05,  0.0000D+00,  183, 'R', & !  916
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 4.4687898472D0, -7.293756704236D-05,  4.4517D-23,  182, 'P', & !  917
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1771620019D0, -7.293732899607D-05, -6.7208D-23,  181, 'P', & !  918
     &          0.2D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 3.2933767158D0, -7.293721735496D-05, -6.7208D-23,  180, 'P', & !  919
     &         11.8D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 5.8086666968D0, -7.293678049058D-05,  7.2752D-24,  179, 'P', & !  920
     &          1.2D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 921, 930 ) &
     & /                             &
     & 0.3310079416D0, -7.293601233096D-05, -6.7208D-23,  178, 'P', & !  921
     &         -2.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.2477751342D0, -7.293586976326D-05, -7.2752D-24,  177, 'R', & !  922
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.3893678204D0, -7.293586203729D-05, -6.2124D-24,  176, 'R', & !  923
     &          3.4D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 2.2477751994D0, -7.293585431131D-05, -5.1496D-24,  175, 'P', & !  924
     &          3.9D0,       -98.1D0,        0.0D0,      0.0D0,     & !
     & 1.6433190047D0, -7.293569475235D-05, -7.2752D-24,  174, 'R', & !  925
     &          0.4D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 4.8618346282D0, -7.293503641979D-05, -7.2752D-24,  172, 'R', & !  926
     &          0.6D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7202420072D0, -7.293502869382D-05, -6.2124D-24,  171, 'P', & !  927
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293469208600D-05,  0.0000D+00,  170, 'R', & !  928
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3935591070D0, -7.293468436076D-05, -1.0628D-24,  168, 'R', & !  929
     &          1.7D0,         3.7D0,        0.0D0,      0.0D0,     & !
     & 4.5351517932D0, -7.293468436039D-05,  0.0000D+00,  169, 'R', & !  930
     &         -1.6D0,        -3.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 931, 940 ) &
     & /                             &
     & 1.3935591722D0, -7.293466890881D-05,  1.0628D-24,  167, 'P', & !  931
     &         -0.8D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.3213932545D0, -7.293459225569D-05, -2.9966D-23,  166, 'P', & !  932
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2567235708D0, -7.293393392313D-05, -2.9966D-23,  165, 'P', & !  933
     &          0.0D0,         5.3D0,        0.0D0,      0.0D0,     & !
     & 5.0544717234D0, -7.293378285980D-05, -1.0628D-24,  163, 'R', & !  934
     &          0.2D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 1.9128791024D0, -7.293378285944D-05,  0.0000D+00,  164, 'R', & !  935
     &         -0.1D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 1.9128791024D0, -7.293377513383D-05,  0.0000D+00,  162, 'P', & !  936
     &         43.1D0,        41.3D0,        0.0D0,      0.0D0,     & !
     & 1.9128791024D0, -7.293376740822D-05,  0.0000D+00,  160, 'P', & !  937
     &         -5.3D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 5.0544717885D0, -7.293376740786D-05,  1.0628D-24,  161, 'P', & !  938
     &        -61.5D0,        18.1D0,        0.0D0,      0.0D0,     & !
     & 2.6459575712D0, -7.293296573794D-05,  2.8903D-23,  159, 'R', & !  939
     &          0.0D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 1.3009604414D0, -7.293295622793D-05,  3.0505D-23,  158, 'R', & !  940
     &        -42.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 941, 950 ) &
     & /                             &
     & 5.8515650132D0, -7.293268885878D-05,  7.2752D-24,  157, 'P', & !  941
     &          8.9D0,        12.7D0,        0.0D0,      0.0D0,     & !
     & 2.7099723922D0, -7.293268113280D-05,  8.3380D-24,  156, 'P', & !  942
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5556208047D0, -7.293258472040D-05,  3.8314D-23,  154, 'P', & !  943
     &        -12.7D0,        -6.3D0,        0.0D0,      0.0D0,     & !
     & 4.5727012944D0, -7.293258160734D-05,  7.4483D-23,  153, 'R', & !  944
     &        -42.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2471088837D0, -7.293251384787D-05,  7.2752D-24,  152, 'P', & !  945
     &          2.1D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 1.4605067782D0, -7.293235619097D-05,  7.4483D-23,  151, 'R', & !  946
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8855207223D0, -7.293216174732D-05,  8.7970D-23,  150, 'P', & !  947
     &         -0.8D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.1530410300D0, -7.293208865765D-05,  6.2124D-24,  149, 'P', & !  948
     &          0.9D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 5.2946337162D0, -7.293208093168D-05,  7.2752D-24,  148, 'P', & !  949
     &         16.4D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 5.3494097933D0, -7.293196715643D-05,  7.2752D-24,  147, 'P', & !  950
     &         18.5D0,        65.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 951, 960 ) &
     & /                             &
     & 1.1951981013D0, -7.293195965369D-05, -2.3764D-23,  146, 'P', & !  951
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8724334596D0, -7.293187453534D-05,  4.0723D-24,  145, 'R', & !  952
     &         39.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1824392000D0, -7.293185551531D-05,  7.2752D-24,  143, 'P', & !  953
     &   38905112.0D0,      6951.1D0,  6034815.2D0,   1022.3D0,     & !
     & 5.7756302475D0, -7.293183649528D-05,  1.0478D-23,  142, 'P', & !  954
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1696802987D0, -7.293175137693D-05,  3.8314D-23,  141, 'P', & !  955
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2986539139D0, -7.293174387419D-05,  7.2752D-24,  140, 'P', & !  956
     &        -19.0D0,        67.1D0,        0.0D0,      0.0D0,     & !
     & 5.3534299910D0, -7.293163009894D-05,  7.2752D-24,  139, 'P', & !  957
     &        -17.2D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 2.2118373700D0, -7.293162237297D-05,  8.3380D-24,  138, 'P', & !  958
     &          0.5D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.7625429849D0, -7.293154928330D-05, -7.3420D-23,  137, 'P', & !  959
     &          1.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4009548235D0, -7.293119718275D-05,  7.2752D-24,  136, 'P', & !  960
     &         -2.2D0,        -1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 961, 970 ) &
     & /                             &
     & 3.4160629462D0, -7.293117668024D-05,  1.0628D-24,  135, 'P', & !  961
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0,     & !
     & 3.8092575953D0, -7.293112631023D-05, -2.3764D-23,  134, 'P', & !  962
     &         15.2D0,        -7.6D0,        0.0D0,      0.0D0,     & !
     & 6.0571103550D0, -7.293103839345D-05,  3.7241D-23,  133, 'R', & !  963
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6549060078D0, -7.293102989782D-05,  6.2124D-24,  131, 'P', & !  964
     &          1.3D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 4.7964986940D0, -7.293102217184D-05,  7.2752D-24,  130, 'P', & !  965
     &        -10.5D0,        14.8D0,        0.0D0,      0.0D0,     & !
     & 0.4300805794D0, -7.293087960414D-05,  6.7208D-23,  129, 'R', & !  966
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1673934728D0, -7.293045831419D-05, -6.7208D-23,  128, 'P', & !  967
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3230037922D0, -7.293015351211D-05,  0.0000D+00,  127, 'R', & !  968
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5295793864D0, -7.293003030570D-05, -1.2425D-23,  126, 'R', & !  969
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.5935919186D0, -7.292994362276D-05,  1.3488D-23,  125, 'P', & !  970
     &         -2.0D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 971, 980 ) &
     & /                             &
     & 2.4519992976D0, -7.292993589679D-05,  1.4550D-23,  124, 'P', & !  971
     &          1.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.1081548292D0, -7.292977710749D-05,  4.4517D-23,  123, 'P', & !  972
     &          0.0D0,         6.4D0,        0.0D0,      0.0D0,     & !
     & 0.0434851455D0, -7.292911877493D-05,  4.4517D-23,  122, 'P', & !  973
     &         -0.9D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5698369127D0, -7.292885015857D-05,  0.0000D+00,  120, 'P', & !  974
     &         -0.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.9181563005D0, -7.292830165307D-05,  7.4483D-23,  119, 'R', & !  975
     &         -2.3D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 3.3566674644D0, -7.292798769508D-05, -5.1496D-24,  117, 'P', & !  976
     &         -2.2D0,        -5.0D0,        0.0D0,      0.0D0,     & !
     & 2.2675758640D0, -7.292792531999D-05, -1.0628D-24,  114, 'R', & !  977
     &          2.1D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292792531962D-05,  0.0000D+00,  115, 'R', & !  978
     &         -1.5D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292791759402D-05,  0.0000D+00,  113, 'R', & !  979
     &          1.1D0,         5.4D0,        0.0D0,      0.0D0,     & !
     & 5.4091685502D0, -7.292790986841D-05,  0.0000D+00,  111, 'P', & !  980
     &          1.0D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 981, 990 ) &
     & /                             &
     & 2.2675759292D0, -7.292790986804D-05,  1.0628D-24,  112, 'P', & !  981
     &        -39.2D0,        19.0D0,        0.0D0,      0.0D0,     & !
     & 2.1171032006D0, -7.292785671931D-05,  1.9700D-23,  110, 'P', & !  982
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 4.0338704584D0, -7.292769869966D-05,  8.1758D-23,  109, 'P', & !  983
     &          3.8D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4385667202D0, -7.292768445168D-05,  1.0628D-24,  108, 'P', & !  984
     &         -1.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 3.5011996102D0, -7.292724648492D-05, -7.2752D-24,  106, 'R', & !  985
     &         -0.7D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 0.3596069892D0, -7.292723875895D-05, -6.2124D-24,  105, 'R', & !  986
     &         -2.0D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 4.8393970103D0, -7.292693054004D-05,  7.2752D-24,  103, 'P', & !  987
     &         -3.4D0,        -1.6D0,        0.0D0,      0.0D0,     & !
     & 0.1908761595D0, -7.292687791745D-05, -4.3444D-23,  102, 'R', & !  988
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 3.3324688457D0, -7.292687019147D-05, -4.2381D-23,  101, 'P', & !  989
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2863506472D0, -7.292687008029D-05,  3.7241D-23,  100, 'R', & !  990
     &         -5.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT= 991,1000 ) &
     & /                             &
     & 4.2231320320D0, -7.292674580926D-05, -7.4483D-23,   99, 'P', & !  991
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2779081091D0, -7.292663203401D-05, -7.4483D-23,   98, 'P', & !  992
     &          1.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 1.1109375158D0, -7.292652039289D-05, -7.4483D-23,   97, 'P', & !  993
     &         33.6D0,        -6.0D0,        0.0D0,      0.0D0,     & !
     & 4.2525302020D0, -7.292651266692D-05, -7.3420D-23,   96, 'P', & !  994
     &          0.8D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 4.2130943052D0, -7.292650140164D-05,  8.0695D-23,   95, 'R', & !  995
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.0715016842D0, -7.292649367566D-05,  8.1758D-23,   94, 'P', & !  996
     &        -20.2D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 4.1877163981D0, -7.292638203455D-05,  8.1758D-23,   93, 'P', & !  997
     &         -0.8D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 4.2819283068D0, -7.292629497653D-05, -7.4483D-23,   92, 'P', & !  998
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.8176945548D0, -7.292614871236D-05, -7.4483D-23,   91, 'R', & !  999
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.1331556615D0, -7.292614387708D-05,  4.9656D-23,   90, 'P', & ! 1000
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1001,1010 ) &
     & /                             &
     & 3.6262274968D0, -7.292608352851D-05,  0.0000D+00,   89, 'R', & ! 1001
     &          4.3D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 0.4846348758D0, -7.292607580254D-05,  1.0628D-24,   88, 'P', & ! 1002
     &          0.0D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 3.6262274968D0, -7.292606807730D-05,  0.0000D+00,   86, 'P', & ! 1003
     &          2.8D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 4.7453754934D0, -7.292590565095D-05, -1.0628D-24,   83, 'R', & ! 1004
     &         -0.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.6037828724D0, -7.292590565058D-05,  0.0000D+00,   84, 'R', & ! 1005
     &          0.0D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 1.8228322108D0, -7.292577530961D-05,  1.3488D-23,   82, 'P', & ! 1006
     &          0.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.9644248970D0, -7.292576758363D-05,  1.4550D-23,   81, 'P', & ! 1007
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.4317540488D0, -7.292531536890D-05, -7.4483D-23,   79, 'P', & ! 1008
     &         -7.5D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 0.0653359994D0, -7.292515734925D-05, -1.2425D-23,   77, 'R', & ! 1009
     &         -1.0D0,        22.4D0,        0.0D0,      0.0D0,     & !
     & 6.1980485780D0, -7.292510420052D-05,  6.2124D-24,   76, 'P', & ! 1010
     &          4.0D0,         1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1011,1020 ) &
     & /                             &
     & 3.0564559570D0, -7.292509647454D-05,  7.2752D-24,   75, 'P', & ! 1011
     &         -0.9D0,         5.5D0,        0.0D0,      0.0D0,     & !
     & 6.1980486432D0, -7.292508874857D-05,  8.3380D-24,   74, 'P', & ! 1012
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1089570428D0, -7.292502637347D-05,  1.2425D-23,   73, 'P', & ! 1013
     &          0.3D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.5474682067D0, -7.292471241549D-05, -6.7208D-23,   72, 'P', & ! 1014
     &          1.3D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 1.1190889122D0, -7.292464305584D-05,  1.0628D-24,   71, 'P', & ! 1015
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 4.1321276326D0, -7.292443414791D-05,  4.3444D-23,   70, 'P', & ! 1016
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.1484870170D0, -7.292442536545D-05,  0.0000D+00,   69, 'R', & ! 1017
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.2900797032D0, -7.292441763947D-05,  1.0628D-24,   68, 'P', & ! 1018
     &          0.0D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 3.8957875945D0, -7.292416390999D-05,  7.2752D-24,   66, 'P', & ! 1019
     &          0.5D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4943052142D0, -7.292398739870D-05, -8.3380D-24,   65, 'R', & ! 1020
     &         -0.2D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1021,1030 ) &
     & /                             &
     & 5.4943052794D0, -7.292397194675D-05, -6.2124D-24,   64, 'R', & ! 1021
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.1389540545D0, -7.292389529363D-05, -3.7241D-23,   63, 'P', & ! 1022
     &          1.5D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 5.0841906614D0, -7.292358300518D-05, -1.0628D-24,   60, 'R', & ! 1023
     &          0.5D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.9425980404D0, -7.292358300482D-05,  0.0000D+00,   61, 'R', & ! 1024
     &         -2.1D0,        -2.5D0,        0.0D0,      0.0D0,     & !
     & 0.8018914362D0, -7.292352823911D-05,  0.0000D+00,   59, 'R', & ! 1025
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.9434841224D0, -7.292352051314D-05,  1.0628D-24,   58, 'P', & ! 1026
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.2919287384D0, -7.292339212975D-05,  7.2357D-23,   57, 'R', & ! 1027
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 6.2456358060D0, -7.292325358069D-05, -7.4483D-23,   56, 'P', & ! 1028
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3574696780D0, -7.292323696107D-05, -3.7241D-23,   55, 'P', & ! 1029
     &          0.0D0,        12.6D0,        0.0D0,      0.0D0,     & !
     & 2.2158770570D0, -7.292322923510D-05, -3.6179D-23,   54, 'P', & ! 1030
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1031,1040 ) &
     & /                             &
     & 2.8720325234D0, -7.292308589774D-05, -8.3380D-24,   53, 'R', & ! 1031
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 6.0136252095D0, -7.292307817177D-05, -7.2752D-24,   52, 'R', & ! 1032
     &         15.3D0,        14.3D0,        0.0D0,      0.0D0,     & !
     & 2.8720325885D0, -7.292307044579D-05, -6.2124D-24,   51, 'R', & ! 1033
     &         25.6D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 3.1334412898D0, -7.292302816433D-05, -7.4483D-23,   50, 'P', & ! 1034
     &          0.6D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.1426207150D0, -7.292286055644D-05,  7.2752D-24,   49, 'P', & ! 1035
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2982310344D0, -7.292255575437D-05,  7.4483D-23,   48, 'R', & ! 1036
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4635183712D0, -7.292226877588D-05,  2.1628D-23,   47, 'R', & ! 1037
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.4017065485D0, -7.292225926587D-05,  2.3230D-23,   46, 'R', & ! 1038
     &          5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7523586206D0, -7.292213446441D-05, -5.9932D-23,   45, 'P', & ! 1039
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5024566105D0, -7.292211006164D-05,  6.7208D-23,   44, 'R', & ! 1040
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1041,1050 ) &
     & /                             &
     & 0.5275331270D0, -7.292199962269D-05, -1.0628D-24,   42, 'R', & ! 1041
     &         -0.4D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292199962232D-05,  0.0000D+00,   43, 'R', & ! 1042
     &          1.2D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292199189671D-05,  0.0000D+00,   41, 'R', & ! 1043
     &         22.7D0,        32.2D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292198417111D-05,  0.0000D+00,   39, 'P', & ! 1044
     &         24.2D0,       -11.8D0,        0.0D0,      0.0D0,     & !
     & 0.5275331922D0, -7.292198417074D-05,  1.0628D-24,   40, 'P', & ! 1045
     &       -271.0D0,       135.0D0,        0.0D0,      0.0D0,     & !
     & 3.6691258132D0, -7.292197644550D-05,  0.0000D+00,   37, 'P', & ! 1046
     &          8.1D0,        35.3D0,        0.0D0,      0.0D0,     & !
     & 3.6691258784D0, -7.292197644477D-05,  2.1256D-24,   38, 'P', & ! 1047
     &          0.0D0,         2.9D0,        0.0D0,      0.0D0,     & !
     & 2.4085141522D0, -7.292197567511D-05, -2.9966D-23,   36, 'P', & ! 1048
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5318547154D0, -7.292189237125D-05,  6.6145D-23,   34, 'R', & ! 1049
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.6563669119D0, -7.292188775833D-05,  3.1039D-23,   33, 'R', & ! 1050
     &         21.8D0,         9.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1051,1060 ) &
     & /                             &
     & 2.3902620944D0, -7.292188464528D-05,  6.7208D-23,   32, 'R', & ! 1051
     &         -9.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0495615610D0, -7.292183738831D-05,  6.2124D-24,   31, 'P', & ! 1052
     &          0.0D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 3.0646696837D0, -7.292181688580D-05,  0.0000D+00,   30, 'R', & ! 1053
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5612528854D0, -7.292165922891D-05,  6.7208D-23,   29, 'R', & ! 1054
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0827963462D0, -7.292161711195D-05, -1.0628D-24,   28, 'R', & ! 1055
     &         -0.3D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 1.2148489630D0, -7.292153495788D-05, -4.4517D-23,   27, 'R', & ! 1056
     &          0.9D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.4348356472D0, -7.292152250780D-05,  1.0628D-24,   26, 'P', & ! 1057
     &          0.0D0,        -3.0D0,        0.0D0,      0.0D0,     & !
     & 2.6770492681D0, -7.292150581851D-05,  4.3444D-23,   25, 'P', & ! 1058
     &         -9.9D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 3.7030815223D0, -7.292146478526D-05,  8.0695D-23,   24, 'P', & ! 1059
     &         -2.5D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292139942083D-05,  0.0000D+00,   23, 'R', & ! 1060
     &         -1.1D0,         0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1061,1070 ) &
     & /                             &
     & 6.2537871372D0, -7.292139169559D-05, -1.0628D-24,   21, 'R', & ! 1061
     &        101.9D0,      -169.0D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292139169522D-05,  0.0000D+00,   22, 'R', & ! 1062
     &       -326.1D0,       544.0D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292138396961D-05,  0.0000D+00,   20, 'P', & ! 1063
     &         47.3D0,        12.3D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292137624401D-05,  0.0000D+00,   18, 'P', & ! 1064
     &          0.6D0,         7.3D0,        0.0D0,      0.0D0,     & !
     & 6.2537872024D0, -7.292137624364D-05,  1.0628D-24,   19, 'P', & ! 1065
     &         -7.1D0,      -108.7D0,        0.0D0,      0.0D0,     & !
     & 3.1121945162D0, -7.292136851840D-05,  0.0000D+00,   17, 'P', & ! 1066
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6044561295D0, -7.292131811294D-05,  0.0000D+00,   16, 'P', & ! 1067
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0253779071D0, -7.292127792034D-05, -1.0628D-24,   13, 'R', & ! 1068
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1669705933D0, -7.292127019436D-05,  0.0000D+00,   12, 'P', & ! 1069
     &         44.5D0,       154.7D0,        0.0D0,      0.0D0,     & !
     & 0.1674965494D0, -7.292126770248D-05,  0.0000D+00,   11, 'P', & ! 1070
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1071,1080 ) &
     & /                             &
     & 5.2959442085D0, -7.292126269163D-05, -3.1039D-23,   10, 'P', & ! 1071
     &         21.1D0,         8.6D0,        0.0D0,      0.0D0,     & !
     & 3.1669705933D0, -7.292126246876D-05,  0.0000D+00,    8, 'P', & ! 1072
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0253779723D0, -7.292126246839D-05,  1.0628D-24,    9, 'P', & ! 1073
     &         25.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2284092301D0, -7.292125687728D-05,  0.0000D+00,    7, 'P', & ! 1074
     &         -0.3D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 1.1407066042D0, -7.292122104456D-05,  0.0000D+00,    6, 'R', & ! 1075
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.6899942596D0, -7.292117757327D-05, -3.2029D-24,    5, 'R', & ! 1076
     &       -230.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0614386368D0, -7.292117613860D-05,  0.0000D+00,    4, 'R', & ! 1077
     &         -1.0D0,        -4.1D0,        0.0D0,      0.0D0,     & !
     & 3.2217466703D0, -7.292117187033D-05,  0.0000D+00,    3, 'R', & ! 1078
     &         -4.3D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 1.3449971298D0, -7.292116806326D-05, -1.6014D-24,    2, 'R', & ! 1079
     &          0.0D0,       215.3D0,        0.0D0,      0.0D0,     & !
     & 3.0614386368D0, -7.292116068738D-05,  0.0000D+00,    1, 'R', & ! 1080
     &        138.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1081,1090 ) &
     & /                             &
     & 3.2217466703D0, -7.292115641911D-05,  0.0000D+00,    1, 'P', & ! 1081
     &       -138.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9381881774D0, -7.292114904323D-05,  1.6014D-24,    2, 'P', & ! 1082
     &          0.0D0,      -598.7D0,        0.0D0,      0.0D0,     & !
     & 3.0614386368D0, -7.292114523616D-05,  0.0000D+00,    3, 'P', & ! 1083
     &        -15.1D0,       -21.5D0,        0.0D0,      0.0D0,     & !
     & 3.2217466703D0, -7.292114096790D-05,  0.0000D+00,    4, 'P', & ! 1084
     &        -25.1D0,        -4.1D0,        0.0D0,      0.0D0,     & !
     & 3.5931910475D0, -7.292113953322D-05,  3.2029D-24,    5, 'P', & ! 1085
     &      -6494.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1424787030D0, -7.292109606193D-05,  0.0000D+00,    6, 'P', & ! 1086
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.0547760771D0, -7.292106022921D-05,  0.0000D+00,    7, 'R', & ! 1087
     &          0.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 6.2578073349D0, -7.292105463810D-05, -1.0628D-24,    9, 'R', & ! 1088
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9872410987D0, -7.292105441486D-05,  3.1039D-23,   10, 'R', & ! 1089
     &        -21.1D0,         8.6D0,        0.0D0,      0.0D0,     & !
     & 6.1156887578D0, -7.292104940401D-05,  0.0000D+00,   11, 'R', & ! 1090
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1091,1100 ) &
     & /                             &
     & 3.1162147139D0, -7.292104691213D-05,  0.0000D+00,   12, 'R', & ! 1091
     &        -44.5D0,       154.7D0,        0.0D0,      0.0D0,     & !
     & 3.1162147139D0, -7.292103918652D-05,  0.0000D+00,   14, 'P', & ! 1092
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2578074001D0, -7.292103918616D-05,  1.0628D-24,   13, 'P', & ! 1093
     &        -22.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0547760771D0, -7.292102932678D-05,  0.0000D+00,   15, 'P', & ! 1094
     &          0.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 5.6787291777D0, -7.292099899355D-05,  0.0000D+00,   16, 'R', & ! 1095
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292094858810D-05,  0.0000D+00,   17, 'R', & ! 1096
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0293981048D0, -7.292094086285D-05, -1.0628D-24,   19, 'R', & ! 1097
     &         -1.1D0,        15.9D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292094086249D-05,  0.0000D+00,   18, 'R', & ! 1098
     &          3.3D0,       -49.4D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292093313688D-05,  0.0000D+00,   20, 'R', & ! 1099
     &        -47.3D0,        12.3D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292092541127D-05,  0.0000D+00,   22, 'P', & ! 1100
     &        -47.7D0,       -79.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1101,1110 ) &
     & /                             &
     & 0.0293981700D0, -7.292092541091D-05,  1.0628D-24,   21, 'P', & ! 1101
     &        696.7D0,      1157.0D0,        0.0D0,      0.0D0,     & !
     & 3.1709907910D0, -7.292091768566D-05,  0.0000D+00,   23, 'P', & ! 1102
     &         -3.2D0,        -5.0D0,        0.0D0,      0.0D0,     & !
     & 2.5801037849D0, -7.292085232124D-05, -8.0695D-23,   24, 'R', & ! 1103
     &          2.5D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.6061360391D0, -7.292081128798D-05, -4.3444D-23,   25, 'R', & ! 1104
     &          9.9D0,        -5.8D0,        0.0D0,      0.0D0,     & !
     & 3.8483496600D0, -7.292079459869D-05, -1.0628D-24,   26, 'R', & ! 1105
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 5.0683363442D0, -7.292078214862D-05,  4.4517D-23,   27, 'P', & ! 1106
     &          5.9D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 3.2003889610D0, -7.292069999454D-05,  1.0628D-24,   28, 'P', & ! 1107
     &         -2.1D0,        -6.0D0,        0.0D0,      0.0D0,     & !
     & 0.7219324218D0, -7.292065787758D-05, -6.7208D-23,   29, 'P', & ! 1108
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2185156235D0, -7.292050022069D-05,  0.0000D+00,   30, 'P', & ! 1109
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2336237462D0, -7.292047971818D-05, -6.2124D-24,   31, 'R', & ! 1110
     &          0.0D0,         2.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1111,1120 ) &
     & /                             &
     & 3.8929232128D0, -7.292043246122D-05, -6.7208D-23,   32, 'P', & ! 1111
     &        -64.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6268183953D0, -7.292042934816D-05, -3.1039D-23,   33, 'P', & ! 1112
     &        -21.8D0,         9.7D0,        0.0D0,      0.0D0,     & !
     & 0.7513305918D0, -7.292042473524D-05, -6.6145D-23,   34, 'P', & ! 1113
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 4.7684110815D0, -7.292042162219D-05, -2.9976D-23,   35, 'P', & ! 1114
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.8746711550D0, -7.292034143139D-05,  2.9966D-23,   36, 'R', & ! 1115
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292034066100D-05,  0.0000D+00,   37, 'R', & ! 1116
     &          0.2D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 5.7556521150D0, -7.292033293575D-05, -1.0628D-24,   40, 'R', & ! 1117
     &        -39.7D0,       -19.7D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292033293539D-05,  0.0000D+00,   39, 'R', & ! 1118
     &        106.2D0,        52.7D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292032520978D-05,  0.0000D+00,   41, 'P', & ! 1119
     &        -22.7D0,        32.2D0,        0.0D0,      0.0D0,     & !
     & 2.6140594940D0, -7.292031748417D-05,  0.0000D+00,   43, 'P', & ! 1120
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1121,1130 ) &
     & /                             &
     & 5.7556521802D0, -7.292031748381D-05,  1.0628D-24,   42, 'P', & ! 1121
     &         -2.5D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 0.7807286966D0, -7.292020704485D-05, -6.7208D-23,   44, 'P', & ! 1122
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8814787586D0, -7.292005784063D-05, -2.3230D-23,   46, 'P', & ! 1123
     &        120.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8196669360D0, -7.292004833061D-05, -2.1628D-23,   47, 'P', & ! 1124
     &          0.0D0,       -12.6D0,        0.0D0,      0.0D0,     & !
     & 1.9849542728D0, -7.291976135212D-05, -7.4483D-23,   48, 'P', & ! 1125
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1405645922D0, -7.291945655005D-05, -7.2752D-24,   49, 'R', & ! 1126
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1497440174D0, -7.291928894217D-05,  7.4483D-23,   50, 'R', & ! 1127
     &         -0.6D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.4111527186D0, -7.291924666070D-05,  6.2124D-24,   51, 'P', & ! 1128
     &        -25.7D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 0.2695600976D0, -7.291923893473D-05,  7.2752D-24,   52, 'P', & ! 1129
     &        104.0D0,       -98.2D0,        0.0D0,      0.0D0,     & !
     & 3.4111527838D0, -7.291923120875D-05,  8.3380D-24,   53, 'P', & ! 1130
     &          0.0D0,         3.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1131,1140 ) &
     & /                             &
     & 0.9257156292D0, -7.291908014542D-05,  3.7241D-23,   55, 'R', & ! 1131
     &          0.0D0,        12.6D0,        0.0D0,      0.0D0,     & !
     & 0.0375495012D0, -7.291906352580D-05,  7.4483D-23,   56, 'R', & ! 1132
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9912565687D0, -7.291892497674D-05, -7.2357D-23,   57, 'P', & ! 1133
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.4812938710D0, -7.291878886738D-05,  0.0000D+00,   59, 'P', & ! 1134
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.3405872668D0, -7.291873410168D-05,  0.0000D+00,   61, 'P', & ! 1135
     &         -0.3D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.1989946458D0, -7.291873410131D-05,  1.0628D-24,   60, 'P', & ! 1136
     &          3.8D0,        -4.3D0,        0.0D0,      0.0D0,     & !
     & 4.3405872668D0, -7.291872637607D-05,  0.0000D+00,   62, 'P', & ! 1137
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1442312526D0, -7.291842181287D-05,  3.7241D-23,   63, 'R', & ! 1138
     &         -1.5D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.7888800278D0, -7.291834515975D-05,  6.2124D-24,   64, 'P', & ! 1139
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.7888800930D0, -7.291832970780D-05,  8.3380D-24,   65, 'P', & ! 1140
     &         -2.3D0,         5.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1141,1150 ) &
     & /                             &
     & 3.6037898790D0, -7.291797764876D-05,  1.4550D-23,   67, 'P', & ! 1141
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1346982902D0, -7.291789174105D-05,  0.0000D+00,   69, 'P', & ! 1142
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.1510576745D0, -7.291788295858D-05, -4.3444D-23,   70, 'R', & ! 1143
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 1.1742282644D0, -7.291729073302D-05, -1.2425D-23,   73, 'R', & ! 1144
     &         -0.3D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.2267293502D0, -7.291722063195D-05, -7.2752D-24,   75, 'R', & ! 1145
     &         -0.1D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.0851367292D0, -7.291721290598D-05, -6.2124D-24,   76, 'R', & ! 1146
     &         -4.1D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 6.2178493078D0, -7.291715975724D-05,  1.2425D-23,   77, 'P', & ! 1147
     &          1.0D0,        22.5D0,        0.0D0,      0.0D0,     & !
     & 3.0762566868D0, -7.291715203127D-05,  1.3488D-23,   78, 'P', & ! 1148
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8514312584D0, -7.291700173760D-05,  7.4483D-23,   79, 'R', & ! 1149
     &          7.5D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 4.9930239445D0, -7.291699401162D-05,  7.5546D-23,   80, 'P', & ! 1150
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1151,1160 ) &
     & /                             &
     & 4.4603530964D0, -7.291654179689D-05, -1.3488D-23,   82, 'R', & ! 1151
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.6794024348D0, -7.291641145591D-05,  0.0000D+00,   84, 'P', & ! 1152
     &          0.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.5378098138D0, -7.291641145555D-05,  1.0628D-24,   83, 'P', & ! 1153
     &         -0.2D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 4.6794024348D0, -7.291640373031D-05,  0.0000D+00,   85, 'P', & ! 1154
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7985504313D0, -7.291624130396D-05, -1.0628D-24,   88, 'R', & ! 1155
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291624130359D-05,  0.0000D+00,   87, 'R', & ! 1156
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 2.6569578103D0, -7.291623357798D-05,  0.0000D+00,   89, 'P', & ! 1157
     &         -4.3D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 1.1500296457D0, -7.291617322941D-05, -4.9656D-23,   90, 'R', & ! 1158
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4654907524D0, -7.291616839413D-05,  7.4483D-23,   91, 'P', & ! 1159
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0012570004D0, -7.291602212997D-05,  7.4483D-23,   92, 'R', & ! 1160
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1161,1170 ) &
     & /                             &
     & 2.0954689091D0, -7.291593507195D-05, -8.1758D-23,   93, 'R', & ! 1161
     &         -0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.2116836230D0, -7.291582343083D-05, -8.1758D-23,   94, 'R', & ! 1162
     &         -3.1D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 2.0700910020D0, -7.291581570486D-05, -8.0695D-23,   95, 'P', & ! 1163
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0306551052D0, -7.291580443958D-05,  7.3420D-23,   96, 'R', & ! 1164
     &          0.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.1722477914D0, -7.291579671360D-05,  7.4483D-23,   97, 'R', & ! 1165
     &        -33.7D0,        -6.0D0,        0.0D0,      0.0D0,     & !
     & 2.0052771981D0, -7.291568507248D-05,  7.4483D-23,   98, 'R', & ! 1166
     &         -1.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 2.0600532752D0, -7.291557129724D-05,  7.4483D-23,   99, 'R', & ! 1167
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9968346600D0, -7.291544702620D-05, -3.7241D-23,  100, 'P', & ! 1168
     &          5.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9507164615D0, -7.291544691502D-05,  4.2381D-23,  101, 'R', & ! 1169
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0923091476D0, -7.291543918905D-05,  4.3444D-23,  102, 'P', & ! 1170
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1171,1180 ) &
     & /                             &
     & 1.4437882968D0, -7.291538656645D-05, -7.2752D-24,  103, 'R', & ! 1171
     &         -0.5D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.4437883620D0, -7.291537111450D-05, -5.1496D-24,  104, 'P', & ! 1172
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9235783180D0, -7.291507834755D-05,  6.2124D-24,  105, 'P', & ! 1173
     &          2.0D0,        -7.5D0,        0.0D0,      0.0D0,     & !
     & 2.7819856970D0, -7.291507062157D-05,  7.2752D-24,  106, 'P', & ! 1174
     &         -4.6D0,       -15.7D0,        0.0D0,      0.0D0,     & !
     & 5.9235783832D0, -7.291506289560D-05,  8.3380D-24,  107, 'P', & ! 1175
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 2.2493148488D0, -7.291461840683D-05, -8.1758D-23,  109, 'R', & ! 1176
     &          0.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.0156093780D0, -7.291440723845D-05, -1.0628D-24,  112, 'R', & ! 1177
     &         -5.8D0,        -2.8D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291440723809D-05,  0.0000D+00,  111, 'R', & ! 1178
     &          7.2D0,         3.4D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439951248D-05,  0.0000D+00,  113, 'P', & ! 1179
     &         -1.1D0,         5.4D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291439178687D-05,  0.0000D+00,  115, 'P', & ! 1180
     &        -10.6D0,         1.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1181,1190 ) &
     & /                             &
     & 4.0156094432D0, -7.291439178650D-05,  1.0628D-24,  114, 'P', & ! 1181
     &         14.9D0,        -2.6D0,        0.0D0,      0.0D0,     & !
     & 0.8740167570D0, -7.291438406126D-05,  0.0000D+00,  116, 'P', & ! 1182
     &          0.0D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 2.9265178428D0, -7.291432941141D-05,  5.1496D-24,  117, 'R', & ! 1183
     &         -0.2D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 2.9265179080D0, -7.291431395946D-05,  7.2752D-24,  118, 'P', & ! 1184
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3650290067D0, -7.291401545343D-05, -7.4483D-23,  119, 'P', & ! 1185
     &          2.3D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 1.7133483945D0, -7.291346694793D-05,  0.0000D+00,  120, 'R', & ! 1186
     &          0.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 1.7133483945D0, -7.291345149671D-05,  0.0000D+00,  121, 'P', & ! 1187
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1750304780D0, -7.291253999901D-05, -4.4517D-23,  123, 'R', & ! 1188
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.6895933885D0, -7.291237348373D-05, -1.3488D-23,  125, 'R', & ! 1189
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7536059208D0, -7.291228680079D-05,  1.2425D-23,  126, 'P', & ! 1190
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1191,1200 ) &
     & /                             &
     & 1.9601815150D0, -7.291216359438D-05,  0.0000D+00,  127, 'P', & ! 1191
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8531047278D0, -7.291143750235D-05, -6.7208D-23,  129, 'P', & ! 1192
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4866866132D0, -7.291129493465D-05, -7.2752D-24,  130, 'R', & ! 1193
     &         -1.6D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 4.6282792994D0, -7.291128720868D-05, -6.2124D-24,  131, 'R', & ! 1194
     &         -1.4D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 1.4866866784D0, -7.291127948270D-05, -5.1496D-24,  132, 'P', & ! 1195
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 0.2260749522D0, -7.291127871305D-05, -3.7241D-23,  133, 'P', & ! 1196
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4739277119D0, -7.291119079627D-05,  2.3764D-23,  134, 'R', & ! 1197
     &          2.2D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.8671223610D0, -7.291114042625D-05, -1.0628D-24,  135, 'R', & ! 1198
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.8822304837D0, -7.291111992374D-05, -7.2752D-24,  136, 'R', & ! 1199
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.5206423223D0, -7.291076782319D-05,  7.3420D-23,  137, 'R', & ! 1200
     &          0.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1201,1210 ) &
     & /                             &
     & 0.9297553162D0, -7.291068700755D-05, -7.2752D-24,  139, 'R', & ! 1201
     &         -2.6D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.9845313933D0, -7.291057323230D-05, -7.2752D-24,  140, 'R', & ! 1202
     &         -2.8D0,        -9.8D0,        0.0D0,      0.0D0,     & !
     & 0.5075550596D0, -7.291048061121D-05, -1.0478D-23,  142, 'R', & ! 1203
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1007461072D0, -7.291046159118D-05, -7.2752D-24,  143, 'R', & ! 1204
     &    5723004.3D0,      -506.1D0, -4638980.5D0,    719.8D0,     & !
     & 4.1007461724D0, -7.291044613924D-05, -5.1496D-24,  144, 'P', & ! 1205
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4107518475D0, -7.291044257116D-05, -4.0723D-24,  145, 'P', & ! 1206
     &        286.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9337755139D0, -7.291034995007D-05, -7.2752D-24,  147, 'R', & ! 1207
     &          2.8D0,        -9.7D0,        0.0D0,      0.0D0,     & !
     & 0.9885515910D0, -7.291023617482D-05, -7.2752D-24,  148, 'R', & ! 1208
     &          2.4D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.1301442772D0, -7.291022844884D-05, -6.2124D-24,  149, 'R', & ! 1209
     &         -0.9D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 0.3976645849D0, -7.291015535918D-05, -8.7970D-23,  150, 'R', & ! 1210
     &         -0.2D0,         0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1211,1220 ) &
     & /                             &
     & 4.8226785290D0, -7.290996091552D-05, -7.4483D-23,  151, 'P', & ! 1211
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0360764235D0, -7.290980325863D-05, -7.2752D-24,  152, 'R', & ! 1212
     &          0.3D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.7104840128D0, -7.290973549915D-05, -7.4483D-23,  153, 'P', & ! 1213
     &         42.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7275645025D0, -7.290973238610D-05, -3.8314D-23,  154, 'R', & ! 1214
     &         -1.8D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 4.8520766990D0, -7.290972777318D-05, -7.3420D-23,  155, 'P', & ! 1215
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 0.4316202940D0, -7.290962824772D-05, -7.2752D-24,  157, 'R', & ! 1216
     &          1.2D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 4.9822248658D0, -7.290936087856D-05, -3.0505D-23,  158, 'P', & ! 1217
     &       -296.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6372277360D0, -7.290935136855D-05, -2.8903D-23,  159, 'P', & ! 1218
     &          0.0D0,        78.0D0,        0.0D0,      0.0D0,     & !
     & 1.2287135186D0, -7.290854969864D-05, -1.0628D-24,  161, 'R', & ! 1219
     &         -9.1D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290854969827D-05,  0.0000D+00,  160, 'R', & ! 1220
     &         -0.9D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1221,1230 ) &
     & /                             &
     & 4.3703062048D0, -7.290854197266D-05,  0.0000D+00,  162, 'R', & ! 1221
     &        -43.4D0,        41.6D0,        0.0D0,      0.0D0,     & !
     & 4.3703062048D0, -7.290853424706D-05,  0.0000D+00,  164, 'P', & ! 1222
     &         -1.3D0,        10.6D0,        0.0D0,      0.0D0,     & !
     & 1.2287135838D0, -7.290853424669D-05,  1.0628D-24,  163, 'P', & ! 1223
     &          1.7D0,       -10.6D0,        0.0D0,      0.0D0,     & !
     & 5.0264617364D0, -7.290838318336D-05,  2.9966D-23,  165, 'R', & ! 1224
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.8896261350D0, -7.290764819768D-05, -1.0628D-24,  167, 'R', & ! 1225
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290763274610D-05,  0.0000D+00,  169, 'P', & ! 1226
     &        -11.5D0,        25.9D0,        0.0D0,      0.0D0,     & !
     & 4.8896262002D0, -7.290763274574D-05,  1.0628D-24,  168, 'P', & ! 1227
     &         11.0D0,       -25.0D0,        0.0D0,      0.0D0,     & !
     & 1.7480335140D0, -7.290762502049D-05,  0.0000D+00,  170, 'P', & ! 1228
     &         26.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5629433000D0, -7.290728841267D-05,  6.2124D-24,  171, 'R', & ! 1229
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.4213506790D0, -7.290728068670D-05,  7.2752D-24,  172, 'P', & ! 1230
     &          4.7D0,        -1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1231,1240 ) &
     & /                             &
     & 4.5629433652D0, -7.290727296073D-05,  8.3380D-24,  173, 'P', & ! 1231
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.6398663025D0, -7.290662235414D-05,  7.2752D-24,  174, 'P', & ! 1232
     &          2.5D0,        -4.7D0,        0.0D0,      0.0D0,     & !
     & 4.0354101078D0, -7.290646279518D-05,  5.1496D-24,  175, 'R', & ! 1233
     &          0.5D0,        14.5D0,        0.0D0,      0.0D0,     & !
     & 0.8938174868D0, -7.290645506921D-05,  6.2124D-24,  176, 'P', & ! 1234
     &         -3.4D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 4.0354101730D0, -7.290644734323D-05,  7.2752D-24,  177, 'P', & ! 1235
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 5.9521773655D0, -7.290630477554D-05,  6.7208D-23,  178, 'R', & ! 1236
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4745186103D0, -7.290553661592D-05, -7.2752D-24,  179, 'R', & ! 1237
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9898085914D0, -7.290509975154D-05,  6.7208D-23,  180, 'R', & ! 1238
     &          1.7D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1060233053D0, -7.290498811042D-05,  6.7208D-23,  181, 'R', & ! 1239
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 3.7117410132D0, -7.290459907587D-05,  0.0000D+00,  183, 'P', & ! 1240
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1241,1250 ) &
     & /                             &
     & 3.7411391180D0, -7.290438138548D-05, -1.0628D-24,  184, 'R', & ! 1241
     &          1.7D0,        -6.3D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290438138512D-05,  0.0000D+00,  185, 'R', & ! 1242
     &          0.4D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290437365951D-05,  0.0000D+00,  186, 'P', & ! 1243
     &          8.8D0,        24.0D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290436593390D-05,  0.0000D+00,  189, 'P', & ! 1244
     &         -1.3D0,        12.3D0,        0.0D0,      0.0D0,     & !
     & 3.7411391832D0, -7.290436593353D-05,  1.0628D-24,  188, 'P', & ! 1245
     &          1.3D0,       -10.6D0,        0.0D0,      0.0D0,     & !
     & 0.5995464970D0, -7.290435820829D-05,  0.0000D+00,  190, 'P', & ! 1246
     &        -10.6D0,         4.7D0,        0.0D0,      0.0D0,     & !
     & 4.9747628642D0, -7.290370255042D-05, -7.2752D-24,  192, 'R', & ! 1247
     &          0.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.8331702432D0, -7.290369482444D-05, -6.2124D-24,  193, 'R', & ! 1248
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7440787080D0, -7.290361699740D-05,  0.0000D+00,  195, 'P', & ! 1249
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8543520280D0, -7.290158983873D-05,  5.1496D-24,  198, 'R', & ! 1250
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1251,1260 ) &
     & /                             &
     & 0.4521499044D0, -7.290139887284D-05, -7.4483D-23,  199, 'P', & ! 1251
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7342447872D0, -7.290110684731D-05,  0.0000D+00,  200, 'P', & ! 1252
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6220502710D0, -7.290087370533D-05,  0.0000D+00,  202, 'P', & ! 1253
     &         -1.8D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 5.7636429572D0, -7.290087370497D-05,  1.0628D-24,  201, 'P', & ! 1254
     &          1.8D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 2.6220502710D0, -7.290086597973D-05,  0.0000D+00,  203, 'P', & ! 1255
     &          0.0D0,         3.2D0,        0.0D0,      0.0D0,     & !
     & 3.6706655278D0, -7.290074054029D-05, -7.4483D-23,  204, 'P', & ! 1256
     &         13.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9183069072D0, -7.289976462912D-05, -1.4550D-23,  206, 'R', & ! 1257
     &     -17521.6D0,         3.2D0,    42441.8D0,    -12.9D0,     & !
     & 5.5114979547D0, -7.289974560909D-05, -1.1348D-23,  207, 'R', & ! 1258
     &         -9.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8112301200D0, -7.289903853709D-05, -8.1758D-23,  209, 'R', & ! 1259
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7997856658D0, -7.289866391650D-05, -3.7780D-23,  210, 'P', & ! 1260
     &       -318.0D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1261,1270 ) &
     & /                             &
     & 1.4547885360D0, -7.289865440649D-05, -3.6179D-23,  211, 'P', & ! 1261
     &         -0.1D0,      -318.4D0,        0.0D0,      0.0D0,     & !
     & 0.1097914062D0, -7.289864489648D-05, -3.4577D-23,  212, 'P', & ! 1262
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2399395730D0, -7.289827800186D-05,  8.3380D-24,  213, 'P', & ! 1263
     &          0.0D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 2.1878670048D0, -7.289784501060D-05, -7.2752D-24,  215, 'R', & ! 1264
     &          1.3D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 5.3294596910D0, -7.289783728463D-05, -6.2124D-24,  216, 'R', & ! 1265
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.6812644245D0, -7.289756320388D-05, -6.1010D-23,  217, 'P', & ! 1266
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7071870002D0, -7.289693578367D-05, -6.2124D-24,  218, 'R', & ! 1267
     &         -0.4D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.8487796864D0, -7.289692805770D-05, -5.1496D-24,  219, 'P', & ! 1268
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3805041000D0, -7.289659145061D-05, -1.0628D-24,  220, 'R', & ! 1269
     &          0.3D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289659145025D-05,  0.0000D+00,  221, 'R', & ! 1270
     &          0.4D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1271,1280 ) &
     & /                             &
     & 5.5220967862D0, -7.289658372464D-05,  0.0000D+00,  222, 'R', & ! 1271
     &        -14.1D0,         4.6D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289657599903D-05,  0.0000D+00,  224, 'P', & ! 1272
     &         -2.8D0,       -11.1D0,        0.0D0,      0.0D0,     & !
     & 2.3805041652D0, -7.289657599866D-05,  1.0628D-24,  223, 'P', & ! 1273
     &          2.2D0,         9.0D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289656827342D-05,  0.0000D+00,  227, 'P', & ! 1274
     &        210.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.5220967862D0, -7.289656827342D-05,  0.0000D+00,  225, 'P', & ! 1275
     &        208.6D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.5220968514D0, -7.289656827269D-05,  2.1256D-24,  226, 'P', & ! 1276
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289592539208D-05,  0.0000D+00,  230, 'R', & ! 1277
     &         -8.3D0,        14.8D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289591766647D-05,  0.0000D+00,  233, 'P', & ! 1278
     &          2.5D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 2.4574271025D0, -7.289591766647D-05,  0.0000D+00,  231, 'P', & ! 1279
     &          0.6D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.5990197886D0, -7.289591766611D-05,  1.0628D-24,  232, 'P', & ! 1280
     &         -2.1D0,        -3.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1281,1290 ) &
     & /                             &
     & 2.4574271025D0, -7.289590994086D-05,  0.0000D+00,  234, 'P', & ! 1281
     &         10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289576583239D-05,  0.0000D+00,  237, 'R', & ! 1282
     &          0.2D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 4.9945635940D0, -7.289575810714D-05, -1.0628D-24,  239, 'R', & ! 1283
     &         -4.7D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289575810678D-05,  0.0000D+00,  240, 'R', & ! 1284
     &         -2.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.8529709730D0, -7.289575038117D-05,  0.0000D+00,  241, 'P', & ! 1285
     &          1.4D0,        -3.8D0,        0.0D0,      0.0D0,     & !
     & 4.7002926042D0, -7.289367669745D-05, -7.2752D-24,  243, 'R', & ! 1286
     &         -0.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.5586999832D0, -7.289366897147D-05, -6.2124D-24,  244, 'R', & ! 1287
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.7002926694D0, -7.289366124550D-05, -5.1496D-24,  245, 'P', & ! 1288
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1143849128D0, -7.289100041682D-05,  0.0000D+00,  247, 'P', & ! 1289
     &         -0.9D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 3.6719128932D0, -7.289087742472D-05,  0.0000D+00,  249, 'P', & ! 1290
     &         -0.5D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1291,1300 ) &
     & /                             &
     & 1.4882263278D0, -7.289004357822D-05, -8.1758D-23,  250, 'R', & ! 1291
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1615434928D0, -7.288968379321D-05, -7.4483D-23,  251, 'P', & ! 1292
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3839449453D0, -7.288909625024D-05,  5.1496D-24,  252, 'R', & ! 1293
     &         -0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 6.0190530144D0, -7.288906766706D-05, -2.1826D-23,  253, 'R', & ! 1294
     &        -10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5555346432D0, -7.288795744443D-05, -4.3454D-23,  254, 'P', & ! 1295
     &          0.0D0,        32.1D0,        0.0D0,      0.0D0,     & !
     & 4.2105375134D0, -7.288794793441D-05, -4.1852D-23,  255, 'P', & ! 1296
     &        -15.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3112875102D0, -7.288779873092D-05,  0.0000D+00,  256, 'P', & ! 1297
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288758876577D-05,  0.0000D+00,  257, 'P', & ! 1298
     &          2.4D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 1.1990929940D0, -7.288758104016D-05,  0.0000D+00,  260, 'P', & ! 1299
     &        -11.5D0,        61.9D0,        0.0D0,      0.0D0,     & !
     & 4.3406856802D0, -7.288758103980D-05,  1.0628D-24,  259, 'P', & ! 1300
     &          6.0D0,       -32.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1301,1310 ) &
     & /                             &
     & 1.1990929940D0, -7.288757331455D-05,  0.0000D+00,  261, 'P', & ! 1301
     &        236.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.1990930592D0, -7.288757331382D-05,  2.1256D-24,  262, 'P', & ! 1302
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3700837850D0, -7.288734789819D-05,  0.0000D+00,  263, 'P', & ! 1303
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4988252245D0, -7.288686624182D-05, -6.8285D-23,  264, 'P', & ! 1304
     &          8.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3396575862D0, -7.288588676257D-05, -7.2752D-24,  265, 'R', & ! 1305
     &          0.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.1980649652D0, -7.288587903660D-05, -6.2124D-24,  266, 'R', & ! 1306
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.3396576514D0, -7.288587131063D-05, -5.1496D-24,  267, 'P', & ! 1307
     &        -26.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2749879025D0, -7.288522843002D-05, -7.2752D-24,  268, 'R', & ! 1308
     &          0.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.2749879676D0, -7.288521297807D-05, -5.1496D-24,  269, 'P', & ! 1309
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5445480001D0, -7.288330881150D-05,  0.0000D+00,  271, 'R', & ! 1310
     &          0.0D0,         3.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1311,1320 ) &
     & /                             &
     & 0.5445480001D0, -7.288330108589D-05,  0.0000D+00,  272, 'P', & ! 1311
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5445480001D0, -7.288330108589D-05,  0.0000D+00,  274, 'P', & ! 1312
     &          1.6D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 3.6861406863D0, -7.288330108552D-05,  1.0628D-24,  273, 'P', & ! 1313
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5445480001D0, -7.288329336028D-05,  0.0000D+00,  275, 'P', & ! 1314
     &          4.8D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 0.1327289658D0, -7.288188024060D-05,  6.2124D-24,  276, 'P', & ! 1315
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2743216520D0, -7.288187251462D-05,  7.2752D-24,  277, 'P', & ! 1316
     &          0.0D0,        -7.3D0,        0.0D0,      0.0D0,     & !
     & 3.2015058104D0, -7.287838383623D-05,  0.0000D+00,  280, 'P', & ! 1317
     &         -0.7D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 3.3730954432D0, -7.287726048236D-05, -5.0729D-23,  281, 'R', & ! 1318
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.0280983134D0, -7.287725097235D-05, -4.9128D-23,  282, 'R', & ! 1319
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1582464802D0, -7.287688407773D-05, -6.2124D-24,  283, 'R', & ! 1320
     &         -0.3D0,         1.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1321,1330 ) &
     & /                             &
     & 5.2998391664D0, -7.287687635176D-05, -5.1496D-24,  284, 'P', & ! 1321
     &        -11.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5995713316D0, -7.287616927976D-05, -7.5560D-23,  285, 'P', & ! 1322
     &         22.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0511696930D0, -7.287615798570D-05, -7.3420D-23,  286, 'P', & ! 1323
     &          0.0D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 2.9095770720D0, -7.287615025973D-05, -7.2357D-23,  287, 'P', & ! 1324
     &        614.8D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.1572184514D0, -7.287517434856D-05, -1.2425D-23,  288, 'R', & ! 1325
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7610082652D0, -7.287200117042D-05,  0.0000D+00,  289, 'P', & ! 1326
     &          0.2D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 4.7610082652D0, -7.287199344481D-05,  0.0000D+00,  290, 'P', & ! 1327
     &         -5.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.2334750730D0, -7.287118327854D-05, -1.0628D-24,  293, 'R', & ! 1328
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287118327817D-05,  0.0000D+00,  292, 'R', & ! 1329
     &         -1.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 1.0918824520D0, -7.287117555256D-05,  0.0000D+00,  294, 'P', & ! 1330
     &         -0.7D0,        59.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1331,1340 ) &
     & /                             &
     & 1.0918824520D0, -7.287116782695D-05,  0.0000D+00,  295, 'P', & ! 1331
     &         -0.8D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.7986394910D0, -7.287079614642D-05,  0.0000D+00,  298, 'P', & ! 1332
     &         -1.6D0,         5.2D0,        0.0D0,      0.0D0,     & !
     & 4.9402321772D0, -7.287079614606D-05,  1.0628D-24,  297, 'P', & ! 1333
     &          0.8D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 1.7986394910D0, -7.287078842082D-05,  0.0000D+00,  299, 'P', & ! 1334
     &         25.9D0,         4.2D0,        0.0D0,      0.0D0,     & !
     & 4.9148542049D0, -7.287069223091D-05,  0.0000D+00,  300, 'R', & ! 1335
     &          0.3D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.9148542049D0, -7.287067677970D-05,  0.0000D+00,  301, 'P', & ! 1336
     &          1.3D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 3.1173999664D0, -7.286617938970D-05, -1.2425D-23,  302, 'R', & ! 1337
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2886267081D0, -7.286576725565D-05,  0.0000D+00,  305, 'P', & ! 1338
     &          0.0D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 3.4171321316D0, -7.286547231769D-05, -8.2835D-23,  306, 'R', & ! 1339
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7271378720D0, -7.286545329767D-05, -7.9632D-23,  307, 'P', & ! 1340
     &     -10300.1D0,         7.8D0,    -2323.4D0,      1.8D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1341,1350 ) &
     & /                             &
     & 5.1926285592D0, -7.286047859050D-05, -7.2752D-24,  308, 'R', & ! 1341
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 5.8993856634D0, -7.286009145802D-05, -5.1496D-24,  309, 'P', & ! 1342
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0019751026D0, -7.285806019912D-05,  0.0000D+00,  310, 'P', & ! 1343
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.5132331310D0, -7.285729768601D-05,  7.2752D-24,  311, 'P', & ! 1344
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.8278839792D0, -7.285475633560D-05, -8.6908D-23,  312, 'P', & ! 1345
     &       1088.1D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 2.3981859880D0, -7.285400352708D-05,  0.0000D+00,  313, 'P', & ! 1346
     &          1.9D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.7093627378D0, -7.285365562298D-05, -1.1014D-22,  314, 'P', & ! 1347
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6589329129D0, -7.285315840067D-05,  0.0000D+00,  316, 'R', & ! 1348
     &         -0.2D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.6589329129D0, -7.285315067507D-05,  0.0000D+00,  317, 'P', & ! 1349
     &          2.0D0,         3.3D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284660844956D-05,  0.0000D+00,  318, 'R', & ! 1350
     &          0.3D0,        -0.2D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1351,1360 ) &
     & /                             &
     & 0.3307939310D0, -7.284660072395D-05,  0.0000D+00,  320, 'R', & ! 1351
     &          2.1D0,        -8.5D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284659299834D-05,  0.0000D+00,  321, 'P', & ! 1352
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3307939310D0, -7.284658527274D-05,  0.0000D+00,  322, 'P', & ! 1353
     &          0.5D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 2.6454447792D0, -7.284405937354D-05, -9.4183D-23,  325, 'R', & ! 1354
     &        -25.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2654579316D0, -7.284260192795D-05,  1.2425D-23,  326, 'P', & ! 1355
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7460538105D0, -7.284053409448D-05,  0.0000D+00,  327, 'P', & ! 1356
     &          6.7D0,         3.8D0,        0.0D0,      0.0D0,     & !
     & 0.4630055792D0, -7.283336241148D-05, -1.0146D-22,  328, 'R', & ! 1357
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3662040388D0, -7.283190496589D-05,  5.1496D-24,  329, 'R', & ! 1358
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2246114178D0, -7.283189723991D-05,  6.2124D-24,  330, 'P', & ! 1359
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.8331747082D0, -7.282791751390D-05,  0.0000D+00,  331, 'P', & ! 1360
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1361,1370 ) &
     & /                             &
     & 5.8528907172D0, -7.282201816973D-05,  0.0000D+00,  332, 'P', & ! 1361
     &          2.7D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 2.7112980962D0, -7.282201816937D-05,  1.0628D-24,  333, 'P', & ! 1362
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8528907172D0, -7.282201044413D-05,  0.0000D+00,  334, 'P', & ! 1363
     &         -0.5D0,        13.6D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120800309D-05,  0.0000D+00,  335, 'R', & ! 1364
     &         -4.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3253575250D0, -7.282120027785D-05, -1.0628D-24,  337, 'R', & ! 1365
     &          0.3D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282120027748D-05,  0.0000D+00,  338, 'R', & ! 1366
     &          1.0D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 2.1837649040D0, -7.282119255188D-05,  0.0000D+00,  339, 'P', & ! 1367
     &          4.5D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 4.0351961624D0, -7.281703573623D-05,  7.4483D-23,  340, 'R', & ! 1368
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2034809130D0, -7.281530093332D-05,  0.0000D+00,  341, 'P', & ! 1369
     &         -0.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.4635228968D0, -7.280732241130D-05,  6.2124D-24,  343, 'P', & ! 1370
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1371,1380 ) &
     & /                             &
     & 3.6051155830D0, -7.280731468533D-05,  7.2752D-24,  344, 'P', & ! 1371
     &          6.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2906018106D0, -7.280268435273D-05,  0.0000D+00,  346, 'R', & ! 1372
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.2906018106D0, -7.280266890152D-05,  0.0000D+00,  347, 'P', & ! 1373
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5946153508D0, -7.279916085772D-05,  9.3644D-23,  349, 'P', & ! 1374
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5642690040D0, -7.279662544924D-05, -1.0628D-24,  353, 'R', & ! 1375
     &         -0.3D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279662544887D-05,  0.0000D+00,  352, 'R', & ! 1376
     &         -0.8D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279661772327D-05,  0.0000D+00,  354, 'P', & ! 1377
     &       -146.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.4226763830D0, -7.279660999766D-05,  0.0000D+00,  355, 'P', & ! 1378
     &          1.7D0,        -7.4D0,        0.0D0,      0.0D0,     & !
     & 4.5642690692D0, -7.279660999729D-05,  1.0628D-24,  356, 'P', & ! 1379
     &          0.0D0,         1.2D0,        0.0D0,      0.0D0,     & !
     & 2.3777227083D0, -7.279005232093D-05,  0.0000D+00,  357, 'P', & ! 1380
     &          1.3D0,        -0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1381,1390 ) &
     & /                             &
     & 5.6384696332D0, -7.278921492014D-05,  0.0000D+00,  358, 'R', & ! 1381
     &         -0.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.6384696332D0, -7.278919946892D-05,  0.0000D+00,  359, 'P', & ! 1382
     &          0.4D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.4121761508D0, -7.278846389565D-05,  8.6369D-23,  360, 'R', & ! 1383
     &         -4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0053671984D0, -7.278844487563D-05,  8.9572D-23,  361, 'P', & ! 1384
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5234224902D0, -7.278592076120D-05, -7.2752D-24,  362, 'R', & ! 1385
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0346805186D0, -7.278515824810D-05,  0.0000D+00,  363, 'R', & ! 1386
     &         -0.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.0346805186D0, -7.278514279689D-05,  0.0000D+00,  364, 'P', & ! 1387
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.5129222580D0, -7.277776693359D-05,  7.9094D-23,  366, 'R', & ! 1388
     &         -4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8229279984D0, -7.277774791356D-05,  8.2297D-23,  367, 'P', & ! 1389
     &          8.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4648436059D0, -7.277743574035D-05,  0.0000D+00,  368, 'P', & ! 1390
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1391,1400 ) &
     & /                             &
     & 5.0933419108D0, -7.277619971031D-05, -7.4483D-23,  369, 'P', & ! 1391
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1218014163D0, -7.277252621630D-05,  0.0000D+00,  371, 'P', & ! 1392
     &          0.0D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277243002640D-05,  0.0000D+00,  372, 'R', & ! 1393
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277242230079D-05,  0.0000D+00,  373, 'R', & ! 1394
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 6.2380161302D0, -7.277241457519D-05,  0.0000D+00,  374, 'P', & ! 1395
     &          2.8D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277204289466D-05,  0.0000D+00,  375, 'R', & ! 1396
     &          0.5D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277203516905D-05,  0.0000D+00,  376, 'P', & ! 1397
     &         -3.4D0,       -13.5D0,        0.0D0,      0.0D0,     & !
     & 3.8031805482D0, -7.277203516868D-05,  1.0628D-24,  377, 'P', & ! 1398
     &          0.2D0,         2.1D0,        0.0D0,      0.0D0,     & !
     & 0.6615878620D0, -7.277202744344D-05,  0.0000D+00,  378, 'P', & ! 1399
     &         94.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.2756473560D0, -7.277122500241D-05,  0.0000D+00,  379, 'R', & ! 1400
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1401,1410 ) &
     & /                             &
     & 3.2756473560D0, -7.277121727680D-05,  0.0000D+00,  380, 'R', & ! 1401
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2756473560D0, -7.277120955119D-05,  0.0000D+00,  381, 'P', & ! 1402
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.6404887984D0, -7.276705095150D-05,  7.5021D-23,  383, 'R', & ! 1403
     &         11.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7368165200D0, -7.276632664351D-05,  7.2752D-24,  384, 'P', & ! 1404
     &         -0.2D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 1.5219675570D0, -7.276595023888D-05,  5.1792D-23,  385, 'P', & ! 1405
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7623340344D0, -7.276133048065D-05, -5.1496D-24,  386, 'P', & ! 1406
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2089223139D0, -7.275990963572D-05,  0.0000D+00,  388, 'P', & ! 1407
     &          1.6D0,         2.3D0,        0.0D0,      0.0D0,     & !
     & 4.6969980350D0, -7.275733168464D-05,  7.2752D-24,  389, 'P', & ! 1408
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 0.5543773200D0, -7.275562968145D-05,  0.0000D+00,  391, 'P', & ! 1409
     &         16.4D0,        26.5D0,        0.0D0,      0.0D0,     & !
     & 5.6227136642D0, -7.275525327682D-05,  4.4517D-23,  392, 'P', & ! 1410
     &        -28.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1411,1420 ) &
     & /                             &
     & 3.3363630170D0, -7.274954174977D-05,  7.2752D-24,  393, 'P', & ! 1411
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1836846482D0, -7.274745261483D-05,  0.0000D+00,  394, 'P', & ! 1412
     &         -2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5792285187D0, -7.274729305514D-05,  0.0000D+00,  395, 'P', & ! 1413
     &          7.7D0,         4.4D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274664244819D-05,  0.0000D+00,  397, 'R', & ! 1414
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274663472258D-05,  0.0000D+00,  398, 'P', & ! 1415
     &          0.5D0,        32.4D0,        0.0D0,      0.0D0,     & !
     & 2.5145588350D0, -7.274662699697D-05,  0.0000D+00,  399, 'P', & ! 1416
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8487886164D0, -7.274537343662D-05,  7.2752D-24,  400, 'P', & ! 1417
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4402744642D0, -7.274455631476D-05,  3.7241D-23,  402, 'R', & ! 1418
     &        254.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 4.3217532228D0, -7.274345560214D-05,  1.4012D-23,  403, 'P', & ! 1419
     &       -147.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.4146053502D0, -7.274233701628D-05,  0.0000D+00,  404, 'P', & ! 1420
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1421,1430 ) &
     & /                             &
     & 4.2661183332D0, -7.273907020408D-05,  0.0000D+00,  405, 'P', & ! 1421
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273884478771D-05,  0.0000D+00,  407, 'P', & ! 1422
     &        120.9D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 1.1539238170D0, -7.273883706210D-05,  0.0000D+00,  408, 'P', & ! 1423
     &          0.0D0,         1.4D0,        0.0D0,      0.0D0,     & !
     & 4.3249146080D0, -7.273861937134D-05,  0.0000D+00,  409, 'P', & ! 1424
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0054368000D0, -7.273557797551D-05,  0.0000D+00,  411, 'P', & ! 1425
     &          0.6D0,         2.0D0,        0.0D0,      0.0D0,     & !
     & 3.6663494164D0, -7.273467647455D-05,  0.0000D+00,  412, 'P', & ! 1426
     &         36.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2578352642D0, -7.273385935269D-05,  2.9966D-23,  413, 'R', & ! 1427
     &        -21.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1393140228D0, -7.273275864007D-05,  6.7366D-24,  414, 'P', & ! 1428
     &       3428.0D0,        -3.2D0,      626.8D0,     -0.6D0,     & !
     & 5.7325050704D0, -7.273273962005D-05,  9.9395D-24,  415, 'P', & ! 1429
     &          3.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8794535570D0, -7.272881893474D-05,  0.0000D+00,  416, 'P', & ! 1430
     &          7.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1431,1440 ) &
     & /                             &
     & 5.2546699242D0, -7.272814782565D-05, -7.2752D-24,  417, 'R', & ! 1431
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3585813714D0, -7.272316239063D-05,  2.2691D-23,  419, 'R', & ! 1432
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4225961272D0, -7.272289323744D-05,  0.0000D+00,  420, 'R', & ! 1433
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4225961272D0, -7.272287778622D-05,  0.0000D+00,  421, 'P', & ! 1434
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8656648302D0, -7.272228531034D-05,  0.0000D+00,  422, 'P', & ! 1435
     &          1.3D0,        -3.0D0,        0.0D0,      0.0D0,     & !
     & 4.9204409073D0, -7.272217153509D-05,  0.0000D+00,  423, 'P', & ! 1436
     &         -2.1D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.9204409073D0, -7.272215608387D-05,  0.0000D+00,  424, 'P', & ! 1437
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2400601300D0, -7.272206167801D-05, -5.3862D-25,  426, 'P', & ! 1438
     &    -124479.8D0,       636.5D0,    96892.7D0,    -89.7D0,     & !
     & 1.7534703140D0, -7.272205989397D-05,  0.0000D+00,  427, 'P', & ! 1439
     &         -0.8D0,        -2.7D0,        0.0D0,      0.0D0,     & !
     & 3.5500658704D0, -7.272204265798D-05,  2.6643D-24,  428, 'P', & ! 1440
     &     -44063.8D0,        43.8D0,    38064.5D0,    -35.2D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1441,1450 ) &
     & /                             &
     & 4.8696850279D0, -7.272194825285D-05,  0.0000D+00,  429, 'R', & ! 1441
     &         -1.9D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.8696850279D0, -7.272193280164D-05,  0.0000D+00,  430, 'P', & ! 1442
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9244611050D0, -7.272181902639D-05,  0.0000D+00,  431, 'P', & ! 1443
     &          0.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.3675298080D0, -7.272122655050D-05,  0.0000D+00,  433, 'P', & ! 1444
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6049832970D0, -7.271879308177D-05,  0.0000D+00,  434, 'P', & ! 1445
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4104281243D0, -7.271713491871D-05,  0.0000D+00,  435, 'P', & ! 1446
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6274870710D0, -7.271528540199D-05,  0.0000D+00,  436, 'P', & ! 1447
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0576209300D0, -7.271136471595D-05, -7.8138D-24,  437, 'R', & ! 1448
     &        334.9D0,        -0.3D0,      313.7D0,     -0.3D0,     & !
     & 2.7126238002D0, -7.271135520593D-05, -6.2124D-24,  438, 'P', & ! 1449
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3676266704D0, -7.271134569592D-05, -4.6109D-24,  439, 'P', & ! 1450
     &       1117.3D0,        -1.0D0,      313.7D0,     -0.3D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1451,1460 ) &
     & /                             &
     & 6.1237765188D0, -7.270944331339D-05,  0.0000D+00,  440, 'P', & ! 1451
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1237765188D0, -7.270942786217D-05,  0.0000D+00,  441, 'P', & ! 1452
     &         15.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5015038280D0, -7.270852636122D-05,  0.0000D+00,  442, 'P', & ! 1453
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270527500023D-05,  0.0000D+00,  444, 'P', & ! 1454
     &         -0.8D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270526727462D-05,  0.0000D+00,  445, 'P', & ! 1455
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 2.3530168110D0, -7.270525954902D-05,  0.0000D+00,  446, 'P', & ! 1456
     &         54.3D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.8751817300D0, -7.270066775388D-05, -1.5089D-23,  447, 'R', & ! 1457
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4683727775D0, -7.270064873386D-05, -1.1886D-23,  448, 'R', & ! 1458
     &        -77.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7566604886D0, -7.269956704126D-05, -3.8319D-23,  449, 'P', & ! 1459
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0666662290D0, -7.269954802124D-05, -3.5116D-23,  450, 'P', & ! 1460
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1461,1470 ) &
     & /                             &
     & 0.9923817930D0, -7.269748506536D-05,  0.0000D+00,  451, 'R', & ! 1461
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269747733975D-05,  0.0000D+00,  452, 'P', & ! 1462
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9923817930D0, -7.269746961414D-05,  0.0000D+00,  453, 'P', & ! 1463
     &          0.0D0,        -5.7D0,        0.0D0,      0.0D0,     & !
     & 4.2108974165D0, -7.269681128159D-05,  0.0000D+00,  454, 'P', & ! 1464
     &          3.9D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269666717311D-05,  0.0000D+00,  455, 'R', & ! 1465
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269665944750D-05,  0.0000D+00,  456, 'R', & ! 1466
     &          0.5D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 3.6064412870D0, -7.269665172189D-05,  0.0000D+00,  458, 'P', & ! 1467
     &         -1.6D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.1705776762D0, -7.269456258622D-05, -5.1496D-24,  459, 'P', & ! 1468
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5846699196D0, -7.269190175754D-05,  0.0000D+00,  460, 'P', & ! 1469
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.2859335775D0, -7.268995177179D-05, -1.9161D-23,  462, 'R', & ! 1470
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1471,1480 ) &
     & /                             &
     & 4.1674123362D0, -7.268885105917D-05, -4.2391D-23,  463, 'P', & ! 1471
     &         53.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9525633080D0, -7.268847465528D-05,  0.0000D+00,  464, 'P', & ! 1472
     &          7.2D0,       -10.0D0,        0.0D0,      0.0D0,     & !
     & 2.2980183141D0, -7.268419470100D-05,  0.0000D+00,  465, 'P', & ! 1473
     &          0.5D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.0277919660D0, -7.268277385535D-05,  7.2752D-24,  466, 'P', & ! 1474
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9549761244D0, -7.267928517696D-05,  0.0000D+00,  468, 'P', & ! 1475
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.9849731362D0, -7.267815409711D-05, -4.9666D-23,  469, 'R', & ! 1476
     &         -5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8664518948D0, -7.267705338449D-05, -7.2896D-23,  470, 'P', & ! 1477
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9869453870D0, -7.267208461926D-05, -1.0628D-24,  472, 'R', & ! 1478
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267208461889D-05,  0.0000D+00,  471, 'R', & ! 1479
     &         -0.3D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 2.8453527660D0, -7.267207689328D-05,  0.0000D+00,  473, 'P', & ! 1480
     &         59.3D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1481,1490 ) &
     & /                             &
     & 2.8453527660D0, -7.267206916768D-05,  0.0000D+00,  474, 'P', & ! 1481
     &          0.5D0,        -3.0D0,        0.0D0,      0.0D0,     & !
     & 3.5521098050D0, -7.267168976154D-05,  0.0000D+00,  475, 'P', & ! 1482
     &          1.0D0,        -1.4D0,        0.0D0,      0.0D0,     & !
     & 3.0420970221D0, -7.266666859637D-05,  0.0000D+00,  478, 'P', & ! 1483
     &         -0.5D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 0.6840126948D0, -7.266635642243D-05, -8.0171D-23,  479, 'P', & ! 1484
     &        -18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7847588020D0, -7.265565946037D-05, -8.7446D-23,  481, 'P', & ! 1485
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1292179197D0, -7.265405201579D-05,  0.0000D+00,  482, 'P', & ! 1486
     &         -1.6D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264750206468D-05,  0.0000D+00,  483, 'R', & ! 1487
     &          0.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264749433907D-05,  0.0000D+00,  484, 'P', & ! 1488
     &         -1.8D0,        -7.1D0,        0.0D0,      0.0D0,     & !
     & 5.2258569312D0, -7.264749433870D-05,  1.0628D-24,  485, 'P', & ! 1489
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 2.0842642450D0, -7.264748661346D-05,  0.0000D+00,  486, 'P', & ! 1490
     &        -23.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1491,1500 ) &
     & /                             &
     & 5.4995241245D0, -7.264143543521D-05,  0.0000D+00,  490, 'P', & ! 1491
     &         -2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0526649492D0, -7.263435629391D-05,  1.6139D-22,  491, 'R', & ! 1492
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1534110564D0, -7.262365933184D-05,  1.5412D-22,  492, 'R', & ! 1493
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3231757240D0, -7.262291178485D-05,  0.0000D+00,  493, 'P', & ! 1494
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9372352180D0, -7.262209389260D-05,  0.0000D+00,  496, 'P', & ! 1495
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.6737659198D0, -7.261618682282D-05,  0.0000D+00,  497, 'P', & ! 1496
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0440721246D0, -7.260357024224D-05,  0.0000D+00,  499, 'P', & ! 1497
     &          3.8D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 3.1761466970D0, -7.259751906399D-05,  0.0000D+00,  500, 'P', & ! 1498
     &          0.4D0,        -2.8D0,        0.0D0,      0.0D0,     & !
     & 3.1761466970D0, -7.259750361277D-05,  0.0000D+00,  501, 'P', & ! 1499
     &          1.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 4.1311930223D0, -7.259095366166D-05,  0.0000D+00,  503, 'P', & ! 1500
     &          1.0D0,        -1.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1501,1510 ) &
     & /                             &
     & 4.0807632625D0, -7.259044871301D-05,  1.1226D-22,  504, 'R', & ! 1501
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1087546400D0, -7.259010080965D-05,  0.0000D+00,  506, 'P', & ! 1502
     &         -1.1D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 4.9622420212D0, -7.258934800039D-05,  8.9033D-23,  507, 'P', & ! 1503
     &         20.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7798028212D0, -7.257865103833D-05,  8.1758D-23,  508, 'P', & ! 1504
     &       -926.6D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 2.2183139199D0, -7.257833708108D-05,  0.0000D+00,  509, 'P', & ! 1505
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 1.7083011370D0, -7.257331591591D-05,  0.0000D+00,  510, 'P', & ! 1506
     &         -8.3D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 2.4150581760D0, -7.257293650977D-05,  0.0000D+00,  511, 'P', & ! 1507
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4150581760D0, -7.257292878416D-05,  0.0000D+00,  512, 'P', & ! 1508
     &          0.0D0,       -23.6D0,        0.0D0,      0.0D0,     & !
     & 5.0291176700D0, -7.257212634313D-05,  0.0000D+00,  513, 'R', & ! 1509
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0291176700D0, -7.257211861752D-05,  0.0000D+00,  514, 'R', & ! 1510
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1511,1520 ) &
     & /                             &
     & 5.0291176700D0, -7.257211089191D-05,  0.0000D+00,  515, 'P', & ! 1511
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5973636212D0, -7.256795407626D-05,  7.4483D-23,  516, 'R', & ! 1512
     &      -4486.0D0,         4.3D0,        0.0D0,      0.0D0,     & !
     & 4.4902868340D0, -7.256722798423D-05,  7.2752D-24,  517, 'P', & ! 1513
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3054348176D0, -7.256572050049D-05,  0.0000D+00,  518, 'P', & ! 1514
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.9623926279D0, -7.256081097644D-05,  0.0000D+00,  519, 'P', & ! 1515
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9623926279D0, -7.256079552523D-05,  0.0000D+00,  520, 'P', & ! 1516
     &          0.0D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.6981097284D0, -7.255725711420D-05,  6.7208D-23,  521, 'R', & ! 1517
     &        180.5D0,        -0.2D0,     -315.5D0,      0.3D0,     & !
     & 2.3078476340D0, -7.255653102217D-05,  0.0000D+00,  522, 'P', & ! 1518
     &        -39.1D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255652329656D-05,  0.0000D+00,  523, 'P', & ! 1519
     &          0.9D0,         4.8D0,        0.0D0,      0.0D0,     & !
     & 2.3078476340D0, -7.255651557095D-05,  0.0000D+00,  524, 'P', & ! 1520
     &          1.3D0,        -0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1521,1530 ) &
     & /                             &
     & 5.5795884870D0, -7.255615640158D-05,  4.3978D-23,  525, 'P', & ! 1521
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6539696550D0, -7.254835395555D-05,  0.0000D+00,  526, 'P', & ! 1522
     &          0.6D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 1.0495135255D0, -7.254819439586D-05,  0.0000D+00,  527, 'P', & ! 1523
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0495135255D0, -7.254817894464D-05,  0.0000D+00,  528, 'P', & ! 1524
     &         -3.8D0,        -6.1D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254754378891D-05,  0.0000D+00,  529, 'R', & ! 1525
     &         -0.2D0,        -1.1D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254753606330D-05,  0.0000D+00,  530, 'P', & ! 1526
     &         -8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254752833769D-05,  0.0000D+00,  531, 'P', & ! 1527
     &         -0.5D0,         2.7D0,        0.0D0,      0.0D0,     & !
     & 4.2680291490D0, -7.254752061209D-05,  0.0000D+00,  532, 'P', & ! 1528
     &        -11.4D0,        -3.2D0,        0.0D0,      0.0D0,     & !
     & 2.5156705284D0, -7.254656015214D-05,  5.9932D-23,  533, 'R', & ! 1529
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3971492870D0, -7.254545943952D-05,  3.6703D-23,  534, 'R', & ! 1530
     &         -3.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1531,1540 ) &
     & /                             &
     & 2.0521521572D0, -7.254544992950D-05,  3.8304D-23,  535, 'P', & ! 1531
     &          0.0D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 4.2786280456D0, -7.254435872690D-05,  1.3473D-23,  536, 'P', & ! 1532
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5886337860D0, -7.254433970687D-05,  1.6676D-23,  537, 'P', & ! 1533
     &          2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8848903570D0, -7.254323835700D-05,  0.0000D+00,  538, 'P', & ! 1534
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 2.7628619200D0, -7.254048733933D-05,  0.0000D+00,  539, 'P', & ! 1535
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9073941310D0, -7.253974612843D-05,  0.0000D+00,  540, 'P', & ! 1536
     &          0.0D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 2.9073941310D0, -7.253973067722D-05,  0.0000D+00,  541, 'P', & ! 1537
     &         32.1D0,        -6.3D0,        0.0D0,      0.0D0,     & !
     & 1.7589071140D0, -7.253647931623D-05,  0.0000D+00,  542, 'P', & ! 1538
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7589071140D0, -7.253647159062D-05,  0.0000D+00,  543, 'P', & ! 1539
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.4198197304D0, -7.253557781528D-05,  0.0000D+00,  544, 'P', & ! 1540
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1541,1550 ) &
     & /                             &
     & 5.4198197304D0, -7.253556236406D-05,  0.0000D+00,  545, 'P', & ! 1541
     &        -16.7D0,       -14.8D0,        0.0D0,      0.0D0,     & !
     & 6.1528982644D0, -7.253475296744D-05,  3.1029D-23,  546, 'R', & ! 1542
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.8079011345D0, -7.253474345743D-05,  3.2630D-23,  547, 'P', & ! 1543
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0961888456D0, -7.253366176483D-05,  6.1980D-24,  548, 'P', & ! 1544
     &         21.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6893798932D0, -7.253364274481D-05,  9.4009D-24,  549, 'P', & ! 1545
     &       -161.7D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 2.6329238710D0, -7.252970482425D-05,  0.0000D+00,  550, 'P', & ! 1546
     &          0.0D0,        -4.2D0,        0.0D0,      0.0D0,     & !
     & 0.8499828177D0, -7.252787075874D-05,  0.0000D+00,  551, 'P', & ! 1547
     &         -2.3D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 0.8928811340D0, -7.252377912694D-05,  0.0000D+00,  552, 'P', & ! 1548
     &        -12.9D0,       -20.1D0,        0.0D0,      0.0D0,     & !
     & 0.2884250045D0, -7.252360411603D-05,  0.0000D+00,  553, 'P', & ! 1549
     &         -2.9D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 0.3359498370D0, -7.252317119984D-05,  0.0000D+00,  554, 'P', & ! 1550
     &          2.3D0,        -1.4D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1551,1560 ) &
     & /                             &
     & 3.4521645509D0, -7.252305955873D-05,  0.0000D+00,  555, 'P', & ! 1551
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3907259141D0, -7.252305742459D-05,  0.0000D+00,  556, 'P', & ! 1552
     &        -25.6D0,       -86.4D0,        0.0D0,      0.0D0,     & !
     & 6.1969349528D0, -7.252296480277D-05, -1.0772D-24,  557, 'P', & ! 1553
     &      -1579.0D0,         1.5D0,     2525.9D0,     -2.4D0,     & !
     & 3.5069406280D0, -7.252296123469D-05,  0.0000D+00,  558, 'P', & ! 1554
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5069406280D0, -7.252295350909D-05,  0.0000D+00,  561, 'P', & ! 1555
     &         -1.7D0,        -7.3D0,        0.0D0,      0.0D0,     & !
     & 0.3653480070D0, -7.252295350872D-05,  1.0628D-24,  560, 'P', & ! 1556
     &          0.0D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 0.2851939577D0, -7.252294791761D-05,  0.0000D+00,  564, 'P', & ! 1557
     &         -2.8D0,        -9.0D0,        0.0D0,      0.0D0,     & !
     & 3.5069406280D0, -7.252294578348D-05,  0.0000D+00,  563, 'P', & ! 1558
     &         18.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5069406932D0, -7.252294578275D-05,  2.1256D-24,  562, 'P', & ! 1559
     &    2659060.3D0,     -2432.1D0,  -180431.9D0,    172.6D0,     & !
     & 0.4455019912D0, -7.252294364935D-05,  0.0000D+00,  565, 'P', & ! 1560
     &          2.8D0,        -9.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1561,1570 ) &
     & /                             &
     & 0.3399700347D0, -7.252283414236D-05,  0.0000D+00,  566, 'P', & ! 1561
     &         25.4D0,       -86.6D0,        0.0D0,      0.0D0,     & !
     & 3.5617167051D0, -7.252283200823D-05,  0.0000D+00,  567, 'P', & ! 1562
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 0.3947461118D0, -7.252272036711D-05,  0.0000D+00,  568, 'P', & ! 1563
     &         -2.4D0,        -1.3D0,        0.0D0,      0.0D0,     & !
     & 0.4422709443D0, -7.252228745092D-05,  0.0000D+00,  569, 'P', & ! 1564
     &          2.8D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 6.1210001220D0, -7.252214334244D-05,  0.0000D+00,  570, 'R', & ! 1565
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1210001220D0, -7.252211244001D-05,  0.0000D+00,  572, 'P', & ! 1566
     &         12.9D0,       -20.2D0,        0.0D0,      0.0D0,     & !
     & 6.1638984383D0, -7.251802080821D-05,  0.0000D+00,  573, 'P', & ! 1567
     &          2.3D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 4.3809573850D0, -7.251618674271D-05,  0.0000D+00,  574, 'P', & ! 1568
     &          0.0D0,        -3.9D0,        0.0D0,      0.0D0,     & !
     & 5.4671221430D0, -7.251395082461D-05,  0.0000D+00,  575, 'P', & ! 1569
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4914720864D0, -7.251236046180D-05, -5.1496D-24,  576, 'P', & ! 1570
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1571,1580 ) &
     & /                             &
     & 4.0144957528D0, -7.251226784071D-05, -8.3524D-24,  577, 'R', & ! 1571
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4660941142D0, -7.251225654666D-05, -6.2124D-24,  578, 'P', & ! 1572
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.3245014932D0, -7.251224882068D-05, -5.1496D-24,  579, 'P', & ! 1573
     &     -29085.0D0,        27.8D0,    -4899.5D0,      4.7D0,     & !
     & 4.4407162071D0, -7.251213717957D-05, -5.1496D-24,  580, 'P', & ! 1574
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 1.5940615256D0, -7.251032920289D-05,  0.0000D+00,  581, 'P', & ! 1575
     &         17.7D0,       -14.8D0,        0.0D0,      0.0D0,     & !
     & 4.1064871250D0, -7.250616088974D-05,  0.0000D+00,  582, 'P', & ! 1576
     &        -34.6D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 4.2510193360D0, -7.250540422763D-05,  0.0000D+00,  583, 'P', & ! 1577
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4252476004D0, -7.250155185862D-05, -1.2425D-23,  585, 'R', & ! 1578
     &       2059.9D0,        -2.0D0,        0.0D0,      0.0D0,     & !
     & 2.7458521070D0, -7.249837095487D-05,  0.0000D+00,  586, 'P', & ! 1579
     &         13.3D0,        -3.4D0,        0.0D0,      0.0D0,     & !
     & 5.9643677305D0, -7.249771262231D-05,  0.0000D+00,  587, 'P', & ! 1580
     &          4.3D0,        -6.7D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1581,1590 ) &
     & /                             &
     & 5.3599116010D0, -7.249755306262D-05,  0.0000D+00,  590, 'P', & ! 1581
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 5.3599116010D0, -7.249753761140D-05,  0.0000D+00,  591, 'P', & ! 1582
     &         -0.5D0,         2.0D0,        0.0D0,      0.0D0,     & !
     & 3.2428084004D0, -7.249085489656D-05, -1.9700D-23,  592, 'R', & ! 1583
     &        -26.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1242871590D0, -7.248975418394D-05, -4.2930D-23,  593, 'P', & ! 1584
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7060336220D0, -7.248937599600D-05,  0.0000D+00,  594, 'P', & ! 1585
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0514886281D0, -7.248509604173D-05,  0.0000D+00,  595, 'P', & ! 1586
     &          0.0D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 0.4252611313D0, -7.248017106646D-05,  0.0000D+00,  596, 'P', & ! 1587
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.5988230800D0, -7.247297823401D-05,  0.0000D+00,  598, 'P', & ! 1588
     &         -0.6D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 4.5988230800D0, -7.247296278279D-05,  0.0000D+00,  599, 'P', & ! 1589
     &         -1.0D0,       -36.1D0,        0.0D0,      0.0D0,     & !
     & 4.7955673361D0, -7.246755448588D-05,  0.0000D+00,  600, 'P', & ! 1590
     &          0.0D0,        -1.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1591,1600 ) &
     & /                             &
     & 2.0516393652D0, -7.245654356510D-05, -8.4782D-23,  601, 'P', & ! 1591
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8826882337D0, -7.245493790530D-05,  0.0000D+00,  602, 'P', & ! 1592
     &         -1.5D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 3.8377345590D0, -7.244839567979D-05,  0.0000D+00,  603, 'P', & ! 1593
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8377345590D0, -7.244838795418D-05,  0.0000D+00,  604, 'P', & ! 1594
     &         -0.6D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 0.1686087458D0, -7.244758551315D-05,  0.0000D+00,  605, 'R', & ! 1595
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1686087458D0, -7.244757778754D-05,  0.0000D+00,  606, 'R', & ! 1596
     &          0.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1523854724D0, -7.244584660304D-05, -9.2057D-23,  607, 'P', & ! 1597
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9698091314D0, -7.244232132471D-05,  0.0000D+00,  608, 'P', & ! 1598
     &         -5.4D0,        -2.9D0,        0.0D0,      0.0D0,     & !
     & 5.3401153362D0, -7.242970474413D-05,  0.0000D+00,  609, 'P', & ! 1599
     &         -3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242300295893D-05,  0.0000D+00,  610, 'R', & ! 1600
     &         -0.2D0,        -0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1601,1610 ) &
     & /                             &
     & 5.6907055320D0, -7.242299523332D-05,  0.0000D+00,  611, 'P', & ! 1601
     &         -8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242298750771D-05,  0.0000D+00,  612, 'P', & ! 1602
     &          0.0D0,        -2.3D0,        0.0D0,      0.0D0,     & !
     & 5.6907055320D0, -7.242297978211D-05,  0.0000D+00,  613, 'P', & ! 1603
     &         -2.4D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.4272362338D0, -7.241708816355D-05,  0.0000D+00,  614, 'P', & ! 1604
     &         -0.6D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239842040471D-05,  0.0000D+00,  616, 'P', & ! 1605
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239841267910D-05,  0.0000D+00,  617, 'P', & ! 1606
     &         -1.3D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 4.9296170110D0, -7.239840495350D-05,  0.0000D+00,  618, 'P', & ! 1607
     &         70.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.2604911978D0, -7.239760251246D-05,  0.0000D+00,  619, 'R', & ! 1608
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.0376380854D0, -7.239135183777D-05,  1.1172D-22,  620, 'R', & ! 1609
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8622249540D0, -7.239100215037D-05,  0.0000D+00,  621, 'P', & ! 1610
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1611,1620 ) &
     & /                             &
     & 2.7471778762D0, -7.238770799070D-05, -5.1496D-24,  622, 'P', & ! 1611
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7366776440D0, -7.237955416309D-05,  8.1219D-23,  623, 'P', & ! 1612
     &        -18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3455567371D0, -7.237431344653D-05,  0.0000D+00,  624, 'P', & ! 1613
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 3.4617714510D0, -7.237421725663D-05,  0.0000D+00,  625, 'P', & ! 1614
     &         -1.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.4617714510D0, -7.237420180542D-05,  0.0000D+00,  626, 'P', & ! 1615
     &         -1.9D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 4.1685284900D0, -7.237383012489D-05,  0.0000D+00,  627, 'P', & ! 1616
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4994026768D0, -7.237301223264D-05,  0.0000D+00,  629, 'P', & ! 1617
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.5542384440D0, -7.236885720103D-05,  7.3944D-23,  630, 'R', & ! 1618
     &        -96.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.7158629419D0, -7.236169686595D-05,  0.0000D+00,  631, 'P', & ! 1619
     &         -1.1D0,        -1.9D0,        0.0D0,      0.0D0,     & !
     & 4.6549845512D0, -7.235816023896D-05,  6.6669D-23,  632, 'R', & ! 1620
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1621,1630 ) &
     & /                             &
     & 4.0613179480D0, -7.235743236289D-05,  0.0000D+00,  633, 'P', & ! 1621
     &          0.4D0,        -1.2D0,        0.0D0,      0.0D0,     & !
     & 4.0613179480D0, -7.235741691168D-05,  0.0000D+00,  634, 'P', & ! 1622
     &        -14.0D0,       -18.9D0,        0.0D0,      0.0D0,     & !
     & 2.8029838395D0, -7.234908028537D-05,  0.0000D+00,  635, 'P', & ! 1623
     &         -6.3D0,        -3.8D0,        0.0D0,      0.0D0,     & !
     & 6.0214994630D0, -7.234842195281D-05,  0.0000D+00,  637, 'P', & ! 1624
     &          0.0D0,       -23.9D0,        0.0D0,      0.0D0,     & !
     & 0.6640298502D0, -7.234634354425D-05,  3.9367D-23,  639, 'P', & ! 1625
     &         11.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6608644450D0, -7.234063201794D-05,  0.0000D+00,  640, 'P', & ! 1626
     &       -107.9D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 3.5123774280D0, -7.233736520574D-05,  0.0000D+00,  641, 'P', & ! 1627
     &          0.0D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 0.8901047372D0, -7.233646370478D-05,  0.0000D+00,  642, 'P', & ! 1628
     &        -29.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7647759574D0, -7.233564658219D-05,  3.2092D-23,  643, 'P', & ! 1629
     &         10.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6462547160D0, -7.233454586957D-05,  8.8622D-24,  644, 'P', & ! 1630
     &         -7.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1631,1640 ) &
     & /                             &
     & 4.3863941850D0, -7.233060616497D-05,  0.0000D+00,  645, 'P', & ! 1631
     &         -6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4784253102D0, -7.232993505514D-05, -5.1496D-24,  646, 'P', & ! 1632
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5823367574D0, -7.232494962013D-05,  2.4817D-23,  647, 'R', & ! 1633
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6463514480D0, -7.232468046767D-05,  0.0000D+00,  648, 'P', & ! 1634
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0894201510D0, -7.232407254057D-05,  0.0000D+00,  649, 'P', & ! 1635
     &         -1.0D0,         2.5D0,        0.0D0,      0.0D0,     & !
     & 2.1441962281D0, -7.232395876532D-05,  0.0000D+00,  650, 'P', & ! 1636
     &          5.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1538097756D0, -7.232386792753D-05, -1.6158D-24,  651, 'P', & ! 1637
     &        -26.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0386642717D0, -7.232384925833D-05,  0.0000D+00,  652, 'P', & ! 1638
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4638155160D0, -7.232384890751D-05,  1.5870D-24,  653, 'P', & ! 1639
     &     104226.6D0,       -92.8D0,   -89431.5D0,     83.8D0,     & !
     & 5.2604109420D0, -7.232384712420D-05,  0.0000D+00,  654, 'P', & ! 1640
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1641,1650 ) &
     & /                             &
     & 2.0934403487D0, -7.232373548308D-05,  0.0000D+00,  655, 'P', & ! 1641
     &          4.7D0,         2.5D0,        0.0D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232304468317D-05,  0.0000D+00,  656, 'R', & ! 1642
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232303695756D-05,  0.0000D+00,  657, 'R', & ! 1643
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.5912851288D0, -7.232301378073D-05,  0.0000D+00,  658, 'P', & ! 1644
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.2813763160D0, -7.231315194544D-05, -5.6882D-24,  659, 'P', & ! 1645
     &       -805.7D0,         0.8D0,        0.0D0,      0.0D0,     & !
     & 3.3475318396D0, -7.231123054362D-05,  0.0000D+00,  660, 'P', & ! 1646
     &          0.9D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 5.8599574390D0, -7.230706223046D-05,  0.0000D+00,  661, 'P', & ! 1647
     &          1.0D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 5.3821224232D0, -7.230245498338D-05, -1.2963D-23,  662, 'R', & ! 1648
     &         63.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4993224210D0, -7.229927229559D-05,  0.0000D+00,  663, 'P', & ! 1649
     &          0.0D0,         0.9D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229846212895D-05,  0.0000D+00,  664, 'R', & ! 1650
     &         -0.1D0,        -0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1651,1660 ) &
     & /                             &
     & 0.8301966078D0, -7.229845440334D-05,  0.0000D+00,  665, 'P', & ! 1651
     &         -5.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229844667773D-05,  0.0000D+00,  666, 'P', & ! 1652
     &          0.0D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 0.8301966078D0, -7.229843895212D-05,  0.0000D+00,  667, 'P', & ! 1653
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1996832232D0, -7.229175802132D-05, -2.0239D-23,  668, 'R', & ! 1654
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227387957473D-05,  0.0000D+00,  669, 'P', & ! 1655
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227387184912D-05,  0.0000D+00,  670, 'P', & ! 1656
     &         -0.9D0,        -3.5D0,        0.0D0,      0.0D0,     & !
     & 0.0691080868D0, -7.227386412351D-05,  0.0000D+00,  671, 'P', & ! 1657
     &        -77.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.2658523429D0, -7.226845582660D-05,  0.0000D+00,  673, 'P', & ! 1658
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 4.6361585477D0, -7.225583924602D-05,  0.0000D+00,  674, 'P', & ! 1659
     &          1.4D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 1.9220790598D0, -7.224847140265D-05,  0.0000D+00,  675, 'P', & ! 1660
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1661,1670 ) &
     & /                             &
     & 2.7232794454D0, -7.224322266544D-05,  0.0000D+00,  676, 'P', & ! 1661
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1609905388D0, -7.222388112283D-05,  0.0000D+00,  677, 'P', & ! 1662
     &          0.0D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 1.1947272424D0, -7.221474959928D-05,  1.4897D-22,  678, 'R', & ! 1663
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3999020178D0, -7.219930629422D-05,  0.0000D+00,  679, 'P', & ! 1664
     &         -0.9D0,         3.5D0,        0.0D0,      0.0D0,     & !
     & 3.0139615118D0, -7.219850385318D-05,  0.0000D+00,  680, 'R', & ! 1665
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0139615118D0, -7.219849612758D-05,  0.0000D+00,  681, 'R', & ! 1666
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.6156952680D0, -7.219188803988D-05,  0.0000D+00,  682, 'P', & ! 1667
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2152417650D0, -7.217510314614D-05,  0.0000D+00,  683, 'P', & ! 1668
     &          7.7D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 2.2528729908D0, -7.217392129897D-05,  0.0000D+00,  684, 'R', & ! 1669
     &         -0.2D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.2528729908D0, -7.217391357336D-05,  0.0000D+00,  685, 'P', & ! 1670
     &         -4.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1671,1680 ) &
     & /                             &
     & 2.2528729908D0, -7.217390584775D-05,  0.0000D+00,  686, 'P', & ! 1671
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 0.5111132668D0, -7.216976032579D-05,  7.3406D-23,  687, 'R', & ! 1672
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1043043144D0, -7.216974130576D-05,  7.6608D-23,  688, 'P', & ! 1673
     &          6.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9218651144D0, -7.215904434370D-05,  6.9333D-23,  690, 'P', & ! 1674
     &        -22.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8147882620D0, -7.215831825240D-05,  0.0000D+00,  691, 'P', & ! 1675
     &         38.5D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 4.5564541535D0, -7.214998162609D-05,  0.0000D+00,  692, 'P', & ! 1676
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4917844698D0, -7.214933874475D-05,  0.0000D+00,  693, 'P', & ! 1677
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4917844698D0, -7.214933101914D-05,  0.0000D+00,  694, 'P', & ! 1678
     &         -0.3D0,        -2.5D0,        0.0D0,      0.0D0,     & !
     & 1.4917844698D0, -7.214932329353D-05,  0.0000D+00,  695, 'P', & ! 1679
     &         -6.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0226112215D0, -7.214834738164D-05,  6.2058D-23,  697, 'R', & ! 1680
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1681,1690 ) &
     & /                             &
     & 0.1311494518D0, -7.214153335866D-05,  0.0000D+00,  698, 'P', & ! 1681
     &          0.5D0,        -6.7D0,        0.0D0,      0.0D0,     & !
     & 5.2658477420D0, -7.213826654646D-05,  0.0000D+00,  699, 'P', & ! 1682
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6435750512D0, -7.213736504551D-05,  0.0000D+00,  700, 'P', & ! 1683
     &          0.0D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 0.7306959488D0, -7.212476391614D-05,  0.0000D+00,  701, 'P', & ! 1684
     &         -0.3D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.4206903388D0, -7.212475203227D-05,  1.0484D-24,  702, 'P', & ! 1685
     &       3183.5D0,        -2.8D0,    -5409.0D0,      4.8D0,     & !
     & 0.7306960792D0, -7.212473301224D-05,  4.2513D-24,  703, 'P', & ! 1686
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3447554428D0, -7.212393057267D-05,  0.0000D+00,  704, 'P', & ! 1687
     &          0.0D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.2382511388D0, -7.211405507021D-05, -6.2268D-24,  705, 'P', & ! 1688
     &        -19.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3389972460D0, -7.210335810814D-05, -1.3502D-23,  706, 'R', & ! 1689
     &          1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6490029864D0, -7.210333908812D-05, -1.0299D-23,  707, 'P', & ! 1690
     &          8.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1691,1700 ) &
     & /                             &
     & 2.5836669218D0, -7.209934029285D-05,  0.0000D+00,  708, 'P', & ! 1691
     &          0.0D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 0.4665637864D0, -7.209264212606D-05, -1.7574D-23,  709, 'P', & ! 1692
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8225784008D0, -7.207476546424D-05,  0.0000D+00,  710, 'P', & ! 1693
     &          1.0D0,        -4.8D0,        0.0D0,      0.0D0,     & !
     & 3.6755493738D0, -7.204938046899D-05,  0.0000D+00,  713, 'R', & ! 1694
     &         -0.3D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.6755493738D0, -7.204937274338D-05,  0.0000D+00,  714, 'P', & ! 1695
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9144608528D0, -7.202479018916D-05,  0.0000D+00,  715, 'P', & ! 1696
     &          0.0D0,        -1.7D0,        0.0D0,      0.0D0,     & !
     & 2.9144608528D0, -7.202478246355D-05,  0.0000D+00,  716, 'P', & ! 1697
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7674318258D0, -7.199938974269D-05,  0.0000D+00,  718, 'P', & ! 1698
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 0.0859802748D0, -7.199278938060D-05,  0.0000D+00,  719, 'P', & ! 1699
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6855267718D0, -7.197600448686D-05,  0.0000D+00,  720, 'P', & ! 1700
     &          1.9D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1701,1710 ) &
     & /                             &
     & 4.0611791372D0, -7.197064443052D-05,  7.6070D-23,  721, 'P', & ! 1701
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8787399372D0, -7.195994746846D-05,  6.8795D-23,  722, 'P', & ! 1702
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2850732688D0, -7.195921959312D-05,  0.0000D+00,  723, 'P', & ! 1703
     &         -0.6D0,         2.5D0,        0.0D0,      0.0D0,     & !
     & 3.2452547838D0, -7.195022463426D-05,  0.0000D+00,  724, 'P', & ! 1704
     &          0.0D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 3.3775651616D0, -7.192565515703D-05,  5.0980D-25,  726, 'P', & ! 1705
     &         87.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.6875709020D0, -7.192563613701D-05,  3.7127D-24,  727, 'P', & ! 1706
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0982257568D0, -7.192483963900D-05,  0.0000D+00,  728, 'R', & ! 1707
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 5.0982257568D0, -7.192483191340D-05,  0.0000D+00,  729, 'P', & ! 1708
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6058778092D0, -7.190424221288D-05, -1.0838D-23,  730, 'P', & ! 1709
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3371372358D0, -7.190024935918D-05,  0.0000D+00,  731, 'P', & ! 1710
     &          0.0D0,        -1.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1711,1720 ) &
     & /                             &
     & 4.3371372358D0, -7.190024163357D-05,  0.0000D+00,  732, 'P', & ! 1711
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2377168326D0, -7.180029880902D-05,  0.0000D+00,  735, 'R', & ! 1712
     &          0.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.2377168326D0, -7.180029108341D-05,  0.0000D+00,  736, 'P', & ! 1713
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7598136188D0, -7.177570852920D-05,  0.0000D+00,  737, 'P', & ! 1714
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 4.2376365768D0, -7.172655114637D-05,  0.0000D+00,  738, 'P', & ! 1715
     &          1.5D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 1.6603932156D0, -7.167575025343D-05,  0.0000D+00,  740, 'P', & ! 1716
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0830695986D0, -7.155120942345D-05,  0.0000D+00,  743, 'P', & ! 1717
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5057459816D0, -7.142666859347D-05,  0.0000D+00,  747, 'P', & ! 1718
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9284223646D0, -7.130212776349D-05,  0.0000D+00,  749, 'P', & ! 1719
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6592551608D0, -7.125386354696D-05, -3.0481D-23,  750, 'P', & ! 1720
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1721,1730 ) &
     & /                             &
     & 0.4768159608D0, -7.124316658490D-05, -3.7756D-23,  751, 'R', & ! 1721
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8875678084D0, -7.123245060281D-05, -4.1828D-23,  752, 'P', & ! 1722
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2039538328D0, -7.118746132932D-05, -1.1739D-22,  754, 'P', & ! 1723
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7985691836D0, -7.106546363379D-05, -2.3744D-23,  756, 'P', & ! 1724
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6161299836D0, -7.105476667173D-05, -3.1019D-23,  757, 'P', & ! 1725
     &          7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4336907836D0, -7.104406970966D-05, -3.8294D-23,  758, 'R', & ! 1726
     &         15.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0268818312D0, -7.104405068964D-05, -3.5092D-23,  759, 'P', & ! 1727
     &         -6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5344368908D0, -7.103337274760D-05, -4.5570D-23,  761, 'R', & ! 1728
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8444426312D0, -7.103335372757D-05, -4.2367D-23,  760, 'P', & ! 1729
     &        -27.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9451887384D0, -7.102265676551D-05, -4.9642D-23,  762, 'R', & ! 1730
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1731,1740 ) &
     & /                             &
     & 4.6442282970D0, -7.101085909083D-05, -8.0147D-23,  763, 'P', & ! 1731
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7335299500D0, -7.099978750817D-05, -4.3444D-23,  764, 'R', & ! 1732
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3432678556D0, -7.099906141614D-05, -1.1065D-22,  765, 'P', & ! 1733
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1608286556D0, -7.098836445408D-05, -1.1793D-22,  766, 'P', & ! 1734
     &        -15.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2615747628D0, -7.097766749202D-05, -1.2520D-22,  767, 'R', & ! 1735
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2566187820D0, -7.090065906998D-05,  4.4002D-23,  768, 'P', & ! 1736
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0741795820D0, -7.088996210792D-05,  3.6727D-23,  769, 'R', & ! 1737
     &          3.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1960248180D0, -7.088424163706D-05, -4.3444D-23,  770, 'R', & ! 1738
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1749256892D0, -7.087926514585D-05,  2.9452D-23,  771, 'R', & ! 1739
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0564044478D0, -7.087816443323D-05,  6.2221D-24,  772, 'P', & ! 1740
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1741,1750 ) &
     & /                             &
     & 3.8739652478D0, -7.086746747117D-05, -1.0531D-24,  773, 'R', & ! 1741
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6915260478D0, -7.085677050911D-05, -8.3283D-24,  774, 'R', & ! 1742
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1661958540D0, -7.085565077646D-05, -2.8355D-23,  775, 'P', & ! 1743
     &          3.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3905656065D0, -7.084497283442D-05, -3.8833D-23,  776, 'R', & ! 1744
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9837566540D0, -7.084495381440D-05, -3.5630D-23,  777, 'P', & ! 1745
     &       -166.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.8013174540D0, -7.083425685234D-05, -4.2905D-23,  778, 'P', & ! 1746
     &       -720.9D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.9020635612D0, -7.082355989027D-05, -5.0181D-23,  779, 'R', & ! 1747
     &         20.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5003570126D0, -7.082245917765D-05, -7.3410D-23,  780, 'P', & ! 1748
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6042684598D0, -7.081747374264D-05, -4.3444D-23,  781, 'R', & ! 1749
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7196243612D0, -7.081286292821D-05, -5.7456D-23,  782, 'R', & ! 1750
     &         -0.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1751,1760 ) &
     & /                             &
     & 4.6011031198D0, -7.081176221559D-05, -8.0685D-23,  783, 'P', & ! 1751
     &          4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3355158938D0, -7.075970080708D-05, -4.3444D-23,  785, 'R', & ! 1752
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3959328048D0, -7.071225915680D-05,  5.0739D-23,  786, 'P', & ! 1753
     &          8.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2134936048D0, -7.070156219474D-05,  4.3464D-23,  787, 'P', & ! 1754
     &         56.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0310544048D0, -7.069086523268D-05,  3.6188D-23,  788, 'R', & ! 1755
     &         68.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6242454524D0, -7.069084621265D-05,  3.9391D-23,  789, 'P', & ! 1756
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1318005120D0, -7.068016827062D-05,  2.8913D-23,  790, 'R', & ! 1757
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4418062524D0, -7.068014925059D-05,  3.2116D-23,  791, 'P', & ! 1758
     &         -8.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2593670524D0, -7.066945228853D-05,  2.4841D-23,  792, 'R', & ! 1759
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2415919182D0, -7.065765461384D-05, -5.6640D-24,  793, 'P', & ! 1760
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1761,1770 ) &
     & /                             &
     & 6.1230706768D0, -7.065655390122D-05, -2.8894D-23,  794, 'P', & ! 1761
     &         79.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3707120562D0, -7.065557799006D-05,  3.1039D-23,  795, 'R', & ! 1762
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0477082640D0, -7.064658303119D-05,  3.1039D-23,  796, 'R', & ! 1763
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9406314768D0, -7.064585693916D-05, -3.6169D-23,  797, 'P', & ! 1764
     &      -3401.7D0,         0.8D0,     -317.1D0,      0.1D0,     & !
     & 0.1313738815D0, -7.063588918218D-05, -1.2405D-23,  798, 'R', & ! 1765
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9251628701D0, -7.063527161821D-05, -4.3444D-23,  799, 'P', & ! 1766
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 1.7581922768D0, -7.063515997710D-05, -4.3444D-23,  800, 'P', & ! 1767
     &     -15436.9D0,         3.6D0,     -317.1D0,      0.1D0,     & !
     & 4.8744069907D0, -7.063504833598D-05, -4.3444D-23,  801, 'R', & ! 1768
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.3850106721D0, -7.063443077201D-05, -7.4483D-23,  802, 'P', & ! 1769
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6472547610D0, -7.062979813745D-05,  3.1039D-23,  803, 'R', & ! 1770
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1771,1780 ) &
     & /                             &
     & 5.8589383840D0, -7.062446301503D-05, -5.0719D-23,  804, 'R', & ! 1771
     &        444.1D0,        -0.1D0,     -317.1D0,      0.1D0,     & !
     & 3.6764991840D0, -7.061376605297D-05, -5.7994D-23,  805, 'R', & ! 1772
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6677693488D0, -7.059015168358D-05, -1.1580D-22,  806, 'P', & ! 1773
     &         -8.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4853301488D0, -7.057945472152D-05, -1.2308D-22,  807, 'P', & ! 1774
     &         -5.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3028909488D0, -7.056875775945D-05, -1.3035D-22,  808, 'P', & ! 1775
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1703684276D0, -7.050246531950D-05,  4.2925D-23,  809, 'P', & ! 1776
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4803741680D0, -7.050244629948D-05,  4.6128D-23,  810, 'P', & ! 1777
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9879292276D0, -7.049176835744D-05,  3.5650D-23,  812, 'R', & ! 1778
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5811202752D0, -7.049174933741D-05,  3.8853D-23,  811, 'P', & ! 1779
     &       -118.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3986810752D0, -7.048105237535D-05,  3.1577D-23,  814, 'P', & ! 1780
     &       -465.6D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1781,1790 ) &
     & /                             &
     & 3.2801598338D0, -7.047995166273D-05,  8.3478D-24,  815, 'P', & ! 1781
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2162418752D0, -7.047035541329D-05,  2.4302D-23,  816, 'R', & ! 1782
     &         10.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0977206338D0, -7.046925470067D-05,  1.0726D-24,  817, 'P', & ! 1783
     &         87.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2016320810D0, -7.046426926565D-05,  3.1039D-23,  818, 'R', & ! 1784
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1984667410D0, -7.045855773861D-05, -6.2026D-24,  820, 'P', & ! 1785
     &        415.9D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 6.0799454996D0, -7.045745702599D-05, -2.9432D-23,  821, 'P', & ! 1786
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0160275410D0, -7.044786077654D-05, -1.3478D-23,  822, 'R', & ! 1787
     &        -11.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8975062996D0, -7.044676006392D-05, -3.6707D-23,  823, 'P', & ! 1788
     &         25.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7150670996D0, -7.043606310186D-05, -4.3983D-23,  825, 'P', & ! 1789
     &         93.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3082581472D0, -7.043604408183D-05, -4.0780D-23,  826, 'P', & ! 1790
     &         31.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1791,1800 ) &
     & /                             &
     & 5.8158132068D0, -7.042536613980D-05, -5.1258D-23,  828, 'R', & ! 1791
     &         -2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1258189472D0, -7.042534711977D-05, -4.8055D-23,  827, 'P', & ! 1792
     &         14.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9433797472D0, -7.041465015771D-05, -5.5330D-23,  829, 'P', & ! 1793
     &         -1.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9328795150D0, -7.040649633010D-05,  3.1039D-23,  830, 'R', & ! 1794
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6035450428D0, -7.038607831714D-05, -4.3444D-23,  831, 'P', & ! 1795
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8108572260D0, -7.034835771776D-05,  1.1795D-22,  832, 'R', & ! 1796
     &          2.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6284180260D0, -7.033766075569D-05,  1.1067D-22,  833, 'R', & ! 1797
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7291641332D0, -7.032696379363D-05,  1.0340D-22,  834, 'R', & ! 1798
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8389555394D0, -7.030445013686D-05,  6.8819D-23,  835, 'R', & ! 1799
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4372489908D0, -7.030334942424D-05,  4.5589D-23,  836, 'P', & ! 1800
     &        398.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1801,1810 ) &
     & /                             &
     & 1.3964024118D0, -7.029266018815D-05,  3.7251D-23,  838, 'P', & ! 1801
     &          0.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.5379950980D0, -7.029265246218D-05,  3.8314D-23,  837, 'P', & ! 1802
     &     -14139.6D0,         0.8D0,    -1901.2D0,      0.1D0,     & !
     & 3.4664934138D0, -7.028731733976D-05, -4.3444D-23,  839, 'P', & ! 1803
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7287375027D0, -7.028268470520D-05,  6.2078D-23,  840, 'R', & ! 1804
     &          2.1D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 5.5225264913D0, -7.028206714123D-05,  3.1039D-23,  841, 'P', & ! 1805
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 2.3555558980D0, -7.028195550011D-05,  3.1039D-23,  842, 'P', & ! 1806
     &     -70209.1D0,         2.8D0,    -2218.0D0,      0.1D0,     & !
     & 5.4971485842D0, -7.028194777414D-05,  3.2102D-23,  845, 'P', & ! 1807
     &          0.0D0,         1.3D0,        0.0D0,      0.0D0,     & !
     & 5.9487469455D0, -7.028193648009D-05,  3.4242D-23,  844, 'P', & ! 1808
     &          2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4717706119D0, -7.028184385900D-05,  3.1039D-23,  846, 'R', & ! 1809
     &          0.0D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 6.2484791108D0, -7.028122940808D-05, -3.6169D-23,  847, 'P', & ! 1810
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1811,1820 ) &
     & /                             &
     & 3.9823742933D0, -7.028122629503D-05,  0.0000D+00,  848, 'P', & ! 1811
     &         -2.0D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 0.1731166980D0, -7.027125853805D-05,  2.3764D-23,  849, 'R', & ! 1812
     &       2028.2D0,        -0.1D0,    -1901.1D0,      0.1D0,     & !
     & 3.7663077455D0, -7.027123951802D-05,  2.6966D-23,  850, 'P', & ! 1813
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0660399108D0, -7.027053244602D-05, -4.3444D-23,  851, 'P', & ! 1814
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0545954566D0, -7.027015782543D-05,  5.3394D-25,  852, 'P', & ! 1815
     &        -11.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9927836340D0, -7.027014831542D-05,  2.1354D-24,  853, 'P', & ! 1816
     &          0.0D0,         6.5D0,        0.0D0,      0.0D0,     & !
     & 6.0262214258D0, -7.026153748715D-05, -4.3444D-23,  854, 'P', & ! 1817
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2738628052D0, -7.026056157599D-05,  1.6488D-23,  855, 'R', & ! 1818
     &        -12.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1553415638D0, -7.025946086337D-05, -6.7413D-24,  857, 'P', & ! 1819
     &        -55.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8103444340D0, -7.025945135336D-05, -5.1398D-24,  858, 'P', & ! 1820
     &          0.0D0,       -50.9D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1821,1830 ) &
     & /                             &
     & 2.4653473042D0, -7.025944184334D-05, -3.5384D-24,  859, 'P', & ! 1821
     &        -18.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5944674422D0, -7.025736521956D-05,  3.3164D-23,  860, 'P', & ! 1822
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9729023638D0, -7.024876390131D-05, -1.4016D-23,  861, 'R', & ! 1823
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6279052340D0, -7.024875439129D-05, -1.2415D-23,  863, 'P', & ! 1824
     &          0.0D0,         7.5D0,        0.0D0,      0.0D0,     & !
     & 0.2829081042D0, -7.024874488128D-05, -1.0814D-23,  862, 'P', & ! 1825
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5546489572D0, -7.024837026069D-05,  3.3164D-23,  864, 'P', & ! 1826
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8543811225D0, -7.024766318869D-05, -3.7246D-23,  865, 'P', & ! 1827
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1643868628D0, -7.024764416866D-05, -3.4043D-23,  866, 'P', & ! 1828
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6383145747D0, -7.023767641168D-05, -1.0280D-23,  867, 'P', & ! 1829
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6719419225D0, -7.023696622662D-05, -4.4521D-23,  869, 'P', & ! 1830
     &          7.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1831,1840 ) &
     & /                             &
     & 5.2651329700D0, -7.023694720660D-05, -4.1318D-23,  868, 'P', & ! 1831
     &     -24827.1D0,         0.8D0,     2072.6D0,     -0.1D0,     & !
     & 0.6087660581D0, -7.023621800151D-05, -7.2357D-23,  870, 'P', & ! 1832
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0826937700D0, -7.022625024453D-05, -4.8594D-23,  871, 'P', & ! 1833
     &      -4578.9D0,         0.1D0,     -633.6D0,      0.0D0,     & !
     & 0.9002545700D0, -7.021555328247D-05, -5.5869D-23,  873, 'P', & ! 1834
     &        400.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0010006772D0, -7.020485632041D-05, -6.3144D-23,  874, 'R', & ! 1835
     &         -9.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7782322810D0, -7.015741467013D-05,  3.1039D-23,  876, 'P', & ! 1836
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9960446964D0, -7.012784789837D-05,  1.0606D-22,  877, 'R', & ! 1837
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6950842550D0, -7.011605022369D-05,  7.5555D-23,  878, 'P', & ! 1838
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7958303622D0, -7.010535326162D-05,  6.8280D-23,  879, 'R', & ! 1839
     &         -3.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3941238136D0, -7.010425254900D-05,  4.5051D-23,  880, 'P', & ! 1840
     &         -2.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1841,1850 ) &
     & /                             &
     & 3.5094797150D0, -7.009964173458D-05,  3.1039D-23,  881, 'P', & ! 1841
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4948699208D0, -7.009355558694D-05,  3.7775D-23,  882, 'P', & ! 1842
     &         80.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3124307208D0, -7.008285862488D-05,  3.0500D-23,  883, 'P', & ! 1843
     &        335.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9056217684D0, -7.008283960485D-05,  3.3703D-23,  884, 'P', & ! 1844
     &         14.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1299915208D0, -7.007216166281D-05,  2.3225D-23,  886, 'R', & ! 1845
     &         -7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7231825684D0, -7.007214264279D-05,  2.6428D-23,  885, 'P', & ! 1846
     &          8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5407433684D0, -7.006144568072D-05,  1.9153D-23,  887, 'R', & ! 1847
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4222221270D0, -7.006034496810D-05, -4.0770D-24,  889, 'P', & ! 1848
     &        141.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2397829270D0, -7.004964800604D-05, -1.1352D-23,  890, 'P', & ! 1849
     &         25.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3405290342D0, -7.003895104398D-05, -1.8627D-23,  891, 'R', & ! 1850
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1851,1860 ) &
     & /                             &
     & 5.2220077928D0, -7.003785033136D-05, -4.1857D-23,  892, 'P', & ! 1851
     &        -93.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0395685928D0, -7.002715336930D-05, -4.9132D-23,  893, 'P', & ! 1852
     &        -21.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8571293928D0, -7.001645640723D-05, -5.6407D-23,  894, 'P', & ! 1853
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1353587192D0, -6.993944798519D-05,  1.1280D-22,  895, 'P', & ! 1854
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9529195192D0, -6.992875102313D-05,  1.0552D-22,  896, 'R', & ! 1855
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7704803192D0, -6.991805406107D-05,  9.8246D-23,  897, 'R', & ! 1856
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4517447436D0, -6.989445871170D-05,  3.7237D-23,  898, 'P', & ! 1857
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7617504840D0, -6.989443969168D-05,  4.0440D-23,  899, 'P', & ! 1858
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2693055436D0, -6.988376174964D-05,  2.9962D-23,  901, 'P', & ! 1859
     &          3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8624965912D0, -6.988374272961D-05,  3.3164D-23,  900, 'P', & ! 1860
     &      -5747.8D0,        -0.9D0,      795.8D0,      0.1D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1861,1870 ) &
     & /                             &
     & 3.6800573912D0, -6.987304576755D-05,  2.5889D-23,  902, 'P', & ! 1861
     &      -1297.4D0,        -0.2D0,     -316.5D0,      0.0D0,     & !
     & 1.4976181912D0, -6.986234880549D-05,  1.8614D-23,  903, 'R', & ! 1862
     &         75.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5983642984D0, -6.985165184342D-05,  1.1339D-23,  904, 'R', & ! 1863
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1788826156D0, -6.983875345612D-05, -4.2396D-23,  905, 'P', & ! 1864
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4071952632D0, -6.981734051197D-05, -5.3743D-23,  906, 'P', & ! 1865
     &         18.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2247560632D0, -6.980664354991D-05, -6.1018D-23,  907, 'P', & ! 1866
     &          4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9097943420D0, -6.972965414789D-05,  1.0498D-22,  908, 'R', & ! 1867
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0195857482D0, -6.970714049112D-05,  7.0406D-23,  909, 'P', & ! 1868
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8193714140D0, -6.968464585437D-05,  3.2626D-23,  910, 'P', & ! 1869
     &       -259.0D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6369322140D0, -6.967394889231D-05,  2.5351D-23,  911, 'P', & ! 1870
     &        -54.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1871,1880 ) &
     & /                             &
     & 1.4544930140D0, -6.966325193025D-05,  1.8075D-23,  912, 'R', & ! 1871
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3640700860D0, -6.961824363673D-05, -5.4282D-23,  913, 'P', & ! 1872
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1766749052D0, -6.953053825263D-05,  1.0765D-22,  914, 'P', & ! 1873
     &          5.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7762462368D0, -6.948554897914D-05,  3.2087D-23,  915, 'P', & ! 1874
     &         -9.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5938070368D0, -6.947485201707D-05,  2.4812D-23,  916, 'P', & ! 1875
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0045588844D0, -6.946413603498D-05,  2.0740D-23,  917, 'P', & ! 1876
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6026349080D0, -6.874735515142D-05, -8.5811D-23,  919, 'P', & ! 1877
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8323718588D0, -6.860396353177D-05, -6.7171D-24,  920, 'R', & ! 1878
     &          0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2431237064D0, -6.859324754968D-05, -1.0789D-23,  921, 'P', & ! 1879
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7419489308D0, -6.855895523825D-05, -7.9074D-23,  923, 'P', & ! 1880
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1881,1890 ) &
     & /                             &
     & 3.5595097308D0, -6.854825827619D-05, -8.6349D-23,  924, 'P', & ! 1881
     &        -11.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3770705308D0, -6.853756131412D-05, -9.3625D-23,  925, 'R', & ! 1882
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9716858816D0, -6.841556361859D-05,  1.9472D-26,  926, 'P', & ! 1883
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7892466816D0, -6.840486665653D-05, -7.2557D-24,  927, 'R', & ! 1884
     &          5.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1999985292D0, -6.839415067444D-05, -1.1328D-23,  928, 'P', & ! 1885
     &        -21.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0175593292D0, -6.838345371238D-05, -1.8603D-23,  930, 'R', & ! 1886
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7165988878D0, -6.837165603769D-05, -4.9108D-23,  931, 'P', & ! 1887
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5980776465D0, -6.837055532507D-05, -7.2338D-23,  932, 'P', & ! 1888
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6988237536D0, -6.835985836301D-05, -7.9613D-23,  933, 'P', & ! 1889
     &        -27.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5163845536D0, -6.834916140095D-05, -8.6888D-23,  934, 'P', & ! 1890
     &       -129.1D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1891,1900 ) &
     & /                             &
     & 1.3339453536D0, -6.833846443889D-05, -9.4163D-23,  935, 'R', & ! 1891
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2683954088D0, -6.824503858393D-05, -1.2405D-23,  938, 'R', & ! 1892
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2385664448D0, -6.821644772333D-05,  2.6837D-24,  939, 'P', & ! 1893
     &          4.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0561272448D0, -6.820575076127D-05, -4.5915D-24,  940, 'P', & ! 1894
     &         34.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1568733520D0, -6.819505379920D-05, -1.1867D-23,  942, 'P', & ! 1895
     &       -438.9D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 1.9744341520D0, -6.818435683714D-05, -1.9142D-23,  943, 'R', & ! 1896
     &         12.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8559129106D0, -6.818325612452D-05, -4.2371D-23,  944, 'P', & ! 1897
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9598243578D0, -6.817827068950D-05, -1.2405D-23,  945, 'R', & ! 1898
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6734737106D0, -6.817255916246D-05, -4.9647D-23,  947, 'P', & ! 1899
     &         10.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4732593765D0, -6.815006452571D-05, -8.7427D-23,  949, 'P', & ! 1900
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1901,1910 ) &
     & /                             &
     & 0.7832651168D0, -6.815004550568D-05, -8.4224D-23,  950, 'P', & ! 1901
     &        -12.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8840112240D0, -6.813934854362D-05, -9.1499D-23,  951, 'P', & ! 1902
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5690495028D0, -6.806235914161D-05,  7.4502D-23,  952, 'P', & ! 1903
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3866103028D0, -6.805166217955D-05,  6.7227D-23,  953, 'R', & ! 1904
     &          2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7973621504D0, -6.804094619746D-05,  6.3155D-23,  955, 'P', & ! 1905
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3139625090D0, -6.801845156071D-05,  2.5375D-23,  956, 'P', & ! 1906
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1954412676D0, -6.801735084809D-05,  2.1451D-24,  957, 'P', & ! 1907
     &         93.9D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.0130020676D0, -6.800665388603D-05, -5.1301D-24,  958, 'P', & ! 1908
     &       1400.7D0,         1.6D0,      314.9D0,      0.4D0,     & !
     & 2.4869297795D0, -6.799668612905D-05,  1.8633D-23,  959, 'R', & ! 1909
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1137481748D0, -6.799595692396D-05, -1.2405D-23,  960, 'P', & ! 1910
     &      -6407.4D0,        -7.5D0,     -314.9D0,     -0.4D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1911,1920 ) &
     & /                             &
     & 1.4237539152D0, -6.799593790394D-05, -9.2024D-24,  961, 'P', & ! 1911
     &         17.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7405665701D0, -6.799522771888D-05, -4.3444D-23,  962, 'P', & ! 1912
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9313089748D0, -6.798525996190D-05, -1.9681D-23,  963, 'R', & ! 1913
     &        183.0D0,         0.2D0,     -314.9D0,     -0.4D0,     & !
     & 5.5245000224D0, -6.798524094188D-05, -1.6478D-23,  964, 'P', & ! 1914
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0320550820D0, -6.797456299984D-05, -2.6956D-23,  965, 'R', & ! 1915
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6303485335D0, -6.797346228722D-05, -5.0185D-23,  966, 'P', & ! 1916
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5685367108D0, -6.797345277721D-05, -4.8584D-23,  968, 'P', & ! 1917
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 4.2235395810D0, -6.797344326719D-05, -4.6982D-23,  967, 'P', & ! 1918
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7401399396D0, -6.795094863045D-05, -8.4762D-23,  969, 'P', & ! 1919
     &       -277.4D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.8408860468D0, -6.794025166838D-05, -9.2038D-23,  970, 'P', & ! 1920
     &        -51.3D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1921,1930 ) &
     & /                             &
     & 2.6584468468D0, -6.792955470632D-05, -9.9313D-23,  971, 'P', & ! 1921
     &          6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6534908660D0, -6.785254628428D-05,  6.9891D-23,  973, 'P', & ! 1922
     &         -7.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7753361020D0, -6.784682581343D-05, -1.0280D-23,  974, 'P', & ! 1923
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7542369732D0, -6.784184932222D-05,  6.2616D-23,  975, 'P', & ! 1924
     &        -38.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5717977732D0, -6.783115236016D-05,  5.5341D-23,  976, 'R', & ! 1925
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4532765318D0, -6.783005164754D-05,  3.2111D-23,  977, 'P', & ! 1926
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2708373318D0, -6.781935468547D-05,  2.4836D-23,  978, 'P', & ! 1927
     &         33.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1523160905D0, -6.781825397285D-05,  1.6065D-24,  979, 'P', & ! 1928
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3715834390D0, -6.780865772341D-05,  1.7561D-23,  980, 'R', & ! 1929
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2530621976D0, -6.780755701079D-05, -5.6687D-24,  981, 'P', & ! 1930
     &        -44.0D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1931,1940 ) &
     & /                             &
     & 4.0706229976D0, -6.779686004873D-05, -1.2944D-23,  983, 'P', & ! 1931
     &         68.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.3806287380D0, -6.779684102870D-05, -9.7410D-24,  982, 'P', & ! 1932
     &       1432.8D0,         1.8D0,     -629.4D0,     -0.8D0,     & !
     & 1.8881837976D0, -6.778616308666D-05, -2.0219D-23,  985, 'R', & ! 1933
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4813748452D0, -6.778614406664D-05, -1.7016D-23,  984, 'P', & ! 1934
     &        148.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.1835797438D0, -6.778005791900D-05, -1.0280D-23,  986, 'P', & ! 1935
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2989356452D0, -6.777544710457D-05, -2.4291D-23,  987, 'P', & ! 1936
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1804144038D0, -6.777434639196D-05, -4.7521D-23,  988, 'P', & ! 1937
     &        -16.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6970147625D0, -6.775185175521D-05, -8.5301D-23,  989, 'P', & ! 1938
     &          5.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7977608696D0, -6.774115479315D-05, -9.2576D-23,  990, 'P', & ! 1939
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1980124850D0, -6.772228498344D-05, -1.0280D-23,  991, 'P', & ! 1940
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1941,1950 ) &
     & /                             &
     & 2.7928048888D0, -6.766414637111D-05,  7.6628D-23,  993, 'P', & ! 1941
     &         18.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6103656888D0, -6.765344940904D-05,  6.9353D-23,  994, 'P', & ! 1942
     &       -483.9D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 0.2456211088D0, -6.764772715415D-05, -1.0280D-23,  995, 'P', & ! 1943
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 4.7111117960D0, -6.764275244698D-05,  6.2078D-23,  996, 'P', & ! 1944
     &      -2967.4D0,        -4.0D0,        0.0D0,      0.0D0,     & !
     & 2.0211175364D0, -6.764273342695D-05,  6.5280D-23,  997, 'P', & ! 1945
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5286725960D0, -6.763205548492D-05,  5.4802D-23,  998, 'R', & ! 1946
     &         85.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.1384105016D0, -6.763132939289D-05, -1.2405D-23,  999, 'P', & ! 1947
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4101513546D0, -6.763095477230D-05,  3.1573D-23, 1000, 'P', & ! 1948
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3462333960D0, -6.762135852285D-05,  4.7527D-23, 1001, 'R', & ! 1949
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2277121546D0, -6.762025781024D-05,  2.4297D-23, 1002, 'P', & ! 1950
     &         -4.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1951,1960 ) &
     & /                             &
     & 6.1659003320D0, -6.762024830022D-05,  2.5899D-23, 1004, 'P', & ! 1951
     &          0.0D0,        -4.0D0,        0.0D0,      0.0D0,     & !
     & 4.8209032022D0, -6.762023879021D-05,  2.7500D-23, 1003, 'P', & ! 1952
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9834611320D0, -6.760955133816D-05,  1.8624D-23, 1006, 'P', & ! 1953
     &         -0.3D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 0.3783500746D0, -6.760844884150D-05, -4.0673D-24, 1008, 'P', & ! 1954
     &          0.0D0,        -0.8D0,        0.0D0,      0.0D0,     & !
     & 3.5199427608D0, -6.760844111553D-05, -3.0044D-24, 1007, 'P', & ! 1955
     &        -12.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9938704727D0, -6.759847335855D-05,  2.0759D-23, 1009, 'P', & ! 1956
     &        -26.2D0,       -13.0D0,        0.0D0,      0.0D0,     & !
     & 4.5044741541D0, -6.759785579458D-05, -1.0280D-23, 1015, 'P', & ! 1957
     &          0.2D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 0.3502624621D0, -6.759784829185D-05, -4.1318D-23, 1012, 'P', & ! 1958
     &          1.0D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.0274978205D0, -6.759776317349D-05, -1.3483D-23, 1011, 'P', & ! 1959
     &          0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4790961818D0, -6.759775187944D-05, -1.1342D-23, 1013, 'P', & ! 1960
     &          0.8D0,         6.5D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1961,1970 ) &
     & /                             &
     & 1.3375035608D0, -6.759774415346D-05, -1.0280D-23, 1010, 'P', & ! 1961
     &     456685.8D0,       602.6D0,   -30080.1D0,    -41.7D0,     & !
     & 2.3247446595D0, -6.759764001508D-05,  2.0759D-23, 1014, 'P', & ! 1962
     &         -1.0D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 4.4537182747D0, -6.759763251235D-05, -1.0280D-23, 1016, 'P', & ! 1963
     &         -0.3D0,         1.9D0,        0.0D0,      0.0D0,     & !
     & 2.9643219561D0, -6.759701494838D-05, -4.1318D-23, 1017, 'P', & ! 1964
     &         26.2D0,       -13.0D0,        0.0D0,      0.0D0,     & !
     & 0.2265660450D0, -6.759238231382D-05,  6.4203D-23, 1018, 'P', & ! 1965
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8114312727D0, -6.758777639649D-05,  1.3484D-23, 1019, 'P', & ! 1966
     &         -4.8D0,        -2.6D0,        0.0D0,      0.0D0,     & !
     & 2.2966569818D0, -6.758705491737D-05, -1.8618D-23, 1021, 'P', & ! 1967
     &          0.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 5.4382496680D0, -6.758704719140D-05, -1.7555D-23, 1020, 'P', & ! 1968
     &      86002.6D0,       114.0D0,    12588.6D0,     17.5D0,     & !
     & 3.0479875736D0, -6.758632109937D-05, -8.4762D-23, 1023, 'P', & ! 1969
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7818827561D0, -6.758631798632D-05, -4.8594D-23, 1022, 'P', & ! 1970
     &          4.8D0,        -2.6D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1971,1980 ) &
     & /                             &
     & 3.2558104680D0, -6.757635022934D-05, -2.4830D-23, 1024, 'P', & ! 1971
     &      -2629.4D0,        -3.7D0,        0.0D0,      0.0D0,     & !
     & 1.0733712680D0, -6.756565326727D-05, -3.2105D-23, 1025, 'R', & ! 1972
     &         25.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4293860128D0, -6.754776115278D-05, -1.0280D-23, 1027, 'P', & ! 1973
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 6.1653875400D0, -6.753134193582D-05, -9.7187D-23, 1028, 'P', & ! 1974
     &         15.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9829483400D0, -6.752064497376D-05, -1.0446D-22, 1029, 'P', & ! 1975
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7601799438D0, -6.747320332348D-05, -1.0280D-23, 1030, 'P', & ! 1976
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8682009530D0, -6.746615020849D-05,  9.9319D-23, 1031, 'R', & ! 1977
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5672405116D0, -6.745435253381D-05,  6.8814D-23, 1032, 'P', & ! 1978
     &          4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6679866188D0, -6.744365557174D-05,  6.1539D-23, 1033, 'P', & ! 1979
     &         29.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9779923592D0, -6.744363655172D-05,  6.4742D-23, 1034, 'P', & ! 1980
     &        -10.2D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1981,1990 ) &
     & /                             &
     & 2.4855474188D0, -6.743295860968D-05,  5.4264D-23, 1035, 'R', & ! 1981
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0787384664D0, -6.743293958965D-05,  5.7467D-23, 1036, 'P', & ! 1982
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7777780250D0, -6.742114191497D-05,  2.6962D-23, 1037, 'P', & ! 1983
     &         67.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.4914273778D0, -6.741543038792D-05, -1.0280D-23, 1038, 'P', & ! 1984
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5953388250D0, -6.741044495291D-05,  1.9687D-23, 1039, 'P', & ! 1985
     &          8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4128996250D0, -6.739974799085D-05,  1.2411D-23, 1040, 'R', & ! 1986
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2943783836D0, -6.739864727823D-05, -1.0818D-23, 1041, 'P', & ! 1987
     &      -1517.5D0,        -2.3D0,      628.6D0,      0.9D0,     & !
     & 5.3951244908D0, -6.738795031616D-05, -1.8093D-23, 1042, 'P', & ! 1988
     &       -180.8D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.2126852908D0, -6.737725335410D-05, -2.5369D-23, 1043, 'P', & ! 1989
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5226910312D0, -6.737723433407D-05, -2.2166D-23, 1044, 'P', & ! 1990
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=1991,2000 ) &
     & /                             &
     & 4.6234371384D0, -6.736653737201D-05, -2.9441D-23, 1045, 'P', & ! 1991
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1828563268D0, -6.734866249350D-05, -1.0280D-23, 1046, 'P', & ! 1992
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3084754172D0, -6.728954797000D-05,  1.3656D-22, 1047, 'R', & ! 1993
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9348671820D0, -6.724453967648D-05,  6.4203D-23, 1048, 'P', & ! 1994
     &      -1292.2D0,        -2.1D0,        0.0D0,      0.0D0,     & !
     & 6.0356132892D0, -6.723384271442D-05,  5.6928D-23, 1049, 'P', & ! 1995
     &       -226.0D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.8531740892D0, -6.722314575235D-05,  4.9653D-23, 1050, 'R', & ! 1996
     &          9.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2512532065D0, -6.719955040299D-05, -1.1357D-23, 1052, 'P', & ! 1997
     &        -14.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8444442540D0, -6.719953138296D-05, -8.1540D-24, 1053, 'P', & ! 1998
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3519993136D0, -6.718885344092D-05, -1.8632D-23, 1054, 'P', & ! 1999
     &         -1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6620050540D0, -6.718883442090D-05, -1.5429D-23, 1055, 'P', & ! 2000
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2001,2010 ) &
     & /                             &
     & 0.4795658540D0, -6.717813745884D-05, -2.2704D-23, 1056, 'P', & ! 2001
     &       -184.7D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 4.5803119612D0, -6.716744049677D-05, -2.9980D-23, 1057, 'P', & ! 2002
     &        -31.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 2.3978727612D0, -6.715674353471D-05, -3.7255D-23, 1058, 'R', & ! 2003
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8917420048D0, -6.704544280124D-05,  6.3665D-23, 1059, 'P', & ! 2004
     &        -50.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 5.9924881120D0, -6.703474583918D-05,  5.6389D-23, 1060, 'P', & ! 2005
     &         -8.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8100489120D0, -6.702404887712D-05,  4.9114D-23, 1061, 'R', & ! 2006
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4364406768D0, -6.697904058360D-05, -2.3243D-23, 1062, 'P', & ! 2007
     &         -7.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5371867840D0, -6.696834362154D-05, -3.0518D-23, 1063, 'P', & ! 2008
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5322308032D0, -6.689133519950D-05,  1.3869D-22, 1064, 'P', & ! 2009
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8486168276D0, -6.684634592600D-05,  6.3126D-23, 1065, 'P', & ! 2010
     &         -1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2011,2020 ) &
     & /                             &
     & 1.0769294752D0, -6.682493298185D-05,  5.1778D-23, 1066, 'P', & ! 2011
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9581908060D0, -6.610815209829D-05, -5.4772D-23, 1068, 'P', & ! 2012
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2745768305D0, -6.606316282480D-05, -1.3033D-22, 1069, 'P', & ! 2013
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8143195216D0, -6.591975218512D-05, -4.8036D-23, 1070, 'P', & ! 2014
     &          2.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9150656288D0, -6.590905522305D-05, -5.5311D-23, 1072, 'P', & ! 2015
     &        -15.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2250713692D0, -6.590903620303D-05, -5.2108D-23, 1071, 'P', & ! 2016
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7326264288D0, -6.589835826099D-05, -6.2586D-23, 1073, 'R', & ! 2017
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1448025796D0, -6.576566360340D-05,  2.3783D-23, 1074, 'R', & ! 2018
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2723691200D0, -6.575494762131D-05,  1.9711D-23, 1075, 'P', & ! 2019
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9536335445D0, -6.573135227194D-05, -4.1299D-23, 1077, 'P', & ! 2020
     &          2.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2021,2030 ) &
     & /                             &
     & 1.7711943445D0, -6.572065530988D-05, -4.8574D-23, 1078, 'P', & ! 2021
     &         41.2D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 5.8719404516D0, -6.570995834782D-05, -5.5849D-23, 1080, 'P', & ! 2022
     &       -138.3D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.1819461920D0, -6.570993932779D-05, -5.2646D-23, 1079, 'P', & ! 2023
     &         20.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.6895012516D0, -6.569926138575D-05, -6.3125D-23, 1081, 'R', & ! 2024
     &          3.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9995069920D0, -6.569924236573D-05, -5.9922D-23, 1082, 'P', & ! 2025
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4983322165D0, -6.566495005430D-05, -1.2821D-22, 1084, 'P', & ! 2026
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4116831428D0, -6.556654770813D-05,  2.6447D-23, 1085, 'P', & ! 2027
     &          8.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2292439428D0, -6.555585074607D-05,  1.9172D-23, 1086, 'P', & ! 2028
     &        -51.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.1107227015D0, -6.555475003345D-05, -4.0575D-24, 1087, 'P', & ! 2029
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3299900500D0, -6.554515378401D-05,  1.1897D-23, 1088, 'R', & ! 2030
     &          1.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2031,2040 ) &
     & /                             &
     & 5.2114688086D0, -6.554405307139D-05, -1.1333D-23, 1089, 'P', & ! 2031
     &         -2.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0290296086D0, -6.553335610932D-05, -1.8608D-23, 1090, 'P', & ! 2032
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7280691673D0, -6.552155843464D-05, -4.9113D-23, 1091, 'P', & ! 2033
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8288152745D0, -6.551086147258D-05, -5.6388D-23, 1093, 'P', & ! 2034
     &          2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1388210148D0, -6.551084245255D-05, -5.3185D-23, 1092, 'P', & ! 2035
     &        564.4D0,         1.5D0,        0.0D0,      0.0D0,     & !
     & 0.9563818148D0, -6.550014549049D-05, -6.0460D-23, 1094, 'P', & ! 2036
     &        103.1D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 1.9417720206D0, -6.549405934285D-05, -5.3724D-23, 1095, 'P', & ! 2037
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0571279220D0, -6.548944852843D-05, -6.7736D-23, 1096, 'P', & ! 2038
     &         -2.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.9386066806D0, -6.548834781581D-05, -9.0965D-23, 1097, 'P', & ! 2039
     &         -3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5509971656D0, -6.537814779496D-05,  3.3184D-23, 1099, 'P', & ! 2040
     &         -4.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2041,2050 ) &
     & /                             &
     & 2.3685579656D0, -6.536745083289D-05,  2.5909D-23, 1100, 'P', & ! 2041
     &        213.7D0,         0.6D0,        0.0D0,      0.0D0,     & !
     & 0.1861187656D0, -6.535675387083D-05,  1.8633D-23, 1102, 'P', & ! 2042
     &       -682.5D0,        -1.8D0,        0.0D0,      0.0D0,     & !
     & 3.7793098132D0, -6.535673485081D-05,  2.1836D-23, 1101, 'P', & ! 2043
     &         10.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2868648728D0, -6.534605690877D-05,  1.1358D-23, 1103, 'R', & ! 2044
     &         19.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.5968706132D0, -6.534603788874D-05,  1.4561D-23, 1104, 'P', & ! 2045
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9859044315D0, -6.533425923409D-05, -1.9147D-23, 1107, 'P', & ! 2046
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2959101718D0, -6.533424021406D-05, -1.5944D-23, 1106, 'P', & ! 2047
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.2781350376D0, -6.532244253938D-05, -4.6448D-23, 1108, 'P', & ! 2048
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4688774424D0, -6.531247478240D-05, -2.2685D-23, 1109, 'P', & ! 2049
     &         -1.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 3.0956958376D0, -6.531174557731D-05, -5.3724D-23, 1110, 'P', & ! 2050
     &      11943.2D0,        32.5D0,     -472.9D0,     -1.3D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2051,2060 ) &
     & /                             &
     & 4.7225142329D0, -6.531101637223D-05, -8.4762D-23, 1111, 'P', & ! 2051
     &          1.0D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.9132566376D0, -6.530104861525D-05, -6.0999D-23, 1112, 'P', & ! 2052
     &       2249.9D0,         6.1D0,        0.0D0,      0.0D0,     & !
     & 5.0140027448D0, -6.529035165319D-05, -6.8274D-23, 1113, 'P', & ! 2053
     &        -66.3D0,        -0.2D0,      312.4D0,      0.9D0,     & !
     & 2.8315635448D0, -6.527965469112D-05, -7.5549D-23, 1114, 'R', & ! 2054
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8266075640D0, -6.520264626909D-05,  9.3655D-23, 1115, 'P', & ! 2055
     &         -3.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6263932298D0, -6.518015163234D-05,  5.5875D-23, 1116, 'P', & ! 2056
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3254327885D0, -6.516835395766D-05,  2.5370D-23, 1117, 'P', & ! 2057
     &         -7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1429935885D0, -6.515765699559D-05,  1.8095D-23, 1119, 'P', & ! 2058
     &         10.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7361846360D0, -6.515763797557D-05,  2.1298D-23, 1118, 'P', & ! 2059
     &        576.0D0,         1.6D0,        0.0D0,      0.0D0,     & !
     & 4.2437396956D0, -6.514696003353D-05,  1.0820D-23, 1121, 'R', & ! 2060
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2061,2070 ) &
     & /                             &
     & 1.5537454360D0, -6.514694101350D-05,  1.4023D-23, 1120, 'P', & ! 2061
     &         92.9D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.6544915432D0, -6.513624405144D-05,  6.7473D-24, 1122, 'P', & ! 2062
     &         -2.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2527849946D0, -6.513514333882D-05, -1.6482D-23, 1123, 'P', & ! 2063
     &       -332.3D0,        -0.9D0,        0.0D0,      0.0D0,     & !
     & 4.3535311018D0, -6.512444637676D-05, -2.3758D-23, 1124, 'P', & ! 2064
     &        -61.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.1710919018D0, -6.511374941470D-05, -3.1033D-23, 1125, 'P', & ! 2065
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.0525706605D0, -6.511264870208D-05, -5.4262D-23, 1126, 'P', & ! 2066
     &       -114.0D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.8701314605D0, -6.510195174001D-05, -6.1538D-23, 1127, 'P', & ! 2067
     &        -18.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.9708775676D0, -6.509125477795D-05, -6.8813D-23, 1128, 'P', & ! 2068
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2703830758D0, -6.508308193031D-05,  2.0759D-23, 1129, 'P', & ! 2069
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1483607868D0, -6.502494331797D-05,  1.0767D-22, 1130, 'P', & ! 2070
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2071,2080 ) &
     & /                             &
     & 2.9659215868D0, -6.501424635591D-05,  1.0039D-22, 1131, 'P', & ! 2071
     &        -18.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 0.7834823868D0, -6.500354939385D-05,  9.3116D-23, 1132, 'P', & ! 2072
     &       -164.1D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 4.8842284940D0, -6.499285243178D-05,  8.5841D-23, 1133, 'R', & ! 2073
     &          4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.5832680526D0, -6.498105475710D-05,  5.5336D-23, 1136, 'P', & ! 2074
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8932737930D0, -6.498103573708D-05,  5.8539D-23, 1135, 'P', & ! 2075
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8754986588D0, -6.496923806239D-05,  2.8034D-23, 1137, 'P', & ! 2076
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8039969746D0, -6.496390293998D-05, -5.3724D-23, 1138, 'P', & ! 2077
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0662410635D0, -6.495927030542D-05,  5.1798D-23, 1139, 'P', & ! 2078
     &         -5.1D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 0.5768447449D0, -6.495865274145D-05,  2.0759D-23, 1142, 'P', & ! 2079
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 0.5514667726D0, -6.495854882630D-05,  1.9696D-23, 1143, 'P', & ! 2080
     &          0.0D0,         0.8D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2081,2090 ) &
     & /                             &
     & 3.6930594588D0, -6.495854110033D-05,  2.0759D-23, 1140, 'P', & ! 2081
     &      60344.7D0,       162.8D0,    -3770.7D0,    -11.0D0,     & !
     & 0.5260888656D0, -6.495842945921D-05,  2.0759D-23, 1141, 'P', & ! 2082
     &          0.0D0,         0.5D0,        0.0D0,      0.0D0,     & !
     & 5.3198778541D0, -6.495781189525D-05, -1.0280D-23, 1144, 'P', & ! 2083
     &          4.8D0,        -2.4D0,        0.0D0,      0.0D0,     & !
     & 6.1669871707D0, -6.494857334335D-05,  4.4523D-23, 1145, 'P', & ! 2084
     &         -0.9D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 1.5106202588D0, -6.494784413827D-05,  1.3484D-23, 1146, 'P', & ! 2085
     &      11369.1D0,        33.4D0,     1248.1D0,      3.7D0,     & !
     & 5.4035434716D0, -6.494711804624D-05, -5.3724D-23, 1148, 'P', & ! 2086
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1374386541D0, -6.494711493318D-05, -1.7555D-23, 1147, 'P', & ! 2087
     &          0.9D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.0805396795D0, -6.493812308737D-05, -5.3724D-23, 1149, 'P', & ! 2088
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6113663660D0, -6.493714717620D-05,  6.2087D-24, 1150, 'P', & ! 2089
     &       -347.9D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 0.2096598175D0, -6.493604646358D-05, -1.7021D-23, 1151, 'P', & ! 2090
     &         48.9D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2091,2100 ) &
     & /                             &
     & 5.1478479948D0, -6.493603695357D-05, -1.5419D-23, 1152, 'P', & ! 2091
     &          0.0D0,        -5.3D0,        0.0D0,      0.0D0,     & !
     & 3.4289271660D0, -6.492645021414D-05, -1.0665D-24, 1153, 'R', & ! 2092
     &          3.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3104059246D0, -6.492534950152D-05, -2.4296D-23, 1154, 'P', & ! 2093
     &          9.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.9654087948D0, -6.492533999151D-05, -2.2695D-23, 1155, 'P', & ! 2094
     &          0.0D0,        -2.2D0,        0.0D0,      0.0D0,     & !
     & 3.0094454833D0, -6.491355182684D-05, -5.4801D-23, 1156, 'P', & ! 2095
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8270062833D0, -6.490285486478D-05, -6.2076D-23, 1157, 'P', & ! 2096
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.2377581308D0, -6.489213888269D-05, -6.6148D-23, 1158, 'P', & ! 2097
     &       -229.3D0,        -0.7D0,        0.0D0,      0.0D0,     & !
     & 0.0553189308D0, -6.488144192062D-05, -7.3424D-23, 1159, 'P', & ! 2098
     &        -43.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.1560650380D0, -6.487074495856D-05, -8.0699D-23, 1160, 'P', & ! 2099
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1157358418D0, -6.483400027035D-05,  2.0759D-23, 1161, 'P', & ! 2100
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2101,2110 ) &
     & /                             &
     & 0.7403572096D0, -6.480445251861D-05,  9.2578D-23, 1162, 'P', & ! 2101
     &          2.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3335482572D0, -6.480443349858D-05,  9.5781D-23, 1163, 'P', & ! 2102
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8501486158D0, -6.478193886184D-05,  5.8001D-23, 1164, 'P', & ! 2103
     &         13.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9508947230D0, -6.477124189978D-05,  5.0725D-23, 1165, 'P', & ! 2104
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6499342816D0, -6.475944422509D-05,  2.0220D-23, 1166, 'P', & ! 2105
     &       -496.6D0,        -1.5D0,        0.0D0,      0.0D0,     & !
     & 1.4674950816D0, -6.474874726303D-05,  1.2945D-23, 1167, 'P', & ! 2106
     &        -79.6D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.5682411888D0, -6.473805030097D-05,  5.6701D-24, 1168, 'P', & ! 2107
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6780325950D0, -6.471553664419D-05, -2.8907D-23, 1169, 'P', & ! 2108
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2904230800D0, -6.460533662335D-05,  9.5242D-23, 1170, 'P', & ! 2109
     &       -186.7D0,        -0.6D0,        0.0D0,      0.0D0,     & !
     & 2.1079838800D0, -6.459463966128D-05,  8.7967D-23, 1171, 'P', & ! 2110
     &        -32.3D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2111,2120 ) &
     & /                             &
     & 6.2087299872D0, -6.458394269922D-05,  8.0691D-23, 1172, 'R', & ! 2111
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.6068091045D0, -6.456034734985D-05,  1.9682D-23, 1173, 'P', & ! 2112
     &         -4.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4243699045D0, -6.454965038779D-05,  1.2407D-23, 1174, 'P', & ! 2113
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.8351217520D0, -6.453893440570D-05,  8.3343D-24, 1175, 'P', & ! 2114
     &        -48.7D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 0.6526825520D0, -6.452823744364D-05,  1.0591D-24, 1176, 'P', & ! 2115
     &         -8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2472979028D0, -6.440623974811D-05,  9.4703D-23, 1177, 'P', & ! 2116
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0648587028D0, -6.439554278605D-05,  8.7428D-23, 1178, 'P', & ! 2117
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7919965748D0, -6.433983753046D-05,  7.7957D-24, 1179, 'P', & ! 2118
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3900725985D0, -6.362305664690D-05, -9.8755D-23, 1180, 'P', & ! 2119
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0305613968D0, -6.346894904516D-05, -2.3733D-23, 1181, 'P', & ! 2120
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2121,2130 ) &
     & /                             &
     & 3.5293866213D0, -6.343465673373D-05, -9.2018D-23, 1182, 'P', & ! 2121
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3469474213D0, -6.342395977167D-05, -9.9293D-23, 1184, 'P', & ! 2122
     &         -2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9401384688D0, -6.342394075164D-05, -9.6091D-23, 1183, 'P', & ! 2123
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1698754196D0, -6.328054913198D-05, -1.6997D-23, 1185, 'P', & ! 2124
     &          3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9874362196D0, -6.326985216992D-05, -2.4272D-23, 1187, 'P', & ! 2125
     &         -6.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5806272672D0, -6.326983314989D-05, -2.1069D-23, 1186, 'P', & ! 2126
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0881823268D0, -6.325915520786D-05, -3.1547D-23, 1188, 'R', & ! 2127
     &          0.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8970132916D0, -6.322484387640D-05, -9.6629D-23, 1189, 'P', & ! 2128
     &         22.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.7145740916D0, -6.321414691434D-05, -1.0390D-22, 1190, 'P', & ! 2129
     &          4.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0260041353D0, -6.309214921881D-05, -1.0260D-23, 1191, 'P', & ! 2130
     &          1.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2131,2140 ) &
     & /                             &
     & 4.1267502425D0, -6.308145225675D-05, -1.7535D-23, 1192, 'P', & ! 2131
     &         33.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.9443110425D0, -6.307075529468D-05, -2.4811D-23, 1194, 'P', & ! 2132
     &        -52.4D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.5375020900D0, -6.307073627466D-05, -2.1608D-23, 1193, 'P', & ! 2133
     &         25.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 6.0450571496D0, -6.306005833262D-05, -3.2086D-23, 1195, 'R', & ! 2134
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3550628900D0, -6.306003931259D-05, -2.8883D-23, 1196, 'P', & ! 2135
     &          4.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0541024486D0, -6.304824163791D-05, -5.9388D-23, 1197, 'P', & ! 2136
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8538881145D0, -6.302574700116D-05, -9.7168D-23, 1198, 'P', & ! 2137
     &        242.6D0,         1.0D0,        0.0D0,      0.0D0,     & !
     & 2.6714489145D0, -6.301505003910D-05, -1.0444D-22, 1199, 'P', & ! 2138
     &         45.6D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 0.4890097145D0, -6.300435307704D-05, -1.1172D-22, 1200, 'P', & ! 2139
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7672390408D0, -6.292734465500D-05,  5.7486D-23, 1201, 'P', & ! 2140
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2141,2150 ) &
     & /                             &
     & 2.5847998408D0, -6.291664769294D-05,  5.0211D-23, 1202, 'P', & ! 2141
     &         -4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.3845855066D0, -6.289415305619D-05,  1.2431D-23, 1204, 'P', & ! 2142
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.0836250653D0, -6.288235538151D-05, -1.8074D-23, 1205, 'P', & ! 2143
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9011858653D0, -6.287165841944D-05, -2.5349D-23, 1207, 'P', & ! 2144
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4943769128D0, -6.287163939942D-05, -2.2146D-23, 1206, 'P', & ! 2145
     &        529.0D0,         2.2D0,        0.0D0,      0.0D0,     & !
     & 3.3119377128D0, -6.286094243736D-05, -2.9422D-23, 1208, 'P', & ! 2146
     &         97.5D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 1.1294985128D0, -6.285024547529D-05, -3.6697D-23, 1209, 'P', & ! 2147
     &         -2.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.0109772715D0, -6.284914476267D-05, -5.9926D-23, 1210, 'P', & ! 2148
     &        -18.2D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 6.1117233786D0, -6.283844780061D-05, -6.7202D-23, 1211, 'P', & ! 2149
     &         -3.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.8107629373D0, -6.282665012593D-05, -9.7706D-23, 1212, 'P', & ! 2150
     &         -3.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2151,2160 ) &
     & /                             &
     & 0.6233677565D0, -6.273894474182D-05,  6.4223D-23, 1213, 'P', & ! 2151
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7241138636D0, -6.272824777976D-05,  5.6947D-23, 1214, 'P', & ! 2152
     &         24.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.5416746636D0, -6.271755081770D-05,  4.9672D-23, 1216, 'P', & ! 2153
     &        -62.5D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 6.1348657112D0, -6.271753179767D-05,  5.2875D-23, 1215, 'P', & ! 2154
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3592354636D0, -6.270685385564D-05,  4.2397D-23, 1217, 'R', & ! 2155
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6514660698D0, -6.269503716093D-05,  1.5095D-23, 1218, 'P', & ! 2156
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.3505056285D0, -6.268323948624D-05, -1.5410D-23, 1219, 'P', & ! 2157
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8244333404D0, -6.267327172927D-05,  8.3538D-24, 1221, 'P', & ! 2158
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4512517356D0, -6.267254252418D-05, -2.2685D-23, 1220, 'P', & ! 2159
     &       7708.3D0,        33.6D0,     -779.2D0,     -3.4D0,     & !
     & 0.7948848237D0, -6.267181331910D-05, -5.3724D-23, 1222, 'P', & ! 2160
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2161,2170 ) &
     & /                             &
     & 3.2688125356D0, -6.266184556212D-05, -2.9960D-23, 1223, 'P', & ! 2161
     &       1453.4D0,         6.3D0,      310.0D0,      1.4D0,     & !
     & 1.0863733356D0, -6.265114860005D-05, -3.7235D-23, 1224, 'P', & ! 2162
     &        -44.2D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 1.9678520943D0, -6.265004788744D-05, -6.0465D-23, 1225, 'P', & ! 2163
     &          1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1871194428D0, -6.264045163799D-05, -4.4511D-23, 1226, 'R', & ! 2164
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9959504076D0, -6.260614030654D-05, -1.0959D-22, 1227, 'P', & ! 2165
     &         -8.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.8135112076D0, -6.259544334447D-05, -1.1687D-22, 1228, 'P', & ! 2166
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6809886865D0, -6.252915090452D-05,  5.6409D-23, 1229, 'P', & ! 2167
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4985494865D0, -6.251845394246D-05,  4.9134D-23, 1231, 'P', & ! 2168
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0917405340D0, -6.251843492243D-05,  5.2336D-23, 1230, 'P', & ! 2169
     &         97.3D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 3.9093013340D0, -6.250773796037D-05,  4.5061D-23, 1232, 'P', & ! 2170
     &         16.9D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2171,2180 ) &
     & /                             &
     & 1.7268621340D0, -6.249704099831D-05,  3.7786D-23, 1234, 'P', & ! 2171
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6083408926D0, -6.249594028569D-05,  1.4556D-23, 1233, 'P', & ! 2172
     &        -67.2D0,        -0.3D0,        0.0D0,      0.0D0,     & !
     & 0.4259016926D0, -6.248524332363D-05,  7.2812D-24, 1235, 'P', & ! 2173
     &        -12.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.5266477998D0, -6.247454636156D-05,  6.0328D-27, 1236, 'P', & ! 2174
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4081265585D0, -6.247344564894D-05, -2.3224D-23, 1237, 'P', & ! 2175
     &       -106.8D0,        -0.5D0,        0.0D0,      0.0D0,     & !
     & 3.2256873585D0, -6.246274868688D-05, -3.0499D-23, 1238, 'P', & ! 2176
     &        -18.5D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.0432481585D0, -6.245205172482D-05, -3.7774D-23, 1239, 'P', & ! 2177
     &          0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.1390382848D0, -6.236434634071D-05,  1.2416D-22, 1240, 'P', & ! 2178
     &        -10.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9565990848D0, -6.235364937865D-05,  1.1688D-22, 1241, 'R', & ! 2179
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.9478692496D0, -6.233003500926D-05,  5.9073D-23, 1242, 'P', & ! 2180
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2181,2190 ) &
     & /                             &
     & 4.4217969615D0, -6.232006725228D-05,  8.2837D-23, 1243, 'P', & ! 2181
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0486153568D0, -6.231933804720D-05,  5.1798D-23, 1244, 'P', & ! 2182
     &       6203.0D0,        28.4D0,     -778.4D0,     -3.6D0,     & !
     & 1.3922484449D0, -6.231860884211D-05,  2.0759D-23, 1245, 'P', & ! 2183
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8661761568D0, -6.230864108513D-05,  4.4523D-23, 1246, 'P', & ! 2184
     &       1169.1D0,         5.4D0,        0.0D0,      0.0D0,     & !
     & 1.4759140625D0, -6.230791499310D-05, -2.2685D-23, 1247, 'P', & ! 2185
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6837369568D0, -6.229794412307D-05,  3.7247D-23, 1248, 'P', & ! 2186
     &        -35.7D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.5652157155D0, -6.229684341045D-05,  1.4018D-23, 1249, 'P', & ! 2187
     &         10.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2202185856D0, -6.229683390044D-05,  1.5619D-23, 1250, 'P', & ! 2188
     &          0.0D0,        -1.0D0,        0.0D0,      0.0D0,     & !
     & 5.7844830640D0, -6.228724716101D-05,  2.9972D-23, 1251, 'R', & ! 2189
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3827765155D0, -6.228614644839D-05,  6.7426D-24, 1252, 'P', & ! 2190
     &          1.7D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2191,2200 ) &
     & /                             &
     & 5.3650013813D0, -6.227434877371D-05, -2.3762D-23, 1253, 'P', & ! 2191
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5933140288D0, -6.225293582955D-05, -3.5110D-23, 1254, 'P', & ! 2192
     &        -37.1D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 2.4108748288D0, -6.224223886749D-05, -4.2385D-23, 1255, 'P', & ! 2193
     &         -7.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2057045138D0, -6.214273580871D-05,  8.9039D-23, 1256, 'P', & ! 2194
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0054901796D0, -6.212024117196D-05,  5.1259D-23, 1257, 'P', & ! 2195
     &        -82.3D0,        -0.4D0,        0.0D0,      0.0D0,     & !
     & 3.8230509796D0, -6.210954420990D-05,  4.3984D-23, 1258, 'P', & ! 2196
     &        -14.1D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.6406117796D0, -6.209884724783D-05,  3.6709D-23, 1259, 'P', & ! 2197
     &          0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3627936708D0, -6.196613357021D-05,  1.2628D-22, 1260, 'P', & ! 2198
     &        -22.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4635397780D0, -6.195543660815D-05,  1.1901D-22, 1261, 'P', & ! 2199
     &         -4.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.1906776500D0, -6.189973135257D-05,  3.9373D-23, 1262, 'P', & ! 2200
     &         -7.5D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2201,2210 ) &
     & /                             &
     & 3.0082384500D0, -6.188903439051D-05,  3.2098D-23, 1263, 'P', & ! 2201
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3196684936D0, -6.176703669498D-05,  1.2574D-22, 1264, 'P', & ! 2202
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7456284965D0, -6.098385359377D-05, -6.7716D-23, 1265, 'P', & ! 2203
     &         -0.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3720202613D0, -6.093884530025D-05, -1.4007D-22, 1266, 'P', & ! 2204
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.8849425193D0, -6.079545368060D-05, -6.0979D-23, 1267, 'P', & ! 2205
     &          1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7025033193D0, -6.078475671853D-05, -6.8255D-23, 1269, 'P', & ! 2206
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0125090596D0, -6.078473769851D-05, -6.5052D-23, 1268, 'P', & ! 2207
     &          2.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3288950841D0, -6.073974842502D-05, -1.4061D-22, 1270, 'P', & ! 2208
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.4296411913D0, -6.072905146295D-05, -1.4789D-22, 1271, 'P', & ! 2209
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.2422460105D0, -6.064134607885D-05,  1.4042D-23, 1272, 'P', & ! 2210
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2211,2220 ) &
     & /                             &
     & 4.3429921176D0, -6.063064911679D-05,  6.7668D-24, 1273, 'P', & ! 2211
     &         -1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9693838825D0, -6.058564082327D-05, -6.5590D-23, 1274, 'P', & ! 2212
     &         34.9D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.0701299896D0, -6.057494386121D-05, -7.2866D-23, 1275, 'P', & ! 2213
     &          6.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.7691695483D0, -6.056314618652D-05, -1.0337D-22, 1276, 'P', & ! 2214
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.1991208333D0, -6.044224920361D-05,  1.3503D-23, 1277, 'P', & ! 2215
     &          7.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.2998669405D0, -6.043155224155D-05,  6.2282D-24, 1279, 'P', & ! 2216
     &         -8.8D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 1.6098726808D0, -6.043153322152D-05,  9.4310D-24, 1278, 'P', & ! 2217
     &          6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.7106187880D0, -6.042083625946D-05,  2.1558D-24, 1281, 'P', & ! 2218
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9262587053D0, -6.038654394803D-05, -6.6129D-23, 1282, 'P', & ! 2219
     &        303.5D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 5.0270048125D0, -6.037584698597D-05, -7.3404D-23, 1283, 'P', & ! 2220
     &         57.2D0,         0.3D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2221,2230 ) &
     & /                             &
     & 2.8445656125D0, -6.036515002391D-05, -8.0679D-23, 1284, 'P', & ! 2221
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9403557388D0, -6.027744463980D-05,  8.1250D-23, 1285, 'P', & ! 2222
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5667475036D0, -6.023243634629D-05,  8.8924D-24, 1286, 'P', & ! 2223
     &        117.8D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 5.6674936108D0, -6.022173938422D-05,  1.6172D-24, 1287, 'P', & ! 2224
     &         21.7D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 3.4850544108D0, -6.021104242216D-05, -5.6580D-24, 1288, 'P', & ! 2225
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.3665331695D0, -6.020994170954D-05, -2.8888D-23, 1289, 'P', & ! 2226
     &         -7.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1840939695D0, -6.019924474748D-05, -3.6163D-23, 1290, 'P', & ! 2227
     &         -1.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.8831335281D0, -6.018744707279D-05, -6.6668D-23, 1291, 'P', & ! 2228
     &         -6.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9838796353D0, -6.017675011073D-05, -7.3943D-23, 1292, 'P', & ! 2229
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.7964844545D0, -6.008904472663D-05,  8.7986D-23, 1293, 'P', & ! 2230
     &          2.6D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2231,2240 ) &
     & /                             &
     & 4.8972305616D0, -6.007834776457D-05,  8.0711D-23, 1294, 'P', & ! 2231
     &         -5.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.5236223265D0, -6.003333947105D-05,  8.3538D-24, 1296, 'P', & ! 2232
     &       1534.4D0,         9.4D0,        0.0D0,      0.0D0,     & !
     & 5.6243684336D0, -6.002264250898D-05,  1.0786D-24, 1297, 'P', & ! 2233
     &        289.1D0,         1.8D0,        0.0D0,      0.0D0,     & !
     & 3.4419292336D0, -6.001194554692D-05, -6.1966D-24, 1299, 'P', & ! 2234
     &         -8.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 4.3234079923D0, -6.001084483430D-05, -2.9426D-23, 1298, 'P', & ! 2235
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.0683209985D0, -5.996693725340D-05, -7.8554D-23, 1300, 'P', & ! 2236
     &         -6.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.1690671056D0, -5.995624029134D-05, -8.5829D-23, 1301, 'P', & ! 2237
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1641111248D0, -5.987923186930D-05,  8.3375D-23, 1302, 'P', & ! 2238
     &         12.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 6.2648572320D0, -5.986853490724D-05,  7.6100D-23, 1303, 'P', & ! 2239
     &          1.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9638967906D0, -5.985673723256D-05,  4.5595D-23, 1304, 'P', & ! 2240
     &         -9.2D0,        -0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2241,2250 ) &
     & /                             &
     & 2.7814575906D0, -5.984604027049D-05,  3.8320D-23, 1305, 'P', & ! 2241
     &         -1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.4804971493D0, -5.983424259581D-05,  7.8152D-24, 1306, 'P', & ! 2242
     &        -28.5D0,        -0.2D0,        0.0D0,      0.0D0,     & !
     & 5.5812432565D0, -5.982354563375D-05,  5.3998D-25, 1307, 'P', & ! 2243
     &         -5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.4945941828D0, -5.972514328758D-05,  1.5519D-22, 1308, 'P', & ! 2244
     &         -0.6D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.1209859476D0, -5.968013499406D-05,  8.2837D-23, 1309, 'P', & ! 2245
     &        578.8D0,         3.7D0,        0.0D0,      0.0D0,     & !
     & 6.2217320548D0, -5.966943803200D-05,  7.5561D-23, 1310, 'P', & ! 2246
     &        109.0D0,         0.7D0,        0.0D0,      0.0D0,     & !
     & 4.0392928548D0, -5.965874106994D-05,  6.8286D-23, 1312, 'P', & ! 2247
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.9207716135D0, -5.965764035732D-05,  4.5057D-23, 1311, 'P', & ! 2248
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.6656846196D0, -5.961373277642D-05, -4.0710D-24, 1313, 'P', & ! 2249
     &         -4.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.7664307268D0, -5.960303581436D-05, -1.1346D-23, 1314, 'P', & ! 2250
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2251,2260 ) &
     & /                             &
     & 2.0778607705D0, -5.948103811883D-05,  8.2298D-23, 1315, 'P', & ! 2251
     &        -10.7D0,        -0.1D0,        0.0D0,      0.0D0,     & !
     & 6.1786068776D0, -5.947034115676D-05,  7.5023D-23, 1316, 'P', & ! 2252
     &         -1.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7183495688D0, -5.932693051708D-05,  1.5732D-22, 1317, 'P', & ! 2253
     &         -1.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.2630482408D0, -5.926052829944D-05,  7.0412D-23, 1318, 'P', & ! 2254
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.7275761593D0, -5.829964224712D-05, -1.0903D-22, 1319, 'P', & ! 2255
     &          1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.0580592173D0, -5.814555366540D-05, -3.7216D-23, 1321, 'P', & ! 2256
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3680649576D0, -5.814553464537D-05, -3.4013D-23, 1320, 'P', & ! 2257
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.6844509821D0, -5.810054537188D-05, -1.0957D-22, 1322, 'P', & ! 2258
     &          8.5D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 0.5020117821D0, -5.808984840982D-05, -1.1685D-22, 1323, 'P', & ! 2259
     &          1.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.3249397805D0, -5.794643777014D-05, -3.4552D-23, 1324, 'P', & ! 2260
     &         18.3D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2261,2270 ) &
     & /                             &
     & 1.1425005805D0, -5.793574080807D-05, -4.1827D-23, 1325, 'P', & ! 2261
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.5546767313D0, -5.780304615048D-05,  4.4542D-23, 1326, 'P', & ! 2262
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.3722375313D0, -5.779234918842D-05,  3.7267D-23, 1328, 'P', & ! 2263
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9654285788D0, -5.779233016839D-05,  4.0470D-23, 1327, 'P', & ! 2264
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.2818146033D0, -5.774734089490D-05, -3.5090D-23, 1329, 'P', & ! 2265
     &        138.2D0,         1.1D0,        0.0D0,      0.0D0,     & !
     & 1.0993754033D0, -5.773664393284D-05, -4.2365D-23, 1330, 'P', & ! 2266
     &         26.1D0,         0.2D0,        0.0D0,      0.0D0,     & !
     & 5.2001215105D0, -5.772594697077D-05, -4.9641D-23, 1331, 'P', & ! 2267
     &         -0.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.9223034016D0, -5.759323329315D-05,  3.9931D-23, 1332, 'P', & ! 2268
     &         18.3D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 1.7398642016D0, -5.758253633109D-05,  3.2656D-23, 1333, 'P', & ! 2269
     &          3.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.4389037603D0, -5.757073865641D-05,  2.1512D-24, 1334, 'P', & ! 2270
     &         -1.4D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2271,2280 ) &
     & /                             &
     & 3.2386894261D0, -5.754824401966D-05, -3.5629D-23, 1335, 'P', & ! 2271
     &         -3.3D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.9696011525D0, -5.743914471143D-05,  1.1175D-22, 1336, 'P', & ! 2272
     &         -0.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8791782245D0, -5.739413641791D-05,  3.9393D-23, 1337, 'P', & ! 2273
     &        218.9D0,         1.7D0,        0.0D0,      0.0D0,     & !
     & 1.6967390245D0, -5.738343945585D-05,  3.2117D-23, 1338, 'P', & ! 2274
     &         41.2D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 5.7974851316D0, -5.737274249379D-05,  2.4842D-23, 1339, 'P', & ! 2275
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.4238768965D0, -5.732773420027D-05, -4.7515D-23, 1340, 'P', & ! 2276
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.5196670228D0, -5.724002881617D-05,  1.1441D-22, 1341, 'P', & ! 2277
     &          1.1D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.0362673815D0, -5.721753417942D-05,  7.6634D-23, 1342, 'P', & ! 2278
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.8360530473D0, -5.719503954268D-05,  3.8854D-23, 1343, 'P', & ! 2279
     &         -5.2D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.6536138473D0, -5.718434258061D-05,  3.1579D-23, 1344, 'P', & ! 2280
     &         -0.8D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2281,2290 ) &
     & /                             &
     & 4.4765418456D0, -5.704093194093D-05,  1.1388D-22, 1345, 'P', & ! 2281
     &         51.4D0,         0.4D0,        0.0D0,      0.0D0,     & !
     & 2.2941026456D0, -5.703023497887D-05,  1.0660D-22, 1346, 'P', & ! 2282
     &          9.8D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 4.4334166685D0, -5.684183506569D-05,  1.1334D-22, 1347, 'P', & ! 2283
     &         -1.0D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0831320573D0, -5.566043919399D-05, -7.7996D-23, 1348, 'P', & ! 2284
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.0400068801D0, -5.546134231875D-05, -7.8534D-23, 1349, 'P', & ! 2285
     &          6.4D0,         0.1D0,        0.0D0,      0.0D0,     & !
     & 2.8575676801D0, -5.545064535669D-05, -8.5810D-23, 1350, 'P', & ! 2286
     &          0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6804956785D0, -5.530723471700D-05, -3.5129D-24, 1351, 'P', & ! 2287
     &          4.7D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 3.4980564785D0, -5.529653775494D-05, -1.0788D-23, 1352, 'P', & ! 2288
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.6373705013D0, -5.510813784177D-05, -4.0515D-24, 1353, 'P', & ! 2289
     &         32.4D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 3.4549313013D0, -5.509744087970D-05, -1.1327D-23, 1354, 'P', & ! 2290
     &          6.2D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2291,2300 ) &
     & /                             &
     & 6.2778592996D0, -5.495403024002D-05,  7.0970D-23, 1355, 'P', & ! 2291
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 5.5942453241D0, -5.490904096653D-05, -4.5901D-24, 1356, 'P', & ! 2292
     &         -0.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.2347341225D0, -5.475493336478D-05,  7.0431D-23, 1357, 'P', & ! 2293
     &         26.4D0,         0.3D0,        0.0D0,      0.0D0,     & !
     & 4.0522949225D0, -5.474423640272D-05,  6.3156D-23, 1358, 'P', & ! 2294
     &          4.9D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 6.1916089453D0, -5.455583648954D-05,  6.9893D-23, 1359, 'P', & ! 2295
     &         -0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 0.5489124365D0, -5.440172888780D-05,  1.4491D-22, 1360, 'P', & ! 2296
     &          4.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 4.6496585436D0, -5.439103192573D-05,  1.3764D-22, 1361, 'P', & ! 2297
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.1123774709D0, -5.282213926562D-05, -4.7496D-23, 1362, 'P', & ! 2298
     &          2.4D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7528662693D0, -5.266803166387D-05,  2.7526D-23, 1363, 'P', & ! 2299
     &          0.5D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 1.7097410921D0, -5.246893478863D-05,  2.6987D-23, 1364, 'P', & ! 2300
     &          5.5D0,         0.1D0,        0.0D0,      0.0D0      & !
     & /
!
      DATA       ( PHAS_NUT(I_NUT), FREQ_NUT(I_NUT), ACCL_NUT(I_NUT),      &
     &             IND_NUT(I_NUT), TYP_NUT(I_NUT),                         &
     &             PMC_NUT(I_NUT), PMS_NUT(I_NUT),                         &
     &             PMC_RATE_NUT(I_NUT), PMS_RATE_NUT(I_NUT),               &
     &             I_NUT=2301,2302 ) &
     & /                             &
     & 5.8104871993D0, -5.245823782657D-05,  1.9712D-23, 1365, 'P', & ! 2301
     &          0.8D0,         0.0D0,        0.0D0,      0.0D0,     & !
     & 2.3071047133D0, -5.211573031165D-05,  1.0147D-22, 1366, 'P', & ! 2302
     &          3.1D0,         0.0D0,        0.0D0,      0.0D0      & !
     & /
!
! --- Contribution to E3 due to a secular part of the nutation-nutation
! --- cross terms (Taken from the full MHB2000 expansion)
!
      REAL*8      CROSS_NUT_RATE_E3
      DATA        CROSS_NUT_RATE_E3 / -5.9232757709D-18 / ! rad/s  or  -3.85559184 mas/Jul_cent
