      SUBROUTINE SPD_2D_ZPD_WRI ( SPD, OUT_PREF, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine SPD_2D_ZPD_WRI
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 24-SEP-2021  SPD_2D_ZPD_WRI  v1.1 (d) L. Petrov 11-FEB-2022 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'spd.i'
      INCLUDE   'heb.i'
      TYPE     ( SPD_3D__TYPE ) :: SPD
      TYPE     ( HEB__TYPE    ) :: HEB_ZPD
      CHARACTER  OUT_PREF*(*)
      INTEGER*4  IUER
      CHARACTER  USER_NAME*128, USER_REALNAME*128, USER_E_ADDRESS*128, STR*128
      CHARACTER  SYSNAME*128, NODENAME*128, HARDWARE*128, DATE_STR*32, FIL_ZPD_OUT*128
      INTEGER*4  IER
      REAL*4,    ALLOCATABLE :: DATA_ARR(:,:,:,:)
      CHARACTER, EXTERNAL :: MJDSEC_TO_DATE*30, GET_CDATE*19
      INTEGER*4, EXTERNAL :: I_LEN, ILEN
!
      CALL GETINFO_USER   ( USER_NAME, USER_REALNAME, USER_E_ADDRESS )
      CALL GETINFO_SYSTEM ( SYSNAME,   NODENAME,      HARDWARE       )
!
      HEB_ZPD%DIMS(1)   = SPD%NLON
      HEB_ZPD%DIMS(2)   = SPD%NLAT
      HEB_ZPD%DIMS(3)   = 3
      HEB_ZPD%DIMS(4)   = 1
      HEB_ZPD%TITLE     = '2D zenith path delay'
      HEB_ZPD%PROD_NAME = '2D zenith path delay derived from '//SPD%NWP_PROD_NAME
      HEB_ZPD%SDS_NAME  = '2D zenith path delay'
!
      STR = SPD_RESP_PROG__LABEL(10:15)
      CALL CHASHL ( STR )
      IF ( NODENAME == 'astrogeo'      .OR. &
     &     NODENAME == 'pethome'       .OR. &
     &     NODENAME == 'earthrotation'      ) THEN
           HEB_ZPD%INSTITUTION    = 'Astrogeo Center'
         ELSE IF ( INDEX ( NODENAME, 'gsfc.nasa.gov' ) > 0 ) THEN
           HEB_ZPD%INSTITUTION    = 'NASA GSFC Code 61A'
         ELSE
           HEB_ZPD%INSTITUTION    = 'Unknown'
      END IF
!
      HEB_ZPD%REFERENCES     = 'http://astrogeo.org/spd and '//SPD%NWP_REFERENCES
      HEB_ZPD%VERSION_ID     = '1'
      HEB_ZPD%UNITS          = 'm'
      HEB_ZPD%HISTORY        = 'Generated by '//SPD_3D_PROG__LABEL//' using '//TRIM(SPD%NWP_TITLE)// &
     &                         ' '//TRIM(SPD%NWP_PROD_NAME)
!
      HEB_ZPD%PROD_DATE_TIME = GET_CDATE()//'  '//HEB_ZPD%PROD_DATE_TIME
      HEB_ZPD%DATA_FORMAT    = HEB__R4
      HEB_ZPD%DATA_TRANSFORM = HEB__NONE
      HEB_ZPD%OFFSET         = 0.0
      HEB_ZPD%SCALE_FACTOR   = 1.0
      HEB_ZPD%FILL_VALUE     = 1.0E15
      HEB_ZPD%VALID_RANGE(1) = 0.0
      HEB_ZPD%VALID_RANGE(2) = 3.0
      WRITE ( UNIT=HEB_ZPD%COMMENT(1), FMT=210 ) SPD%NLON, 360.0/(SPD%NLON-2), &
     &                                           SPD%NLAT, 180.0/(SPD%NLAT-1)
 210  FORMAT ( '1st dimension lon: ', I4, ', step: ', F5.3, ' deg; '  &
     &         '2nd dimension lat: ', I4, ', step: ', F5.3, ' deg; ', &
     &         '3rd dimension cmp:      3' )
      WRITE ( UNIT=HEB_ZPD%COMMENT(2), FMT='(A)' ) '3rd dimension cmp '// &
     &                                             '1 -- total path delay, '// &
     &                                             '2 -- wet path delay, '// &
     &                                             '3 -- total refractivity'
      CALL CLRCH ( HEB_ZPD%COMMENT(3) ) 
      CALL CLRCH ( HEB_ZPD%COMMENT(4) ) 
!
      CALL HEB_MINMAX_R8_SECT ( HEB_ZPD, 1, SPD%NLON, 1, SPD%NLAT, 1, SPD%NTYP, 1, 1, &
     &                          SPD%REF_3D, DBLE(HEB_ZPD%VALID_RANGE(2)) )
!
      HEB_ZPD%MJD = SPD%MJD
      HEB_ZPD%TAI = SPD%UTC
      HEB_ZPD%UTC = SPD%UTC
!
      CALL ERR_PASS ( IUER, IER ) 
      DATE_STR = MJDSEC_TO_DATE ( HEB_ZPD%MJD, HEB_ZPD%UTC, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 5481, IUER, 'SPD_2D_ZPD_WRI', 'Wrong '// &
     &         'values of HEB_ZPD%MJD, HEB_ZPD%UTC' )
           RETURN 
      END IF
!
      FIL_ZPD_OUT = OUT_PREF(1:I_LEN(OUT_PREF))// &
     &              DATE_STR(1:4)// &
     &              DATE_STR(6:7)// &
     &              DATE_STR(9:10)//'_'// &
     &              DATE_STR(12:13)// &
     &              DATE_STR(15:16)// &
     &              '.heb'
!
      ALLOCATE ( DATA_ARR(HEB_ZPD%DIMS(1),HEB_ZPD%DIMS(2),HEB_ZPD%DIMS(3),HEB_ZPD%DIMS(4)), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL CLRCH  ( STR )
           CALL IINCH8 ( INT8(4)*HEB_ZPD%DIMS(1)*HEB_ZPD%DIMS(2)*HEB_ZPD%DIMS(3)*HEB_ZPD%DIMS(4), STR )
           CALL ERR_LOG ( 5482, IUER, 'SPD_2D_ZPD_WRI', 'Failure '// &
     &         'in an attempt to allocate '//TRIM(STR)//' bytes of '// &
     &         'dynamic memory' )
           RETURN 
      END IF
      DATA_ARR = 0.0
!
      CALL SPD_R8_TO_R4 ( HEB_ZPD%DIMS(1)*HEB_ZPD%DIMS(2)*HEB_ZPD%DIMS(3)*HEB_ZPD%DIMS(4), &
     &                    SPD%REF_3D, DATA_ARR )
!
      CALL ERR_PASS ( IUER, IER )
      CALL WRITE_HEB ( HEB_ZPD, DATA_ARR, FIL_ZPD_OUT, IER )
      IF ( IER .NE. 0 ) THEN
           CALL GERROR ( STR )
           CALL ERR_LOG ( 5483, IUER, 'SPD_2D_ZPD_WRI', 'Failure '// &
     &         'in an attempt to write into output file '// &
     &          FIL_ZPD_OUT )
           RETURN 
      END IF
      DEALLOCATE ( DATA_ARR )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  SPD_2D_ZPD_WRI   !#!  
