#include <mk5_preprocessor_directives.inc>
      SUBROUTINE INVS_14 ( A, EPS, IERR )
! ************************************************************************
! *                                                                      *
! *       Inverts square symmetric matrix in packed upper triangular     *
! *     storage format using Cholesky decomposition.                     *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.11.28  ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), S
      REAL*8     EPS
      INTEGER*4  IERR
!
      IF ( A ( 1 ) .LT. EPS ) THEN
           IERR = 1
           RETURN
      END IF
      A(1) = 1.0D0 / DSQRT ( A(1) )
      S = A(1)
      A( 2  ) = A( 2  ) * S
      A( 4  ) = A( 4  ) * S
      A( 7  ) = A( 7  ) * S
      A( 11  ) = A( 11  ) * S
      A( 16  ) = A( 16  ) * S
      A( 22  ) = A( 22  ) * S
      A( 29  ) = A( 29  ) * S
      A( 37  ) = A( 37  ) * S
      A( 46  ) = A( 46  ) * S
      A( 56  ) = A( 56  ) * S
      A( 67  ) = A( 67  ) * S
      A( 79  ) = A( 79  ) * S
      A( 92  ) = A( 92  ) * S
      S = 0.0D0
      S = S + A( 2  ) * A( 2  )
      A( 3  ) = ( A( 3  ) - S )
      IF ( A( 3  ) .LT. EPS ) THEN
           IERR = 2
           RETURN
      END IF
      A( 3  ) = 1.0D0 / DSQRT ( A( 3  ) )
      S = 0.0D0
      S = S + A( 2  ) * A( 4  )
      A( 5  ) = ( A( 5  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 7  )
      A( 8  ) = ( A( 8  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 11  )
      A( 12  ) = ( A( 12  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 16  )
      A( 17  ) = ( A( 17  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 22  )
      A( 23  ) = ( A( 23  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 29  )
      A( 30  ) = ( A( 30  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 37  )
      A( 38  ) = ( A( 38  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 46  )
      A( 47  ) = ( A( 47  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 56  )
      A( 57  ) = ( A( 57  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 67  )
      A( 68  ) = ( A( 68  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 79  )
      A( 80  ) = ( A( 80  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 2  ) * A( 92  )
      A( 93  ) = ( A( 93  ) - S ) * A( 3  )
      S = 0.0D0
      S = S + A( 4  ) * A( 4  )
      S = S + A( 5  ) * A( 5  )
      A( 6  ) = ( A( 6  ) - S )
      IF ( A( 6  ) .LT. EPS ) THEN
           IERR = 3
           RETURN
      END IF
      A( 6  ) = 1.0D0 / DSQRT ( A( 6  ) )
      S = 0.0D0
      S = S + A( 4  ) * A( 7  )
      S = S + A( 5  ) * A( 8  )
      A( 9  ) = ( A( 9  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 11  )
      S = S + A( 5  ) * A( 12  )
      A( 13  ) = ( A( 13  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 16  )
      S = S + A( 5  ) * A( 17  )
      A( 18  ) = ( A( 18  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 22  )
      S = S + A( 5  ) * A( 23  )
      A( 24  ) = ( A( 24  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 29  )
      S = S + A( 5  ) * A( 30  )
      A( 31  ) = ( A( 31  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 37  )
      S = S + A( 5  ) * A( 38  )
      A( 39  ) = ( A( 39  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 46  )
      S = S + A( 5  ) * A( 47  )
      A( 48  ) = ( A( 48  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 56  )
      S = S + A( 5  ) * A( 57  )
      A( 58  ) = ( A( 58  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 67  )
      S = S + A( 5  ) * A( 68  )
      A( 69  ) = ( A( 69  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 79  )
      S = S + A( 5  ) * A( 80  )
      A( 81  ) = ( A( 81  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 4  ) * A( 92  )
      S = S + A( 5  ) * A( 93  )
      A( 94  ) = ( A( 94  ) - S ) * A( 6  )
      S = 0.0D0
      S = S + A( 7  ) * A( 7  )
      S = S + A( 8  ) * A( 8  )
      S = S + A( 9  ) * A( 9  )
      A( 10  ) = ( A( 10  ) - S )
      IF ( A( 10  ) .LT. EPS ) THEN
           IERR = 4
           RETURN
      END IF
      A( 10  ) = 1.0D0 / DSQRT ( A( 10  ) )
      S = 0.0D0
      S = S + A( 7  ) * A( 11  )
      S = S + A( 8  ) * A( 12  )
      S = S + A( 9  ) * A( 13  )
      A( 14  ) = ( A( 14  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 16  )
      S = S + A( 8  ) * A( 17  )
      S = S + A( 9  ) * A( 18  )
      A( 19  ) = ( A( 19  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 22  )
      S = S + A( 8  ) * A( 23  )
      S = S + A( 9  ) * A( 24  )
      A( 25  ) = ( A( 25  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 29  )
      S = S + A( 8  ) * A( 30  )
      S = S + A( 9  ) * A( 31  )
      A( 32  ) = ( A( 32  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 37  )
      S = S + A( 8  ) * A( 38  )
      S = S + A( 9  ) * A( 39  )
      A( 40  ) = ( A( 40  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 46  )
      S = S + A( 8  ) * A( 47  )
      S = S + A( 9  ) * A( 48  )
      A( 49  ) = ( A( 49  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 56  )
      S = S + A( 8  ) * A( 57  )
      S = S + A( 9  ) * A( 58  )
      A( 59  ) = ( A( 59  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 67  )
      S = S + A( 8  ) * A( 68  )
      S = S + A( 9  ) * A( 69  )
      A( 70  ) = ( A( 70  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 79  )
      S = S + A( 8  ) * A( 80  )
      S = S + A( 9  ) * A( 81  )
      A( 82  ) = ( A( 82  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 7  ) * A( 92  )
      S = S + A( 8  ) * A( 93  )
      S = S + A( 9  ) * A( 94  )
      A( 95  ) = ( A( 95  ) - S ) * A( 10  )
      S = 0.0D0
      S = S + A( 11  ) * A( 11  )
      S = S + A( 12  ) * A( 12  )
      S = S + A( 13  ) * A( 13  )
      S = S + A( 14  ) * A( 14  )
      A( 15  ) = ( A( 15  ) - S )
      IF ( A( 15  ) .LT. EPS ) THEN
           IERR = 5
           RETURN
      END IF
      A( 15  ) = 1.0D0 / DSQRT ( A( 15  ) )
      S = 0.0D0
      S = S + A( 11  ) * A( 16  )
      S = S + A( 12  ) * A( 17  )
      S = S + A( 13  ) * A( 18  )
      S = S + A( 14  ) * A( 19  )
      A( 20  ) = ( A( 20  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 22  )
      S = S + A( 12  ) * A( 23  )
      S = S + A( 13  ) * A( 24  )
      S = S + A( 14  ) * A( 25  )
      A( 26  ) = ( A( 26  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 29  )
      S = S + A( 12  ) * A( 30  )
      S = S + A( 13  ) * A( 31  )
      S = S + A( 14  ) * A( 32  )
      A( 33  ) = ( A( 33  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 37  )
      S = S + A( 12  ) * A( 38  )
      S = S + A( 13  ) * A( 39  )
      S = S + A( 14  ) * A( 40  )
      A( 41  ) = ( A( 41  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 46  )
      S = S + A( 12  ) * A( 47  )
      S = S + A( 13  ) * A( 48  )
      S = S + A( 14  ) * A( 49  )
      A( 50  ) = ( A( 50  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 56  )
      S = S + A( 12  ) * A( 57  )
      S = S + A( 13  ) * A( 58  )
      S = S + A( 14  ) * A( 59  )
      A( 60  ) = ( A( 60  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 67  )
      S = S + A( 12  ) * A( 68  )
      S = S + A( 13  ) * A( 69  )
      S = S + A( 14  ) * A( 70  )
      A( 71  ) = ( A( 71  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 79  )
      S = S + A( 12  ) * A( 80  )
      S = S + A( 13  ) * A( 81  )
      S = S + A( 14  ) * A( 82  )
      A( 83  ) = ( A( 83  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 11  ) * A( 92  )
      S = S + A( 12  ) * A( 93  )
      S = S + A( 13  ) * A( 94  )
      S = S + A( 14  ) * A( 95  )
      A( 96  ) = ( A( 96  ) - S ) * A( 15  )
      S = 0.0D0
      S = S + A( 16  ) * A( 16  )
      S = S + A( 17  ) * A( 17  )
      S = S + A( 18  ) * A( 18  )
      S = S + A( 19  ) * A( 19  )
      S = S + A( 20  ) * A( 20  )
      A( 21  ) = ( A( 21  ) - S )
      IF ( A( 21  ) .LT. EPS ) THEN
           IERR = 6
           RETURN
      END IF
      A( 21  ) = 1.0D0 / DSQRT ( A( 21  ) )
      S = 0.0D0
      S = S + A( 16  ) * A( 22  )
      S = S + A( 17  ) * A( 23  )
      S = S + A( 18  ) * A( 24  )
      S = S + A( 19  ) * A( 25  )
      S = S + A( 20  ) * A( 26  )
      A( 27  ) = ( A( 27  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 29  )
      S = S + A( 17  ) * A( 30  )
      S = S + A( 18  ) * A( 31  )
      S = S + A( 19  ) * A( 32  )
      S = S + A( 20  ) * A( 33  )
      A( 34  ) = ( A( 34  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 37  )
      S = S + A( 17  ) * A( 38  )
      S = S + A( 18  ) * A( 39  )
      S = S + A( 19  ) * A( 40  )
      S = S + A( 20  ) * A( 41  )
      A( 42  ) = ( A( 42  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 46  )
      S = S + A( 17  ) * A( 47  )
      S = S + A( 18  ) * A( 48  )
      S = S + A( 19  ) * A( 49  )
      S = S + A( 20  ) * A( 50  )
      A( 51  ) = ( A( 51  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 56  )
      S = S + A( 17  ) * A( 57  )
      S = S + A( 18  ) * A( 58  )
      S = S + A( 19  ) * A( 59  )
      S = S + A( 20  ) * A( 60  )
      A( 61  ) = ( A( 61  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 67  )
      S = S + A( 17  ) * A( 68  )
      S = S + A( 18  ) * A( 69  )
      S = S + A( 19  ) * A( 70  )
      S = S + A( 20  ) * A( 71  )
      A( 72  ) = ( A( 72  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 79  )
      S = S + A( 17  ) * A( 80  )
      S = S + A( 18  ) * A( 81  )
      S = S + A( 19  ) * A( 82  )
      S = S + A( 20  ) * A( 83  )
      A( 84  ) = ( A( 84  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 16  ) * A( 92  )
      S = S + A( 17  ) * A( 93  )
      S = S + A( 18  ) * A( 94  )
      S = S + A( 19  ) * A( 95  )
      S = S + A( 20  ) * A( 96  )
      A( 97  ) = ( A( 97  ) - S ) * A( 21  )
      S = 0.0D0
      S = S + A( 22  ) * A( 22  )
      S = S + A( 23  ) * A( 23  )
      S = S + A( 24  ) * A( 24  )
      S = S + A( 25  ) * A( 25  )
      S = S + A( 26  ) * A( 26  )
      S = S + A( 27  ) * A( 27  )
      A( 28  ) = ( A( 28  ) - S )
      IF ( A( 28  ) .LT. EPS ) THEN
           IERR = 7
           RETURN
      END IF
      A( 28  ) = 1.0D0 / DSQRT ( A( 28  ) )
      S = 0.0D0
      S = S + A( 22  ) * A( 29  )
      S = S + A( 23  ) * A( 30  )
      S = S + A( 24  ) * A( 31  )
      S = S + A( 25  ) * A( 32  )
      S = S + A( 26  ) * A( 33  )
      S = S + A( 27  ) * A( 34  )
      A( 35  ) = ( A( 35  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 37  )
      S = S + A( 23  ) * A( 38  )
      S = S + A( 24  ) * A( 39  )
      S = S + A( 25  ) * A( 40  )
      S = S + A( 26  ) * A( 41  )
      S = S + A( 27  ) * A( 42  )
      A( 43  ) = ( A( 43  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 46  )
      S = S + A( 23  ) * A( 47  )
      S = S + A( 24  ) * A( 48  )
      S = S + A( 25  ) * A( 49  )
      S = S + A( 26  ) * A( 50  )
      S = S + A( 27  ) * A( 51  )
      A( 52  ) = ( A( 52  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 56  )
      S = S + A( 23  ) * A( 57  )
      S = S + A( 24  ) * A( 58  )
      S = S + A( 25  ) * A( 59  )
      S = S + A( 26  ) * A( 60  )
      S = S + A( 27  ) * A( 61  )
      A( 62  ) = ( A( 62  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 67  )
      S = S + A( 23  ) * A( 68  )
      S = S + A( 24  ) * A( 69  )
      S = S + A( 25  ) * A( 70  )
      S = S + A( 26  ) * A( 71  )
      S = S + A( 27  ) * A( 72  )
      A( 73  ) = ( A( 73  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 79  )
      S = S + A( 23  ) * A( 80  )
      S = S + A( 24  ) * A( 81  )
      S = S + A( 25  ) * A( 82  )
      S = S + A( 26  ) * A( 83  )
      S = S + A( 27  ) * A( 84  )
      A( 85  ) = ( A( 85  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 22  ) * A( 92  )
      S = S + A( 23  ) * A( 93  )
      S = S + A( 24  ) * A( 94  )
      S = S + A( 25  ) * A( 95  )
      S = S + A( 26  ) * A( 96  )
      S = S + A( 27  ) * A( 97  )
      A( 98  ) = ( A( 98  ) - S ) * A( 28  )
      S = 0.0D0
      S = S + A( 29  ) * A( 29  )
      S = S + A( 30  ) * A( 30  )
      S = S + A( 31  ) * A( 31  )
      S = S + A( 32  ) * A( 32  )
      S = S + A( 33  ) * A( 33  )
      S = S + A( 34  ) * A( 34  )
      S = S + A( 35  ) * A( 35  )
      A( 36  ) = ( A( 36  ) - S )
      IF ( A( 36  ) .LT. EPS ) THEN
           IERR = 8
           RETURN
      END IF
      A( 36  ) = 1.0D0 / DSQRT ( A( 36  ) )
      S = 0.0D0
      S = S + A( 29  ) * A( 37  )
      S = S + A( 30  ) * A( 38  )
      S = S + A( 31  ) * A( 39  )
      S = S + A( 32  ) * A( 40  )
      S = S + A( 33  ) * A( 41  )
      S = S + A( 34  ) * A( 42  )
      S = S + A( 35  ) * A( 43  )
      A( 44  ) = ( A( 44  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 29  ) * A( 46  )
      S = S + A( 30  ) * A( 47  )
      S = S + A( 31  ) * A( 48  )
      S = S + A( 32  ) * A( 49  )
      S = S + A( 33  ) * A( 50  )
      S = S + A( 34  ) * A( 51  )
      S = S + A( 35  ) * A( 52  )
      A( 53  ) = ( A( 53  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 29  ) * A( 56  )
      S = S + A( 30  ) * A( 57  )
      S = S + A( 31  ) * A( 58  )
      S = S + A( 32  ) * A( 59  )
      S = S + A( 33  ) * A( 60  )
      S = S + A( 34  ) * A( 61  )
      S = S + A( 35  ) * A( 62  )
      A( 63  ) = ( A( 63  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 29  ) * A( 67  )
      S = S + A( 30  ) * A( 68  )
      S = S + A( 31  ) * A( 69  )
      S = S + A( 32  ) * A( 70  )
      S = S + A( 33  ) * A( 71  )
      S = S + A( 34  ) * A( 72  )
      S = S + A( 35  ) * A( 73  )
      A( 74  ) = ( A( 74  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 29  ) * A( 79  )
      S = S + A( 30  ) * A( 80  )
      S = S + A( 31  ) * A( 81  )
      S = S + A( 32  ) * A( 82  )
      S = S + A( 33  ) * A( 83  )
      S = S + A( 34  ) * A( 84  )
      S = S + A( 35  ) * A( 85  )
      A( 86  ) = ( A( 86  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 29  ) * A( 92  )
      S = S + A( 30  ) * A( 93  )
      S = S + A( 31  ) * A( 94  )
      S = S + A( 32  ) * A( 95  )
      S = S + A( 33  ) * A( 96  )
      S = S + A( 34  ) * A( 97  )
      S = S + A( 35  ) * A( 98  )
      A( 99  ) = ( A( 99  ) - S ) * A( 36  )
      S = 0.0D0
      S = S + A( 37  ) * A( 37  )
      S = S + A( 38  ) * A( 38  )
      S = S + A( 39  ) * A( 39  )
      S = S + A( 40  ) * A( 40  )
      S = S + A( 41  ) * A( 41  )
      S = S + A( 42  ) * A( 42  )
      S = S + A( 43  ) * A( 43  )
      S = S + A( 44  ) * A( 44  )
      A( 45  ) = ( A( 45  ) - S )
      IF ( A( 45  ) .LT. EPS ) THEN
           IERR = 9
           RETURN
      END IF
      A( 45  ) = 1.0D0 / DSQRT ( A( 45  ) )
      S = 0.0D0
      S = S + A( 37  ) * A( 46  )
      S = S + A( 38  ) * A( 47  )
      S = S + A( 39  ) * A( 48  )
      S = S + A( 40  ) * A( 49  )
      S = S + A( 41  ) * A( 50  )
      S = S + A( 42  ) * A( 51  )
      S = S + A( 43  ) * A( 52  )
      S = S + A( 44  ) * A( 53  )
      A( 54  ) = ( A( 54  ) - S ) * A( 45  )
      S = 0.0D0
      S = S + A( 37  ) * A( 56  )
      S = S + A( 38  ) * A( 57  )
      S = S + A( 39  ) * A( 58  )
      S = S + A( 40  ) * A( 59  )
      S = S + A( 41  ) * A( 60  )
      S = S + A( 42  ) * A( 61  )
      S = S + A( 43  ) * A( 62  )
      S = S + A( 44  ) * A( 63  )
      A( 64  ) = ( A( 64  ) - S ) * A( 45  )
      S = 0.0D0
      S = S + A( 37  ) * A( 67  )
      S = S + A( 38  ) * A( 68  )
      S = S + A( 39  ) * A( 69  )
      S = S + A( 40  ) * A( 70  )
      S = S + A( 41  ) * A( 71  )
      S = S + A( 42  ) * A( 72  )
      S = S + A( 43  ) * A( 73  )
      S = S + A( 44  ) * A( 74  )
      A( 75  ) = ( A( 75  ) - S ) * A( 45  )
      S = 0.0D0
      S = S + A( 37  ) * A( 79  )
      S = S + A( 38  ) * A( 80  )
      S = S + A( 39  ) * A( 81  )
      S = S + A( 40  ) * A( 82  )
      S = S + A( 41  ) * A( 83  )
      S = S + A( 42  ) * A( 84  )
      S = S + A( 43  ) * A( 85  )
      S = S + A( 44  ) * A( 86  )
      A( 87  ) = ( A( 87  ) - S ) * A( 45  )
      S = 0.0D0
      S = S + A( 37  ) * A( 92  )
      S = S + A( 38  ) * A( 93  )
      S = S + A( 39  ) * A( 94  )
      S = S + A( 40  ) * A( 95  )
      S = S + A( 41  ) * A( 96  )
      S = S + A( 42  ) * A( 97  )
      S = S + A( 43  ) * A( 98  )
      S = S + A( 44  ) * A( 99  )
      A( 100  ) = ( A( 100  ) - S ) * A( 45  )
      S = 0.0D0
      S = S + A( 46  ) * A( 46  )
      S = S + A( 47  ) * A( 47  )
      S = S + A( 48  ) * A( 48  )
      S = S + A( 49  ) * A( 49  )
      S = S + A( 50  ) * A( 50  )
      S = S + A( 51  ) * A( 51  )
      S = S + A( 52  ) * A( 52  )
      S = S + A( 53  ) * A( 53  )
      S = S + A( 54  ) * A( 54  )
      A( 55  ) = ( A( 55  ) - S )
      IF ( A( 55  ) .LT. EPS ) THEN
           IERR = 10
           RETURN
      END IF
      A( 55  ) = 1.0D0 / DSQRT ( A( 55  ) )
      S = 0.0D0
      S = S + A( 46  ) * A( 56  )
      S = S + A( 47  ) * A( 57  )
      S = S + A( 48  ) * A( 58  )
      S = S + A( 49  ) * A( 59  )
      S = S + A( 50  ) * A( 60  )
      S = S + A( 51  ) * A( 61  )
      S = S + A( 52  ) * A( 62  )
      S = S + A( 53  ) * A( 63  )
      S = S + A( 54  ) * A( 64  )
      A( 65  ) = ( A( 65  ) - S ) * A( 55  )
      S = 0.0D0
      S = S + A( 46  ) * A( 67  )
      S = S + A( 47  ) * A( 68  )
      S = S + A( 48  ) * A( 69  )
      S = S + A( 49  ) * A( 70  )
      S = S + A( 50  ) * A( 71  )
      S = S + A( 51  ) * A( 72  )
      S = S + A( 52  ) * A( 73  )
      S = S + A( 53  ) * A( 74  )
      S = S + A( 54  ) * A( 75  )
      A( 76  ) = ( A( 76  ) - S ) * A( 55  )
      S = 0.0D0
      S = S + A( 46  ) * A( 79  )
      S = S + A( 47  ) * A( 80  )
      S = S + A( 48  ) * A( 81  )
      S = S + A( 49  ) * A( 82  )
      S = S + A( 50  ) * A( 83  )
      S = S + A( 51  ) * A( 84  )
      S = S + A( 52  ) * A( 85  )
      S = S + A( 53  ) * A( 86  )
      S = S + A( 54  ) * A( 87  )
      A( 88  ) = ( A( 88  ) - S ) * A( 55  )
      S = 0.0D0
      S = S + A( 46  ) * A( 92  )
      S = S + A( 47  ) * A( 93  )
      S = S + A( 48  ) * A( 94  )
      S = S + A( 49  ) * A( 95  )
      S = S + A( 50  ) * A( 96  )
      S = S + A( 51  ) * A( 97  )
      S = S + A( 52  ) * A( 98  )
      S = S + A( 53  ) * A( 99  )
      S = S + A( 54  ) * A( 100  )
      A( 101  ) = ( A( 101  ) - S ) * A( 55  )
      S = 0.0D0
      S = S + A( 56  ) * A( 56  )
      S = S + A( 57  ) * A( 57  )
      S = S + A( 58  ) * A( 58  )
      S = S + A( 59  ) * A( 59  )
      S = S + A( 60  ) * A( 60  )
      S = S + A( 61  ) * A( 61  )
      S = S + A( 62  ) * A( 62  )
      S = S + A( 63  ) * A( 63  )
      S = S + A( 64  ) * A( 64  )
      S = S + A( 65  ) * A( 65  )
      A( 66  ) = ( A( 66  ) - S )
      IF ( A( 66  ) .LT. EPS ) THEN
           IERR = 11
           RETURN
      END IF
      A( 66  ) = 1.0D0 / DSQRT ( A( 66  ) )
      S = 0.0D0
      S = S + A( 56  ) * A( 67  )
      S = S + A( 57  ) * A( 68  )
      S = S + A( 58  ) * A( 69  )
      S = S + A( 59  ) * A( 70  )
      S = S + A( 60  ) * A( 71  )
      S = S + A( 61  ) * A( 72  )
      S = S + A( 62  ) * A( 73  )
      S = S + A( 63  ) * A( 74  )
      S = S + A( 64  ) * A( 75  )
      S = S + A( 65  ) * A( 76  )
      A( 77  ) = ( A( 77  ) - S ) * A( 66  )
      S = 0.0D0
      S = S + A( 56  ) * A( 79  )
      S = S + A( 57  ) * A( 80  )
      S = S + A( 58  ) * A( 81  )
      S = S + A( 59  ) * A( 82  )
      S = S + A( 60  ) * A( 83  )
      S = S + A( 61  ) * A( 84  )
      S = S + A( 62  ) * A( 85  )
      S = S + A( 63  ) * A( 86  )
      S = S + A( 64  ) * A( 87  )
      S = S + A( 65  ) * A( 88  )
      A( 89  ) = ( A( 89  ) - S ) * A( 66  )
      S = 0.0D0
      S = S + A( 56  ) * A( 92  )
      S = S + A( 57  ) * A( 93  )
      S = S + A( 58  ) * A( 94  )
      S = S + A( 59  ) * A( 95  )
      S = S + A( 60  ) * A( 96  )
      S = S + A( 61  ) * A( 97  )
      S = S + A( 62  ) * A( 98  )
      S = S + A( 63  ) * A( 99  )
      S = S + A( 64  ) * A( 100  )
      S = S + A( 65  ) * A( 101  )
      A( 102  ) = ( A( 102  ) - S ) * A( 66  )
      S = 0.0D0
      S = S + A( 67  ) * A( 67  )
      S = S + A( 68  ) * A( 68  )
      S = S + A( 69  ) * A( 69  )
      S = S + A( 70  ) * A( 70  )
      S = S + A( 71  ) * A( 71  )
      S = S + A( 72  ) * A( 72  )
      S = S + A( 73  ) * A( 73  )
      S = S + A( 74  ) * A( 74  )
      S = S + A( 75  ) * A( 75  )
      S = S + A( 76  ) * A( 76  )
      S = S + A( 77  ) * A( 77  )
      A( 78  ) = ( A( 78  ) - S )
      IF ( A( 78  ) .LT. EPS ) THEN
           IERR = 12
           RETURN
      END IF
      A( 78  ) = 1.0D0 / DSQRT ( A( 78  ) )
      S = 0.0D0
      S = S + A( 67  ) * A( 79  )
      S = S + A( 68  ) * A( 80  )
      S = S + A( 69  ) * A( 81  )
      S = S + A( 70  ) * A( 82  )
      S = S + A( 71  ) * A( 83  )
      S = S + A( 72  ) * A( 84  )
      S = S + A( 73  ) * A( 85  )
      S = S + A( 74  ) * A( 86  )
      S = S + A( 75  ) * A( 87  )
      S = S + A( 76  ) * A( 88  )
      S = S + A( 77  ) * A( 89  )
      A( 90  ) = ( A( 90  ) - S ) * A( 78  )
      S = 0.0D0
      S = S + A( 67  ) * A( 92  )
      S = S + A( 68  ) * A( 93  )
      S = S + A( 69  ) * A( 94  )
      S = S + A( 70  ) * A( 95  )
      S = S + A( 71  ) * A( 96  )
      S = S + A( 72  ) * A( 97  )
      S = S + A( 73  ) * A( 98  )
      S = S + A( 74  ) * A( 99  )
      S = S + A( 75  ) * A( 100  )
      S = S + A( 76  ) * A( 101  )
      S = S + A( 77  ) * A( 102  )
      A( 103  ) = ( A( 103  ) - S ) * A( 78  )
      S = 0.0D0
      S = S + A( 79  ) * A( 79  )
      S = S + A( 80  ) * A( 80  )
      S = S + A( 81  ) * A( 81  )
      S = S + A( 82  ) * A( 82  )
      S = S + A( 83  ) * A( 83  )
      S = S + A( 84  ) * A( 84  )
      S = S + A( 85  ) * A( 85  )
      S = S + A( 86  ) * A( 86  )
      S = S + A( 87  ) * A( 87  )
      S = S + A( 88  ) * A( 88  )
      S = S + A( 89  ) * A( 89  )
      S = S + A( 90  ) * A( 90  )
      A( 91  ) = ( A( 91  ) - S )
      IF ( A( 91  ) .LT. EPS ) THEN
           IERR = 13
           RETURN
      END IF
      A( 91  ) = 1.0D0 / DSQRT ( A( 91  ) )
      S = 0.0D0
      S = S + A( 79  ) * A( 92  )
      S = S + A( 80  ) * A( 93  )
      S = S + A( 81  ) * A( 94  )
      S = S + A( 82  ) * A( 95  )
      S = S + A( 83  ) * A( 96  )
      S = S + A( 84  ) * A( 97  )
      S = S + A( 85  ) * A( 98  )
      S = S + A( 86  ) * A( 99  )
      S = S + A( 87  ) * A( 100  )
      S = S + A( 88  ) * A( 101  )
      S = S + A( 89  ) * A( 102  )
      S = S + A( 90  ) * A( 103  )
      A( 104  ) = ( A( 104  ) - S ) * A( 91  )
      S = 0.0D0
      S = S + A( 92  ) * A( 92  )
      S = S + A( 93  ) * A( 93  )
      S = S + A( 94  ) * A( 94  )
      S = S + A( 95  ) * A( 95  )
      S = S + A( 96  ) * A( 96  )
      S = S + A( 97  ) * A( 97  )
      S = S + A( 98  ) * A( 98  )
      S = S + A( 99  ) * A( 99  )
      S = S + A( 100  ) * A( 100  )
      S = S + A( 101  ) * A( 101  )
      S = S + A( 102  ) * A( 102  )
      S = S + A( 103  ) * A( 103  )
      S = S + A( 104  ) * A( 104  )
      A( 105  ) = ( A( 105  ) - S )
      IF ( A( 105  ) .LT. EPS ) THEN
           IERR = 14
           RETURN
      END IF
      A( 105  ) = 1.0D0 / DSQRT ( A( 105  ) )
      S = 0.0D0
      S = S - A( 1  ) * A( 2  )
      A( 2 ) = S * A( 3  )
      S = 0.0D0
      S = S - A( 1  ) * A( 4  )
      S = S - A( 2  ) * A( 5  )
      A( 4 ) = S * A( 6  )
      S = 0.0D0
      S = S - A( 1  ) * A( 7  )
      S = S - A( 2  ) * A( 8  )
      S = S - A( 4  ) * A( 9  )
      A( 7 ) = S * A( 10  )
      S = 0.0D0
      S = S - A( 1  ) * A( 11  )
      S = S - A( 2  ) * A( 12  )
      S = S - A( 4  ) * A( 13  )
      S = S - A( 7  ) * A( 14  )
      A( 11 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 1  ) * A( 16  )
      S = S - A( 2  ) * A( 17  )
      S = S - A( 4  ) * A( 18  )
      S = S - A( 7  ) * A( 19  )
      S = S - A( 11  ) * A( 20  )
      A( 16 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 1  ) * A( 22  )
      S = S - A( 2  ) * A( 23  )
      S = S - A( 4  ) * A( 24  )
      S = S - A( 7  ) * A( 25  )
      S = S - A( 11  ) * A( 26  )
      S = S - A( 16  ) * A( 27  )
      A( 22 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 1  ) * A( 29  )
      S = S - A( 2  ) * A( 30  )
      S = S - A( 4  ) * A( 31  )
      S = S - A( 7  ) * A( 32  )
      S = S - A( 11  ) * A( 33  )
      S = S - A( 16  ) * A( 34  )
      S = S - A( 22  ) * A( 35  )
      A( 29 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 1  ) * A( 37  )
      S = S - A( 2  ) * A( 38  )
      S = S - A( 4  ) * A( 39  )
      S = S - A( 7  ) * A( 40  )
      S = S - A( 11  ) * A( 41  )
      S = S - A( 16  ) * A( 42  )
      S = S - A( 22  ) * A( 43  )
      S = S - A( 29  ) * A( 44  )
      A( 37 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 1  ) * A( 46  )
      S = S - A( 2  ) * A( 47  )
      S = S - A( 4  ) * A( 48  )
      S = S - A( 7  ) * A( 49  )
      S = S - A( 11  ) * A( 50  )
      S = S - A( 16  ) * A( 51  )
      S = S - A( 22  ) * A( 52  )
      S = S - A( 29  ) * A( 53  )
      S = S - A( 37  ) * A( 54  )
      A( 46 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 1  ) * A( 56  )
      S = S - A( 2  ) * A( 57  )
      S = S - A( 4  ) * A( 58  )
      S = S - A( 7  ) * A( 59  )
      S = S - A( 11  ) * A( 60  )
      S = S - A( 16  ) * A( 61  )
      S = S - A( 22  ) * A( 62  )
      S = S - A( 29  ) * A( 63  )
      S = S - A( 37  ) * A( 64  )
      S = S - A( 46  ) * A( 65  )
      A( 56 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 1  ) * A( 67  )
      S = S - A( 2  ) * A( 68  )
      S = S - A( 4  ) * A( 69  )
      S = S - A( 7  ) * A( 70  )
      S = S - A( 11  ) * A( 71  )
      S = S - A( 16  ) * A( 72  )
      S = S - A( 22  ) * A( 73  )
      S = S - A( 29  ) * A( 74  )
      S = S - A( 37  ) * A( 75  )
      S = S - A( 46  ) * A( 76  )
      S = S - A( 56  ) * A( 77  )
      A( 67 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 1  ) * A( 79  )
      S = S - A( 2  ) * A( 80  )
      S = S - A( 4  ) * A( 81  )
      S = S - A( 7  ) * A( 82  )
      S = S - A( 11  ) * A( 83  )
      S = S - A( 16  ) * A( 84  )
      S = S - A( 22  ) * A( 85  )
      S = S - A( 29  ) * A( 86  )
      S = S - A( 37  ) * A( 87  )
      S = S - A( 46  ) * A( 88  )
      S = S - A( 56  ) * A( 89  )
      S = S - A( 67  ) * A( 90  )
      A( 79 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 1  ) * A( 92  )
      S = S - A( 2  ) * A( 93  )
      S = S - A( 4  ) * A( 94  )
      S = S - A( 7  ) * A( 95  )
      S = S - A( 11  ) * A( 96  )
      S = S - A( 16  ) * A( 97  )
      S = S - A( 22  ) * A( 98  )
      S = S - A( 29  ) * A( 99  )
      S = S - A( 37  ) * A( 100  )
      S = S - A( 46  ) * A( 101  )
      S = S - A( 56  ) * A( 102  )
      S = S - A( 67  ) * A( 103  )
      S = S - A( 79  ) * A( 104  )
      A( 92 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 3  ) * A( 5  )
      A( 5 ) = S * A( 6  )
      S = 0.0D0
      S = S - A( 3  ) * A( 8  )
      S = S - A( 5  ) * A( 9  )
      A( 8 ) = S * A( 10  )
      S = 0.0D0
      S = S - A( 3  ) * A( 12  )
      S = S - A( 5  ) * A( 13  )
      S = S - A( 8  ) * A( 14  )
      A( 12 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 3  ) * A( 17  )
      S = S - A( 5  ) * A( 18  )
      S = S - A( 8  ) * A( 19  )
      S = S - A( 12  ) * A( 20  )
      A( 17 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 3  ) * A( 23  )
      S = S - A( 5  ) * A( 24  )
      S = S - A( 8  ) * A( 25  )
      S = S - A( 12  ) * A( 26  )
      S = S - A( 17  ) * A( 27  )
      A( 23 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 3  ) * A( 30  )
      S = S - A( 5  ) * A( 31  )
      S = S - A( 8  ) * A( 32  )
      S = S - A( 12  ) * A( 33  )
      S = S - A( 17  ) * A( 34  )
      S = S - A( 23  ) * A( 35  )
      A( 30 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 3  ) * A( 38  )
      S = S - A( 5  ) * A( 39  )
      S = S - A( 8  ) * A( 40  )
      S = S - A( 12  ) * A( 41  )
      S = S - A( 17  ) * A( 42  )
      S = S - A( 23  ) * A( 43  )
      S = S - A( 30  ) * A( 44  )
      A( 38 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 3  ) * A( 47  )
      S = S - A( 5  ) * A( 48  )
      S = S - A( 8  ) * A( 49  )
      S = S - A( 12  ) * A( 50  )
      S = S - A( 17  ) * A( 51  )
      S = S - A( 23  ) * A( 52  )
      S = S - A( 30  ) * A( 53  )
      S = S - A( 38  ) * A( 54  )
      A( 47 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 3  ) * A( 57  )
      S = S - A( 5  ) * A( 58  )
      S = S - A( 8  ) * A( 59  )
      S = S - A( 12  ) * A( 60  )
      S = S - A( 17  ) * A( 61  )
      S = S - A( 23  ) * A( 62  )
      S = S - A( 30  ) * A( 63  )
      S = S - A( 38  ) * A( 64  )
      S = S - A( 47  ) * A( 65  )
      A( 57 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 3  ) * A( 68  )
      S = S - A( 5  ) * A( 69  )
      S = S - A( 8  ) * A( 70  )
      S = S - A( 12  ) * A( 71  )
      S = S - A( 17  ) * A( 72  )
      S = S - A( 23  ) * A( 73  )
      S = S - A( 30  ) * A( 74  )
      S = S - A( 38  ) * A( 75  )
      S = S - A( 47  ) * A( 76  )
      S = S - A( 57  ) * A( 77  )
      A( 68 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 3  ) * A( 80  )
      S = S - A( 5  ) * A( 81  )
      S = S - A( 8  ) * A( 82  )
      S = S - A( 12  ) * A( 83  )
      S = S - A( 17  ) * A( 84  )
      S = S - A( 23  ) * A( 85  )
      S = S - A( 30  ) * A( 86  )
      S = S - A( 38  ) * A( 87  )
      S = S - A( 47  ) * A( 88  )
      S = S - A( 57  ) * A( 89  )
      S = S - A( 68  ) * A( 90  )
      A( 80 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 3  ) * A( 93  )
      S = S - A( 5  ) * A( 94  )
      S = S - A( 8  ) * A( 95  )
      S = S - A( 12  ) * A( 96  )
      S = S - A( 17  ) * A( 97  )
      S = S - A( 23  ) * A( 98  )
      S = S - A( 30  ) * A( 99  )
      S = S - A( 38  ) * A( 100  )
      S = S - A( 47  ) * A( 101  )
      S = S - A( 57  ) * A( 102  )
      S = S - A( 68  ) * A( 103  )
      S = S - A( 80  ) * A( 104  )
      A( 93 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 6  ) * A( 9  )
      A( 9 ) = S * A( 10  )
      S = 0.0D0
      S = S - A( 6  ) * A( 13  )
      S = S - A( 9  ) * A( 14  )
      A( 13 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 6  ) * A( 18  )
      S = S - A( 9  ) * A( 19  )
      S = S - A( 13  ) * A( 20  )
      A( 18 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 6  ) * A( 24  )
      S = S - A( 9  ) * A( 25  )
      S = S - A( 13  ) * A( 26  )
      S = S - A( 18  ) * A( 27  )
      A( 24 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 6  ) * A( 31  )
      S = S - A( 9  ) * A( 32  )
      S = S - A( 13  ) * A( 33  )
      S = S - A( 18  ) * A( 34  )
      S = S - A( 24  ) * A( 35  )
      A( 31 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 6  ) * A( 39  )
      S = S - A( 9  ) * A( 40  )
      S = S - A( 13  ) * A( 41  )
      S = S - A( 18  ) * A( 42  )
      S = S - A( 24  ) * A( 43  )
      S = S - A( 31  ) * A( 44  )
      A( 39 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 6  ) * A( 48  )
      S = S - A( 9  ) * A( 49  )
      S = S - A( 13  ) * A( 50  )
      S = S - A( 18  ) * A( 51  )
      S = S - A( 24  ) * A( 52  )
      S = S - A( 31  ) * A( 53  )
      S = S - A( 39  ) * A( 54  )
      A( 48 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 6  ) * A( 58  )
      S = S - A( 9  ) * A( 59  )
      S = S - A( 13  ) * A( 60  )
      S = S - A( 18  ) * A( 61  )
      S = S - A( 24  ) * A( 62  )
      S = S - A( 31  ) * A( 63  )
      S = S - A( 39  ) * A( 64  )
      S = S - A( 48  ) * A( 65  )
      A( 58 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 6  ) * A( 69  )
      S = S - A( 9  ) * A( 70  )
      S = S - A( 13  ) * A( 71  )
      S = S - A( 18  ) * A( 72  )
      S = S - A( 24  ) * A( 73  )
      S = S - A( 31  ) * A( 74  )
      S = S - A( 39  ) * A( 75  )
      S = S - A( 48  ) * A( 76  )
      S = S - A( 58  ) * A( 77  )
      A( 69 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 6  ) * A( 81  )
      S = S - A( 9  ) * A( 82  )
      S = S - A( 13  ) * A( 83  )
      S = S - A( 18  ) * A( 84  )
      S = S - A( 24  ) * A( 85  )
      S = S - A( 31  ) * A( 86  )
      S = S - A( 39  ) * A( 87  )
      S = S - A( 48  ) * A( 88  )
      S = S - A( 58  ) * A( 89  )
      S = S - A( 69  ) * A( 90  )
      A( 81 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 6  ) * A( 94  )
      S = S - A( 9  ) * A( 95  )
      S = S - A( 13  ) * A( 96  )
      S = S - A( 18  ) * A( 97  )
      S = S - A( 24  ) * A( 98  )
      S = S - A( 31  ) * A( 99  )
      S = S - A( 39  ) * A( 100  )
      S = S - A( 48  ) * A( 101  )
      S = S - A( 58  ) * A( 102  )
      S = S - A( 69  ) * A( 103  )
      S = S - A( 81  ) * A( 104  )
      A( 94 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 10  ) * A( 14  )
      A( 14 ) = S * A( 15  )
      S = 0.0D0
      S = S - A( 10  ) * A( 19  )
      S = S - A( 14  ) * A( 20  )
      A( 19 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 10  ) * A( 25  )
      S = S - A( 14  ) * A( 26  )
      S = S - A( 19  ) * A( 27  )
      A( 25 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 10  ) * A( 32  )
      S = S - A( 14  ) * A( 33  )
      S = S - A( 19  ) * A( 34  )
      S = S - A( 25  ) * A( 35  )
      A( 32 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 10  ) * A( 40  )
      S = S - A( 14  ) * A( 41  )
      S = S - A( 19  ) * A( 42  )
      S = S - A( 25  ) * A( 43  )
      S = S - A( 32  ) * A( 44  )
      A( 40 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 10  ) * A( 49  )
      S = S - A( 14  ) * A( 50  )
      S = S - A( 19  ) * A( 51  )
      S = S - A( 25  ) * A( 52  )
      S = S - A( 32  ) * A( 53  )
      S = S - A( 40  ) * A( 54  )
      A( 49 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 10  ) * A( 59  )
      S = S - A( 14  ) * A( 60  )
      S = S - A( 19  ) * A( 61  )
      S = S - A( 25  ) * A( 62  )
      S = S - A( 32  ) * A( 63  )
      S = S - A( 40  ) * A( 64  )
      S = S - A( 49  ) * A( 65  )
      A( 59 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 10  ) * A( 70  )
      S = S - A( 14  ) * A( 71  )
      S = S - A( 19  ) * A( 72  )
      S = S - A( 25  ) * A( 73  )
      S = S - A( 32  ) * A( 74  )
      S = S - A( 40  ) * A( 75  )
      S = S - A( 49  ) * A( 76  )
      S = S - A( 59  ) * A( 77  )
      A( 70 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 10  ) * A( 82  )
      S = S - A( 14  ) * A( 83  )
      S = S - A( 19  ) * A( 84  )
      S = S - A( 25  ) * A( 85  )
      S = S - A( 32  ) * A( 86  )
      S = S - A( 40  ) * A( 87  )
      S = S - A( 49  ) * A( 88  )
      S = S - A( 59  ) * A( 89  )
      S = S - A( 70  ) * A( 90  )
      A( 82 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 10  ) * A( 95  )
      S = S - A( 14  ) * A( 96  )
      S = S - A( 19  ) * A( 97  )
      S = S - A( 25  ) * A( 98  )
      S = S - A( 32  ) * A( 99  )
      S = S - A( 40  ) * A( 100  )
      S = S - A( 49  ) * A( 101  )
      S = S - A( 59  ) * A( 102  )
      S = S - A( 70  ) * A( 103  )
      S = S - A( 82  ) * A( 104  )
      A( 95 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 15  ) * A( 20  )
      A( 20 ) = S * A( 21  )
      S = 0.0D0
      S = S - A( 15  ) * A( 26  )
      S = S - A( 20  ) * A( 27  )
      A( 26 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 15  ) * A( 33  )
      S = S - A( 20  ) * A( 34  )
      S = S - A( 26  ) * A( 35  )
      A( 33 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 15  ) * A( 41  )
      S = S - A( 20  ) * A( 42  )
      S = S - A( 26  ) * A( 43  )
      S = S - A( 33  ) * A( 44  )
      A( 41 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 15  ) * A( 50  )
      S = S - A( 20  ) * A( 51  )
      S = S - A( 26  ) * A( 52  )
      S = S - A( 33  ) * A( 53  )
      S = S - A( 41  ) * A( 54  )
      A( 50 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 15  ) * A( 60  )
      S = S - A( 20  ) * A( 61  )
      S = S - A( 26  ) * A( 62  )
      S = S - A( 33  ) * A( 63  )
      S = S - A( 41  ) * A( 64  )
      S = S - A( 50  ) * A( 65  )
      A( 60 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 15  ) * A( 71  )
      S = S - A( 20  ) * A( 72  )
      S = S - A( 26  ) * A( 73  )
      S = S - A( 33  ) * A( 74  )
      S = S - A( 41  ) * A( 75  )
      S = S - A( 50  ) * A( 76  )
      S = S - A( 60  ) * A( 77  )
      A( 71 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 15  ) * A( 83  )
      S = S - A( 20  ) * A( 84  )
      S = S - A( 26  ) * A( 85  )
      S = S - A( 33  ) * A( 86  )
      S = S - A( 41  ) * A( 87  )
      S = S - A( 50  ) * A( 88  )
      S = S - A( 60  ) * A( 89  )
      S = S - A( 71  ) * A( 90  )
      A( 83 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 15  ) * A( 96  )
      S = S - A( 20  ) * A( 97  )
      S = S - A( 26  ) * A( 98  )
      S = S - A( 33  ) * A( 99  )
      S = S - A( 41  ) * A( 100  )
      S = S - A( 50  ) * A( 101  )
      S = S - A( 60  ) * A( 102  )
      S = S - A( 71  ) * A( 103  )
      S = S - A( 83  ) * A( 104  )
      A( 96 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 21  ) * A( 27  )
      A( 27 ) = S * A( 28  )
      S = 0.0D0
      S = S - A( 21  ) * A( 34  )
      S = S - A( 27  ) * A( 35  )
      A( 34 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 21  ) * A( 42  )
      S = S - A( 27  ) * A( 43  )
      S = S - A( 34  ) * A( 44  )
      A( 42 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 21  ) * A( 51  )
      S = S - A( 27  ) * A( 52  )
      S = S - A( 34  ) * A( 53  )
      S = S - A( 42  ) * A( 54  )
      A( 51 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 21  ) * A( 61  )
      S = S - A( 27  ) * A( 62  )
      S = S - A( 34  ) * A( 63  )
      S = S - A( 42  ) * A( 64  )
      S = S - A( 51  ) * A( 65  )
      A( 61 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 21  ) * A( 72  )
      S = S - A( 27  ) * A( 73  )
      S = S - A( 34  ) * A( 74  )
      S = S - A( 42  ) * A( 75  )
      S = S - A( 51  ) * A( 76  )
      S = S - A( 61  ) * A( 77  )
      A( 72 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 21  ) * A( 84  )
      S = S - A( 27  ) * A( 85  )
      S = S - A( 34  ) * A( 86  )
      S = S - A( 42  ) * A( 87  )
      S = S - A( 51  ) * A( 88  )
      S = S - A( 61  ) * A( 89  )
      S = S - A( 72  ) * A( 90  )
      A( 84 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 21  ) * A( 97  )
      S = S - A( 27  ) * A( 98  )
      S = S - A( 34  ) * A( 99  )
      S = S - A( 42  ) * A( 100  )
      S = S - A( 51  ) * A( 101  )
      S = S - A( 61  ) * A( 102  )
      S = S - A( 72  ) * A( 103  )
      S = S - A( 84  ) * A( 104  )
      A( 97 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 28  ) * A( 35  )
      A( 35 ) = S * A( 36  )
      S = 0.0D0
      S = S - A( 28  ) * A( 43  )
      S = S - A( 35  ) * A( 44  )
      A( 43 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 28  ) * A( 52  )
      S = S - A( 35  ) * A( 53  )
      S = S - A( 43  ) * A( 54  )
      A( 52 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 28  ) * A( 62  )
      S = S - A( 35  ) * A( 63  )
      S = S - A( 43  ) * A( 64  )
      S = S - A( 52  ) * A( 65  )
      A( 62 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 28  ) * A( 73  )
      S = S - A( 35  ) * A( 74  )
      S = S - A( 43  ) * A( 75  )
      S = S - A( 52  ) * A( 76  )
      S = S - A( 62  ) * A( 77  )
      A( 73 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 28  ) * A( 85  )
      S = S - A( 35  ) * A( 86  )
      S = S - A( 43  ) * A( 87  )
      S = S - A( 52  ) * A( 88  )
      S = S - A( 62  ) * A( 89  )
      S = S - A( 73  ) * A( 90  )
      A( 85 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 28  ) * A( 98  )
      S = S - A( 35  ) * A( 99  )
      S = S - A( 43  ) * A( 100  )
      S = S - A( 52  ) * A( 101  )
      S = S - A( 62  ) * A( 102  )
      S = S - A( 73  ) * A( 103  )
      S = S - A( 85  ) * A( 104  )
      A( 98 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 36  ) * A( 44  )
      A( 44 ) = S * A( 45  )
      S = 0.0D0
      S = S - A( 36  ) * A( 53  )
      S = S - A( 44  ) * A( 54  )
      A( 53 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 36  ) * A( 63  )
      S = S - A( 44  ) * A( 64  )
      S = S - A( 53  ) * A( 65  )
      A( 63 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 36  ) * A( 74  )
      S = S - A( 44  ) * A( 75  )
      S = S - A( 53  ) * A( 76  )
      S = S - A( 63  ) * A( 77  )
      A( 74 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 36  ) * A( 86  )
      S = S - A( 44  ) * A( 87  )
      S = S - A( 53  ) * A( 88  )
      S = S - A( 63  ) * A( 89  )
      S = S - A( 74  ) * A( 90  )
      A( 86 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 36  ) * A( 99  )
      S = S - A( 44  ) * A( 100  )
      S = S - A( 53  ) * A( 101  )
      S = S - A( 63  ) * A( 102  )
      S = S - A( 74  ) * A( 103  )
      S = S - A( 86  ) * A( 104  )
      A( 99 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 45  ) * A( 54  )
      A( 54 ) = S * A( 55  )
      S = 0.0D0
      S = S - A( 45  ) * A( 64  )
      S = S - A( 54  ) * A( 65  )
      A( 64 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 45  ) * A( 75  )
      S = S - A( 54  ) * A( 76  )
      S = S - A( 64  ) * A( 77  )
      A( 75 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 45  ) * A( 87  )
      S = S - A( 54  ) * A( 88  )
      S = S - A( 64  ) * A( 89  )
      S = S - A( 75  ) * A( 90  )
      A( 87 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 45  ) * A( 100  )
      S = S - A( 54  ) * A( 101  )
      S = S - A( 64  ) * A( 102  )
      S = S - A( 75  ) * A( 103  )
      S = S - A( 87  ) * A( 104  )
      A( 100 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 55  ) * A( 65  )
      A( 65 ) = S * A( 66  )
      S = 0.0D0
      S = S - A( 55  ) * A( 76  )
      S = S - A( 65  ) * A( 77  )
      A( 76 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 55  ) * A( 88  )
      S = S - A( 65  ) * A( 89  )
      S = S - A( 76  ) * A( 90  )
      A( 88 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 55  ) * A( 101  )
      S = S - A( 65  ) * A( 102  )
      S = S - A( 76  ) * A( 103  )
      S = S - A( 88  ) * A( 104  )
      A( 101 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 66  ) * A( 77  )
      A( 77 ) = S * A( 78  )
      S = 0.0D0
      S = S - A( 66  ) * A( 89  )
      S = S - A( 77  ) * A( 90  )
      A( 89 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 66  ) * A( 102  )
      S = S - A( 77  ) * A( 103  )
      S = S - A( 89  ) * A( 104  )
      A( 102 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 78  ) * A( 90  )
      A( 90 ) = S * A( 91  )
      S = 0.0D0
      S = S - A( 78  ) * A( 103  )
      S = S - A( 90  ) * A( 104  )
      A( 103 ) = S * A( 105  )
      S = 0.0D0
      S = S - A( 91  ) * A( 104  )
      A( 104 ) = S * A( 105  )
      S = 0.0D0
      S = S + A( 1  ) * A( 1  )
      S = S + A( 2  ) * A( 2  )
      S = S + A( 4  ) * A( 4  )
      S = S + A( 7  ) * A( 7  )
      S = S + A( 11  ) * A( 11  )
      S = S + A( 16  ) * A( 16  )
      S = S + A( 22  ) * A( 22  )
      S = S + A( 29  ) * A( 29  )
      S = S + A( 37  ) * A( 37  )
      S = S + A( 46  ) * A( 46  )
      S = S + A( 56  ) * A( 56  )
      S = S + A( 67  ) * A( 67  )
      S = S + A( 79  ) * A( 79  )
      S = S + A( 92  ) * A( 92  )
      A( 1  ) = S
      S = 0.0D0
      S = S + A( 2  ) * A( 3  )
      S = S + A( 4  ) * A( 5  )
      S = S + A( 7  ) * A( 8  )
      S = S + A( 11  ) * A( 12  )
      S = S + A( 16  ) * A( 17  )
      S = S + A( 22  ) * A( 23  )
      S = S + A( 29  ) * A( 30  )
      S = S + A( 37  ) * A( 38  )
      S = S + A( 46  ) * A( 47  )
      S = S + A( 56  ) * A( 57  )
      S = S + A( 67  ) * A( 68  )
      S = S + A( 79  ) * A( 80  )
      S = S + A( 92  ) * A( 93  )
      A( 2  ) = S
      S = 0.0D0
      S = S + A( 4  ) * A( 6  )
      S = S + A( 7  ) * A( 9  )
      S = S + A( 11  ) * A( 13  )
      S = S + A( 16  ) * A( 18  )
      S = S + A( 22  ) * A( 24  )
      S = S + A( 29  ) * A( 31  )
      S = S + A( 37  ) * A( 39  )
      S = S + A( 46  ) * A( 48  )
      S = S + A( 56  ) * A( 58  )
      S = S + A( 67  ) * A( 69  )
      S = S + A( 79  ) * A( 81  )
      S = S + A( 92  ) * A( 94  )
      A( 4  ) = S
      S = 0.0D0
      S = S + A( 7  ) * A( 10  )
      S = S + A( 11  ) * A( 14  )
      S = S + A( 16  ) * A( 19  )
      S = S + A( 22  ) * A( 25  )
      S = S + A( 29  ) * A( 32  )
      S = S + A( 37  ) * A( 40  )
      S = S + A( 46  ) * A( 49  )
      S = S + A( 56  ) * A( 59  )
      S = S + A( 67  ) * A( 70  )
      S = S + A( 79  ) * A( 82  )
      S = S + A( 92  ) * A( 95  )
      A( 7  ) = S
      S = 0.0D0
      S = S + A( 11  ) * A( 15  )
      S = S + A( 16  ) * A( 20  )
      S = S + A( 22  ) * A( 26  )
      S = S + A( 29  ) * A( 33  )
      S = S + A( 37  ) * A( 41  )
      S = S + A( 46  ) * A( 50  )
      S = S + A( 56  ) * A( 60  )
      S = S + A( 67  ) * A( 71  )
      S = S + A( 79  ) * A( 83  )
      S = S + A( 92  ) * A( 96  )
      A( 11  ) = S
      S = 0.0D0
      S = S + A( 16  ) * A( 21  )
      S = S + A( 22  ) * A( 27  )
      S = S + A( 29  ) * A( 34  )
      S = S + A( 37  ) * A( 42  )
      S = S + A( 46  ) * A( 51  )
      S = S + A( 56  ) * A( 61  )
      S = S + A( 67  ) * A( 72  )
      S = S + A( 79  ) * A( 84  )
      S = S + A( 92  ) * A( 97  )
      A( 16  ) = S
      S = 0.0D0
      S = S + A( 22  ) * A( 28  )
      S = S + A( 29  ) * A( 35  )
      S = S + A( 37  ) * A( 43  )
      S = S + A( 46  ) * A( 52  )
      S = S + A( 56  ) * A( 62  )
      S = S + A( 67  ) * A( 73  )
      S = S + A( 79  ) * A( 85  )
      S = S + A( 92  ) * A( 98  )
      A( 22  ) = S
      S = 0.0D0
      S = S + A( 29  ) * A( 36  )
      S = S + A( 37  ) * A( 44  )
      S = S + A( 46  ) * A( 53  )
      S = S + A( 56  ) * A( 63  )
      S = S + A( 67  ) * A( 74  )
      S = S + A( 79  ) * A( 86  )
      S = S + A( 92  ) * A( 99  )
      A( 29  ) = S
      S = 0.0D0
      S = S + A( 37  ) * A( 45  )
      S = S + A( 46  ) * A( 54  )
      S = S + A( 56  ) * A( 64  )
      S = S + A( 67  ) * A( 75  )
      S = S + A( 79  ) * A( 87  )
      S = S + A( 92  ) * A( 100  )
      A( 37  ) = S
      S = 0.0D0
      S = S + A( 46  ) * A( 55  )
      S = S + A( 56  ) * A( 65  )
      S = S + A( 67  ) * A( 76  )
      S = S + A( 79  ) * A( 88  )
      S = S + A( 92  ) * A( 101  )
      A( 46  ) = S
      S = 0.0D0
      S = S + A( 56  ) * A( 66  )
      S = S + A( 67  ) * A( 77  )
      S = S + A( 79  ) * A( 89  )
      S = S + A( 92  ) * A( 102  )
      A( 56  ) = S
      S = 0.0D0
      S = S + A( 67  ) * A( 78  )
      S = S + A( 79  ) * A( 90  )
      S = S + A( 92  ) * A( 103  )
      A( 67  ) = S
      S = 0.0D0
      S = S + A( 79  ) * A( 91  )
      S = S + A( 92  ) * A( 104  )
      A( 79  ) = S
      S = 0.0D0
      S = S + A( 92  ) * A( 105  )
      A( 92  ) = S
      S = 0.0D0
      S = S + A( 3  ) * A( 3  )
      S = S + A( 5  ) * A( 5  )
      S = S + A( 8  ) * A( 8  )
      S = S + A( 12  ) * A( 12  )
      S = S + A( 17  ) * A( 17  )
      S = S + A( 23  ) * A( 23  )
      S = S + A( 30  ) * A( 30  )
      S = S + A( 38  ) * A( 38  )
      S = S + A( 47  ) * A( 47  )
      S = S + A( 57  ) * A( 57  )
      S = S + A( 68  ) * A( 68  )
      S = S + A( 80  ) * A( 80  )
      S = S + A( 93  ) * A( 93  )
      A( 3  ) = S
      S = 0.0D0
      S = S + A( 5  ) * A( 6  )
      S = S + A( 8  ) * A( 9  )
      S = S + A( 12  ) * A( 13  )
      S = S + A( 17  ) * A( 18  )
      S = S + A( 23  ) * A( 24  )
      S = S + A( 30  ) * A( 31  )
      S = S + A( 38  ) * A( 39  )
      S = S + A( 47  ) * A( 48  )
      S = S + A( 57  ) * A( 58  )
      S = S + A( 68  ) * A( 69  )
      S = S + A( 80  ) * A( 81  )
      S = S + A( 93  ) * A( 94  )
      A( 5  ) = S
      S = 0.0D0
      S = S + A( 8  ) * A( 10  )
      S = S + A( 12  ) * A( 14  )
      S = S + A( 17  ) * A( 19  )
      S = S + A( 23  ) * A( 25  )
      S = S + A( 30  ) * A( 32  )
      S = S + A( 38  ) * A( 40  )
      S = S + A( 47  ) * A( 49  )
      S = S + A( 57  ) * A( 59  )
      S = S + A( 68  ) * A( 70  )
      S = S + A( 80  ) * A( 82  )
      S = S + A( 93  ) * A( 95  )
      A( 8  ) = S
      S = 0.0D0
      S = S + A( 12  ) * A( 15  )
      S = S + A( 17  ) * A( 20  )
      S = S + A( 23  ) * A( 26  )
      S = S + A( 30  ) * A( 33  )
      S = S + A( 38  ) * A( 41  )
      S = S + A( 47  ) * A( 50  )
      S = S + A( 57  ) * A( 60  )
      S = S + A( 68  ) * A( 71  )
      S = S + A( 80  ) * A( 83  )
      S = S + A( 93  ) * A( 96  )
      A( 12  ) = S
      S = 0.0D0
      S = S + A( 17  ) * A( 21  )
      S = S + A( 23  ) * A( 27  )
      S = S + A( 30  ) * A( 34  )
      S = S + A( 38  ) * A( 42  )
      S = S + A( 47  ) * A( 51  )
      S = S + A( 57  ) * A( 61  )
      S = S + A( 68  ) * A( 72  )
      S = S + A( 80  ) * A( 84  )
      S = S + A( 93  ) * A( 97  )
      A( 17  ) = S
      S = 0.0D0
      S = S + A( 23  ) * A( 28  )
      S = S + A( 30  ) * A( 35  )
      S = S + A( 38  ) * A( 43  )
      S = S + A( 47  ) * A( 52  )
      S = S + A( 57  ) * A( 62  )
      S = S + A( 68  ) * A( 73  )
      S = S + A( 80  ) * A( 85  )
      S = S + A( 93  ) * A( 98  )
      A( 23  ) = S
      S = 0.0D0
      S = S + A( 30  ) * A( 36  )
      S = S + A( 38  ) * A( 44  )
      S = S + A( 47  ) * A( 53  )
      S = S + A( 57  ) * A( 63  )
      S = S + A( 68  ) * A( 74  )
      S = S + A( 80  ) * A( 86  )
      S = S + A( 93  ) * A( 99  )
      A( 30  ) = S
      S = 0.0D0
      S = S + A( 38  ) * A( 45  )
      S = S + A( 47  ) * A( 54  )
      S = S + A( 57  ) * A( 64  )
      S = S + A( 68  ) * A( 75  )
      S = S + A( 80  ) * A( 87  )
      S = S + A( 93  ) * A( 100  )
      A( 38  ) = S
      S = 0.0D0
      S = S + A( 47  ) * A( 55  )
      S = S + A( 57  ) * A( 65  )
      S = S + A( 68  ) * A( 76  )
      S = S + A( 80  ) * A( 88  )
      S = S + A( 93  ) * A( 101  )
      A( 47  ) = S
      S = 0.0D0
      S = S + A( 57  ) * A( 66  )
      S = S + A( 68  ) * A( 77  )
      S = S + A( 80  ) * A( 89  )
      S = S + A( 93  ) * A( 102  )
      A( 57  ) = S
      S = 0.0D0
      S = S + A( 68  ) * A( 78  )
      S = S + A( 80  ) * A( 90  )
      S = S + A( 93  ) * A( 103  )
      A( 68  ) = S
      S = 0.0D0
      S = S + A( 80  ) * A( 91  )
      S = S + A( 93  ) * A( 104  )
      A( 80  ) = S
      S = 0.0D0
      S = S + A( 93  ) * A( 105  )
      A( 93  ) = S
      S = 0.0D0
      S = S + A( 6  ) * A( 6  )
      S = S + A( 9  ) * A( 9  )
      S = S + A( 13  ) * A( 13  )
      S = S + A( 18  ) * A( 18  )
      S = S + A( 24  ) * A( 24  )
      S = S + A( 31  ) * A( 31  )
      S = S + A( 39  ) * A( 39  )
      S = S + A( 48  ) * A( 48  )
      S = S + A( 58  ) * A( 58  )
      S = S + A( 69  ) * A( 69  )
      S = S + A( 81  ) * A( 81  )
      S = S + A( 94  ) * A( 94  )
      A( 6  ) = S
      S = 0.0D0
      S = S + A( 9  ) * A( 10  )
      S = S + A( 13  ) * A( 14  )
      S = S + A( 18  ) * A( 19  )
      S = S + A( 24  ) * A( 25  )
      S = S + A( 31  ) * A( 32  )
      S = S + A( 39  ) * A( 40  )
      S = S + A( 48  ) * A( 49  )
      S = S + A( 58  ) * A( 59  )
      S = S + A( 69  ) * A( 70  )
      S = S + A( 81  ) * A( 82  )
      S = S + A( 94  ) * A( 95  )
      A( 9  ) = S
      S = 0.0D0
      S = S + A( 13  ) * A( 15  )
      S = S + A( 18  ) * A( 20  )
      S = S + A( 24  ) * A( 26  )
      S = S + A( 31  ) * A( 33  )
      S = S + A( 39  ) * A( 41  )
      S = S + A( 48  ) * A( 50  )
      S = S + A( 58  ) * A( 60  )
      S = S + A( 69  ) * A( 71  )
      S = S + A( 81  ) * A( 83  )
      S = S + A( 94  ) * A( 96  )
      A( 13  ) = S
      S = 0.0D0
      S = S + A( 18  ) * A( 21  )
      S = S + A( 24  ) * A( 27  )
      S = S + A( 31  ) * A( 34  )
      S = S + A( 39  ) * A( 42  )
      S = S + A( 48  ) * A( 51  )
      S = S + A( 58  ) * A( 61  )
      S = S + A( 69  ) * A( 72  )
      S = S + A( 81  ) * A( 84  )
      S = S + A( 94  ) * A( 97  )
      A( 18  ) = S
      S = 0.0D0
      S = S + A( 24  ) * A( 28  )
      S = S + A( 31  ) * A( 35  )
      S = S + A( 39  ) * A( 43  )
      S = S + A( 48  ) * A( 52  )
      S = S + A( 58  ) * A( 62  )
      S = S + A( 69  ) * A( 73  )
      S = S + A( 81  ) * A( 85  )
      S = S + A( 94  ) * A( 98  )
      A( 24  ) = S
      S = 0.0D0
      S = S + A( 31  ) * A( 36  )
      S = S + A( 39  ) * A( 44  )
      S = S + A( 48  ) * A( 53  )
      S = S + A( 58  ) * A( 63  )
      S = S + A( 69  ) * A( 74  )
      S = S + A( 81  ) * A( 86  )
      S = S + A( 94  ) * A( 99  )
      A( 31  ) = S
      S = 0.0D0
      S = S + A( 39  ) * A( 45  )
      S = S + A( 48  ) * A( 54  )
      S = S + A( 58  ) * A( 64  )
      S = S + A( 69  ) * A( 75  )
      S = S + A( 81  ) * A( 87  )
      S = S + A( 94  ) * A( 100  )
      A( 39  ) = S
      S = 0.0D0
      S = S + A( 48  ) * A( 55  )
      S = S + A( 58  ) * A( 65  )
      S = S + A( 69  ) * A( 76  )
      S = S + A( 81  ) * A( 88  )
      S = S + A( 94  ) * A( 101  )
      A( 48  ) = S
      S = 0.0D0
      S = S + A( 58  ) * A( 66  )
      S = S + A( 69  ) * A( 77  )
      S = S + A( 81  ) * A( 89  )
      S = S + A( 94  ) * A( 102  )
      A( 58  ) = S
      S = 0.0D0
      S = S + A( 69  ) * A( 78  )
      S = S + A( 81  ) * A( 90  )
      S = S + A( 94  ) * A( 103  )
      A( 69  ) = S
      S = 0.0D0
      S = S + A( 81  ) * A( 91  )
      S = S + A( 94  ) * A( 104  )
      A( 81  ) = S
      S = 0.0D0
      S = S + A( 94  ) * A( 105  )
      A( 94  ) = S
      S = 0.0D0
      S = S + A( 10  ) * A( 10  )
      S = S + A( 14  ) * A( 14  )
      S = S + A( 19  ) * A( 19  )
      S = S + A( 25  ) * A( 25  )
      S = S + A( 32  ) * A( 32  )
      S = S + A( 40  ) * A( 40  )
      S = S + A( 49  ) * A( 49  )
      S = S + A( 59  ) * A( 59  )
      S = S + A( 70  ) * A( 70  )
      S = S + A( 82  ) * A( 82  )
      S = S + A( 95  ) * A( 95  )
      A( 10  ) = S
      S = 0.0D0
      S = S + A( 14  ) * A( 15  )
      S = S + A( 19  ) * A( 20  )
      S = S + A( 25  ) * A( 26  )
      S = S + A( 32  ) * A( 33  )
      S = S + A( 40  ) * A( 41  )
      S = S + A( 49  ) * A( 50  )
      S = S + A( 59  ) * A( 60  )
      S = S + A( 70  ) * A( 71  )
      S = S + A( 82  ) * A( 83  )
      S = S + A( 95  ) * A( 96  )
      A( 14  ) = S
      S = 0.0D0
      S = S + A( 19  ) * A( 21  )
      S = S + A( 25  ) * A( 27  )
      S = S + A( 32  ) * A( 34  )
      S = S + A( 40  ) * A( 42  )
      S = S + A( 49  ) * A( 51  )
      S = S + A( 59  ) * A( 61  )
      S = S + A( 70  ) * A( 72  )
      S = S + A( 82  ) * A( 84  )
      S = S + A( 95  ) * A( 97  )
      A( 19  ) = S
      S = 0.0D0
      S = S + A( 25  ) * A( 28  )
      S = S + A( 32  ) * A( 35  )
      S = S + A( 40  ) * A( 43  )
      S = S + A( 49  ) * A( 52  )
      S = S + A( 59  ) * A( 62  )
      S = S + A( 70  ) * A( 73  )
      S = S + A( 82  ) * A( 85  )
      S = S + A( 95  ) * A( 98  )
      A( 25  ) = S
      S = 0.0D0
      S = S + A( 32  ) * A( 36  )
      S = S + A( 40  ) * A( 44  )
      S = S + A( 49  ) * A( 53  )
      S = S + A( 59  ) * A( 63  )
      S = S + A( 70  ) * A( 74  )
      S = S + A( 82  ) * A( 86  )
      S = S + A( 95  ) * A( 99  )
      A( 32  ) = S
      S = 0.0D0
      S = S + A( 40  ) * A( 45  )
      S = S + A( 49  ) * A( 54  )
      S = S + A( 59  ) * A( 64  )
      S = S + A( 70  ) * A( 75  )
      S = S + A( 82  ) * A( 87  )
      S = S + A( 95  ) * A( 100  )
      A( 40  ) = S
      S = 0.0D0
      S = S + A( 49  ) * A( 55  )
      S = S + A( 59  ) * A( 65  )
      S = S + A( 70  ) * A( 76  )
      S = S + A( 82  ) * A( 88  )
      S = S + A( 95  ) * A( 101  )
      A( 49  ) = S
      S = 0.0D0
      S = S + A( 59  ) * A( 66  )
      S = S + A( 70  ) * A( 77  )
      S = S + A( 82  ) * A( 89  )
      S = S + A( 95  ) * A( 102  )
      A( 59  ) = S
      S = 0.0D0
      S = S + A( 70  ) * A( 78  )
      S = S + A( 82  ) * A( 90  )
      S = S + A( 95  ) * A( 103  )
      A( 70  ) = S
      S = 0.0D0
      S = S + A( 82  ) * A( 91  )
      S = S + A( 95  ) * A( 104  )
      A( 82  ) = S
      S = 0.0D0
      S = S + A( 95  ) * A( 105  )
      A( 95  ) = S
      S = 0.0D0
      S = S + A( 15  ) * A( 15  )
      S = S + A( 20  ) * A( 20  )
      S = S + A( 26  ) * A( 26  )
      S = S + A( 33  ) * A( 33  )
      S = S + A( 41  ) * A( 41  )
      S = S + A( 50  ) * A( 50  )
      S = S + A( 60  ) * A( 60  )
      S = S + A( 71  ) * A( 71  )
      S = S + A( 83  ) * A( 83  )
      S = S + A( 96  ) * A( 96  )
      A( 15  ) = S
      S = 0.0D0
      S = S + A( 20  ) * A( 21  )
      S = S + A( 26  ) * A( 27  )
      S = S + A( 33  ) * A( 34  )
      S = S + A( 41  ) * A( 42  )
      S = S + A( 50  ) * A( 51  )
      S = S + A( 60  ) * A( 61  )
      S = S + A( 71  ) * A( 72  )
      S = S + A( 83  ) * A( 84  )
      S = S + A( 96  ) * A( 97  )
      A( 20  ) = S
      S = 0.0D0
      S = S + A( 26  ) * A( 28  )
      S = S + A( 33  ) * A( 35  )
      S = S + A( 41  ) * A( 43  )
      S = S + A( 50  ) * A( 52  )
      S = S + A( 60  ) * A( 62  )
      S = S + A( 71  ) * A( 73  )
      S = S + A( 83  ) * A( 85  )
      S = S + A( 96  ) * A( 98  )
      A( 26  ) = S
      S = 0.0D0
      S = S + A( 33  ) * A( 36  )
      S = S + A( 41  ) * A( 44  )
      S = S + A( 50  ) * A( 53  )
      S = S + A( 60  ) * A( 63  )
      S = S + A( 71  ) * A( 74  )
      S = S + A( 83  ) * A( 86  )
      S = S + A( 96  ) * A( 99  )
      A( 33  ) = S
      S = 0.0D0
      S = S + A( 41  ) * A( 45  )
      S = S + A( 50  ) * A( 54  )
      S = S + A( 60  ) * A( 64  )
      S = S + A( 71  ) * A( 75  )
      S = S + A( 83  ) * A( 87  )
      S = S + A( 96  ) * A( 100  )
      A( 41  ) = S
      S = 0.0D0
      S = S + A( 50  ) * A( 55  )
      S = S + A( 60  ) * A( 65  )
      S = S + A( 71  ) * A( 76  )
      S = S + A( 83  ) * A( 88  )
      S = S + A( 96  ) * A( 101  )
      A( 50  ) = S
      S = 0.0D0
      S = S + A( 60  ) * A( 66  )
      S = S + A( 71  ) * A( 77  )
      S = S + A( 83  ) * A( 89  )
      S = S + A( 96  ) * A( 102  )
      A( 60  ) = S
      S = 0.0D0
      S = S + A( 71  ) * A( 78  )
      S = S + A( 83  ) * A( 90  )
      S = S + A( 96  ) * A( 103  )
      A( 71  ) = S
      S = 0.0D0
      S = S + A( 83  ) * A( 91  )
      S = S + A( 96  ) * A( 104  )
      A( 83  ) = S
      S = 0.0D0
      S = S + A( 96  ) * A( 105  )
      A( 96  ) = S
      S = 0.0D0
      S = S + A( 21  ) * A( 21  )
      S = S + A( 27  ) * A( 27  )
      S = S + A( 34  ) * A( 34  )
      S = S + A( 42  ) * A( 42  )
      S = S + A( 51  ) * A( 51  )
      S = S + A( 61  ) * A( 61  )
      S = S + A( 72  ) * A( 72  )
      S = S + A( 84  ) * A( 84  )
      S = S + A( 97  ) * A( 97  )
      A( 21  ) = S
      S = 0.0D0
      S = S + A( 27  ) * A( 28  )
      S = S + A( 34  ) * A( 35  )
      S = S + A( 42  ) * A( 43  )
      S = S + A( 51  ) * A( 52  )
      S = S + A( 61  ) * A( 62  )
      S = S + A( 72  ) * A( 73  )
      S = S + A( 84  ) * A( 85  )
      S = S + A( 97  ) * A( 98  )
      A( 27  ) = S
      S = 0.0D0
      S = S + A( 34  ) * A( 36  )
      S = S + A( 42  ) * A( 44  )
      S = S + A( 51  ) * A( 53  )
      S = S + A( 61  ) * A( 63  )
      S = S + A( 72  ) * A( 74  )
      S = S + A( 84  ) * A( 86  )
      S = S + A( 97  ) * A( 99  )
      A( 34  ) = S
      S = 0.0D0
      S = S + A( 42  ) * A( 45  )
      S = S + A( 51  ) * A( 54  )
      S = S + A( 61  ) * A( 64  )
      S = S + A( 72  ) * A( 75  )
      S = S + A( 84  ) * A( 87  )
      S = S + A( 97  ) * A( 100  )
      A( 42  ) = S
      S = 0.0D0
      S = S + A( 51  ) * A( 55  )
      S = S + A( 61  ) * A( 65  )
      S = S + A( 72  ) * A( 76  )
      S = S + A( 84  ) * A( 88  )
      S = S + A( 97  ) * A( 101  )
      A( 51  ) = S
      S = 0.0D0
      S = S + A( 61  ) * A( 66  )
      S = S + A( 72  ) * A( 77  )
      S = S + A( 84  ) * A( 89  )
      S = S + A( 97  ) * A( 102  )
      A( 61  ) = S
      S = 0.0D0
      S = S + A( 72  ) * A( 78  )
      S = S + A( 84  ) * A( 90  )
      S = S + A( 97  ) * A( 103  )
      A( 72  ) = S
      S = 0.0D0
      S = S + A( 84  ) * A( 91  )
      S = S + A( 97  ) * A( 104  )
      A( 84  ) = S
      S = 0.0D0
      S = S + A( 97  ) * A( 105  )
      A( 97  ) = S
      S = 0.0D0
      S = S + A( 28  ) * A( 28  )
      S = S + A( 35  ) * A( 35  )
      S = S + A( 43  ) * A( 43  )
      S = S + A( 52  ) * A( 52  )
      S = S + A( 62  ) * A( 62  )
      S = S + A( 73  ) * A( 73  )
      S = S + A( 85  ) * A( 85  )
      S = S + A( 98  ) * A( 98  )
      A( 28  ) = S
      S = 0.0D0
      S = S + A( 35  ) * A( 36  )
      S = S + A( 43  ) * A( 44  )
      S = S + A( 52  ) * A( 53  )
      S = S + A( 62  ) * A( 63  )
      S = S + A( 73  ) * A( 74  )
      S = S + A( 85  ) * A( 86  )
      S = S + A( 98  ) * A( 99  )
      A( 35  ) = S
      S = 0.0D0
      S = S + A( 43  ) * A( 45  )
      S = S + A( 52  ) * A( 54  )
      S = S + A( 62  ) * A( 64  )
      S = S + A( 73  ) * A( 75  )
      S = S + A( 85  ) * A( 87  )
      S = S + A( 98  ) * A( 100  )
      A( 43  ) = S
      S = 0.0D0
      S = S + A( 52  ) * A( 55  )
      S = S + A( 62  ) * A( 65  )
      S = S + A( 73  ) * A( 76  )
      S = S + A( 85  ) * A( 88  )
      S = S + A( 98  ) * A( 101  )
      A( 52  ) = S
      S = 0.0D0
      S = S + A( 62  ) * A( 66  )
      S = S + A( 73  ) * A( 77  )
      S = S + A( 85  ) * A( 89  )
      S = S + A( 98  ) * A( 102  )
      A( 62  ) = S
      S = 0.0D0
      S = S + A( 73  ) * A( 78  )
      S = S + A( 85  ) * A( 90  )
      S = S + A( 98  ) * A( 103  )
      A( 73  ) = S
      S = 0.0D0
      S = S + A( 85  ) * A( 91  )
      S = S + A( 98  ) * A( 104  )
      A( 85  ) = S
      S = 0.0D0
      S = S + A( 98  ) * A( 105  )
      A( 98  ) = S
      S = 0.0D0
      S = S + A( 36  ) * A( 36  )
      S = S + A( 44  ) * A( 44  )
      S = S + A( 53  ) * A( 53  )
      S = S + A( 63  ) * A( 63  )
      S = S + A( 74  ) * A( 74  )
      S = S + A( 86  ) * A( 86  )
      S = S + A( 99  ) * A( 99  )
      A( 36  ) = S
      S = 0.0D0
      S = S + A( 44  ) * A( 45  )
      S = S + A( 53  ) * A( 54  )
      S = S + A( 63  ) * A( 64  )
      S = S + A( 74  ) * A( 75  )
      S = S + A( 86  ) * A( 87  )
      S = S + A( 99  ) * A( 100  )
      A( 44  ) = S
      S = 0.0D0
      S = S + A( 53  ) * A( 55  )
      S = S + A( 63  ) * A( 65  )
      S = S + A( 74  ) * A( 76  )
      S = S + A( 86  ) * A( 88  )
      S = S + A( 99  ) * A( 101  )
      A( 53  ) = S
      S = 0.0D0
      S = S + A( 63  ) * A( 66  )
      S = S + A( 74  ) * A( 77  )
      S = S + A( 86  ) * A( 89  )
      S = S + A( 99  ) * A( 102  )
      A( 63  ) = S
      S = 0.0D0
      S = S + A( 74  ) * A( 78  )
      S = S + A( 86  ) * A( 90  )
      S = S + A( 99  ) * A( 103  )
      A( 74  ) = S
      S = 0.0D0
      S = S + A( 86  ) * A( 91  )
      S = S + A( 99  ) * A( 104  )
      A( 86  ) = S
      S = 0.0D0
      S = S + A( 99  ) * A( 105  )
      A( 99  ) = S
      S = 0.0D0
      S = S + A( 45  ) * A( 45  )
      S = S + A( 54  ) * A( 54  )
      S = S + A( 64  ) * A( 64  )
      S = S + A( 75  ) * A( 75  )
      S = S + A( 87  ) * A( 87  )
      S = S + A( 100  ) * A( 100  )
      A( 45  ) = S
      S = 0.0D0
      S = S + A( 54  ) * A( 55  )
      S = S + A( 64  ) * A( 65  )
      S = S + A( 75  ) * A( 76  )
      S = S + A( 87  ) * A( 88  )
      S = S + A( 100  ) * A( 101  )
      A( 54  ) = S
      S = 0.0D0
      S = S + A( 64  ) * A( 66  )
      S = S + A( 75  ) * A( 77  )
      S = S + A( 87  ) * A( 89  )
      S = S + A( 100  ) * A( 102  )
      A( 64  ) = S
      S = 0.0D0
      S = S + A( 75  ) * A( 78  )
      S = S + A( 87  ) * A( 90  )
      S = S + A( 100  ) * A( 103  )
      A( 75  ) = S
      S = 0.0D0
      S = S + A( 87  ) * A( 91  )
      S = S + A( 100  ) * A( 104  )
      A( 87  ) = S
      S = 0.0D0
      S = S + A( 100  ) * A( 105  )
      A( 100  ) = S
      S = 0.0D0
      S = S + A( 55  ) * A( 55  )
      S = S + A( 65  ) * A( 65  )
      S = S + A( 76  ) * A( 76  )
      S = S + A( 88  ) * A( 88  )
      S = S + A( 101  ) * A( 101  )
      A( 55  ) = S
      S = 0.0D0
      S = S + A( 65  ) * A( 66  )
      S = S + A( 76  ) * A( 77  )
      S = S + A( 88  ) * A( 89  )
      S = S + A( 101  ) * A( 102  )
      A( 65  ) = S
      S = 0.0D0
      S = S + A( 76  ) * A( 78  )
      S = S + A( 88  ) * A( 90  )
      S = S + A( 101  ) * A( 103  )
      A( 76  ) = S
      S = 0.0D0
      S = S + A( 88  ) * A( 91  )
      S = S + A( 101  ) * A( 104  )
      A( 88  ) = S
      S = 0.0D0
      S = S + A( 101  ) * A( 105  )
      A( 101  ) = S
      S = 0.0D0
      S = S + A( 66  ) * A( 66  )
      S = S + A( 77  ) * A( 77  )
      S = S + A( 89  ) * A( 89  )
      S = S + A( 102  ) * A( 102  )
      A( 66  ) = S
      S = 0.0D0
      S = S + A( 77  ) * A( 78  )
      S = S + A( 89  ) * A( 90  )
      S = S + A( 102  ) * A( 103  )
      A( 77  ) = S
      S = 0.0D0
      S = S + A( 89  ) * A( 91  )
      S = S + A( 102  ) * A( 104  )
      A( 89  ) = S
      S = 0.0D0
      S = S + A( 102  ) * A( 105  )
      A( 102  ) = S
      S = 0.0D0
      S = S + A( 78  ) * A( 78  )
      S = S + A( 90  ) * A( 90  )
      S = S + A( 103  ) * A( 103  )
      A( 78  ) = S
      S = 0.0D0
      S = S + A( 90  ) * A( 91  )
      S = S + A( 103  ) * A( 104  )
      A( 90  ) = S
      S = 0.0D0
      S = S + A( 103  ) * A( 105  )
      A( 103  ) = S
      S = 0.0D0
      S = S + A( 91  ) * A( 91  )
      S = S + A( 104  ) * A( 104  )
      A( 91  ) = S
      S = 0.0D0
      S = S + A( 104  ) * A( 105  )
      A( 104  ) = S
      S = 0.0D0
      S = S + A( 105  ) * A( 105  )
      A( 105  ) = S
!
      IERR = 0
      RETURN
      END  !#!  INVS_14  #!#
