#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#ifdef __MACH__
#include <mach/clock.h>
#include <mach/mach.h>
#include <mach/mach_time.h>
#endif

#define UNIX__J2000_UTC  946684800.0
#define UNIX__J2000_TAI  946684832.0

void get_hr_utc ( uint32_t  * time_info )
/*
# ************************************************************************
# *                                                                      *
# *   Routine get_hr_utc returns system UTC function in a broken format  *
# *   with precision to one nanosecond. (Though the accuracy of clock    *
# *   is more likely be at a level of one millisecond).                  *
# *                                                                      *
# *   Usage:                                                             *
# *                                                                      *
# *   CALL GET_HR_TIME ( TIME_INFO )                                     *
# *                                                                      *
# *                                                                      *
# * _________________________ Input parameters: ________________________ *
# *                                                                      *
# *    TIME_INFO ( INTEGER*4 ) -- Array of date. Dimension: 7.           *
# *                            TIME_INFO(1) -- year                      *
# *                            TIME_INFO(2) -- month                     *
# *                            TIME_INFO(3) -- day                       *
# *                            TIME_INFO(4) -- hour                      *
# *                            TIME_INFO(5) -- minute                    *
# *                            TIME_INFO(6) -- second                    *
# *                            TIME_INFO(7) -- nanosecond                *
# *                                                                      *
# *   Copyright (c) 1975-2025 United States Government as represented by *
# *   the Administrator of the National Aeronautics and Space            *
# *   Administration. All Rights Reserved.                               *
# *   License: NASA Open Source Software Agreement (NOSA).               *
# *                                                                      *
# * ###  11-AUG-2015  get_hr_utc   v1.1 (d)  L. Petrov 11-AUG-2015  ###  *
# *                                                                      *
# ************************************************************************
*/

{
  struct tm    *now_tm;
#ifndef DARWIN
//
// --- Linux
//
  clockid_t clock_to_use = CLOCK_REALTIME ;
  struct timespec        now_wall_timer;
 
  clock_gettime ( clock_to_use, &now_wall_timer);
  now_tm = gmtime ( (time_t *) &now_wall_timer.tv_sec ) ;

#else
//
// --- Darwin
//
  static clock_serv_t    cclock;
  mach_timespec_t        now_wall_timer;
  time_t      *now;

  host_get_clock_service ( mach_host_self(), CALENDAR_CLOCK, &cclock );
  clock_get_time ( cclock, &now_wall_timer );
  mach_port_deallocate ( mach_task_self(), cclock );

  now = (time_t *) time (NULL) ;
  now_tm = gmtime ( (time_t *) &now ) ;

#endif

  time_info[0] = now_tm->tm_year  + 1900 ;
  time_info[1] = now_tm->tm_mon + 1 ;
  time_info[2] = now_tm->tm_mday  ;
  time_info[3] = now_tm->tm_hour  ;
  time_info[4] = now_tm->tm_min  ;
  time_info[5] = now_tm->tm_sec  ;
  time_info[6] = now_wall_timer.tv_nsec  ;
  //   printf ( "time_info(1) = %d %d %d %d %d %d %d \n ", time_info[0], time_info[1], time_info[2], time_info[3],  time_info[4],  time_info[5],  time_info[6] ) ; /* %%%%%%%%%%% */
}

void get_hr_time ( uint32_t  * time_info )
/*
# ************************************************************************
# *                                                                      *
# *   Routine get_hr_time returns system time in a broken format         *
# *   with precision to one nanosecond. (Though the accuracy of clock    *
# *   is more likely be at a level of one millisecond).                  *
# *                                                                      *
# *   Usage:                                                             *
# *                                                                      *
# *   CALL GET_HR_TIME ( TIME_INFO )                                     *
# *                                                                      *
# *                                                                      *
# * _________________________ Input parameters: ________________________ *
# *                                                                      *
# *    TIME_INFO ( INTEGER*4 ) -- Array of date. Dimension: 7.           *
# *                            TIME_INFO(1) -- year                      *
# *                            TIME_INFO(2) -- month                     *
# *                            TIME_INFO(3) -- day                       *
# *                            TIME_INFO(4) -- hour                      *
# *                            TIME_INFO(5) -- minute                    *
# *                            TIME_INFO(6) -- second                    *
# *                            TIME_INFO(7) -- nanosecond                *
# *                                                                      *
# *   Copyright (c) 1975-2025 United States Government as represented by *
# *   the Administrator of the National Aeronautics and Space            *
# *   Administration. All Rights Reserved.                               *
# *   License: NASA Open Source Software Agreement (NOSA).               *
# *                                                                      *
# * ###  31-AUG-2014  get_hr_time  v1.1 (d)  L. Petrov 31-AUG-2014  ###  *
# *                                                                      *
# ************************************************************************
*/

{
  struct tm    *now_tm;
#ifndef DARWIN
//
// --- Linux
//
  clockid_t clock_to_use = CLOCK_REALTIME ;
  struct timespec        now_wall_timer;
 
  clock_gettime ( clock_to_use, &now_wall_timer);
  now_tm = localtime ( (time_t *) &now_wall_timer.tv_sec ) ;

#else
//
// --- Darwin
//
  static clock_serv_t    cclock;
  mach_timespec_t        now_wall_timer;
  time_t      *now;

  host_get_clock_service ( mach_host_self(), CALENDAR_CLOCK, &cclock );
  clock_get_time ( cclock, &now_wall_timer );
  mach_port_deallocate ( mach_task_self(), cclock );

  now = (time_t *) time (NULL) ;
  now_tm = localtime ( (time_t *) &now ) ;

#endif

  time_info[0] = now_tm->tm_year  + 1900 ;
  time_info[1] = now_tm->tm_mon + 1 ;
  time_info[2] = now_tm->tm_mday  ;
  time_info[3] = now_tm->tm_hour  ;
  time_info[4] = now_tm->tm_min  ;
  time_info[5] = now_tm->tm_sec  ;
  time_info[6] = now_wall_timer.tv_nsec  ;
  //   printf ( "time_info(1) = %d %d %d %d %d %d %d \n ", time_info[0], time_info[1], time_info[2], time_info[3],  time_info[4],  time_info[5],  time_info[6] ) ; /* %%%%%%%%%%% */
}

double get_utc ( )
/*
# ************************************************************************
# *                                                                      *
# *   Routine get_utc returns current UTC time tag with resepect to      *
# *   2000.01.01_00:00:00.0 UTC with precision to one nanosecond.        *
# *   (Though the accuracy of clock is more likely be at a level of      *
# *   one millisecond).                                                  *
# *                                                                      *
# *   Usage:                                                             *
# *                                                                      *
# *   UTC = GET_UTC ( )                                                  *
# *                                                                      *
# *   GET_UTC ( REAL*8     )                                             *
# *                                                                      *
# *   Copyright (c) 1975-2025 United States Government as represented by *
# *   the Administrator of the National Aeronautics and Space            *
# *   Administration. All Rights Reserved.                               *
# *   License: NASA Open Source Software Agreement (NOSA).               *
# *                                                                      *
# * ###  11-MAY-2016     get_utc   v1.0 (d)  L. Petrov 11-MAY-2016  ###  *
# *                                                                      *
# ************************************************************************
*/

{
  struct tm    *now_tm;
#ifndef DARWIN
//
// --- Linux
//
  clockid_t clock_to_use = CLOCK_REALTIME ;
  struct timespec   timer;
 
  clock_gettime ( clock_to_use, &timer);
  return ( (timer.tv_sec - UNIX__J2000_UTC) + timer.tv_nsec/1.0E9 ) ;

#else
//
// --- Darwin
//

  clock_serv_t cclock;
  mach_timespec_t mts;
  host_get_clock_service(mach_host_self(), CALENDAR_CLOCK, &cclock);
  clock_get_time(cclock, &mts);
  mach_port_deallocate(mach_task_self(), cclock);

  return ( (mts.tv_sec - UNIX__J2000_UTC) + mts.tv_nsec/1.0E9 );

#endif

}
