      PROGRAM    OPA_EXAMPLE_FORTRAN
! ************************************************************************
! *                                                                      *
! *   Program OPA_EXAMPLE_FORTRAN
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ## 10-JAN-2026 OPA_EXAMPLE_FORTRAN v1.0 (d) L. Petrov 10-JAN-2026 ## *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'astro_constants.i'
      INCLUDE   'spd.i'
      INCLUDE   'spd_local.i'
      INTEGER*4    M_STA, M_FRQ
      PARAMETER  ( M_STA = 8  )
      PARAMETER  ( M_FRQ = 16  )
      TYPE       ( SPD_DEL__TYPE ) :: SPD_DEL(M_STA)
      CHARACTER  SPD_DIR*128, C_STA(M_STA)*8, MODE_STR*8
      INTEGER*4  L_DIR, L_STA, MJD_BEG, MJD_OBS, MJD_END, IVRB, N_FRQ, &
     &           J1, J2, IUER
      REAL*8     TAI_BEG, TAI_OBS, TAI_END, ELEV, AZIM, FRQ_ARR(M_FRQ), &
     &           OPA_ARR(M_FRQ), TATM_ARR(M_FRQ)
      REAL*8     SPD_DELAY, SPD_RATE, SPD_DELAY_DER_ZEN, SPD_RATE_DER_ZEN
!
! --- Define directories with slant path delays in binary format
!
      SPD_DIR = SPD__ROOT//'/share/spd_geosit/asc'
!
! --- Define the station list 
!
      L_STA = 2
      C_STA(1) = 'GGAO12M '
      C_STA(2) = 'SVETLOE '
!
      N_FRQ = 2
      FRQ_ARR(1) = 2.24D10
      FRQ_ARR(2) = 2.25D10
!
! --- Derfine the time range for interpolation of slant path delay
!
      MJD_BEG = 61048 ; TAI_BEG = 39600.0 ! Corresponds to 2026.01.08_11:00:00.0
      MJD_END = 61048 ; TAI_END = 48137.0 ! Corresponds to 2026.01.08_13:22:17.0
!
! --- Initialize SPD object 
!
      DO 410 J1=1,L_STA
         IUER = -1
         CALL SPD_INIT ( SPD_DEL(J1), IUER )
         IF ( IUER .NE. 0 ) THEN
              IUER = -1
              CALL ERR_LOG ( 4701, IUER, 'OPA_EXAMPLE_FORTRAN', 'Failure '// &
     &            'in initialization SPD data structure' )
              CALL EXIT ( 1 ) 
         END IF
 410  CONTINUE 
!
      MODE_STR = 'azel'
      IVRB     = 1
!
      IUER = -1
      CALL SPD_RES_INTRP ( SPD_DIR, L_STA, C_STA, MJD_BEG, TAI_BEG, &
     &                     MJD_END, TAI_END, SPD_DEL, MODE_STR, IVRB, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -1
           CALL ERR_LOG ( 4702, IUER, 'OPA_EXAMPLE_FORTRAN', 'Error in '// &
     &         'interpolation of atmospheric opacity and brightness '// &
     &         'temperature' )
           CALL EXIT ( 1 )
      END IF
!
      MJD_OBS   = 61048
      TAI_OBS   = 43260 ! 12:01:00
      ELEV = 0.265D0
      AZIM = 2.424D0
!
      IUER = -1
      CALL GET_OPA_TATM_SPECTRUM ( 'opa', SPD_DEL(2), MJD_OBS, TAI_OBS, &
     &                              ELEV, AZIM, N_FRQ, FRQ_ARR, OPA_ARR, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -1
           CALL ERR_LOG ( 4703, IUER, 'OPA_EXAMPLE_FORTRAN', 'Error in '// &
     &         'getting atmospheric opacity for station '//C_STA(2) )
           CALL EXIT ( 1 )
      END IF
!
      IUER = -1
      CALL GET_OPA_TATM_SPECTRUM ( 'tatm', SPD_DEL(2), MJD_OBS, TAI_OBS, &
     &                              ELEV, AZIM, N_FRQ, FRQ_ARR, TATM_ARR, IUER )
      IF ( IUER .NE. 0 ) THEN
           IUER = -1
           CALL ERR_LOG ( 4703, IUER, 'OPA_EXAMPLE_FORTRAN', 'Error in '// &
     &         'getting atmospheric brightness temperatyre for station '//C_STA(2) )
           CALL EXIT ( 1 )
      END IF
      WRITE  ( 6, '(A)' ) 'opa_example_fortran'
      WRITE  ( 6, '(A)' ) '==================='
      WRITE  ( 6, '(A)' ) ' '
      WRITE  ( 6, '(A)' ) 'Opacities and Tatm are taken from '//TRIM(SPD_DIR)
      WRITE  ( 6, '(A)' ) ' '
      WRITE  ( 6, 110 ) C_STA(1), ELEV, AZIM, FRQ_ARR(1), FRQ_ARR(2)
 110  FORMAT ( 'Station ', A, ' Elev: ', F9.5, ' Azim: ', F9.5, ' rad '/ &
     &         'Frequencies ', 1PD12.5, 1X, 1PD12.5, ' Hz' )
      WRITE  ( 6, 120 ) OPA_ARR(1:2), TATM_ARR(1:2)
 120  FORMAT ( 'Opacity:    ', F8.5, 1X, F8.5/ &
     &         'Tatm:      ', F6.1, 3X, F6.1, '   K' )
!
! --- Free SPD objects
!
      DO 420 J2=1,L_STA
         IUER = -1
         CALL SPD_DEL_QUIT ( SPD_DEL(J2), IUER )
         IF ( IUER .NE. 0 ) THEN
              IUER = -1
              CALL ERR_LOG ( 4704, IUER, 'OPA_EXAMPLE_FORTRAN', 'Failure '// &
     &            'in freeing SPD data structure' )
              CALL EXIT ( 1 ) 
         END IF
 420  CONTINUE 
!
      END  PROGRAM   OPA_EXAMPLE_FORTRAN  !#!#
