% ************************************************************************
% *                                                                      *
% *   Program spd_cli_example_m demonstrages using MATLAV interface to   *
% *   SPD_CLIENT.
% *                                                                      *
% * ### 29-APR-2015 spd_cli_example_m v1.0 (c) L. Petrov 29-APR-2015 ### *
% *                                                                      *
% ************************************************************************
clear all; close all;

spd_share  = '/opt64/spd/share'  ; 
spd_script = '/opt64/spd/script' ;

addpath ( fullfile(spd_script) ) ;

spd_cli_conf = strcat(spd_share,'/spd_cli_example.cnf') ;
spd_cli_dat  = strcat(spd_share,'/spd_cli_example.dat') ;

np = 2 ;
mjd_beg = 57040 ; % 2015.01.18
tai_beg = 21600 ; %  6 hours
mjd_end = 57040 ; % 2015.01.18
tai_end = 82800 ; % 23 hours
ivrb    = 2 ;

fprintf ( 'Started spd_init... \n' )
%
% --- Intialuization: parse SPD_CLIENT contgrol file, allocate memory for 
% --- spd_2p, check, whether the server is running
%
[spd_2p, cli_ptr, iuer] = spd_cli_init ( np, spd_cli_conf, mjd_beg, tai_beg, ...
                                         mjd_end, tai_end, ivrb ) ;
%
% --- set coordinates of the emitter and the receicer and the time tag
%
spd_2p(1).mjd= 57040 ;
spd_2p(1).tai= 50400.0 ;
spd_2p(1).emi_1=  2528531.8502 ;
spd_2p(1).emi_2= -5071450.3089 ;
spd_2p(1).emi_3= -2930240.7676 ;
spd_2p(1).rec_1=  2526217.0353 ;
spd_2p(1).rec_2= -5066807.5084 ;
spd_2p(1).rec_3= -2927540.1350 ;
%
spd_2p(2).mjd= 57040   ;
spd_2p(2).tai= 50400.1 ;
spd_2p(2).emi_1=  2550636.0866 ;
spd_2p(2).emi_2= -5060369.2658 ;
spd_2p(2).emi_3= -2930240.7676 ;
spd_2p(2).rec_1=  2548301.2817 ;
spd_2p(2).rec_2= -5055737.0978 ;
spd_2p(2).rec_3= -2927540.4194 ;

%
% --- Send a request to the server to compute path delay
%
fprintf ( 'Started spd_get_delay... \n' )
[spd_2p, iuer] = spd_cli_get_2pd ( np, spd_2p, cli_ptr, ivrb ) ;
if iuer ~= 0
   fprintf ( 'Error in spd_get_delay' ) ;
   exit ( 1 ) ;
end
fprintf ( 'Finished spd_get_delay... \n' )
%
% --- Print path delay
%
for ind=1:2
    fprintf ( 'ind = %i  del= %f %f ; del_rder= %f %f del_eder= %f %f\n', ...
               ind, spd_2p(ind).del_1st,      spd_2p(ind).del_2nd,        ...
                    spd_2p(ind).del_rder_1st, spd_2p(ind).del_rder_2nd,   ...
                    spd_2p(ind).del_eder_1st, spd_2p(ind).del_eder_2nd    ...
            );
end

spd_cli_quit ( spd_2p, cli_ptr ) ;
fprintf ( 'end of example\n' ) ;
return;
