!
! --- This file was generated automatically by program make_tid v 1.0
! --- written by Leonid Petrov (Leonid.Petrov@lpetrov.net)
! --- It contains phases, frequencies, accelerations amplitudes and 
! --- orders of the tidal waves of the 2-nd and 3-rd degree 
! --- with (renormalized) amplitude  cutoff  0.00100 m
! --- Constituents with differences in frequences less than  1.000D-11 rad/sec 
! --- are merged
! --- Harmonic expansion HW95 was used.
! --- (T. Hartmann and H-G. Wenzel "The HW95 tidal potential catalogue",
! ---  Geophysical Research Letters", Vol. 22(24), p. 3553-3556, 1995),
! ---  Amplitudes were renormalized!
!
      INTEGER*4   NTID, NT$1
      PARAMETER ( NTID = 313 )
      REAL*8      TID_PHAS(NTID), TID_FREQ(NTID), TID_ACCL(NTID), TID_AMPL(NTID)
      INTEGER*4   L(NTID), M(NTID)
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=1,10)    &
     & / &
     & 3.141593D0, 0.000000000000D+00,  0.00D+00, 3.082489,  2, 0, & !     1
     & 4.100746D0, 1.069696236521D-08, -7.28D-24, 0.273654,  2, 0, & !     2
     & 5.059900D0, 2.139392473041D-08, -1.46D-23, 0.002671,  2, 0, & !     3
     & 3.025585D0, 2.250414646350D-08, -3.62D-23, 0.002002,  3, 0, & !     4
     & 3.098467D0, 1.990968752920D-07, -5.39D-25, 0.048884,  2, 0, & !     5
     & 3.550066D0, 1.991158946075D-07,  2.66D-24, 0.002537,  2, 0, & !     6
     & 3.738956D0, 3.532044769725D-07,  7.45D-23, 0.003058,  2, 0, & !     7
     & 3.055342D0, 3.981937505839D-07, -1.08D-24, 0.001177,  2, 0, & !     8
     & 0.365348D0, 3.982127698995D-07,  2.13D-24, 0.303633,  2, 0, & !     9
     & 1.324501D0, 4.089097322647D-07, -5.15D-24, 0.007563,  2, 0  & !    10
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=11,20)   &
     & / &
     & 5.425248D0, 4.196066946299D-07, -1.24D-23, 0.001667,  2, 0, & !    11
     & 0.322223D0, 5.973096451915D-07,  1.59D-24, 0.017750,  2, 0, & !    12
     & 4.942910D0, 2.086901700477D-06, -4.29D-23, 0.002819,  2, 0, & !    13
     & 3.940631D0, 2.275301613404D-06, -3.62D-23, 0.004734,  2, 0, & !    14
     & 4.899785D0, 2.285998575769D-06, -4.34D-23, 0.065922,  2, 0, & !    15
     & 5.858938D0, 2.296695538134D-06, -5.07D-23, 0.004280,  2, 0, & !    16
     & 5.540274D0, 2.440106177449D-06,  3.16D-23, 0.002118,  2, 0, & !    17
     & 5.198467D0, 2.462600814255D-06, -6.20D-24, 0.001912,  2, 0, & !    18
     & 4.537995D0, 2.628506090376D-06,  3.83D-23, 0.022630,  2, 0, & !    19
     & 5.497148D0, 2.639203052741D-06,  3.10D-23, 0.344743,  2, 0  & !    20
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=21,30)   &
     & / &
     & 0.173117D0, 2.649900015107D-06,  2.38D-23, 0.022372,  2, 0, & !    21
     & 4.421987D0, 2.651010236840D-06,  2.14D-24, 0.001902,  3, 0, & !    22
     & 5.381141D0, 2.661707199205D-06, -5.14D-24, 0.036768,  3, 0, & !    23
     & 3.198701D0, 2.672404161570D-06, -1.24D-23, 0.005803,  3, 0, & !    24
     & 5.265133D0, 2.684211345668D-06, -4.13D-23, 0.018449,  2, 0, & !    25
     & 3.082694D0, 2.694908308034D-06, -4.86D-23, 0.007505,  2, 0, & !    26
     & 0.900254D0, 2.705605270399D-06, -5.59D-23, 0.002016,  2, 0, & !    27
     & 2.312431D0, 2.838299928033D-06,  3.05D-23, 0.001767,  2, 0, & !    28
     & 5.862496D0, 3.037415822641D-06,  3.32D-23, 0.004813,  2, 0, & !    29
     & 3.680057D0, 3.048112785006D-06,  2.59D-23, 0.002396,  2, 0  & !    30
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=31,40)   &
     & / &
     & 0.374792D0, 4.571997151538D-06, -8.69D-23, 0.001075,  2, 0, & !    31
     & 1.015280D0, 4.726104753218D-06, -1.19D-23, 0.003765,  2, 0, & !    32
     & 3.154594D0, 4.914504666145D-06, -5.13D-24, 0.004079,  2, 0, & !    33
     & 0.972155D0, 4.925201628510D-06, -1.24D-23, 0.057189,  2, 0, & !    34
     & 1.931309D0, 4.935898590875D-06, -1.97D-23, 0.003665,  2, 0, & !    35
     & 0.856147D0, 4.947705774974D-06, -4.86D-23, 0.001171,  3, 0, & !    36
     & 4.522221D0, 5.124317523118D-06, -9.74D-24, 0.001975,  2, 0, & !    37
     & 0.610365D0, 5.267709143118D-06,  6.94D-23, 0.001504,  2, 0, & !    38
     & 1.569519D0, 5.278406105483D-06,  6.21D-23, 0.028254,  2, 0, & !    39
     & 2.528672D0, 5.289103067848D-06,  5.48D-23, 0.001833,  2, 0  & !    40
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=41,50)   &
     & / &
     & 1.453511D0, 5.300910251946D-06,  2.59D-23, 0.006010,  3, 0, & !    41
     & 4.479096D0, 5.323414398410D-06, -1.03D-23, 0.652632,  2, 0, & !    42
     & 2.296657D0, 5.334111360775D-06, -1.76D-23, 0.270591,  2, 0, & !    43
     & 0.114218D0, 5.344808323140D-06, -2.48D-23, 0.025307,  2, 0, & !    44
     & 1.294378D0, 5.522511273702D-06, -1.08D-23, 0.002244,  2, 0, & !    45
     & 1.934867D0, 5.676618875382D-06,  6.42D-23, 0.001961,  2, 0, & !    46
     & 2.730347D0, 7.211200204279D-06, -5.58D-23, 0.001758,  2, 0, & !    47
     & 6.280413D0, 7.410316098887D-06, -5.32D-23, 0.001095,  2, 0, & !    48
     & 3.327711D0, 7.564404681252D-06,  1.86D-23, 0.009064,  2, 0, & !    49
     & 3.211703D0, 7.586908827715D-06, -1.75D-23, 0.001008,  3, 0 & !    50
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=51,60)   &
     & / &
     & 6.237288D0, 7.609412974179D-06, -5.37D-23, 0.023729,  2, 0, & !    51
     & 4.054849D0, 7.620109936544D-06, -6.10D-23, 0.009836,  2, 0, & !    52
     & 0.594592D0, 7.763520575859D-06,  2.13D-23, 0.001166,  2, 0, & !    53
     & 3.925075D0, 7.917609158224D-06,  9.31D-23, 0.002270,  2, 0, & !    54
     & 0.551466D0, 7.962617451151D-06,  2.08D-23, 0.124958,  2, 0, & !    55
     & 4.652212D0, 7.973314413516D-06,  1.35D-23, 0.051790,  2, 0, & !    56
     & 2.469773D0, 7.984011375882D-06,  6.21D-24, 0.004851,  2, 0, & !    57
     & 0.435459D0, 7.985121597615D-06, -1.54D-23, 0.002993,  3, 0, & !    58
     & 4.536205D0, 7.995818559980D-06, -2.27D-23, 0.001861,  3, 0, & !    59
     & 3.649934D0, 8.161714326443D-06,  2.02D-23, 0.001051,  2, 0  & !    60
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=61,70)   &
     & / &
     & 2.352784D0, 1.004951915163D-05, -2.21D-23, 0.001346,  2, 0, & !    61
     & 5.683267D0, 1.020360773399D-05,  4.97D-23, 0.001073,  2, 0, & !    62
     & 2.309658D0, 1.024861602692D-05, -2.27D-23, 0.019958,  2, 0, & !    63
     & 0.127219D0, 1.025931298929D-05, -3.00D-23, 0.008270,  2, 0, & !    64
     & 2.907022D0, 1.060182050389D-05,  5.18D-23, 0.016531,  2, 0, & !    65
     & 0.724583D0, 1.061251746626D-05,  4.45D-23, 0.006854,  2, 0, & !    66
     & 4.665214D0, 1.288781907966D-05,  8.35D-24, 0.004822,  2, 0, & !    67
     & 2.482775D0, 1.289851604203D-05,  1.08D-24, 0.001998,  2, 0, & !    68
     & 5.262578D0, 1.324102355663D-05,  8.28D-23, 0.001860,  2, 0, & !    69
     & 2.586682D0, 5.739413641898D-05, -3.83D-23, 0.003142,  2, 1  & !    70
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=71,80)   &
     & / &
     & 3.184046D0, 5.774734089595D-05,  3.62D-23, 0.001950,  2, 1, & !    71
     & 0.244128D0, 5.966943803238D-05, -7.45D-23, 0.001381,  2, 1, & !    72
     & 4.344874D0, 5.968013499475D-05, -8.18D-23, 0.007322,  2, 1, & !    73
     & 0.841492D0, 6.002264250935D-05, -1.58D-26, 0.003578,  2, 1, & !    74
     & 4.942238D0, 6.003333947172D-05, -7.29D-24, 0.018967,  2, 1, & !    75
     & 4.899113D0, 6.023243634701D-05, -7.83D-24, 0.001438,  2, 1, & !    76
     & 5.539601D0, 6.038654394869D-05,  6.72D-23, 0.003666,  2, 1, & !    77
     & 2.715692D0, 6.228613693866D-05, -7.28D-24, 0.001357,  3, 1, & !    78
     & 0.533252D0, 6.229683390102D-05, -1.46D-23, 0.003429,  3, 1, & !    79
     & 2.599684D0, 6.230864108512D-05, -4.35D-23, 0.012277,  2, 1  & !    80
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=81,90)   &
     & / &
     & 0.417245D0, 6.231933804749D-05, -5.07D-23, 0.065101,  2, 1, & !    81
     & 4.199326D0, 6.247344564917D-05,  2.43D-23, 0.001107,  2, 1, & !    82
     & 0.374119D0, 6.251843492278D-05, -5.13D-23, 0.001006,  2, 1, & !    83
     & 3.197047D0, 6.266184556210D-05,  3.10D-23, 0.014809,  2, 1, & !    84
     & 1.014608D0, 6.267254252446D-05,  2.37D-23, 0.078504,  2, 1, & !    85
     & 0.971483D0, 6.287163939975D-05,  2.32D-23, 0.005301,  2, 1, & !    86
     & 1.611972D0, 6.302574700143D-05,  9.82D-23, 0.002397,  2, 1, & !    87
     & 5.317029D0, 6.460533662326D-05, -9.42D-23, 0.001583,  2, 1, & !    88
     & 5.957518D0, 6.475944422494D-05, -1.92D-23, 0.004137,  2, 1, & !    89
     & 1.086509D0, 6.489213888257D-05,  6.72D-23, 0.001884,  2, 1  & !    90
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=91,100)   &
     & / &
     & 5.071247D0, 6.492533999140D-05,  2.38D-23, 0.004947,  3, 1, & !    91
     & 2.888808D0, 6.493603695377D-05,  1.65D-23, 0.012501,  3, 1, & !    92
     & 3.996086D0, 6.493714717550D-05, -5.15D-24, 0.002852,  2, 1, & !    93
     & 4.955240D0, 6.494784413786D-05, -1.24D-23, 0.092777,  2, 1, & !    94
     & 2.772800D0, 6.495854110023D-05, -1.97D-23, 0.491954,  2, 1, & !    95
     & 2.540785D0, 6.500354939316D-05, -9.21D-23, 0.001332,  2, 1, & !    96
     & 3.071482D0, 6.513514333872D-05,  1.75D-23, 0.002652,  2, 1, & !    97
     & 2.729675D0, 6.515763797552D-05, -2.02D-23, 0.004591,  2, 1, & !    98
     & 5.552603D0, 6.530104861484D-05,  6.21D-23, 0.017613,  2, 1, & !    99
     & 3.370164D0, 6.531174557720D-05,  5.48D-23, 0.093377,  2, 1  & !   100
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=101,110)   &
     & / &
     & 0.112564D0, 6.533424972367D-05,  1.86D-23, 0.001071,  3, 1, & !   101
     & 3.138148D0, 6.535675387013D-05, -1.76D-23, 0.005308,  2, 1, & !   102
     & 4.097302D0, 6.536745083249D-05, -2.48D-23, 0.001661,  2, 1, & !   103
     & 3.327039D0, 6.551084245249D-05,  5.42D-23, 0.004313,  2, 1, & !   104
     & 3.735512D0, 6.570995834710D-05,  5.69D-23, 0.001029,  2, 1, & !   105
     & 2.844701D0, 6.717813745834D-05,  2.38D-23, 0.001116,  2, 1, & !   106
     & 3.571839D0, 6.723384271363D-05, -5.59D-23, 0.001352,  2, 1, & !   107
     & 1.389400D0, 6.724453967600D-05, -6.31D-23, 0.007719,  2, 1, & !   108
     & 4.212328D0, 6.738795031531D-05,  1.92D-23, 0.001055,  2, 1, & !   109
     & 2.029889D0, 6.739864727768D-05,  1.19D-23, 0.008831,  2, 1  & !   110
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=111,120)   &
     & / &
     & 0.068457D0, 6.757635022824D-05,  2.59D-23, 0.014850,  2, 1, & !   111
     & 1.027610D0, 6.758704719061D-05,  1.86D-23, 0.484725,  2, 1, & !   112
     & 5.128356D0, 6.759774415297D-05,  1.13D-23, 2.569423,  2, 1, & !   113
     & 1.870756D0, 6.762024829943D-05, -2.48D-23, 0.006392,  3, 1, & !   114
     & 4.896340D0, 6.764275244590D-05, -6.10D-23, 0.016553,  2, 1, & !   115
     & 2.713901D0, 6.765344940826D-05, -6.83D-23, 0.002697,  2, 1, & !   116
     & 5.085231D0, 6.779684102826D-05,  1.08D-23, 0.007777,  2, 1, & !   117
     & 2.584127D0, 6.795094862994D-05,  8.58D-23, 0.001465,  2, 1, & !   118
     & 2.468119D0, 6.797345277641D-05,  4.96D-23, 0.001245,  3, 1, & !   119
     & 5.493704D0, 6.799595692287D-05,  1.35D-23, 0.033491,  2, 1  & !   120
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=121,130)   &
     & / &
     & 0.169672D0, 6.800665388524D-05,  6.19D-24, 0.007300,  2, 1, & !   121
     & 5.450579D0, 6.819505379816D-05,  1.29D-23, 0.002209,  2, 1, & !   122
     & 5.927395D0, 6.987304576637D-05, -2.48D-23, 0.004292,  2, 1, & !   123
     & 3.744956D0, 6.988374272874D-05, -3.21D-23, 0.018948,  2, 1, & !   124
     & 4.153429D0, 7.008285862335D-05, -2.94D-23, 0.001035,  2, 1, & !   125
     & 5.565605D0, 7.021555328098D-05,  5.69D-23, 0.001181,  2, 1, & !   126
     & 0.241573D0, 7.022625024335D-05,  4.97D-23, 0.013443,  2, 1, & !   127
     & 4.342319D0, 7.023694720571D-05,  4.24D-23, 0.072640,  2, 1, & !   128
     & 3.267158D0, 7.024875438981D-05,  1.35D-23, 0.005784,  3, 1, & !   129
     & 4.226311D0, 7.025945135218D-05,  6.20D-24, 0.039110,  3, 1  & !   130
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=131,140)   &
     & / &
     & 5.185465D0, 7.027014831454D-05, -1.07D-24, 0.005059,  3, 1, & !   131
     & 0.009557D0, 7.027125853627D-05, -2.27D-23, 0.005852,  2, 1, & !   132
     & 0.968711D0, 7.028195549864D-05, -3.00D-23, 0.201970,  2, 1, & !   133
     & 5.069457D0, 7.029265246100D-05, -3.73D-23, 0.040534,  2, 1, & !   134
     & 6.028610D0, 7.030334942337D-05, -4.45D-23, 0.001133,  2, 1, & !   135
     & 1.267393D0, 7.045855773713D-05,  7.27D-24, 0.001121,  2, 1, & !   136
     & 0.925586D0, 7.048105237393D-05, -3.05D-23, 0.001241,  2, 1, & !   137
     & 0.606921D0, 7.062446301325D-05,  5.18D-23, 0.001119,  2, 1, & !   138
     & 1.566075D0, 7.063515997561D-05,  4.45D-23, 0.038648,  2, 1, & !   139
     & 5.666821D0, 7.064585693798D-05,  3.72D-23, 0.008480,  2, 1  & !   140
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=141,150)   &
     & / &
     & 1.522949D0, 7.083425685090D-05,  4.40D-23, 0.001651,  2, 1, & !   141
     & 3.045169D0, 7.212475203090D-05,  1.44D-26, 0.002833,  2, 1, & !   142
     & 3.002044D0, 7.232384890619D-05, -5.24D-25, 0.069873,  2, 1, & !   143
     & 1.999765D0, 7.251224881912D-05,  6.21D-24, 0.013548,  2, 1, & !   144
     & 2.958919D0, 7.252294578148D-05, -1.06D-24, 1.195341,  2, 1, & !   145
     & 2.726903D0, 7.256795407441D-05, -7.34D-23, 0.001792,  2, 1, & !   146
     & 6.057386D0, 7.272204265677D-05, -1.60D-24, 0.009998,  2, 1, & !   147
     & 3.367392D0, 7.272206167609D-05,  1.60D-24, 0.028645,  2, 1, & !   148
     & 0.298682D0, 7.289865440492D-05,  3.72D-23, 0.002130,  3, 1, & !   149
     & 2.365113D0, 7.291046158901D-05,  8.34D-24, 0.071534,  2, 1  & !   150
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=151,160)   &
     & / &
     & 3.324267D0, 7.292115855138D-05,  1.06D-24, 3.612086,  2, 1, & !   151
     & 1.141827D0, 7.293185551375D-05, -6.21D-24, 0.490219,  2, 1, & !   152
     & 2.100981D0, 7.294255247611D-05, -1.35D-23, 0.010532,  2, 1, & !   153
     & 3.281141D0, 7.312025542667D-05,  5.24D-25, 0.028656,  2, 1, & !   154
     & 3.921630D0, 7.327436302835D-05,  7.55D-23, 0.001792,  2, 1, & !   155
     & 0.548022D0, 7.331937132128D-05,  3.19D-24, 0.051435,  2, 1, & !   156
     & 1.507176D0, 7.333006828364D-05, -4.09D-24, 0.001990,  2, 1, & !   157
     & 0.504897D0, 7.351846819657D-05,  2.65D-24, 0.003002,  2, 1, & !   158
     & 5.125584D0, 7.500806025186D-05, -4.18D-23, 0.001651,  2, 1, & !   159
     & 4.355321D0, 7.515145187186D-05,  3.73D-23, 0.001148,  2, 1  & !   160
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=161,170)   &
     & / &
     & 4.123305D0, 7.519646016478D-05, -3.51D-23, 0.001238,  2, 1, & !   161
     & 5.082459D0, 7.520715712715D-05, -4.24D-23, 0.038636,  2, 1, & !   162
     & 2.900020D0, 7.521785408951D-05, -4.97D-23, 0.007664,  2, 1, & !   163
     & 5.722948D0, 7.536126472883D-05,  3.26D-23, 0.001241,  2, 1, & !   164
     & 5.381141D0, 7.538375936564D-05, -5.14D-24, 0.001121,  2, 1, & !   165
     & 4.720669D0, 7.554966464176D-05,  3.94D-23, 0.005913,  2, 1, & !   166
     & 5.679822D0, 7.556036160412D-05,  3.21D-23, 0.202043,  2, 1, & !   167
     & 3.497383D0, 7.557105856649D-05,  2.48D-23, 0.040048,  2, 1, & !   168
     & 5.563815D0, 7.558286575059D-05, -4.08D-24, 0.014274,  3, 1, & !   169
     & 3.381375D0, 7.559356271295D-05, -1.14D-23, 0.005784,  3, 1  & !   170
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=171,180)   &
     & / &
     & 5.447807D0, 7.560536989705D-05, -4.03D-23, 0.003124,  2, 1, & !   171
     & 3.265368D0, 7.561606685941D-05, -4.75D-23, 0.001963,  2, 1, & !   172
     & 1.082928D0, 7.562676382178D-05, -5.48D-23, 0.001181,  2, 1, & !   173
     & 2.495105D0, 7.575945847941D-05,  3.16D-23, 0.001035,  2, 1, & !   174
     & 1.197954D0, 7.764726330460D-05, -1.08D-23, 0.002206,  2, 1, & !   175
     & 3.337268D0, 7.783566321753D-05, -4.07D-24, 0.001069,  2, 1, & !   176
     & 1.154829D0, 7.784636017989D-05, -1.13D-23, 0.033509,  2, 1, & !   177
     & 5.255575D0, 7.785705714226D-05, -1.86D-23, 0.006562,  2, 1, & !   178
     & 1.752193D0, 7.819956465686D-05,  6.31D-23, 0.016562,  2, 1, & !   179
     & 5.852939D0, 7.821026161923D-05,  5.59D-23, 0.003280,  2, 1  & !   180
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=181,190)   &
     & / &
     & 1.636185D0, 7.822206880333D-05,  2.70D-23, 0.002333,  3, 1, & !   181
     & 4.661770D0, 7.824457294979D-05, -9.22D-24, 0.110515,  2, 1, & !   182
     & 2.479331D0, 7.825526991216D-05, -1.65D-23, 0.070813,  2, 1, & !   183
     & 0.296892D0, 7.826596687452D-05, -2.38D-23, 0.014836,  2, 1, & !   184
     & 2.913021D0, 8.013235875566D-05, -5.48D-23, 0.001019,  2, 1, & !   185
     & 3.510385D0, 8.048556323263D-05,  1.97D-23, 0.005306,  2, 1, & !   186
     & 1.327946D0, 8.049626019500D-05,  1.24D-23, 0.001037,  2, 1, & !   187
     & 0.136777D0, 8.053057152556D-05, -5.27D-23, 0.004020,  2, 1, & !   188
     & 4.237523D0, 8.054126848792D-05, -5.99D-23, 0.002574,  2, 1, & !   189
     & 4.107749D0, 8.083876770960D-05,  9.42D-23, 0.001330,  2, 1  & !   190
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=191,200)   &
     & / &
     & 0.734140D0, 8.088377600253D-05,  2.18D-23, 0.021164,  2, 1, & !   191
     & 4.834886D0, 8.089447296490D-05,  1.45D-23, 0.013551,  2, 1, & !   192
     & 2.652447D0, 8.090516992726D-05,  7.27D-24, 0.002844,  2, 1, & !   193
     & 2.492332D0, 8.316977457830D-05, -2.16D-23, 0.003379,  2, 1, & !   194
     & 0.309893D0, 8.318047154067D-05, -2.89D-23, 0.002165,  2, 1, & !   195
     & 3.089696D0, 8.352297905527D-05,  5.29D-23, 0.002800,  2, 1, & !   196
     & 0.907257D0, 8.353367601764D-05,  4.56D-23, 0.001794,  2, 1, & !   197
     & 3.555393D0, 1.276760919176D-04, -6.83D-23, 0.001033,  2, 2, & !   198
     & 4.152757D0, 1.280292963946D-04,  6.18D-24, 0.001249,  2, 2, & !   199
     & 5.313585D0, 1.299620904934D-04, -1.12D-22, 0.001809,  2, 2  & !   200
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=201,210)   &
     & / &
     & 5.910949D0, 1.303152949704D-04, -3.73D-23, 0.007567,  2, 2, & !   201
     & 0.225127D0, 1.306684994473D-04,  3.72D-23, 0.004693,  2, 2, & !   202
     & 1.501963D0, 1.325787893997D-04, -4.45D-23, 0.001810,  3, 2, & !   203
     & 1.385956D0, 1.326012935461D-04, -8.07D-23, 0.017658,  2, 2, & !   204
     & 2.099327D0, 1.329319938766D-04,  3.00D-23, 0.001820,  3, 2, & !   205
     & 1.024166D0, 1.329438010607D-04,  1.05D-24, 0.001709,  2, 2, & !   206
     & 1.983319D0, 1.329544980231D-04, -6.23D-24, 0.045770,  2, 2, & !   207
     & 1.940194D0, 1.331535948984D-04, -6.77D-24, 0.003466,  2, 2, & !   208
     & 2.580683D0, 1.333077025001D-04,  6.83D-23, 0.008832,  2, 2, & !   209
     & 0.643044D0, 1.350413997236D-04, -4.91D-23, 0.002118,  2, 2  & !   210
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=211,220)   &
     & / &
     & 6.039958D0, 1.352072954900D-04, -6.22D-24, 0.001777,  3, 2, & !   211
     & 3.857519D0, 1.352179924524D-04, -1.35D-23, 0.010462,  3, 2, & !   212
     & 2.782358D0, 1.352297996365D-04, -4.24D-23, 0.005855,  2, 2, & !   213
     & 3.741511D0, 1.352404965989D-04, -4.97D-23, 0.156950,  2, 2, & !   214
     & 1.240407D0, 1.353946042005D-04,  2.53D-23, 0.002667,  2, 2, & !   215
     & 4.040193D0, 1.354170988374D-04, -1.24D-23, 0.001677,  2, 2, & !   216
     & 3.698386D0, 1.354395934742D-04, -5.02D-23, 0.002427,  2, 2, & !   217
     & 4.454883D0, 1.355711969294D-04,  6.10D-23, 0.001955,  3, 2, & !   218
     & 3.379721D0, 1.355830041135D-04,  3.21D-23, 0.007064,  2, 2, & !   219
     & 4.338875D0, 1.355937010758D-04,  2.48D-23, 0.189426,  2, 2  & !   220
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=221,230)   &
     & / &
     & 4.295750D0, 1.357927979511D-04,  2.43D-23, 0.012775,  2, 2, & !   221
     & 4.936238D0, 1.359469055528D-04,  9.93D-23, 0.005777,  2, 2, & !   222
     & 3.813412D0, 1.374600929570D-04, -6.21D-24, 0.001003,  2, 2, & !   223
     & 2.358111D0, 1.375264951746D-04, -9.31D-23, 0.003817,  2, 2, & !   224
     & 2.998600D0, 1.376806027763D-04, -1.81D-23, 0.009970,  2, 2, & !   225
     & 4.410776D0, 1.378132974340D-04,  6.83D-23, 0.004543,  2, 2, & !   226
     & 2.112329D0, 1.378464985428D-04,  2.48D-23, 0.006478,  3, 2, & !   227
     & 6.213075D0, 1.378571955051D-04,  1.75D-23, 0.038122,  3, 2, & !   228
     & 5.137914D0, 1.378690026892D-04, -1.14D-23, 0.044279,  2, 2, & !   229
     & 6.097067D0, 1.378796996516D-04, -1.86D-23, 1.186047,  2, 2  & !   230
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=231,240)   &
     & / &
     & 3.595963D0, 1.380338072533D-04,  5.64D-23, 0.002200,  2, 2, & !   231
     & 0.112564D0, 1.380563018901D-04,  1.86D-23, 0.006397,  2, 2, & !   232
     & 6.053942D0, 1.380787965269D-04, -1.92D-23, 0.011068,  2, 2, & !   233
     & 5.735277D0, 1.382222071662D-04,  6.31D-23, 0.008397,  2, 2, & !   234
     & 0.411245D0, 1.382329041286D-04,  5.58D-23, 0.225298,  2, 2, & !   235
     & 3.320822D0, 1.382779124215D-04, -1.65D-23, 0.001151,  2, 2, & !   236
     & 0.368120D0, 1.384320010039D-04,  5.53D-23, 0.010394,  2, 2, & !   237
     & 6.168968D0, 1.400992960097D-04,  2.48D-23, 0.002689,  2, 2, & !   238
     & 4.713666D0, 1.401656982274D-04, -6.21D-23, 0.018596,  2, 2, & !   239
     & 5.354155D0, 1.403198058291D-04,  1.29D-23, 0.021286,  2, 2  & !   240
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=241,250)   &
     & / &
     & 5.427038D0, 1.404963985579D-04,  4.86D-23, 0.002159,  3, 2, & !   241
     & 0.251131D0, 1.404975087796D-04,  2.70D-23, 0.003219,  2, 2, & !   242
     & 1.210284D0, 1.405082057420D-04,  1.97D-23, 0.231130,  2, 2, & !   243
     & 2.169437D0, 1.405189027044D-04,  1.24D-23, 6.194554,  2, 2, & !   244
     & 5.762628D0, 1.405189217237D-04,  1.56D-23, 0.002958,  2, 2, & !   245
     & 2.053430D0, 1.405414068508D-04, -2.38D-23, 0.005747,  3, 2, & !   246
     & 6.154176D0, 1.405521038132D-04, -3.10D-23, 0.001090,  3, 2, & !   247
     & 5.079015D0, 1.405639109973D-04, -6.00D-23, 0.003587,  2, 2, & !   248
     & 2.896575D0, 1.405746079596D-04, -6.72D-23, 0.001284,  2, 2, & !   249
     & 2.126312D0, 1.407179995796D-04,  1.19D-23, 0.018752,  2, 2  & !   250
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=251,260)   &
     & / &
     & 5.908394D0, 1.408721071813D-04,  8.69D-23, 0.003530,  2, 2, & !   251
     & 2.650793D0, 1.408946113278D-04,  5.07D-23, 0.001120,  3, 2, & !   252
     & 5.676378D0, 1.409171154743D-04,  1.45D-23, 0.007263,  2, 2, & !   253
     & 0.352346D0, 1.409278124366D-04,  7.26D-24, 0.003483,  2, 2, & !   254
     & 1.311500D0, 1.409385093990D-04, -1.95D-26, 0.001178,  2, 2, & !   255
     & 0.829162D0, 1.426058044048D-04, -3.05D-23, 0.002188,  2, 2, & !   256
     & 6.110069D0, 1.427942043178D-04, -2.38D-23, 0.002045,  2, 2, & !   257
     & 0.786037D0, 1.428049012801D-04, -3.10D-23, 0.045678,  2, 2, & !   258
     & 1.084719D0, 1.429815035186D-04,  6.20D-24, 0.001103,  2, 2, & !   259
     & 0.424247D0, 1.431474087947D-04,  5.07D-23, 0.006407,  2, 2  & !   260
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=261,270)   &
     & / &
     & 1.383401D0, 1.431581057571D-04,  4.34D-23, 0.175107,  2, 2, & !   261
     & 3.449832D0, 1.431699129412D-04,  1.45D-23, 0.002080,  3, 2, & !   262
     & 4.408985D0, 1.431806099036D-04,  7.27D-24, 0.035163,  3, 2, & !   263
     & 2.226546D0, 1.431913068659D-04, -9.74D-27, 0.006624,  3, 2, & !   264
     & 1.151385D0, 1.432031140500D-04, -2.89D-23, 0.043770,  2, 2, & !   265
     & 5.252131D0, 1.432138110124D-04, -3.62D-23, 0.019318,  2, 2, & !   266
     & 3.069692D0, 1.432245079747D-04, -4.35D-23, 0.002732,  2, 2, & !   267
     & 1.748749D0, 1.435563185270D-04,  4.56D-23, 0.008373,  2, 2, & !   268
     & 5.849495D0, 1.435670154894D-04,  3.83D-23, 0.004042,  2, 2, & !   269
     & 0.086250D0, 1.450459105823D-04,  1.08D-24, 0.006836,  2, 2  & !   270
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=271,280)   &
     & / &
     & 0.043125D0, 1.452450074576D-04,  5.39D-25, 0.168449,  2, 2, & !   271
     & 2.182439D0, 1.454334073705D-04,  7.28D-24, 0.006453,  2, 2, & !   272
     & 6.283185D0, 1.454441043329D-04, -7.35D-40, 2.881748,  2, 2, & !   273
     & 3.593191D0, 1.454441233522D-04,  3.20D-24, 0.001052,  2, 2, & !   274
     & 3.098467D0, 1.456432012082D-04, -5.39D-25, 0.024055,  2, 2, & !   275
     & 3.550066D0, 1.456432202275D-04,  2.66D-24, 0.006198,  2, 2, & !   276
     & 0.481356D0, 1.458198129563D-04,  3.83D-23, 0.001915,  3, 2, & !   277
     & 2.547787D0, 1.458316201404D-04,  9.40D-24, 0.010022,  2, 2, & !   278
     & 3.506941D0, 1.458423171028D-04,  2.13D-24, 0.783028,  2, 2, & !   279
     & 1.324501D0, 1.458530140651D-04, -5.15D-24, 0.233371,  2, 2  & !   280
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=281,290)   &
     & / &
     & 5.425248D0, 1.458637110275D-04, -1.24D-23, 0.025368,  2, 2, & !   281
     & 3.463816D0, 1.460414139781D-04,  1.59D-24, 0.006213,  2, 2, & !   282
     & 0.730696D0, 1.462405298727D-04,  4.25D-24, 0.005334,  2, 2, & !   283
     & 5.265133D0, 1.481283156785D-04, -4.13D-23, 0.008374,  2, 2, & !   284
     & 3.082694D0, 1.481390126409D-04, -4.86D-23, 0.003651,  2, 2, & !   285
     & 5.862496D0, 1.484815201555D-04,  3.32D-23, 0.043801,  2, 2, & !   286
     & 3.680057D0, 1.484922171179D-04,  2.59D-23, 0.019074,  2, 2, & !   287
     & 1.497618D0, 1.485029140802D-04,  1.86D-23, 0.002070,  2, 2, & !   288
     & 5.746489D0, 1.485040243020D-04, -3.01D-24, 0.003239,  3, 2, & !   289
     & 3.564049D0, 1.485147212643D-04, -1.03D-23, 0.002080,  3, 2  & !   290
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=291,300)   &
     & / &
     & 1.337503D0, 1.507675187313D-04, -1.03D-23, 0.007264,  2, 2, & !   291
     & 5.438249D0, 1.507782156936D-04, -1.76D-23, 0.003126,  2, 2, & !   292
     & 1.934867D0, 1.511207232082D-04,  6.42D-23, 0.003589,  2, 2, & !   293
     & 6.035613D0, 1.511314201706D-04,  5.69D-23, 0.001563,  2, 2, & !   294
     & 4.844444D0, 1.511657315012D-04, -8.15D-24, 0.011460,  2, 2, & !   295
     & 2.662005D0, 1.511764284635D-04, -1.54D-23, 0.009937,  2, 2, & !   296
     & 0.479566D0, 1.511871254259D-04, -2.27D-23, 0.003215,  2, 2, & !   297
     & 3.693059D0, 1.534067217840D-04,  2.08D-23, 0.001151,  2, 2, & !   298
     & 0.916814D0, 1.538049345539D-04,  2.29D-23, 0.002195,  2, 2, & !   299
     & 5.017560D0, 1.538156315163D-04,  1.56D-23, 0.001902,  2, 2  & !   300
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=301,310)   &
     & / &
     & 3.068038D0, 2.032139493753D-04, -2.55D-26, 0.001081,  3, 3, & !   301
     & 4.826230D0, 2.054999479510D-04, -4.35D-23, 0.003565,  3, 3, & !   302
     & 5.423594D0, 2.058531524280D-04,  3.10D-23, 0.003584,  3, 3, & !   303
     & 6.222632D0, 2.081284540414D-04, -5.16D-24, 0.001153,  3, 3, & !   304
     & 0.898600D0, 2.081391510038D-04, -1.24D-23, 0.020565,  3, 3, & !   305
     & 1.495964D0, 2.084923554808D-04,  6.21D-23, 0.003850,  3, 3, & !   306
     & 2.295003D0, 2.107676570942D-04,  2.59D-23, 0.004199,  3, 3, & !   307
     & 3.254156D0, 2.107783540565D-04,  1.86D-23, 0.075042,  3, 3, & !   308
     & 1.870756D0, 2.130643526323D-04, -2.48D-23, 0.001046,  3, 3, & !   309
     & 2.468119D0, 2.134175571093D-04,  4.96D-23, 0.004250,  3, 3  & !   310
     & /
!
      DATA      ( TID_PHAS(NT$1), TID_FREQ(NT$1), TID_ACCL(NT$1), &
     &            TID_AMPL(NT$1), L(NT$1), M(NT$1), NT$1=311,313)   &
     & / &
     & 2.236104D0, 2.134625654022D-04, -2.27D-23, 0.001597,  3, 3, & !   311
     & 4.591659D0, 2.161017684549D-04,  8.33D-24, 0.009776,  3, 3, & !   312
     & 2.409220D0, 2.161124654173D-04,  1.05D-24, 0.004289,  3, 3  & !   313
     & /
