      SUBROUTINE DBPOX(NUMDD,LDBNAM,IDBVER,IDBEND)
      IMPLICIT   NONE ! Updated by Jim Ryan for I*4 compliance, Sept 2002
!
! 1.     DBPOX PROGRAM SPECIFICATION
!
! 1.1.   DBPOX gets information from NAMFIL on the data bases in OBSFIL.
!        A maximum of 15 data base names may be picked up.
!
! 1.2.   REFERENCES:
!
! 2.  DBPOX INTERFACE
!
! 2.1 Parameter File
      INCLUDE 'solve.i'
!
! 2.2 INPUT VARIABLES:  NONE
!
! 2.3 OUTPUT VARIABLES:
!
      INTEGER*2 NUMDD,LDBNAM(5,15),IDBVER(15)
      INTEGER*4 IDBEND(15)
!
!     IDBEND(15)   = File pointer to end of data base
!                      (logical record counter)
!                    (obsfil record number representing the last
!                     observation in the data base)
!     IDBVER(15)   = Data base version numbers
!     LDBNAM(5,15) = Data base names
!     NUMDD        = Number of data bases (<=15)
!
! 2.4 COMMON BLOCKS USED
      INCLUDE 'precm.i'
!
! 2.5.   SUBROUTINE INTERFACE:
!
!     CALLED SUBROUTINES: getcard
!
! 3.  LOCAL VARIABLES
!
      CHARACTER*70 JBUF, errstr
      character*80 bufstr
      INTEGER*2 IERR,JJ
      INTEGER*4  IERR4
!
! IERR - Error return from getcard
! JBUF - Buffer to hold records from NAMFIL
! JJ - Loop index
!
! 4.  HISTORY
!   WHO   WHEN   WHAT
!   CMA  831008  Modified to handle eccentricity type in 'NAMFIL'
!   BK   850226  To input calling program name for error handling
!   KDB  860423  To support new NAMFIL structure
!   AEE  910515  Enhanced error messages written to the error file.
!   kdb  951207  Integer*4 number of observations.
!
! 5.  DBPOX PROGRAM STRUCTURE
!
!  Read NAMFIL, to get each data base's name and version
!  number, and to get the pointer to the last OBSFIL
!  observation, for each data base.
!
      NUMDD = 1
      IERR=0
      CALL GETCARD ( NUMDD, 'INIT', INT2(1), JBUF, IERR )
      IF (IERR .NE. 0) NUMDD = 0
      DO WHILE ( IERR .EQ. 0 .AND. NUMDD .LE. 15 )
         READ ( JBUF, 1000, IOSTAT=IERR4 ) (LDBNAM(JJ,NUMDD),JJ = 1, 5), &
     &          IDBVER(NUMDD), IDBEND(NUMDD)
         CALL FERR( INT2(IERR4), "Reading NAMFIL card", INT2(0), INT2(0) )
 1000    FORMAT (10X, 5A2, I4, 11X, I11, 34X)
         NUMDD = NUMDD + 1
         CALL GETCARD ( NUMDD, 'INIT', INT2(1), JBUF, IERR )
         IF (IERR .NE. 0) NUMDD = NUMDD - 1
      END DO
!
!     If the loop terminated because there were more data bases than
!     are allowed, and not because it ran out of data bases, die
!     an ignominious death.
!
      IF ( NUMDD .EQ. 16 ) THEN
           ERRSTR = ' TOO MANY DATABASES IN NAMFIL '
           CALL FERR ( INT2(157), ERRSTR, INT2(0), INT2(0) )
!
!     If an abnormal IERR was generated by any call of GETCARD,
!     display the IERR. The normal, expected value for IERR at this
!     point is -6.
!
      ELSE IF (IERR .NE. -6) THEN
        WRITE(errstr,"('DBPOX GETCARD HAD IERR ', I10)") IERR
        call ferr( INT2(158), errstr, INT2(0), INT2(0) )
      END IF
!
      RETURN
      END
