      SUBROUTINE IND_PARM_TROT(TOTAL_POS,TOTAL_PARMS,TOTAL_NUM, &
     &   THIS_EPOCH,THIS_POS,THIS_PARMS,THIS_NUM)
!
      IMPLICIT   NONE ! Updated by Jim Ryan for I*4 compliance, Sept 2002
!
! 1.  IND_PARM_TROT PROGRAM SPECIFICATION
!
! 1.1 Take the list of earth orientation offset parameter names and
!     deriv list positions generated by a call to parms and
!     index_parms and generate two shorter lists applicable to
!     a given epoch.
!
! 1.2 REFERENCES:
!
! 2.  IND_PARM_TROT INTERFACE
!
! 2.1 Parameter File
      INCLUDE 'solve.i'
!
! 2.2 INPUT Variables:
!
      INTEGER*2 TOTAL_NUM, TOTAL_POS(M_GPA)
      CHARACTER*20 TOTAL_PARMS(*)
      REAL*8 THIS_EPOCH
!
!        TOTAL_POS - list of positions of all earth orientation offset
!                    parameters within the deriv array
!
!        TOTAL_PARMS - list of parameter names of all earth orientation offset
!                    parameters
!
!        TOTAL_NUM - total number of earth orientation offset parameters in
!                    the deriv array
!
!        THIS_EPOCH - epoch for which shorter postition and parameter names
!                     lists should be generated
!
!
! 2.3 OUTPUT Variables:
!
      INTEGER*2 THIS_NUM, THIS_POS(3)
      CHARACTER*20 THIS_PARMS(3)
!
!        THIS_POS - list of earth orientation offset deriv array positions
!                   for this epoch
!
!        THIS_PARMS - list of earth orientation offset parameter names
!                   for this epoch
!
!        THIS_NUM - number of earth orientation offset parameters
!                   for this epoch
!
!
! 2.4 COMMON BLOCKS USED
!
! 2.5 SUBROUTINE INTERFACE
!
!       CALLING SUBROUTINES: a2jst
!       CALLED SUBROUTINES: epoc
!
! 3.  LOCAL VARIABLES
!
      INTEGER*2 I,IY,IY_GOAL,ID,ID_GOAL,IM,IM_GOAL,IMIN
      INTEGER*2 IMIN_GOAL,IHR,IHR_GOAL,IXYU
      INTEGER*4 ios
      REAL*8 TEST_EPOCH
!
! 4.  HISTORY
!
!  WHO  WHEN    WHAT
!  KDB  9/18/90
!
! 5.  IND_PARM_TROT PROGRAM STRUCTURE
!
      DO I = 1,3
        THIS_POS(I) = 0
        THIS_PARMS(I) = '                    '
      END DO
      THIS_NUM = 0
!
!     Run down the list of earth orientation offsets, comparing the given
!     rotation epoch to the epoch encoded in each parameter name, to find
!     the offsets for the given epoch.
!
      CALL EPOC(IM_GOAL,ID_GOAL,IY_GOAL,IHR_GOAL,IMIN_GOAL,THIS_EPOCH )
      DO I = 1,TOTAL_NUM
!
!       Decode the parameter name to find out the epoch to which it
!       applies.  (The list is assumed to be in the short form generated by
!       PARMS.)
!
        READ(TOTAL_PARMS(I)(11:12),'(I2)',IOSTAT=ios) IY
        if (ios.ne.0) call ferr ( INT2(ios), "IND_PARM_TROT: "// &
     &  "Reading eop parm names", INT2(0), INT2(0) )
        READ(TOTAL_PARMS(I)(13:14),'(I2)',IOSTAT=ios) IM
        if (ios.ne.0) call ferr ( INT2(ios), "IND_PARM_TROT: "// &
     &  "Reading eop parm names", INT2(0), INT2(0) )
        READ(TOTAL_PARMS(I)(15:16),'(I2)',IOSTAT=ios) ID
        if (ios.ne.0) call ferr ( INT2(ios), "IND_PARM_TROT: "// &
     &  "Reading eop parm names", INT2(0), INT2(0) )
        READ(TOTAL_PARMS(I)(17:18),'(I2)',IOSTAT=ios) IHR
        if (ios.ne.0) call ferr ( INT2(ios), "IND_PARM_TROT: "// &
     &  "Reading eop parm names", INT2(0), INT2(0) )
        READ(TOTAL_PARMS(I)(19:20),'(I2)',IOSTAT=ios) IMIN
        if (ios.ne.0) call ferr ( INT2(ios), "IND_PARM_TROT: "// &
     &  "Reading eop parm names", INT2(0), INT2(0) )
!
        IF (IY.EQ.IY_GOAL .AND. IM.EQ.IM_GOAL .AND. &
     &      ID.EQ.ID_GOAL .AND. IMIN.EQ.IMIN_GOAL .AND. &
     &      IHR.EQ.IHR_GOAL) THEN
          IF (TOTAL_PARMS(I)(1:1) .EQ. 'X') THEN
            IXYU = 1
          ELSE IF (TOTAL_PARMS(I)(1:1) .EQ. 'Y') THEN
            IXYU = 2
          ELSE
            IXYU = 3
          END IF
          THIS_NUM = THIS_NUM + 1
          THIS_POS(IXYU) = TOTAL_POS(I)
          THIS_PARMS(THIS_NUM) = TOTAL_PARMS(I)
        END IF
      END DO
!
      RETURN
      END
