      PROGRAM COPYQ
      IMPLICIT   NONE ! Updated by Jim Ryan for I*4 compliance, Sept 2002
      INCLUDE 'solve.i'
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
!  THIS IS A SIMPLE COPY PROGRAM TO COPY
!  A SOURCE FILE TO A DESTINATION FILE
!
!  IF THE DESTINATION FILE EXISTS, IT HAD BETTER BE THE CORRECT TYPE
!  AND SIZE TO HOLD THE INPUT, IT DOESN'T WORK FOR TYPE 2 FILES OR
!  FILES OF LARGER EXTENT THAN 32767 BLOCKS, BUT COULD BE EASILY
!  FIXED TO DO SO
!
!  THE RUNSTRING IS:
!
!   RU,COPYQ,SNAMR,DNAMR,Q,BLOCKS
!
!   SNAMR = SOURCE NAMR
!   DNAMR = DESTINATION NAMR
!   Q       IF PRESENT THIS MEANS QUIET
!   BLOCKS = blocks to transfer
!
!CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
!
! parameters
!
      INTEGER*4 JMEM_BLOCKS,JMEM_WORDS
      PARAMETER &
     &           (JMEM_BLOCKS=256, &
     &           JMEM_WORDS=JMEM_BLOCKS*BLOCK_WORDS)
!
!  EXTERNAL FUNCTIONS
!
      INTEGER*2 TRIMLEN
      INTEGER*4 DECMLTODINT
!
!  VARIABLES
!
      CHARACTER*6 QUIET
      CHARACTER*12 LMOVE
      CHARACTER*100 BUFF,SOURCE,DESTIN,TOKEN
      character*80 bufstr
      INTEGER*2 MEM(JMEM_WORDS),IERR,IBUFF(50),LENS,LEND
      INTEGER*4 JTRANS,MOVLEN,JMOVE,FILDES,FILSRC
      INTEGER*4 I4P0
!
!  STORAGE MANIPULATION
!
      EQUIVALENCE (IBUFF,BUFF)
      DATA I4P0 /0/
!
!   HISTORY
!   JLR  921215  replaced nJ's with I4Pn's
!
!  PASSED INFORMATION
!
      CALL PRE_PROG()
      BUFF=' '
      CALL USE_BUFFER( IBUFF, INT2(50), 'ORC' )
!
      CALL SPLITSTRING(BUFF,TOKEN,BUFF )
      CALL SPLITSTRING(BUFF,TOKEN,BUFF )
      CALL SPLITSTRING(BUFF,SOURCE,BUFF )
      CALL SPLITSTRING(BUFF,DESTIN,BUFF )
      CALL SPLITSTRING(BUFF,QUIET,BUFF )
      CALL SPLITSTRING(BUFF,LMOVE,BUFF )
      MOVLEN=DECMLTODINT(LMOVE,IERR)
      IF(IERR.NE.0) CALL FERR( IERR, 'DECODING BLOCKS TO MOVE', INT2(0), &
     &   INT2(0))
!
      INCLUDE 'copyq_version.i' ! Set revision date of the current version
!
      IF(QUIET.NE.'Q') then
        call start_mn()
        call setcr_mn(I4P0,I4P0 )
        call reverse_on_mn()
        call addstr_f("COPYQ " )
        call reverse_off_mn()
        WRITE(bufstr,*) 'CI Ver. 93.07.08, BUFFER SIZE: ', &
     &              JMEM_BLOCKS,' BLOCKS'
        call addstr_f(bufstr )
        call nl_mn()
      endif
!
      CALL BIN_OPEN(SOURCE,FILSRC,'O' )
      CALL BIN_OPEN(DESTIN,FILDES,'O' )
!
      JMOVE=MOVLEN
      DO WHILE(JMOVE.GT.0)
        JTRANS=MIN(JMEM_BLOCKS,JMOVE)
        CALL BIN_READ(SOURCE,FILSRC,MEM,JTRANS )
        CALL BIN_WRITE(DESTIN,FILDES,MEM,JTRANS )
        JMOVE=JMOVE-JTRANS
      ENDDO
!
      LENS=MAX(INT2(1),TRIMLEN(SOURCE))
      LEND=MAX(INT2(1),TRIMLEN(DESTIN))
      IF(QUIET.NE.'Q') then
        WRITE(bufstr,9955) SOURCE(1:LENS),DESTIN(1:LEND)
9955  FORMAT(" ",A," COPIED TO ",A)
        call addstr_f(bufstr )
        call nl_mn()
        call end_mn()
      endif
!
      CALL BIN_CLOSE(SOURCE,FILSRC )
      CALL BIN_CLOSE(DESTIN,FILDES )
!
      CALL END_PROG()
      END
