      PROGRAM    GEN_ADHOC_HEO
! ************************************************************************
! *                                                                      *
! *   Program GEN_ADHOC_HEO
! *                                                                      *
! *  ### 04-MAR-2006 GEN_ADHOC_HEO v5.0 (c)  L. Petrov  04-DEC-2025 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INTEGER*4  MW
      PARAMETER  ( MW = 8192 )
      REAL*8     PI, PI2, P2I
      PARAMETER ( PI=3.141592653589793D0, PI2=2.D0*PI, P2I=PI/2D0 )
      CHARACTER  FILOUT*128, NAM_FRQ(MW)*8, STR*32
      INTEGER*4  IWID
      REAL*8       K1_FRQ, SA_FRQ, NQ_FRQ, FRQ_LIM
      PARAMETER  ( K1_FRQ   = 7.292115855138D-05 )
      PARAMETER  ( SA_FRQ   = 1.990968752920D-07 )
      PARAMETER  ( FRQ_LIM  = 1.2D0*SA_FRQ )
      PARAMETER  ( IWID = 23 )
      INTEGER*4  M_BND
      PARAMETER  ( M_BND = 16 )
      REAL*8     FRQ_BND(M_BND)
      REAL*8     FRQ(MW), PHS(MW), ARR_SRT1(MW), ARR_SRT2(MW)
      CHARACTER   DATE_BEG*19, DATE_END*19
      LOGICAL*4   E3_USE, FL_CLOSE
      INTEGER*4   J1, J2, J3, J4, J5, ID, I_FRQ, LW, IND, ISGN, MJD_BEG, MJD_END, IUER
      REAL*8      TAI_BEG, TAI_END, NF_SCALE
      INTEGER*4,  EXTERNAL ::  I_LEN, LINDEX
      CHARACTER,  EXTERNAL ::  GET_CDATE*19
!
      IF ( IARGC() < 3 ) THEN
           WRITE ( 6, * ) 'Usage: gen_adhoc_heo  date_start date_end nf_scale filout'
           CALL EXIT ( 1 ) 
         ELSE 
           CALL GETARG ( 1, DATE_BEG )
           CALL GETARG ( 2, DATE_END )
           CALL GETARG ( 3, STR      )
           READ ( UNIT=STR, FMT='(F10.5)' ) NF_SCALE
           CALL GETARG ( 4, FILOUT   )
!
           IUER = -1
           CALL DATE_TO_TIME ( DATE_BEG, MJD_BEG, TAI_BEG, IUER )
           IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
!
           IUER = -1
           CALL DATE_TO_TIME ( DATE_END, MJD_END, TAI_END, IUER )
           IF ( IUER .NE. 0 ) CALL EXIT ( 1 )
      END IF
      NQ_FRQ = NF_SCALE * PI2/( (MJD_END - MJD_BEG)*86400.0D0 + (TAI_END - TAI_BEG) )
      NQ_FRQ = 1.D-13*INT(1.D13*NQ_FRQ)
      write ( 6, * ) 'Scaled Nyquist frquency: ', NQ_FRQ
      write ( 6, * ) 'Scaled factor:           ', NF_SCALE
!
      I_FRQ = 0
      DO 410 J1=1,2
         IF ( J1 == 1 ) ISGN = -1
         IF ( J1 == 2 ) ISGN =  1
         DO 420 J2=1,4
            DO 430 J3=-IWID,IWID
               I_FRQ = I_FRQ + 1
               FRQ(I_FRQ) = ISGN*J2*K1_FRQ + J3*NQ_FRQ
               PHS(I_FRQ) = 0.0D0
               NAM_FRQ(I_FRQ) = 'K00_0000'
               IF ( ISGN == -1 ) NAM_FRQ(I_FRQ)(3:3) = '-'
               IF ( ISGN ==  1 ) NAM_FRQ(I_FRQ)(3:3) = '+'
               CALL INCH ( J2, NAM_FRQ(I_FRQ)(2:2) )
               CALL INCH ( IABS(J3), NAM_FRQ(I_FRQ)(6:8) )
               CALL CHASHR ( NAM_FRQ(I_FRQ)(6:8) )
               IF ( J3 > 0 ) NAM_FRQ(I_FRQ)(5:5) = '+'
               IF ( J3 < 0 ) NAM_FRQ(I_FRQ)(5:5) = '-'
               CALL BLANK_TO_ZERO ( NAM_FRQ(I_FRQ) )
               ARR_SRT1(I_FRQ) = FRQ(I_FRQ)
               ARR_SRT2(I_FRQ) = I_FRQ + 1.D-8
 430        CONTINUE 
 420     CONTINUE 
 410  CONTINUE 
!
      OPEN ( UNIT=11, FILE=FILOUT, STATUS='UNKNOWN' ) 
!
      ID = LINDEX ( FILOUT, '/' )
      WRITE ( UNIT=11, FMT='(A)' ) '#'
      WRITE ( UNIT=11, FMT='(A)' ) '#  Generated by gen_adhoc_heo on '//GET_CDATE()
      WRITE ( UNIT=11, FMT='(A)' ) '#'
      WRITE ( UNIT=11, FMT='(A)' ) '#  Ad hoc frequencies of the solutions '//TRIM(FILOUT(ID+1:))
      WRITE ( UNIT=11, FMT='(A)' ) '#'
      WRITE ( UNIT=11, FMT='(A)' ) '#  Name             Freq                 Phase          PM, E3'
      WRITE ( UNIT=11, FMT='(A)' ) '#'
      WRITE ( UNIT=11, FMT='(A)' ) '#----------------   -------------------  ------------    -   -'
      WRITE ( UNIT=11, FMT='(A)' ) '# 2:17              21:39                46:53          58  62 '
      WRITE ( UNIT=11, FMT='(A)' ) '#'
!
      CALL SORT8 ( I_FRQ, ARR_SRT1, ARR_SRT2 )
      DO 450 J5=1,I_FRQ
         IND = ARR_SRT2(J5)
         IF ( FRQ(IND) .LT. 0.0D0 ) THEN
              E3_USE = .TRUE.
            ELSE 
              E3_USE = .FALSE.
         END IF
         WRITE  ( 11, 110 ) NAM_FRQ(IND), FRQ(IND), PHS(IND), E3_USE, J5
 110     FORMAT ( "'", A, "        ', ", 1PD19.12, &
     &            ", ",0PF10.8, "D0,   T,  ",L1,", ! ", I4 )
 450  CONTINUE 
      CLOSE ( UNIT=11 )
      WRITE ( 6, * ) ' I_FRQ =', I_FRQ
      WRITE ( 6, '(A)' ) 'Output file: '//FILOUT(1:I_LEN(FILOUT))
      END  PROGRAM  GEN_ADHOC_HEO  !#!#
