      SUBROUTINE COMMON_46_to_58()
! ************************************************************************
! *                                                                      *
! *   Routine  COMMON_46_TO_58  transfroms common block from 46-block    *
! *   format (pre MAR-2006) to 58-block format (post MAR-2006 ).         *
! *                                                                      *
! *   It is assumed that the image of 46-block of SOCOM resids there     *
! *   where the image of 58-block should be located.                     *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### 21-JUL-2000  COMMON_46_TO_58  v1.0 (d) L. Petrov 24-JUL-2000 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE
      INCLUDE   'solve.i'
      INCLUDE   'socom.i'
      INCLUDE   'socom_46.i'
      INTEGER*4  NB, NB_46
      INTEGER*2  INT2_ARG
      INTEGER*4  INT4
      INT4(INT2_ARG) = INT(INT2_ARG,KIND=4)
!
      NB_46 = JSOCOM_BLOCKS_46*INT4(BLOCK_BYTES)
      NB    = JSOCOM_BLOCKS*INT4(BLOCK_BYTES)
!
! --- Copying content of socom to its 46-block sister
!
      CALL LIB$MOVC3 ( NB_46, ISOCOM, ISOCOM_46 )
!
! --- Initialization of main socom
!
      CALL NOUT      ( NB,    ISOCOM )
      CALL CLRCH ( USER_PRO )
      CALL CLRCH ( USER_BUF )
      CALL CLRCH ( SCR_FIL_ORIGIN )
      CALL CLRCH ( EXP_DESC )
      CALL CLRCH ( EXP_CODE )
      CALL CLRCH ( PI_NAME )
      CALL CLRCH ( CORRELATOR_NAME )
      CALL CLRCH ( CORRTYPE )
      CALL CLRCH ( REC_MODE )
      CALL CLRCH ( UT1_RS )
      CALL CLRCH ( UT1_RS_FLYBY )
!
! --- Copying stuff from 46-block socom to its older sister: 46-block socom
!
!
! --- REAL*8
!
      PI_VAR = PI_VAR_46
      CALL LIB$MOVC3 ( 8*INT4(MAX_CLK), FJDCL_46, FJDCL )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ATM), TATM_46, TATM )
      ELMIN = ELMIN_46
      VLIGHT = VLIGHT_46
      CALL LIB$MOVC3 ( 8*INT4(MAX_ROT), TROT_46, TROT )
      CALL LIB$MOVC3 ( 8*3, WRMS_46, WRMS )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ROT)*4, ROTAP_46, ROTAP )
      CALL LIB$MOVC3 ( 8*3, UT1INB_46, UT1INB )
      CALL LIB$MOVC3 ( 8*3, WOBINB_46, WOBINB  )
      CALCV = CALCV_46
      ATMOS_INTERVAL = ATMOS_INTERVAL_46
      CLOCK_INTERVAL = CLOCK_INTERVAL_46
      CALL LIB$MOVC3 ( 8*2, ROT_INTERVAL_46, ROT_INTERVAL )
      TROT_A1 = TROT_A1_46
      CALL LIB$MOVC3 ( 8*INT4(MAX_EROT_VALUES), UT1PTB_46, UT1PTB )
      CALL LIB$MOVC3 ( 8*INT4(MAX_EROT_VALUES), WOBXXB_46, WOBXXB )
      CALL LIB$MOVC3 ( 8*INT4(MAX_EROT_VALUES), WOBYYB_46, WOBYYB )
      FCNPER = FCNPER_46
      CALL LIB$MOVC3 ( 8*INT4(MAX_ARC_STA), SACNST_46, SACNST )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ARC_STA), SCCNST_46, SCCNST  )
      CALL LIB$MOVC3 ( 8*INT4(MAX_ARC_STA), ELVCUT_46, ELVCUT )
      CALL LIB$MOVC3 ( 8*3, EOPCONS_46, EOPCONS  )
      CALL LIB$MOVC3 ( 8*3, EOPRCONS_46, EOPRCONS  )
      CALL LIB$MOVC3 ( 8*2, SEOCNST_46, SEOCNST  )
      PWCCNST = PWCCNST_46
      CALL LIB$MOVC3 ( 8*2, NUTCONS_46, NUTCONS  )
      CALL LIB$MOVC3 ( 8*INT4(MAX_GRAD), TGRAD_46, TGRAD  )
      GRAD_INTERVAL = GRAD_INTERVAL_46
      CALL LIB$MOVC3 ( 8*2, GRADCONS_46, GRADCONS )
      NUTPSI_DIF = NUTPSI_DIF_46
      NUTEPS_DIF = NUTEPS_DIF_46
      NUTPSI_AVE = NUTPSI_AVE_46
      NUTEPS_AVE = NUTEPS_AVE_46
      CHISQR(1) = CHISQR_46(1) 
      CHISQR(2) = CHISQR_46(2) 
      CHISQR(3) = CHISQR_46(3) 
      UTC_M_TAI = UTC_M_TAI_46
!
! --- LOGICAL*2
!
      LOGBCL = LOGBCL_46
      BMODE_CL = BMODE_CL_46
      BMODE_AT = BMODE_AT_46
      CLK_BRK_STAT = CLK_BRK_STAT_46
      FLYBY_WARNING = FLYBY_WARNING_46
      SITE_DEP_CONST = SITE_DEP_CONST_46
      SIMULATION_TEST = SIMULATION_TEST_46
      SITE_DEP_EL_CUT = SITE_DEP_EL_CUT_46
      SHORT_UT1_IN = SHORT_UT1_IN_46
      SOL_AVAIL = SOL_AVAIL_46
      OLD_CLOCKS = OLD_CLOCKS_46
      OLD_ATMS = OLD_ATMS_46
      SKIP_EOP_OFF = SKIP_EOP_OFF_46
      CGM_TYPE = CGM_TYPE_46
!
! --- Character
!
      USER_PRO = USER_PRO_46
      USER_BUF = USER_BUF_46
      SCR_FIL_ORIGIN = SCR_FIL_ORIGIN_46
      UT1_RS = UT1_RS_46
      UT1_RS_FLYBY = UT1_RS_FLYBY_46
!
!      EXP_DESC = EXP_DESC_46 
!      EXP_CODE = EXP_CODE_46 
!      PI_NAME  = PI_NAME_46 
!      CORRELATOR_NAME = CORRELATOR_NAME_46 
!      CORRTYPE = CORRTYPE_46 
!      REC_MODE = REC_MODE_46 
!
!      UT1_RS       = UT1_RS_46       
!      UT1_RS_FLYBY = UT1_RS_FLYBY_46 
!      EOP_TS_CALC  = EOP_TS_CALC_46  
!      EOP_TS_MODF  = EOP_TS_MODF_46  
!      DBNAME_CH    = DBNAME_CH_46    
!      ENV_FINAM    = ENV_FINAM_46    
!
! --- INTEGER*2
!
      NUMSTR = NUMSTR_46
      NUMSTA = NUMSTA_46
      NPOLD = NPOLD_46
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_ARC_STA), ICLOCK_46, ICLOCK )
      IDNWT = IDNWT_46
      IPRES = IPRES_46
      CALL LIB$MOVC3 ( 2*2, IRNCD_46, IRNCD  )
      ITDGLB = ITDGLB_46
      NPARAM = NPARAM_46
      IDATYP = IDATYP_46
      NROT = NROT_46
      NSOURC = NSOURC_46
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NSPARM_46, NSPARM  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NUMATM_46, NUMATM  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NUMGRAD_46, NUMGRAD )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), IATSTR_46, IATSTR  )
      ICLMAX = ICLMAX_46
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), NUMCLK_46, NUMCLK  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), ICLSTR_46, ICLSTR  )
      IPSTP = IPSTP_46
      CALL LIB$MOVC3 ( 2*3, LNUT_46, LNUT  )
      LPREC = LPREC_46
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS)*3, LTIDE_46, LTIDE )
      LREL = LREL_46
      CALL LIB$MOVC3 ( 2*INT4(ROT_BIT_WORDS)*3, LROT_46, LROT  )
      CALL LIB$MOVC3 ( 2*INT4(ATM_BIT_WORDS)*3, LATM_46, LATM  )
      CALL LIB$MOVC3 ( 2*INT4(MAX_CLK), LCLK_46, LCLK  )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_46), LSTAR_46(1,1), LSTAR(1,1) )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_46), LSTAR_46(1,2), LSTAR(1,2) )
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS), LAXOF_46, LAXOF  )
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS)*3, LSITEC_46, LSITEC )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_46), ISRSEL_46, ISRSEL  )
      IUEN = IUEN_46
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_CLK), ICLSTA_46, ICLSTA  )
      NFLEPS = NFLEPS_46
      CALL LIB$MOVC3 ( 2*14, FLEPS_46, FLEPS  )
      NFLPSI = NFLPSI_46
      CALL LIB$MOVC3 ( 2*14, FLPSI_46, FLPSI  )
      CALL LIB$MOVC3 ( 2*7, IDPNUT_46, IDPNUT  )
      NDPNUT = NDPNUT_46
      CALL LIB$MOVC3 ( 2*INT4(STA_BIT_WORDS)*3, LSITEV_46, LSITEV )
      IARCSOC = IARCSOC_46
      NSLAST = NSLAST_46
      IDBSEL = IDBSEL_46
      NDB = NDB_46
      IDCSEL = IDCSEL_46
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_ARC_STA), IBLSEL_G_46, &
     &     IBLSEL_G )
      CALL LIB$MOVC3 ( 2*INT4(ARC_STA_BIT_WORDS*MAX_ARC_STA), IBLSEL_P_46, &
     &     IBLSEL_P )
      CONSTRAINT_BITS = CONSTRAINT_BITS_46
      INDL = INDL_46
      CALL LIB$MOVC3 ( 2*INT4(MAX_ARC_STA), WVMASK_46, WVMASK  )
      BM_REF_CL = BM_REF_CL_46
      CALL LIB$MOVC3 ( 2*2, NROT_A1_46, NROT_A1 )
      CALL LIB$MOVC3 ( 2*2, EOP_STYLE_46, EOP_STYLE  )
      CALL LIB$MOVC3 ( 2*2, EOPA1_CHOICE_46, EOPA1_CHOICE )
      IEOPL = IEOPL_46
      NUMSTAX = NUMSTAX_46
      INTERPOLATION_UT1 = INTERPOLATION_UT1_46
      INTERPOLATION_PM = INTERPOLATION_PM_46
      BGROUND = BGROUND_46
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_46), LPROP_46(1,1), LPROP(1,1) )
      CALL LIB$MOVC3 ( 2*INT4(SRC_BIT_WORDS_46), LPROP_46(1,2), LPROP(1,2) )
      TOTSTA = TOTSTA_46
      CALL LIB$MOVC3 ( 2*2, LGRAD_46, LGRAD  )
      INIT_INTERACTIVE = INIT_INTERACTIVE_46
      CALL LIB$MOVC3 ( 2*2, CLOCK_REF_BITS_46, CLOCK_REF_BITS  )
      IDBEST = IDBEST_46
      OPP_STATUS = OPP_STATUS_46
      PAMB_STATUS = PAMB_STATUS_46
      SUPMET = SUPMET_46
      CALL LIB$MOVC3 ( 2*INT4(SOCOM_IFREE_LEN), IFREE_SOCOM_46, IFREE_SOCOM  )
      SOCOM_LAST_I2 = SOCOM_LAST_I2_46
!
! --- INTEGER*4
!
      NUMOBS = NUMOBS_46
      CALL LIB$MOVC3 ( 4*INT4(MAX_DBS), IDBEND_46, IDBEND  )
      NUMSCA = NUMSCA_46
      STABIT_G(1) = STABIT_G_46(1)
      STABIT_G(2) = STABIT_G_46(2)
      STABIT_P(1) = STABIT_P_46(1)
      STABIT_P(2) = STABIT_P_46(2)
!
      RETURN
      END  !#!  COMMON_46_TO_58  #!#
