      SUBROUTINE USE_ARCF_MAT(MAT,NP,STRING)
      IMPLICIT NONE
!
! 1.  USE_ARCF_MAT PROGRAM SPECIFICATION
!
! 1.1 Access an ARCFIL's matrix.
!
! 1.2 REFERENCES:
!
! 2.  USE_ARCF_MAT INTERFACE
!
! 2.1 Parameter File
      INCLUDE 'solve.i'
!
! 2.2 INPUT Variables:
!
      CHARACTER*(*) STRING
      INTEGER*4 NP
      REAL*8 MAT(*)
!
! MAT - The matrix
! NP - Number of parameters
! STRING - Requested access type
!
! 2.3 OUTPUT Variables: None
!
! 2.4 COMMON BLOCKS USED
      CHARACTER*(NAME_SIZE) SAVNAM
      INTEGER*4 FILDES
      INTEGER*2 IDIRECT(BLOCK_WORDS)
      LOGICAL*2 KSCOM
      COMMON/SAVARC/FILDES,IDIRECT,KSCOM
      COMMON/NAMARC/SAVNAM
      SAVE /SAVARC/,/NAMARC/
!
! 2.5 SUBROUTINE INTERFACE
!
!       CALLING SUBROUTINES:
!       CALLED SUBROUTINES: cgm_mat,use_file
!
! 3.  LOCAL VARIABLES
!
      INTEGER*4 JRND_BLOCKS,MAT_E,JB
      INTEGER*4 I4P1
      INTEGER*8 LEN8_BYTES, LEN8_BLOCKS 
      INTEGER*8, EXTERNAL :: MAT_E4
      DATA  I4P1 / 1 /
!
! JB - Number of blocks to be read or written
!
! 4.  HISTORY
!   WHO   WHEN   WHAT
!
! 5.  USE_ARCF_MAT PROGRAM STRUCTURE
!
      IF ( KSCOM ) THEN
           CALL CGM_MAT(IDIRECT,SAVNAM,FILDES,MAT,NP,STRING)
        ELSE
!@        JB=JRND_BLOCKS(MAT_E(MAX_PAR,NP)*REALL_WORDS)
!@        CALL USE_FILE(SAVNAM,FILDES,MAT,JB,I4P1,STRING)
!
         LEN8_BYTES  = 8*MAT_E4(M_GPA, NP)
         LEN8_BLOCKS = (LEN8_BYTES+INT8(255))/INT8(256)
         CALL USE_FILE8 ( SAVNAM, FILDES, MAT, LEN8_BLOCKS, INT8(1), STRING )
      ENDIF
!
      RETURN
      END
