      SUBROUTINE IONO_WRI ( NOBS, MODE, PRG_NAM, IONO_FRQ_AVR, &
     &                      EXP_NAME, VERS, IONO, FILOUT, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine IONO_WRI
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ###  14-JUL-2020   IONO_WRI   v2.0 (d)   L. Petrov  08-DEC-2022  ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'solve.i'
      INCLUDE   'iono_solve.i'
      INTEGER*4  NOBS, MODE, VERS, IUER
      CHARACTER  PRG_NAM*(*)
      REAL*8     IONO_FRQ_AVR
      TYPE     ( IONO_DEL__TYPE ) :: IONO(M_OBS)
      CHARACTER  EXP_NAME*(*), FILOUT*(*)
      CHARACTER  STR*128
      INTEGER*4  M_HEA
      PARAMETER  ( M_HEA= 32 )
      CHARACTER, ALLOCATABLE :: OUT(:)*80
      INTEGER*4  J1, J2, NO, IL, IER 
      CHARACTER, EXTERNAL :: GET_CDATE*19
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      ALLOCATE ( OUT(NOBS+M_HEA), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7331, IUER, 'IONO_WRI', 'Error in an attempt '// &
     &         'to allocate memory for array OUT' ) 
           RETURN 
      END IF
!
      NO = 0
      IF ( MODE == ION__WEI ) THEN
           NO = NO + 1; OUT(NO) = LABEL__ADDW
        ELSE IF ( MODE == ION__DEL ) THEN
           NO = NO + 1; OUT(NO) = LABEL__AOC
        ELSE IF ( MODE == ION__NOI ) THEN
           NO = NO + 1; OUT(NO) = LABEL__ADDW
      END IF
      NO = NO + 1; OUT(NO) = '#'
      NO = NO + 1; 
      IL = ILEN(EXP_NAME)
      IF ( IL < 10 ) IL = 10
      WRITE ( UNIT=OUT(NO), FMT=110 ) '# Experiment: '//EXP_NAME(1:IL)//' Version ', VERS, &
     &                                '  Nobs: ', NOBS
 110  FORMAT ( A, I3, A, I6 )
      NO = NO + 1; OUT(NO) = '#'
      CALL CLRCH ( STR )
      WRITE ( UNIT=STR, FMT='(1PD13.6)' ) IONO_FRQ_AVR
      CALL INCH ( IONO(1)%ISEED, STR(31:40) )
      NO = NO + 1; OUT(NO) = '# Generated by '//TRIM(PRG_NAM)
      NO = NO + 1; OUT(NO) = '# Average Ionospheric frequency: '//STR(1:13)
      NO = NO + 1; OUT(NO) = '# Seed: '//STR(31:40)
      IF ( MODE == ION__WEI ) THEN
          NO = NO + 1; OUT(NO) = '# File contains additive noise die to GNSS inospheric path delay errors'
        ELSE IF ( MODE == ION__DEL ) THEN
          NO = NO + 1; OUT(NO) = '# File contains GNSS inospheric path delay'
        ELSE IF ( MODE == ION__NOI ) THEN
          NO = NO + 1; OUT(NO) = '# File contains random noise with sigmas that corresponds to the GNSS inospheric path delay errors'
      END IF
      NO = NO + 1; OUT(NO) = '#'
      NO = NO + 1; OUT(NO) = '# Generated on '//GET_CDATE()
      NO = NO + 1; OUT(NO) = '#'
!
      DO 410 J1=1,NOBS
         NO = NO + 1
         IF ( MODE == ION__WEI ) THEN
              WRITE ( UNIT=OUT(NO), FMT=120 ) J1, IONO(J1)%ADD_IONO_SIG
 120          FORMAT ( 'Ind_obs: ', I6, ' Add_wei: ', 1PD13.6 )
            ELSE IF ( MODE == ION__DEL ) THEN
              WRITE ( UNIT=OUT(NO), FMT=130 ) J1, IONO(J1)%ADD_IONO_VAL
 130          FORMAT ( 'Ind_obs: ', I6, ' Add_del: ', 1PD13.6 )
            ELSE IF ( MODE == ION__NOI ) THEN
              WRITE ( UNIT=OUT(NO), FMT=130 ) J1, IONO(J1)%IONO_D
         END IF
 410  CONTINUE 
!
      CALL ERR_PASS ( IUER, IER )
      CALL WR_TEXT ( NO, OUT, FILOUT, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7332, IUER, 'IONO_WRI', 'Error in an attempt '// &
     &         'to write into the output file '//FILOUT )
           DEALLOCATE ( OUT )
           RETURN 
      END IF
      DEALLOCATE ( OUT )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  IONO_WRI  !#!  
