      SUBROUTINE WRI_ADD_IONO_WEI ( NOBS, MODE, PRG_NAM, IONO_FRQ_AVR, &
     &                              EXP_NAME, VERS, IONO, FILOUT, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine WRI_ADD_IONO_WEI
! *                                                                      *
! * ### 14-JUL-2020  WRI_ADD_IONO_WEI v1.2 (c) L. Petrov 26-SEP-2022 ### *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'iono_from_solve.i'
      INTEGER*4  NOBS, MODE, VERS, IUER
      CHARACTER  PRG_NAM*(*)
      REAL*8     IONO_FRQ_AVR
      TYPE     ( IONO__TYPE ) :: IONO(NOBS)
      CHARACTER  EXP_NAME*(*), FILOUT*(*)
      CHARACTER  STR*128
      INTEGER*4  M_HEA
      PARAMETER  ( M_HEA= 32 )
      CHARACTER, ALLOCATABLE :: OUT(:)*80
      INTEGER*4  J1, J2, NO, IL, IER 
      CHARACTER, EXTERNAL :: GET_CDATE*19
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      ALLOCATE ( OUT(NOBS+M_HEA), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7121, IUER, 'WRI_ADD_IONO_WEI', 'Error in an attempt '// &
     &         'to allocate memory for array OUT' ) 
           RETURN 
      END IF
!
      NO = 0
      IF ( MODE < 10 ) THEN
           NO = NO + 1; OUT(NO) = LABEL__ADDW
         ELSE IF ( MODE < 30 ) THEN
           NO = NO + 1; OUT(NO) = LABEL__AOC
      END IF
      NO = NO + 1; OUT(NO) = '#'
      NO = NO + 1; 
      IL = ILEN(EXP_NAME)
      IF ( IL < 10 ) IL = 10
      WRITE ( UNIT=OUT(NO), FMT=110 ) '# Experiment: '//EXP_NAME(1:IL)//' Version ', VERS, &
     &                                '  Nobs: ', NOBS
 110  FORMAT ( A, I3, A, I6 )
      NO = NO + 1; OUT(NO) = '#'
      CALL CLRCH ( STR )
      CALL INCH  ( MODE, STR )
      CALL CLRCH ( STR )
      WRITE ( UNIT=STR, FMT='(1PD13.6)' ) IONO_FRQ_AVR
      CALL INCH ( IONO%ISEED, STR(31:40) )
      NO = NO + 1; OUT(NO) = '# Generated by '//TRIM(PRG_NAM)
      NO = NO + 1; OUT(NO) = '# Average Ionospheric frequency: '//STR(1:13)
      NO = NO + 1; OUT(NO) = '# ISEED: '//STR(31:40)
      IF ( MOD((MODE+10),10) == 2 ) THEN
           NO = NO + 1; OUT(NO) = '# Baseline weights: account'
         ELSE
           NO = NO + 1; OUT(NO) = '# Baseline weights: ignore'
      END IF
!
      IF ( MODE > 10 .AND. MODE < 20 ) THEN
          NO = NO + 1; OUT(NO) = '# File contains GNSS inospheric path delay'
        ELSE IF ( MODE > 20 .AND. MODE < 30 ) THEN
          NO = NO + 1; OUT(NO) = '# File contains additive noise due to GNSS inospheric path delay errors'
      END IF
      NO = NO + 1; OUT(NO) = '#'
      NO = NO + 1; OUT(NO) = '# Generated on '//GET_CDATE()
      NO = NO + 1; OUT(NO) = '#'
!
      DO 410 J1=1,NOBS
         NO = NO + 1
         IF ( MODE < 10 ) THEN
              WRITE ( UNIT=OUT(NO), FMT=120 ) J1, IONO(J1)%ADD_IONO_SIG
 120          FORMAT ( 'Ind_obs: ', I6, ' Add_wei: ', 1PD13.6 )
            ELSE IF ( MODE < 20 ) THEN
              WRITE ( UNIT=OUT(NO), FMT=130 ) J1, IONO(J1)%ADD_IONO_VAL
 130          FORMAT ( 'Ind_obs: ', I6, ' Add_del: ', 1PD13.6 )
            ELSE IF ( MODE < 30 ) THEN
              WRITE ( UNIT=OUT(NO), FMT=130 ) J1, IONO(J1)%IONO_D
         END IF
 410  CONTINUE 
!
      CALL ERR_PASS ( IUER, IER )
      CALL WR_TEXT ( NO, OUT, FILOUT, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 7122, IUER, 'WRI_ADD_IONO_WEI', 'Error in an attempt '// &
     &         'to write into the output file '//FILOUT )
           DEALLOCATE ( OUT )
           RETURN 
      END IF
      DEALLOCATE ( OUT )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE  WRI_ADD_IONO_WEI  !#!  
