      SUBROUTINE SAMB_DO ( PIMA_CNT, FILRES, WIN_SEMI_WIDTH, SNR_MIN, &
     &                     NOBS_REFRI, FILTER_RULE, FILOUT, IUER )
! ************************************************************************
! *                                                                      *
! *   Routine  SAMB_DO 
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *  ### 08-FEB-2010    SAMB_DO    v1.3 (d)  L. Petrov  08-SEP-2024 ###  *
! *                                                                      *
! ************************************************************************
      IMPLICIT   NONE 
      INCLUDE   'solve.i'
      CHARACTER  PIMA_CNT*(*), FILRES*(*), FILTER_RULE*(*), FILOUT*(*)
      REAL*8     WIN_SEMI_WIDTH, SNR_MIN
      INTEGER*4  NOBS_REFRI, IUER
      CHARACTER  STR*128, STR_WIN*32, SOL_TYPE_LONG*21, STS_STR*2, STR_SNR*6
      CHARACTER, ALLOCATABLE :: BUF(:)*1024, OUT(:)*256
      INTEGER*2  DATYP_I2
      REAL*8     TAU_RES_SOLVE, TAU_RES_PIMA, TAU_OBS, GRAMB_SPC, SNR
      INTEGER*4  J1, J2, J3, IND_BND, NRES, NOUT, PIND_OBS, NUM_AMB, IQC, &
     &           UV_STA_ORDER, IER
      LOGICAL*4, EXTERNAL :: DATYP_INQ
      CHARACTER, EXTERNAL :: GET_CDATE*19
      INTEGER*4, EXTERNAL :: ILEN, I_LEN
!
      NOBS_REFRI = 0
      ALLOCATE ( BUF(MAX_OBS), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL CLRCH ( STR )
           CALL IINCH8 ( INT8(MAX_OBS)*INT8(LEN(BUF(1))), STR )
           CALL ERR_LOG ( 4411, IUER, 'SAMB_DO', 'Failure to allocate '// &
     &          STR(1:I_LEN(STR))//' bytes of dynamic memory for the '// &
     &          'buffer that will hold resudual file' )
           RETURN 
      END IF
!
      ALLOCATE ( OUT(MAX_OBS), STAT=IER )
      IF ( IER .NE. 0 ) THEN
           CALL CLRCH ( STR )
           CALL IINCH ( MAX_OBS*LEN(OUT(1)), STR )
           CALL ERR_LOG ( 4412, IUER, 'SAMB_DO', 'Failure to allocate '// &
     &          STR(1:I_LEN(STR))//' bytes of dynamic memory for the '// &
     &          'buffer that will hold residual file' )
           RETURN 
      END IF
!
      CALL ERR_PASS ( IUER, IER )
      CALL RD_TEXT  ( FILRES, MAX_OBS, BUF, NRES, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 4413, IUER, 'SAMB_DO', 'Failure in an attempt '// &
     &         'to read residuals file '//FILRES )
           RETURN 
      END IF
!
      WRITE ( UNIT=STR_WIN, FMT='(F12.3)' ) WIN_SEMI_WIDTH*1.D9
      CALL CHASHL ( STR_WIN )
      WRITE ( UNIT=STR_SNR, FMT='(F6.3)' ) SNR_MIN
      CALL CHASHL ( STR_SNR )
      OUT(1) = '#!/bin/csh -f'
      OUT(2) = '#'
      OUT(3) = '# Generated by SAMB on '//GET_CDATE()
      OUT(4) = '#'
      OUT(5) = '# samb -p '//PIMA_CNT(1:I_LEN(PIMA_CNT))// &
     &         ' -r '//FILRES(1:I_LEN(FILRES))// &
     &         ' -w '//STR_WIN(1:I_LEN(STR_WIN))// &
     &         ' -s '//STR_SNR(1:I_LEN(STR_SNR))// &
     &         ' -f '//FILTER_RULE(1:I_LEN(FILTER_RULE))// &
     &         ' -o '//FILOUT(1:I_LEN(FILOUT))
      OUT(6) = '#'
      NOUT = 6
!
      WRITE ( UNIT=STR_WIN, FMT='(1PD16.8)' ) WIN_SEMI_WIDTH
      CALL CHASHL ( STR_WIN )
!
      DATYP_I2 = -1
      DO 410 J1=1,NRES
         IF ( BUF(J1)(1:15) == ' Solution type:' ) THEN
              SOL_TYPE_LONG = BUF(J1)(17:37) 
              IF ( SOL_TYPE_LONG == GRPRAT__DTC ) THEN
                   DATYP_I2 = GRPRAT__DTP
                 ELSE IF ( SOL_TYPE_LONG == PHSRAT__DTC ) THEN
                   DATYP_I2 = PHSRAT__DTP
                 ELSE IF ( SOL_TYPE_LONG == SNBRAT__DTC ) THEN
                   DATYP_I2 = SNBRAT__DTP
                 ELSE IF ( SOL_TYPE_LONG == GRPONL__DTC ) THEN
                   DATYP_I2 = GRPONL__DTP
                 ELSE IF ( SOL_TYPE_LONG == PHSONL__DTC ) THEN
                   DATYP_I2 = PHSONL__DTP
                 ELSE IF ( SOL_TYPE_LONG == SNBONL__DTC ) THEN
                   DATYP_I2 = SNBONL__DTP
                 ELSE IF ( SOL_TYPE_LONG == RATONL__DTC ) THEN
                   DATYP_I2 = RATONL__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  G_GXS__DTC ) THEN
                   DATYP_I2 =  G_GXS__DTP
                 ELSE IF ( SOL_TYPE_LONG == PX_GXS__DTC ) THEN
                   DATYP_I2 = PX_GXS__DTP
                 ELSE IF ( SOL_TYPE_LONG == PS_GXS__DTC ) THEN
                   DATYP_I2 = PS_GXS__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  PX_GX__DTC ) THEN
                   DATYP_I2 =  PX_GX__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  PX_GS__DTC ) THEN
                   DATYP_I2 =  PX_GS__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  PS_GX__DTC ) THEN
                   DATYP_I2 =  PS_GX__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  PS_GS__DTC ) THEN
                   DATYP_I2 =  PS_GS__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  P_PXS__DTC ) THEN
                   DATYP_I2 =  P_PXS__DTP
                 ELSE IF ( SOL_TYPE_LONG ==     GX__DTC ) THEN
                   DATYP_I2 =     GX__DTP
                 ELSE IF ( SOL_TYPE_LONG ==     GS__DTC ) THEN
                   DATYP_I2 =     GS__DTP
                 ELSE IF ( SOL_TYPE_LONG ==     PX__DTC ) THEN
                   DATYP_I2 =     PX__DTP
                 ELSE IF ( SOL_TYPE_LONG ==     PS__DTC ) THEN
                   DATYP_I2 =     PS__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  SNG_X__DTC ) THEN
                   DATYP_I2 =  SNG_X__DTP
                 ELSE IF ( SOL_TYPE_LONG ==  SNG_S__DTC ) THEN
                   DATYP_I2 =  SNG_S__DTP
                 ELSE 
                   CALL ERR_LOG ( 4413, IUER, 'SAMB_DO', 'Failure in '// &
     &                 'parsing residuals file '//FILRES(1:I_LEN(FILRES))// &
     &                 'line '//BUF(J1)(1:I_LEN(BUF(J1)))// &
     &                 ' -- unsupported solution type' )
                   RETURN 
              END IF
         END IF
410  CONTINUE 
!
      IF ( DATYP_I2 == -1 ) THEN
           CALL ERR_LOG ( 4414, IUER, 'SAMB_DO', 'Failure in parsing '// &
     &         'residuals file '//FILRES(1:I_LEN(FILRES))// &
     &         ' -- no solution type was found' )
           RETURN 
      END IF
      IF ( DATYP_INQ ( DATYP_I2, SBAND__DTP ) ) THEN
           IND_BND = 2
         ELSE
           IND_BND = 1
      END IF
!
      DO 420 J2=1,NRES
         IF ( BUF(J2)(379:380) == '@@' ) THEN
              IF ( ILEN(BUF(J2)) < 507 ) THEN
                   READ ( UNIT=BUF(J2)(73:80), FMT='(F8.0)', IOSTAT=IER ) TAU_RES_SOLVE
                   IF ( IER .NE. 0 ) GOTO 420
                   TAU_RES_SOLVE = TAU_RES_SOLVE*1.D-12
                 ELSE 
                   READ ( UNIT=BUF(J2)(489:507), FMT='(1PD20.12)', IOSTAT=IER ) TAU_RES_SOLVE
              END IF
              READ ( UNIT=BUF(J2)(196:211), FMT='(F16.13)', IOSTAT=IER ) TAU_OBS
              READ ( UNIT=BUF(J2)(452:453), FMT='(I2)',     IOSTAT=IER ) UV_STA_ORDER
              READ ( UNIT=BUF(J2)(477:482), FMT='(I6)',     IOSTAT=IER ) PIND_OBS
              STS_STR = BUF(J2)(485:486)
!
              IF ( BUF(J2)(430:438) == '*********' ) BUF(J2)(430:438) = '    1.D-4'
              IF ( BUF(J2)(441:449) == '*********' ) BUF(J2)(441:449) = '    1.D-4'
!
              IF ( IND_BND == 1 ) THEN
                   READ ( UNIT=BUF(J2)(394:409), FMT='(D16.8)', IOSTAT=IER ) TAU_RES_PIMA
                   READ ( UNIT=BUF(J2)(189:193), FMT='(I5)',    IOSTAT=IER ) NUM_AMB
                   READ ( UNIT=BUF(J2)(430:438), FMT='(F9.4)',  IOSTAT=IER ) GRAMB_SPC
                   READ ( UNIT=BUF(J2)(150:150), FMT='(I1)',    IOSTAT=IER ) IQC
                   IF ( IER .NE. 0 ) IQC = -1
                   READ ( UNIT=BUF(J2)(155:160), FMT='(F6.1)',  IOSTAT=IER ) SNR
                   GRAMB_SPC = GRAMB_SPC*1.D-9
                 ELSE IF ( IND_BND == 2 ) THEN
                   READ ( UNIT=BUF(J2)(412:427), FMT='(D16.8)', IOSTAT=IER ) TAU_RES_PIMA
                   READ ( UNIT=BUF(J2)(214:218), FMT='(I5)',    IOSTAT=IER ) NUM_AMB
                   READ ( UNIT=BUF(J2)(441:449), FMT='(F9.4)',  IOSTAT=IER ) GRAMB_SPC
                   READ ( UNIT=BUF(J2)(153:153), FMT='(I1)',    IOSTAT=IER ) IQC
                   IF ( IER .NE. 0 ) IQC = -1
                   READ ( UNIT=BUF(J2)(164:169), FMT='(F6.1)',  IOSTAT=IER ) SNR
                   GRAMB_SPC = GRAMB_SPC*1.D-9
              END IF
              IF ( IQC < 0       ) GOTO 420
              IF ( FILTER_RULE == 'MARKED_ONLY' ) THEN
                   IF ( BUF(J2)(8:9) .NE. 'R ' ) GOTO 420
              END IF
              IF ( BUF(J2)(8:8) .NE. 'R'  .AND.  SNR < SNR_MIN ) GOTO 420
              IF ( BUF(J2)(8:8) .EQ. 'R' .OR. &
     &             ( STS_STR == '  ' .AND. &
     &               ( DABS(TAU_RES_SOLVE) > WIN_SEMI_WIDTH .OR. &
     &                 NUM_AMB .NE. 0                            ) ) ) THEN
!
! ---------------- Either outlier, or group delay ambiguity
!
                   WRITE ( UNIT=STR(1:16), FMT='(1PD16.8)' ) TAU_RES_PIMA - &
     &                     UV_STA_ORDER*(TAU_RES_SOLVE - NUM_AMB*GRAMB_SPC) 
                   CALL CHASHR ( STR(1:16) )
!
                   NOBS_REFRI = NOBS_REFRI + 1
                   NOUT = NOUT + 1
                   OUT(NOUT) = 'pima '//PIMA_CNT(1:I_LEN(PIMA_CNT))//' frib '// &
     &                         'FRIB.OBS: '//BUF(J2)(477:482)//' '// &
     &                         'FRIB.DELAY_WINDOW_CENTER: '//STR(1:16)//' '// &
     &                         'FRIB.DELAY_WINDOW_WIDTH: '//STR_WIN(1:I_LEN(STR_WIN))//' '// &
     &                         'FRIB.SECONDARY_MAX_TRIES: 1'
              END IF
         END IF
 420  CONTINUE 
!
      CALL ERR_PASS ( IUER, IER )
      CALL WR_TEXT  ( NOUT, OUT, FILOUT, IER )
      IF ( IER .NE. 0 ) THEN
           CALL ERR_LOG ( 4414, IUER, 'SAMB_DO', 'Failure in writing '// &
     &         'output file '//FILOUT )
           RETURN 
      END IF
      CALL SYSTEM ( 'chmod o+x,u+x,g+x '//FILOUT(1:I_LEN(FILOUT))//CHAR(0) )
!
      CALL ERR_LOG ( 0, IUER )
      RETURN
      END  SUBROUTINE SAMB_DO  !#!#
