#include <mk5_preprocessor_directives.inc>
      SUBROUTINE MUL_MM_SS_S_13 ( A, B, C )
! ************************************************************************
! *                                                                      *
! *   Compute a product of two square symmetric matrices in upper        *
! *   triangular representation.                                         *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! *   Copyright (c) 1975-2025 United States Government as represented by *
! *   the Administrator of the National Aeronautics and Space            *
! *   Administration. All Rights Reserved.                               *
! *   License: NASA Open Source Software Agreement (NOSA).               *
! *                                                                      *
! * ### Source code was created automatically                         ## *
! * ### Generator: INVS_GENERATOR (c) L. Petrov version of 2002.12.14 ## *
! *                                                                      *
! ************************************************************************
      REAL*8     A(*), B(*), C(*)
!
      C( 1 ) = A( 1 ) * B( 1 )
      C( 1 ) = C( 1 ) + A( 2 ) * B( 2 )
      C( 1 ) = C( 1 ) + A( 4 ) * B( 4 )
      C( 1 ) = C( 1 ) + A( 7 ) * B( 7 )
      C( 1 ) = C( 1 ) + A( 11 ) * B( 11 )
      C( 1 ) = C( 1 ) + A( 16 ) * B( 16 )
      C( 1 ) = C( 1 ) + A( 22 ) * B( 22 )
      C( 1 ) = C( 1 ) + A( 29 ) * B( 29 )
      C( 1 ) = C( 1 ) + A( 37 ) * B( 37 )
      C( 1 ) = C( 1 ) + A( 46 ) * B( 46 )
      C( 1 ) = C( 1 ) + A( 56 ) * B( 56 )
      C( 1 ) = C( 1 ) + A( 67 ) * B( 67 )
      C( 1 ) = C( 1 ) + A( 79 ) * B( 79 )
!
      C( 2 ) = A( 2 ) * B( 1 )
      C( 2 ) = C( 2 ) + A( 3 ) * B( 2 )
      C( 2 ) = C( 2 ) + A( 5 ) * B( 4 )
      C( 2 ) = C( 2 ) + A( 8 ) * B( 7 )
      C( 2 ) = C( 2 ) + A( 12 ) * B( 11 )
      C( 2 ) = C( 2 ) + A( 17 ) * B( 16 )
      C( 2 ) = C( 2 ) + A( 23 ) * B( 22 )
      C( 2 ) = C( 2 ) + A( 30 ) * B( 29 )
      C( 2 ) = C( 2 ) + A( 38 ) * B( 37 )
      C( 2 ) = C( 2 ) + A( 47 ) * B( 46 )
      C( 2 ) = C( 2 ) + A( 57 ) * B( 56 )
      C( 2 ) = C( 2 ) + A( 68 ) * B( 67 )
      C( 2 ) = C( 2 ) + A( 80 ) * B( 79 )
!
      C( 3 ) = A( 2 ) * B( 2 )
      C( 3 ) = C( 3 ) + A( 3 ) * B( 3 )
      C( 3 ) = C( 3 ) + A( 5 ) * B( 5 )
      C( 3 ) = C( 3 ) + A( 8 ) * B( 8 )
      C( 3 ) = C( 3 ) + A( 12 ) * B( 12 )
      C( 3 ) = C( 3 ) + A( 17 ) * B( 17 )
      C( 3 ) = C( 3 ) + A( 23 ) * B( 23 )
      C( 3 ) = C( 3 ) + A( 30 ) * B( 30 )
      C( 3 ) = C( 3 ) + A( 38 ) * B( 38 )
      C( 3 ) = C( 3 ) + A( 47 ) * B( 47 )
      C( 3 ) = C( 3 ) + A( 57 ) * B( 57 )
      C( 3 ) = C( 3 ) + A( 68 ) * B( 68 )
      C( 3 ) = C( 3 ) + A( 80 ) * B( 80 )
!
      C( 4 ) = A( 4 ) * B( 1 )
      C( 4 ) = C( 4 ) + A( 5 ) * B( 2 )
      C( 4 ) = C( 4 ) + A( 6 ) * B( 4 )
      C( 4 ) = C( 4 ) + A( 9 ) * B( 7 )
      C( 4 ) = C( 4 ) + A( 13 ) * B( 11 )
      C( 4 ) = C( 4 ) + A( 18 ) * B( 16 )
      C( 4 ) = C( 4 ) + A( 24 ) * B( 22 )
      C( 4 ) = C( 4 ) + A( 31 ) * B( 29 )
      C( 4 ) = C( 4 ) + A( 39 ) * B( 37 )
      C( 4 ) = C( 4 ) + A( 48 ) * B( 46 )
      C( 4 ) = C( 4 ) + A( 58 ) * B( 56 )
      C( 4 ) = C( 4 ) + A( 69 ) * B( 67 )
      C( 4 ) = C( 4 ) + A( 81 ) * B( 79 )
!
      C( 5 ) = A( 4 ) * B( 2 )
      C( 5 ) = C( 5 ) + A( 5 ) * B( 3 )
      C( 5 ) = C( 5 ) + A( 6 ) * B( 5 )
      C( 5 ) = C( 5 ) + A( 9 ) * B( 8 )
      C( 5 ) = C( 5 ) + A( 13 ) * B( 12 )
      C( 5 ) = C( 5 ) + A( 18 ) * B( 17 )
      C( 5 ) = C( 5 ) + A( 24 ) * B( 23 )
      C( 5 ) = C( 5 ) + A( 31 ) * B( 30 )
      C( 5 ) = C( 5 ) + A( 39 ) * B( 38 )
      C( 5 ) = C( 5 ) + A( 48 ) * B( 47 )
      C( 5 ) = C( 5 ) + A( 58 ) * B( 57 )
      C( 5 ) = C( 5 ) + A( 69 ) * B( 68 )
      C( 5 ) = C( 5 ) + A( 81 ) * B( 80 )
!
      C( 6 ) = A( 4 ) * B( 4 )
      C( 6 ) = C( 6 ) + A( 5 ) * B( 5 )
      C( 6 ) = C( 6 ) + A( 6 ) * B( 6 )
      C( 6 ) = C( 6 ) + A( 9 ) * B( 9 )
      C( 6 ) = C( 6 ) + A( 13 ) * B( 13 )
      C( 6 ) = C( 6 ) + A( 18 ) * B( 18 )
      C( 6 ) = C( 6 ) + A( 24 ) * B( 24 )
      C( 6 ) = C( 6 ) + A( 31 ) * B( 31 )
      C( 6 ) = C( 6 ) + A( 39 ) * B( 39 )
      C( 6 ) = C( 6 ) + A( 48 ) * B( 48 )
      C( 6 ) = C( 6 ) + A( 58 ) * B( 58 )
      C( 6 ) = C( 6 ) + A( 69 ) * B( 69 )
      C( 6 ) = C( 6 ) + A( 81 ) * B( 81 )
!
      C( 7 ) = A( 7 ) * B( 1 )
      C( 7 ) = C( 7 ) + A( 8 ) * B( 2 )
      C( 7 ) = C( 7 ) + A( 9 ) * B( 4 )
      C( 7 ) = C( 7 ) + A( 10 ) * B( 7 )
      C( 7 ) = C( 7 ) + A( 14 ) * B( 11 )
      C( 7 ) = C( 7 ) + A( 19 ) * B( 16 )
      C( 7 ) = C( 7 ) + A( 25 ) * B( 22 )
      C( 7 ) = C( 7 ) + A( 32 ) * B( 29 )
      C( 7 ) = C( 7 ) + A( 40 ) * B( 37 )
      C( 7 ) = C( 7 ) + A( 49 ) * B( 46 )
      C( 7 ) = C( 7 ) + A( 59 ) * B( 56 )
      C( 7 ) = C( 7 ) + A( 70 ) * B( 67 )
      C( 7 ) = C( 7 ) + A( 82 ) * B( 79 )
!
      C( 8 ) = A( 7 ) * B( 2 )
      C( 8 ) = C( 8 ) + A( 8 ) * B( 3 )
      C( 8 ) = C( 8 ) + A( 9 ) * B( 5 )
      C( 8 ) = C( 8 ) + A( 10 ) * B( 8 )
      C( 8 ) = C( 8 ) + A( 14 ) * B( 12 )
      C( 8 ) = C( 8 ) + A( 19 ) * B( 17 )
      C( 8 ) = C( 8 ) + A( 25 ) * B( 23 )
      C( 8 ) = C( 8 ) + A( 32 ) * B( 30 )
      C( 8 ) = C( 8 ) + A( 40 ) * B( 38 )
      C( 8 ) = C( 8 ) + A( 49 ) * B( 47 )
      C( 8 ) = C( 8 ) + A( 59 ) * B( 57 )
      C( 8 ) = C( 8 ) + A( 70 ) * B( 68 )
      C( 8 ) = C( 8 ) + A( 82 ) * B( 80 )
!
      C( 9 ) = A( 7 ) * B( 4 )
      C( 9 ) = C( 9 ) + A( 8 ) * B( 5 )
      C( 9 ) = C( 9 ) + A( 9 ) * B( 6 )
      C( 9 ) = C( 9 ) + A( 10 ) * B( 9 )
      C( 9 ) = C( 9 ) + A( 14 ) * B( 13 )
      C( 9 ) = C( 9 ) + A( 19 ) * B( 18 )
      C( 9 ) = C( 9 ) + A( 25 ) * B( 24 )
      C( 9 ) = C( 9 ) + A( 32 ) * B( 31 )
      C( 9 ) = C( 9 ) + A( 40 ) * B( 39 )
      C( 9 ) = C( 9 ) + A( 49 ) * B( 48 )
      C( 9 ) = C( 9 ) + A( 59 ) * B( 58 )
      C( 9 ) = C( 9 ) + A( 70 ) * B( 69 )
      C( 9 ) = C( 9 ) + A( 82 ) * B( 81 )
!
      C( 10 ) = A( 7 ) * B( 7 )
      C( 10 ) = C( 10 ) + A( 8 ) * B( 8 )
      C( 10 ) = C( 10 ) + A( 9 ) * B( 9 )
      C( 10 ) = C( 10 ) + A( 10 ) * B( 10 )
      C( 10 ) = C( 10 ) + A( 14 ) * B( 14 )
      C( 10 ) = C( 10 ) + A( 19 ) * B( 19 )
      C( 10 ) = C( 10 ) + A( 25 ) * B( 25 )
      C( 10 ) = C( 10 ) + A( 32 ) * B( 32 )
      C( 10 ) = C( 10 ) + A( 40 ) * B( 40 )
      C( 10 ) = C( 10 ) + A( 49 ) * B( 49 )
      C( 10 ) = C( 10 ) + A( 59 ) * B( 59 )
      C( 10 ) = C( 10 ) + A( 70 ) * B( 70 )
      C( 10 ) = C( 10 ) + A( 82 ) * B( 82 )
!
      C( 11 ) = A( 11 ) * B( 1 )
      C( 11 ) = C( 11 ) + A( 12 ) * B( 2 )
      C( 11 ) = C( 11 ) + A( 13 ) * B( 4 )
      C( 11 ) = C( 11 ) + A( 14 ) * B( 7 )
      C( 11 ) = C( 11 ) + A( 15 ) * B( 11 )
      C( 11 ) = C( 11 ) + A( 20 ) * B( 16 )
      C( 11 ) = C( 11 ) + A( 26 ) * B( 22 )
      C( 11 ) = C( 11 ) + A( 33 ) * B( 29 )
      C( 11 ) = C( 11 ) + A( 41 ) * B( 37 )
      C( 11 ) = C( 11 ) + A( 50 ) * B( 46 )
      C( 11 ) = C( 11 ) + A( 60 ) * B( 56 )
      C( 11 ) = C( 11 ) + A( 71 ) * B( 67 )
      C( 11 ) = C( 11 ) + A( 83 ) * B( 79 )
!
      C( 12 ) = A( 11 ) * B( 2 )
      C( 12 ) = C( 12 ) + A( 12 ) * B( 3 )
      C( 12 ) = C( 12 ) + A( 13 ) * B( 5 )
      C( 12 ) = C( 12 ) + A( 14 ) * B( 8 )
      C( 12 ) = C( 12 ) + A( 15 ) * B( 12 )
      C( 12 ) = C( 12 ) + A( 20 ) * B( 17 )
      C( 12 ) = C( 12 ) + A( 26 ) * B( 23 )
      C( 12 ) = C( 12 ) + A( 33 ) * B( 30 )
      C( 12 ) = C( 12 ) + A( 41 ) * B( 38 )
      C( 12 ) = C( 12 ) + A( 50 ) * B( 47 )
      C( 12 ) = C( 12 ) + A( 60 ) * B( 57 )
      C( 12 ) = C( 12 ) + A( 71 ) * B( 68 )
      C( 12 ) = C( 12 ) + A( 83 ) * B( 80 )
!
      C( 13 ) = A( 11 ) * B( 4 )
      C( 13 ) = C( 13 ) + A( 12 ) * B( 5 )
      C( 13 ) = C( 13 ) + A( 13 ) * B( 6 )
      C( 13 ) = C( 13 ) + A( 14 ) * B( 9 )
      C( 13 ) = C( 13 ) + A( 15 ) * B( 13 )
      C( 13 ) = C( 13 ) + A( 20 ) * B( 18 )
      C( 13 ) = C( 13 ) + A( 26 ) * B( 24 )
      C( 13 ) = C( 13 ) + A( 33 ) * B( 31 )
      C( 13 ) = C( 13 ) + A( 41 ) * B( 39 )
      C( 13 ) = C( 13 ) + A( 50 ) * B( 48 )
      C( 13 ) = C( 13 ) + A( 60 ) * B( 58 )
      C( 13 ) = C( 13 ) + A( 71 ) * B( 69 )
      C( 13 ) = C( 13 ) + A( 83 ) * B( 81 )
!
      C( 14 ) = A( 11 ) * B( 7 )
      C( 14 ) = C( 14 ) + A( 12 ) * B( 8 )
      C( 14 ) = C( 14 ) + A( 13 ) * B( 9 )
      C( 14 ) = C( 14 ) + A( 14 ) * B( 10 )
      C( 14 ) = C( 14 ) + A( 15 ) * B( 14 )
      C( 14 ) = C( 14 ) + A( 20 ) * B( 19 )
      C( 14 ) = C( 14 ) + A( 26 ) * B( 25 )
      C( 14 ) = C( 14 ) + A( 33 ) * B( 32 )
      C( 14 ) = C( 14 ) + A( 41 ) * B( 40 )
      C( 14 ) = C( 14 ) + A( 50 ) * B( 49 )
      C( 14 ) = C( 14 ) + A( 60 ) * B( 59 )
      C( 14 ) = C( 14 ) + A( 71 ) * B( 70 )
      C( 14 ) = C( 14 ) + A( 83 ) * B( 82 )
!
      C( 15 ) = A( 11 ) * B( 11 )
      C( 15 ) = C( 15 ) + A( 12 ) * B( 12 )
      C( 15 ) = C( 15 ) + A( 13 ) * B( 13 )
      C( 15 ) = C( 15 ) + A( 14 ) * B( 14 )
      C( 15 ) = C( 15 ) + A( 15 ) * B( 15 )
      C( 15 ) = C( 15 ) + A( 20 ) * B( 20 )
      C( 15 ) = C( 15 ) + A( 26 ) * B( 26 )
      C( 15 ) = C( 15 ) + A( 33 ) * B( 33 )
      C( 15 ) = C( 15 ) + A( 41 ) * B( 41 )
      C( 15 ) = C( 15 ) + A( 50 ) * B( 50 )
      C( 15 ) = C( 15 ) + A( 60 ) * B( 60 )
      C( 15 ) = C( 15 ) + A( 71 ) * B( 71 )
      C( 15 ) = C( 15 ) + A( 83 ) * B( 83 )
!
      C( 16 ) = A( 16 ) * B( 1 )
      C( 16 ) = C( 16 ) + A( 17 ) * B( 2 )
      C( 16 ) = C( 16 ) + A( 18 ) * B( 4 )
      C( 16 ) = C( 16 ) + A( 19 ) * B( 7 )
      C( 16 ) = C( 16 ) + A( 20 ) * B( 11 )
      C( 16 ) = C( 16 ) + A( 21 ) * B( 16 )
      C( 16 ) = C( 16 ) + A( 27 ) * B( 22 )
      C( 16 ) = C( 16 ) + A( 34 ) * B( 29 )
      C( 16 ) = C( 16 ) + A( 42 ) * B( 37 )
      C( 16 ) = C( 16 ) + A( 51 ) * B( 46 )
      C( 16 ) = C( 16 ) + A( 61 ) * B( 56 )
      C( 16 ) = C( 16 ) + A( 72 ) * B( 67 )
      C( 16 ) = C( 16 ) + A( 84 ) * B( 79 )
!
      C( 17 ) = A( 16 ) * B( 2 )
      C( 17 ) = C( 17 ) + A( 17 ) * B( 3 )
      C( 17 ) = C( 17 ) + A( 18 ) * B( 5 )
      C( 17 ) = C( 17 ) + A( 19 ) * B( 8 )
      C( 17 ) = C( 17 ) + A( 20 ) * B( 12 )
      C( 17 ) = C( 17 ) + A( 21 ) * B( 17 )
      C( 17 ) = C( 17 ) + A( 27 ) * B( 23 )
      C( 17 ) = C( 17 ) + A( 34 ) * B( 30 )
      C( 17 ) = C( 17 ) + A( 42 ) * B( 38 )
      C( 17 ) = C( 17 ) + A( 51 ) * B( 47 )
      C( 17 ) = C( 17 ) + A( 61 ) * B( 57 )
      C( 17 ) = C( 17 ) + A( 72 ) * B( 68 )
      C( 17 ) = C( 17 ) + A( 84 ) * B( 80 )
!
      C( 18 ) = A( 16 ) * B( 4 )
      C( 18 ) = C( 18 ) + A( 17 ) * B( 5 )
      C( 18 ) = C( 18 ) + A( 18 ) * B( 6 )
      C( 18 ) = C( 18 ) + A( 19 ) * B( 9 )
      C( 18 ) = C( 18 ) + A( 20 ) * B( 13 )
      C( 18 ) = C( 18 ) + A( 21 ) * B( 18 )
      C( 18 ) = C( 18 ) + A( 27 ) * B( 24 )
      C( 18 ) = C( 18 ) + A( 34 ) * B( 31 )
      C( 18 ) = C( 18 ) + A( 42 ) * B( 39 )
      C( 18 ) = C( 18 ) + A( 51 ) * B( 48 )
      C( 18 ) = C( 18 ) + A( 61 ) * B( 58 )
      C( 18 ) = C( 18 ) + A( 72 ) * B( 69 )
      C( 18 ) = C( 18 ) + A( 84 ) * B( 81 )
!
      C( 19 ) = A( 16 ) * B( 7 )
      C( 19 ) = C( 19 ) + A( 17 ) * B( 8 )
      C( 19 ) = C( 19 ) + A( 18 ) * B( 9 )
      C( 19 ) = C( 19 ) + A( 19 ) * B( 10 )
      C( 19 ) = C( 19 ) + A( 20 ) * B( 14 )
      C( 19 ) = C( 19 ) + A( 21 ) * B( 19 )
      C( 19 ) = C( 19 ) + A( 27 ) * B( 25 )
      C( 19 ) = C( 19 ) + A( 34 ) * B( 32 )
      C( 19 ) = C( 19 ) + A( 42 ) * B( 40 )
      C( 19 ) = C( 19 ) + A( 51 ) * B( 49 )
      C( 19 ) = C( 19 ) + A( 61 ) * B( 59 )
      C( 19 ) = C( 19 ) + A( 72 ) * B( 70 )
      C( 19 ) = C( 19 ) + A( 84 ) * B( 82 )
!
      C( 20 ) = A( 16 ) * B( 11 )
      C( 20 ) = C( 20 ) + A( 17 ) * B( 12 )
      C( 20 ) = C( 20 ) + A( 18 ) * B( 13 )
      C( 20 ) = C( 20 ) + A( 19 ) * B( 14 )
      C( 20 ) = C( 20 ) + A( 20 ) * B( 15 )
      C( 20 ) = C( 20 ) + A( 21 ) * B( 20 )
      C( 20 ) = C( 20 ) + A( 27 ) * B( 26 )
      C( 20 ) = C( 20 ) + A( 34 ) * B( 33 )
      C( 20 ) = C( 20 ) + A( 42 ) * B( 41 )
      C( 20 ) = C( 20 ) + A( 51 ) * B( 50 )
      C( 20 ) = C( 20 ) + A( 61 ) * B( 60 )
      C( 20 ) = C( 20 ) + A( 72 ) * B( 71 )
      C( 20 ) = C( 20 ) + A( 84 ) * B( 83 )
!
      C( 21 ) = A( 16 ) * B( 16 )
      C( 21 ) = C( 21 ) + A( 17 ) * B( 17 )
      C( 21 ) = C( 21 ) + A( 18 ) * B( 18 )
      C( 21 ) = C( 21 ) + A( 19 ) * B( 19 )
      C( 21 ) = C( 21 ) + A( 20 ) * B( 20 )
      C( 21 ) = C( 21 ) + A( 21 ) * B( 21 )
      C( 21 ) = C( 21 ) + A( 27 ) * B( 27 )
      C( 21 ) = C( 21 ) + A( 34 ) * B( 34 )
      C( 21 ) = C( 21 ) + A( 42 ) * B( 42 )
      C( 21 ) = C( 21 ) + A( 51 ) * B( 51 )
      C( 21 ) = C( 21 ) + A( 61 ) * B( 61 )
      C( 21 ) = C( 21 ) + A( 72 ) * B( 72 )
      C( 21 ) = C( 21 ) + A( 84 ) * B( 84 )
!
      C( 22 ) = A( 22 ) * B( 1 )
      C( 22 ) = C( 22 ) + A( 23 ) * B( 2 )
      C( 22 ) = C( 22 ) + A( 24 ) * B( 4 )
      C( 22 ) = C( 22 ) + A( 25 ) * B( 7 )
      C( 22 ) = C( 22 ) + A( 26 ) * B( 11 )
      C( 22 ) = C( 22 ) + A( 27 ) * B( 16 )
      C( 22 ) = C( 22 ) + A( 28 ) * B( 22 )
      C( 22 ) = C( 22 ) + A( 35 ) * B( 29 )
      C( 22 ) = C( 22 ) + A( 43 ) * B( 37 )
      C( 22 ) = C( 22 ) + A( 52 ) * B( 46 )
      C( 22 ) = C( 22 ) + A( 62 ) * B( 56 )
      C( 22 ) = C( 22 ) + A( 73 ) * B( 67 )
      C( 22 ) = C( 22 ) + A( 85 ) * B( 79 )
!
      C( 23 ) = A( 22 ) * B( 2 )
      C( 23 ) = C( 23 ) + A( 23 ) * B( 3 )
      C( 23 ) = C( 23 ) + A( 24 ) * B( 5 )
      C( 23 ) = C( 23 ) + A( 25 ) * B( 8 )
      C( 23 ) = C( 23 ) + A( 26 ) * B( 12 )
      C( 23 ) = C( 23 ) + A( 27 ) * B( 17 )
      C( 23 ) = C( 23 ) + A( 28 ) * B( 23 )
      C( 23 ) = C( 23 ) + A( 35 ) * B( 30 )
      C( 23 ) = C( 23 ) + A( 43 ) * B( 38 )
      C( 23 ) = C( 23 ) + A( 52 ) * B( 47 )
      C( 23 ) = C( 23 ) + A( 62 ) * B( 57 )
      C( 23 ) = C( 23 ) + A( 73 ) * B( 68 )
      C( 23 ) = C( 23 ) + A( 85 ) * B( 80 )
!
      C( 24 ) = A( 22 ) * B( 4 )
      C( 24 ) = C( 24 ) + A( 23 ) * B( 5 )
      C( 24 ) = C( 24 ) + A( 24 ) * B( 6 )
      C( 24 ) = C( 24 ) + A( 25 ) * B( 9 )
      C( 24 ) = C( 24 ) + A( 26 ) * B( 13 )
      C( 24 ) = C( 24 ) + A( 27 ) * B( 18 )
      C( 24 ) = C( 24 ) + A( 28 ) * B( 24 )
      C( 24 ) = C( 24 ) + A( 35 ) * B( 31 )
      C( 24 ) = C( 24 ) + A( 43 ) * B( 39 )
      C( 24 ) = C( 24 ) + A( 52 ) * B( 48 )
      C( 24 ) = C( 24 ) + A( 62 ) * B( 58 )
      C( 24 ) = C( 24 ) + A( 73 ) * B( 69 )
      C( 24 ) = C( 24 ) + A( 85 ) * B( 81 )
!
      C( 25 ) = A( 22 ) * B( 7 )
      C( 25 ) = C( 25 ) + A( 23 ) * B( 8 )
      C( 25 ) = C( 25 ) + A( 24 ) * B( 9 )
      C( 25 ) = C( 25 ) + A( 25 ) * B( 10 )
      C( 25 ) = C( 25 ) + A( 26 ) * B( 14 )
      C( 25 ) = C( 25 ) + A( 27 ) * B( 19 )
      C( 25 ) = C( 25 ) + A( 28 ) * B( 25 )
      C( 25 ) = C( 25 ) + A( 35 ) * B( 32 )
      C( 25 ) = C( 25 ) + A( 43 ) * B( 40 )
      C( 25 ) = C( 25 ) + A( 52 ) * B( 49 )
      C( 25 ) = C( 25 ) + A( 62 ) * B( 59 )
      C( 25 ) = C( 25 ) + A( 73 ) * B( 70 )
      C( 25 ) = C( 25 ) + A( 85 ) * B( 82 )
!
      C( 26 ) = A( 22 ) * B( 11 )
      C( 26 ) = C( 26 ) + A( 23 ) * B( 12 )
      C( 26 ) = C( 26 ) + A( 24 ) * B( 13 )
      C( 26 ) = C( 26 ) + A( 25 ) * B( 14 )
      C( 26 ) = C( 26 ) + A( 26 ) * B( 15 )
      C( 26 ) = C( 26 ) + A( 27 ) * B( 20 )
      C( 26 ) = C( 26 ) + A( 28 ) * B( 26 )
      C( 26 ) = C( 26 ) + A( 35 ) * B( 33 )
      C( 26 ) = C( 26 ) + A( 43 ) * B( 41 )
      C( 26 ) = C( 26 ) + A( 52 ) * B( 50 )
      C( 26 ) = C( 26 ) + A( 62 ) * B( 60 )
      C( 26 ) = C( 26 ) + A( 73 ) * B( 71 )
      C( 26 ) = C( 26 ) + A( 85 ) * B( 83 )
!
      C( 27 ) = A( 22 ) * B( 16 )
      C( 27 ) = C( 27 ) + A( 23 ) * B( 17 )
      C( 27 ) = C( 27 ) + A( 24 ) * B( 18 )
      C( 27 ) = C( 27 ) + A( 25 ) * B( 19 )
      C( 27 ) = C( 27 ) + A( 26 ) * B( 20 )
      C( 27 ) = C( 27 ) + A( 27 ) * B( 21 )
      C( 27 ) = C( 27 ) + A( 28 ) * B( 27 )
      C( 27 ) = C( 27 ) + A( 35 ) * B( 34 )
      C( 27 ) = C( 27 ) + A( 43 ) * B( 42 )
      C( 27 ) = C( 27 ) + A( 52 ) * B( 51 )
      C( 27 ) = C( 27 ) + A( 62 ) * B( 61 )
      C( 27 ) = C( 27 ) + A( 73 ) * B( 72 )
      C( 27 ) = C( 27 ) + A( 85 ) * B( 84 )
!
      C( 28 ) = A( 22 ) * B( 22 )
      C( 28 ) = C( 28 ) + A( 23 ) * B( 23 )
      C( 28 ) = C( 28 ) + A( 24 ) * B( 24 )
      C( 28 ) = C( 28 ) + A( 25 ) * B( 25 )
      C( 28 ) = C( 28 ) + A( 26 ) * B( 26 )
      C( 28 ) = C( 28 ) + A( 27 ) * B( 27 )
      C( 28 ) = C( 28 ) + A( 28 ) * B( 28 )
      C( 28 ) = C( 28 ) + A( 35 ) * B( 35 )
      C( 28 ) = C( 28 ) + A( 43 ) * B( 43 )
      C( 28 ) = C( 28 ) + A( 52 ) * B( 52 )
      C( 28 ) = C( 28 ) + A( 62 ) * B( 62 )
      C( 28 ) = C( 28 ) + A( 73 ) * B( 73 )
      C( 28 ) = C( 28 ) + A( 85 ) * B( 85 )
!
      C( 29 ) = A( 29 ) * B( 1 )
      C( 29 ) = C( 29 ) + A( 30 ) * B( 2 )
      C( 29 ) = C( 29 ) + A( 31 ) * B( 4 )
      C( 29 ) = C( 29 ) + A( 32 ) * B( 7 )
      C( 29 ) = C( 29 ) + A( 33 ) * B( 11 )
      C( 29 ) = C( 29 ) + A( 34 ) * B( 16 )
      C( 29 ) = C( 29 ) + A( 35 ) * B( 22 )
      C( 29 ) = C( 29 ) + A( 36 ) * B( 29 )
      C( 29 ) = C( 29 ) + A( 44 ) * B( 37 )
      C( 29 ) = C( 29 ) + A( 53 ) * B( 46 )
      C( 29 ) = C( 29 ) + A( 63 ) * B( 56 )
      C( 29 ) = C( 29 ) + A( 74 ) * B( 67 )
      C( 29 ) = C( 29 ) + A( 86 ) * B( 79 )
!
      C( 30 ) = A( 29 ) * B( 2 )
      C( 30 ) = C( 30 ) + A( 30 ) * B( 3 )
      C( 30 ) = C( 30 ) + A( 31 ) * B( 5 )
      C( 30 ) = C( 30 ) + A( 32 ) * B( 8 )
      C( 30 ) = C( 30 ) + A( 33 ) * B( 12 )
      C( 30 ) = C( 30 ) + A( 34 ) * B( 17 )
      C( 30 ) = C( 30 ) + A( 35 ) * B( 23 )
      C( 30 ) = C( 30 ) + A( 36 ) * B( 30 )
      C( 30 ) = C( 30 ) + A( 44 ) * B( 38 )
      C( 30 ) = C( 30 ) + A( 53 ) * B( 47 )
      C( 30 ) = C( 30 ) + A( 63 ) * B( 57 )
      C( 30 ) = C( 30 ) + A( 74 ) * B( 68 )
      C( 30 ) = C( 30 ) + A( 86 ) * B( 80 )
!
      C( 31 ) = A( 29 ) * B( 4 )
      C( 31 ) = C( 31 ) + A( 30 ) * B( 5 )
      C( 31 ) = C( 31 ) + A( 31 ) * B( 6 )
      C( 31 ) = C( 31 ) + A( 32 ) * B( 9 )
      C( 31 ) = C( 31 ) + A( 33 ) * B( 13 )
      C( 31 ) = C( 31 ) + A( 34 ) * B( 18 )
      C( 31 ) = C( 31 ) + A( 35 ) * B( 24 )
      C( 31 ) = C( 31 ) + A( 36 ) * B( 31 )
      C( 31 ) = C( 31 ) + A( 44 ) * B( 39 )
      C( 31 ) = C( 31 ) + A( 53 ) * B( 48 )
      C( 31 ) = C( 31 ) + A( 63 ) * B( 58 )
      C( 31 ) = C( 31 ) + A( 74 ) * B( 69 )
      C( 31 ) = C( 31 ) + A( 86 ) * B( 81 )
!
      C( 32 ) = A( 29 ) * B( 7 )
      C( 32 ) = C( 32 ) + A( 30 ) * B( 8 )
      C( 32 ) = C( 32 ) + A( 31 ) * B( 9 )
      C( 32 ) = C( 32 ) + A( 32 ) * B( 10 )
      C( 32 ) = C( 32 ) + A( 33 ) * B( 14 )
      C( 32 ) = C( 32 ) + A( 34 ) * B( 19 )
      C( 32 ) = C( 32 ) + A( 35 ) * B( 25 )
      C( 32 ) = C( 32 ) + A( 36 ) * B( 32 )
      C( 32 ) = C( 32 ) + A( 44 ) * B( 40 )
      C( 32 ) = C( 32 ) + A( 53 ) * B( 49 )
      C( 32 ) = C( 32 ) + A( 63 ) * B( 59 )
      C( 32 ) = C( 32 ) + A( 74 ) * B( 70 )
      C( 32 ) = C( 32 ) + A( 86 ) * B( 82 )
!
      C( 33 ) = A( 29 ) * B( 11 )
      C( 33 ) = C( 33 ) + A( 30 ) * B( 12 )
      C( 33 ) = C( 33 ) + A( 31 ) * B( 13 )
      C( 33 ) = C( 33 ) + A( 32 ) * B( 14 )
      C( 33 ) = C( 33 ) + A( 33 ) * B( 15 )
      C( 33 ) = C( 33 ) + A( 34 ) * B( 20 )
      C( 33 ) = C( 33 ) + A( 35 ) * B( 26 )
      C( 33 ) = C( 33 ) + A( 36 ) * B( 33 )
      C( 33 ) = C( 33 ) + A( 44 ) * B( 41 )
      C( 33 ) = C( 33 ) + A( 53 ) * B( 50 )
      C( 33 ) = C( 33 ) + A( 63 ) * B( 60 )
      C( 33 ) = C( 33 ) + A( 74 ) * B( 71 )
      C( 33 ) = C( 33 ) + A( 86 ) * B( 83 )
!
      C( 34 ) = A( 29 ) * B( 16 )
      C( 34 ) = C( 34 ) + A( 30 ) * B( 17 )
      C( 34 ) = C( 34 ) + A( 31 ) * B( 18 )
      C( 34 ) = C( 34 ) + A( 32 ) * B( 19 )
      C( 34 ) = C( 34 ) + A( 33 ) * B( 20 )
      C( 34 ) = C( 34 ) + A( 34 ) * B( 21 )
      C( 34 ) = C( 34 ) + A( 35 ) * B( 27 )
      C( 34 ) = C( 34 ) + A( 36 ) * B( 34 )
      C( 34 ) = C( 34 ) + A( 44 ) * B( 42 )
      C( 34 ) = C( 34 ) + A( 53 ) * B( 51 )
      C( 34 ) = C( 34 ) + A( 63 ) * B( 61 )
      C( 34 ) = C( 34 ) + A( 74 ) * B( 72 )
      C( 34 ) = C( 34 ) + A( 86 ) * B( 84 )
!
      C( 35 ) = A( 29 ) * B( 22 )
      C( 35 ) = C( 35 ) + A( 30 ) * B( 23 )
      C( 35 ) = C( 35 ) + A( 31 ) * B( 24 )
      C( 35 ) = C( 35 ) + A( 32 ) * B( 25 )
      C( 35 ) = C( 35 ) + A( 33 ) * B( 26 )
      C( 35 ) = C( 35 ) + A( 34 ) * B( 27 )
      C( 35 ) = C( 35 ) + A( 35 ) * B( 28 )
      C( 35 ) = C( 35 ) + A( 36 ) * B( 35 )
      C( 35 ) = C( 35 ) + A( 44 ) * B( 43 )
      C( 35 ) = C( 35 ) + A( 53 ) * B( 52 )
      C( 35 ) = C( 35 ) + A( 63 ) * B( 62 )
      C( 35 ) = C( 35 ) + A( 74 ) * B( 73 )
      C( 35 ) = C( 35 ) + A( 86 ) * B( 85 )
!
      C( 36 ) = A( 29 ) * B( 29 )
      C( 36 ) = C( 36 ) + A( 30 ) * B( 30 )
      C( 36 ) = C( 36 ) + A( 31 ) * B( 31 )
      C( 36 ) = C( 36 ) + A( 32 ) * B( 32 )
      C( 36 ) = C( 36 ) + A( 33 ) * B( 33 )
      C( 36 ) = C( 36 ) + A( 34 ) * B( 34 )
      C( 36 ) = C( 36 ) + A( 35 ) * B( 35 )
      C( 36 ) = C( 36 ) + A( 36 ) * B( 36 )
      C( 36 ) = C( 36 ) + A( 44 ) * B( 44 )
      C( 36 ) = C( 36 ) + A( 53 ) * B( 53 )
      C( 36 ) = C( 36 ) + A( 63 ) * B( 63 )
      C( 36 ) = C( 36 ) + A( 74 ) * B( 74 )
      C( 36 ) = C( 36 ) + A( 86 ) * B( 86 )
!
      C( 37 ) = A( 37 ) * B( 1 )
      C( 37 ) = C( 37 ) + A( 38 ) * B( 2 )
      C( 37 ) = C( 37 ) + A( 39 ) * B( 4 )
      C( 37 ) = C( 37 ) + A( 40 ) * B( 7 )
      C( 37 ) = C( 37 ) + A( 41 ) * B( 11 )
      C( 37 ) = C( 37 ) + A( 42 ) * B( 16 )
      C( 37 ) = C( 37 ) + A( 43 ) * B( 22 )
      C( 37 ) = C( 37 ) + A( 44 ) * B( 29 )
      C( 37 ) = C( 37 ) + A( 45 ) * B( 37 )
      C( 37 ) = C( 37 ) + A( 54 ) * B( 46 )
      C( 37 ) = C( 37 ) + A( 64 ) * B( 56 )
      C( 37 ) = C( 37 ) + A( 75 ) * B( 67 )
      C( 37 ) = C( 37 ) + A( 87 ) * B( 79 )
!
      C( 38 ) = A( 37 ) * B( 2 )
      C( 38 ) = C( 38 ) + A( 38 ) * B( 3 )
      C( 38 ) = C( 38 ) + A( 39 ) * B( 5 )
      C( 38 ) = C( 38 ) + A( 40 ) * B( 8 )
      C( 38 ) = C( 38 ) + A( 41 ) * B( 12 )
      C( 38 ) = C( 38 ) + A( 42 ) * B( 17 )
      C( 38 ) = C( 38 ) + A( 43 ) * B( 23 )
      C( 38 ) = C( 38 ) + A( 44 ) * B( 30 )
      C( 38 ) = C( 38 ) + A( 45 ) * B( 38 )
      C( 38 ) = C( 38 ) + A( 54 ) * B( 47 )
      C( 38 ) = C( 38 ) + A( 64 ) * B( 57 )
      C( 38 ) = C( 38 ) + A( 75 ) * B( 68 )
      C( 38 ) = C( 38 ) + A( 87 ) * B( 80 )
!
      C( 39 ) = A( 37 ) * B( 4 )
      C( 39 ) = C( 39 ) + A( 38 ) * B( 5 )
      C( 39 ) = C( 39 ) + A( 39 ) * B( 6 )
      C( 39 ) = C( 39 ) + A( 40 ) * B( 9 )
      C( 39 ) = C( 39 ) + A( 41 ) * B( 13 )
      C( 39 ) = C( 39 ) + A( 42 ) * B( 18 )
      C( 39 ) = C( 39 ) + A( 43 ) * B( 24 )
      C( 39 ) = C( 39 ) + A( 44 ) * B( 31 )
      C( 39 ) = C( 39 ) + A( 45 ) * B( 39 )
      C( 39 ) = C( 39 ) + A( 54 ) * B( 48 )
      C( 39 ) = C( 39 ) + A( 64 ) * B( 58 )
      C( 39 ) = C( 39 ) + A( 75 ) * B( 69 )
      C( 39 ) = C( 39 ) + A( 87 ) * B( 81 )
!
      C( 40 ) = A( 37 ) * B( 7 )
      C( 40 ) = C( 40 ) + A( 38 ) * B( 8 )
      C( 40 ) = C( 40 ) + A( 39 ) * B( 9 )
      C( 40 ) = C( 40 ) + A( 40 ) * B( 10 )
      C( 40 ) = C( 40 ) + A( 41 ) * B( 14 )
      C( 40 ) = C( 40 ) + A( 42 ) * B( 19 )
      C( 40 ) = C( 40 ) + A( 43 ) * B( 25 )
      C( 40 ) = C( 40 ) + A( 44 ) * B( 32 )
      C( 40 ) = C( 40 ) + A( 45 ) * B( 40 )
      C( 40 ) = C( 40 ) + A( 54 ) * B( 49 )
      C( 40 ) = C( 40 ) + A( 64 ) * B( 59 )
      C( 40 ) = C( 40 ) + A( 75 ) * B( 70 )
      C( 40 ) = C( 40 ) + A( 87 ) * B( 82 )
!
      C( 41 ) = A( 37 ) * B( 11 )
      C( 41 ) = C( 41 ) + A( 38 ) * B( 12 )
      C( 41 ) = C( 41 ) + A( 39 ) * B( 13 )
      C( 41 ) = C( 41 ) + A( 40 ) * B( 14 )
      C( 41 ) = C( 41 ) + A( 41 ) * B( 15 )
      C( 41 ) = C( 41 ) + A( 42 ) * B( 20 )
      C( 41 ) = C( 41 ) + A( 43 ) * B( 26 )
      C( 41 ) = C( 41 ) + A( 44 ) * B( 33 )
      C( 41 ) = C( 41 ) + A( 45 ) * B( 41 )
      C( 41 ) = C( 41 ) + A( 54 ) * B( 50 )
      C( 41 ) = C( 41 ) + A( 64 ) * B( 60 )
      C( 41 ) = C( 41 ) + A( 75 ) * B( 71 )
      C( 41 ) = C( 41 ) + A( 87 ) * B( 83 )
!
      C( 42 ) = A( 37 ) * B( 16 )
      C( 42 ) = C( 42 ) + A( 38 ) * B( 17 )
      C( 42 ) = C( 42 ) + A( 39 ) * B( 18 )
      C( 42 ) = C( 42 ) + A( 40 ) * B( 19 )
      C( 42 ) = C( 42 ) + A( 41 ) * B( 20 )
      C( 42 ) = C( 42 ) + A( 42 ) * B( 21 )
      C( 42 ) = C( 42 ) + A( 43 ) * B( 27 )
      C( 42 ) = C( 42 ) + A( 44 ) * B( 34 )
      C( 42 ) = C( 42 ) + A( 45 ) * B( 42 )
      C( 42 ) = C( 42 ) + A( 54 ) * B( 51 )
      C( 42 ) = C( 42 ) + A( 64 ) * B( 61 )
      C( 42 ) = C( 42 ) + A( 75 ) * B( 72 )
      C( 42 ) = C( 42 ) + A( 87 ) * B( 84 )
!
      C( 43 ) = A( 37 ) * B( 22 )
      C( 43 ) = C( 43 ) + A( 38 ) * B( 23 )
      C( 43 ) = C( 43 ) + A( 39 ) * B( 24 )
      C( 43 ) = C( 43 ) + A( 40 ) * B( 25 )
      C( 43 ) = C( 43 ) + A( 41 ) * B( 26 )
      C( 43 ) = C( 43 ) + A( 42 ) * B( 27 )
      C( 43 ) = C( 43 ) + A( 43 ) * B( 28 )
      C( 43 ) = C( 43 ) + A( 44 ) * B( 35 )
      C( 43 ) = C( 43 ) + A( 45 ) * B( 43 )
      C( 43 ) = C( 43 ) + A( 54 ) * B( 52 )
      C( 43 ) = C( 43 ) + A( 64 ) * B( 62 )
      C( 43 ) = C( 43 ) + A( 75 ) * B( 73 )
      C( 43 ) = C( 43 ) + A( 87 ) * B( 85 )
!
      C( 44 ) = A( 37 ) * B( 29 )
      C( 44 ) = C( 44 ) + A( 38 ) * B( 30 )
      C( 44 ) = C( 44 ) + A( 39 ) * B( 31 )
      C( 44 ) = C( 44 ) + A( 40 ) * B( 32 )
      C( 44 ) = C( 44 ) + A( 41 ) * B( 33 )
      C( 44 ) = C( 44 ) + A( 42 ) * B( 34 )
      C( 44 ) = C( 44 ) + A( 43 ) * B( 35 )
      C( 44 ) = C( 44 ) + A( 44 ) * B( 36 )
      C( 44 ) = C( 44 ) + A( 45 ) * B( 44 )
      C( 44 ) = C( 44 ) + A( 54 ) * B( 53 )
      C( 44 ) = C( 44 ) + A( 64 ) * B( 63 )
      C( 44 ) = C( 44 ) + A( 75 ) * B( 74 )
      C( 44 ) = C( 44 ) + A( 87 ) * B( 86 )
!
      C( 45 ) = A( 37 ) * B( 37 )
      C( 45 ) = C( 45 ) + A( 38 ) * B( 38 )
      C( 45 ) = C( 45 ) + A( 39 ) * B( 39 )
      C( 45 ) = C( 45 ) + A( 40 ) * B( 40 )
      C( 45 ) = C( 45 ) + A( 41 ) * B( 41 )
      C( 45 ) = C( 45 ) + A( 42 ) * B( 42 )
      C( 45 ) = C( 45 ) + A( 43 ) * B( 43 )
      C( 45 ) = C( 45 ) + A( 44 ) * B( 44 )
      C( 45 ) = C( 45 ) + A( 45 ) * B( 45 )
      C( 45 ) = C( 45 ) + A( 54 ) * B( 54 )
      C( 45 ) = C( 45 ) + A( 64 ) * B( 64 )
      C( 45 ) = C( 45 ) + A( 75 ) * B( 75 )
      C( 45 ) = C( 45 ) + A( 87 ) * B( 87 )
!
      C( 46 ) = A( 46 ) * B( 1 )
      C( 46 ) = C( 46 ) + A( 47 ) * B( 2 )
      C( 46 ) = C( 46 ) + A( 48 ) * B( 4 )
      C( 46 ) = C( 46 ) + A( 49 ) * B( 7 )
      C( 46 ) = C( 46 ) + A( 50 ) * B( 11 )
      C( 46 ) = C( 46 ) + A( 51 ) * B( 16 )
      C( 46 ) = C( 46 ) + A( 52 ) * B( 22 )
      C( 46 ) = C( 46 ) + A( 53 ) * B( 29 )
      C( 46 ) = C( 46 ) + A( 54 ) * B( 37 )
      C( 46 ) = C( 46 ) + A( 55 ) * B( 46 )
      C( 46 ) = C( 46 ) + A( 65 ) * B( 56 )
      C( 46 ) = C( 46 ) + A( 76 ) * B( 67 )
      C( 46 ) = C( 46 ) + A( 88 ) * B( 79 )
!
      C( 47 ) = A( 46 ) * B( 2 )
      C( 47 ) = C( 47 ) + A( 47 ) * B( 3 )
      C( 47 ) = C( 47 ) + A( 48 ) * B( 5 )
      C( 47 ) = C( 47 ) + A( 49 ) * B( 8 )
      C( 47 ) = C( 47 ) + A( 50 ) * B( 12 )
      C( 47 ) = C( 47 ) + A( 51 ) * B( 17 )
      C( 47 ) = C( 47 ) + A( 52 ) * B( 23 )
      C( 47 ) = C( 47 ) + A( 53 ) * B( 30 )
      C( 47 ) = C( 47 ) + A( 54 ) * B( 38 )
      C( 47 ) = C( 47 ) + A( 55 ) * B( 47 )
      C( 47 ) = C( 47 ) + A( 65 ) * B( 57 )
      C( 47 ) = C( 47 ) + A( 76 ) * B( 68 )
      C( 47 ) = C( 47 ) + A( 88 ) * B( 80 )
!
      C( 48 ) = A( 46 ) * B( 4 )
      C( 48 ) = C( 48 ) + A( 47 ) * B( 5 )
      C( 48 ) = C( 48 ) + A( 48 ) * B( 6 )
      C( 48 ) = C( 48 ) + A( 49 ) * B( 9 )
      C( 48 ) = C( 48 ) + A( 50 ) * B( 13 )
      C( 48 ) = C( 48 ) + A( 51 ) * B( 18 )
      C( 48 ) = C( 48 ) + A( 52 ) * B( 24 )
      C( 48 ) = C( 48 ) + A( 53 ) * B( 31 )
      C( 48 ) = C( 48 ) + A( 54 ) * B( 39 )
      C( 48 ) = C( 48 ) + A( 55 ) * B( 48 )
      C( 48 ) = C( 48 ) + A( 65 ) * B( 58 )
      C( 48 ) = C( 48 ) + A( 76 ) * B( 69 )
      C( 48 ) = C( 48 ) + A( 88 ) * B( 81 )
!
      C( 49 ) = A( 46 ) * B( 7 )
      C( 49 ) = C( 49 ) + A( 47 ) * B( 8 )
      C( 49 ) = C( 49 ) + A( 48 ) * B( 9 )
      C( 49 ) = C( 49 ) + A( 49 ) * B( 10 )
      C( 49 ) = C( 49 ) + A( 50 ) * B( 14 )
      C( 49 ) = C( 49 ) + A( 51 ) * B( 19 )
      C( 49 ) = C( 49 ) + A( 52 ) * B( 25 )
      C( 49 ) = C( 49 ) + A( 53 ) * B( 32 )
      C( 49 ) = C( 49 ) + A( 54 ) * B( 40 )
      C( 49 ) = C( 49 ) + A( 55 ) * B( 49 )
      C( 49 ) = C( 49 ) + A( 65 ) * B( 59 )
      C( 49 ) = C( 49 ) + A( 76 ) * B( 70 )
      C( 49 ) = C( 49 ) + A( 88 ) * B( 82 )
!
      C( 50 ) = A( 46 ) * B( 11 )
      C( 50 ) = C( 50 ) + A( 47 ) * B( 12 )
      C( 50 ) = C( 50 ) + A( 48 ) * B( 13 )
      C( 50 ) = C( 50 ) + A( 49 ) * B( 14 )
      C( 50 ) = C( 50 ) + A( 50 ) * B( 15 )
      C( 50 ) = C( 50 ) + A( 51 ) * B( 20 )
      C( 50 ) = C( 50 ) + A( 52 ) * B( 26 )
      C( 50 ) = C( 50 ) + A( 53 ) * B( 33 )
      C( 50 ) = C( 50 ) + A( 54 ) * B( 41 )
      C( 50 ) = C( 50 ) + A( 55 ) * B( 50 )
      C( 50 ) = C( 50 ) + A( 65 ) * B( 60 )
      C( 50 ) = C( 50 ) + A( 76 ) * B( 71 )
      C( 50 ) = C( 50 ) + A( 88 ) * B( 83 )
!
      C( 51 ) = A( 46 ) * B( 16 )
      C( 51 ) = C( 51 ) + A( 47 ) * B( 17 )
      C( 51 ) = C( 51 ) + A( 48 ) * B( 18 )
      C( 51 ) = C( 51 ) + A( 49 ) * B( 19 )
      C( 51 ) = C( 51 ) + A( 50 ) * B( 20 )
      C( 51 ) = C( 51 ) + A( 51 ) * B( 21 )
      C( 51 ) = C( 51 ) + A( 52 ) * B( 27 )
      C( 51 ) = C( 51 ) + A( 53 ) * B( 34 )
      C( 51 ) = C( 51 ) + A( 54 ) * B( 42 )
      C( 51 ) = C( 51 ) + A( 55 ) * B( 51 )
      C( 51 ) = C( 51 ) + A( 65 ) * B( 61 )
      C( 51 ) = C( 51 ) + A( 76 ) * B( 72 )
      C( 51 ) = C( 51 ) + A( 88 ) * B( 84 )
!
      C( 52 ) = A( 46 ) * B( 22 )
      C( 52 ) = C( 52 ) + A( 47 ) * B( 23 )
      C( 52 ) = C( 52 ) + A( 48 ) * B( 24 )
      C( 52 ) = C( 52 ) + A( 49 ) * B( 25 )
      C( 52 ) = C( 52 ) + A( 50 ) * B( 26 )
      C( 52 ) = C( 52 ) + A( 51 ) * B( 27 )
      C( 52 ) = C( 52 ) + A( 52 ) * B( 28 )
      C( 52 ) = C( 52 ) + A( 53 ) * B( 35 )
      C( 52 ) = C( 52 ) + A( 54 ) * B( 43 )
      C( 52 ) = C( 52 ) + A( 55 ) * B( 52 )
      C( 52 ) = C( 52 ) + A( 65 ) * B( 62 )
      C( 52 ) = C( 52 ) + A( 76 ) * B( 73 )
      C( 52 ) = C( 52 ) + A( 88 ) * B( 85 )
!
      C( 53 ) = A( 46 ) * B( 29 )
      C( 53 ) = C( 53 ) + A( 47 ) * B( 30 )
      C( 53 ) = C( 53 ) + A( 48 ) * B( 31 )
      C( 53 ) = C( 53 ) + A( 49 ) * B( 32 )
      C( 53 ) = C( 53 ) + A( 50 ) * B( 33 )
      C( 53 ) = C( 53 ) + A( 51 ) * B( 34 )
      C( 53 ) = C( 53 ) + A( 52 ) * B( 35 )
      C( 53 ) = C( 53 ) + A( 53 ) * B( 36 )
      C( 53 ) = C( 53 ) + A( 54 ) * B( 44 )
      C( 53 ) = C( 53 ) + A( 55 ) * B( 53 )
      C( 53 ) = C( 53 ) + A( 65 ) * B( 63 )
      C( 53 ) = C( 53 ) + A( 76 ) * B( 74 )
      C( 53 ) = C( 53 ) + A( 88 ) * B( 86 )
!
      C( 54 ) = A( 46 ) * B( 37 )
      C( 54 ) = C( 54 ) + A( 47 ) * B( 38 )
      C( 54 ) = C( 54 ) + A( 48 ) * B( 39 )
      C( 54 ) = C( 54 ) + A( 49 ) * B( 40 )
      C( 54 ) = C( 54 ) + A( 50 ) * B( 41 )
      C( 54 ) = C( 54 ) + A( 51 ) * B( 42 )
      C( 54 ) = C( 54 ) + A( 52 ) * B( 43 )
      C( 54 ) = C( 54 ) + A( 53 ) * B( 44 )
      C( 54 ) = C( 54 ) + A( 54 ) * B( 45 )
      C( 54 ) = C( 54 ) + A( 55 ) * B( 54 )
      C( 54 ) = C( 54 ) + A( 65 ) * B( 64 )
      C( 54 ) = C( 54 ) + A( 76 ) * B( 75 )
      C( 54 ) = C( 54 ) + A( 88 ) * B( 87 )
!
      C( 55 ) = A( 46 ) * B( 46 )
      C( 55 ) = C( 55 ) + A( 47 ) * B( 47 )
      C( 55 ) = C( 55 ) + A( 48 ) * B( 48 )
      C( 55 ) = C( 55 ) + A( 49 ) * B( 49 )
      C( 55 ) = C( 55 ) + A( 50 ) * B( 50 )
      C( 55 ) = C( 55 ) + A( 51 ) * B( 51 )
      C( 55 ) = C( 55 ) + A( 52 ) * B( 52 )
      C( 55 ) = C( 55 ) + A( 53 ) * B( 53 )
      C( 55 ) = C( 55 ) + A( 54 ) * B( 54 )
      C( 55 ) = C( 55 ) + A( 55 ) * B( 55 )
      C( 55 ) = C( 55 ) + A( 65 ) * B( 65 )
      C( 55 ) = C( 55 ) + A( 76 ) * B( 76 )
      C( 55 ) = C( 55 ) + A( 88 ) * B( 88 )
!
      C( 56 ) = A( 56 ) * B( 1 )
      C( 56 ) = C( 56 ) + A( 57 ) * B( 2 )
      C( 56 ) = C( 56 ) + A( 58 ) * B( 4 )
      C( 56 ) = C( 56 ) + A( 59 ) * B( 7 )
      C( 56 ) = C( 56 ) + A( 60 ) * B( 11 )
      C( 56 ) = C( 56 ) + A( 61 ) * B( 16 )
      C( 56 ) = C( 56 ) + A( 62 ) * B( 22 )
      C( 56 ) = C( 56 ) + A( 63 ) * B( 29 )
      C( 56 ) = C( 56 ) + A( 64 ) * B( 37 )
      C( 56 ) = C( 56 ) + A( 65 ) * B( 46 )
      C( 56 ) = C( 56 ) + A( 66 ) * B( 56 )
      C( 56 ) = C( 56 ) + A( 77 ) * B( 67 )
      C( 56 ) = C( 56 ) + A( 89 ) * B( 79 )
!
      C( 57 ) = A( 56 ) * B( 2 )
      C( 57 ) = C( 57 ) + A( 57 ) * B( 3 )
      C( 57 ) = C( 57 ) + A( 58 ) * B( 5 )
      C( 57 ) = C( 57 ) + A( 59 ) * B( 8 )
      C( 57 ) = C( 57 ) + A( 60 ) * B( 12 )
      C( 57 ) = C( 57 ) + A( 61 ) * B( 17 )
      C( 57 ) = C( 57 ) + A( 62 ) * B( 23 )
      C( 57 ) = C( 57 ) + A( 63 ) * B( 30 )
      C( 57 ) = C( 57 ) + A( 64 ) * B( 38 )
      C( 57 ) = C( 57 ) + A( 65 ) * B( 47 )
      C( 57 ) = C( 57 ) + A( 66 ) * B( 57 )
      C( 57 ) = C( 57 ) + A( 77 ) * B( 68 )
      C( 57 ) = C( 57 ) + A( 89 ) * B( 80 )
!
      C( 58 ) = A( 56 ) * B( 4 )
      C( 58 ) = C( 58 ) + A( 57 ) * B( 5 )
      C( 58 ) = C( 58 ) + A( 58 ) * B( 6 )
      C( 58 ) = C( 58 ) + A( 59 ) * B( 9 )
      C( 58 ) = C( 58 ) + A( 60 ) * B( 13 )
      C( 58 ) = C( 58 ) + A( 61 ) * B( 18 )
      C( 58 ) = C( 58 ) + A( 62 ) * B( 24 )
      C( 58 ) = C( 58 ) + A( 63 ) * B( 31 )
      C( 58 ) = C( 58 ) + A( 64 ) * B( 39 )
      C( 58 ) = C( 58 ) + A( 65 ) * B( 48 )
      C( 58 ) = C( 58 ) + A( 66 ) * B( 58 )
      C( 58 ) = C( 58 ) + A( 77 ) * B( 69 )
      C( 58 ) = C( 58 ) + A( 89 ) * B( 81 )
!
      C( 59 ) = A( 56 ) * B( 7 )
      C( 59 ) = C( 59 ) + A( 57 ) * B( 8 )
      C( 59 ) = C( 59 ) + A( 58 ) * B( 9 )
      C( 59 ) = C( 59 ) + A( 59 ) * B( 10 )
      C( 59 ) = C( 59 ) + A( 60 ) * B( 14 )
      C( 59 ) = C( 59 ) + A( 61 ) * B( 19 )
      C( 59 ) = C( 59 ) + A( 62 ) * B( 25 )
      C( 59 ) = C( 59 ) + A( 63 ) * B( 32 )
      C( 59 ) = C( 59 ) + A( 64 ) * B( 40 )
      C( 59 ) = C( 59 ) + A( 65 ) * B( 49 )
      C( 59 ) = C( 59 ) + A( 66 ) * B( 59 )
      C( 59 ) = C( 59 ) + A( 77 ) * B( 70 )
      C( 59 ) = C( 59 ) + A( 89 ) * B( 82 )
!
      C( 60 ) = A( 56 ) * B( 11 )
      C( 60 ) = C( 60 ) + A( 57 ) * B( 12 )
      C( 60 ) = C( 60 ) + A( 58 ) * B( 13 )
      C( 60 ) = C( 60 ) + A( 59 ) * B( 14 )
      C( 60 ) = C( 60 ) + A( 60 ) * B( 15 )
      C( 60 ) = C( 60 ) + A( 61 ) * B( 20 )
      C( 60 ) = C( 60 ) + A( 62 ) * B( 26 )
      C( 60 ) = C( 60 ) + A( 63 ) * B( 33 )
      C( 60 ) = C( 60 ) + A( 64 ) * B( 41 )
      C( 60 ) = C( 60 ) + A( 65 ) * B( 50 )
      C( 60 ) = C( 60 ) + A( 66 ) * B( 60 )
      C( 60 ) = C( 60 ) + A( 77 ) * B( 71 )
      C( 60 ) = C( 60 ) + A( 89 ) * B( 83 )
!
      C( 61 ) = A( 56 ) * B( 16 )
      C( 61 ) = C( 61 ) + A( 57 ) * B( 17 )
      C( 61 ) = C( 61 ) + A( 58 ) * B( 18 )
      C( 61 ) = C( 61 ) + A( 59 ) * B( 19 )
      C( 61 ) = C( 61 ) + A( 60 ) * B( 20 )
      C( 61 ) = C( 61 ) + A( 61 ) * B( 21 )
      C( 61 ) = C( 61 ) + A( 62 ) * B( 27 )
      C( 61 ) = C( 61 ) + A( 63 ) * B( 34 )
      C( 61 ) = C( 61 ) + A( 64 ) * B( 42 )
      C( 61 ) = C( 61 ) + A( 65 ) * B( 51 )
      C( 61 ) = C( 61 ) + A( 66 ) * B( 61 )
      C( 61 ) = C( 61 ) + A( 77 ) * B( 72 )
      C( 61 ) = C( 61 ) + A( 89 ) * B( 84 )
!
      C( 62 ) = A( 56 ) * B( 22 )
      C( 62 ) = C( 62 ) + A( 57 ) * B( 23 )
      C( 62 ) = C( 62 ) + A( 58 ) * B( 24 )
      C( 62 ) = C( 62 ) + A( 59 ) * B( 25 )
      C( 62 ) = C( 62 ) + A( 60 ) * B( 26 )
      C( 62 ) = C( 62 ) + A( 61 ) * B( 27 )
      C( 62 ) = C( 62 ) + A( 62 ) * B( 28 )
      C( 62 ) = C( 62 ) + A( 63 ) * B( 35 )
      C( 62 ) = C( 62 ) + A( 64 ) * B( 43 )
      C( 62 ) = C( 62 ) + A( 65 ) * B( 52 )
      C( 62 ) = C( 62 ) + A( 66 ) * B( 62 )
      C( 62 ) = C( 62 ) + A( 77 ) * B( 73 )
      C( 62 ) = C( 62 ) + A( 89 ) * B( 85 )
!
      C( 63 ) = A( 56 ) * B( 29 )
      C( 63 ) = C( 63 ) + A( 57 ) * B( 30 )
      C( 63 ) = C( 63 ) + A( 58 ) * B( 31 )
      C( 63 ) = C( 63 ) + A( 59 ) * B( 32 )
      C( 63 ) = C( 63 ) + A( 60 ) * B( 33 )
      C( 63 ) = C( 63 ) + A( 61 ) * B( 34 )
      C( 63 ) = C( 63 ) + A( 62 ) * B( 35 )
      C( 63 ) = C( 63 ) + A( 63 ) * B( 36 )
      C( 63 ) = C( 63 ) + A( 64 ) * B( 44 )
      C( 63 ) = C( 63 ) + A( 65 ) * B( 53 )
      C( 63 ) = C( 63 ) + A( 66 ) * B( 63 )
      C( 63 ) = C( 63 ) + A( 77 ) * B( 74 )
      C( 63 ) = C( 63 ) + A( 89 ) * B( 86 )
!
      C( 64 ) = A( 56 ) * B( 37 )
      C( 64 ) = C( 64 ) + A( 57 ) * B( 38 )
      C( 64 ) = C( 64 ) + A( 58 ) * B( 39 )
      C( 64 ) = C( 64 ) + A( 59 ) * B( 40 )
      C( 64 ) = C( 64 ) + A( 60 ) * B( 41 )
      C( 64 ) = C( 64 ) + A( 61 ) * B( 42 )
      C( 64 ) = C( 64 ) + A( 62 ) * B( 43 )
      C( 64 ) = C( 64 ) + A( 63 ) * B( 44 )
      C( 64 ) = C( 64 ) + A( 64 ) * B( 45 )
      C( 64 ) = C( 64 ) + A( 65 ) * B( 54 )
      C( 64 ) = C( 64 ) + A( 66 ) * B( 64 )
      C( 64 ) = C( 64 ) + A( 77 ) * B( 75 )
      C( 64 ) = C( 64 ) + A( 89 ) * B( 87 )
!
      C( 65 ) = A( 56 ) * B( 46 )
      C( 65 ) = C( 65 ) + A( 57 ) * B( 47 )
      C( 65 ) = C( 65 ) + A( 58 ) * B( 48 )
      C( 65 ) = C( 65 ) + A( 59 ) * B( 49 )
      C( 65 ) = C( 65 ) + A( 60 ) * B( 50 )
      C( 65 ) = C( 65 ) + A( 61 ) * B( 51 )
      C( 65 ) = C( 65 ) + A( 62 ) * B( 52 )
      C( 65 ) = C( 65 ) + A( 63 ) * B( 53 )
      C( 65 ) = C( 65 ) + A( 64 ) * B( 54 )
      C( 65 ) = C( 65 ) + A( 65 ) * B( 55 )
      C( 65 ) = C( 65 ) + A( 66 ) * B( 65 )
      C( 65 ) = C( 65 ) + A( 77 ) * B( 76 )
      C( 65 ) = C( 65 ) + A( 89 ) * B( 88 )
!
      C( 66 ) = A( 56 ) * B( 56 )
      C( 66 ) = C( 66 ) + A( 57 ) * B( 57 )
      C( 66 ) = C( 66 ) + A( 58 ) * B( 58 )
      C( 66 ) = C( 66 ) + A( 59 ) * B( 59 )
      C( 66 ) = C( 66 ) + A( 60 ) * B( 60 )
      C( 66 ) = C( 66 ) + A( 61 ) * B( 61 )
      C( 66 ) = C( 66 ) + A( 62 ) * B( 62 )
      C( 66 ) = C( 66 ) + A( 63 ) * B( 63 )
      C( 66 ) = C( 66 ) + A( 64 ) * B( 64 )
      C( 66 ) = C( 66 ) + A( 65 ) * B( 65 )
      C( 66 ) = C( 66 ) + A( 66 ) * B( 66 )
      C( 66 ) = C( 66 ) + A( 77 ) * B( 77 )
      C( 66 ) = C( 66 ) + A( 89 ) * B( 89 )
!
      C( 67 ) = A( 67 ) * B( 1 )
      C( 67 ) = C( 67 ) + A( 68 ) * B( 2 )
      C( 67 ) = C( 67 ) + A( 69 ) * B( 4 )
      C( 67 ) = C( 67 ) + A( 70 ) * B( 7 )
      C( 67 ) = C( 67 ) + A( 71 ) * B( 11 )
      C( 67 ) = C( 67 ) + A( 72 ) * B( 16 )
      C( 67 ) = C( 67 ) + A( 73 ) * B( 22 )
      C( 67 ) = C( 67 ) + A( 74 ) * B( 29 )
      C( 67 ) = C( 67 ) + A( 75 ) * B( 37 )
      C( 67 ) = C( 67 ) + A( 76 ) * B( 46 )
      C( 67 ) = C( 67 ) + A( 77 ) * B( 56 )
      C( 67 ) = C( 67 ) + A( 78 ) * B( 67 )
      C( 67 ) = C( 67 ) + A( 90 ) * B( 79 )
!
      C( 68 ) = A( 67 ) * B( 2 )
      C( 68 ) = C( 68 ) + A( 68 ) * B( 3 )
      C( 68 ) = C( 68 ) + A( 69 ) * B( 5 )
      C( 68 ) = C( 68 ) + A( 70 ) * B( 8 )
      C( 68 ) = C( 68 ) + A( 71 ) * B( 12 )
      C( 68 ) = C( 68 ) + A( 72 ) * B( 17 )
      C( 68 ) = C( 68 ) + A( 73 ) * B( 23 )
      C( 68 ) = C( 68 ) + A( 74 ) * B( 30 )
      C( 68 ) = C( 68 ) + A( 75 ) * B( 38 )
      C( 68 ) = C( 68 ) + A( 76 ) * B( 47 )
      C( 68 ) = C( 68 ) + A( 77 ) * B( 57 )
      C( 68 ) = C( 68 ) + A( 78 ) * B( 68 )
      C( 68 ) = C( 68 ) + A( 90 ) * B( 80 )
!
      C( 69 ) = A( 67 ) * B( 4 )
      C( 69 ) = C( 69 ) + A( 68 ) * B( 5 )
      C( 69 ) = C( 69 ) + A( 69 ) * B( 6 )
      C( 69 ) = C( 69 ) + A( 70 ) * B( 9 )
      C( 69 ) = C( 69 ) + A( 71 ) * B( 13 )
      C( 69 ) = C( 69 ) + A( 72 ) * B( 18 )
      C( 69 ) = C( 69 ) + A( 73 ) * B( 24 )
      C( 69 ) = C( 69 ) + A( 74 ) * B( 31 )
      C( 69 ) = C( 69 ) + A( 75 ) * B( 39 )
      C( 69 ) = C( 69 ) + A( 76 ) * B( 48 )
      C( 69 ) = C( 69 ) + A( 77 ) * B( 58 )
      C( 69 ) = C( 69 ) + A( 78 ) * B( 69 )
      C( 69 ) = C( 69 ) + A( 90 ) * B( 81 )
!
      C( 70 ) = A( 67 ) * B( 7 )
      C( 70 ) = C( 70 ) + A( 68 ) * B( 8 )
      C( 70 ) = C( 70 ) + A( 69 ) * B( 9 )
      C( 70 ) = C( 70 ) + A( 70 ) * B( 10 )
      C( 70 ) = C( 70 ) + A( 71 ) * B( 14 )
      C( 70 ) = C( 70 ) + A( 72 ) * B( 19 )
      C( 70 ) = C( 70 ) + A( 73 ) * B( 25 )
      C( 70 ) = C( 70 ) + A( 74 ) * B( 32 )
      C( 70 ) = C( 70 ) + A( 75 ) * B( 40 )
      C( 70 ) = C( 70 ) + A( 76 ) * B( 49 )
      C( 70 ) = C( 70 ) + A( 77 ) * B( 59 )
      C( 70 ) = C( 70 ) + A( 78 ) * B( 70 )
      C( 70 ) = C( 70 ) + A( 90 ) * B( 82 )
!
      C( 71 ) = A( 67 ) * B( 11 )
      C( 71 ) = C( 71 ) + A( 68 ) * B( 12 )
      C( 71 ) = C( 71 ) + A( 69 ) * B( 13 )
      C( 71 ) = C( 71 ) + A( 70 ) * B( 14 )
      C( 71 ) = C( 71 ) + A( 71 ) * B( 15 )
      C( 71 ) = C( 71 ) + A( 72 ) * B( 20 )
      C( 71 ) = C( 71 ) + A( 73 ) * B( 26 )
      C( 71 ) = C( 71 ) + A( 74 ) * B( 33 )
      C( 71 ) = C( 71 ) + A( 75 ) * B( 41 )
      C( 71 ) = C( 71 ) + A( 76 ) * B( 50 )
      C( 71 ) = C( 71 ) + A( 77 ) * B( 60 )
      C( 71 ) = C( 71 ) + A( 78 ) * B( 71 )
      C( 71 ) = C( 71 ) + A( 90 ) * B( 83 )
!
      C( 72 ) = A( 67 ) * B( 16 )
      C( 72 ) = C( 72 ) + A( 68 ) * B( 17 )
      C( 72 ) = C( 72 ) + A( 69 ) * B( 18 )
      C( 72 ) = C( 72 ) + A( 70 ) * B( 19 )
      C( 72 ) = C( 72 ) + A( 71 ) * B( 20 )
      C( 72 ) = C( 72 ) + A( 72 ) * B( 21 )
      C( 72 ) = C( 72 ) + A( 73 ) * B( 27 )
      C( 72 ) = C( 72 ) + A( 74 ) * B( 34 )
      C( 72 ) = C( 72 ) + A( 75 ) * B( 42 )
      C( 72 ) = C( 72 ) + A( 76 ) * B( 51 )
      C( 72 ) = C( 72 ) + A( 77 ) * B( 61 )
      C( 72 ) = C( 72 ) + A( 78 ) * B( 72 )
      C( 72 ) = C( 72 ) + A( 90 ) * B( 84 )
!
      C( 73 ) = A( 67 ) * B( 22 )
      C( 73 ) = C( 73 ) + A( 68 ) * B( 23 )
      C( 73 ) = C( 73 ) + A( 69 ) * B( 24 )
      C( 73 ) = C( 73 ) + A( 70 ) * B( 25 )
      C( 73 ) = C( 73 ) + A( 71 ) * B( 26 )
      C( 73 ) = C( 73 ) + A( 72 ) * B( 27 )
      C( 73 ) = C( 73 ) + A( 73 ) * B( 28 )
      C( 73 ) = C( 73 ) + A( 74 ) * B( 35 )
      C( 73 ) = C( 73 ) + A( 75 ) * B( 43 )
      C( 73 ) = C( 73 ) + A( 76 ) * B( 52 )
      C( 73 ) = C( 73 ) + A( 77 ) * B( 62 )
      C( 73 ) = C( 73 ) + A( 78 ) * B( 73 )
      C( 73 ) = C( 73 ) + A( 90 ) * B( 85 )
!
      C( 74 ) = A( 67 ) * B( 29 )
      C( 74 ) = C( 74 ) + A( 68 ) * B( 30 )
      C( 74 ) = C( 74 ) + A( 69 ) * B( 31 )
      C( 74 ) = C( 74 ) + A( 70 ) * B( 32 )
      C( 74 ) = C( 74 ) + A( 71 ) * B( 33 )
      C( 74 ) = C( 74 ) + A( 72 ) * B( 34 )
      C( 74 ) = C( 74 ) + A( 73 ) * B( 35 )
      C( 74 ) = C( 74 ) + A( 74 ) * B( 36 )
      C( 74 ) = C( 74 ) + A( 75 ) * B( 44 )
      C( 74 ) = C( 74 ) + A( 76 ) * B( 53 )
      C( 74 ) = C( 74 ) + A( 77 ) * B( 63 )
      C( 74 ) = C( 74 ) + A( 78 ) * B( 74 )
      C( 74 ) = C( 74 ) + A( 90 ) * B( 86 )
!
      C( 75 ) = A( 67 ) * B( 37 )
      C( 75 ) = C( 75 ) + A( 68 ) * B( 38 )
      C( 75 ) = C( 75 ) + A( 69 ) * B( 39 )
      C( 75 ) = C( 75 ) + A( 70 ) * B( 40 )
      C( 75 ) = C( 75 ) + A( 71 ) * B( 41 )
      C( 75 ) = C( 75 ) + A( 72 ) * B( 42 )
      C( 75 ) = C( 75 ) + A( 73 ) * B( 43 )
      C( 75 ) = C( 75 ) + A( 74 ) * B( 44 )
      C( 75 ) = C( 75 ) + A( 75 ) * B( 45 )
      C( 75 ) = C( 75 ) + A( 76 ) * B( 54 )
      C( 75 ) = C( 75 ) + A( 77 ) * B( 64 )
      C( 75 ) = C( 75 ) + A( 78 ) * B( 75 )
      C( 75 ) = C( 75 ) + A( 90 ) * B( 87 )
!
      C( 76 ) = A( 67 ) * B( 46 )
      C( 76 ) = C( 76 ) + A( 68 ) * B( 47 )
      C( 76 ) = C( 76 ) + A( 69 ) * B( 48 )
      C( 76 ) = C( 76 ) + A( 70 ) * B( 49 )
      C( 76 ) = C( 76 ) + A( 71 ) * B( 50 )
      C( 76 ) = C( 76 ) + A( 72 ) * B( 51 )
      C( 76 ) = C( 76 ) + A( 73 ) * B( 52 )
      C( 76 ) = C( 76 ) + A( 74 ) * B( 53 )
      C( 76 ) = C( 76 ) + A( 75 ) * B( 54 )
      C( 76 ) = C( 76 ) + A( 76 ) * B( 55 )
      C( 76 ) = C( 76 ) + A( 77 ) * B( 65 )
      C( 76 ) = C( 76 ) + A( 78 ) * B( 76 )
      C( 76 ) = C( 76 ) + A( 90 ) * B( 88 )
!
      C( 77 ) = A( 67 ) * B( 56 )
      C( 77 ) = C( 77 ) + A( 68 ) * B( 57 )
      C( 77 ) = C( 77 ) + A( 69 ) * B( 58 )
      C( 77 ) = C( 77 ) + A( 70 ) * B( 59 )
      C( 77 ) = C( 77 ) + A( 71 ) * B( 60 )
      C( 77 ) = C( 77 ) + A( 72 ) * B( 61 )
      C( 77 ) = C( 77 ) + A( 73 ) * B( 62 )
      C( 77 ) = C( 77 ) + A( 74 ) * B( 63 )
      C( 77 ) = C( 77 ) + A( 75 ) * B( 64 )
      C( 77 ) = C( 77 ) + A( 76 ) * B( 65 )
      C( 77 ) = C( 77 ) + A( 77 ) * B( 66 )
      C( 77 ) = C( 77 ) + A( 78 ) * B( 77 )
      C( 77 ) = C( 77 ) + A( 90 ) * B( 89 )
!
      C( 78 ) = A( 67 ) * B( 67 )
      C( 78 ) = C( 78 ) + A( 68 ) * B( 68 )
      C( 78 ) = C( 78 ) + A( 69 ) * B( 69 )
      C( 78 ) = C( 78 ) + A( 70 ) * B( 70 )
      C( 78 ) = C( 78 ) + A( 71 ) * B( 71 )
      C( 78 ) = C( 78 ) + A( 72 ) * B( 72 )
      C( 78 ) = C( 78 ) + A( 73 ) * B( 73 )
      C( 78 ) = C( 78 ) + A( 74 ) * B( 74 )
      C( 78 ) = C( 78 ) + A( 75 ) * B( 75 )
      C( 78 ) = C( 78 ) + A( 76 ) * B( 76 )
      C( 78 ) = C( 78 ) + A( 77 ) * B( 77 )
      C( 78 ) = C( 78 ) + A( 78 ) * B( 78 )
      C( 78 ) = C( 78 ) + A( 90 ) * B( 90 )
!
      C( 79 ) = A( 79 ) * B( 1 )
      C( 79 ) = C( 79 ) + A( 80 ) * B( 2 )
      C( 79 ) = C( 79 ) + A( 81 ) * B( 4 )
      C( 79 ) = C( 79 ) + A( 82 ) * B( 7 )
      C( 79 ) = C( 79 ) + A( 83 ) * B( 11 )
      C( 79 ) = C( 79 ) + A( 84 ) * B( 16 )
      C( 79 ) = C( 79 ) + A( 85 ) * B( 22 )
      C( 79 ) = C( 79 ) + A( 86 ) * B( 29 )
      C( 79 ) = C( 79 ) + A( 87 ) * B( 37 )
      C( 79 ) = C( 79 ) + A( 88 ) * B( 46 )
      C( 79 ) = C( 79 ) + A( 89 ) * B( 56 )
      C( 79 ) = C( 79 ) + A( 90 ) * B( 67 )
      C( 79 ) = C( 79 ) + A( 91 ) * B( 79 )
!
      C( 80 ) = A( 79 ) * B( 2 )
      C( 80 ) = C( 80 ) + A( 80 ) * B( 3 )
      C( 80 ) = C( 80 ) + A( 81 ) * B( 5 )
      C( 80 ) = C( 80 ) + A( 82 ) * B( 8 )
      C( 80 ) = C( 80 ) + A( 83 ) * B( 12 )
      C( 80 ) = C( 80 ) + A( 84 ) * B( 17 )
      C( 80 ) = C( 80 ) + A( 85 ) * B( 23 )
      C( 80 ) = C( 80 ) + A( 86 ) * B( 30 )
      C( 80 ) = C( 80 ) + A( 87 ) * B( 38 )
      C( 80 ) = C( 80 ) + A( 88 ) * B( 47 )
      C( 80 ) = C( 80 ) + A( 89 ) * B( 57 )
      C( 80 ) = C( 80 ) + A( 90 ) * B( 68 )
      C( 80 ) = C( 80 ) + A( 91 ) * B( 80 )
!
      C( 81 ) = A( 79 ) * B( 4 )
      C( 81 ) = C( 81 ) + A( 80 ) * B( 5 )
      C( 81 ) = C( 81 ) + A( 81 ) * B( 6 )
      C( 81 ) = C( 81 ) + A( 82 ) * B( 9 )
      C( 81 ) = C( 81 ) + A( 83 ) * B( 13 )
      C( 81 ) = C( 81 ) + A( 84 ) * B( 18 )
      C( 81 ) = C( 81 ) + A( 85 ) * B( 24 )
      C( 81 ) = C( 81 ) + A( 86 ) * B( 31 )
      C( 81 ) = C( 81 ) + A( 87 ) * B( 39 )
      C( 81 ) = C( 81 ) + A( 88 ) * B( 48 )
      C( 81 ) = C( 81 ) + A( 89 ) * B( 58 )
      C( 81 ) = C( 81 ) + A( 90 ) * B( 69 )
      C( 81 ) = C( 81 ) + A( 91 ) * B( 81 )
!
      C( 82 ) = A( 79 ) * B( 7 )
      C( 82 ) = C( 82 ) + A( 80 ) * B( 8 )
      C( 82 ) = C( 82 ) + A( 81 ) * B( 9 )
      C( 82 ) = C( 82 ) + A( 82 ) * B( 10 )
      C( 82 ) = C( 82 ) + A( 83 ) * B( 14 )
      C( 82 ) = C( 82 ) + A( 84 ) * B( 19 )
      C( 82 ) = C( 82 ) + A( 85 ) * B( 25 )
      C( 82 ) = C( 82 ) + A( 86 ) * B( 32 )
      C( 82 ) = C( 82 ) + A( 87 ) * B( 40 )
      C( 82 ) = C( 82 ) + A( 88 ) * B( 49 )
      C( 82 ) = C( 82 ) + A( 89 ) * B( 59 )
      C( 82 ) = C( 82 ) + A( 90 ) * B( 70 )
      C( 82 ) = C( 82 ) + A( 91 ) * B( 82 )
!
      C( 83 ) = A( 79 ) * B( 11 )
      C( 83 ) = C( 83 ) + A( 80 ) * B( 12 )
      C( 83 ) = C( 83 ) + A( 81 ) * B( 13 )
      C( 83 ) = C( 83 ) + A( 82 ) * B( 14 )
      C( 83 ) = C( 83 ) + A( 83 ) * B( 15 )
      C( 83 ) = C( 83 ) + A( 84 ) * B( 20 )
      C( 83 ) = C( 83 ) + A( 85 ) * B( 26 )
      C( 83 ) = C( 83 ) + A( 86 ) * B( 33 )
      C( 83 ) = C( 83 ) + A( 87 ) * B( 41 )
      C( 83 ) = C( 83 ) + A( 88 ) * B( 50 )
      C( 83 ) = C( 83 ) + A( 89 ) * B( 60 )
      C( 83 ) = C( 83 ) + A( 90 ) * B( 71 )
      C( 83 ) = C( 83 ) + A( 91 ) * B( 83 )
!
      C( 84 ) = A( 79 ) * B( 16 )
      C( 84 ) = C( 84 ) + A( 80 ) * B( 17 )
      C( 84 ) = C( 84 ) + A( 81 ) * B( 18 )
      C( 84 ) = C( 84 ) + A( 82 ) * B( 19 )
      C( 84 ) = C( 84 ) + A( 83 ) * B( 20 )
      C( 84 ) = C( 84 ) + A( 84 ) * B( 21 )
      C( 84 ) = C( 84 ) + A( 85 ) * B( 27 )
      C( 84 ) = C( 84 ) + A( 86 ) * B( 34 )
      C( 84 ) = C( 84 ) + A( 87 ) * B( 42 )
      C( 84 ) = C( 84 ) + A( 88 ) * B( 51 )
      C( 84 ) = C( 84 ) + A( 89 ) * B( 61 )
      C( 84 ) = C( 84 ) + A( 90 ) * B( 72 )
      C( 84 ) = C( 84 ) + A( 91 ) * B( 84 )
!
      C( 85 ) = A( 79 ) * B( 22 )
      C( 85 ) = C( 85 ) + A( 80 ) * B( 23 )
      C( 85 ) = C( 85 ) + A( 81 ) * B( 24 )
      C( 85 ) = C( 85 ) + A( 82 ) * B( 25 )
      C( 85 ) = C( 85 ) + A( 83 ) * B( 26 )
      C( 85 ) = C( 85 ) + A( 84 ) * B( 27 )
      C( 85 ) = C( 85 ) + A( 85 ) * B( 28 )
      C( 85 ) = C( 85 ) + A( 86 ) * B( 35 )
      C( 85 ) = C( 85 ) + A( 87 ) * B( 43 )
      C( 85 ) = C( 85 ) + A( 88 ) * B( 52 )
      C( 85 ) = C( 85 ) + A( 89 ) * B( 62 )
      C( 85 ) = C( 85 ) + A( 90 ) * B( 73 )
      C( 85 ) = C( 85 ) + A( 91 ) * B( 85 )
!
      C( 86 ) = A( 79 ) * B( 29 )
      C( 86 ) = C( 86 ) + A( 80 ) * B( 30 )
      C( 86 ) = C( 86 ) + A( 81 ) * B( 31 )
      C( 86 ) = C( 86 ) + A( 82 ) * B( 32 )
      C( 86 ) = C( 86 ) + A( 83 ) * B( 33 )
      C( 86 ) = C( 86 ) + A( 84 ) * B( 34 )
      C( 86 ) = C( 86 ) + A( 85 ) * B( 35 )
      C( 86 ) = C( 86 ) + A( 86 ) * B( 36 )
      C( 86 ) = C( 86 ) + A( 87 ) * B( 44 )
      C( 86 ) = C( 86 ) + A( 88 ) * B( 53 )
      C( 86 ) = C( 86 ) + A( 89 ) * B( 63 )
      C( 86 ) = C( 86 ) + A( 90 ) * B( 74 )
      C( 86 ) = C( 86 ) + A( 91 ) * B( 86 )
!
      C( 87 ) = A( 79 ) * B( 37 )
      C( 87 ) = C( 87 ) + A( 80 ) * B( 38 )
      C( 87 ) = C( 87 ) + A( 81 ) * B( 39 )
      C( 87 ) = C( 87 ) + A( 82 ) * B( 40 )
      C( 87 ) = C( 87 ) + A( 83 ) * B( 41 )
      C( 87 ) = C( 87 ) + A( 84 ) * B( 42 )
      C( 87 ) = C( 87 ) + A( 85 ) * B( 43 )
      C( 87 ) = C( 87 ) + A( 86 ) * B( 44 )
      C( 87 ) = C( 87 ) + A( 87 ) * B( 45 )
      C( 87 ) = C( 87 ) + A( 88 ) * B( 54 )
      C( 87 ) = C( 87 ) + A( 89 ) * B( 64 )
      C( 87 ) = C( 87 ) + A( 90 ) * B( 75 )
      C( 87 ) = C( 87 ) + A( 91 ) * B( 87 )
!
      C( 88 ) = A( 79 ) * B( 46 )
      C( 88 ) = C( 88 ) + A( 80 ) * B( 47 )
      C( 88 ) = C( 88 ) + A( 81 ) * B( 48 )
      C( 88 ) = C( 88 ) + A( 82 ) * B( 49 )
      C( 88 ) = C( 88 ) + A( 83 ) * B( 50 )
      C( 88 ) = C( 88 ) + A( 84 ) * B( 51 )
      C( 88 ) = C( 88 ) + A( 85 ) * B( 52 )
      C( 88 ) = C( 88 ) + A( 86 ) * B( 53 )
      C( 88 ) = C( 88 ) + A( 87 ) * B( 54 )
      C( 88 ) = C( 88 ) + A( 88 ) * B( 55 )
      C( 88 ) = C( 88 ) + A( 89 ) * B( 65 )
      C( 88 ) = C( 88 ) + A( 90 ) * B( 76 )
      C( 88 ) = C( 88 ) + A( 91 ) * B( 88 )
!
      C( 89 ) = A( 79 ) * B( 56 )
      C( 89 ) = C( 89 ) + A( 80 ) * B( 57 )
      C( 89 ) = C( 89 ) + A( 81 ) * B( 58 )
      C( 89 ) = C( 89 ) + A( 82 ) * B( 59 )
      C( 89 ) = C( 89 ) + A( 83 ) * B( 60 )
      C( 89 ) = C( 89 ) + A( 84 ) * B( 61 )
      C( 89 ) = C( 89 ) + A( 85 ) * B( 62 )
      C( 89 ) = C( 89 ) + A( 86 ) * B( 63 )
      C( 89 ) = C( 89 ) + A( 87 ) * B( 64 )
      C( 89 ) = C( 89 ) + A( 88 ) * B( 65 )
      C( 89 ) = C( 89 ) + A( 89 ) * B( 66 )
      C( 89 ) = C( 89 ) + A( 90 ) * B( 77 )
      C( 89 ) = C( 89 ) + A( 91 ) * B( 89 )
!
      C( 90 ) = A( 79 ) * B( 67 )
      C( 90 ) = C( 90 ) + A( 80 ) * B( 68 )
      C( 90 ) = C( 90 ) + A( 81 ) * B( 69 )
      C( 90 ) = C( 90 ) + A( 82 ) * B( 70 )
      C( 90 ) = C( 90 ) + A( 83 ) * B( 71 )
      C( 90 ) = C( 90 ) + A( 84 ) * B( 72 )
      C( 90 ) = C( 90 ) + A( 85 ) * B( 73 )
      C( 90 ) = C( 90 ) + A( 86 ) * B( 74 )
      C( 90 ) = C( 90 ) + A( 87 ) * B( 75 )
      C( 90 ) = C( 90 ) + A( 88 ) * B( 76 )
      C( 90 ) = C( 90 ) + A( 89 ) * B( 77 )
      C( 90 ) = C( 90 ) + A( 90 ) * B( 78 )
      C( 90 ) = C( 90 ) + A( 91 ) * B( 90 )
!
      C( 91 ) = A( 79 ) * B( 79 )
      C( 91 ) = C( 91 ) + A( 80 ) * B( 80 )
      C( 91 ) = C( 91 ) + A( 81 ) * B( 81 )
      C( 91 ) = C( 91 ) + A( 82 ) * B( 82 )
      C( 91 ) = C( 91 ) + A( 83 ) * B( 83 )
      C( 91 ) = C( 91 ) + A( 84 ) * B( 84 )
      C( 91 ) = C( 91 ) + A( 85 ) * B( 85 )
      C( 91 ) = C( 91 ) + A( 86 ) * B( 86 )
      C( 91 ) = C( 91 ) + A( 87 ) * B( 87 )
      C( 91 ) = C( 91 ) + A( 88 ) * B( 88 )
      C( 91 ) = C( 91 ) + A( 89 ) * B( 89 )
      C( 91 ) = C( 91 ) + A( 90 ) * B( 90 )
      C( 91 ) = C( 91 ) + A( 91 ) * B( 91 )
!
!
      RETURN
      END !#! SUBROUTINE MUL_MM_SS_S_13
